/* NVTV NVidia CRTC data header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Header: Data routines for the NVidia CRTC data.
 *
 */

#ifndef _DATA_NV_H
#define _DATA_NV_H

#include "tv_chip.h"
#include "data.h"

void data_init_nv (TVNvRegs *r, int portHost, int devFlags);

TVMode *data_modes_nv_bt (void);
TVMode *data_modes_nv_cx (void);
TVMode *data_modes_nv_ch1 (void);
TVMode *data_modes_nv_ph1 (void);
TVMode *data_modes_nv_ph2 (void);

extern DataCardFunc data_nv_func;

extern DataFunc data_nv_bt_func;
extern DataFunc data_nv_cx_func;
extern DataFunc data_nv_ch1_func;
extern DataFunc data_nv_ch2_func;
extern DataFunc data_nv_ph1_func;
extern DataFunc data_nv_ph2_func;

#endif /* _DATA_NV_H */
