/* NVTV Gui -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Header: The GTK graphical user interface.
 */

#ifndef _GUI_H
#define _GUI_H

#include <gtk/gtk.h>
#include "backend.h"
#include "data.h"

/* FIXME: Think about global vars */

extern TVRegs gui_regs;

extern TVSystem gui_system;
extern TVMode *gui_list_mode;
extern TVMode *gui_act_mode;

extern TVChip gui_tv_chip;

extern DataFunc *gui_func;

typedef GtkAdjustment GuiNotify;

extern GuiNotify *update_crt;
extern GuiNotify *update_chip;
extern GuiNotify *update_mode;
extern GuiNotify *changed_all;

typedef enum {
  ACCEL_FIRST  = 0,
  ACCEL_TV_ON  = 0,
  ACCEL_TV_OFF = 1,
  ACCEL_SWITCH = 2,
  ACCEL_CENTER = 3,
  ACCEL_ADJUST = 4,
  ACCEL_RESET  = 5,
  ACCEL_PRINT  = 6,
  ACCEL_LAST   = 7,
} GuiAccelIndex;

typedef struct accel_struct {
  char *label;
  char *accel;
  guint key;
  GdkModifierType mods;
} GuiAccel;

extern GuiAccel gui_accel [ACCEL_LAST];

typedef struct reg_mask {
  char *label;
  int  bits;
  int  tick;
  void *addr;
  int  size;
} GuiRegMask;

typedef struct flag_mask {
  char *label;
  int  mask;
  void *addr;
  int  size;
} GuiFlagMask;

#define PRINT_CRT_REGS	 (1 << 0)
#define PRINT_CHIP_REGS	 (1 << 1)
#define PRINT_ADJUSTED	 (1 << 2)
#define PRINT_FP_REGS	 (1 << 3)

GtkWidget* create_option_menu (GtkSignalFunc func, ...);

GtkWidget *create_arrow_button (GtkTable *table, GtkArrowType arrow_type,
  int x0, int x1, int y0, int y1);

GtkWidget *create_radio_box (int active, gboolean hor_vert, 
  GtkSignalFunc func, GSList **group, ...);

GuiNotify *create_notify (void);

GtkWidget* create_framed_label (GtkWidget *table, char *title, char *value,
  int x1, int x2, int x3, int y);

GtkLabel *gui_mask_label (GtkWidget *table, char *title, char *val, 
  int x1, int x2, int x3, int y);

void gui_mask_checkbutton (GtkWidget *table, GtkObject *changed, 
  GuiFlagMask *m, int x1, int x2, int y);

void gui_mask_entry (GtkWidget *table, GtkObject *changed, 
  GuiRegMask *m, int x1, int x2, int x3, int y);

void gui_mask_twin_entry (GtkWidget *table, GtkObject *changed, 
  GuiRegMask *m, int x1, int x2, int x3, int x4, int y);

void gui_act_mode_set (TVMode *mode);

void gui_tv_set (void);

void gui_map_cb (GtkWidget *widget, GtkAccelGroup *group);
void gui_unmap_cb (GtkWidget *widget, GtkAccelGroup *group);

void gui_print_cb (GtkButton *button, gpointer data);

void gui_reset_crt_cb (GtkWidget *widget, gpointer data);

GtkWidget *gui_regs_page (char *title, GtkAccelGroup *accel_group, 
  int print_mode, GtkObject *update, GtkSignalFunc reset_cb,
  int reg_x, int reg_y, int reg_lines, GuiRegMask *mask_reg, 
  int twin_x, int twin_y, GuiRegMask *mask_twin,
  int flag_x, int flag_y, int flag_lines, GuiFlagMask *mask_flag);

void gui_main (int argc, char *argv[], CardPtr card_list);

#endif /* _GUI_H */
