/* NVTV GUI (Conexant part) -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * The GTK graphical user interface. Conexant part.
 */

/* FIXME: Reuse bt routines ... */

#include "local.h" /* before everything else */

#include <gtk/gtk.h>

#include "gui.h"
#include "gui_bt.h"
#include "gui_cx.h"

GtkAdjustment *update_cx;

#ifndef DISABLE_TIMEOUT
static gint gui_timeout_cx_id = -1; /* status timeout */
#endif

#define FIELD(b,m) addr:&(b.m), size:sizeof(b.m)
#define FIELD_BT(m) FIELD(gui_regs.enc.cx.bt,m)
#define FIELD_CX(m) FIELD(gui_regs.enc.cx,m)

/* -------- GUI Masks -------- */

struct mask_cx_freq {
  GtkLabel *clk, *hsyn, *vsyn, *hover, *vover, *aspect;
};

struct mask_cx_freq gui_mask_cx_freq;

struct mask_status {
  GtkToggleButton *tvon, *pal, *over, *under, *pll_lock, *pll_reset, *secam;
};

struct mask_status gui_mask_cx_status;

static GuiRegMask cx_mask1_reg [] = {
  {label:"h_active:",      bits:11, tick:1, FIELD_BT(h_active)},
  {label:"h_blanki:",      bits:10, tick:1, FIELD_BT(h_blanki)},
  {label:"h_clki:",        bits:11, tick:1, FIELD_BT(h_clki)},
  {label:"h_fract:",       bits:8,  tick:1, FIELD_BT(h_fract)},
  {label:"h_blanko:",      bits:11, tick:1, FIELD_BT(h_blanko)},
  {label:"h_clko:",        bits:12, tick:1, FIELD_BT(h_clko)},
  {label:"sync_amp:",      bits:8,  tick:1, FIELD_BT(sync_amp)},
  {label:"bst_amp:",       bits:8,  tick:1, FIELD_BT(bst_amp)},
  {label:"hsync_width:",   bits:8,  tick:1, FIELD_BT(hsync_width)},
  {label:"hburst_begin:",  bits:9,  tick:1, FIELD_BT(hburst_begin)},
  {label:"hburst_end:",    bits:9,  tick:1, FIELD_BT(hburst_end)},
  {label:"v_activei:",     bits:10, tick:1, FIELD_BT(v_activei)},
  {label:"v_blanki:",      bits:8,  tick:1, FIELD_BT(v_blanki)},
  {label:"v_linesi:",      bits:11, tick:1, FIELD_BT(v_linesi)},
  {label:"v_activeo:",     bits:9,  tick:1, FIELD_BT(v_activeo)},
  {label:"v_blanko:",      bits:10, tick:1, FIELD_BT(v_blanko)},
  {label:"v_scale:",       bits:14, tick:1, FIELD_BT(v_scale)},
  {label:"pll_fract:",     bits:16, tick:1, FIELD_BT(pll_fract)},
  {label:"pll_int:",       bits:6,  tick:1, FIELD_BT(pll_int)},
  {label:"wssinc:",        bits:16, tick:1, FIELD_CX(wssinc)},   
  {label:NULL}
};				    

static GuiRegMask cx_mask2_reg [] = {
  {label:"dr_limitp:", bits:11, tick:1, FIELD_CX(dr_limitp)},
  {label:"dr_limitn:", bits:11, tick:1, FIELD_CX(dr_limitn)},
  {label:"db_limitp:", bits:11, tick:1, FIELD_CX(db_limitp)},
  {label:"db_limitn:", bits:11, tick:1, FIELD_CX(db_limitn)},
  {label:"filfsconv:", bits:6, 	tick:1, FIELD_CX(filfsconv)},
  {label:"filincr:",   bits:8, 	tick:1, FIELD_CX(filincr)},  
  {label:"mcompy:",    bits:8, 	tick:1, FIELD_CX(mcompy)},   
  {label:"mcompu:",    bits:8, 	tick:1, FIELD_CX(mcompu)},   
  {label:"mcompv:",    bits:8, 	tick:1, FIELD_CX(mcompv)},   
  {label:NULL }
};

static GuiFlagMask cx_mask2_flag [] = {
  {label:"prog_sc",     mask:CX_FLAG4_PROG_SC,     FIELD_CX(flags4)}, 
  {label:"sc_pattern",  mask:CX_FLAG4_SC_PATTERN,  FIELD_CX(flags4)}, 
  {label:"field_id",    mask:CX_FLAG4_FIELD_ID,    FIELD_CX(flags4)},
  {label:"fm",          mask:CX_FLAG1_FM,          FIELD_BT(flags1)},
  {label:"ewssf1",      mask:CX_FLAG5_EWSSF1,      FIELD_CX(flags5)},
  {label:"ewssf2",      mask:CX_FLAG5_EWSSF2,      FIELD_CX(flags5)},
  {label:NULL }
};

static GuiRegMask cx_mask2_twin [] = {
  {label:"wsdat:",     bits:21, tick:1, FIELD_CX(wsdat)},
  {label:"msc:",       bits:32, tick:1, FIELD_BT(msc)}, 
  {label:"msc_db:",    bits:32, tick:1, FIELD_CX(msc_db)},
  {label:NULL}
};				    

static GuiRegMask cx_mask3_reg [] = {
  {label:"hsynoffset:",    bits:-10,tick:1, FIELD_BT(hsynoffset)},
  {label:"vsynoffset:",    bits:11, tick:1, FIELD_BT(vsynoffset)},
  {label:"hsynwidth:",     bits:6,  tick:1, FIELD_BT(hsynwidth)},
  {label:"vsynwidth:",     bits:3,  tick:1, FIELD_BT(vsynwidth)},
  {label:"phase_off:",     bits:8,  tick:1, FIELD_BT(phase_off)},
  {label:"hue_adj:",       bits:8,  tick:1, FIELD_CX(hue_adj)},  
  {label:"y_off:",         bits:8,  tick:1, FIELD_CX(y_off)},    
  {label:"mcr:",           bits:8,  tick:1, FIELD_BT(mcr)},
  {label:"mcb:",           bits:8,  tick:1, FIELD_BT(mcb)},
  {label:"my:",            bits:8,  tick:1, FIELD_BT(my)},
  {label:"out_muxa:",      bits:2,  tick:1, FIELD_BT(out_muxa)},
  {label:"out_muxb:",      bits:2,  tick:1, FIELD_BT(out_muxb)},
  {label:"out_muxc:",      bits:2,  tick:1, FIELD_BT(out_muxc)},
  {label:"out_muxd:",      bits:2,  tick:1, FIELD_BT(out_muxd)},
  {label:"c_altff:",       bits:2, 	tick:1, FIELD_CX(c_altff)},  
  {label:"y_altff:",       bits:2, 	tick:1, FIELD_CX(y_altff)},  
  {label:"c_thresh:",      bits:3, 	tick:1, FIELD_CX(c_thresh)}, 
  {label:"y_thresh:",      bits:3,  tick:1, FIELD_CX(y_thresh)}, 
  {label:"macro:",         bits:3,  tick:1, FIELD_BT(macro)},
  {label:NULL}
};                                  

static GuiFlagMask cx_mask3_flag [] = {
  {label:"dacdisa",     mask:BT_FLAG3_DACDISA,     FIELD_BT(flags3)}, 
  {label:"dacdisb",     mask:BT_FLAG3_DACDISB,     FIELD_BT(flags3)}, 
  {label:"dacdisc",     mask:BT_FLAG3_DACDISC,     FIELD_BT(flags3)}, 
  {label:"dacdisd",     mask:BT_FLAG3_DACDISD,     FIELD_BT(flags3)}, 
  {label:"adpt_ff",     mask:CX_FLAG5_ADPT_FF,     FIELD_CX(flags5)},
  {label:"ffrtn",       mask:CX_FLAG5_FFRTN,       FIELD_CX(flags5)},
  {label:"yselect",     mask:CX_FLAG5_YSELECT,     FIELD_CX(flags5)},
  {label:NULL }
};

static GuiRegMask cx_mask4_reg [] = {
  {label:"f_sely:",        bits:3,  tick:1, FIELD_BT(f_sely)},
  {label:"f_selc:",        bits:3,  tick:1, FIELD_BT(f_selc)},
  {label:"pkfil_sel:",     bits:2,  tick:1, FIELD_CX(pkfil_sel)},
  {label:"ylpf:",          bits:2,  tick:1, FIELD_BT(ylpf)},
  {label:"clpf:",          bits:2,  tick:1, FIELD_BT(clpf)},
  {label:"ycoring:",       bits:3,  tick:1, FIELD_BT(ycoring)},
  {label:"ccoring:",       bits:3,  tick:1, FIELD_BT(ccoring)},
  {label:"yattenuate:",    bits:3,  tick:1, FIELD_BT(yattenuate)},
  {label:"cattenuate:",    bits:3,  tick:1, FIELD_BT(cattenuate)},
  {label:NULL}
};				    

static GuiFlagMask cx_mask4_flag [] = {
  {label:"ni_out",      mask:BT_FLAG1_NI_OUT,      FIELD_BT(flags1)}, 
  {label:"setup",       mask:BT_FLAG1_SETUP,       FIELD_BT(flags1)}, 
  {label:"625line",     mask:BT_FLAG1_625LINE,     FIELD_BT(flags1)}, 
  {label:"vsync_dur",   mask:BT_FLAG1_VSYNC_DUR,   FIELD_BT(flags1)}, 
  {label:"dis_screset", mask:BT_FLAG1_DIS_SCRESET, FIELD_BT(flags1)}, 
  {label:"pal_md",      mask:BT_FLAG1_PAL_MD,      FIELD_BT(flags1)}, 
  {label:"dis_ffilt",   mask:BT_FLAG2_DIS_FFILT,   FIELD_BT(flags2)}, 
  {label:"dis_yflpf",   mask:BT_FLAG2_DIS_YFLPF,   FIELD_BT(flags2)}, 
  {label:"eclip",       mask:BT_FLAG1_ECLIP,	   FIELD_BT(flags1)}, 
  {label:"chroma_bw",   mask:CX_FLAG4_CHROMA_BW,   FIELD_CX(flags4)},
  {label:"en_async",    mask:BT_FLAG1_EN_ASYNC,	   FIELD_BT(flags1)}, 
  {label:"pll_32clk",   mask:CX_FLAG5_PLL_32CLK,   FIELD_CX(flags5)},
  {label:"pix_double",  mask:CX_FLAG5_PIX_DOUBLE,  FIELD_CX(flags5)},
  {label:"div2",        mask:CX_FLAG5_DIV2,        FIELD_CX(flags5)},
  {label:"dis_gmshy",   mask:BT_FLAG2_DIS_GMSHY,   FIELD_BT(flags2)}, 
  {label:"dis_gmushy",  mask:BT_FLAG2_DIS_GMUSHY,  FIELD_BT(flags2)}, 
  {label:"dis_gmshc",   mask:BT_FLAG2_DIS_GMSHC,   FIELD_BT(flags2)}, 
  {label:"dis_gmushc",  mask:BT_FLAG2_DIS_GMUSHC,  FIELD_BT(flags2)}, 
  {label:"dis_chroma",  mask:BT_FLAG2_DIS_CHROMA,  FIELD_BT(flags2)}, 
  {label:"by_yccr",     mask:CX_FLAG4_BY_YCCR,     FIELD_CX(flags4)},
  {label:NULL }
};

/* -------- -------- */

/* FIXME: Handle different xtal, 3:2 mode, div2 */

void cx_freq_calc_cb (GtkObject *obj, struct mask_cx_freq *m)
{
  double Fxtal = 13500000; 
  double Fclk; 
  double Fhsyn;
  double Fvsyn;
  double dALO, dTLO, dATO, dTTO, dVACTIVEO;
  double dAspect, dHOC, dVOC;
  char s [20];

  if ((gui_tv_chip & TV_ENCODER) != TV_BROOKTREE && 
      (gui_tv_chip & TV_ENCODER) != TV_CONEXANT) return;

  Fclk = Fxtal * (gui_regs.enc.bt.pll_int + 
		  gui_regs.enc.bt.pll_fract / 65536.0) / 6.0;
  sprintf (s, "%3.2f MHz", Fclk / 1e6);
  gtk_label_set_text (m->clk, s);

  Fhsyn = Fclk / gui_regs.enc.bt.h_clki;
  snprintf (s, 20, "%3.2f kHz", Fhsyn / 1e3);
  gtk_label_set_text (m->hsyn, s);

  Fvsyn = Fhsyn / gui_regs.enc.bt.v_linesi;
  snprintf (s, 20, "%3.2f  Hz", Fvsyn);
  gtk_label_set_text (m->vsyn, s);

  if (gui_regs.enc.bt.flags1 & BT_FLAG1_625LINE) {
    dALO = 288.0;
    dTLO = 312.0;
    dATO = .000052;
    dTTO = .000064;
  } else {
    dALO = 243.0;
    dTLO = 262.0;
    dATO = .00005265556;
    dTTO = .00006355556;
  }
  /* if interlace then dTLO += 0.5 */
  dVACTIVEO = (int) (((gui_regs.enc.bt.v_activei * dTLO) + 
		      (gui_regs.enc.bt.v_linesi - 1.0)) / 
		     gui_regs.enc.bt.v_linesi);
  /* normally, dVACTIVEO = v_activeo - 2 */
  /* These two euqations are also possible, but that's not what happens
   *  in recalc.c, so don't use them.
   * dVOC = 1.0 - (gui_regs.enc.bt.v_activeo - 2) / dALO;
   * dVOC = 1.0 - ((gui_regs.enc.bt.v_activei / gui_regs.enc.bt.v_linesi) / 
   *              (dALO / dTLO));
   */
  dVOC = 1.0 - dVACTIVEO / dALO;
  dHOC = 1.0 - ((2.0 * gui_regs.enc.bt.h_active / gui_regs.enc.bt.h_clko) / 
               (dATO / dTTO));
  dAspect = (1.0 - dHOC) / (1.0 - dVOC);

  snprintf (s, 20, "%06.3f %%", dHOC * 100.0);
  gtk_label_set_text (m->hover, s);
  snprintf (s, 20, "%06.3f %%", dVOC * 100.0);
  gtk_label_set_text (m->vover, s);
  snprintf (s, 20, "%07.5f", dAspect);
  gtk_label_set_text (m->aspect, s);

  /* FIXME: check above, calculate aspect */
}

gint check_cx_cb (struct mask_status *m)
{
  int status;

  if ((gui_tv_chip & TV_ENCODER) != TV_CONEXANT) return TRUE;
  status = back_card->getStatus (4);
  if (status < 0) return TRUE;
  if (! (status & 0x100)) status = 0;
  gtk_toggle_button_set_active (m->tvon,      (status & 0x100) ? TRUE : FALSE);
  gtk_toggle_button_set_active (m->secam,     (status & 0x040) ? TRUE : FALSE);
  gtk_toggle_button_set_active (m->pll_reset, (status & 0x020) ? TRUE : FALSE);
  gtk_toggle_button_set_active (m->pll_lock,  (status & 0x010) ? TRUE : FALSE);
  gtk_toggle_button_set_active (m->over,      (status & 0x008) ? TRUE : FALSE);
  gtk_toggle_button_set_active (m->under,     (status & 0x004) ? TRUE : FALSE);
  gtk_toggle_button_set_active (m->pal,       (status & 0x002) ? TRUE : FALSE);
  return TRUE;
}

void reset_cx_cb (GtkObject *obj, gpointer data)
{
  if ((gui_tv_chip & TV_ENCODER) != TV_CONEXANT) return;
  if (gui_act_mode) {
    gui_regs.enc.cx = gui_act_mode->regs.enc.cx;
    gui_tv_set ();
    gtk_signal_emit_by_name (GTK_OBJECT (update_cx), "changed");
    gtk_signal_emit_by_name (GTK_OBJECT (changed_all), "changed");
  }
}

void update_cx_cb (GtkObject *obj, gpointer data)
{
  if ((gui_tv_chip & TV_ENCODER) != TV_CONEXANT) return;
  gtk_signal_emit_by_name (GTK_OBJECT (update_cx), "changed");
}

void gui_map_cx_cb (GtkWidget *widget, gpointer data)
{
  DPRINTF ("gui_map_cx_cb\n");
#ifndef DISABLE_TIMEOUT
  if (gui_timeout_cx_id == -1) {
    gui_timeout_cx_id = gtk_timeout_add (500 /* ms */, 
      (GtkFunction) check_cx_cb, &gui_mask_cx_status);
  }
#endif
}

void gui_unmap_cx_cb (GtkWidget *widget, gpointer data)
{
  DPRINTF ("gui_unmap_cx_cb\n");
#ifndef DISABLE_TIMEOUT
  if (gui_timeout_cx_id != -1) {
    gtk_timeout_remove (gui_timeout_cx_id);
    gui_timeout_cx_id = -1;
  }
#endif
}

/* -------- GUI Pages -------- */

GtkWidget *gui_cx_status_page (void)
{
  GtkWidget *page;
  GtkWidget *frame;
  GtkWidget *table;
  GtkWidget *button;

  page = gtk_vbox_new (FALSE, 5);
  gtk_signal_connect (GTK_OBJECT (page), "map",
    GTK_SIGNAL_FUNC (gui_map_cx_cb), NULL);
  gtk_signal_connect (GTK_OBJECT (page), "unmap",
    GTK_SIGNAL_FUNC (gui_unmap_cx_cb), NULL);
  gtk_container_set_border_width (GTK_CONTAINER (page), 5);

  /* Frequencies CRT / TV */

  frame = gtk_frame_new ("Frequencies");
  gtk_box_pack_start (GTK_BOX (page), frame, TRUE, TRUE, 0);

  table = gtk_table_new (3, 4, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (table), 10);
  gtk_container_add (GTK_CONTAINER (frame), table);

  gui_mask_cx_freq.clk = 
    gui_mask_label (table, "Monitor dot clock:",   "---.-- MHz", 0,1,2, 0);
  gui_mask_cx_freq.hsyn = 
    gui_mask_label (table, "Monitor horiz. sync:", "---.-- kHz", 0,1,2, 1);
  gui_mask_cx_freq.vsyn = 
    gui_mask_label (table, "Monitor vert. sync:",  "---.--  Hz", 0,1,2, 2);
  gui_mask_cx_freq.hover = 
    gui_mask_label (table, "TV horiz. overscan:",  "--.--  %",   0,1,2, 3);
  gui_mask_cx_freq.vover = 
    gui_mask_label (table, "TV vert. overscan:",   "--.--  %",   0,1,2, 4);
  gui_mask_cx_freq.aspect = 
   gui_mask_label (table, "TV aspect ratio:",      "-.---  ",    0,1,2, 5);

  gtk_table_set_col_spacings (GTK_TABLE(table), 10);
  gtk_table_set_row_spacings (GTK_TABLE(table), 10);

  /* TV Status: CX Fifo overrun/underrun */

  frame = gtk_frame_new ("Conexant Status");
  gtk_box_pack_start (GTK_BOX (page), frame, TRUE, TRUE, 0);

  table = gtk_table_new (1, 1, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (table), 10);
  gtk_container_add (GTK_CONTAINER (frame), table);

  button = gtk_check_button_new_with_label ("TV on");
  gui_mask_cx_status.tvon = (GtkToggleButton *) button;
  gtk_table_attach (GTK_TABLE(table), button, 0,1, 0,1, GTK_FILL,GTK_FILL,0,0);

  button = gtk_check_button_new_with_label ("PLL locked");
  gui_mask_cx_status.pll_lock = (GtkToggleButton *) button;
  gtk_table_attach (GTK_TABLE(table), button, 0,1, 1,2, GTK_FILL,GTK_FILL,0,0);

  button = gtk_check_button_new_with_label ("PLL reset");
  gui_mask_cx_status.pll_reset = (GtkToggleButton *) button;
  gtk_table_attach (GTK_TABLE(table), button, 0,1, 2,3, GTK_FILL,GTK_FILL,0,0);

  button = gtk_check_button_new_with_label ("FIFO overrun");
  gui_mask_cx_status.over = (GtkToggleButton *) button;
  gtk_table_attach (GTK_TABLE(table), button, 1,2, 0,1, GTK_FILL,GTK_FILL,0,0);

  button = gtk_check_button_new_with_label ("FIFO underrun");
  gui_mask_cx_status.under = (GtkToggleButton *) button;
  gtk_table_attach (GTK_TABLE(table), button, 1,2, 1,2, GTK_FILL,GTK_FILL,0,0);

  button = gtk_check_button_new_with_label ("PAL pin");
  gui_mask_cx_status.pal = (GtkToggleButton *) button;
  gtk_table_attach (GTK_TABLE(table), button, 2,3, 0,1, GTK_FILL,GTK_FILL,0,0);

  button = gtk_check_button_new_with_label ("SECAM");
  gui_mask_cx_status.secam = (GtkToggleButton *) button;
  gtk_table_attach (GTK_TABLE(table), button, 2,3, 1,2, GTK_FILL,GTK_FILL,0,0);

  gtk_table_set_col_spacings (GTK_TABLE(table), 5);
  gtk_table_set_row_spacings (GTK_TABLE(table), 5);

  /* return */

  return page;
}

GtkWidget *gui_cx_reg1_page (void)
{
  GtkAccelGroup *gui_cx_reg_accel_group;

  gui_cx_reg_accel_group = gtk_accel_group_new ();
  return gui_regs_page ("CX 25870/871 Timings", 
    gui_cx_reg_accel_group, PRINT_CHIP_REGS,
    GTK_OBJECT (update_cx), GTK_SIGNAL_FUNC (reset_cx_cb),
    0, 0, 11, cx_mask1_reg, 0, 0, NULL, 0, 0, 0, NULL);
}

GtkWidget *gui_cx_reg2_page (void)
{
  GtkAccelGroup *gui_cx_reg_accel_group;

  gui_cx_reg_accel_group = gtk_accel_group_new ();
  return gui_regs_page ("CX 25870/871 Secam & Subcarrier", 
    gui_cx_reg_accel_group, PRINT_CHIP_REGS,
    GTK_OBJECT (update_cx), GTK_SIGNAL_FUNC (reset_cx_cb),
    0, 0, 6, cx_mask2_reg, 0, 6, cx_mask2_twin, 3, 3, 3, cx_mask2_flag);
}

GtkWidget *gui_cx_reg3_page (void)
{
  GtkAccelGroup *gui_cx_reg_accel_group;

  gui_cx_reg_accel_group = gtk_accel_group_new ();
  return gui_regs_page ("CX 25870/871 Parameters", 
    gui_cx_reg_accel_group, PRINT_CHIP_REGS,
    GTK_OBJECT (update_cx), GTK_SIGNAL_FUNC (reset_cx_cb),
    0, 0, 10, cx_mask3_reg, 0, 0, NULL, 6, 0, 9, cx_mask3_flag);
}

GtkWidget *gui_cx_reg4_page (void)
{
  GtkAccelGroup *gui_cx_reg_accel_group;

  gui_cx_reg_accel_group = gtk_accel_group_new ();
  return gui_regs_page ("CX 25870/871 Flags", 
    gui_cx_reg_accel_group, PRINT_CHIP_REGS,
    GTK_OBJECT (update_cx), GTK_SIGNAL_FUNC (reset_cx_cb),
    0, 0, 10, cx_mask4_reg, 0, 0, NULL, 4, 0, 10, cx_mask4_flag);
}

void gui_cx_init (void)
{
  update_cx = (GtkAdjustment *) gtk_adjustment_new (0, 0, 0, 0, 0, 0);
  gtk_signal_connect (GTK_OBJECT (update_chip), "changed", 
    GTK_SIGNAL_FUNC (update_cx_cb), NULL);
  gtk_signal_connect (GTK_OBJECT (changed_all), "changed",
    GTK_SIGNAL_FUNC (cx_freq_calc_cb), &gui_mask_cx_freq);
}

