/* NVTV GUI (CRTC NV part) -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * The GTK graphical user interface. CRTC NV part.
 */

#include "local.h" /* before everything else */

#include <gtk/gtk.h>

#include "gui.h"
#include "gui_nv.h"
#include "backend.h"

#define FIELD(b,m) addr:&(b.m), size:sizeof(b.m)
#define FIELD_CRT(m) FIELD(gui_regs.crtc.nv,m)
#define FIELD_FP(m) FIELD(gui_regs.crtc.nv.fp,m)

static GuiRegMask nv_mask_reg [] = {
  {label:"HDisplay:",    bits:12, tick:8, FIELD_CRT(HDisplay)}, 
  {label:"HSyncStart:",  bits:12, tick:8, FIELD_CRT(HSyncStart)}, 
  {label:"HSyncEnd:",    bits:12, tick:8, FIELD_CRT(HSyncEnd)}, 
  {label:"HTotal:",      bits:12, tick:8, FIELD_CRT(HTotal)}, 
  {label:"VDisplay:",    bits:12, tick:1, FIELD_CRT(VDisplay)}, 
  {label:"VSyncStart:",  bits:12, tick:1, FIELD_CRT(VSyncStart)},  
  {label:"VSyncEnd:",    bits:12, tick:1, FIELD_CRT(VSyncEnd)},    
  {label:"VTotal:",      bits:12, tick:1, FIELD_CRT(VTotal)},      
  {label:"Latency:",     bits:3,  tick:1, FIELD_CRT(latency)},      
  {label:"DotClock:",    bits:20, tick:1, FIELD_CRT(clock)},      
  {label:"*HSyncStart:", bits:12, tick:1, FIELD_CRT(slave.HSyncStart)}, 
  {label:"*HSyncEnd:",   bits:12, tick:1, FIELD_CRT(slave.HSyncEnd)},   
  {label:"*HTotal:",     bits:12, tick:1, FIELD_CRT(slave.HTotal)},     
  {label:"*VSyncStart:", bits:12, tick:1, FIELD_CRT(slave.VSyncStart)}, 
  {label:"*VSyncEnd:",   bits:12, tick:1, FIELD_CRT(slave.VSyncEnd)},   
  {label:"*VTotal:",     bits:12, tick:1, FIELD_CRT(slave.VTotal)},     
  {label:"*Unknown:",    bits:12, tick:1, FIELD_CRT(slave.Unknown)},       
  {label:NULL }
};

static GuiFlagMask nv_mask_flag [] = {
  {label:"DblScan",  mask:NV_FLAG_DOUBLE_SCAN, FIELD_CRT(flags)}, 
  {label:"DblPix",   mask:NV_FLAG_DOUBLE_PIX,  FIELD_CRT(flags)}, 
  {label:NULL }
};

static GuiRegMask nv_fp_mask_reg [] = {
  {label:"HDisplay:",    bits:11, tick:1, FIELD_FP(HDisplay)}, 
  {label:"HSyncStart:",  bits:11, tick:1, FIELD_FP(HSyncStart)}, 
  {label:"HSyncEnd:",    bits:11, tick:1, FIELD_FP(HSyncEnd)}, 
  {label:"HTotal:",      bits:11, tick:1, FIELD_FP(HTotal)}, 
  {label:"HValidStart:", bits:11, tick:1, FIELD_FP(HValidStart)}, 
  {label:"HValidEnd:",   bits:11, tick:1, FIELD_FP(HValidEnd)}, 
  {label:"HCrtc:",       bits:11, tick:1, FIELD_FP(HCrtc)}, 
  {label:"VDisplay:",    bits:11, tick:1, FIELD_FP(VDisplay)}, 
  {label:"VSyncStart:",  bits:11, tick:1, FIELD_FP(VSyncStart)},  
  {label:"VSyncEnd:",    bits:11, tick:1, FIELD_FP(VSyncEnd)},    
  {label:"VTotal:",      bits:11, tick:1, FIELD_FP(VTotal)},      
  {label:"VValidStart:", bits:11, tick:1, FIELD_FP(VValidStart)}, 
  {label:"VValidEnd:",   bits:11, tick:1, FIELD_FP(VValidEnd)}, 
  {label:"VCrtc:",       bits:11, tick:1, FIELD_FP(VCrtc)}, 
  {label:NULL }
};

GtkWidget *gui_nv_page (void)
{
  GtkAccelGroup *gui_nv_reg_accel_group;

  gui_nv_reg_accel_group = gtk_accel_group_new ();
  return gui_regs_page ("NV CRTC Register Values", 
    gui_nv_reg_accel_group, PRINT_CRT_REGS,
    GTK_OBJECT (update_crt), GTK_SIGNAL_FUNC (gui_reset_crt_cb),
    0, 0, 10, nv_mask_reg, 0, 0, NULL, 3, 7, 3, nv_mask_flag);

#if 0 /* FIXME */
  button = gtk_button_new_with_label ("Check");
  gtk_widget_set_sensitive (GTK_WIDGET (button), FALSE);
  /* check if registers are "sane", correct if necessary */
  gtk_table_attach(GTK_TABLE(page), button, 2,3,1,2,
    GTK_FILL, GTK_FILL, 0, 0);
#endif
}

GtkWidget *gui_nv_fp_page (void)
{
  GtkAccelGroup *gui_nv_fp_accel_group;

  gui_nv_fp_accel_group = gtk_accel_group_new ();
  return gui_regs_page ("NV Flatpanel Register Values", 
    gui_nv_fp_accel_group, PRINT_FP_REGS,
    GTK_OBJECT (update_crt), GTK_SIGNAL_FUNC (gui_reset_crt_cb),
    0, 0, 7, nv_fp_mask_reg, 0, 0, NULL, 0, 0, 0, NULL);
}

  
