/* NVTV GUI (CRTC 3dfx part) -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * The GTK graphical user interface. CRTC 3dfx part.
 */

#include "local.h" /* after xfree, before everything else */

#include <gtk/gtk.h>

#include "gui.h"
#include "gui_tdfx.h"
#include "backend.h"

#define FIELD(b,m) addr:&(b.m), size:sizeof(b.m)
#define FIELD_CRT(m) FIELD(gui_regs.crtc.tdfx,m)

static GuiRegMask tdfx_mask_reg [] = {
  {label:"HScreenSize:",  bits:12, tick:1, FIELD_CRT(HScreenSize)}, 
  {label:"VScreenSize:",  bits:12, tick:1, FIELD_CRT(VScreenSize)},
  {label:"HDisplay:",     bits:12, tick:8, FIELD_CRT(HDisplay)}, 
  {label:"HSyncStart:",   bits:12, tick:8, FIELD_CRT(HSyncStart)}, 
  {label:"HSyncEnd:",     bits:12, tick:8, FIELD_CRT(HSyncEnd)}, 
  {label:"HTotal:",       bits:12, tick:8, FIELD_CRT(HTotal)}, 
  {label:"VDisplay:",     bits:12, tick:1, FIELD_CRT(VDisplay)}, 
  {label:"VSyncStart:",   bits:12, tick:1, FIELD_CRT(VSyncStart)},  
  {label:"VSyncEnd:",     bits:12, tick:1, FIELD_CRT(VSyncEnd)},    
  {label:"VTotal:",       bits:12, tick:1, FIELD_CRT(VTotal)},      
  {label:"DotClock:",     bits:20, tick:1, FIELD_CRT(clock)},      
  {label:"*HBlankStart:", bits:11, tick:1, FIELD_CRT(tvHBlankStart)}, 
  {label:"*HBlankEnd:",   bits:11, tick:1, FIELD_CRT(tvHBlankEnd)},   
  {label:"*VBlankStart:", bits:11, tick:1, FIELD_CRT(tvVBlankStart)}, 
  {label:"*VBlankEnd:",   bits:11, tick:1, FIELD_CRT(tvVBlankEnd)},   
  {label:"*BlankDelay:",  bits:3,  tick:1, FIELD_CRT(tvBlankDelay)}, 
  {label:"*SyncDelay:",   bits:3,  tick:1, FIELD_CRT(tvSyncDelay)}, 
  {label:"*Latency:",     bits:4,  tick:1, FIELD_CRT(tvLatency)}, 
  {label:NULL }
};

static GuiFlagMask tdfx_mask_flag [] = {
  {label:"Clock2x",       mask:TDFX_FLAG_CLOCK2X,    FIELD_CRT(flags)}, 
  {label:"DoublePix",     mask:TDFX_FLAG_DOUBLE_PIX, FIELD_CRT(flags)}, 
  {label:"HalfMode",      mask:TDFX_FLAG_HALF_MODE,  FIELD_CRT(flags)}, 
  {label:NULL }
};

GtkWidget *gui_tdfx_page (void)
{
  GtkAccelGroup *gui_tdfx_reg_accel_group;

  gui_tdfx_reg_accel_group = gtk_accel_group_new ();
  return gui_regs_page ("CRTC 3dfx Register Values", 
    gui_tdfx_reg_accel_group, PRINT_CRT_REGS,
    GTK_OBJECT (update_crt), GTK_SIGNAL_FUNC (gui_reset_crt_cb),
    0, 0, 11, tdfx_mask_reg, 0, 11, NULL, 3, 7, 11, tdfx_mask_flag);

#if 0 /* FIXME */
  button = gtk_button_new_with_label ("Check");
  gtk_widget_set_sensitive (GTK_WIDGET (button), FALSE);
  /* check if registers are "sane", correct if necessary */
  gtk_table_attach(GTK_TABLE(page), button, 2,3,1,2,
    GTK_FILL, GTK_FILL, 0, 0);
#endif
}

  
