/* NVTV TV mmio header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Header: Extra memory mapped I/O defines
 *
 */

#ifndef _MMIO_H
#define _MMIO_H

/* Extra MMIO defines */

#include "debug.h"

#define HEAD 0x2000

#define CRT_INDEX(h) (0x3d4 + (h) * HEAD)
#define CRT_DATA(h)  (0x3d5 + (h) * HEAD)

#define MMIO_H_OUT8(base,h,offset,val) MMIO_OUT8(base,(offset)+(h)*HEAD,val)
#define MMIO_H_OUT32(base,h,offset,val) MMIO_OUT32(base,(offset)+(h)*HEAD,val)
#define MMIO_H_IN8(base,h,offset) MMIO_IN8(base,(offset)+(h)*HEAD)
#define MMIO_H_IN32(base,h,offset) MMIO_IN32(base,(offset)+(h)*HEAD)

#define MMIO_H_AND32(base,h,offset,val) MMIO_AND32(base,(offset)+(h)*HEAD,val)
#define MMIO_H_OR32(base,h,offset,val) MMIO_OR32(base,(offset)+(h)*HEAD,val)

#if !defined(FAKE_MMIO) && !defined(TEST_MMIO)

#define MMIO_AND32(base, offset, val) \
	*(volatile CARD32 *)(void *)(((CARD8*)(base)) + (offset)) &= (val)
#define MMIO_OR32(base, offset, val) \
	*(volatile CARD32 *)(void *)(((CARD8*)(base)) + (offset)) |= (val)

#else /* FAKE_MMIO */

#undef MMIO_IN8
#undef MMIO_IN16
#undef MMIO_IN32
#undef MMIO_OUT8
#undef MMIO_OUT16
#undef MMIO_OUT32

#endif

#ifdef TEST_MMIO

#define MMIO_IN8(base, offset)		mmio_in8 (base, offset)
#define MMIO_IN16(base, offset)		mmio_in16 (base, offset)
#define MMIO_IN32(base, offset)		mmio_in32 (base, offset)
#define MMIO_OUT8(base, offset, val)	mmio_out8 (base, offset, val)
#define MMIO_OUT16(base, offset, val)	mmio_out16 (base, offset, val)
#define MMIO_OUT32(base, offset, val)	mmio_out32 (base, offset, val)
#define MMIO_AND32(base, offset, val)	mmio_and32 (base, offset, val)
#define MMIO_OR32(base, offset, val)	mmio_or32 (base, offset, val)

#else /* TEST_MMIO */

#ifdef FAKE_MMIO

#ifdef CHECK_MMIO

#ifndef CHECK_MMIO_ABORT
#define MMIO_CAUGHT FPRINTF ("\nMMIO CHECK trigger in %s:%i\n", __FUNCTION__, __LINE__)
#else
#define MMIO_CAUGHT FPRINTF ("OOPS %i", 1/0)
#endif

#define MMIO_RANGE(base, offset) \
  ((((((int) base) >> 12) & 0xfff) == CHECK_MMIO_BASE && offset >= CHECK_MMIO_MIN && offset <= CHECK_MMIO_MAX) ? MMIO_CAUGHT : FPRINTF("")),

#else

#define MMIO_RANGE(base, offset)

#endif

#define MMIO_IN8(base, offset) \
  ( MMIO_RANGE(base, offset) FPRINTF("[%03X/%04X?8] ", \
      (((int) base) >> 12) & 0xfff, offset), 0 )
#define MMIO_IN16(base, offset) \
  ( MMIO_RANGE(base, offset) FPRINTF("[%03X/%04X?16] ", \
      (((int) base) >> 12) & 0xfff, offset), 0 )
#define MMIO_IN32(base, offset) \
  ( MMIO_RANGE(base, offset) FPRINTF("[%03X/%04X?32] ", \
      (((int) base) >> 12) & 0xfff, offset), 0L )
#define MMIO_OUT8(base, offset, val) \
  ( MMIO_RANGE(base, offset) FPRINTF("[%03X/%04X=%02X] ", \
    (((int) base) >> 12) & 0xfff, offset, (int) (val)) )
#define MMIO_OUT16(base, offset, val) \
  ( MMIO_RANGE(base, offset) FPRINTF("[%03X/%04X=%04X] ", \
    (((int) base) >> 12) & 0xfff, offset, (int) (val)) )
#define MMIO_OUT32(base, offset, val) \
  ( MMIO_RANGE(base, offset) FPRINTF("[%03X/%04X=%08X] ", \
     (((int) base) >> 12) & 0xfff, offset, (int) (val)) )
#define MMIO_AND32(base, offset, val) \
  ( MMIO_RANGE(base, offset) FPRINTF("[%03X/%04X&=%08X] ", \
      (((int) base) >> 12) & 0xfff, offset, (int) (val)) )
#define MMIO_OR32(base, offset, val) \
  ( MMIO_RANGE(base, offset) FPRINTF("[%03X/%04X|=%08X] ", \
      (((int) base) >> 12) & 0xfff, offset, (int) (val)) )

#endif /* FAKE_MMIO */
#endif /* TEST_MMIO */

#endif /* _MMIO_H */

