/* NVTV main header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents: Global variables.
 */

#ifndef _MAIN_H
#define _MAIN_H

#include "tv_chip.h"

typedef struct _OptIntDecl {
  char *name;
  int min, max;
  int *addr;
} OptIntDecl;

typedef struct _OptIntVal {
  int val;
  int *addr;
  struct _OptIntVal *link;
} OptIntVal;

typedef struct _OptFlagDecl {
  char *name;
  int mask;
  int *addr_val;
  int *addr_mask;
} OptFlagDecl;

void modifySet (TVSettings *s, OptIntVal *m); /* only opt_set for now */

extern OptIntVal *opt_set_act;

extern Bool opt_no_root;
extern TVSystem opt_system;      /* use if != TV_SYSTEM_NONE */

extern TVConnect opt_connect;    /* use if != CONNECT_NONE */
extern TVSettings opt_set;

extern TVChip opt_tv_chip;       /* use if != TV_NO_CHIP */
int opt_tv_bus, opt_tv_addr;     /* use if == TV_CHIP_BY_ADDR */

#if HAVE_X
extern Window opt_window;        /* use if != None */
#endif

extern int opt_res_x, opt_res_y; /* use if both != -1 */
extern float opt_hoc, opt_voc;   /* use if both != -1.0 */ 
extern char *opt_size;           /* use if != NULL */

extern int opt_head;             /* use if != -1 */

extern int opt_service_flags;
extern int opt_service_mask;

extern int opt_mode_flags;
extern int opt_mode_mask;

#endif


