/* NVTV actions -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * Contents: Printing actions.
 *
 */

#include "local.h" /* before everything else */

#include <stdio.h>

#include "print.h"

/* -------- Print actions -------- */

/* FIXME TODO print_nv_fp_regs */

void print_nv_regs (TVNvRegs *m)
{
  printf ("*** CRT Registers\n");
  printf ("  Clock       : %li,\n", m->clock);     
  printf ("  HDisplay    : %i,\n", m->HDisplay);
  printf ("  HSyncStart  : %i,\n", m->HSyncStart);   
  printf ("  HSyncEnd    : %i,\n", m->HSyncEnd);     
  printf ("  HTotal      : %i,\n", m->HTotal);       
  printf ("  HBlankStart : %i,\n", m->HBlankStart);   
  printf ("  HBlankEnd   : %i,\n", m->HBlankEnd);     
  printf ("  VDisplay    : %i,\n", m->VDisplay);     
  printf ("  VSyncStart  : %i,\n", m->VSyncStart);   
  printf ("  VSyncEnd    : %i,\n", m->VSyncEnd);     
  printf ("  VTotal      : %i,\n", m->VTotal);       
  printf ("  VBlankStart : %i,\n", m->VBlankStart);   
  printf ("  VBlankEnd   : %i,\n", m->VBlankEnd);     
  printf ("  Latency     : %i,\n", m->latency);     
}

void print_nv_fp_regs (TVNvFpRegs *m)
{
  printf ("*** FP Registers\n");
  printf ("  HDisplay    : %i,\n", m->HDisplay); 
  printf ("  HSyncStart  : %i,\n", m->HSyncStart);  
  printf ("  HSyncEnd    : %i,\n", m->HSyncEnd);    
  printf ("  HTotal      : %i,\n", m->HTotal);      
  printf ("  HValidStart : %i,\n", m->HValidStart); 
  printf ("  HValidEnd   : %i,\n", m->HValidEnd);   
  printf ("  HCrtc       : %i,\n", m->HCrtc);       
  printf ("  VDisplay    : %i,\n", m->VDisplay);    
  printf ("  VSyncStart  : %i,\n", m->VSyncStart);  
  printf ("  VSyncEnd    : %i,\n", m->VSyncEnd);    
  printf ("  VTotal      : %i,\n", m->VTotal);      
  printf ("  VValidStart : %i,\n", m->VValidStart); 
  printf ("  VValidEnd   : %i,\n", m->VValidEnd);   
  printf ("  VCrtc       : %i,\n", m->VCrtc);       
}

void print_crt_regs (TVCrtcRegs *m, CardType card)
{
  switch (card)
  {
  case CARD_NVIDIA:
  case CARD_XBOX:
    print_nv_regs (&m->nv);
    break;
  default:
    break;
  }
}

void print_fp_regs (TVCrtcRegs *m, CardType card)
{
  switch (card)
  {
  case CARD_NVIDIA:
  case CARD_XBOX:
    print_nv_fp_regs (&m->nv.fp);
    break;
  default:
    break;
  }
}

void print_bt_regs (TVBtRegs *b)
{
  printf ("*** Brooktree Registers\n");
  printf ("  hsynoffset   : %i,\n", b->hsynoffset);
  printf ("  vsynoffset   : %i,\n", b->vsynoffset);
  printf ("  hsynwidth    : %i,\n", b->hsynwidth);
  printf ("  vsynwidth    : %i,\n", b->vsynwidth);
  printf ("  h_active     : %i,\n", b->h_active);
  printf ("  h_blanki     : %i,\n", b->h_blanki); 
  printf ("  h_clki       : %i,\n", b->h_clki);   
  printf ("  h_fract      : %i,\n", b->h_fract);  
  printf ("  h_blanko     : %i,\n", b->h_blanko); 
  printf ("  h_clko       : %i,\n", b->h_clko);
  printf ("  v_activei    : %i,\n", b->v_activei);
  printf ("  v_blanki     : %i,\n", b->v_blanki); 
  printf ("  v_linesi     : %i,\n", b->v_linesi); 
  printf ("  v_activeo    : %i,\n", b->v_activeo);
  printf ("  v_blanko     : %i,\n", b->v_blanko); 
  printf ("  v_scale      : %i,\n", b->v_scale);  
  printf ("  pll_fract    : %i,\n", b->pll_fract);
  printf ("  pll_int      : %i,\n", b->pll_int);  
  printf ("  sync_amp     : %i,\n", b->sync_amp); 
  printf ("  bst_amp      : %i,\n", b->bst_amp);  
  printf ("  hsync_width  : %i,\n", b->hsync_width);
  printf ("  hburst_begin : %i,\n", b->hburst_begin);
  printf ("  hburst_end   : %i,\n", b->hburst_end);
  printf ("  mcr          : %i,\n", b->mcr);      
  printf ("  mcb          : %i,\n", b->mcb);      
  printf ("  my           : %i,\n", b->my);       
  printf ("  msc          : %li,\n", b->msc); 
  /* FIXME TODO flags */
}

void print_ch1_regs (TVChRegs *r)
{
  printf ("*** Chrontel Registers\n");
  printf ("  dmr_ir    : %i,\n", r->dmr_ir);
  printf ("  dmr_vs    : %i,\n", r->dmr_vs);
  printf ("  dmr_sr    : %i,\n", r->dmr_sr);
  printf ("  sav       : %i,\n", r->sav);
  printf ("  hpr       : %i,\n", r->hpr);
  printf ("  vpr       : %i,\n", r->vpr);
  printf ("  pll_m     : %i,\n", r->pll_m);
  printf ("  pll_n     : %i,\n", r->pll_n);
  printf ("  pllcap    : %i,\n", r->pllcap);
  printf ("  dacg      : %i,\n", r->dacg);
  printf ("  fsci      : %li,\n", r->fsci);
  printf ("  ffr_fc    : %i,\n", r->ffr_fc);
  printf ("  ffr_fy    : %i,\n", r->ffr_fy);
  printf ("  ffr_ft    : %i,\n", r->ffr_ft);
  printf ("  blr       : %i,\n", r->blr);
  printf ("  ce        : %i,\n", r->ce);
  printf ("  vbw_flff  : %i,\n", r->vbw_flff);  
  printf ("  vbw_cbw   : %i,\n", r->vbw_cbw);   
  printf ("  vbw_ypeak : %i,\n", r->vbw_ypeak); 
  printf ("  vbw_ysv   : %i,\n", r->vbw_ysv);   
  printf ("  vbw_ycv   : %i,\n", r->vbw_ycv);    
  /* FIXME TODO flags */
}

void print_ch2_regs (TVChRegs *r)
{
}

void print_ph1_regs (TVPh1Regs *r)
{
  printf ("adwhs  : %i,\n", r->adwhs);    
  printf ("adwhe  : %i,\n", r->adwhe);    
  printf ("xofs   : %i,\n", r->xofs);     
  printf ("xpix   : %i,\n", r->xpix);     
  printf ("xinc   : %i,\n", r->xinc);     
  printf ("hlen   : %i,\n", r->hlen);     
  printf ("fal    : %i,\n", r->fal);      
  printf ("lal    : %i,\n", r->lal);      
  printf ("yinc   : %i,\n", r->yinc);     
  printf ("yskip  : %i,\n", r->yskip);    
  printf ("yofso  : %i,\n", r->yofso);    
  printf ("yofse  : %i,\n", r->yofse);    
  printf ("ypix   : %i,\n", r->ypix);     
  printf ("yiwgto : %i,\n", r->yiwgto);   
  printf ("yiwgte : %i,\n", r->yiwgte);   
  printf ("pcl    : %li,\n", r->pcl);    
  printf ("fsc    : %li,\n", r->fsc);    
  printf ("idel   : %i,\n", r->idel);     
  printf ("bs     : %i,\n", r->bs);       
  printf ("be     : %i,\n", r->be);       
  printf ("bsta   : %i,\n", r->bsta);     
  printf ("blckl  : %i,\n", r->blckl);    
  printf ("blnnl  : %i,\n", r->blnnl);    
  printf ("chps   : %i,\n", r->chps);     
  printf ("gy     : %i,\n", r->gy);       
  printf ("gcd    : %i,\n", r->gcd);      
  printf ("bcy    : %i,\n", r->bcy);      
  printf ("bcu    : %i,\n", r->bcu);      
  printf ("bcv    : %i,\n", r->bcv);      
  printf ("ccrs   : %i,\n", r->ccrs);     
  printf ("gainu  : %i,\n", r->gainu);    
  printf ("gainv  : %i,\n", r->gainv);    
  /* FIXME flags1, flags2; */
}

void print_ph2_regs (TVPh2Regs *r)
{
  print_ph1_regs (&r->super);
  printf ("yfil   : %i,\n", r->yfil);
  printf ("fili   : %i,\n", r->fili);
  printf ("pcle   : %i,\n", r->pcle);
  printf ("pcli   : %i,\n", r->pcli);
  /* FIXME flags3; */
}

void print_tv_regs (TVEncoderRegs *c, TVChip type)
{
  switch (type & TV_ENCODER) 
  {
    case TV_BROOKTREE:
    case TV_CONEXANT:
      print_bt_regs (&c->bt); 
      break;
    case TV_CHRONTEL_MODEL1:
      print_ch1_regs (&c->ch); 
      break;
    case TV_CHRONTEL_MODEL2:
      print_ch2_regs (&c->ch); 
      break;
    case TV_PHILIPS_MODEL1:
      print_ph1_regs (&c->ph1); 
      break;
    case TV_PHILIPS_MODEL2:
      print_ph2_regs (&c->ph2); 
      break;
    default:
      break;
  }
}

