/* NVTV Brooktree TV-I2C header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Header: Routines to access the Brooktree chip registers via the I2C bus.
 *
 */

#ifndef _TV_BT_H
#define _TV_BT_H

#include "xf86i2c.h"
#include "tv_i2c.h"
#include "tv_chip.h"
#include "tv_common.h"

void TVBtMacroMode (TVEncoderObj *this, TVEncoderRegs *r);
void TVBtSetRegs (TVEncoderObj *this, TVEncoderRegs *r, TVState state);
void TVBtSetState (TVEncoderObj *this, TVEncoderRegs *r, TVState state);

char *TVDetectBrooktree (I2CDevPtr dev, TVChip *encoder, TVState state);

extern TVEncoderObj tvBtTemplate;

#endif /* _TV_BT_H */
