/* NVTV Philips TV-I2C header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: tv_ph.h,v 1.5 2002/03/20 18:39:32 hsalokor Exp $
 *
 * Contents:
 *
 * Header: Routines to access the Brooktree chip registers via the I2C bus.
 *
 */

#ifndef _TV_PH2_H
#define _TV_PH2_H

#include "tv_chip.h"
#include "tv_common.h"

void TVPh2InitRegs (TVEncoderObj *this, int flags);
void TVPh2SetRegs (TVEncoderObj *this, TVEncoderRegs *r, TVState state);
void TVPh2SetState (TVEncoderObj *this, TVEncoderRegs *r, TVState state);
long TVPh2GetStatus (TVEncoderObj *this, int index);
TVConnect TVPh2GetConnect (TVEncoderObj *this);
void TVPh2SetHWConfig (TVEncoderObj *this, int config);
void TVPh2GetHWConfig (TVEncoderObj *this, int *config);

extern TVEncoderObj tvPh2Template;

#endif /* _TV_PH2_H */
