// see License.txt for copyright and terms of use

// Process command-line arguments.

#ifndef QUAL_CMD_H
#define QUAL_CMD_H

#include "oink_cmd.h"
#include "oink_file.h"          // File

class QualCmd : public virtual OinkCmd {
  public:
  // cqual arguments
  char *config;                 // lattice configuration file

  // FIX: test this; it should produce some output under some
  // circumstances.  With print quals graph?
  int hotspots;

  bool print_quals_graph;       // works
  bool strict_const;            // works
  bool casts_preserve;          // works
  bool use_const_subtyping;     // works
  bool flow_sensitive;          // waiting for cqual people to get it done
  bool ugly;                    // works
  bool poly;                    // works; passed to polymorphic backend

  // qual arguments

  // Literals to attach to the generic thrown qvar.  This is sort of
  // qualifiers for a generic catch clause.
  ASTList<char> catchQuals;

  bool inference;               // do inference
  bool print_trans_qual;        // print with transitive qualifier deductions
  bool name_expressions;        // whether to name expressions
  bool name_vars;               // whether to name variables
  bool name_if_missing;         // whether to name unnamed items

  // when casting between function types, keep going down into their
  // return and parameter types
  bool casts_preserve_below_functions;

  // do we insert structural edges?
  bool flow_compoundUp;         // edge up from var to compound
  bool flow_compoundDown;       // compound edge down
  bool flow_pointUp;            // edge up from pointed-to to pointer
  bool flow_pointDown;          // pointer edge down
  bool flow_refUp;              // edge up from refered-to to ref
  bool flow_refDown;            // ref edge down

  bool explain_errors;          // print bad dataflow path when one is found
  int max_errors;               // max errors
  bool ret_inf;                 // exit with error code when a qualifier inconsistency is detected
  bool name_with_loc;           // type names should contain a location string also
  bool name_with_serialno;      // type names should contain a serial number also

  bool merge_ref_ptr_qvars;     // whether to merge ref and ptr qvars instead of unifying

  // compactify graph before serialization
  enum { CG_NEVER, CG_ALWAYS, CG_IFSRZ } compactify_graph;

  // module analysis flags
  bool module_access;           // do the module access analysis
  bool module_write;            // do the module write analysis
  bool module_trust;            // do the module trust analysis

  QualCmd();

  virtual void readEnvironment();

  void readOneArg(int &argc, char **&argv);
  void dump();
  void printHelp();
  void initializeFromFlags();

  // convenience methods
  bool doCompactifyGraph() {
    return
      compactify_graph == QualCmd::CG_ALWAYS ||
      (compactify_graph == QualCmd::CG_IFSRZ && !srz.empty());
  }
};

#endif // QUAL_CMD_H
