// see License.txt for copyright and terms of use

#include "value_ast_visitor.h"  // ValueASTVisitor
#include "oink_global.h"        // ValueFactory *valueFactory

// make values for every Expression
bool ValueASTVisitor::visitExpression(Expression *expr) {
  // FIX: why can this happen?
//    xassert(!expr->abstrValue);

  bool isE_variable0 = expr->isE_variable();
  // make sure that if this is a variable that it is a non-template
  // one
  if (isE_variable0) {
    xassert(expr->asE_variable()->var->getReal());
  }

  // FIX: There are Expressions without a Type.  18 april 2005 Scott
  // said he was fixing this but he didn't get them all.
  if (expr->type && !expr->abstrValue) {
    // optimization
    if (oinkCmd->merge_E_variable_and_var_values && isE_variable0) {
      // re-use the Variable's [abstract] Value rather than create our
      // own and merge it later in the dataflow
      Variable_O *var = asVariable_O(expr->asE_variable()->var);
      Value *varValue = var->abstrValue();
      bool const varIsRef = var->type->isReferenceType();
      bool const exprIsRef = expr->type->isReferenceType();
      if (exprIsRef == varIsRef) {
        expr->abstrValue = varValue;
      } else if (exprIsRef && !varIsRef) {
        expr->abstrValue = varValue->asLval();
      } else if (!exprIsRef && varIsRef) {
        xfailure("not sure this can happen");
      } else {
        xfailure("can't happen");
      }
    } else {
      expr->abstrValue = vFac->buildValue(expr->type, loc);
    }
  }
  return true;
}

bool ValueASTVisitor::visitFunction(Function *func) {
  xassert(func->funcType);
  Variable_O *var = asVariable_O(func->nameAndParams->var);
  xassert(var->getReal());
  xassert(!func->abstrValue);
  if (var->filteredOut()) return false;
  // annotate with Value
  func->abstrValue = vFac->buildValue(func->funcType, loc);
  // This is taken from ElabVisitor::elaborateFunctionStart()
  FunctionValue *ft = func->abstrValue->asFunctionValue();
  if (ft->retValue->t()->isCompoundType()) {
    ft->registerRetVar(func->retVar);
  }
  return true;
}

bool ValueASTVisitor::visitDeclarator(Declarator *decltor) {
  xassert(decltor->type);
  Variable_O *var = asVariable_O(decltor->var);
  xassert(var->getReal());
  xassert(!decltor->abstrValue);
  if (var->filteredOut()) return false;
  // annotate with Value
  decltor->abstrValue = vFac->buildValue(decltor->type, loc);
  return true;
}

// **** keep the loc member up to date

bool ValueASTVisitor::visitTopForm(TopForm *obj) {
  loc = obj->loc;
  return true;
}

bool ValueASTVisitor::visitPQName(PQName *obj) {
  loc = obj->loc;
  return true;
}

bool ValueASTVisitor::visitTypeSpecifier(TypeSpecifier *obj) {
  loc = obj->loc;
  return true;
}

bool ValueASTVisitor::visitEnumerator(Enumerator *obj) {
  loc = obj->loc;
  return true;
}

bool ValueASTVisitor::visitMember(Member *obj) {
  loc = obj->loc;
  return true;
}

bool ValueASTVisitor::visitIDeclarator(IDeclarator *obj) {
  loc = obj->loc;
  return true;
}

bool ValueASTVisitor::visitStatement(Statement *obj) {
  loc = obj->loc;
  return true;
}

bool ValueASTVisitor::visitInitializer(Initializer *obj) {
  loc = obj->loc;
  return true;
}

bool ValueASTVisitor::visitTemplateParameter(TemplateParameter *obj) {
  loc = obj->loc;
  return true;
}
