#Create the table for user accounts
Create table T_DDX_ACCOUNTS (
ACCOUNT_ID BIGINT(10) UNSIGNED UNIQUE NOT NULL,
Primary Key (ACCOUNT_ID),
ACCOUNT_NM VARCHAR(50) NOT NULL,
ACCOUNT_PASS_NM VARCHAR(30) NOT NULL,
ACCOUNT_FULL_NM VARCHAR(80),
ACCOUNT_ROLE_NM VARCHAR(30),
ACCOUNT_CREATED_BY_ID VARCHAR(30) NOT NULL,
ACCOUNT_CREATED_DT DATETIME,
ACCOUNT_UPDATED_BY_ID VARCHAR(30),
ACCOUNT_UPDATED_DT DATETIME
) TYPE = InnoDB;

#Create the index on account name
create unique index DDX_ACCOUNTS_NAME_I ON T_DDX_ACCOUNTS (ACCOUNT_NM);

#Create the sequence for the project (we don't use auto_increment fields
# in tables, for compatibility with Oracle
Create table DDX_SEQ (
 SEQ_NB BIGINT(10) UNSIGNED UNIQUE NOT NULL AUTO_INCREMENT
 ) TYPE = InnoDB;

#Put in the first sequence number
INSERT INTO DDX_SEQ VALUES(NULL);

# The command below inserts one account record in the table.
# It assumes that you have enabled encoded passwords via the in the dougdocx.properties file via the
# AccountPasswordsEncoded=true property.
# When decoded, the password below is "admin"
INSERT INTO T_DDX_ACCOUNTS VALUES ( 1 , 'admin' , 'YWRtaW4=' , 'DougDocX Administrator' , 'ADMIN' , 'batch' , SYSDATE() , null , null);

# if not, use this:
