/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: pntobj3d.hxx,v $
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _E3D_PNTOBJ3D_HXX
#define _E3D_PNTOBJ3D_HXX

#include <svx/obj3d.hxx>
#include "svx/svxdllapi.h"

/*************************************************************************
|*
|* Klasse fuer einzelne dreidimensionale Punkte
|*
\************************************************************************/

class SVX_DLLPUBLIC E3dPointObj : public E3dObject
{
 protected:
	basegfx::B3DPoint		aPosition;
	basegfx::B3DPoint		aTransPos;

	sal_Bool	bTransPosValid	: 1;

	virtual void SetTransformChanged();

 public:
	TYPEINFO();
	E3dPointObj(const basegfx::B3DPoint& rPos);
	E3dPointObj();

	virtual UINT16 GetObjIdentifier() const;

	virtual void SetPosition(const basegfx::B3DPoint& rNewPos);
	const basegfx::B3DPoint& GetPosition() const { return aPosition; }
	const basegfx::B3DPoint& GetTransPosition();

	virtual void operator=(const SdrObject&);
};

#endif			// _E3D_PNTOBJ3D_HXX
