/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: SlsPageNotificationObjectContact.cxx,v $
 * $Revision: 1.11 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"

#include "view/SlsPageNotificationObjectContact.hxx"

#include <svx/svdpage.hxx>
#include <svx/sdr/contact/viewobjectcontact.hxx>
#include <com/sun/star/uno/RuntimeException.hpp>

namespace sd { namespace slidesorter { namespace view {

PageNotificationObjectContact::PageNotificationObjectContact (
    SdrPage& rBroadcaster,
    ::sdr::contact::ViewObjectContact& rListener)
    : ObjectContactPainter(sal_False),
      mrBroadcaster(rBroadcaster),
      mrListener(rListener)
{
    mbIsPreviewRenderer = sal_True;
}




PageNotificationObjectContact::~PageNotificationObjectContact (void)
{
}




sal_uInt32 PageNotificationObjectContact::GetPaintObjectCount (void) const
{
    return 1;
}




::sdr::contact::ViewContact& PageNotificationObjectContact::GetPaintObjectViewContact (
    sal_uInt32 nIndex) const
{
    if (nIndex!=0)
    {
        OSL_ASSERT(nIndex==0);
        throw new ::com::sun::star::uno::RuntimeException(
            ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                "PageNotificationObjectContact: IllegalArgument nIndex!=0")),
            NULL);
    }
    else
        return mrBroadcaster.GetViewContact();
}




void PageNotificationObjectContact::InvalidatePartOfView (const Rectangle& ) const
{
    mrListener.ActionChanged();
}




void PageNotificationObjectContact::EnsureValidDrawHierarchy (
    ::sdr::contact::DisplayInfo& rDisplayInfo)
{
    return ObjectContactPainter::EnsureValidDrawHierarchy(rDisplayInfo);
}

} } } // end of namespace ::sd::slidesorter::view
