/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: measctrl.hxx,v $
 * $Revision: 1.6 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef _SVX_MEASCTRL_HXX
#define _SVX_MEASCTRL_HXX

// include ---------------------------------------------------------------

#ifndef _CTRL_HXX //autogen
#include <vcl/ctrl.hxx>
#endif
#include "svx/svxdllapi.h"


class SfxItemSet;

class XOutputDevice;
class SdrMeasureObj;
class SdrModel;

/*************************************************************************
|*
|* SvxXMeasurePreview
|*
\************************************************************************/
class SVX_DLLPUBLIC SvxXMeasurePreview : public Control
{
 friend class SvxMeasurePage;

private:
	const SfxItemSet&	rAttrs;
	XOutputDevice*	pExtOutDev;
	SdrMeasureObj*		pMeasureObj;
	SdrModel*           pModel;

public:
			SvxXMeasurePreview( Window* pParent, const ResId& rResId,
								const SfxItemSet& rInAttrs );
			~SvxXMeasurePreview();

	virtual void Paint( const Rectangle& rRect );
	virtual void MouseButtonDown( const MouseEvent& rMEvt );

	void		 SetAttributes( const SfxItemSet& rInAttrs );

	virtual void DataChanged( const DataChangedEvent& rDCEvt );
};

#endif

