/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: viewcontactpainthelper.hxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SDR_CONTACT_VIEWCONTACTPAINTHELPER_HXX
#define _SDR_CONTACT_VIEWCONTACTPAINTHELPER_HXX

#include <svx/sdr/contact/displayinfo.hxx>

//////////////////////////////////////////////////////////////////////////////
// predeclarations
class SdrObject;
class SfxItemSet;

namespace sdr
{
	namespace contact
	{
		class ViewContact;
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// ViewContact Paint helpers

namespace sdr
{
	namespace contact
	{
		// process the BackgroundObject painting
		sal_Bool PaintBackgroundObject(
			ViewContact& rPainter,
			SdrObject& rBackgroundObject,
			DisplayInfo& rDisplayInfo, 
			Rectangle& rPaintRectangle, 
			const ViewObjectContact& rAssociatedVOC);

		// Paint a PageBackgroundObject with the size of the page and the attributes
		// of the given FillProperties
		sal_Bool PaintBackgroundObjectWithItemSet(
			ViewContact& rPainter,
			DisplayInfo& rDisplayInfo, Rectangle& rPaintRectangle,
			const SfxItemSet& rFillProperties);
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_CONTACT_VIEWCONTACTPAINTHELPER_HXX

// eof
