/* The following code was generated by JFlex 1.4.1 on 4/15/08 8:53 AM */

package org.apache.lucene.wikipedia.analysis;

/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.lucene.analysis.Token;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 4/15/08 8:53 AM from the specification file
 * <tt>/tango/mike/src/lucene.23.clean/contrib/wikipedia/src/java/org/apache/lucene/wikipedia/analysis/WikipediaTokenizerImpl.jflex</tt>
 */
class WikipediaTokenizerImpl {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int DOUBLE_BRACE_STATE = 7;
  public static final int INTERNAL_LINK_STATE = 2;
  public static final int TWO_SINGLE_QUOTES_STATE = 4;
  public static final int CATEGORY_STATE = 1;
  public static final int FIVE_SINGLE_QUOTES_STATE = 5;
  public static final int STRING = 8;
  public static final int YYINITIAL = 0;
  public static final int DOUBLE_EQUALS_STATE = 6;
  public static final int THREE_SINGLE_QUOTES_STATE = 5;
  public static final int EXTERNAL_LINK_STATE = 3;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\24\1\23\1\0\1\24\1\22\22\0\1\24\1\0\1\12"+
    "\1\53\2\0\1\3\1\1\4\0\1\14\1\5\1\2\1\10\12\16"+
    "\1\27\1\0\1\7\1\11\1\13\1\53\1\4\2\15\1\30\5\15"+
    "\1\41\21\15\1\25\1\0\1\26\1\0\1\6\1\0\1\31\1\43"+
    "\2\15\1\33\1\40\1\34\1\50\1\41\4\15\1\42\1\35\1\51"+
    "\1\15\1\36\1\52\1\32\3\15\1\44\1\37\1\15\1\45\1\47"+
    "\1\46\102\0\27\15\1\0\37\15\1\0\u0568\15\12\17\206\15\12\17"+
    "\u026c\15\12\17\166\15\12\17\166\15\12\17\166\15\12\17\166\15\12\17"+
    "\167\15\11\17\166\15\12\17\166\15\12\17\166\15\12\17\340\15\12\17"+
    "\166\15\12\17\u0166\15\12\17\266\15\u0100\15\u0e00\15\u1040\0\u0150\21\140\0"+
    "\20\21\u0100\0\200\21\200\0\u19c0\21\100\0\u5200\21\u0c00\0\u2bb0\20\u2150\0"+
    "\u0200\21\u0465\0\73\21\75\15\43\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\11\0\4\1\4\2\1\3\1\1\1\4\2\1\1\5"+
    "\1\1\1\6\1\1\2\7\1\10\1\11\1\10\1\12"+
    "\1\13\1\7\1\14\1\15\1\16\1\17\1\7\1\20"+
    "\1\7\4\21\1\22\1\21\1\23\1\24\1\25\3\0"+
    "\1\26\14\0\1\27\1\30\1\31\1\32\1\10\1\0"+
    "\1\33\1\0\1\34\1\0\1\35\3\0\1\36\1\37"+
    "\2\40\1\37\2\41\2\0\1\40\1\0\14\40\1\37"+
    "\3\0\1\10\1\42\3\0\1\43\1\44\5\0\1\45"+
    "\4\0\1\45\2\0\2\45\2\0\1\10\5\0\1\30"+
    "\1\37\1\40\1\46\3\0\1\10\2\0\1\47\30\0"+
    "\1\50\2\0\1\51\1\52\1\53";

  private static int [] zzUnpackAction() {
    int [] result = new int[178];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\54\0\130\0\204\0\260\0\334\0\u0108\0\u0134"+
    "\0\u0160\0\u018c\0\u01b8\0\u01e4\0\u0210\0\u023c\0\u0268\0\u0294"+
    "\0\u02c0\0\u018c\0\u02ec\0\u0318\0\u0344\0\u0370\0\u039c\0\u03c8"+
    "\0\u03f4\0\u0420\0\u018c\0\u0370\0\u044c\0\u018c\0\u0478\0\u04a4"+
    "\0\u04d0\0\u04fc\0\u0528\0\u0554\0\u0580\0\u05ac\0\u05d8\0\u0604"+
    "\0\u0630\0\u018c\0\u065c\0\u0370\0\u0688\0\u06b4\0\u06e0\0\u070c"+
    "\0\u018c\0\u018c\0\u0738\0\u0764\0\u0790\0\u018c\0\u07bc\0\u07e8"+
    "\0\u0814\0\u0840\0\u086c\0\u0898\0\u08c4\0\u08f0\0\u091c\0\u0948"+
    "\0\u0974\0\u09a0\0\u09cc\0\u09f8\0\u018c\0\u018c\0\u0a24\0\u0a50"+
    "\0\u0a7c\0\u0aa8\0\u0ad4\0\u0b00\0\u0b2c\0\u0b58\0\u0b84\0\u0bb0"+
    "\0\u0bdc\0\u0c08\0\u0c34\0\u0c60\0\u0c8c\0\u0814\0\u0cb8\0\u0ce4"+
    "\0\u0d10\0\u0d3c\0\u0d68\0\u0d94\0\u0dc0\0\u0dec\0\u0e18\0\u0e44"+
    "\0\u0e70\0\u0e9c\0\u0ec8\0\u0ef4\0\u0f20\0\u0f4c\0\u0f78\0\u0fa4"+
    "\0\u0fd0\0\u0ffc\0\u1028\0\u1054\0\u018c\0\u1080\0\u10ac\0\u10d8"+
    "\0\u1104\0\u018c\0\u1130\0\u115c\0\u1188\0\u11b4\0\u11e0\0\u120c"+
    "\0\u1238\0\u1264\0\u1290\0\u12bc\0\u12e8\0\u1314\0\u1340\0\u07e8"+
    "\0\u0974\0\u136c\0\u1398\0\u13c4\0\u13f0\0\u141c\0\u1448\0\u1474"+
    "\0\u14a0\0\u018c\0\u14cc\0\u14f8\0\u1524\0\u1550\0\u157c\0\u15a8"+
    "\0\u15d4\0\u1600\0\u162c\0\u018c\0\u1658\0\u1684\0\u16b0\0\u16dc"+
    "\0\u1708\0\u1734\0\u1760\0\u178c\0\u17b8\0\u17e4\0\u1810\0\u183c"+
    "\0\u1868\0\u1894\0\u18c0\0\u18ec\0\u1918\0\u1944\0\u1970\0\u199c"+
    "\0\u19c8\0\u19f4\0\u1a20\0\u1a4c\0\u1a78\0\u1aa4\0\u1ad0\0\u018c"+
    "\0\u018c\0\u018c";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[178];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\12\1\13\5\12\1\14\1\12\1\15\3\12\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\2\12\1\24\2\12"+
    "\15\16\1\25\2\12\3\16\10\12\1\26\5\12\4\27"+
    "\1\12\1\23\3\12\1\30\1\12\15\27\3\12\3\27"+
    "\10\12\1\26\5\12\4\31\1\12\1\23\3\12\1\32"+
    "\1\12\15\31\3\12\3\31\1\12\7\33\1\34\5\33"+
    "\4\35\1\33\1\23\2\12\1\33\1\36\1\33\15\35"+
    "\3\33\1\37\2\35\2\33\1\40\5\33\1\34\5\33"+
    "\4\41\1\33\1\42\2\33\1\43\2\33\15\41\3\33"+
    "\3\41\10\33\1\34\5\33\4\44\1\33\1\42\2\33"+
    "\1\43\2\33\15\44\3\33\3\44\10\33\1\34\1\33"+
    "\1\45\3\33\4\46\1\33\1\42\5\33\15\46\3\33"+
    "\3\46\10\33\1\47\5\33\4\50\1\33\1\42\5\33"+
    "\15\50\1\33\1\51\1\33\3\50\1\33\1\52\1\53"+
    "\5\52\1\54\1\52\1\55\3\52\4\56\1\52\1\57"+
    "\2\52\1\60\2\52\15\56\2\52\1\61\3\56\1\52"+
    "\55\0\1\62\62\0\1\63\4\0\4\64\7\0\6\64"+
    "\1\65\6\64\3\0\3\64\12\0\1\66\43\0\1\67"+
    "\1\70\1\71\1\72\2\73\1\0\1\74\3\0\1\74"+
    "\1\16\1\17\1\20\1\21\7\0\15\16\3\0\3\16"+
    "\3\0\1\75\1\0\1\76\2\77\1\0\1\100\3\0"+
    "\1\100\3\17\1\21\7\0\15\17\3\0\3\17\2\0"+
    "\1\67\1\101\1\71\1\72\2\77\1\0\1\100\3\0"+
    "\1\100\1\20\1\17\1\20\1\21\7\0\15\20\3\0"+
    "\3\20\3\0\1\102\1\0\1\76\2\73\1\0\1\74"+
    "\3\0\1\74\4\21\7\0\15\21\3\0\3\21\24\0"+
    "\1\12\55\0\1\103\73\0\1\104\16\0\1\63\4\0"+
    "\4\64\7\0\15\64\3\0\3\64\16\0\4\27\7\0"+
    "\15\27\3\0\3\27\27\0\1\105\42\0\4\31\7\0"+
    "\15\31\3\0\3\31\27\0\1\106\42\0\4\35\7\0"+
    "\15\35\3\0\3\35\16\0\4\35\7\0\2\35\1\107"+
    "\12\35\3\0\3\35\2\0\1\110\67\0\4\41\7\0"+
    "\15\41\3\0\3\41\24\0\1\33\55\0\1\111\43\0"+
    "\4\44\7\0\15\44\3\0\3\44\12\0\1\105\57\0"+
    "\4\46\7\0\15\46\3\0\3\46\11\0\1\112\4\0"+
    "\4\64\7\0\15\64\3\0\3\64\16\0\4\50\7\0"+
    "\15\50\3\0\3\50\47\0\1\105\6\0\1\113\63\0"+
    "\1\114\57\0\4\56\7\0\15\56\3\0\3\56\24\0"+
    "\1\52\55\0\1\115\43\0\4\64\7\0\15\64\3\0"+
    "\3\64\14\0\1\33\1\0\4\116\1\0\3\117\3\0"+
    "\15\116\3\0\3\116\14\0\1\33\1\0\4\116\1\0"+
    "\3\117\3\0\3\116\1\120\11\116\3\0\3\116\16\0"+
    "\1\121\1\0\1\121\10\0\15\121\3\0\3\121\16\0"+
    "\1\122\1\123\1\124\1\125\7\0\15\122\3\0\3\122"+
    "\16\0\1\126\1\0\1\126\10\0\15\126\3\0\3\126"+
    "\16\0\1\127\1\130\1\127\1\130\7\0\15\127\3\0"+
    "\3\127\16\0\1\131\2\132\1\133\7\0\15\131\3\0"+
    "\3\131\16\0\1\74\2\134\10\0\15\74\3\0\3\74"+
    "\16\0\1\135\2\136\1\137\7\0\15\135\3\0\3\135"+
    "\16\0\4\130\7\0\15\130\3\0\3\130\16\0\1\140"+
    "\2\141\1\142\7\0\15\140\3\0\3\140\16\0\1\143"+
    "\2\144\1\145\7\0\15\143\3\0\3\143\16\0\1\146"+
    "\1\136\1\147\1\137\7\0\15\146\3\0\3\146\16\0"+
    "\1\150\2\123\1\125\7\0\15\150\3\0\3\150\30\0"+
    "\1\151\1\152\64\0\1\153\27\0\4\35\7\0\2\35"+
    "\1\154\12\35\3\0\3\35\2\0\1\155\101\0\1\156"+
    "\1\157\40\0\4\64\7\0\6\64\1\160\6\64\3\0"+
    "\3\64\2\0\1\161\63\0\1\162\71\0\1\163\1\164"+
    "\34\0\1\165\1\0\1\33\1\0\4\116\1\0\3\117"+
    "\3\0\15\116\3\0\3\116\16\0\4\166\1\0\3\117"+
    "\3\0\15\166\3\0\3\166\12\0\1\165\1\0\1\33"+
    "\1\0\4\116\1\0\3\117\3\0\10\116\1\167\4\116"+
    "\3\0\3\116\2\0\1\67\13\0\1\121\1\0\1\121"+
    "\10\0\15\121\3\0\3\121\3\0\1\170\1\0\1\76"+
    "\2\171\6\0\1\122\1\123\1\124\1\125\7\0\15\122"+
    "\3\0\3\122\3\0\1\172\1\0\1\76\2\173\1\0"+
    "\1\174\3\0\1\174\3\123\1\125\7\0\15\123\3\0"+
    "\3\123\3\0\1\175\1\0\1\76\2\173\1\0\1\174"+
    "\3\0\1\174\1\124\1\123\1\124\1\125\7\0\15\124"+
    "\3\0\3\124\3\0\1\176\1\0\1\76\2\171\6\0"+
    "\4\125\7\0\15\125\3\0\3\125\3\0\1\177\2\0"+
    "\1\177\7\0\1\127\1\130\1\127\1\130\7\0\15\127"+
    "\3\0\3\127\3\0\1\177\2\0\1\177\7\0\4\130"+
    "\7\0\15\130\3\0\3\130\3\0\1\171\1\0\1\76"+
    "\2\171\6\0\1\131\2\132\1\133\7\0\15\131\3\0"+
    "\3\131\3\0\1\173\1\0\1\76\2\173\1\0\1\174"+
    "\3\0\1\174\3\132\1\133\7\0\15\132\3\0\3\132"+
    "\3\0\1\171\1\0\1\76\2\171\6\0\4\133\7\0"+
    "\15\133\3\0\3\133\3\0\1\174\2\0\2\174\1\0"+
    "\1\174\3\0\1\174\3\134\10\0\15\134\3\0\3\134"+
    "\3\0\1\102\1\0\1\76\2\73\1\0\1\74\3\0"+
    "\1\74\1\135\2\136\1\137\7\0\15\135\3\0\3\135"+
    "\3\0\1\75\1\0\1\76\2\77\1\0\1\100\3\0"+
    "\1\100\3\136\1\137\7\0\15\136\3\0\3\136\3\0"+
    "\1\102\1\0\1\76\2\73\1\0\1\74\3\0\1\74"+
    "\4\137\7\0\15\137\3\0\3\137\3\0\1\73\1\0"+
    "\1\76\2\73\1\0\1\74\3\0\1\74\1\140\2\141"+
    "\1\142\7\0\15\140\3\0\3\140\3\0\1\77\1\0"+
    "\1\76\2\77\1\0\1\100\3\0\1\100\3\141\1\142"+
    "\7\0\15\141\3\0\3\141\3\0\1\73\1\0\1\76"+
    "\2\73\1\0\1\74\3\0\1\74\4\142\7\0\15\142"+
    "\3\0\3\142\3\0\1\74\2\0\2\74\1\0\1\74"+
    "\3\0\1\74\1\143\2\144\1\145\7\0\15\143\3\0"+
    "\3\143\3\0\1\100\2\0\2\100\1\0\1\100\3\0"+
    "\1\100\3\144\1\145\7\0\15\144\3\0\3\144\3\0"+
    "\1\74\2\0\2\74\1\0\1\74\3\0\1\74\4\145"+
    "\7\0\15\145\3\0\3\145\3\0\1\200\1\0\1\76"+
    "\2\73\1\0\1\74\3\0\1\74\1\146\1\136\1\147"+
    "\1\137\7\0\15\146\3\0\3\146\3\0\1\201\1\0"+
    "\1\76\2\77\1\0\1\100\3\0\1\100\1\147\1\136"+
    "\1\147\1\137\7\0\15\147\3\0\3\147\3\0\1\176"+
    "\1\0\1\76\2\171\6\0\1\150\2\123\1\125\7\0"+
    "\15\150\3\0\3\150\31\0\1\152\54\0\1\202\64\0"+
    "\1\203\26\0\4\35\7\0\15\35\3\0\1\35\1\204"+
    "\1\35\31\0\1\157\54\0\1\205\35\0\1\33\1\0"+
    "\4\116\1\0\3\117\3\0\3\116\1\206\11\116\3\0"+
    "\3\116\2\0\1\207\102\0\1\164\54\0\1\210\34\0"+
    "\1\211\52\0\1\165\3\0\4\166\7\0\15\166\3\0"+
    "\3\166\12\0\1\165\1\0\1\212\1\0\4\116\1\0"+
    "\3\117\3\0\15\116\3\0\3\116\16\0\1\213\1\125"+
    "\1\213\1\125\7\0\15\213\3\0\3\213\16\0\4\133"+
    "\7\0\15\133\3\0\3\133\16\0\4\137\7\0\15\137"+
    "\3\0\3\137\16\0\4\142\7\0\15\142\3\0\3\142"+
    "\16\0\4\145\7\0\15\145\3\0\3\145\16\0\1\214"+
    "\1\137\1\214\1\137\7\0\15\214\3\0\3\214\16\0"+
    "\4\125\7\0\15\125\3\0\3\125\16\0\4\215\7\0"+
    "\15\215\3\0\3\215\33\0\1\216\61\0\1\217\30\0"+
    "\4\35\6\0\1\220\15\35\3\0\2\35\1\221\33\0"+
    "\1\222\32\0\1\165\1\0\1\33\1\0\4\116\1\0"+
    "\3\117\3\0\10\116\1\223\4\116\3\0\3\116\2\0"+
    "\1\224\104\0\1\225\36\0\4\226\7\0\15\226\3\0"+
    "\3\226\3\0\1\170\1\0\1\76\2\171\6\0\1\213"+
    "\1\125\1\213\1\125\7\0\15\213\3\0\3\213\3\0"+
    "\1\200\1\0\1\76\2\73\1\0\1\74\3\0\1\74"+
    "\1\214\1\137\1\214\1\137\7\0\15\214\3\0\3\214"+
    "\3\0\1\177\2\0\1\177\7\0\4\215\7\0\15\215"+
    "\3\0\3\215\34\0\1\227\55\0\1\230\26\0\1\231"+
    "\60\0\4\35\6\0\1\220\15\35\3\0\3\35\34\0"+
    "\1\232\31\0\1\165\1\0\1\105\1\0\4\116\1\0"+
    "\3\117\3\0\15\116\3\0\3\116\34\0\1\233\32\0"+
    "\1\234\2\0\4\226\7\0\15\226\3\0\3\226\35\0"+
    "\1\235\62\0\1\236\20\0\1\237\77\0\1\240\53\0"+
    "\1\241\32\0\1\33\1\0\4\166\1\0\3\117\3\0"+
    "\15\166\3\0\3\166\36\0\1\242\53\0\1\243\33\0"+
    "\4\244\7\0\15\244\3\0\3\244\36\0\1\245\53\0"+
    "\1\246\54\0\1\247\61\0\1\250\11\0\1\251\12\0"+
    "\4\244\7\0\15\244\3\0\3\244\37\0\1\252\53\0"+
    "\1\253\54\0\1\254\22\0\1\12\62\0\4\255\7\0"+
    "\15\255\3\0\3\255\40\0\1\256\53\0\1\257\43\0"+
    "\1\260\26\0\2\255\1\0\2\255\1\0\2\255\2\0"+
    "\5\255\7\0\15\255\3\0\4\255\27\0\1\261\53\0"+
    "\1\262\24\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[6908];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\11\0\1\11\7\1\1\11\10\1\1\11\2\1\1\11"+
    "\13\1\1\11\6\1\2\11\3\0\1\11\14\0\2\1"+
    "\2\11\1\1\1\0\1\1\1\0\1\1\1\0\1\1"+
    "\3\0\7\1\2\0\1\1\1\0\15\1\3\0\1\1"+
    "\1\11\3\0\1\1\1\11\5\0\1\1\4\0\1\1"+
    "\2\0\2\1\2\0\1\1\5\0\1\11\3\1\3\0"+
    "\1\1\2\0\1\11\30\0\1\1\2\0\3\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[178];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

public static final int ALPHANUM          = WikipediaTokenizer.ALPHANUM_ID;
public static final int APOSTROPHE        = WikipediaTokenizer.APOSTROPHE_ID;
public static final int ACRONYM           = WikipediaTokenizer.ACRONYM_ID;
public static final int COMPANY           = WikipediaTokenizer.COMPANY_ID;
public static final int EMAIL             = WikipediaTokenizer.EMAIL_ID;
public static final int HOST              = WikipediaTokenizer.HOST_ID;
public static final int NUM               = WikipediaTokenizer.NUM_ID;
public static final int CJ                = WikipediaTokenizer.CJ_ID;
public static final int INTERNAL_LINK     = WikipediaTokenizer.INTERNAL_LINK_ID;
public static final int EXTERNAL_LINK     = WikipediaTokenizer.EXTERNAL_LINK_ID;
public static final int CITATION          = WikipediaTokenizer.CITATION_ID;
public static final int CATEGORY          = WikipediaTokenizer.CATEGORY_ID;
public static final int BOLD              = WikipediaTokenizer.BOLD_ID;
public static final int ITALICS           = WikipediaTokenizer.ITALICS_ID;
public static final int BOLD_ITALICS      = WikipediaTokenizer.BOLD_ITALICS_ID;
public static final int HEADING           = WikipediaTokenizer.HEADING_ID;
public static final int SUB_HEADING       = WikipediaTokenizer.SUB_HEADING_ID;
public static final int EXTERNAL_LINK_URL = WikipediaTokenizer.EXTERNAL_LINK_URL_ID;


private int currentTokType;
private int numBalanced = 0;
private int positionInc = 1;
private int numLinkToks = 0;

public static final String [] TOKEN_TYPES = WikipediaTokenizer.TOKEN_TYPES;

public final int yychar()
{
    return yychar;
}

public final int getPositionIncrement(){
  return positionInc;
}

/**
 * Fills Lucene token with the current token text.
 */
final void getText(Token t, int tokType) {
  t.setTermBuffer(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  WikipediaTokenizerImpl(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  WikipediaTokenizerImpl(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 230) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int getNextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 7: 
          { /* ignore */
          }
        case 44: break;
        case 3: 
          { positionInc = 1; return CJ;
          }
        case 45: break;
        case 28: 
          { numBalanced = 0;currentTokType = ALPHANUM; yybegin(YYINITIAL);/*end italics*/
          }
        case 46: break;
        case 9: 
          { numLinkToks = 0; positionInc = 0; yybegin(YYINITIAL);
          }
        case 47: break;
        case 4: 
          { positionInc = 1; currentTokType = EXTERNAL_LINK_URL; yybegin(EXTERNAL_LINK_STATE);
          }
        case 48: break;
        case 39: 
          { numBalanced = 0;currentTokType = ALPHANUM; yybegin(YYINITIAL);/*end bold italics*/
          }
        case 49: break;
        case 11: 
          { currentTokType = ITALICS; yybegin(STRING); return currentTokType;/*italics*/
          }
        case 50: break;
        case 23: 
          { positionInc = 1; currentTokType = INTERNAL_LINK; yybegin(INTERNAL_LINK_STATE);
          }
        case 51: break;
        case 5: 
          { yybegin(CATEGORY_STATE); return currentTokType;
          }
        case 52: break;
        case 36: 
          { numBalanced = 0;currentTokType = ALPHANUM; yybegin(YYINITIAL);/*end sub header*/
          }
        case 53: break;
        case 8: 
          { if (numLinkToks == 0){positionInc = 0;} else{positionInc = 1;} currentTokType = EXTERNAL_LINK; yybegin(EXTERNAL_LINK_STATE); numLinkToks++; return currentTokType;
          }
        case 54: break;
        case 24: 
          { positionInc = 1; currentTokType = CITATION; yybegin(DOUBLE_BRACE_STATE);
          }
        case 55: break;
        case 22: 
          { positionInc = 1; yybegin(DOUBLE_EQUALS_STATE);
          }
        case 56: break;
        case 41: 
          { positionInc = 1; currentTokType = CATEGORY; yybegin(CATEGORY_STATE);
          }
        case 57: break;
        case 18: 
          { yybegin(STRING); return currentTokType;/* STRING ALPHANUM*/
          }
        case 58: break;
        case 21: 
          { positionInc = 1; if (numBalanced == 0){numBalanced++;yybegin(TWO_SINGLE_QUOTES_STATE);} else{numBalanced = 0;}
          }
        case 59: break;
        case 1: 
          { positionInc = 1;
          }
        case 60: break;
        case 43: 
          { numBalanced = 0;currentTokType = CATEGORY;yybegin(CATEGORY_STATE);
          }
        case 61: break;
        case 25: 
          { yybegin(YYINITIAL);
          }
        case 62: break;
        case 40: 
          { positionInc = 1; yybegin(EXTERNAL_LINK_STATE); return currentTokType;
          }
        case 63: break;
        case 19: 
          { numBalanced = 0;currentTokType = EXTERNAL_LINK;yybegin(EXTERNAL_LINK_STATE);
          }
        case 64: break;
        case 13: 
          { yybegin(STRING);return currentTokType;
          }
        case 65: break;
        case 38: 
          { positionInc = 1; return EMAIL;
          }
        case 66: break;
        case 37: 
          { positionInc = 1; return ACRONYM;
          }
        case 67: break;
        case 17: 
          { /* ignore STRING */
          }
        case 68: break;
        case 42: 
          { currentTokType = CATEGORY;yybegin(CATEGORY_STATE);
          }
        case 69: break;
        case 20: 
          { yybegin(STRING); return currentTokType;/*pipe*/
          }
        case 70: break;
        case 12: 
          { currentTokType = EXTERNAL_LINK;yybegin(EXTERNAL_LINK_STATE);
          }
        case 71: break;
        case 29: 
          { numBalanced = 0;currentTokType = INTERNAL_LINK;yybegin(INTERNAL_LINK_STATE);
          }
        case 72: break;
        case 35: 
          { numBalanced = 0;currentTokType = ALPHANUM;yybegin(YYINITIAL);/*end bold*/
          }
        case 73: break;
        case 16: 
          { yybegin(DOUBLE_BRACE_STATE); return currentTokType;
          }
        case 74: break;
        case 31: 
          { positionInc = 1; return HOST;
          }
        case 75: break;
        case 34: 
          { currentTokType = BOLD_ITALICS;  yybegin(FIVE_SINGLE_QUOTES_STATE);
          }
        case 76: break;
        case 27: 
          { currentTokType = INTERNAL_LINK;yybegin(INTERNAL_LINK_STATE);
          }
        case 77: break;
        case 14: 
          { currentTokType = SUB_HEADING; yybegin(STRING);
          }
        case 78: break;
        case 30: 
          { positionInc = 1; return APOSTROPHE;
          }
        case 79: break;
        case 32: 
          { positionInc = 1; return NUM;
          }
        case 80: break;
        case 15: 
          { currentTokType = HEADING; yybegin(DOUBLE_EQUALS_STATE); return currentTokType;
          }
        case 81: break;
        case 6: 
          { yybegin(INTERNAL_LINK_STATE); return currentTokType;
          }
        case 82: break;
        case 2: 
          { positionInc = 1; return ALPHANUM;
          }
        case 83: break;
        case 33: 
          { positionInc = 1; return COMPANY;
          }
        case 84: break;
        case 10: 
          { currentTokType = BOLD;  yybegin(THREE_SINGLE_QUOTES_STATE);
          }
        case 85: break;
        case 26: 
          { numLinkToks = 0; yybegin(YYINITIAL);
          }
        case 86: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            return YYEOF;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
