/**
 * ===========================================
 * LibBase : a free Java utility library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libbase
 *
 * (C) Copyright 2007,2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * IOUtilsTest
 * ------------
 * (C) Copyright 2006, by Pentaho Corporation.
 */



package org.pentaho.reporting.libraries.util;

import junit.framework.TestCase;
import org.pentaho.reporting.libraries.base.util.IOUtils;

/**
 * Todo: Document Me
 *
 * @author Thomas Morgner
 */
public class IOUtilsTest extends TestCase
{
  public IOUtilsTest(final String s)
  {
    super(s);
  }

  public void testGetAbsolutePath()
  {
    assertEquals ("content.xml", IOUtils.getInstance().getAbsolutePath("content.xml", "")); // expect: content.xml
    assertEquals ("directory/content.xml", IOUtils.getInstance().getAbsolutePath("content.xml", "directory/")); // expect: directory/content.xml
    assertEquals ("content.xml", IOUtils.getInstance().getAbsolutePath("content.xml", "directory")); // expect: content.xml
    assertEquals ("content.xml", IOUtils.getInstance().getAbsolutePath("../content.xml", "")); // expect: content.xml
    assertEquals ("content.xml", IOUtils.getInstance().getAbsolutePath("../content.xml", "directory/")); // expect: content.xml
    assertEquals ("content.xml", IOUtils.getInstance().getAbsolutePath("../content.xml", "directory")); // expect: content.xml
    assertEquals ("content.xml", IOUtils.getInstance().getAbsolutePath("/content.xml", "")); // expect: content.xml
    assertEquals ("content.xml", IOUtils.getInstance().getAbsolutePath("/content.xml", "directory/")); // expect: content.xml
    assertEquals ("content.xml", IOUtils.getInstance().getAbsolutePath("/content.xml", "directory")); // expect: content.xml
    assertEquals ("content.xml", IOUtils.getInstance().getAbsolutePath("/../content.xml", "")); // expect: content.xml
    assertEquals ("content.xml", IOUtils.getInstance().getAbsolutePath("/../content.xml", "directory/")); // expect: content.xml
    assertEquals ("content.xml", IOUtils.getInstance().getAbsolutePath("/../content.xml", "directory")); // expect: content.xml
    assertEquals ("content.xml", IOUtils.getInstance().getAbsolutePath("test/../content.xml", "")); // expect: content.xml
    assertEquals ("directory/content.xml", IOUtils.getInstance().getAbsolutePath("test/../content.xml", "directory/")); // expect: directory/content.xml
    assertEquals ("content.xml", IOUtils.getInstance().getAbsolutePath("test/../content.xml", "directory")); // expect: content.xml

    assertEquals ("content/", IOUtils.getInstance().getAbsolutePath("/content/", "")); // expect: content.xml
    assertEquals ("content/", IOUtils.getInstance().getAbsolutePath("/content/", "directory/")); // expect: content.xml
    assertEquals ("content/", IOUtils.getInstance().getAbsolutePath("/content/", "directory")); // expect: content.xml

  }
}
