/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * AfmParseUtilities.java
 * ------------
 */

package org.pentaho.reporting.libraries.fonts.afm;

import java.io.IOException;
import java.util.StringTokenizer;

/**
 * Creation-Date: 22.07.2007, 16:38:32
 *
 * @author Thomas Morgner
 */
public class AfmParseUtilities
{
  private AfmParseUtilities()
  {
  }

  public static int parseInt (final String key, final String wholeLine) throws IOException
  {
    try
    {
      return Integer.parseInt(wholeLine.substring(key.length()).trim());
    }
    catch(Exception e)
    {
      throw new IOException("Failed to parse value for Line '" + wholeLine + '\'');
    }
  }

  public static double parseDouble (final String key, final String wholeLine) throws IOException
  {
    try
    {
      return Double.parseDouble(wholeLine.substring(key.length()).trim());
    }
    catch(Exception e)
    {
      throw new IOException("Failed to parse value for Line '" + wholeLine + '\'');
    }
  }

  public static double[] parseDoubleArray(final String line, final int size) throws IOException
  {
    final StringTokenizer strtok = new StringTokenizer(line);
    if (strtok.countTokens() != (size + 1))
    {
      throw new IOException("Invalid array specification: " + line);
    }
    strtok.nextToken();
    try
    {
      final double[] retval = new double[size];
      for (int i = 0; i < size; i++)
      {
        retval[i] = Double.parseDouble(strtok.nextToken());
      }
      return retval;
    }
    catch (Exception e)
    {
      throw new IOException("Invalid array specification: " + line);
    }
  }
}
