/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: numpara.hxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef _NUMPARA_HXX
#define _NUMPARA_HXX

#include "numrule.hxx"
#ifndef _NDARR_HXX //autogen
#include "ndarr.hxx"
#endif
#include "ndindex.hxx"
namespace binfilter {

class SwTxtNode;
class SwDoc;
class SwNumSection;
class SwNodes;

class _NumPara
{
	const SwNumSection& rNumSection;

	void _Init();

public:
	SwNodeIndex aNdIdx;
	ULONG nCnt;
	SwNum aNum;
	char nDiff;				// +1, 0, -1 !! dafuer reicht ein char !!
	BYTE nOldLevel;
	BOOL bInitNum : 1;
	BOOL bWasUndo : 1;
	BOOL bOverTbl : 1;		// Flag fuer ForEach-Methoden, Tabelle ueberspr.

	_NumPara( char nOffset, const SwNodeIndex& rNdIdx,
				const SwNumSection& rSect, ULONG nCntNodes );
	_NumPara( const SwNodeIndex& rNdIdx, const SwNumSection& rSect );
	~_NumPara();

	void UpdateNum( SwTxtNode& rTxtNd );
};

// Funktion fuer ForEach am Nodes-Array
BOOL _NumUpDown( const SwNodePtr& rpNode, void* pPara );


} //namespace binfilter
#endif	// _NUMPARA_HXX
