/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: breakhdl.cxx,v $
 * $Revision: 1.12 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_xmloff.hxx"
#include <breakhdl.hxx>
#include <xmloff/xmltoken.hxx>
#include <xmloff/xmluconv.hxx>
#include <rtl/ustrbuf.hxx>
#include <com/sun/star/style/BreakType.hpp>
#include <com/sun/star/uno/Any.hxx>

#ifndef _XMLOFF_XMLEMENT_HXX
#include <xmloff/xmlelement.hxx>
#endif

using ::rtl::OUString;
using ::rtl::OUStringBuffer;

using namespace ::com::sun::star;
using namespace ::xmloff::token;

SvXMLEnumMapEntry pXML_BreakTypes[] =
{
	{ XML_AUTO,	        0 },
	{ XML_COLUMN,       1 },
	{ XML_PAGE,         2 },
	{ XML_EVEN_PAGE,    2 },
	{ XML_ODD_PAGE,     2 },
	{ XML_TOKEN_INVALID, 0}
};

///////////////////////////////////////////////////////////////////////////////
//
// class XMLFmtBreakBeforePropHdl
//

XMLFmtBreakBeforePropHdl::~XMLFmtBreakBeforePropHdl()
{
	// Nothing to do
}

sal_Bool XMLFmtBreakBeforePropHdl::importXML( const OUString& rStrImpValue, uno::Any& rValue, const SvXMLUnitConverter& ) const
{ 
	sal_uInt16 nEnum;
	sal_Bool bRet = SvXMLUnitConverter::convertEnum( nEnum, rStrImpValue, pXML_BreakTypes );
	if( bRet )
	{
        style::BreakType eBreak;
        switch ( nEnum )
        {
        case 0:
            eBreak = style::BreakType_NONE;
            break;
        case 1:
            eBreak = style::BreakType_COLUMN_BEFORE;
            break;
        default:
            eBreak = style::BreakType_PAGE_BEFORE;
            break;
        }
		rValue <<= eBreak;
	}

	return bRet; 
}

sal_Bool XMLFmtBreakBeforePropHdl::exportXML( OUString& rStrExpValue, const uno::Any& rValue, const SvXMLUnitConverter& ) const
{ 
	style::BreakType eBreak;

	if( !( rValue >>= eBreak ) )
	{
		sal_Int32 nValue = 0;
		if( !( rValue >>= nValue ) )
			return sal_False;

		eBreak = (style::BreakType) nValue;
	}
	
	sal_uInt16 nEnum = 0;
	switch( eBreak )
	{
		case style::BreakType_COLUMN_BEFORE:
			nEnum = 1;
			break;
		case style::BreakType_PAGE_BEFORE:
			nEnum = 2;
			break;
		case style::BreakType_NONE:
			nEnum = 0;
			break;
		default:
			return sal_False;
	}
	
	OUStringBuffer aOut;
	/* sal_Bool bOk = */ SvXMLUnitConverter::convertEnum( aOut, nEnum, pXML_BreakTypes );
	rStrExpValue = aOut.makeStringAndClear();

	return sal_True;
}

///////////////////////////////////////////////////////////////////////////////
//
// class XMLFmtBreakBeforePropHdl
//

XMLFmtBreakAfterPropHdl::~XMLFmtBreakAfterPropHdl()
{
	// Nothing to do
}

sal_Bool XMLFmtBreakAfterPropHdl::importXML( const OUString& rStrImpValue, uno::Any& rValue, const SvXMLUnitConverter& ) const
{ 
	sal_uInt16 nEnum;
	sal_Bool bRet = SvXMLUnitConverter::convertEnum( nEnum, rStrImpValue, pXML_BreakTypes );
	if( bRet )
	{
        style::BreakType eBreak;
        switch ( nEnum )
        {
        case 0:
            eBreak = style::BreakType_NONE;
            break;
        case 1:
            eBreak = style::BreakType_COLUMN_AFTER;
            break;
        default:
            eBreak = style::BreakType_PAGE_AFTER;
            break;
        }
		rValue <<= eBreak;
	}

	return bRet; 
}

sal_Bool XMLFmtBreakAfterPropHdl::exportXML( OUString& rStrExpValue, const uno::Any& rValue, const SvXMLUnitConverter& ) const
{ 
	style::BreakType eBreak;

	if( !( rValue >>= eBreak ) )
	{
		sal_Int32 nValue = 0;
		if( !( rValue >>= nValue ) )
			return sal_False;

		eBreak = (style::BreakType) nValue;
	}
	
	sal_uInt16 nEnum = 0;
	switch( eBreak )
	{
		case style::BreakType_COLUMN_AFTER:
			nEnum = 1;
			break;
		case style::BreakType_PAGE_AFTER:
			nEnum = 2;
			break;
		case style::BreakType_NONE:
			nEnum = 0;
			break;
		default:
			return sal_False;
	}
	
	OUStringBuffer aOut;
	/* sal_Bool bOk = */ SvXMLUnitConverter::convertEnum( aOut, nEnum, pXML_BreakTypes );
	rStrExpValue = aOut.makeStringAndClear();

	return sal_True;
}
