 /*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: accnotextframe.cxx,v $
 * $Revision: 1.13 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"


#include <vos/mutex.hxx>
#include <vcl/svapp.hxx>
#include <com/sun/star/accessibility/AccessibleRole.hpp>
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#include <unotools/accessiblestatesethelper.hxx>
#include <frmfmt.hxx>
#include <ndnotxt.hxx>
#include <flyfrm.hxx>
#include <cntfrm.hxx>
#include "accnotextframe.hxx"

using namespace ::com::sun::star;
using namespace ::com::sun::star::accessibility;
using ::rtl::OUString;

const SwNoTxtNode *SwAccessibleNoTextFrame::GetNoTxtNode() const
{
	const SwNoTxtNode *pNd  = 0;
	const SwFlyFrm *pFlyFrm = static_cast< const SwFlyFrm *>( GetFrm() );
	if( pFlyFrm->Lower() && pFlyFrm->Lower()->IsNoTxtFrm() )
	{
		const SwCntntFrm *pCntFrm =
			static_cast<const SwCntntFrm *>( pFlyFrm->Lower() );
		pNd = pCntFrm->GetNode()->GetNoTxtNode();
	}

	return pNd;
}

SwAccessibleNoTextFrame::SwAccessibleNoTextFrame(
        SwAccessibleMap* pInitMap,
        sal_Int16 nInitRole,
        const SwFlyFrm* pFlyFrm  ) :
    SwAccessibleFrameBase( pInitMap, nInitRole, pFlyFrm ),
	aDepend( this, const_cast < SwNoTxtNode * >( GetNoTxtNode() ) )
{
	const SwNoTxtNode *pNd = GetNoTxtNode();
	if( pNd )
		sDesc = OUString( pNd->GetAlternateText() );
	if( !sDesc.getLength() )
		sDesc = GetName();
}

SwAccessibleNoTextFrame::~SwAccessibleNoTextFrame()
{
}

void SwAccessibleNoTextFrame::Modify( SfxPoolItem *pOld, SfxPoolItem *pNew)
{
	SwAccessibleFrameBase::Modify( pOld, pNew );

	sal_uInt16 nWhich = pOld ? pOld->Which() : pNew ? pNew->Which() : 0 ;
	const SwNoTxtNode *pNd = GetNoTxtNode();
	ASSERT( pNd == aDepend.GetRegisteredIn(), "invalid frame" );
	switch( nWhich )
	{
	case RES_NAME_CHANGED:
		if( pNd->GetAlternateText().Len() )
			break;
	case RES_ALT_TEXT_CHANGED:
		if( pNd && GetFrm() )
		{
			OUString sOldDesc( sDesc );

			const String& rDesc = pNd->GetAlternateText();
			sDesc = rDesc;
			if( !sDesc.getLength() )
				sDesc = GetName();

			if( sDesc != sOldDesc )
			{
				AccessibleEventObject aEvent;
				aEvent.EventId = AccessibleEventId::DESCRIPTION_CHANGED;
				aEvent.OldValue <<= sOldDesc;
				aEvent.NewValue <<= sDesc;
				FireAccessibleEvent( aEvent );
			}
		}
		break;
		/*
	case RES_OBJECTDYING:
		if( aDepend.GetRegisteredIn() ==
				static_cast< SwModify *>( static_cast< SwPtrMsgPoolItem * >( pOld )->pObject ) )
			const_cast < SwModify *>( aDepend.GetRegisteredIn()->Remove( aDepend );
		break;

	case RES_FMT_CHG:
		if( static_cast< SwFmtChg * >(pNew)->pChangedFmt == GetRegisteredIn() &&
			static_cast< SwFmtChg * >(pOld)->pChangedFmt->IsFmtInDTOR() )
			pRegisteredIn->Remove( this );
		break;
	*/
	}
}

void SwAccessibleNoTextFrame::Dispose( sal_Bool bRecursive )
{
	vos::OGuard aGuard(Application::GetSolarMutex());

	if( aDepend.GetRegisteredIn() )
		const_cast < SwModify *>( aDepend.GetRegisteredIn() )->Remove( &aDepend );

	SwAccessibleFrameBase::Dispose( bRecursive );
}

OUString SAL_CALL SwAccessibleNoTextFrame::getAccessibleDescription (void)
        throw (uno::RuntimeException)
{
	vos::OGuard aGuard(Application::GetSolarMutex());

	CHECK_FOR_DEFUNC( XAccessibleContext )

	return sDesc;
}



//
// XInterface
//

uno::Any SAL_CALL SwAccessibleNoTextFrame::queryInterface( const uno::Type& aType ) 
    throw (uno::RuntimeException)    
{
    if( aType == 
        ::getCppuType( static_cast<uno::Reference<XAccessibleImage>*>( NULL ) ) )
    {
        uno::Reference<XAccessibleImage> xImage = this;
        uno::Any aAny;
        aAny <<= xImage;
        return aAny;
    }
    else
        return SwAccessibleContext::queryInterface( aType );
}


//====== XTypeProvider ====================================================
uno::Sequence< uno::Type > SAL_CALL SwAccessibleNoTextFrame::getTypes() throw(uno::RuntimeException)
{
	uno::Sequence< uno::Type > aTypes( SwAccessibleFrameBase::getTypes() );

	sal_Int32 nIndex = aTypes.getLength();
	aTypes.realloc( nIndex + 1 );

	uno::Type* pTypes = aTypes.getArray();
	pTypes[nIndex] = ::getCppuType( static_cast< uno::Reference< XAccessibleImage > * >( 0 ) );

	return aTypes;
}


//
// XAccessibleImage
//

// implementation of the XAccessibleImage methods is a no-brainer, as
// all releveant information is already accessible through other
// methods. So we just delegate to those.

OUString SAL_CALL SwAccessibleNoTextFrame::getAccessibleImageDescription() 
    throw ( uno::RuntimeException )
{
    return getAccessibleDescription();
}

sal_Int32 SAL_CALL SwAccessibleNoTextFrame::getAccessibleImageHeight(  ) 
    throw ( uno::RuntimeException )
{
    return getSize().Height;
}

sal_Int32 SAL_CALL SwAccessibleNoTextFrame::getAccessibleImageWidth(  ) 
    throw ( uno::RuntimeException )
{
    return getSize().Width;
}
