package org.pentaho.reporting.libraries.formula.function.information;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeConversionException;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.typing.sequence.AnySequence;

/**
 * This function counts the number of non-empty values in the list of AnySequences provided. A value is non-blank if it
 * contains any content of any type, including an error.
 *
 * @author Cedric Pronzato
 */
public class CountAFunction implements Function
{

  public CountAFunction()
  {
  }

  public String getCanonicalName()
  {
    return "COUNTA";
  }

  public TypeValuePair evaluate(final FormulaContext context, final ParameterCallback parameters) throws EvaluationException
  {
    final int parameterCount = parameters.getParameterCount();

    if (parameterCount == 0)
    {
      throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
    }

    int count = 0;

    for (int paramIdx = 0; paramIdx < parameterCount; paramIdx++)
    {
      try
      {
        final Type type = parameters.getType(paramIdx);
        final Object value = parameters.getValue(paramIdx);
        final Sequence sequence = context.getTypeRegistry().convertToNumberSequence(type, value, false);

        while (sequence.hasNext())
        {
          final Object o = sequence.next();
          if (o != null)
          {
            count++;
          }
        }
      }
      catch (EvaluationException e)
      {
        count++;
      }
    }

    return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(count));
  }
}