!IF "$(CFG)" == ""
CFG=genbrk - Win32 Release
!ENDIF

!IF  "$(CFG)" == "icupkg - Win32 Release"

OUTDIR=.\Release
INTDIR=.\Release
# Begin Custom Macros
OutDir=.\Release
# End Custom Macros

!IF "$(RECURSE)" == "0"

ALL : "$(OUTDIR)\icupkg.exe" "..\..\..\bin\icupkg.exe"

!ELSE

ALL : "toolutil - Win32 Release" "common - Win32 Release" "$(OUTDIR)\icupkg.exe" "..\..\..\bin\icupkg.exe"

!ENDIF

!IF "$(RECURSE)" == "1"
CLEAN :"common - Win32 ReleaseCLEAN" "toolutil - Win32 ReleaseCLEAN"
!ELSE
CLEAN :
!ENDIF
	-@erase "$(INTDIR)\icupkg.obj"
	-@erase "$(INTDIR)\vc60.idb"
	-@erase "$(OUTDIR)\icupkg.exe"
	-@erase "..\..\..\bin\icupkg.exe"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

MTL=midl.exe
CPP=cl.exe
CPP_PROJ=/nologo /MD /Za /W3 $(EXCEPTIONSWITCH) /O2 /I "..\..\common" /I "..\..\i18n" /I "..\toolutil" /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D "_MBCS" /D "_CRT_SECURE_NO_DEPRECATE" /Fo"$(INTDIR)\\" /Fd"$(INTDIR)\\" /FD /c

.c{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cpp{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cxx{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.c{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cpp{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cxx{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

RSC=rc.exe
BSC32=bscmake.exe
BSC32_FLAGS=/nologo /o"$(OUTDIR)\icupkg.bsc"
BSC32_SBRS= \

LINK32=link.exe
LINK32_FLAGS=icuuc.lib icutu.lib /nologo /subsystem:console /incremental:no /pdb:"$(OUTDIR)\icupkg.pdb" /machine:I386 /out:"$(OUTDIR)\icupkg.exe" /libpath:"..\toolutil\Release" /libpath:"..\..\..\lib"
LINK32_OBJS= \
	"$(INTDIR)\icupkg.obj" \
	"..\..\..\lib\icuuc.lib" \
	"..\..\..\lib\icutu.lib"

"$(OUTDIR)\icupkg.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<
	if exist $@.manifest mt.exe -manifest $@.manifest -outputresource:$@;1

TargetPath=.\Release\icupkg.exe
InputPath=.\Release\icupkg.exe
InputName=icupkg
SOURCE="$(InputPath)"

"..\..\..\bin\icupkg.exe" : $(SOURCE) "$(INTDIR)" "$(OUTDIR)"
	<<tempfile.bat
	@echo off
	copy $(TargetPath) ..\..\..\bin
<<


!ELSEIF  "$(CFG)" == "icupkg - Win32 Debug"

OUTDIR=.\Debug
INTDIR=.\Debug
# Begin Custom Macros
OutDir=.\Debug
# End Custom Macros

!IF "$(RECURSE)" == "0"

ALL : "$(OUTDIR)\icupkg.exe" "$(OUTDIR)\icupkg.bsc" "..\..\..\bin\icupkg.exe"

!ELSE

ALL : "toolutil - Win32 Debug" "common - Win32 Debug" "$(OUTDIR)\icupkg.exe" "$(OUTDIR)\icupkg.bsc" "..\..\..\bin\icupkg.exe"

!ENDIF

!IF "$(RECURSE)" == "1"
CLEAN :"common - Win32 DebugCLEAN" "toolutil - Win32 DebugCLEAN"
!ELSE
CLEAN :
!ENDIF
	-@erase "$(INTDIR)\icupkg.obj"
	-@erase "$(INTDIR)\icupkg.sbr"
	-@erase "$(INTDIR)\vc60.idb"
	-@erase "$(INTDIR)\vc60.pdb"
	-@erase "$(OUTDIR)\icupkg.bsc"
	-@erase "$(OUTDIR)\icupkg.exe"
	-@erase "$(OUTDIR)\icupkg.ilk"
	-@erase "$(OUTDIR)\icupkg.pdb"
	-@erase "..\..\..\bin\icupkg.exe"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

MTL=midl.exe
CPP=cl.exe
CPP_PROJ=/nologo   /Za /W3 /Gm $(EXCEPTIONSWITCH) /ZI /Od /I "..\..\common" /I "..\..\i18n" /I "..\toolutil" /D "WIN32" /D "_DEBUG" /D "_CONSOLE" /D "_MBCS" /D "_CRT_SECURE_NO_DEPRECATE" /FR"$(INTDIR)\\" /Fo"$(INTDIR)\\" /Fd"$(INTDIR)\\" /FD /GZ /c

.c{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cpp{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cxx{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.c{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cpp{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cxx{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

RSC=rc.exe
BSC32=bscmake.exe
BSC32_FLAGS=/nologo /o"$(OUTDIR)\icupkg.bsc"
BSC32_SBRS= \
	"$(INTDIR)\icupkg.sbr"

"$(OUTDIR)\icupkg.bsc" : "$(OUTDIR)" $(BSC32_SBRS)
    $(BSC32) @<<
  $(BSC32_FLAGS) $(BSC32_SBRS)
<<

LINK32=link.exe
LINK32_FLAGS=icuucd.lib icutud.lib /nologo /subsystem:console /incremental:yes /pdb:"$(OUTDIR)\icupkg.pdb" /debug /machine:I386 /out:"$(OUTDIR)\icupkg.exe" /libpath:"..\toolutil\Debug" /libpath:"..\..\..\lib"
LINK32_OBJS= \
	"$(INTDIR)\icupkg.obj" \
	"..\..\..\lib\icuucd.lib" \
	"..\..\..\lib\icutud.lib"

"$(OUTDIR)\icupkg.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<
	if exist $@.manifest mt.exe -manifest $@.manifest -outputresource:$@;1

TargetPath=.\Debug\icupkg.exe
InputPath=.\Debug\icupkg.exe
InputName=icupkg
SOURCE="$(InputPath)"

"..\..\..\bin\icupkg.exe" : $(SOURCE) "$(INTDIR)" "$(OUTDIR)"
	<<tempfile.bat
	@echo off
	copy $(TargetPath) ..\..\..\bin
<<

!ENDIF


!IF "$(NO_EXTERNAL_DEPS)" != "1"
!IF EXISTS("icupkg.dep")
!INCLUDE "icupkg.dep"
!ELSE
!MESSAGE Warning: cannot find "icupkg.dep"
!ENDIF
!ENDIF


!IF "$(CFG)" == "icupkg - Win32 Release" || "$(CFG)" == "icupkg - Win32 Debug"
SOURCE=.\icupkg.cpp

!IF  "$(CFG)" == "icupkg - Win32 Release"


"$(INTDIR)\icupkg.obj" : $(SOURCE) "$(INTDIR)"


!ELSEIF  "$(CFG)" == "icupkg - Win32 Debug"


"$(INTDIR)\icupkg.obj"	"$(INTDIR)\icupkg.sbr" : $(SOURCE) "$(INTDIR)"

!ENDIF

!IF  "$(CFG)" == "icupkg - Win32 Release"

"common - Win32 Release" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Release"
   cd "..\tools\icupkg"

"common - Win32 ReleaseCLEAN" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Release" RECURSE=1 CLEAN
   cd "..\tools\icupkg"

!ELSEIF  "$(CFG)" == "icupkg - Win32 Debug"

"common - Win32 Debug" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Debug"
   cd "..\tools\icupkg"

"common - Win32 DebugCLEAN" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Debug" RECURSE=1 CLEAN
   cd "..\tools\icupkg"

!ENDIF

!IF  "$(CFG)" == "icupkg - Win32 Release"

"toolutil - Win32 Release" :
   cd "..\..\tools\toolutil"
   $(MAKE) /$(MAKEFLAGS) /F .\toolutil.mak CFG="toolutil - Win32 Release"
   cd "..\icupkg"

"toolutil - Win32 ReleaseCLEAN" :
   cd "..\..\tools\toolutil"
   $(MAKE) /$(MAKEFLAGS) /F .\toolutil.mak CFG="toolutil - Win32 Release" RECURSE=1 CLEAN
   cd "..\icupkg"

!ELSEIF  "$(CFG)" == "icupkg - Win32 Debug"

"toolutil - Win32 Debug" :
   cd "..\..\tools\toolutil"
   $(MAKE) /$(MAKEFLAGS) /F .\toolutil.mak CFG="toolutil - Win32 Debug"
   cd "..\icupkg"

"toolutil - Win32 DebugCLEAN" :
   cd "..\..\tools\toolutil"
   $(MAKE) /$(MAKEFLAGS) /F .\toolutil.mak CFG="toolutil - Win32 Debug" RECURSE=1 CLEAN
   cd "..\icupkg"

!ENDIF


!ENDIF