
//  (C) Copyright John Maddock 2000. Permission to copy, use, modify, sell and   
//  distribute this software is granted provided this copyright notice appears
//  in all copies. This software is provided "as is" without express or implied
//  warranty, and with no claim as to its suitability for any purpose.

#include "test.hpp"
#include "check_integral_constant.hpp"
#include TYPE_TRAITS(is_fundamental)

TT_TEST_BEGIN(is_fundamental)

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<void>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<void const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<void volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<void const volatile>::value, true);

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<bool>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<bool const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<bool volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<bool const volatile>::value, true);

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<signed char>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<signed char const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<signed char volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<signed char const volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned char>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<char>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned char const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<char const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned char volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<char volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned char const volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<char const volatile>::value, true);

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned short>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<short>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned short const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<short const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned short volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<short volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned short const volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<short const volatile>::value, true);

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned int>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<int>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned int const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<int const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned int volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<int volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned int const volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<int const volatile>::value, true);

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned long>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<long>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned long const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<long const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned long volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<long volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned long const volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<long const volatile>::value, true);

#ifdef BOOST_HAS_LONG_LONG

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned long long>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<long long>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned long long const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<long long const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned long long volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<long long volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned long long const volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<long long const volatile>::value, true);

#endif

#ifdef BOOST_HAS_MS_INT64

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int8>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int8>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int8 const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int8 const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int8 volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int8 volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int8 const volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int8 const volatile>::value, true);

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int16>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int16>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int16 const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int16 const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int16 volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int16 volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int16 const volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int16 const volatile>::value, true);

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int32>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int32>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int32 const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int32 const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int32 volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int32 volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int32 const volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int32 const volatile>::value, true);

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int64>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int64>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int64 const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int64 const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int64 volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int64 volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<unsigned __int64 const volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<__int64 const volatile>::value, true);

#endif

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<float>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<float const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<float volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<float const volatile>::value, true);

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<double>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<double const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<double volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<double const volatile>::value, true);

BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<long double>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<long double const>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<long double volatile>::value, true);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<long double const volatile>::value, true);

//
// cases that should not be true:
//
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<UDT>::value, false);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<test_abc1>::value, false);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<empty_UDT>::value, false);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<float*>::value, false);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<float&>::value, false);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<const float&>::value, false);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<float[2]>::value, false);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<incomplete_type>::value, false);
BOOST_CHECK_INTEGRAL_CONSTANT(::tt::is_fundamental<foo0_t>::value, false);

TT_TEST_END







