!IF "$(CFG)" == ""
CFG=intltest - Win32 Release
!ENDIF

NULL=

!IF  "$(CFG)" == "intltest - Win32 Release"

OUTDIR=.\Release
INTDIR=.\Release
# Begin Custom Macros
OutDir=.\Release
# End Custom Macros

!IF "$(RECURSE)" == "0"

ALL : "$(OUTDIR)\intltest.exe"

!ELSE

ALL : "toolutil - Win32 Release" "i18n - Win32 Release" "common - Win32 Release" "$(OUTDIR)\intltest.exe"

!ENDIF


"$(OUTDIR)" :
    if not exist "$(OUTDIR)" mkdir "$(OUTDIR)"

MTL=midl.exe
CPP=cl.exe
CPP_PROJ=/nologo  /MT /Za /W3 $(EXCEPTIONSWITCH) /Zi /Ox /Ob0 /I "..\..\..\include" /I "..\..\..\source\common" /I "..\..\..\source\i18n" /I "..\..\tools\toolutil" /I "..\..\tools\ctestfw" /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D "_MBCS" /D "_CRT_SECURE_NO_DEPRECATE" /Fo"$(INTDIR)\\" /Fd"$(INTDIR)\\" /FD /c

.c{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cpp{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cxx{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.c{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cpp{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cxx{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

RSC=rc.exe
BSC32=bscmake.exe
BSC32_FLAGS=/nologo /o"$(OUTDIR)\intltest.bsc"
BSC32_SBRS= \

LINK32=link.exe
LINK32_FLAGS=/nologo /subsystem:console /incremental:no /pdb:"$(OUTDIR)\intltest.pdb" /machine:I386 /out:"$(OUTDIR)\intltest.exe" /libpath:"..\..\..\lib"
LINK32_OBJS= \
	$(INTDIR)\aliastst.obj\
	$(INTDIR)\allcoll.obj\
	$(INTDIR)\apicoll.obj\
	$(INTDIR)\astrotst.obj\
	$(INTDIR)\calcasts.obj\
	$(INTDIR)\callimts.obj\
	$(INTDIR)\calregts.obj\
	$(INTDIR)\caltest.obj\
	$(INTDIR)\caltztst.obj\
	$(INTDIR)\canittst.obj\
	$(INTDIR)\citrtest.obj\
	$(INTDIR)\cntabcol.obj\
	$(INTDIR)\convtest.obj\
	$(INTDIR)\cpdtrtst.obj\
	$(INTDIR)\csdetest.obj\
	$(INTDIR)\currcoll.obj\
	$(INTDIR)\dadrcoll.obj\
    $(INTDIR)\dadrcal.obj\
    $(INTDIR)\dadrfmt.obj\
	$(INTDIR)\dcfmapts.obj\
	$(INTDIR)\decoll.obj\
	$(INTDIR)\dtfmapts.obj\
	$(INTDIR)\dtfmrgts.obj\
	$(INTDIR)\dtfmtrtts.obj\
	$(INTDIR)\dtfmttst.obj\
    $(INTDIR)\dtifmtts.obj\
    $(INTDIR)\dtptngts.obj\
	$(INTDIR)\encoll.obj\
	$(INTDIR)\escoll.obj\
	$(INTDIR)\ficoll.obj\
    $(INTDIR)\fldset.obj\
	$(INTDIR)\frcoll.obj\
	$(INTDIR)\g7coll.obj\
	$(INTDIR)\icusvtst.obj\
	$(INTDIR)\idnaconf.obj\
	$(INTDIR)\idnaref.obj\
	$(INTDIR)\incaltst.obj\
	$(INTDIR)\intltest.obj\
	$(INTDIR)\itercoll.obj\
	$(INTDIR)\itformat.obj\
	$(INTDIR)\itmajor.obj\
	$(INTDIR)\itrbbi.obj\
	$(INTDIR)\itrbnf.obj\
	$(INTDIR)\itrbnfp.obj\
	$(INTDIR)\itrbnfrt.obj\
	$(INTDIR)\ittrans.obj\
	$(INTDIR)\itutil.obj\
	$(INTDIR)\jacoll.obj\
	$(INTDIR)\jamotest.obj\
	$(INTDIR)\lcukocol.obj\
	$(INTDIR)\loctest.obj\
	$(INTDIR)\miscdtfm.obj\
	$(INTDIR)\mnkytst.obj\
	$(INTDIR)\msfmrgts.obj\
	$(INTDIR)\nmfmapts.obj\
	$(INTDIR)\nmfmtrt.obj\
	$(INTDIR)\normconf.obj\
	$(INTDIR)\nptrans.obj\
	$(INTDIR)\numfmtst.obj\
	$(INTDIR)\numrgts.obj\
    $(INTDIR)\plurults.obj\
    $(INTDIR)\plurfmts.obj\
	$(INTDIR)\pptest.obj\
	$(INTDIR)\punyref.obj\
	$(INTDIR)\rbbiapts.obj\
	$(INTDIR)\rbbitst.obj\
	$(INTDIR)\regcoll.obj\
	$(INTDIR)\regextst.obj\
	$(INTDIR)\reptest.obj\
	$(INTDIR)\restest.obj\
	$(INTDIR)\restsnew.obj\
	$(INTDIR)\rndmcoll.obj\
	$(INTDIR)\sdtfmtts.obj\
	$(INTDIR)\sfwdchit.obj\
	$(INTDIR)\srchtest.obj\
    $(INTDIR)\ssearch.obj\
	$(INTDIR)\strcase.obj\
	$(INTDIR)\strtest.obj\
	$(INTDIR)\tchcfmt.obj\
	$(INTDIR)\testidn.obj\
	$(INTDIR)\testidna.obj\
	$(INTDIR)\testutil.obj\
	$(INTDIR)\textfile.obj\
	$(INTDIR)\tfsmalls.obj\
	$(INTDIR)\thcoll.obj\
	$(INTDIR)\tmsgfmt.obj\
	$(INTDIR)\tokiter.obj\
	$(INTDIR)\transapi.obj\
	$(INTDIR)\transrt.obj\
	$(INTDIR)\transtst.obj\
	$(INTDIR)\trcoll.obj\
	$(INTDIR)\trnserr.obj\
	$(INTDIR)\tscoll.obj\
	$(INTDIR)\tsdate.obj\
	$(INTDIR)\tsdcfmsy.obj\
	$(INTDIR)\tsdtfmsy.obj\
	$(INTDIR)\tsmthred.obj\
	$(INTDIR)\tsnmfmt.obj\
	$(INTDIR)\tsputil.obj\
	$(INTDIR)\tstnorm.obj\
	$(INTDIR)\tstnrapi.obj\
	$(INTDIR)\tzbdtest.obj\
    $(INTDIR)\tzfmttst.obj\
    $(INTDIR)\tzoffloc.obj\
	$(INTDIR)\tzregts.obj\
    $(INTDIR)\tzrulets.obj\
	$(INTDIR)\tztest.obj\
	$(INTDIR)\ucaconf.obj\
	$(INTDIR)\ucdtest.obj\
	$(INTDIR)\uobjtest.obj\
	$(INTDIR)\usettest.obj\
	$(INTDIR)\ustrtest.obj\
	$(INTDIR)\utxttest.obj\
	$(INTDIR)\uvectest.obj\
	$(INTDIR)\v32test.obj\
	$(INTDIR)\wbnf.obj\
	$(INTDIR)\windttst.obj\
	$(INTDIR)\winnmtst.obj\
	$(INTDIR)\winutil.obj\
	$(INTDIR)\svccoll.obj\
	"..\..\..\lib\icuuc.lib" \
	"..\..\..\lib\icuin.lib" \
	"..\..\..\lib\icutest.lib" \
	"..\..\..\lib\icutu.lib"

"$(OUTDIR)\intltest.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ELSEIF  "$(CFG)" == "intltest - Win32 Debug"
!ENDIF


!IF "$(NO_EXTERNAL_DEPS)" != "1"
!IF EXISTS("intltest.dep")
!INCLUDE "intltest.dep"
!ELSE
!MESSAGE Warning: cannot find "intltest.dep"
!ENDIF
!ENDIF


!IF "$(CFG)" == "intltest - Win32 Release" || "$(CFG)" == "intltest - Win32 Debug"

SOURCE=.\aliastst.cpp
"$(INTDIR)\aliastst.obj": $(SOURCE) "$(INTDIR)" ..\..\i18n\unicode\calendar.h ..\..\i18n\unicode\smpdtfmt.h ..\..\i18n\unicode\datefmt.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\coll.h ..\..\common\unicode\resbund.h

SOURCE=.\allcoll.cpp
"$(INTDIR)\allcoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\sortkey.h

SOURCE=.\apicoll.cpp
CPP_SWITCHES=/nologo  /MT /Za /W3 $(EXCEPTIONSWITCH) /Zi /Ox /Ob0 /I "..\..\..\include" /I "..\..\..\source\common" /I "..\..\..\source\i18n" /I "..\..\tools\toolutil" /I "..\..\tools\ctestfw" /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D "_MBCS" /D "_CRT_SECURE_NO_DEPRECATE" /Fo"$(INTDIR)\\" /Fd"$(INTDIR)\\" /FD /c
"$(INTDIR)\apicoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\i18n\unicode\coleitr.h ..\..\i18n\unicode\sortkey.h ..\..\common\unicode\chariter.h ..\..\common\unicode\schriter.h ..\..\common\unicode\ustring.h ..\..\i18n\unicode\ucol.h
	$(CPP) @<<
  $(CPP_SWITCHES) $(SOURCE)
<<

SOURCE=.\astrotst.cpp
"$(INTDIR)\astrotst.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\utypes.h ..\..\common\unicode\locid.h ..\..\i18n\unicode\simpletz.h

SOURCE=.\calcasts.cpp
"$(INTDIR)\calcasts.obj": $(SOURCE) "$(INTDIR)" ..\..\i18n\unicode\datefmt.h

SOURCE=.\callimts.cpp
"$(INTDIR)\callimts.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\calendar.h ..\..\i18n\unicode\gregocal.h ..\..\i18n\unicode\datefmt.h ..\..\i18n\unicode\smpdtfmt.h

SOURCE=.\calregts.cpp
"$(INTDIR)\calregts.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\gregocal.h ..\..\i18n\unicode\simpletz.h ..\..\i18n\unicode\smpdtfmt.h ..\..\common\unicode\strenum.h

SOURCE=.\caltest.cpp
"$(INTDIR)\caltest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\gregocal.h ..\..\i18n\unicode\smpdtfmt.h ..\..\i18n\unicode\simpletz.h

SOURCE=.\caltztst.cpp
"$(INTDIR)\caltztst.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\smpdtfmt.h

SOURCE=.\canittst.cpp
"$(INTDIR)\canittst.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\caniter.h ..\..\common\unicode\normlzr.h ..\..\common\unicode\uchar.h

SOURCE=.\citrtest.cpp
"$(INTDIR)\citrtest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\chariter.h ..\..\common\unicode\ustring.h ..\..\common\unicode\unistr.h ..\..\common\unicode\schriter.h ..\..\common\unicode\uchriter.h ..\..\common\unicode\uiter.h ..\..\common\unicode\putil.h

SOURCE=.\cntabcol.cpp
"$(INTDIR)\cntabcol.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h

SOURCE=.\convtest.cpp
"$(INTDIR)\convtest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\ucnv.h ..\..\common\unicode\unistr.h ..\..\common\unicode\parsepos.h ..\..\common\unicode\uniset.h ..\..\common\unicode\ustring.h ..\..\common\unicode\ures.h ..\..\tools\ctestfw\unicode\tstdtmod.h

SOURCE=.\cpdtrtst.cpp
"$(INTDIR)\cpdtrtst.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\utypes.h ..\..\i18n\unicode\translit.h ..\..\common\unicode\uniset.h

SOURCE=.\csdetest.cpp
"$(INTDIR)\csdetest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\ucsdet.h ..\..\common\unicode\ucnv.h ..\..\common\unicode\unistr.h ..\..\common\unicode\putil.h

SOURCE=.\currcoll.cpp
"$(INTDIR)\currcoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\sortkey.h

SOURCE=.\dadrcoll.cpp
"$(INTDIR)\dadrcoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\uchar.h ..\..\tools\ctestfw\unicode\tstdtmod.h

SOURCE=.\dcfmapts.cpp
"$(INTDIR)\dcfmapts.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\decimfmt.h ..\..\i18n\unicode\dcfmtsym.h ..\..\common\unicode\parseerr.h

SOURCE=.\decoll.cpp
"$(INTDIR)\decoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\sortkey.h

SOURCE=.\dtfmapts.cpp
"$(INTDIR)\dtfmapts.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\datefmt.h ..\..\i18n\unicode\smpdtfmt.h ..\..\i18n\unicode\decimfmt.h ..\..\i18n\unicode\choicfmt.h ..\..\i18n\unicode\msgfmt.h

SOURCE=.\dtfmrgts.cpp
"$(INTDIR)\dtfmrgts.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\timezone.h ..\..\i18n\unicode\gregocal.h ..\..\i18n\unicode\smpdtfmt.h ..\..\i18n\unicode\datefmt.h ..\..\i18n\unicode\simpletz.h ..\..\common\unicode\resbund.h

SOURCE=.\dtfmtrtts.cpp
"$(INTDIR)\dtfmtrtts.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\datefmt.h ..\..\i18n\unicode\smpdtfmt.h ..\..\i18n\unicode\gregocal.h

SOURCE=.\dtfmttst.cpp
"$(INTDIR)\dtfmttst.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\timezone.h ..\..\i18n\unicode\gregocal.h ..\..\i18n\unicode\smpdtfmt.h ..\..\i18n\unicode\datefmt.h ..\..\i18n\unicode\simpletz.h ..\..\common\unicode\strenum.h ..\..\i18n\unicode\dtfmtsym.h

SOURCE=.\encoll.cpp
"$(INTDIR)\encoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\sortkey.h

SOURCE=.\escoll.cpp
"$(INTDIR)\escoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\sortkey.h

SOURCE=.\ficoll.cpp
"$(INTDIR)\ficoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\sortkey.h

SOURCE=.\frcoll.cpp
"$(INTDIR)\frcoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\sortkey.h

SOURCE=.\g7coll.cpp
"$(INTDIR)\g7coll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\sortkey.h

SOURCE=.\icusvtst.cpp
"$(INTDIR)\icusvtst.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h

SOURCE=.\idnaconf.cpp
"$(INTDIR)\idnaconf.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\ucnv.h ..\..\common\unicode\ustring.h ..\..\common\unicode\uidna.h

SOURCE=.\idnaref.cpp
"$(INTDIR)\idnaref.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\ustring.h

SOURCE=.\incaltst.cpp
"$(INTDIR)\incaltst.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\utypes.h ..\..\common\unicode\locid.h ..\..\i18n\unicode\gregocal.h ..\..\i18n\unicode\smpdtfmt.h ..\..\i18n\unicode\simpletz.h

SOURCE=.\intltest.cpp
"$(INTDIR)\intltest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\unistr.h ..\..\common\unicode\ures.h ..\..\i18n\unicode\smpdtfmt.h ..\..\common\unicode\ucnv.h ..\..\common\unicode\uclean.h ..\..\i18n\unicode\timezone.h ..\..\i18n\unicode\curramt.h ..\..\common\unicode\putil.h ..\..\common\unicode\locid.h ..\..\common\unicode\locid.h

SOURCE=.\itercoll.cpp
"$(INTDIR)\itercoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\sortkey.h ..\..\common\unicode\schriter.h ..\..\common\unicode\chariter.h ..\..\common\unicode\uchar.h

SOURCE=.\itformat.cpp
"$(INTDIR)\itformat.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h

SOURCE=.\itmajor.cpp
"$(INTDIR)\itmajor.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h

SOURCE=.\itrbbi.cpp
"$(INTDIR)\itrbbi.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h

SOURCE=.\itrbnf.cpp
"$(INTDIR)\itrbnf.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\umachine.h ..\..\i18n\unicode\tblcoll.h ..\..\i18n\unicode\coleitr.h ..\..\common\unicode\ures.h ..\..\common\unicode\ustring.h ..\..\i18n\unicode\decimfmt.h ..\..\common\unicode\udata.h

SOURCE=.\itrbnfp.cpp
"$(INTDIR)\itrbnfp.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\umachine.h ..\..\i18n\unicode\tblcoll.h ..\..\i18n\unicode\coleitr.h ..\..\common\unicode\ures.h ..\..\common\unicode\ustring.h ..\..\i18n\unicode\decimfmt.h

SOURCE=.\itrbnfrt.cpp
"$(INTDIR)\itrbnfrt.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\fmtable.h

SOURCE=.\ittrans.cpp
"$(INTDIR)\ittrans.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h

SOURCE=.\itutil.cpp
"$(INTDIR)\itutil.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h

SOURCE=.\jacoll.cpp
"$(INTDIR)\jacoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\sortkey.h

SOURCE=.\jamotest.cpp
"$(INTDIR)\jamotest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\utypes.h ..\..\i18n\unicode\translit.h

SOURCE=.\lcukocol.cpp
"$(INTDIR)\lcukocol.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\sortkey.h

SOURCE=.\loctest.cpp
"$(INTDIR)\loctest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\decimfmt.h ..\..\i18n\unicode\ucurr.h ..\..\i18n\unicode\smpdtfmt.h ..\..\i18n\unicode\dtfmtsym.h ..\..\common\unicode\brkiter.h ..\..\i18n\unicode\coll.h

SOURCE=.\miscdtfm.cpp
"$(INTDIR)\miscdtfm.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\format.h ..\..\i18n\unicode\decimfmt.h ..\..\i18n\unicode\datefmt.h ..\..\i18n\unicode\smpdtfmt.h ..\..\i18n\unicode\dtfmtsym.h ..\..\common\unicode\locid.h ..\..\i18n\unicode\msgfmt.h ..\..\i18n\unicode\numfmt.h ..\..\i18n\unicode\choicfmt.h ..\..\i18n\unicode\gregocal.h

SOURCE=.\mnkytst.cpp
"$(INTDIR)\mnkytst.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\sortkey.h

SOURCE=.\msfmrgts.cpp
"$(INTDIR)\msfmrgts.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\format.h ..\..\i18n\unicode\decimfmt.h ..\..\common\unicode\locid.h ..\..\i18n\unicode\msgfmt.h ..\..\i18n\unicode\numfmt.h ..\..\i18n\unicode\choicfmt.h ..\..\i18n\unicode\gregocal.h

SOURCE=.\nmfmapts.cpp
"$(INTDIR)\nmfmapts.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\numfmt.h ..\..\i18n\unicode\decimfmt.h ..\..\common\unicode\locid.h ..\..\i18n\unicode\unum.h ..\..\common\unicode\strenum.h

SOURCE=.\nmfmtrt.cpp
"$(INTDIR)\nmfmtrt.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\dcfmtsym.h ..\..\i18n\unicode\decimfmt.h ..\..\common\unicode\locid.h

SOURCE=.\normconf.cpp
"$(INTDIR)\normconf.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\uchar.h ..\..\common\unicode\normlzr.h ..\..\common\unicode\uniset.h ..\..\common\unicode\putil.h

SOURCE=.\nptrans.cpp
"$(INTDIR)\nptrans.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\resbund.h ..\..\common\unicode\uniset.h

SOURCE=.\numfmtst.cpp
"$(INTDIR)\numfmtst.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\dcfmtsym.h ..\..\i18n\unicode\decimfmt.h ..\..\i18n\unicode\ucurr.h ..\..\common\unicode\ustring.h ..\..\i18n\unicode\measfmt.h ..\..\i18n\unicode\curramt.h

SOURCE=.\numrgts.cpp
"$(INTDIR)\numrgts.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\dcfmtsym.h ..\..\i18n\unicode\decimfmt.h ..\..\common\unicode\locid.h ..\..\common\unicode\resbund.h ..\..\i18n\unicode\calendar.h ..\..\i18n\unicode\datefmt.h ..\..\i18n\unicode\ucurr.h

SOURCE=.\pptest.cpp
"$(INTDIR)\pptest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\numfmt.h ..\..\i18n\unicode\decimfmt.h

SOURCE=.\punyref.c
"$(INTDIR)\punyref.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h

SOURCE=.\rbbiapts.cpp
"$(INTDIR)\rbbiapts.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\uchar.h ..\..\common\unicode\rbbi.h ..\..\common\unicode\schriter.h ..\..\common\unicode\ustring.h ..\..\common\unicode\utext.h

SOURCE=.\rbbitst.cpp
"$(INTDIR)\rbbitst.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\utypes.h ..\..\common\unicode\brkiter.h ..\..\common\unicode\rbbi.h ..\..\common\unicode\uchar.h ..\..\common\unicode\utf16.h ..\..\common\unicode\ucnv.h ..\..\common\unicode\schriter.h ..\..\common\unicode\uniset.h ..\..\i18n\unicode\regex.h ..\..\common\unicode\ustring.h ..\..\common\unicode\utext.h

SOURCE=.\regcoll.cpp
"$(INTDIR)\regcoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\common\unicode\unistr.h ..\..\i18n\unicode\sortkey.h

SOURCE=.\regextst.cpp
"$(INTDIR)\regextst.obj": $(SOURCE) "$(INTDIR)" ..\..\i18n\unicode\regex.h ..\..\common\unicode\uchar.h ..\..\common\unicode\ucnv.h

SOURCE=.\reptest.cpp
"$(INTDIR)\reptest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\rep.h

SOURCE=.\restest.cpp
"$(INTDIR)\restest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\unistr.h ..\..\common\unicode\uniset.h ..\..\common\unicode\resbund.h

SOURCE=.\restsnew.cpp
"$(INTDIR)\restsnew.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\unistr.h ..\..\common\unicode\resbund.h

SOURCE=.\rndmcoll.cpp
"$(INTDIR)\rndmcoll.obj": $(SOURCE) "$(INTDIR)"

SOURCE=.\sdtfmtts.cpp
"$(INTDIR)\sdtfmtts.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\smpdtfmt.h ..\..\i18n\unicode\dtfmtsym.h

SOURCE=.\sfwdchit.cpp
"$(INTDIR)\sfwdchit.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\ustring.h ..\..\common\unicode\unistr.h

SOURCE=.\srchtest.cpp
"$(INTDIR)\srchtest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\stsearch.h ..\..\common\unicode\ustring.h ..\..\common\unicode\schriter.h

SOURCE=.\strcase.cpp
"$(INTDIR)\strcase.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\uchar.h ..\..\common\unicode\ures.h ..\..\common\unicode\uloc.h ..\..\common\unicode\locid.h ..\..\common\unicode\ubrk.h ..\..\common\unicode\unistr.h ..\..\common\unicode\ucasemap.h ..\..\tools\ctestfw\unicode\tstdtmod.h

SOURCE=.\strtest.cpp
"$(INTDIR)\strtest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\putil.h ..\..\common\unicode\ustring.h

SOURCE=.\tchcfmt.cpp
"$(INTDIR)\tchcfmt.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\msgfmt.h ..\..\i18n\unicode\choicfmt.h

SOURCE=.\testidn.cpp
"$(INTDIR)\testidn.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\uchar.h ..\..\common\unicode\putil.h ..\..\common\unicode\udata.h

SOURCE=.\testidna.cpp
"$(INTDIR)\testidna.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\ustring.h ..\..\common\unicode\usprep.h ..\..\common\unicode\uniset.h ..\..\common\unicode\putil.h

SOURCE=.\testutil.cpp
"$(INTDIR)\testutil.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\unistr.h

SOURCE=.\textfile.cpp
"$(INTDIR)\textfile.obj": $(SOURCE) "$(INTDIR)"

SOURCE=.\tfsmalls.cpp
"$(INTDIR)\tfsmalls.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\msgfmt.h ..\..\i18n\unicode\choicfmt.h ..\..\common\unicode\parsepos.h ..\..\i18n\unicode\fieldpos.h ..\..\i18n\unicode\fmtable.h ..\..\i18n\unicode\decimfmt.h

SOURCE=.\thcoll.cpp
"$(INTDIR)\thcoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\sortkey.h ..\..\common\unicode\ustring.h

SOURCE=.\tmsgfmt.cpp
"$(INTDIR)\tmsgfmt.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\format.h ..\..\i18n\unicode\decimfmt.h ..\..\common\unicode\locid.h ..\..\i18n\unicode\msgfmt.h ..\..\i18n\unicode\numfmt.h ..\..\i18n\unicode\choicfmt.h ..\..\i18n\unicode\gregocal.h ..\..\i18n\unicode\datefmt.h

SOURCE=.\tokiter.cpp
"$(INTDIR)\tokiter.obj": $(SOURCE) "$(INTDIR)"

SOURCE=.\transapi.cpp
"$(INTDIR)\transapi.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\utypes.h ..\..\i18n\unicode\translit.h ..\..\common\unicode\unifilt.h ..\..\common\unicode\rep.h ..\..\common\unicode\locid.h ..\..\common\unicode\uniset.h

SOURCE=.\transrt.cpp
"$(INTDIR)\transrt.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\translit.h ..\..\i18n\unicode\calendar.h ..\..\common\unicode\uniset.h ..\..\common\unicode\uchar.h ..\..\common\unicode\normlzr.h ..\..\common\unicode\uchar.h ..\..\common\unicode\parseerr.h ..\..\common\unicode\usetiter.h ..\..\common\unicode\putil.h ..\..\common\unicode\uversion.h ..\..\common\unicode\locid.h ..\..\i18n\unicode\ulocdata.h ..\..\common\unicode\utf8.h

SOURCE=.\transtst.cpp
"$(INTDIR)\transtst.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\locid.h ..\..\i18n\unicode\dtfmtsym.h ..\..\common\unicode\normlzr.h ..\..\i18n\unicode\translit.h ..\..\common\unicode\uchar.h ..\..\common\unicode\unifilt.h ..\..\common\unicode\uniset.h ..\..\common\unicode\ustring.h ..\..\common\unicode\usetiter.h ..\..\common\unicode\uscript.h

SOURCE=.\trcoll.cpp
"$(INTDIR)\trcoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\unistr.h ..\..\tools\ctestfw\unicode\tstdtmod.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\tblcoll.h ..\..\i18n\unicode\sortkey.h

SOURCE=.\trnserr.cpp
"$(INTDIR)\trnserr.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\utypes.h ..\..\i18n\unicode\translit.h ..\..\common\unicode\uniset.h ..\..\common\unicode\unifilt.h ..\..\common\unicode\rep.h ..\..\common\unicode\locid.h

SOURCE=.\tscoll.cpp
"$(INTDIR)\tscoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\uchar.h ..\..\common\unicode\ustring.h

SOURCE=.\tsdate.cpp
"$(INTDIR)\tsdate.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\datefmt.h ..\..\i18n\unicode\smpdtfmt.h

SOURCE=.\tsdcfmsy.cpp
"$(INTDIR)\tsdcfmsy.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\dcfmtsym.h ..\..\i18n\unicode\decimfmt.h ..\..\i18n\unicode\unum.h

SOURCE=.\tsdtfmsy.cpp
"$(INTDIR)\tsdtfmsy.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\dtfmtsym.h

SOURCE=.\tsmthred.cpp
CPP_SWITCHES=/nologo  /MT /Ze /W3 $(EXCEPTIONSWITCH) /Zi /Ox /Ob0 /I "..\..\..\include" /I "..\..\..\source\common" /I "..\..\..\source\i18n" /I "..\..\tools\toolutil" /I "..\..\tools\ctestfw" /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D "_MBCS" /D "_CRT_SECURE_NO_DEPRECATE" /Fo"$(INTDIR)\\" /Fd"$(INTDIR)\\" /FD /c
"$(INTDIR)\tsmthred.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\ustring.h ..\..\common\unicode\resbund.h ..\..\common\unicode\udata.h ..\..\common\unicode\uloc.h ..\..\common\unicode\locid.h ..\..\common\unicode\putil.h ..\..\i18n\unicode\numfmt.h ..\..\i18n\unicode\choicfmt.h ..\..\i18n\unicode\msgfmt.h ..\..\common\unicode\locid.h ..\..\i18n\unicode\ucol.h ..\..\i18n\unicode\calendar.h
	$(CPP) @<<
  $(CPP_SWITCHES) $(SOURCE)
<<

SOURCE=.\tsnmfmt.cpp
"$(INTDIR)\tsnmfmt.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\decimfmt.h

SOURCE=.\tsputil.cpp
"$(INTDIR)\tsputil.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h

SOURCE=.\tstnorm.cpp
"$(INTDIR)\tstnorm.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\uchar.h ..\..\common\unicode\normlzr.h ..\..\common\unicode\uniset.h ..\..\common\unicode\usetiter.h ..\..\common\unicode\schriter.h

SOURCE=.\tstnrapi.cpp
"$(INTDIR)\tstnrapi.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\uchar.h ..\..\common\unicode\normlzr.h ..\..\common\unicode\uniset.h ..\..\common\unicode\usetiter.h ..\..\common\unicode\schriter.h

SOURCE=.\tzbdtest.cpp
"$(INTDIR)\tzbdtest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\timezone.h ..\..\i18n\unicode\simpletz.h ..\..\i18n\unicode\gregocal.h

SOURCE=.\tzregts.cpp
"$(INTDIR)\tzregts.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\simpletz.h ..\..\i18n\unicode\smpdtfmt.h ..\..\common\unicode\strenum.h

SOURCE=.\tztest.cpp
"$(INTDIR)\tztest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\timezone.h ..\..\i18n\unicode\simpletz.h ..\..\i18n\unicode\calendar.h ..\..\i18n\unicode\gregocal.h ..\..\common\unicode\resbund.h ..\..\common\unicode\strenum.h

SOURCE=.\ucaconf.cpp
"$(INTDIR)\ucaconf.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\ustring.h

SOURCE=.\ucdtest.cpp
"$(INTDIR)\ucdtest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\ustring.h ..\..\common\unicode\uchar.h ..\..\common\unicode\uniset.h ..\..\common\unicode\putil.h

SOURCE=.\uobjtest.cpp
"$(INTDIR)\uobjtest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\utypes.h ..\..\common\unicode\brkiter.h ..\..\i18n\unicode\calendar.h ..\..\common\unicode\caniter.h ..\..\common\unicode\chariter.h ..\..\i18n\unicode\choicfmt.h ..\..\i18n\unicode\coleitr.h ..\..\i18n\unicode\coll.h ..\..\i18n\unicode\curramt.h ..\..\i18n\unicode\datefmt.h ..\..\common\unicode\dbbi.h ..\..\i18n\unicode\dcfmtsym.h ..\..\i18n\unicode\decimfmt.h ..\..\i18n\unicode\dtfmtsym.h ..\..\i18n\unicode\fieldpos.h ..\..\i18n\unicode\fmtable.h ..\..\i18n\unicode\format.h ..\..\i18n\unicode\gregocal.h ..\..\common\unicode\locid.h ..\..\i18n\unicode\msgfmt.h ..\..\common\unicode\normlzr.h ..\..\i18n\unicode\numfmt.h ..\..\common\unicode\parsepos.h ..\..\common\unicode\rbbi.h ..\..\i18n\unicode\rbnf.h ..\..\i18n\unicode\regex.h ..\..\common\unicode\resbund.h ..\..\common\unicode\schriter.h ..\..\i18n\unicode\simpletz.h ..\..\i18n\unicode\smpdtfmt.h ..\..\i18n\unicode\sortkey.h ..\..\i18n\unicode\stsearch.h ..\..\i18n\unicode\tblcoll.h ..\..\i18n\unicode\timezone.h ..\..\i18n\unicode\translit.h ..\..\common\unicode\uchriter.h ..\..\common\unicode\unifilt.h ..\..\common\unicode\unifunct.h ..\..\common\unicode\uniset.h ..\..\common\unicode\unistr.h ..\..\common\unicode\uobject.h ..\..\common\unicode\usetiter.h

SOURCE=.\usettest.cpp
"$(INTDIR)\usettest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\uniset.h ..\..\common\unicode\uchar.h ..\..\common\unicode\usetiter.h ..\..\common\unicode\ustring.h ..\..\common\unicode\parsepos.h ..\..\common\unicode\symtable.h ..\..\common\unicode\uversion.h

SOURCE=.\ustrtest.cpp
"$(INTDIR)\ustrtest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\common\unicode\unistr.h ..\..\common\unicode\uchar.h ..\..\common\unicode\ustring.h ..\..\common\unicode\locid.h ..\..\common\unicode\ucnv.h ..\..\io\unicode\ustream.h

SOURCE=.\utxttest.cpp
"$(INTDIR)\utxttest.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h

SOURCE=.\uvectest.cpp
"$(INTDIR)\uvectest.obj": $(SOURCE) "$(INTDIR)"

SOURCE=.\v32test.cpp
"$(INTDIR)\v32test.obj": $(SOURCE) "$(INTDIR)"

SOURCE=.\wbnf.cpp
"$(INTDIR)\wbnf.obj": $(SOURCE) "$(INTDIR)"

SOURCE=.\windttst.cpp
CPP_SWITCHES=/nologo  /MT /Ze /W3 $(EXCEPTIONSWITCH) /Zi /Ox /Ob0 /I "..\..\..\include" /I "..\..\..\source\common" /I "..\..\..\source\i18n" /I "..\..\tools\toolutil" /I "..\..\tools\ctestfw" /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D "_MBCS" /D "_CRT_SECURE_NO_DEPRECATE" /Fo"$(INTDIR)\\" /Fd"$(INTDIR)\\" /FD /c
"$(INTDIR)\windttst.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\format.h ..\..\i18n\unicode\numfmt.h ..\..\common\unicode\locid.h ..\..\common\unicode\ustring.h ..\..\tools\ctestfw\unicode\testlog.h ..\..\i18n\unicode\utmscale.h
	$(CPP) @<<
  $(CPP_SWITCHES) $(SOURCE)
<<

SOURCE=.\winnmtst.cpp
CPP_SWITCHES=/nologo  /MT /Ze /W3 $(EXCEPTIONSWITCH) /Zi /Ox /Ob0 /I "..\..\..\include" /I "..\..\..\source\common" /I "..\..\..\source\i18n" /I "..\..\tools\toolutil" /I "..\..\tools\ctestfw" /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D "_MBCS" /D "_CRT_SECURE_NO_DEPRECATE" /Fo"$(INTDIR)\\" /Fd"$(INTDIR)\\" /FD /c
"$(INTDIR)\winnmtst.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\format.h ..\..\i18n\unicode\numfmt.h ..\..\common\unicode\locid.h ..\..\common\unicode\ustring.h ..\..\tools\ctestfw\unicode\testlog.h ..\..\i18n\unicode\utmscale.h
	$(CPP) @<<
  $(CPP_SWITCHES) $(SOURCE)
<<

SOURCE=.\winutil.cpp
CPP_SWITCHES=/nologo  /MT /Ze /W3 $(EXCEPTIONSWITCH) /Zi /Ox /Ob0 /I "..\..\..\include" /I "..\..\..\source\common" /I "..\..\..\source\i18n" /I "..\..\tools\toolutil" /I "..\..\tools\ctestfw" /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D "_MBCS" /D "_CRT_SECURE_NO_DEPRECATE" /Fo"$(INTDIR)\\" /Fd"$(INTDIR)\\" /FD /c
"$(INTDIR)\winutil.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h
	$(CPP) @<<
  $(CPP_SWITCHES) $(SOURCE)
<<

SOURCE=.\svccoll.cpp
"$(INTDIR)\svccoll.obj": $(SOURCE) "$(INTDIR)" ..\..\common\unicode\utypes.h ..\..\i18n\unicode\coll.h ..\..\common\unicode\strenum.h

!ENDIF

!IF  "$(CFG)" == "intltest - Win32 Release"

"common - Win32 Release" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Release"
   cd "..\test\intltest"

"common - Win32 ReleaseCLEAN" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Release" RECURSE=1 CLEAN
   cd "..\test\intltest"

!ELSEIF  "$(CFG)" == "intltest - Win32 Debug"

"common - Win32 Debug" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Debug"
   cd "..\test\intltest"

"common - Win32 DebugCLEAN" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Debug" RECURSE=1 CLEAN
   cd "..\test\intltest"

!ENDIF

!IF  "$(CFG)" == "intltest - Win32 Release"

"i18n - Win32 Release" :
   cd "..\..\i18n"
   $(MAKE) /$(MAKEFLAGS) /F .\i18n.mak CFG="i18n - Win32 Release"
   cd "..\test\intltest"

"i18n - Win32 ReleaseCLEAN" :
   cd "..\..\i18n"
   $(MAKE) /$(MAKEFLAGS) /F .\i18n.mak CFG="i18n - Win32 Release" RECURSE=1 CLEAN
   cd "..\test\intltest"

!ELSEIF  "$(CFG)" == "intltest - Win32 Debug"

"i18n - Win32 Debug" :
   cd "..\..\i18n"
   $(MAKE) /$(MAKEFLAGS) /F .\i18n.mak CFG="i18n - Win32 Debug"
   cd "..\test\intltest"

"i18n - Win32 DebugCLEAN" :
   cd "..\..\i18n"
   $(MAKE) /$(MAKEFLAGS) /F .\i18n.mak CFG="i18n - Win32 Debug" RECURSE=1 CLEAN
   cd "..\test\intltest"

!ENDIF

!IF  "$(CFG)" == "intltest - Win32 Release"

"toolutil - Win32 Release" :
   cd "..\..\tools\toolutil"
   $(MAKE) /$(MAKEFLAGS) /F .\toolutil.mak CFG="toolutil - Win32 Release"
   cd "..\..\test\intltest"

"toolutil - Win32 ReleaseCLEAN" :
   cd "..\..\tools\toolutil"
   $(MAKE) /$(MAKEFLAGS) /F .\toolutil.mak CFG="toolutil - Win32 Release" RECURSE=1 CLEAN
   cd "..\..\test\intltest"

!ELSEIF  "$(CFG)" == "intltest - Win32 Debug"

"toolutil - Win32 Debug" :
   cd "..\..\tools\toolutil"
   $(MAKE) /$(MAKEFLAGS) /F .\toolutil.mak CFG="toolutil - Win32 Debug"
   cd "..\..\test\intltest"

"toolutil - Win32 DebugCLEAN" :
   cd "..\..\tools\toolutil"
   $(MAKE) /$(MAKEFLAGS) /F .\toolutil.mak CFG="toolutil - Win32 Debug" RECURSE=1 CLEAN
   cd "..\..\test\intltest"

!ENDIF