/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: rtl_locale.cxx,v $
 * $Revision: 1.5 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/


// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sal.hxx"
// autogenerated file with codegen.pl

#include <cppunit/simpleheader.hxx>
#include <rtl/locale.hxx>
#include <osl/thread.h>

namespace rtl_locale
{
    // default locale for test purpose
    void setDefaultLocale()
    {
        rtl::OLocale::setDefault(rtl::OUString::createFromAscii("de"), rtl::OUString::createFromAscii("DE"), /* rtl::OUString() */ rtl::OUString::createFromAscii("hochdeutsch") );
    }

class getDefault : public CppUnit::TestFixture
{
public:
    // initialise your test code values here.
    void setUp()
    {
    }

    void tearDown()
    {
    }

    // insert your test code here.
    void getDefault_000()
    {
        // this is demonstration code
        // CPPUNIT_ASSERT_MESSAGE("a message", 1 == 1);

        // due to the fact, we set the default locale at first, this test is no longer possible
   	// ::rtl::OLocale aLocale = ::rtl::OLocale::getDefault();
        // CPPUNIT_ASSERT_MESSAGE("locale must be null", aLocale.getData() == NULL);

    }

    void getDefault_001()
    {
        // rtl::OLocale::setDefault(rtl::OUString::createFromAscii("de"), rtl::OUString::createFromAscii("DE"), rtl::OUString());
   	rtl::OLocale aLocale = ::rtl::OLocale::getDefault();
        CPPUNIT_ASSERT_MESSAGE("locale must not null", aLocale.getData() != NULL);
    }

    // Change the following lines only, if you add, remove or rename 
    // member functions of the current class, 
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(getDefault);
    CPPUNIT_TEST(getDefault_000);
    CPPUNIT_TEST(getDefault_001);
    CPPUNIT_TEST_SUITE_END();
}; // class getDefault


class setDefault : public CppUnit::TestFixture
{
public:
    // initialise your test code values here.
    void setUp()
    {
    }

    void tearDown()
    {
        setDefaultLocale();
    }

    // insert your test code here.
    void setDefault_001()
    {
        rtl::OLocale::setDefault(rtl::OUString::createFromAscii("en"), rtl::OUString::createFromAscii("US"), rtl::OUString());
   	rtl::OLocale aLocale = ::rtl::OLocale::getDefault();
        CPPUNIT_ASSERT_MESSAGE("locale must not null", aLocale.getData() != NULL);
        
        // be sure to not GPF
    }

    // Change the following lines only, if you add, remove or rename 
    // member functions of the current class, 
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(setDefault);
    CPPUNIT_TEST(setDefault_001);
    CPPUNIT_TEST_SUITE_END();
}; // class setDefault


class getLanguage : public CppUnit::TestFixture
{
public:
    // initialise your test code values here.
    void setUp()
    {
    }

    void tearDown()
    {
    }

    // insert your test code here.
    void getLanguage_001()
    {
   	rtl::OLocale aLocale = ::rtl::OLocale::getDefault();
        rtl::OUString suLanguage = aLocale.getLanguage();
        t_print("Language: %s\n", rtl::OUStringToOString(suLanguage, osl_getThreadTextEncoding()).getStr());
        CPPUNIT_ASSERT_MESSAGE("locale language must be 'de'", suLanguage.equals(rtl::OUString::createFromAscii("de")));
    }
    void getLanguage_002()
    {
   	rtl::OLocale aLocale = ::rtl::OLocale::getDefault();
        rtl::OUString suLanguage = rtl_locale_getLanguage(aLocale.getData());
        t_print("Language: %s\n", rtl::OUStringToOString(suLanguage, osl_getThreadTextEncoding()).getStr());
        CPPUNIT_ASSERT_MESSAGE("locale language must be 'de'", suLanguage.equals(rtl::OUString::createFromAscii("de")));
    }

    // Change the following lines only, if you add, remove or rename 
    // member functions of the current class, 
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(getLanguage);
    CPPUNIT_TEST(getLanguage_001);
    CPPUNIT_TEST(getLanguage_002);
    CPPUNIT_TEST_SUITE_END();
}; // class getLanguage


class getCountry : public CppUnit::TestFixture
{
public:
    // initialise your test code values here.
    void setUp()
    {
    }

    void tearDown()
    {
    }

    // insert your test code here.
    void getCountry_001()
    {
   	rtl::OLocale aLocale = ::rtl::OLocale::getDefault();
        rtl::OUString suCountry = aLocale.getCountry();
        t_print("Country: %s\n", rtl::OUStringToOString(suCountry, osl_getThreadTextEncoding()).getStr());
        CPPUNIT_ASSERT_MESSAGE("locale country must be 'DE'", suCountry.equals(rtl::OUString::createFromAscii("DE")));
    }
    void getCountry_002()
    {
   	rtl::OLocale aLocale = ::rtl::OLocale::getDefault();
        rtl::OUString suCountry = rtl_locale_getCountry(aLocale.getData());
        t_print("Country: %s\n", rtl::OUStringToOString(suCountry, osl_getThreadTextEncoding()).getStr());
        CPPUNIT_ASSERT_MESSAGE("locale country must be 'DE'", suCountry.equals(rtl::OUString::createFromAscii("DE")));
    }

    // Change the following lines only, if you add, remove or rename 
    // member functions of the current class, 
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(getCountry);
    CPPUNIT_TEST(getCountry_001);
    CPPUNIT_TEST(getCountry_002);
    CPPUNIT_TEST_SUITE_END();
}; // class getCountry


class getVariant : public CppUnit::TestFixture
{
public:
    // initialise your test code values here.
    void setUp()
    {
    }

    void tearDown()
    {
    }

    // insert your test code here.
    void getVariant_001()
    {
   	rtl::OLocale aLocale = ::rtl::OLocale::getDefault();
        rtl::OUString suVariant = aLocale.getVariant();
        t_print("Variant: %s\n", rtl::OUStringToOString(suVariant, osl_getThreadTextEncoding()).getStr());
        CPPUNIT_ASSERT_MESSAGE("locale variant must be 'hochdeutsch'", suVariant.equals(rtl::OUString::createFromAscii("hochdeutsch")));
    }
    void getVariant_002()
    {
   	rtl::OLocale aLocale = ::rtl::OLocale::getDefault();
        rtl::OUString suVariant = rtl_locale_getVariant(aLocale.getData());
        t_print("Variant: %s\n", rtl::OUStringToOString(suVariant, osl_getThreadTextEncoding()).getStr());
        CPPUNIT_ASSERT_MESSAGE("locale variant must be 'hochdeutsch'", suVariant.equals(rtl::OUString::createFromAscii("hochdeutsch")));
    }

    // Change the following lines only, if you add, remove or rename 
    // member functions of the current class, 
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(getVariant);
    CPPUNIT_TEST(getVariant_001);
    CPPUNIT_TEST(getVariant_002);
    CPPUNIT_TEST_SUITE_END();
}; // class getVariant


class hashCode : public CppUnit::TestFixture
{
public:
    // initialise your test code values here.
    void setUp()
    {
    }

    void tearDown()
    {
    }

    // insert your test code here.
    void hashCode_001()
    {
   	rtl::OLocale aLocale = ::rtl::OLocale::getDefault();
        sal_Int32 nHashCode = aLocale.hashCode();
        t_print("Hashcode: %d\n", nHashCode);
        CPPUNIT_ASSERT_MESSAGE("locale hashcode must be 3831", nHashCode != 0);
    }
    void hashCode_002()
    {
   	rtl::OLocale aLocale = ::rtl::OLocale::getDefault();
        sal_Int32 nHashCode = rtl_locale_hashCode(aLocale.getData());
        t_print("Hashcode: %d\n", nHashCode);
        CPPUNIT_ASSERT_MESSAGE("locale hashcode must be 3831", nHashCode != 0);
    }

    // Change the following lines only, if you add, remove or rename 
    // member functions of the current class, 
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(hashCode);
    CPPUNIT_TEST(hashCode_001);
    CPPUNIT_TEST(hashCode_002);
    CPPUNIT_TEST_SUITE_END();
}; // class hashCode


class equals : public CppUnit::TestFixture
{
public:
    // initialise your test code values here.
    void setUp()
    {
    }

    void tearDown()
    {
    }

    // insert your test code here.
    void equals_001()
    {
        rtl::OLocale aLocale1 = rtl::OLocale::registerLocale(rtl::OUString::createFromAscii("en"), rtl::OUString::createFromAscii("US"), rtl::OUString());
        rtl::OLocale aLocale2 = rtl::OLocale::registerLocale(rtl::OUString::createFromAscii("en"), rtl::OUString::createFromAscii("US"));
        
        sal_Bool bLocaleAreEqual = sal_False;
        bLocaleAreEqual = (aLocale1 == aLocale2);

        CPPUNIT_ASSERT_MESSAGE("check operator ==()", bLocaleAreEqual == sal_True);
    }

    void equals_002()
    {
        rtl::OLocale aLocale1 = rtl::OLocale::registerLocale(rtl::OUString::createFromAscii("en"), rtl::OUString::createFromAscii("US"), rtl::OUString());
        rtl::OLocale aLocale2 = rtl::OLocale::registerLocale(rtl::OUString::createFromAscii("en"), rtl::OUString::createFromAscii("US"));
        
        sal_Int32 nEqual = rtl_locale_equals(aLocale1.getData(), aLocale2.getData());
        t_print("rtl_locale_equals() result: %d\n", nEqual);
        CPPUNIT_ASSERT(nEqual != 0);
    }

    // Change the following lines only, if you add, remove or rename 
    // member functions of the current class, 
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(equals);
    CPPUNIT_TEST(equals_001);
    CPPUNIT_TEST(equals_002);
    CPPUNIT_TEST_SUITE_END();
}; // class equals

// -----------------------------------------------------------------------------
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(rtl_locale::getDefault, "rtl_locale");
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(rtl_locale::setDefault, "rtl_locale");
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(rtl_locale::getLanguage, "rtl_locale");
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(rtl_locale::getCountry, "rtl_locale");
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(rtl_locale::getVariant, "rtl_locale");
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(rtl_locale::hashCode, "rtl_locale");
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(rtl_locale::equals, "rtl_locale");
} // namespace rtl_locale


// -----------------------------------------------------------------------------

// this macro creates an empty function, which will called by the RegisterAllFunctions()
// to let the user the possibility to also register some functions by hand.
// NOADDITIONAL;

void RegisterAdditionalFunctions(FktRegFuncPtr)
{
    // start message
    t_print("Initializing ...\n" );
    rtl_locale::setDefaultLocale();
    t_print("Initialization Done.\n" );
}
