/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: offmgr_app3.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2006/08/14 13:15:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ofapch.hxx"
#endif

#pragma hdrstop

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _CONFIG_HXX
#include <tools/config.hxx>
#endif
#ifndef _SFXFLAGITEM_HXX
#include <svtools/flagitem.hxx>
#endif
#ifndef _SFX_WHITER_HXX
#include <svtools/whiter.hxx>
#endif
#ifndef _SFXDISPATCH_HXX
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SFXREQUEST_HXX
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXVIEWSH_HXX
#include <bf_sfx2/viewsh.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif
#ifndef _SFX_PRINTOPT_HXX
#include <bf_sfx2/printopt.hxx>
#endif
#ifndef _SVX_ADRITEM_HXX
#include <bf_svx/adritem.hxx>
#endif
#ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
#include <svtools/languageoptions.hxx>
#endif

#ifndef _SFXGENLINK_HXX //autogen
#include <bf_sfx2/genlink.hxx>
#endif
#ifndef _SVX_OPTGENRL_HXX
#include <bf_svx/optgenrl.hxx>
#endif
#ifndef _SVX_FONT_SUBSTITUTION_HXX //autogen
#include <fontsubs.hxx>
#endif
#ifndef _SBXCORE_HXX //autogen
#include <basic/sbxcore.hxx>
#endif

#ifndef _SFXSIDS_HRC
#include <bf_sfx2/sfxsids.hrc>
#endif
#ifndef _SVX_OPTITEMS_HXX
#define ITEMID_SPELLCHECK   SID_ATTR_SPELL
#define ITEMID_HYPHENREGION SID_ATTR_HYPHENREGION
#include <bf_svx/optitems.hxx>
#endif
#ifndef _SVX_HYZNITEM_HXX
#define  ITEMID_HYPHENZONE SID_ATTR_PARA_HYPHENZONE
#include <bf_svx/hyznitem.hxx>
#endif
#ifndef _SVX_LANGITEM_HXX
#define	ITEMID_LANGUAGE SID_ATTR_CHAR_LANGUAGE
#include <bf_svx/langitem.hxx>
#endif
#ifndef _SVX_OPTCOLOR_HXX
#include <bf_svx/optcolor.hxx>
#endif
#ifndef _SVX_OPTCTL_HXX
#include <bf_svx/optctl.hxx>
#endif

#ifndef _XTABLE_HXX
#include <bf_svx/xtable.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _PVER_HXX //autogen
#include <svtools/pver.hxx>
#endif
#ifndef _SVX_DIALOGS_HRC
#include <bf_svx/dialogs.hrc>
#endif
#include <bf_sfx2/misccfg.hxx>

#ifndef _SVX_OPTSAVE_HXX //autogen
#include <bf_svx/optsave.hxx>
#endif
#ifndef _SVX_OPTPATH_HXX //autogen
#include <bf_svx/optpath.hxx>
#endif
#ifndef _SVX_OPTGENRL_HXX //autogen
#include <bf_svx/optgenrl.hxx>
#endif
#ifndef _SVX_OPTLINGU_HXX //autogen
#include <bf_svx/optlingu.hxx>
#endif
#ifndef _SVX_TAB_AREA_HXX //autogen
#include <bf_svx/tabarea.hxx>
#endif
#ifndef _SVX_OPTINET_HXX //autogen
#include <bf_svx/optinet2.hxx>
#endif
#ifndef _SVX_OPTEXTBR_HXX //autogen
#include <bf_svx/optextbr.hxx>
#endif
#ifndef _SVX_OPTASIAN_HXX
#include <bf_svx/optasian.hxx>
#endif
#ifndef _SVX_OPTACCESSIBILITY_HXX
#include <bf_svx/optaccessibility.hxx>
#endif
#ifndef _SVX_OPTJSEARCH_HXX_
#include <bf_svx/optjsearch.hxx>
#endif

#ifndef _OFA_OPTHTML_HXX //autogen
#include <opthtml.hxx>
#endif
#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif
#ifndef _UTL_CONFIGMGR_HXX_
#include <unotools/configmgr.hxx>
#endif

#include <comphelper/processfactory.hxx>

#ifndef _SFX_SFXUNO_HXX
#include <bf_sfx2/sfxuno.hxx>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XJOBEXECUTOR_HPP_
#include <com/sun/star/task/XJobExecutor.hpp>
#endif
#ifndef _UNO_LINGU_HXX
#include <bf_svx/unolingu.hxx>
#endif

#ifndef _LINGUISTIC_LNGPROPS_HHX_
#include <bf_linguistic/lngprops.hxx>
#endif
#ifndef _OSL_MODULE_H_
#include <osl/module.h>
#endif
#ifndef _OSL_PROCESS_H_
#include <osl/process.h>
#endif
#ifndef _RTL_BOOTSTRAP_HXX_
#include <rtl/bootstrap.hxx>
#endif

#include <bf_sfx2/viewfrm.hxx>
#include <bf_sfx2/docfac.hxx>

#define ITEMID_COLOR_TABLE      SID_COLOR_TABLE
#ifndef _SVX_DRAWITEM_HXX 
#include <bf_svx/drawitem.hxx>
#endif

#include "resid.hxx"
#include "app.hxx"
#include "appimp.hxx"
#include "app.hrc"
#include "osplcfg.hxx"
#include "apearcfg.hxx"
#include "optgdlg.hxx"
#include "splnote.hxx"
#include "optfltr.hxx"
#include "ofaids.hrc"
#include "ofaitem.hxx"
#include <tools/urlobj.hxx>
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif
#ifndef SVTOOLS_REGOPTIONS_HXX
#include <svtools/regoptions.hxx>
#endif
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
#define DEF_INCH	2540L
#define DEF_RELTWIP	1440L
namespace binfilter {


using namespace rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::linguistic2;
using namespace ::com::sun::star::task;

// ------------------------------------------------------------------------
//STRIP001 static const ::rtl::OUString& getProductRegistrationServiceName( )
//STRIP001 {
//STRIP001 	static ::rtl::OUString s_sServiceName = ::rtl::OUString::createFromAscii( "com.sun.star.setup.ProductRegistration" );
//STRIP001 	return s_sServiceName;
//STRIP001 }
//STRIP001 
// ------------------------------------------------------------------------
 
/*N*/void OfficeApplication::ExecuteApp_Impl( SfxRequest &rReq )
/*N*/{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	sal_uInt16 nSlot = rReq.GetSlot();
//STRIP001 	sal_Bool bIgnore = sal_False;
//STRIP001 
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001 		case SID_OPTPAGE_PROXY:
//STRIP001 		case SID_OPTPAGE_USERDATA:
//STRIP001 		case SID_OPTIONS_TREEDIALOG:
//STRIP001 		{
//STRIP001 			ExecuteGeneralOptionsDialog(nSlot);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ONLINE_REGISTRATION:
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				// create the ProductRegistration component
//STRIP001 				Reference< XMultiServiceFactory > xORB( ::legacy_binfilters::getLegacyProcessServiceFactory() );
//STRIP001 				Reference< XJobExecutor > xProductRegistration;
//STRIP001 				if ( xORB.is() )
//STRIP001 					xProductRegistration = xProductRegistration.query( xORB->createInstance( getProductRegistrationServiceName() ) );
//STRIP001 				DBG_ASSERT( xProductRegistration.is(), "OfficeApplication::ExecuteApp_Impl: could not create the service!" );
//STRIP001 
//STRIP001 				// tell it that the user wants to register
//STRIP001 				if ( xProductRegistration.is() )
//STRIP001 				{
//STRIP001 					xProductRegistration->trigger( ::rtl::OUString::createFromAscii( "RegistrationRequired" ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			catch( const ::com::sun::star::uno::Exception& )
//STRIP001 			{
//STRIP001 				DBG_ERROR( "OfficeApplication::ExecuteApp_Impl(SID_ONLINE_REGISTRATION): caught an exception!" );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_BASICIDE_APPEAR:
//STRIP001 		{
//STRIP001 			bIgnore = sal_True;
//STRIP001 			rReq.Done();
//STRIP001 
//STRIP001             const SfxObjectFactory* pFact = SfxObjectFactory::GetFactory(String::CreateFromAscii("private:factory/sbasic") );
//STRIP001             if ( !pFact )
//STRIP001                 return;
//STRIP001 
//STRIP001             SfxViewFrame* pView = SfxViewFrame::GetFirst();
//STRIP001             while ( pView )
//STRIP001             {
//STRIP001                 if ( &pView->GetObjectShell()->GetFactory() == pFact )
//STRIP001                     break;
//STRIP001                 pView = SfxViewFrame::GetNext( *pView );
//STRIP001             }
//STRIP001 
//STRIP001             if ( !pView )
//STRIP001             {
//STRIP001                 SfxObjectShell* pDocShell = pFact->CreateObject();
//STRIP001                 pDocShell->DoInitNew( 0 );
//STRIP001                 pDocShell->SetModified( FALSE );
//STRIP001                 SfxViewFrame* pBasicFrame = SFX_APP()->CreateViewFrame( *pDocShell, 0 );
//STRIP001                 pBasicFrame->SetName( String( RTL_CONSTASCII_USTRINGPARAM( "BASIC:1" ) ) );
//STRIP001             }
//STRIP001             else
//STRIP001                 pView->GetFrame()->Appear();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_BASICCHOOSER:
//STRIP001 		{
//STRIP001 			bIgnore = sal_True;
//STRIP001 			const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 			const SfxPoolItem* pItem;
//STRIP001             BOOL bChooseOnly = FALSE, bExecute = TRUE;
//STRIP001             if(pArgs && SFX_ITEM_SET == pArgs->GetItemState(SID_RECORDMACRO, sal_False, &pItem) )
//STRIP001             {
//STRIP001                 BOOL bRecord = ((SfxBoolItem*)pItem)->GetValue();
//STRIP001                 if ( bRecord )
//STRIP001                 {
//STRIP001                     // !Hack
//STRIP001                     bChooseOnly = FALSE;
//STRIP001                     bExecute = FALSE;
//STRIP001                 }
//STRIP001             }
//STRIP001 
//STRIP001             rReq.SetReturnValue( SfxStringItem( nSlot, OfficeApplication::ChooseMacro( bExecute, bChooseOnly ) ) );
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_SEARCH_ITEM:
//STRIP001 		break;
//STRIP001 		case SID_ATTR_ADDRESS:
//STRIP001 		{
//STRIP001 			const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 			const SfxPoolItem* pItem;
//STRIP001 			if(pArgs && SFX_ITEM_SET == pArgs->GetItemState(nSlot, sal_False, &pItem))
//STRIP001 			{
//STRIP001 					((SvxAddressItem*)pItem)->Store();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_APP_ENTERWAIT:
//STRIP001 			Application::EnterWait();
//STRIP001 			break;
//STRIP001 		case SID_APP_LEAVEWAIT:
//STRIP001 			Application::LeaveWait();
//STRIP001 			break;
//STRIP001 		case SID_APP_ISWAIT:
//STRIP001 			{
//STRIP001 				rReq.SetReturnValue( SfxBoolItem( SID_APP_ISWAIT,
//STRIP001 												Application::IsWait() ));
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_OFFICE_CHECK_PLZ:
//STRIP001 		{
//STRIP001 			sal_Bool bRet = sal_False;
//STRIP001 			SFX_REQUEST_ARG(rReq, pStringItem, SfxStringItem, nSlot, sal_False);
//STRIP001 
//STRIP001 			if ( pStringItem )
//STRIP001 			{
//STRIP001 				String aPLZ = pStringItem->GetValue();
//STRIP001 				bRet = TRUE /*!!!SfxIniManager::CheckPLZ( aPLZ )*/;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				SbxBase::SetError( SbxERR_WRONG_ARGS );
//STRIP001 			rReq.SetReturnValue( SfxBoolItem( nSlot, bRet ) );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bIgnore )
//STRIP001 		rReq.Done();
/*N*/ }
 
// ------------------------------------------------------------------------
 
/*N*/void OfficeApplication::GetStateApp_Impl( SfxItemSet &rSet )
/*N*/{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	SfxWhichIter aIter( rSet );
//STRIP001 	sal_uInt16 nWhich = aIter.FirstWhich();
//STRIP001 
//STRIP001 	while ( nWhich )
//STRIP001 	{
//STRIP001 		switch ( nWhich )
//STRIP001 		{
//STRIP001 			case SID_ATTR_ADDRESS:
//STRIP001 			{
//STRIP001 				SvxAddressItem aAddress;
//STRIP001 				aAddress.SetWhich(nWhich);
//STRIP001 				rSet.Put(aAddress);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case SID_ONLINE_REGISTRATION:
//STRIP001 			{
//STRIP001 				::svt::RegOptions aOptions;
//STRIP001 				if ( !aOptions.allowMenu() )
//STRIP001 					rSet.DisableItem( SID_ONLINE_REGISTRATION );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
/*N*/ }
 
// ------------------------------------------------------------------------
// Overloaded Application::Sys...
// Check whether systems-settings (from the os) should overwrite our defaults
// (CP & TH)
 
//STRIP001 void
//STRIP001 OfficeApplication::SystemSettingsChanging( AllSettings& rSettings, Window* pFrame )
//STRIP001 {
//STRIP001 	if ( !OfaTabAppearanceCfg::IsInitialized () )
//STRIP001 		return ;
//STRIP001 
//STRIP001 #   define DRAGFULL_OPTION_ALL \
//STRIP001 	     ( DRAGFULL_OPTION_WINDOWMOVE | DRAGFULL_OPTION_WINDOWSIZE  \
//STRIP001 		 | DRAGFULL_OPTION_OBJECTMOVE  | DRAGFULL_OPTION_OBJECTSIZE \
//STRIP001 		 | DRAGFULL_OPTION_DOCKING     | DRAGFULL_OPTION_SPLIT      \
//STRIP001 		 | DRAGFULL_OPTION_SCROLL )
//STRIP001 #   define DRAGFULL_OPTION_NONE ((sal_uInt32)~DRAGFULL_OPTION_ALL)
//STRIP001 
//STRIP001 	StyleSettings hStyleSettings   = rSettings.GetStyleSettings();
//STRIP001 	MouseSettings hMouseSettings = rSettings.GetMouseSettings();
//STRIP001 
//STRIP001 	sal_uInt32         nDragFullOptions = hStyleSettings.GetDragFullOptions();
//STRIP001 
//STRIP001 	OfaTabAppearanceCfg* pAppearanceCfg = GetTabAppearanceConfig();
//STRIP001 	sal_uInt16 nGet = pAppearanceCfg->GetDragMode();
//STRIP001 
//STRIP001 	switch ( nGet )
//STRIP001 	{
//STRIP001 	case DragFullWindow:
//STRIP001 		nDragFullOptions |= DRAGFULL_OPTION_ALL;
//STRIP001 		break;
//STRIP001 	case DragFrame:
//STRIP001 		nDragFullOptions &= DRAGFULL_OPTION_NONE;
//STRIP001 		break;
//STRIP001 	case DragSystemDep:
//STRIP001 	default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001     sal_uInt32 nFollow = hMouseSettings.GetFollow();
//STRIP001     hMouseSettings.SetFollow(pAppearanceCfg->IsMenuMouseFollow() ?
//STRIP001             (nFollow|MOUSE_FOLLOW_MENU) : (nFollow&~MOUSE_FOLLOW_MENU));
//STRIP001     rSettings.SetMouseSettings(hMouseSettings);
//STRIP001 
//STRIP001 	sal_uInt16 nTabStyle = hStyleSettings.GetTabControlStyle();
//STRIP001     nTabStyle &= ~STYLE_TABCONTROL_SINGLELINE;
//STRIP001     if(pAppearanceCfg->IsSingleLineTabCtrl())
//STRIP001         nTabStyle |=STYLE_TABCONTROL_SINGLELINE;
//STRIP001 
//STRIP001     nTabStyle &= ~STYLE_TABCONTROL_COLOR;
//STRIP001     if(pAppearanceCfg->IsColoredTabCtrl())
//STRIP001         nTabStyle |= STYLE_TABCONTROL_COLOR;
//STRIP001 
//STRIP001     hStyleSettings.SetTabControlStyle(nTabStyle);
//STRIP001 
//STRIP001 	hStyleSettings.SetDragFullOptions( nDragFullOptions );
//STRIP001 	rSettings.SetStyleSettings ( hStyleSettings );
//STRIP001 
//STRIP001 	MiscSettings aMiscSettings( rSettings.GetMiscSettings() );
//STRIP001 	aMiscSettings.SetTwoDigitYearStart( (USHORT)GetMiscConfig()->GetYear2000() );
//STRIP001 	rSettings.SetMiscSettings( aMiscSettings );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 /*
//STRIP001 BasicIDE* OfficeApplication::GetBasicIDE()
//STRIP001 {
//STRIP001 	if(!pDataImpl->pBasicIDE)
//STRIP001 		pDataImpl->pBasicIDE = new BasicIDE;
//STRIP001 	return pDataImpl->pBasicIDE;
//STRIP001 }
//STRIP001 */
//STRIP001 /* -----------------11.02.99 13:57-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 SfxItemSet*	OfficeApplication::CreateItemSet( sal_uInt16 nId )
//STRIP001 {
//STRIP001 	Reference< XPropertySet >  xProp( SvxGetLinguPropertySet() );
//STRIP001 
//STRIP001 	SfxItemSet*	pRet = 0;
//STRIP001 	switch(nId)
//STRIP001 	{
//STRIP001         case SID_GENERAL_OPTIONS:
//STRIP001 		{
//STRIP001 			pRet = new SfxItemSet(
//STRIP001 				GetPool(),
//STRIP001 				SID_BASIC_ENABLED, SID_BASIC_ENABLED,
//STRIP001 //SID_OPTIONS_START - ..END
//STRIP001 				SID_OPTIONS_START, SID_INET_PROXY_PORT,
//STRIP001                 SID_INET_SMTPSERVER, SID_INET_SMTPSERVER,
//STRIP001 				SID_INET_NOPROXY, SID_INET_SOCKS_PROXY_PORT,
//STRIP001 				SID_INET_DNS_AUTO, SID_INET_DNS_SERVER,
//STRIP001                 SID_INET_EXE_PLUGIN, SID_INET_EXE_PLUGIN,
//STRIP001 				SID_ATTR_BUTTON_OUTSTYLE3D, SID_ATTR_BUTTON_BIGSIZE,
//STRIP001 				SID_ATTR_AUTO_STYLE_UPDATE, SID_AUTOHELPAGENT_RESET,
//STRIP001 				SID_ATTR_QUICKLAUNCHER, SID_APPEAR_COLORED_TABCTRL,
//STRIP001 				SID_ATTR_ALLOWFOLDERWEBVIEW, SID_HELPAGENT_TIMEOUT,
//STRIP001 				SID_PRINTER_NOTFOUND_WARN, SID_PRINTER_NOTFOUND_WARN,
//STRIP001 				SID_PRINTER_CHANGESTODOC, SID_PRINTER_CHANGESTODOC,
//STRIP001 				SID_SECURE_URL, SID_SECURE_URL,
//STRIP001 #if defined( UNX ) || defined ( FS_PRIV_DEBUG )
//STRIP001 				SID_OPT_FONT_ANTIALIASING_ENABLED, SID_OPT_FONT_ANTIALIASING_MINPIXELS,
//STRIP001 #endif
//STRIP001                 SID_OPT_MIDDLE_MOUSE, SID_OPT_MIDDLE_MOUSE,
//STRIP001                 SID_MACRO_WARNING,  SID_MACRO_CONFIRMATION,
//STRIP001                 SID_HELP_STYLESHEET, SID_HELP_STYLESHEET,
//STRIP001                 0 );
//STRIP001 
//STRIP001 			GetOptions(*pRet);
//STRIP001 			pRet->Put(SvxAddressItem(SID_ATTR_ADDRESS));
//STRIP001 
//STRIP001 			SfxMiscCfg*	pMisc = GetMiscConfig();
//STRIP001 			const SfxPoolItem* pItem;
//STRIP001 			SfxPoolItem* pClone;
//STRIP001             SfxViewFrame* pViewFrame = SfxViewFrame::Current();
//STRIP001             if ( pViewFrame )
//STRIP001             {
//STRIP001                 SfxDispatcher* pDispatch = pViewFrame->GetDispatcher();
//STRIP001 
//STRIP001                 sal_Bool bAppUndo = sal_False;
//STRIP001     //          UndoCount fuer den Writer extra
//STRIP001                 if(SFX_ITEM_AVAILABLE <= pDispatch->QueryState( SID_ATTR_UNDO_COUNT, pItem) )
//STRIP001                 {
//STRIP001                     pClone = pItem->Clone();
//STRIP001                     pRet->Put(*pClone);
//STRIP001                     delete pClone;
//STRIP001                     bAppUndo = sal_True;
//STRIP001                 }
//STRIP001 
//STRIP001                 // Sonstiges - Year2000
//STRIP001                 if( SFX_ITEM_AVAILABLE <= pDispatch->QueryState( SID_ATTR_YEAR2000, pItem ) )
//STRIP001                     pRet->Put( SfxUInt16Item( SID_ATTR_YEAR2000, ((const SfxUInt16Item*)pItem)->GetValue() ) );
//STRIP001                 else
//STRIP001                     pRet->Put( SfxUInt16Item( SID_ATTR_YEAR2000, (USHORT)pMisc->GetYear2000() ) );
//STRIP001             }
//STRIP001             else
//STRIP001                 pRet->Put( SfxUInt16Item( SID_ATTR_YEAR2000, (USHORT)pMisc->GetYear2000() ) );
//STRIP001 
//STRIP001 
//STRIP001 			// Sonstiges - Tabulator
//STRIP001             pRet->Put(SfxBoolItem(SID_PRINTER_NOTFOUND_WARN, pMisc->IsNotFoundWarning()));
//STRIP001 
//STRIP001 			sal_uInt16 nFlag = pMisc->IsPaperSizeWarning() ? SFX_PRINTER_CHG_SIZE : 0;
//STRIP001             nFlag  |= pMisc->IsPaperOrientationWarning()  ? SFX_PRINTER_CHG_ORIENTATION : 0;
//STRIP001 			pRet->Put( SfxFlagItem( SID_PRINTER_CHANGESTODOC, nFlag ));
//STRIP001 
//STRIP001 			// Optionen Allgemein -- Darstellung
//STRIP001 			OfaTabAppearanceCfg* pAppearanceCfg = GetTabAppearanceConfig();
//STRIP001 			sal_uInt16 nSet;
//STRIP001 
//STRIP001 			nSet = pAppearanceCfg->GetLookNFeel();
//STRIP001 			pRet->Put(SfxUInt16Item (SID_OPT_SYSTEMLOOK,    nSet) );
//STRIP001 
//STRIP001 			nSet = pAppearanceCfg->GetScaleFactor();
//STRIP001 			pRet->Put(SfxUInt16Item (SID_OPT_SCREENSCALING, nSet) );
//STRIP001 
//STRIP001 			nSet = pAppearanceCfg->GetDragMode();
//STRIP001 			pRet->Put(SfxUInt16Item (SID_OPT_DRAGMODE,      nSet) );
//STRIP001 
//STRIP001             pRet->Put(SfxInt16Item (SID_OPT_SNAPTYPE, pAppearanceCfg->GetSnapMode()) );
//STRIP001             pRet->Put(SfxInt16Item (SID_OPT_MIDDLE_MOUSE, pAppearanceCfg->GetMiddleMouseButton()));
//STRIP001 #if defined( UNX ) || defined ( FS_PRIV_DEBUG )
//STRIP001 			pRet->Put( SfxBoolItem( SID_OPT_FONT_ANTIALIASING_ENABLED, pAppearanceCfg->IsFontAntiAliasing() ) );
//STRIP001 			pRet->Put( SfxUInt16Item( SID_OPT_FONT_ANTIALIASING_MINPIXELS, pAppearanceCfg->GetFontAntialiasingMinPixelHeight() ) );
//STRIP001 #endif
//STRIP001 
//STRIP001 			AllSettings   hAppSettings = Application::GetSettings();
//STRIP001 			MouseSettings hMouseSettings = hAppSettings.GetMouseSettings();
//STRIP001 			sal_uInt32 nFollow = hMouseSettings.GetFollow();
//STRIP001 
//STRIP001 			sal_uInt16 nTabStyle = hAppSettings.GetStyleSettings().GetTabControlStyle();
//STRIP001 
//STRIP001 			pRet->Put(SfxBoolItem(SID_APPEAR_MENUE_MOUSE_FOLLOW,
//STRIP001 									0 != (nFollow&MOUSE_FOLLOW_MENU)));
//STRIP001 			pRet->Put(SfxBoolItem(SID_APPEAR_SINGLE_LINE_TABCTRL,
//STRIP001 						0 !=(nTabStyle&STYLE_TABCONTROL_SINGLELINE)));
//STRIP001 			pRet->Put(SfxBoolItem(SID_APPEAR_COLORED_TABCTRL,
//STRIP001 						0 !=(nTabStyle&STYLE_TABCONTROL_COLOR)));
//STRIP001 		}
//STRIP001 		break;
//STRIP001         case SID_LANGUAGE_OPTIONS:
//STRIP001         {
//STRIP001             pRet = new SfxItemSet(
//STRIP001 				GetPool(),
//STRIP001                 SID_ATTR_LANGUAGE, SID_AUTOSPELL_MARKOFF,
//STRIP001                 SID_ATTR_CHAR_CJK_LANGUAGE, SID_ATTR_CHAR_CTL_LANGUAGE,
//STRIP001                 SID_OPT_LOCALE_CHANGED, SID_OPT_LOCALE_CHANGED,
//STRIP001 				0 );
//STRIP001 
//STRIP001 			// fuer die Linguistik
//STRIP001 
//STRIP001 			Reference< XSpellChecker1 >  xSpell = SvxGetSpellChecker();
//STRIP001 			pRet->Put(SfxSpellCheckItem( xSpell, SID_ATTR_SPELL ));
//STRIP001 			SfxHyphenRegionItem aHyphen( SID_ATTR_HYPHENREGION );
//STRIP001 
//STRIP001 			sal_Int16 	nMinLead  = 2,
//STRIP001 						nMinTrail = 2;
//STRIP001 			if (xProp.is())
//STRIP001 			{
//STRIP001 				xProp->getPropertyValue( String::CreateFromAscii(
//STRIP001 						UPN_HYPH_MIN_LEADING) ) >>= nMinLead;
//STRIP001 				xProp->getPropertyValue( String::CreateFromAscii(
//STRIP001 						UPN_HYPH_MIN_TRAILING) ) >>= nMinTrail;
//STRIP001 			}
//STRIP001 			aHyphen.GetMinLead()  = (sal_uInt8)nMinLead;
//STRIP001 			aHyphen.GetMinTrail() = (sal_uInt8)nMinTrail;
//STRIP001 
//STRIP001 			const SfxPoolItem* pItem;
//STRIP001 			SfxPoolItem* pClone;
//STRIP001             SfxViewFrame* pViewFrame = SfxViewFrame::Current();
//STRIP001             if ( pViewFrame )
//STRIP001             {
//STRIP001                 SfxDispatcher* pDispatch = pViewFrame->GetDispatcher();
//STRIP001                 if(SFX_ITEM_AVAILABLE <= pDispatch->QueryState(SID_ATTR_LANGUAGE, pItem))
//STRIP001                     pRet->Put(SfxUInt16Item(SID_ATTR_LANGUAGE, ((const SvxLanguageItem*)pItem)->GetLanguage()));
//STRIP001                 if(SFX_ITEM_AVAILABLE <= pDispatch->QueryState(SID_ATTR_CHAR_CJK_LANGUAGE, pItem))
//STRIP001                     pRet->Put(SfxUInt16Item(SID_ATTR_CHAR_CJK_LANGUAGE, ((const SvxLanguageItem*)pItem)->GetLanguage()));
//STRIP001                 if(SFX_ITEM_AVAILABLE <= pDispatch->QueryState(SID_ATTR_CHAR_CTL_LANGUAGE, pItem))
//STRIP001                     pRet->Put(SfxUInt16Item(SID_ATTR_CHAR_CTL_LANGUAGE, ((const SvxLanguageItem*)pItem)->GetLanguage()));
//STRIP001 
//STRIP001 				pRet->Put(aHyphen);
//STRIP001                 if(SFX_ITEM_AVAILABLE <= pDispatch->QueryState(SID_AUTOSPELL_CHECK, pItem))
//STRIP001                 {
//STRIP001                     pClone = pItem->Clone();
//STRIP001                     pRet->Put(*pClone);
//STRIP001                     delete pClone;
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                         sal_Bool bVal = sal_False;
//STRIP001                         if (xProp.is())
//STRIP001                         {
//STRIP001                             xProp->getPropertyValue( String::CreateFromAscii( UPN_IS_SPELL_AUTO) ) >>= bVal;
//STRIP001                         }
//STRIP001 
//STRIP001                         pRet->Put(SfxBoolItem(SID_AUTOSPELL_CHECK, bVal));
//STRIP001                 }
//STRIP001 
//STRIP001                 if(SFX_ITEM_AVAILABLE <= pDispatch->QueryState(SID_AUTOSPELL_MARKOFF, pItem))
//STRIP001                 {
//STRIP001                     pClone = pItem->Clone();
//STRIP001                     pRet->Put(*pClone);
//STRIP001                     delete pClone;
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     sal_Bool bVal = sal_False;
//STRIP001                     if (xProp.is())
//STRIP001                     {
//STRIP001                         xProp->getPropertyValue( String::CreateFromAscii( UPN_IS_SPELL_HIDE) ) >>= bVal;
//STRIP001                     }
//STRIP001                     pRet->Put(SfxBoolItem(SID_AUTOSPELL_MARKOFF, bVal));
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         break;
//STRIP001         case SID_INET_DLG :
//STRIP001 				pRet = new SfxItemSet(GetPool(),
//STRIP001 								SID_BASIC_ENABLED, SID_BASIC_ENABLED,
//STRIP001 				//SID_OPTIONS_START - ..END
//STRIP001 								SID_OPTIONS_START, SID_INET_PROXY_PORT,
//STRIP001 								SID_SAVEREL_INET, SID_SAVEREL_FSYS,
//STRIP001 								SID_INET_SMTPSERVER, SID_INET_SMTPSERVER,
//STRIP001 								SID_INET_NOPROXY, SID_INET_SOCKS_PROXY_PORT,
//STRIP001 								SID_INET_DNS_AUTO, SID_INET_DNS_SERVER,
//STRIP001 								SID_SECURE_URL, SID_SECURE_URL,
//STRIP001 								0L );
//STRIP001 				GetOptions(*pRet);
//STRIP001 		break;
//STRIP001 		case SID_FILTER_DLG:
//STRIP001             pRet = new SfxItemSet( GetPool(),
//STRIP001             SID_ATTR_DOCINFO, SID_ATTR_AUTOSAVEMINUTE,
//STRIP001             SID_SAVEREL_INET, SID_SAVEREL_FSYS,
//STRIP001 			SID_ATTR_PRETTYPRINTING, SID_ATTR_PRETTYPRINTING,
//STRIP001             0 );
//STRIP001             GetOptions(*pRet);
//STRIP001             break;
//STRIP001 
//STRIP001 		case SID_SB_STARBASEOPTIONS:
//STRIP001             pRet = new SfxItemSet( GetPool(),
//STRIP001             SID_SB_POOLING_ENABLED, SID_SB_DRIVER_TIMEOUTS,
//STRIP001             0 );
//STRIP001 			::offapp::ConnectionPoolConfig::GetOptions(*pRet);
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 /* -----------------11.02.99 13:57-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 void	OfficeApplication::ApplyItemSet( sal_uInt16 nId, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	switch(nId)
//STRIP001 	{
//STRIP001 		case SID_GENERAL_OPTIONS:
//STRIP001 		{
//STRIP001 			SfxMiscCfg*	pMisc = GetMiscConfig();
//STRIP001 			const SfxPoolItem* pItem;
//STRIP001 			SetOptions( rSet );
//STRIP001 			// Dispatcher neu holen, weil SetOptions() ggf. den Dispatcher zerst"ort hat
//STRIP001             SfxViewFrame *pViewFrame = SfxViewFrame::Current();
//STRIP001 // -------------------------------------------------------------------------
//STRIP001 //							Adresse setzen
//STRIP001 // -------------------------------------------------------------------------
//STRIP001 			if ( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_ADDRESS, sal_False, &pItem ) )
//STRIP001 			{
//STRIP001 				( (SvxAddressItem*)pItem )->Store();
//STRIP001 			}
//STRIP001 
//STRIP001 // -------------------------------------------------------------------------
//STRIP001 //			Year2000 auswerten
//STRIP001 // -------------------------------------------------------------------------
//STRIP001 
//STRIP001             USHORT nY2K = USHRT_MAX;
//STRIP001             if( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_YEAR2000, sal_False, &pItem ) )
//STRIP001                 nY2K = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001             if ( pViewFrame )
//STRIP001             {
//STRIP001                 SfxDispatcher* pDispatch = pViewFrame->GetDispatcher();
//STRIP001                 if( USHRT_MAX != nY2K)
//STRIP001                 {
//STRIP001                     pDispatch->Execute( SID_ATTR_YEAR2000, SFX_CALLMODE_ASYNCHRON, pItem, 0L);
//STRIP001                 }
//STRIP001 
//STRIP001 // -------------------------------------------------------------------------
//STRIP001 //			UndoCount fuer den Writer extra
//STRIP001 // -------------------------------------------------------------------------
//STRIP001 
//STRIP001                 sal_Bool bAppUndo = sal_False;
//STRIP001     //          UndoCount fuer den Writer extra
//STRIP001                 if(SFX_ITEM_AVAILABLE <= pDispatch->QueryState( SID_ATTR_UNDO_COUNT, pItem)
//STRIP001                     && SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_UNDO_COUNT, sal_False, &pItem))
//STRIP001                 {
//STRIP001                     pDispatch->Execute(SID_ATTR_UNDO_COUNT, SFX_CALLMODE_ASYNCHRON|SFX_CALLMODE_RECORD, pItem, 0L);
//STRIP001                 }
//STRIP001             }
//STRIP001             if( USHRT_MAX != nY2K)
//STRIP001             {
//STRIP001                 pMisc->SetYear2000( nY2K );
//STRIP001                 // an die Settings fuer VCL-Fields und NumberFormatter-Default propagieren
//STRIP001                 AllSettings aAllSettings( Application::GetSettings() );
//STRIP001                 MiscSettings aMiscSettings( aAllSettings.GetMiscSettings() );
//STRIP001                 aMiscSettings.SetTwoDigitYearStart( (USHORT)pMisc->GetYear2000() );
//STRIP001                 aAllSettings.SetMiscSettings( aMiscSettings );
//STRIP001                 Application::SetSettings( aAllSettings );
//STRIP001             }
//STRIP001 
//STRIP001 // -------------------------------------------------------------------------
//STRIP001 //			Drucken auswerten
//STRIP001 // -------------------------------------------------------------------------
//STRIP001 
//STRIP001 			if(SFX_ITEM_SET == rSet.GetItemState(SID_PRINTER_NOTFOUND_WARN, sal_False, &pItem))
//STRIP001 				pMisc->SetNotFoundWarning(((const SfxBoolItem*)pItem)->GetValue());
//STRIP001 
//STRIP001 			if(SFX_ITEM_SET == rSet.GetItemState(SID_PRINTER_CHANGESTODOC, sal_False, &pItem))
//STRIP001 			{
//STRIP001 				const SfxFlagItem* pFlag = (const SfxFlagItem*)pItem;
//STRIP001 				pMisc->SetPaperSizeWarning(0 != (pFlag->GetValue() &  SFX_PRINTER_CHG_SIZE ));
//STRIP001                 pMisc->SetPaperOrientationWarning(0 !=  (pFlag->GetValue() & SFX_PRINTER_CHG_ORIENTATION ));
//STRIP001 			}
//STRIP001 
//STRIP001 // -------------------------------------------------------------------------
//STRIP001 //			Appearance auswerten
//STRIP001 // -------------------------------------------------------------------------
//STRIP001 
//STRIP001 			AllSettings   hAppSettings = Application::GetSettings();
//STRIP001 			StyleSettings hAppStyle    = hAppSettings.GetStyleSettings();
//STRIP001 			sal_Bool  bAppChanged = sal_False;
//STRIP001 
//STRIP001 			OfaTabAppearanceCfg* pAppearanceCfg = GetTabAppearanceConfig();
//STRIP001 			// Look & Feel
//STRIP001 			if(SFX_ITEM_SET == rSet.GetItemState(SID_OPT_SYSTEMLOOK, sal_False, &pItem))
//STRIP001 			{
//STRIP001 				pAppearanceCfg->SetLookNFeel( ((const SfxUInt16Item*)pItem)->GetValue() );
//STRIP001 				bAppChanged = sal_True;
//STRIP001 			}
//STRIP001 
//STRIP001 			// Screen and ScreenFont Scaling
//STRIP001 			if(SFX_ITEM_SET == rSet.GetItemState(SID_OPT_SCREENSCALING, sal_False, &pItem))
//STRIP001 			{
//STRIP001 				pAppearanceCfg->SetScaleFactor( ((const SfxUInt16Item*)pItem)->GetValue() );
//STRIP001 				bAppChanged = sal_True;
//STRIP001 			}
//STRIP001 
//STRIP001 			// Mouse Snap
//STRIP001 			if(SFX_ITEM_SET == rSet.GetItemState(SID_OPT_SNAPTYPE, sal_False, &pItem))
//STRIP001 			{
//STRIP001                 pAppearanceCfg->SetSnapMode( ((const SfxInt16Item*)pItem)->GetValue() );
//STRIP001 				bAppChanged = sal_True;
//STRIP001 			}
//STRIP001             // Middle mouse button
//STRIP001             if(SFX_ITEM_SET == rSet.GetItemState(SID_OPT_MIDDLE_MOUSE, sal_False, &pItem))
//STRIP001 			{
//STRIP001                 pAppearanceCfg->SetMiddleMouseButton( ((const SfxInt16Item*)pItem)->GetValue() );
//STRIP001 				bAppChanged = sal_True;
//STRIP001 			}
//STRIP001 
//STRIP001 #if defined( UNX ) || defined ( FS_PRIV_DEBUG )
//STRIP001 			// Font Antialising - enabled
//STRIP001 			if (SFX_ITEM_SET == rSet.GetItemState(SID_OPT_FONT_ANTIALIASING_ENABLED, sal_False, &pItem) )
//STRIP001 			{
//STRIP001                 pAppearanceCfg->SetFontAntiAliasing( static_cast< const SfxBoolItem* >( pItem )->GetValue() );
//STRIP001 				bAppChanged = sal_True;
//STRIP001 			}
//STRIP001 
//STRIP001 			// Font Antialising - min pixel height
//STRIP001 			if (SFX_ITEM_SET == rSet.GetItemState(SID_OPT_FONT_ANTIALIASING_MINPIXELS, sal_False, &pItem) )
//STRIP001 			{
//STRIP001                 pAppearanceCfg->SetFontAntialiasingMinPixelHeight( static_cast< const SfxUInt16Item* >( pItem )->GetValue() );
//STRIP001 				bAppChanged = sal_True;
//STRIP001 			}
//STRIP001 #endif
//STRIP001 
//STRIP001 			// Show Full Window while dragging?
//STRIP001 			if(SFX_ITEM_SET == rSet.GetItemState(SID_OPT_DRAGMODE, sal_False, &pItem))
//STRIP001 			{
//STRIP001 				pAppearanceCfg->SetDragMode( ((const SfxUInt16Item*)pItem)->GetValue() );
//STRIP001 				bAppChanged = sal_True;
//STRIP001 			}
//STRIP001 
//STRIP001 			if(SFX_ITEM_SET == rSet.GetItemState(SID_APPEAR_MENUE_MOUSE_FOLLOW, sal_False, &pItem))
//STRIP001 			{
//STRIP001 				pAppearanceCfg->SetMenuMouseFollow( ((const SfxBoolItem*)pItem)->GetValue() );
//STRIP001 				bAppChanged = sal_True;
//STRIP001 			}
//STRIP001 
//STRIP001 			if(SFX_ITEM_SET == rSet.GetItemState(SID_APPEAR_SINGLE_LINE_TABCTRL, sal_False, &pItem))
//STRIP001 			{
//STRIP001 				pAppearanceCfg->SetSingleLineTabCtrl( ((const SfxBoolItem*)pItem)->GetValue() );
//STRIP001 				bAppChanged = sal_True;
//STRIP001 			}
//STRIP001 
//STRIP001 			if(SFX_ITEM_SET == rSet.GetItemState(SID_APPEAR_COLORED_TABCTRL, sal_False, &pItem))
//STRIP001 			{
//STRIP001 				pAppearanceCfg->SetColoredTabCtrl(((const SfxBoolItem*)pItem)->GetValue() );
//STRIP001 				bAppChanged = sal_True;
//STRIP001 			}
//STRIP001 
//STRIP001 			// Appearance has changed ? publish it to Application
//STRIP001 			if ( bAppChanged )
//STRIP001 			{
//STRIP001 				pAppearanceCfg->SetApplicationDefaults ( GetpApp() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		break;
//STRIP001         case SID_LANGUAGE_OPTIONS :
//STRIP001         {
//STRIP001             sal_Bool bSaveSpellCheck = sal_False;
//STRIP001             const SfxPoolItem* pItem;
//STRIP001 			if ( SFX_ITEM_SET == rSet.GetItemState( SID_SPELL_MODIFIED, sal_False, &pItem ) )
//STRIP001 			{
//STRIP001 				bSaveSpellCheck = ( (const SfxBoolItem*)pItem )->GetValue();
//STRIP001 			}
//STRIP001             Reference< XMultiServiceFactory >  xMgr( ::legacy_binfilters::getLegacyProcessServiceFactory() );
//STRIP001 			Reference< XPropertySet >  xProp(
//STRIP001 					xMgr->createInstance( OUString::createFromAscii(
//STRIP001 							"com.sun.star.linguistic2.LinguProperties") ),
//STRIP001 					UNO_QUERY );
//STRIP001             if ( SFX_ITEM_SET == rSet.GetItemState(SID_ATTR_HYPHENREGION, sal_False, &pItem ) )
//STRIP001 			{
//STRIP001 				const SfxHyphenRegionItem* pHyphenItem = (const SfxHyphenRegionItem*)pItem;
//STRIP001 
//STRIP001 				if (xProp.is())
//STRIP001 				{
//STRIP001 					xProp->setPropertyValue(
//STRIP001 							String::CreateFromAscii(UPN_HYPH_MIN_LEADING),
//STRIP001 							makeAny((sal_Int16) pHyphenItem->GetMinLead()) );
//STRIP001 					xProp->setPropertyValue(
//STRIP001 							String::CreateFromAscii(UPN_HYPH_MIN_TRAILING),
//STRIP001 							makeAny((sal_Int16) pHyphenItem->GetMinTrail()) );
//STRIP001 				}
//STRIP001 				bSaveSpellCheck = sal_True;
//STRIP001 			}
//STRIP001 
//STRIP001             SfxViewFrame *pViewFrame = SfxViewFrame::Current();
//STRIP001             if ( pViewFrame )
//STRIP001             {
//STRIP001                 SfxDispatcher* pDispatch = pViewFrame->GetDispatcher();
//STRIP001 				pItem = 0;
//STRIP001 				if(SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_LANGUAGE, sal_False, &pItem ))
//STRIP001 				{
//STRIP001                 	pDispatch->Execute(pItem->Which(),    SFX_CALLMODE_ASYNCHRON, pItem, 0L);
//STRIP001                     bSaveSpellCheck = sal_True;
//STRIP001 				}
//STRIP001 				if(SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_CHAR_CTL_LANGUAGE, sal_False, &pItem ))
//STRIP001 				{
//STRIP001                 	pDispatch->Execute(pItem->Which(),    SFX_CALLMODE_ASYNCHRON, pItem, 0L);
//STRIP001                     bSaveSpellCheck = sal_True;
//STRIP001 				}
//STRIP001 				if(SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_CHAR_CJK_LANGUAGE, sal_False, &pItem ))
//STRIP001 				{
//STRIP001                 	pDispatch->Execute(pItem->Which(),    SFX_CALLMODE_ASYNCHRON, pItem, 0L);
//STRIP001                     bSaveSpellCheck = sal_True;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( SFX_ITEM_SET == rSet.GetItemState(SID_AUTOSPELL_CHECK, sal_False, &pItem ))
//STRIP001                 {
//STRIP001                     sal_Bool bOnlineSpelling = ((const SfxBoolItem*)pItem)->GetValue();
//STRIP001                     pDispatch->Execute(SID_AUTOSPELL_CHECK,
//STRIP001                         SFX_CALLMODE_ASYNCHRON|SFX_CALLMODE_RECORD, pItem, 0L);
//STRIP001 
//STRIP001                     if (xProp.is())
//STRIP001                     {
//STRIP001                         xProp->setPropertyValue(
//STRIP001                                 String::CreateFromAscii(UPN_IS_SPELL_AUTO),
//STRIP001                                 makeAny(bOnlineSpelling) );
//STRIP001                     }
//STRIP001                 }
//STRIP001 
//STRIP001                 if( SFX_ITEM_SET == rSet.GetItemState(SID_AUTOSPELL_MARKOFF, sal_False, &pItem ))
//STRIP001                 {
//STRIP001                     sal_Bool bHideSpell = ((const SfxBoolItem*)pItem)->GetValue();
//STRIP001                     pDispatch->Execute(SID_AUTOSPELL_MARKOFF, SFX_CALLMODE_ASYNCHRON|SFX_CALLMODE_RECORD, pItem, 0L);
//STRIP001 
//STRIP001                     if (xProp.is())
//STRIP001                     {
//STRIP001                         xProp->setPropertyValue(
//STRIP001                                 String::CreateFromAscii(UPN_IS_SPELL_HIDE),
//STRIP001                                 makeAny(bHideSpell) );
//STRIP001                     }
//STRIP001                 }
//STRIP001 
//STRIP001                 if( bSaveSpellCheck )
//STRIP001                 {
//STRIP001                     //! the config item has changed since we modified the
//STRIP001                     //! property set it uses
//STRIP001                     pDispatch->Execute(SID_SPELLCHECKER_CHANGED, SFX_CALLMODE_ASYNCHRON);
//STRIP001                 }
//STRIP001             }
//STRIP001 
//STRIP001             if( SFX_ITEM_SET == rSet.GetItemState(SID_OPT_LOCALE_CHANGED, sal_False, &pItem ))
//STRIP001             {
//STRIP001                 SfxViewFrame* pViewFrame = SfxViewFrame::GetFirst();
//STRIP001                 while ( pViewFrame )
//STRIP001                 {
//STRIP001                     pViewFrame->GetDispatcher()->Execute(pItem->Which(),    SFX_CALLMODE_ASYNCHRON, pItem, 0L);
//STRIP001                     pViewFrame = SfxViewFrame::GetNext( *pViewFrame );
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         break;
//STRIP001 		case SID_INET_DLG :
//STRIP001         case SID_FILTER_DLG:
//STRIP001 			SetOptions( rSet );
//STRIP001 
//STRIP001 		case SID_SB_STARBASEOPTIONS:
//STRIP001 			::offapp::ConnectionPoolConfig::SetOptions( rSet );
//STRIP001 			break;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 }
//STRIP001 /* -----------------11.02.99 13:57-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 
//STRIP001 typedef SfxTabPage* (*FNCreateTabPage)( Window *pParent, const SfxItemSet &rAttrSet );
//STRIP001 
//STRIP001 SfxTabPage*	OfficeApplication::CreateTabPage( sal_uInt16 nId, Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	FNCreateTabPage fnCreate = 0;
//STRIP001 	switch(nId)
//STRIP001 	{
//STRIP001 		case RID_SFXPAGE_SAVE:						fnCreate = &SvxSaveTabPage::Create; break;
//STRIP001 		case RID_SFXPAGE_PATH:						fnCreate = &SvxPathTabPage::Create; break;
//STRIP001 		case RID_SFXPAGE_GENERAL:					fnCreate = &SvxGeneralTabPage::Create; break;
//STRIP001 		case RID_SFXPAGE_PRINTOPTIONS:				fnCreate = &SfxCommonPrintOptionsTabPage::Create; break;
//STRIP001 		case OFA_TP_HELPERPROG:						fnCreate = &OfaHelperProgramsTabPage::Create; break;
//STRIP001 		case OFA_TP_LANGUAGES:						fnCreate = &OfaLanguagesTabPage::Create; break;
//STRIP001 		case RID_SFXPAGE_LINGU:						fnCreate = &SvxLinguTabPage::Create; break;
//STRIP001 		case RID_SVXPAGE_COLOR:						fnCreate = &SvxColorTabPage::Create; break;
//STRIP001 		case OFA_TP_VIEW:							fnCreate = &OfaViewTabPage::Create; break;
//STRIP001 		case OFA_TP_MISC:							fnCreate = &OfaMiscTabPage::Create; break;
//STRIP001 		case OFA_TP_MEMORY:							fnCreate = &OfaMemoryOptionsPage::Create; break;
//STRIP001 		case RID_SVXPAGE_ASIAN_LAYOUT:				fnCreate = &SvxAsianLayoutPage::Create; break;
//STRIP001 		case RID_SVX_FONT_SUBSTITUTION:				fnCreate = &SvxFontSubstTabPage::Create; break;
//STRIP001 		case RID_SVXPAGE_INET_PROXY:				fnCreate = &SvxProxyTabPage::Create; break;
//STRIP001 		case RID_SVXPAGE_INET_SEARCH:				fnCreate = &SvxSearchTabPage::Create; break;
//STRIP001 		case RID_SVXPAGE_INET_SCRIPTING:			fnCreate = &SvxScriptingTabPage::Create; break;
//STRIP001 		case RID_SVXPAGE_COLORCONFIG:				fnCreate = &SvxColorOptionsTabPage::Create; break;
//STRIP001 		case RID_OFAPAGE_HTMLOPT:					fnCreate = &OfaHtmlTabPage::Create; break;
//STRIP001 		case SID_OPTFILTER_MSOFFICE:				fnCreate = &OfaMSFilterTabPage::Create; break;
//STRIP001 		case RID_OFAPAGE_MSFILTEROPT2:				fnCreate = &OfaMSFilterTabPage2::Create; break;
//STRIP001 		case RID_SVXPAGE_JSEARCH_OPTIONS:			fnCreate = &SvxJSearchOptionsPage::Create ; break;
//STRIP001 		case SID_SB_CONNECTIONPOOLING:				fnCreate = &::offapp::ConnectionPoolOptionsPage::Create; break;
//STRIP001 		case RID_SVXPAGE_ACCESSIBILITYCONFIG:		fnCreate = &SvxAccessibilityOptionsTabPage::Create; break;
//STRIP001 		case RID_SVXPAGE_SSO:						fnCreate = ( FNCreateTabPage )GetSSOCreator(); break;
//STRIP001 		case RID_SVXPAGE_OPTIONS_CTL:				fnCreate = &SvxCTLOptionsPage::Create ; break;
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxTabPage*	pRet = fnCreate ? (*fnCreate)( pParent, rSet ) : NULL;
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------11.02.99 13:57-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 void	OfficeApplication::ExecuteGeneralOptionsDialog(sal_uInt16 nSlot)
//STRIP001 {
//STRIP001 	//SID_OPTPAGE_USERDATA, SID_OPTPAGE_PROXY
//STRIP001 	OfaTreeOptionsDialog* pDlg = new OfaTreeOptionsDialog( NULL );
//STRIP001 
//STRIP001 	OfaPageResource aDlgResource;
//STRIP001 	sal_uInt16 nGroup = 0;
//STRIP001 	if(nSlot != SID_OPTPAGE_PROXY)
//STRIP001 	{
//STRIP001 		BOOL isSSOEnabled = EnableSSO();
//STRIP001 
//STRIP001 		ResStringArray& rGeneralArray = aDlgResource.GetGeneralArray();
//STRIP001 		nGroup = pDlg->AddGroup(rGeneralArray.GetString(0), this, 0, SID_GENERAL_OPTIONS );
//STRIP001 		sal_uInt16 nEnd = nSlot == SID_OPTIONS_TREEDIALOG ? rGeneralArray.Count() : 2;
//STRIP001 
//STRIP001         sal_uInt16 i;
//STRIP001         for(i = 1; i < nEnd; i++)
//STRIP001 		{
//STRIP001 			sal_uInt16 nPageId = (sal_uInt16)rGeneralArray.GetValue(i);
//STRIP001 			if ( nPageId != RID_SVXPAGE_SSO || isSSOEnabled )
//STRIP001 			{
//STRIP001 				pDlg->AddTabPage( nPageId, rGeneralArray.GetString(i), nGroup );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         //load/save
//STRIP001         ResStringArray& rFilterArray = aDlgResource.GetFilterArray();
//STRIP001         nGroup = pDlg->AddGroup( rFilterArray.GetString(0), this, 0,
//STRIP001                                     SID_FILTER_DLG );
//STRIP001         for(i = 1; i < rFilterArray.Count(); ++i )
//STRIP001             pDlg->AddTabPage( (sal_uInt16)rFilterArray.GetValue(i),
//STRIP001                                 rFilterArray.GetString(i), nGroup );
//STRIP001     }
//STRIP001 
//STRIP001     SvtLanguageOptions aLanguageOptions;
//STRIP001 
//STRIP001     if ( nSlot == SID_OPTIONS_TREEDIALOG )
//STRIP001 	{
//STRIP001         // language options
//STRIP001         ResStringArray& rLangArray = aDlgResource.GetLangArray();
//STRIP001         nGroup = pDlg->AddGroup( rLangArray.GetString(0), this, 0, SID_LANGUAGE_OPTIONS );
//STRIP001         for ( USHORT i = 1; i < rLangArray.Count(); ++i )
//STRIP001         {
//STRIP001             sal_uInt16 nValue = (sal_uInt16)rLangArray.GetValue(i);
//STRIP001             if ( ( RID_SVXPAGE_JSEARCH_OPTIONS != nValue || aLanguageOptions.IsJapaneseFindEnabled() ) &&
//STRIP001                  ( RID_SVXPAGE_ASIAN_LAYOUT != nValue    || aLanguageOptions.IsAsianTypographyEnabled() ) &&
//STRIP001 				 ( RID_SVXPAGE_OPTIONS_CTL != nValue 	 || aLanguageOptions.IsCTLFontEnabled() ) )
//STRIP001                 pDlg->AddTabPage( nValue, rLangArray.GetString(i), nGroup );
//STRIP001         }
//STRIP001     }
//STRIP001     if ( nSlot != SID_OPTPAGE_USERDATA )
//STRIP001 	{
//STRIP001 		// Internet
//STRIP001 		// f"ur SID_OPTPAGE_PROXY wird der komplett INet-Dlg angezeigt
//STRIP001 		ResStringArray& rInetArray = aDlgResource.GetInetArray();
//STRIP001 		nGroup = pDlg->AddGroup(rInetArray.GetString(0), this, 0, SID_INET_DLG );
//STRIP001 		//falls doch nur dir Proxy-Page gewuenscht wird, dann diese Zeile
//STRIP001 //		sal_uInt16 nEnd = nSlot == SID_OPTPAGE_PROXY ? 2 : rInetArray.Count();
//STRIP001 		sal_uInt16 nEnd = rInetArray.Count();
//STRIP001 
//STRIP001 		for ( sal_uInt16 i = 1; i < nEnd; i++ )
//STRIP001 		{
//STRIP001 			sal_uInt16 nPageId = (sal_uInt16)rInetArray.GetValue(i);
//STRIP001 			pDlg->AddTabPage( nPageId, rInetArray.GetString(i), nGroup );
//STRIP001 		}
//STRIP001 		if ( nSlot == SID_OPTPAGE_PROXY )
//STRIP001 			pDlg->ActivatePage(	RID_SVXPAGE_INET_PROXY );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nSlot == SID_OPTIONS_TREEDIALOG )
//STRIP001 	{
//STRIP001         sal_Bool bHasAnyFilter = sal_False;
//STRIP001 		SvtModuleOptions aModuleOpt;
//STRIP001 		if ( aModuleOpt.IsWriter() )
//STRIP001 		{
//STRIP001 			// Textdokument
//STRIP001 			bHasAnyFilter = sal_True;
//STRIP001 			ResStringArray& rTextArray = aDlgResource.GetTextArray();
//STRIP001 			SfxModule *pSwMod = (*(SfxModule**) GetAppData(BF_SHL_WRITER));
//STRIP001 			nGroup = pDlg->AddGroup(rTextArray.GetString(0), pSwMod, pSwMod, SID_SW_EDITOPTIONS );
//STRIP001 			for(USHORT i = 1; i < rTextArray.Count(); i++)
//STRIP001             {
//STRIP001                 sal_uInt16 nValue = (sal_uInt16)rTextArray.GetValue(i);
//STRIP001                 if((RID_SW_TP_STD_FONT_CJK != nValue || aLanguageOptions.IsCJKFontEnabled())&&
//STRIP001                     (RID_SW_TP_STD_FONT_CTL != nValue || aLanguageOptions.IsCTLFontEnabled()))
//STRIP001                     pDlg->AddTabPage( nValue, rTextArray.GetString(i), nGroup);
//STRIP001             }
//STRIP001 #ifndef PRODUCT
//STRIP001 			pDlg->AddTabPage( RID_SW_TP_OPTTEST_PAGE, String::CreateFromAscii("Interner Test"), nGroup);
//STRIP001 #endif
//STRIP001 			// HTML-Dokument
//STRIP001 			ResStringArray& rHTMLArray = aDlgResource.GetHTMLArray();
//STRIP001 			nGroup = pDlg->AddGroup(rHTMLArray.GetString(0), pSwMod, pSwMod, SID_SW_ONLINEOPTIONS );
//STRIP001 			for(i = 1; i < rHTMLArray.Count(); i++)
//STRIP001 				pDlg->AddTabPage( (sal_uInt16)rHTMLArray.GetValue(i), rHTMLArray.GetString(i), nGroup);
//STRIP001 #ifndef PRODUCT
//STRIP001 			pDlg->AddTabPage( RID_SW_TP_OPTTEST_PAGE, String::CreateFromAscii("Interner Test"), nGroup);
//STRIP001 #endif
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aModuleOpt.IsCalc() )
//STRIP001 		{
//STRIP001 			// StarCalc-Dialog
//STRIP001 			bHasAnyFilter = sal_True;
//STRIP001 			SfxModule*		pScMod = ( *( SfxModule** ) GetAppData( BF_SHL_CALC ) );
//STRIP001 			ResStringArray&	rCalcArray = aDlgResource.GetCalcArray();
//STRIP001 			nGroup = pDlg->AddGroup( rCalcArray.GetString( 0 ), pScMod, pScMod, SID_SC_EDITOPTIONS );
//STRIP001 			const sal_Bool	bCTL = aLanguageOptions.IsCTLFontEnabled();
//STRIP001 			sal_uInt16		nId;
//STRIP001 			const USHORT	nCount = rCalcArray.Count();
//STRIP001 			for( USHORT i = 1 ; i < nCount ; ++i )
//STRIP001 			{
//STRIP001 				nId = ( sal_uInt16 ) rCalcArray.GetValue( i );
//STRIP001 //				if( bCTL || nId != RID_OFA_TP_INTERNATIONAL )
//STRIP001 //				#103755# if an international tabpage is need one day, this should be used again... ;-)
//STRIP001 				if( nId != RID_OFA_TP_INTERNATIONAL )
//STRIP001 					pDlg->AddTabPage( nId, rCalcArray.GetString( i ), nGroup );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aModuleOpt.IsImpress() )
//STRIP001 		{
//STRIP001 			//Praesentation
//STRIP001 			bHasAnyFilter = sal_True;
//STRIP001 			SfxModule*		pSdMod = ( *( SfxModule** ) GetAppData( BF_SHL_DRAW ) );
//STRIP001 			ResStringArray&	rImpressArray = aDlgResource.GetImpressArray();
//STRIP001 			nGroup = pDlg->AddGroup( rImpressArray.GetString( 0 ), pSdMod, pSdMod, SID_SD_EDITOPTIONS );
//STRIP001 			const sal_Bool	bCTL = aLanguageOptions.IsCTLFontEnabled();
//STRIP001 			sal_uInt16		nId;
//STRIP001 			const USHORT	nCount = rImpressArray.Count();
//STRIP001 			for( USHORT i = 1 ; i < nCount ; ++i )
//STRIP001 			{
//STRIP001 				nId = ( sal_uInt16 ) rImpressArray.GetValue( i );
//STRIP001 				if( bCTL || nId != RID_OFA_TP_INTERNATIONAL_IMPR )
//STRIP001 					pDlg->AddTabPage( nId, rImpressArray.GetString( i ), nGroup );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aModuleOpt.IsDraw() )
//STRIP001 		{
//STRIP001 			//Zeichnung
//STRIP001 			SfxModule*		pSdMod = ( *( SfxModule** ) GetAppData( BF_SHL_DRAW ) );
//STRIP001 			ResStringArray&	rDrawArray = aDlgResource.GetDrawArray();
//STRIP001 			nGroup = pDlg->AddGroup( rDrawArray.GetString( 0 ), pSdMod, pSdMod, SID_SD_GRAPHIC_OPTIONS );
//STRIP001 			const sal_Bool	bCTL = aLanguageOptions.IsCTLFontEnabled();
//STRIP001 			sal_uInt16		nId;
//STRIP001 			const USHORT	nCount = rDrawArray.Count();
//STRIP001 			for( USHORT i = 1 ; i < nCount ; ++i )
//STRIP001 			{
//STRIP001 				nId = ( sal_uInt16 ) rDrawArray.GetValue( i );
//STRIP001 				if( bCTL || nId != RID_OFA_TP_INTERNATIONAL_SD )
//STRIP001 					pDlg->AddTabPage( nId, rDrawArray.GetString( i ), nGroup );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aModuleOpt.IsMath() )
//STRIP001 		{
//STRIP001 			// StarMath-Dialog
//STRIP001 			SfxModule *pSmMod = (*(SfxModule**) GetAppData(BF_SHL_SM));
//STRIP001 			ResStringArray& rStarMathArray = aDlgResource.GetStarMathArray();
//STRIP001 			nGroup = pDlg->AddGroup(rStarMathArray.GetString(0), pSmMod, pSmMod, SID_SM_EDITOPTIONS );
//STRIP001 			for(USHORT i = 1; i < rStarMathArray.Count(); i++)
//STRIP001 				pDlg->AddTabPage( (sal_uInt16)rStarMathArray.GetValue(i), rStarMathArray.GetString(i), nGroup);
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aModuleOpt.IsChart() )
//STRIP001 		{
//STRIP001 			//Diagramm
//STRIP001 			SfxModule *pSchMod = (*(SfxModule**) GetAppData(BF_SHL_SCH));
//STRIP001 			ResStringArray& rChartArray = aDlgResource.GetChartArray();
//STRIP001 			nGroup = pDlg->AddGroup(rChartArray.GetString(0), pSchMod, pSchMod, SID_SCH_EDITOPTIONS );
//STRIP001 			for(USHORT i = 1; i < rChartArray.Count(); i++)
//STRIP001 				pDlg->AddTabPage( (sal_uInt16)rChartArray.GetValue(i), rChartArray.GetString(i), nGroup);
//STRIP001 		}
//STRIP001 
//STRIP001 		if (sal_True)
//STRIP001 		{	// Data access (always installed)
//STRIP001 			ResStringArray& rDSArray = aDlgResource.GetDatasourcesArray();
//STRIP001 			nGroup = pDlg->AddGroup(rDSArray.GetString(0), this, NULL, SID_SB_STARBASEOPTIONS );
//STRIP001 			for(USHORT i = 1; i < rDSArray.Count(); i++)
//STRIP001 				pDlg->AddTabPage( (sal_uInt16)rDSArray.GetValue(i), rDSArray.GetString(i), nGroup);
//STRIP001 		}
//STRIP001 
//STRIP001         pDlg->ActivateLastSelection();
//STRIP001         if ( nSlot == SID_OPTPAGE_USERDATA )
//STRIP001 			pDlg->ActivatePage(	RID_SFXPAGE_GENERAL );
//STRIP001     }
//STRIP001 
//STRIP001 	short nRet;
//STRIP001 	{
//STRIP001 		// collect all DictionaryList Events while the dialog is executed
//STRIP001         Reference< ::com::sun::star::linguistic2::XDictionaryList> xDictionaryList(SvxGetDictionaryList());
//STRIP001 		SvxDicListChgClamp aClamp( xDictionaryList );
//STRIP001 		nRet = pDlg->Execute();
//STRIP001 	}
//STRIP001 
//STRIP001 	if(RET_OK == nRet)
//STRIP001 	{
//STRIP001 		pDlg->ApplyItemSets();
//STRIP001 
//STRIP001 		if( pDlg->GetColorTable() )
//STRIP001 		{
//STRIP001 			pDlg->GetColorTable()->Save();
//STRIP001 
//STRIP001 			// notify current viewframe it it uses the same color table
//STRIP001 			if ( SfxViewFrame::Current() && SfxViewFrame::Current()->GetDispatcher() )
//STRIP001 			{
//STRIP001 				const OfaPtrItem* pPtr = (const OfaPtrItem*)SfxViewFrame::Current()->GetDispatcher()->Execute( SID_GET_COLORTABLE, SFX_CALLMODE_SYNCHRON );
//STRIP001 				if( pPtr )
//STRIP001 				{
//STRIP001 					XColorTable* pColorTab = (XColorTable*)pPtr->GetValue();
//STRIP001 
//STRIP001 					if( pColorTab && 
//STRIP001 						pColorTab->GetPath() == pDlg->GetColorTable()->GetPath() &&
//STRIP001 						pColorTab->GetName() == pDlg->GetColorTable()->GetName() )
//STRIP001 						SfxObjectShell::Current()->PutItem( SvxColorTableItem( pDlg->GetColorTable() ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 
//STRIP001         utl::ConfigManager::GetConfigManager()->StoreConfigItems();
//STRIP001     }
//STRIP001 	delete pDlg;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL OfficeApplication::EnableSSO( void )
//STRIP001 {
//STRIP001 	// SSO must be enabled if the configuration manager bootstrap settings
//STRIP001 	// are configured as follows ...
//STRIP001 	//  CFG_Offline=false
//STRIP001 	//  CFG_ServerType=uno ( or unspecified )
//STRIP001 	//  CFG_BackendService=
//STRIP001 	//   com.sun.star.comp.configuration.backend.LdapSingleBackend
//STRIP001 
//STRIP001 	OUString theIniFile;
//STRIP001 	osl_getExecutableFile( &theIniFile.pData );
//STRIP001 	theIniFile = theIniFile.copy( 0, theIniFile.lastIndexOf( '/' ) + 1 ) +
//STRIP001 				 OUString::createFromAscii( SAL_CONFIGFILE( "configmgr" ) );
//STRIP001 	::rtl::Bootstrap theBootstrap( theIniFile );
//STRIP001 
//STRIP001 	OUString theOfflineValue;
//STRIP001 	OUString theDefaultOfflineValue = OUString::createFromAscii( "false" );
//STRIP001 	theBootstrap.getFrom( OUString::createFromAscii( "CFG_Offline" ),
//STRIP001 						  theOfflineValue,
//STRIP001 						  theDefaultOfflineValue );
//STRIP001 
//STRIP001 	OUString theServerTypeValue;
//STRIP001 	theBootstrap.getFrom( OUString::createFromAscii( "CFG_ServerType" ),
//STRIP001 						  theServerTypeValue );
//STRIP001 
//STRIP001 	OUString theBackendServiceTypeValue;
//STRIP001 	theBootstrap.getFrom( OUString::createFromAscii( "CFG_BackendService" ),
//STRIP001 						  theBackendServiceTypeValue );
//STRIP001 
//STRIP001 	BOOL bSSOEnabled = 
//STRIP001 		( theOfflineValue == theDefaultOfflineValue						&&
//STRIP001 		  ( theServerTypeValue.getLength() == 0 ||
//STRIP001 		  theServerTypeValue == OUString::createFromAscii( "uno" ) )	&&
//STRIP001 		  theBackendServiceTypeValue ==
//STRIP001 			OUString::createFromAscii(
//STRIP001 				"com.sun.star.comp.configuration.backend.LdapSingleBackend" ) );
//STRIP001 	if ( bSSOEnabled && GetSSOCreator() == 0 )
//STRIP001 	{
//STRIP001 		bSSOEnabled = FALSE;
//STRIP001 	}
//STRIP001 	return bSSOEnabled;
//STRIP001 }
//STRIP001 
//STRIP001 void * OfficeApplication::GetSSOCreator( void )
//STRIP001 {
//STRIP001 	static void * theSymbol = 0;
//STRIP001 	if ( theSymbol == 0 )
//STRIP001 	{
//STRIP001 		OUString	theModuleName	=
//STRIP001 			OUString::createFromAscii( SVLIBRARY( "ssoopt" ) );
//STRIP001 		oslModule	theModule		=
//STRIP001 			osl_loadModule( theModuleName.pData, SAL_LOADMODULE_DEFAULT );
//STRIP001 		if ( theModule != 0 )
//STRIP001 		{
//STRIP001 			OUString theSymbolName =
//STRIP001 				OUString::createFromAscii( "CreateSSOTabPage" );
//STRIP001 			theSymbol = osl_getSymbol( theModule, theSymbolName.pData );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return theSymbol;		
//STRIP001 }
}
