/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: autocdoc.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:26:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _MySVXACORR_HXX
#include <bf_svx/svxacorr.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
namespace binfilter {

// class OffAutoCorrectDoc_Impl ------------------------------------------

class OffAutoCorrectDoc_Impl : public SvxAutoCorrDoc

/*	[Beschreibung]

*/

{
private:
	USHORT					_nStart;
	USHORT					_nEnd;
	String					_aURL;
	SvxAutoCorrect*			_pAutoCorrect;

public:
	OffAutoCorrectDoc_Impl( SvxAutoCorrect* pAutoCorr ) :
		_nStart( 0 ), _nEnd( 0 ), _pAutoCorrect( pAutoCorr ) {}
	virtual ~OffAutoCorrectDoc_Impl();

	BOOL					Check4Links( const String& rLine, SvStream& rStrm );

	virtual BOOL 			SetINetAttr( USHORT nStart,
										 USHORT nEnd, const String& rURL );

							// nur Dummy, da Pure Virtual
	virtual BOOL 			Delete( USHORT nStt, USHORT nEnd );
	virtual BOOL 			Insert( USHORT nPos, const String& rTxt );
	virtual BOOL 			Replace( USHORT nPos, const String& rTxt );
	virtual BOOL 			SetAttr( USHORT nStt, USHORT nEnd,
									 USHORT nSlotId, SfxPoolItem& );
	virtual BOOL			IsWordDelim( USHORT nPos,
										 BOOL bPrevPara = FALSE ) const;
	virtual BOOL			HasSymbolChars( USHORT nStt, USHORT nEnd );
	virtual const String* 	GetPrevPara( BOOL bAtNormalPos );
	virtual BOOL			ChgAutoCorrWord( USHORT& rSttPos, USHORT nEndPos,
											 SvxAutoCorrect& rACorrect,
											 const String** ppPara );
};

} //namespace binfilter
