/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_csvtablebox.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:57:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif
#pragma hdrstop

// ============================================================================

#ifndef _SC_CSVTABLEBOX_HXX
#include "csvtablebox.hxx"
#endif

// auto strip #ifndef _TOOLS_DEBUG_HXX
// auto strip #include <tools/debug.hxx>
// auto strip #endif
// auto strip #ifndef _SV_LSTBOX_HXX
// auto strip #include <vcl/lstbox.hxx>
// auto strip #endif
namespace binfilter {


// ============================================================================

/*M*/ ScCsvTableBox::ScCsvTableBox( Window* pParent ) :
/*M*/     ScCsvControl( pParent, maData, WB_BORDER | WB_TABSTOP | WB_DIALOGCONTROL ),
/*M*/     maRuler( *this ),
/*M*/     maGrid( *this ),
/*M*/     maHScroll( this, WB_HORZ | WB_DRAG ),
/*M*/     maVScroll( this, WB_VERT | WB_DRAG ),
/*M*/     maScrollBox( this )
/*M*/ {
/*M*/     DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Init();
/*M*/ }

/*M*/ ScCsvTableBox::ScCsvTableBox( Window* pParent, const ResId& rResId ) :
/*M*/     ScCsvControl( pParent, maData, rResId ),
/*M*/     maRuler( *this ),
/*M*/     maGrid( *this ),
/*M*/     maHScroll( this, WB_HORZ | WB_DRAG ),
/*M*/     maVScroll( this, WB_VERT | WB_DRAG ),
/*M*/     maScrollBox( this )
/*M*/ {
/*M*/     DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Init();
/*M*/ }


// common table box handling --------------------------------------------------

//STRIP001 void ScCsvTableBox::SetSeparatorsMode()
//STRIP001 {
//STRIP001     if( mbFixedMode )
//STRIP001     {
//STRIP001         // rescue data for fixed width mode
//STRIP001         mnFixedWidth = GetPosCount();
//STRIP001         maFixColStates = maGrid.GetColumnStates();
//STRIP001         // switch to separators mode
//STRIP001         mbFixedMode = false;
//STRIP001         // reset and reinitialize controls
//STRIP001         DisableRepaint();
//STRIP001         Execute( CSVCMD_SETLINEOFFSET, 0 );
//STRIP001         Execute( CSVCMD_SETPOSCOUNT, 1 );
//STRIP001         Execute( CSVCMD_NEWCELLTEXTS );
//STRIP001         maGrid.SetColumnStates( maSepColStates );
//STRIP001         InitControls();
//STRIP001         EnableRepaint();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvTableBox::SetFixedWidthMode()
//STRIP001 {
//STRIP001     if( !mbFixedMode )
//STRIP001     {
//STRIP001         // rescue data for separators mode
//STRIP001         maSepColStates = maGrid.GetColumnStates();
//STRIP001         // switch to fixed width mode
//STRIP001         mbFixedMode = true;
//STRIP001         // reset and reinitialize controls
//STRIP001         DisableRepaint();
//STRIP001         Execute( CSVCMD_SETLINEOFFSET, 0 );
//STRIP001         Execute( CSVCMD_SETPOSCOUNT, mnFixedWidth );
//STRIP001         maGrid.SetSplits( maRuler.GetSplits() );
//STRIP001         maGrid.SetColumnStates( maFixColStates );
//STRIP001         InitControls();
//STRIP001         EnableRepaint();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvTableBox::Init()
//STRIP001 {
//STRIP001     mbFixedMode = false;
//STRIP001     mnFixedWidth = 1;
//STRIP001 
//STRIP001     maHScroll.EnableRTL( false ); // #107812# RTL
//STRIP001     maHScroll.SetLineSize( 1 );
//STRIP001     maVScroll.SetLineSize( 1 );
//STRIP001 
//STRIP001     Link aLink = LINK( this, ScCsvTableBox, CsvCmdHdl );
//STRIP001     SetCmdHdl( aLink );
//STRIP001     maRuler.SetCmdHdl( aLink );
//STRIP001     maGrid.SetCmdHdl( aLink );
//STRIP001 
//STRIP001     aLink = LINK( this, ScCsvTableBox, ScrollHdl );
//STRIP001     maHScroll.SetScrollHdl( aLink );
//STRIP001     maVScroll.SetScrollHdl( aLink );
//STRIP001 
//STRIP001     aLink = LINK( this, ScCsvTableBox, ScrollEndHdl );
//STRIP001     maHScroll.SetEndScrollHdl( aLink );
//STRIP001     maVScroll.SetEndScrollHdl( aLink );
//STRIP001 
//STRIP001     InitControls();
//STRIP001 }

//STRIP001 void ScCsvTableBox::InitControls()
//STRIP001 {
//STRIP001     maGrid.UpdateLayoutData();
//STRIP001 
//STRIP001     sal_Int32 nScrollBarSize = GetSettings().GetStyleSettings().GetScrollBarSize();
//STRIP001     Size aWinSize = CalcOutputSize( GetSizePixel() );
//STRIP001     sal_Int32 nDataWidth = aWinSize.Width() - nScrollBarSize;
//STRIP001     sal_Int32 nDataHeight = aWinSize.Height() - nScrollBarSize;
//STRIP001 
//STRIP001     maData.mnWinWidth = nDataWidth;
//STRIP001     maData.mnWinHeight = nDataHeight;
//STRIP001 
//STRIP001     if( mbFixedMode )
//STRIP001     {
//STRIP001         // ruler sets height internally
//STRIP001         maRuler.SetPosSizePixel( 0, 0, nDataWidth, 0 );
//STRIP001         sal_Int32 nY = maRuler.GetSizePixel().Height();
//STRIP001         maData.mnWinHeight -= nY;
//STRIP001         maGrid.SetPosSizePixel( 0, nY, nDataWidth, maData.mnWinHeight );
//STRIP001     }
//STRIP001     else
//STRIP001         maGrid.SetPosSizePixel( 0, 0, nDataWidth, nDataHeight );
//STRIP001     maGrid.Show();
//STRIP001     maRuler.Show( mbFixedMode );
//STRIP001 
//STRIP001     // scrollbars always visible
//STRIP001     maHScroll.SetPosSizePixel( 0, nDataHeight, nDataWidth, nScrollBarSize );
//STRIP001     InitHScrollBar();
//STRIP001     maHScroll.Show();
//STRIP001 
//STRIP001     // scrollbars always visible
//STRIP001     maVScroll.SetPosSizePixel( nDataWidth, 0, nScrollBarSize, nDataHeight );
//STRIP001     InitVScrollBar();
//STRIP001     maVScroll.Show();
//STRIP001 
//STRIP001     bool bScrBox = maHScroll.IsVisible() && maVScroll.IsVisible();
//STRIP001     if( bScrBox )
//STRIP001         maScrollBox.SetPosSizePixel( nDataWidth, nDataHeight, nScrollBarSize, nScrollBarSize );
//STRIP001     maScrollBox.Show( bScrBox );
//STRIP001 
//STRIP001     // let the controls self-adjust to visible area
//STRIP001     Execute( CSVCMD_SETPOSOFFSET, GetFirstVisPos() );
//STRIP001     Execute( CSVCMD_SETLINEOFFSET, GetFirstVisLine() );
//STRIP001 }

//STRIP001 void ScCsvTableBox::InitHScrollBar()
//STRIP001 {
//STRIP001     maHScroll.SetRange( Range( 0, GetPosCount() + 2 ) );
//STRIP001     maHScroll.SetVisibleSize( GetVisPosCount() );
//STRIP001     maHScroll.SetPageSize( GetVisPosCount() * 3 / 4 );
//STRIP001     maHScroll.SetThumbPos( GetFirstVisPos() );
//STRIP001 }

//STRIP001 void ScCsvTableBox::InitVScrollBar()
//STRIP001 {
//STRIP001     maVScroll.SetRange( Range( 0, GetLineCount() + 1 ) );
//STRIP001     maVScroll.SetVisibleSize( GetVisLineCount() );
//STRIP001     maVScroll.SetPageSize( GetVisLineCount() - 2 );
//STRIP001     maVScroll.SetThumbPos( GetFirstVisLine() );
//STRIP001 }

//STRIP001 void ScCsvTableBox::MakePosVisible( sal_Int32 nPos )
//STRIP001 {
//STRIP001     if( (0 <= nPos) && (nPos < GetPosCount()) )
//STRIP001     {
//STRIP001         if( nPos - CSV_SCROLL_DIST + 1 <= GetFirstVisPos() )
//STRIP001             Execute( CSVCMD_SETPOSOFFSET, nPos - CSV_SCROLL_DIST );
//STRIP001         else if( nPos + CSV_SCROLL_DIST >= GetLastVisPos() )
//STRIP001             Execute( CSVCMD_SETPOSOFFSET, nPos - GetVisPosCount() + CSV_SCROLL_DIST );
//STRIP001     }
//STRIP001 }


// cell contents --------------------------------------------------------------

//STRIP001 void ScCsvTableBox::SetUniStrings(
//STRIP001         const String* pTextLines, const String& rSepChars,
//STRIP001         sal_Unicode cTextSep, bool bMergeSep )
//STRIP001 {
//STRIP001     // assuming that pTextLines is a string array with size CSV_PREVIEW_LINES
//STRIP001     // -> will be dynamic sometime
//STRIP001     DisableRepaint();
//STRIP001     sal_Int32 nEndLine = GetFirstVisLine() + CSV_PREVIEW_LINES;
//STRIP001     const String* pString = pTextLines;
//STRIP001     for( sal_Int32 nLine = GetFirstVisLine(); nLine < nEndLine; ++nLine, ++pString )
//STRIP001     {
//STRIP001         if( mbFixedMode )
//STRIP001             maGrid.ImplSetTextLineFix( nLine, *pString );
//STRIP001         else
//STRIP001             maGrid.ImplSetTextLineSep( nLine, *pString, rSepChars, cTextSep, bMergeSep );
//STRIP001     }
//STRIP001     EnableRepaint();
//STRIP001 }

//STRIP001 void ScCsvTableBox::SetByteStrings(
//STRIP001         const ByteString* pTextLines, CharSet eCharSet,
//STRIP001         const String& rSepChars, sal_Unicode cTextSep, bool bMergeSep )
//STRIP001 {
//STRIP001     // assuming that pTextLines is a string array with size CSV_PREVIEW_LINES
//STRIP001     // -> will be dynamic sometime
//STRIP001     DisableRepaint();
//STRIP001     sal_Int32 nEndLine = GetFirstVisLine() + CSV_PREVIEW_LINES;
//STRIP001     const ByteString* pString = pTextLines;
//STRIP001     for( sal_Int32 nLine = GetFirstVisLine(); nLine < nEndLine; ++nLine, ++pString )
//STRIP001     {
//STRIP001         if( mbFixedMode )
//STRIP001             maGrid.ImplSetTextLineFix( nLine, String( *pString, eCharSet ) );
//STRIP001         else
//STRIP001             maGrid.ImplSetTextLineSep( nLine, String( *pString, eCharSet ), rSepChars, cTextSep, bMergeSep );
//STRIP001     }
//STRIP001     EnableRepaint();
//STRIP001 }


// column settings ------------------------------------------------------------

/*M*/ void ScCsvTableBox::InitTypes( const ListBox& rListBox )
/*M*/ {
/*M*/     DBG_BF_ASSERT(0, "STRIP"); //STRIP001 sal_uInt16 nTypeCount = rListBox.GetEntryCount();
//STRIP001     StringVec aTypeNames( nTypeCount );
//STRIP001     for( sal_uInt16 nIndex = 0; nIndex < nTypeCount; ++nIndex )
//STRIP001         aTypeNames[ nIndex ] = rListBox.GetEntry( nIndex );
//STRIP001     maGrid.SetTypeNames( aTypeNames );
/*M*/ }

/*M*/ void ScCsvTableBox::FillColumnData( ScAsciiOptions& rOptions ) const
/*M*/ {
/*M*/     DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( mbFixedMode )
//STRIP001         maGrid.FillColumnDataFix( rOptions );
//STRIP001     else
//STRIP001         maGrid.FillColumnDataSep( rOptions );
/*M*/ }


// event handling -------------------------------------------------------------

//STRIP001 void ScCsvTableBox::Resize()
//STRIP001 {
//STRIP001     ScCsvControl::Resize();
//STRIP001     InitControls();
//STRIP001 }

//STRIP001 void ScCsvTableBox::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     if( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001         InitControls();
//STRIP001     ScCsvControl::DataChanged( rDCEvt );
//STRIP001 }

//STRIP001 IMPL_LINK( ScCsvTableBox, CsvCmdHdl, ScCsvControl*, pCtrl )
//STRIP001 {
//STRIP001     DBG_ASSERT( pCtrl, "ScCsvTableBox::CsvCmdHdl - missing sender" );
//STRIP001 
//STRIP001     const ScCsvCmd& rCmd = pCtrl->GetCmd();
//STRIP001     ScCsvCmdType eType = rCmd.GetType();
//STRIP001     sal_Int32 nParam1 = rCmd.GetParam1();
//STRIP001     sal_Int32 nParam2 = rCmd.GetParam2();
//STRIP001 
//STRIP001     bool bFound = true;
//STRIP001     switch( eType )
//STRIP001     {
//STRIP001         case CSVCMD_REPAINT:
//STRIP001             if( !IsNoRepaint() )
//STRIP001             {
//STRIP001                 maGrid.ImplRedraw();
//STRIP001                 maRuler.ImplRedraw();
//STRIP001                 InitHScrollBar();
//STRIP001                 InitVScrollBar();
//STRIP001             }
//STRIP001         break;
//STRIP001         case CSVCMD_MAKEPOSVISIBLE:
//STRIP001             MakePosVisible( nParam1 );
//STRIP001         break;
//STRIP001 
//STRIP001         case CSVCMD_NEWCELLTEXTS:
//STRIP001             if( mbFixedMode )
//STRIP001                 Execute( CSVCMD_UPDATECELLTEXTS );
//STRIP001             else
//STRIP001             {
//STRIP001                 DisableRepaint();
//STRIP001                 ScCsvColStateVec aStates( maGrid.GetColumnStates() );
//STRIP001                 sal_Int32 nPos = GetFirstVisPos();
//STRIP001                 Execute( CSVCMD_SETPOSCOUNT, 1 );
//STRIP001                 Execute( CSVCMD_UPDATECELLTEXTS );
//STRIP001                 Execute( CSVCMD_SETPOSOFFSET, nPos );
//STRIP001                 maGrid.SetColumnStates( aStates );
//STRIP001                 EnableRepaint();
//STRIP001             }
//STRIP001         break;
//STRIP001         case CSVCMD_UPDATECELLTEXTS:
//STRIP001             maUpdateTextHdl.Call( this );
//STRIP001         break;
//STRIP001         case CSVCMD_SETCOLUMNTYPE:
//STRIP001             maGrid.SetSelColumnType( nParam1 );
//STRIP001         break;
//STRIP001         case CSVCMD_EXPORTCOLUMNTYPE:
//STRIP001             maColTypeHdl.Call( this );
//STRIP001         break;
//STRIP001         case CSVCMD_SETFIRSTIMPORTLINE:
//STRIP001             maGrid.SetFirstImportedLine( nParam1 );
//STRIP001         break;
//STRIP001 
//STRIP001         case CSVCMD_INSERTSPLIT:
//STRIP001             DBG_ASSERT( mbFixedMode, "ScCsvTableBox::CsvCmdHdl::InsertSplit - invalid call" );
//STRIP001             if( maRuler.GetSplitCount() + 1 < CSV_MAXCOLCOUNT )
//STRIP001             {
//STRIP001                 maRuler.InsertSplit( nParam1 );
//STRIP001                 maGrid.InsertSplit( nParam1 );
//STRIP001             }
//STRIP001         break;
//STRIP001         case CSVCMD_REMOVESPLIT:
//STRIP001             DBG_ASSERT( mbFixedMode, "ScCsvTableBox::CsvCmdHdl::RemoveSplit - invalid call" );
//STRIP001             maRuler.RemoveSplit( nParam1 );
//STRIP001             maGrid.RemoveSplit( nParam1 );
//STRIP001         break;
//STRIP001         case CSVCMD_TOGGLESPLIT:
//STRIP001             Execute( maRuler.HasSplit( nParam1 ) ? CSVCMD_REMOVESPLIT : CSVCMD_INSERTSPLIT, nParam1 );
//STRIP001         break;
//STRIP001         case CSVCMD_MOVESPLIT:
//STRIP001             DBG_ASSERT( mbFixedMode, "ScCsvTableBox::CsvCmdHdl::MoveSplit - invalid call" );
//STRIP001             maRuler.MoveSplit( nParam1, nParam2 );
//STRIP001             maGrid.MoveSplit( nParam1, nParam2 );
//STRIP001         break;
//STRIP001         case CSVCMD_REMOVEALLSPLITS:
//STRIP001             DBG_ASSERT( mbFixedMode, "ScCsvTableBox::CsvCmdHdl::RemoveAllSplits - invalid call" );
//STRIP001             maRuler.RemoveAllSplits();
//STRIP001             maGrid.RemoveAllSplits();
//STRIP001         break;
//STRIP001         default:
//STRIP001             bFound = false;
//STRIP001     }
//STRIP001     if( bFound )
//STRIP001         return 0;
//STRIP001 
//STRIP001     const ScCsvLayoutData aOldData( maData );
//STRIP001     switch( eType )
//STRIP001     {
//STRIP001         case CSVCMD_SETPOSCOUNT:
//STRIP001             maData.mnPosCount = Max( nParam1, 1L );
//STRIP001             ImplSetPosOffset( GetFirstVisPos() );
//STRIP001         break;
//STRIP001         case CSVCMD_SETPOSOFFSET:
//STRIP001             ImplSetPosOffset( nParam1 );
//STRIP001         break;
//STRIP001         case CSVCMD_SETHDRWIDTH:
//STRIP001             maData.mnHdrWidth = Max( nParam1, 0L );
//STRIP001             ImplSetPosOffset( GetFirstVisPos() );
//STRIP001         break;
//STRIP001         case CSVCMD_SETCHARWIDTH:
//STRIP001             maData.mnCharWidth = Max( nParam1, 1L );
//STRIP001             ImplSetPosOffset( GetFirstVisPos() );
//STRIP001         break;
//STRIP001         case CSVCMD_SETLINECOUNT:
//STRIP001             maData.mnLineCount = Max( nParam1, 1L );
//STRIP001             ImplSetLineOffset( GetFirstVisLine() );
//STRIP001         break;
//STRIP001         case CSVCMD_SETLINEOFFSET:
//STRIP001             ImplSetLineOffset( nParam1 );
//STRIP001         break;
//STRIP001         case CSVCMD_SETHDRHEIGHT:
//STRIP001             maData.mnHdrHeight = Max( nParam1, 0L );
//STRIP001             ImplSetLineOffset( GetFirstVisLine() );
//STRIP001         break;
//STRIP001         case CSVCMD_SETLINEHEIGHT:
//STRIP001             maData.mnLineHeight = Max( nParam1, 1L );
//STRIP001             ImplSetLineOffset( GetFirstVisLine() );
//STRIP001         break;
//STRIP001         case CSVCMD_MOVERULERCURSOR:
//STRIP001             maData.mnPosCursor = IsVisibleSplitPos( nParam1 ) ? nParam1 : CSV_POS_INVALID;
//STRIP001         break;
//STRIP001         case CSVCMD_MOVEGRIDCURSOR:
//STRIP001             maData.mnColCursor = ((0 <= nParam1) && (nParam1 < GetPosCount())) ? nParam1 : CSV_POS_INVALID;
//STRIP001         break;
//STRIP001     }
//STRIP001 
//STRIP001     if( maData != aOldData )
//STRIP001     {
//STRIP001         DisableRepaint();
//STRIP001         maRuler.ApplyLayout( aOldData );
//STRIP001         maGrid.ApplyLayout( aOldData );
//STRIP001         EnableRepaint();
//STRIP001     }
//STRIP001 
//STRIP001     return 0;
//STRIP001 }

//STRIP001 IMPL_LINK( ScCsvTableBox, ScrollHdl, ScrollBar*, pScrollBar )
//STRIP001 {
//STRIP001     DBG_ASSERT( pScrollBar, "ScCsvTableBox::ScrollHdl - missing sender" );
//STRIP001 
//STRIP001     if( pScrollBar == &maHScroll )
//STRIP001         Execute( CSVCMD_SETPOSOFFSET, pScrollBar->GetThumbPos() );
//STRIP001     else if( pScrollBar == &maVScroll )
//STRIP001         Execute( CSVCMD_SETLINEOFFSET, pScrollBar->GetThumbPos() );
//STRIP001 
//STRIP001     return 0;
//STRIP001 }

//STRIP001 IMPL_LINK( ScCsvTableBox, ScrollEndHdl, ScrollBar*, pScrollBar )
//STRIP001 {
//STRIP001     DBG_ASSERT( pScrollBar, "ScCsvTableBox::ScrollEndHdl - missing sender" );
//STRIP001 
//STRIP001     if( pScrollBar == &maHScroll )
//STRIP001     {
//STRIP001         if( GetRulerCursorPos() != CSV_POS_INVALID )
//STRIP001             Execute( CSVCMD_MOVERULERCURSOR, maRuler.GetNoScrollPos( GetRulerCursorPos() ) );
//STRIP001         if( GetGridCursorPos() != CSV_POS_INVALID )
//STRIP001             Execute( CSVCMD_MOVEGRIDCURSOR, maGrid.GetNoScrollCol( GetGridCursorPos() ) );
//STRIP001     }
//STRIP001 
//STRIP001     return 0;
//STRIP001 }


// accessibility --------------------------------------------------------------

//STRIP001 ScCsvTableBox::XAccessibleRef ScCsvTableBox::CreateAccessible()
//STRIP001 {
//STRIP001     // do not use the ScCsvControl mechanism, return default accessible object
//STRIP001     return Control::CreateAccessible();
//STRIP001 }

//STRIP001 ScAccessibleCsvControl* ScCsvTableBox::ImplCreateAccessible()
//STRIP001 {
//STRIP001     return NULL;    // not used, see CreateAccessible()
//STRIP001 }


// ============================================================================

}
