/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_drtxtob.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:15:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

//-------------------------------------------------------------------------

#include "scitems.hxx"
#include "eetext.hxx"
#define ITEMID_FIELD EE_FEATURE_FIELD

#include <bf_svx/adjitem.hxx>
// auto strip #include <bf_svx/clipfmtitem.hxx>
// auto strip #include <bf_svx/cntritem.hxx>
// auto strip #include <bf_svx/crsditem.hxx>
// auto strip #include <bf_svx/editeng.hxx>
// auto strip #include <bf_svx/escpitem.hxx>

// auto strip #ifndef _PSTM_HXX
// auto strip #include <tools/pstm.hxx>
// auto strip #endif

// auto strip #ifndef _SFXPOOLITEM_HXX
// auto strip #include <svtools/poolitem.hxx>
// auto strip #endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif

// auto strip #include <bf_svx/flditem.hxx>
// auto strip #include <bf_svx/fontitem.hxx>
// auto strip #include <bf_svx/frmdiritem.hxx>
// auto strip #include <bf_svx/hlnkitem.hxx>
// auto strip #include <bf_svx/lspcitem.hxx>
// auto strip #include <bf_svx/svdoutl.hxx>
// auto strip #include <bf_svx/outlobj.hxx>
// auto strip #include <bf_svx/postitem.hxx>
// auto strip #include <bf_svx/scripttypeitem.hxx>
// auto strip #include <bf_svx/shdditem.hxx>
// auto strip #include <bf_svx/srchitem.hxx>

#ifndef _XDEF_HXX
#include <bf_svx/xdef.hxx>
#endif

// auto strip #include <bf_svx/textanim.hxx>
// auto strip #include <bf_svx/udlnitem.hxx>
// auto strip #include <bf_svx/wghtitem.hxx>
// auto strip #ifndef _SVX_WRITINGMODEITEM_HXX
// auto strip #include <bf_svx/writingmodeitem.hxx>
// auto strip #endif
// auto strip #include <bf_sfx2/app.hxx>
#include <bf_sfx2/dispatch.hxx>
#include <bf_sfx2/objface.hxx>
// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #include <svtools/cjkoptions.hxx>
// auto strip #include <svtools/cliplistener.hxx>
// auto strip #include <svtools/transfer.hxx>
// auto strip #include <svtools/whiter.hxx>
// auto strip #ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
// auto strip #include <svtools/languageoptions.hxx>
// auto strip #endif
// auto strip #include <vcl/msgbox.hxx>

#include "bf_sc.hrc"
#include "globstr.hrc"
#include "drtxtob.hxx"
// auto strip #include "viewdata.hxx"
// auto strip #include "document.hxx"
// auto strip #include "drawview.hxx"
// auto strip #include "viewutil.hxx"
#include "scresid.hxx"
// auto strip #include "tabvwsh.hxx"

//STRIP008 #define ScDrawTextObjectBar
//STRIP008 #include "scslots.hxx"
namespace binfilter {
#define ScDrawTextObjectBar
#include "scslots.hxx"
/*N*/ SFX_IMPL_INTERFACE( ScDrawTextObjectBar, SfxShell, ScResId(SCSTR_DRAWTEXTSHELL) )
/*N*/ {
/*N*/ 	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT|SFX_VISIBILITY_STANDARD|SFX_VISIBILITY_SERVER,
/*N*/ 								ScResId(RID_TEXT_TOOLBOX) );
/*N*/ 	SFX_POPUPMENU_REGISTRATION( ScResId(RID_POPUP_DRAWTEXT) );
/*N*/ 	SFX_OBJECTMENU_REGISTRATION( SID_OBJECTMENU0, ScResId(RID_OBJECTMENU_DRAWTEXT) );
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION( ScGetFontWorkId() );
/*N*/ }

//STRIP001 TYPEINIT1( ScDrawTextObjectBar, SfxShell );



// abschalten der nicht erwuenschten Acceleratoren:

//STRIP001 void ScDrawTextObjectBar::StateDisableItems( SfxItemSet &rSet )
//STRIP001 {
//STRIP001 	SfxWhichIter aIter(rSet);
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001 
//STRIP001 	while (nWhich)
//STRIP001 	{
//STRIP001 		rSet.DisableItem( nWhich );
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }

//STRIP001 ScDrawTextObjectBar::ScDrawTextObjectBar(ScViewData* pData) :
//STRIP001 	SfxShell(pData->GetViewShell()),
//STRIP001 	pViewData(pData),
//STRIP001 	pClipEvtLstnr(NULL),
//STRIP001 	bPastePossible(FALSE)
//STRIP001 {
//STRIP001 	SetPool( pViewData->GetScDrawView()->GetDefaultAttr().GetPool() );
//STRIP001 
//STRIP001 	//	UndoManager wird beim Umschalten in den Edit-Modus umgesetzt...
//STRIP001 	SetUndoManager( pViewData->GetSfxDocShell()->GetUndoManager() );
//STRIP001 
//STRIP001 	SetHelpId( HID_SCSHELL_DRTXTOB );
//STRIP001 	SetName(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("DrawText")));
//STRIP001 }

//STRIP001 __EXPORT ScDrawTextObjectBar::~ScDrawTextObjectBar()
//STRIP001 {
//STRIP001 	if ( pClipEvtLstnr )
//STRIP001 	{
//STRIP001 		pClipEvtLstnr->AddRemoveListener( pViewData->GetActiveWin(), FALSE );
//STRIP001 		pClipEvtLstnr->release();
//STRIP001 	}
//STRIP001 }

//========================================================================
//
//			Funktionen
//
//========================================================================

//STRIP001 void __EXPORT ScDrawTextObjectBar::Execute( SfxRequest &rReq )
//STRIP001 {
//STRIP001 	ScDrawView* pView = pViewData->GetScDrawView();
//STRIP001 	OutlinerView* pOutView = pView->GetTextEditOutlinerView();
//STRIP001 	Outliner* pOutliner = pView->GetTextEditOutliner();
//STRIP001 
//STRIP001 	if (!pOutView || !pOutliner)
//STRIP001 	{
//STRIP001 		ExecuteGlobal( rReq );				// auf ganze Objekte
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 	USHORT nSlot = rReq.GetSlot();
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001 		case SID_COPY:
//STRIP001 			pOutView->Copy();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_CUT:
//STRIP001 			pOutView->Cut();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_PASTE:
//STRIP001 			pOutView->PasteSpecial();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_CLIPBOARD_FORMAT_ITEMS:
//STRIP001 			{
//STRIP001 				ULONG nFormat = 0;
//STRIP001 				const SfxPoolItem* pItem;
//STRIP001 				if ( pReqArgs &&
//STRIP001 					 pReqArgs->GetItemState(nSlot, TRUE, &pItem) == SFX_ITEM_SET &&
//STRIP001 					 pItem->ISA(SfxUInt32Item) )
//STRIP001 				{
//STRIP001 					nFormat = ((const SfxUInt32Item*)pItem)->GetValue();
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( nFormat )
//STRIP001 				{
//STRIP001 					if (nFormat == SOT_FORMAT_STRING)
//STRIP001 						pOutView->Paste();
//STRIP001 					else
//STRIP001 						pOutView->PasteSpecial();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FID_PASTE_CONTENTS:
//STRIP001 			ExecutePasteContents( rReq );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_SELECTALL:
//STRIP001 			{
//STRIP001 				ULONG nCount = pOutliner->GetParagraphCount();
//STRIP001 				ESelection aSel( 0,0,(USHORT)nCount,0 );
//STRIP001 				pOutView->SetSelection( aSel );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_CHARMAP:
//STRIP001 			{
//STRIP001 				const SvxFontItem& rItem = (const SvxFontItem&)
//STRIP001 							pOutView->GetAttribs().Get(EE_CHAR_FONTINFO);
//STRIP001 
//STRIP001 				String aString;
//STRIP001 				SvxFontItem aNewItem( EE_CHAR_FONTINFO );
//STRIP001 
//STRIP001 				if (ScViewUtil::ExecuteCharMap( rItem, aNewItem, aString ))
//STRIP001 				{
//STRIP001 					SfxItemSet aSet( pOutliner->GetEmptyItemSet() );
//STRIP001 					aSet.Put( aNewItem );
//STRIP001 					//	SetAttribs an der View selektiert ein Wort, wenn nichts selektiert ist
//STRIP001 					pOutView->GetOutliner()->QuickSetAttribs( aSet, pOutView->GetSelection() );
//STRIP001 					pOutView->InsertText(aString);
//STRIP001 				}
//STRIP001 
//STRIP001 				Invalidate( SID_ATTR_CHAR_FONT );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_HYPERLINK_SETLINK:
//STRIP001 			if( pReqArgs )
//STRIP001 			{
//STRIP001 				const SfxPoolItem* pItem;
//STRIP001 				if ( pReqArgs->GetItemState( SID_HYPERLINK_SETLINK, TRUE, &pItem ) == SFX_ITEM_SET )
//STRIP001 				{
//STRIP001 					const SvxHyperlinkItem* pHyper = (const SvxHyperlinkItem*) pItem;
//STRIP001 					const String& rName		= pHyper->GetName();
//STRIP001 					const String& rURL		= pHyper->GetURL();
//STRIP001 					const String& rTarget	= pHyper->GetTargetFrame();
//STRIP001 					SvxLinkInsertMode eMode = pHyper->GetInsertMode();
//STRIP001 
//STRIP001 					BOOL bDone = FALSE;
//STRIP001 					if ( pOutView && ( eMode == HLINK_DEFAULT || eMode == HLINK_FIELD ) )
//STRIP001 					{
//STRIP001 						const SvxFieldItem*	pFieldItem = pOutView->GetFieldAtSelection();
//STRIP001 						if (pFieldItem)
//STRIP001 						{
//STRIP001 							const SvxFieldData* pField = pFieldItem->GetField();
//STRIP001 							if ( pField && pField->ISA(SvxURLField) )
//STRIP001 							{
//STRIP001 								//	altes Feld selektieren
//STRIP001 
//STRIP001 								ESelection aSel = pOutView->GetSelection();
//STRIP001 								aSel.Adjust();
//STRIP001 								aSel.nEndPara = aSel.nStartPara;
//STRIP001 								aSel.nEndPos = aSel.nStartPos + 1;
//STRIP001 								pOutView->SetSelection( aSel );
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						//	neues Feld einfuegen
//STRIP001 
//STRIP001 						SvxURLField aURLField( rURL, rName, SVXURLFORMAT_REPR );
//STRIP001 						aURLField.SetTargetFrame( rTarget );
//STRIP001 						SvxFieldItem aURLItem( aURLField );
//STRIP001 						pOutView->InsertField( aURLItem );
//STRIP001 
//STRIP001 						//	select new field
//STRIP001 
//STRIP001 						ESelection aSel = pOutView->GetSelection();
//STRIP001 						if ( aSel.nStartPos == aSel.nEndPos && aSel.nStartPos > 0 )
//STRIP001 						{
//STRIP001 							//	Cursor is behind the inserted field -> extend selection to the left
//STRIP001 
//STRIP001 							--aSel.nStartPos;
//STRIP001 							pOutView->SetSelection( aSel );
//STRIP001 						}
//STRIP001 
//STRIP001 						bDone = TRUE;
//STRIP001 					}
//STRIP001 
//STRIP001 					if (!bDone)
//STRIP001 						ExecuteGlobal( rReq );		// normal an der View
//STRIP001 
//STRIP001 					//	InsertURL an der ViewShell schaltet bei "Text" die DrawShell ab !!!
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001         case SID_OPEN_HYPERLINK:
//STRIP001             {
//STRIP001                 SdrView* pView = pViewData->GetScDrawView();
//STRIP001                 OutlinerView* pOutView = pView->GetTextEditOutlinerView();
//STRIP001                 if ( pOutView )
//STRIP001                 {
//STRIP001                     const SvxFieldItem* pFieldItem = pOutView->GetFieldAtSelection();
//STRIP001                     if ( pFieldItem )
//STRIP001                     {
//STRIP001                         const SvxFieldData* pField = pFieldItem->GetField();
//STRIP001                         if( pField && pField->ISA( SvxURLField ) )
//STRIP001                         {
//STRIP001                             const SvxURLField* pURLField = static_cast< const SvxURLField* >( pField );
//STRIP001                             ScGlobal::OpenURL( pURLField->GetURL(), pURLField->GetTargetFrame() );
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001 		case SID_ENABLE_HYPHENATION:
//STRIP001 		case SID_TEXTDIRECTION_LEFT_TO_RIGHT:
//STRIP001 		case SID_TEXTDIRECTION_TOP_TO_BOTTOM:
//STRIP001 			pView->ScEndTextEdit();					// end text edit before switching direction
//STRIP001 			ExecuteGlobal( rReq );
//STRIP001 			// restore consistent state between shells and functions:
//STRIP001 			pViewData->GetDispatcher().Execute(SID_OBJECT_SELECT, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD);
//STRIP001 			break;
//STRIP001 
//STRIP001 #if 0
//STRIP001 		// Hyphenation is handled above - text edit is ended
//STRIP001 		case SID_ENABLE_HYPHENATION:
//STRIP001 			// force loading of hyphenator (object is skipped in repaint)
//STRIP001 			((ScDrawLayer*)pView->GetModel())->UseHyphenator();
//STRIP001 			pOutliner->SetHyphenator( LinguMgr::GetHyphenator() );
//STRIP001 			ExecuteGlobal( rReq );
//STRIP001 			break;
//STRIP001 #endif
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScDrawTextObjectBar::GetState( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxViewFrame* pViewFrm = pViewData->GetViewShell()->GetViewFrame();
//STRIP001 	BOOL bHasFontWork = pViewFrm->HasChildWindow(SID_FONTWORK);
//STRIP001 	BOOL bDisableFontWork = FALSE;
//STRIP001 
//STRIP001 	if (IsNoteEdit())
//STRIP001 	{
//STRIP001 		//	Funktionen, die bei Notizen disabled sind:
//STRIP001 
//STRIP001 		rSet.DisableItem( SID_TEXT_STANDARD );
//STRIP001 		rSet.DisableItem( SID_DRAWTEXT_ATTR_DLG );
//STRIP001 
//STRIP001 		if(!bHasFontWork)
//STRIP001 			bDisableFontWork = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bDisableFontWork )
//STRIP001 		rSet.DisableItem( SID_FONTWORK	);
//STRIP001 	else
//STRIP001 		rSet.Put(SfxBoolItem(SID_FONTWORK, bHasFontWork));
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( SID_HYPERLINK_GETLINK ) != SFX_ITEM_UNKNOWN )
//STRIP001 	{
//STRIP001 		SvxHyperlinkItem aHLinkItem;
//STRIP001 		SdrView* pView = pViewData->GetScDrawView();
//STRIP001 		OutlinerView* pOutView = pView->GetTextEditOutlinerView();
//STRIP001 		if ( pOutView )
//STRIP001 		{
//STRIP001 			BOOL bField = FALSE;
//STRIP001 			const SvxFieldItem*	pFieldItem = pOutView->GetFieldAtSelection();
//STRIP001 			if (pFieldItem)
//STRIP001 			{
//STRIP001 				const SvxFieldData* pField = pFieldItem->GetField();
//STRIP001 				if ( pField && pField->ISA(SvxURLField) )
//STRIP001 				{
//STRIP001 					const SvxURLField* pURLField = (const SvxURLField*) pField;
//STRIP001 					aHLinkItem.SetName( pURLField->GetRepresentation() );
//STRIP001 					aHLinkItem.SetURL( pURLField->GetURL() );
//STRIP001 					aHLinkItem.SetTargetFrame( pURLField->GetTargetFrame() );
//STRIP001 					bField = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if (!bField)
//STRIP001 			{
//STRIP001 				// use selected text as name for urls
//STRIP001 				String sReturn = pOutView->GetSelected();
//STRIP001 				sReturn.Erase(255);
//STRIP001 				sReturn.EraseTrailingChars();
//STRIP001 				aHLinkItem.SetName(sReturn);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		rSet.Put(aHLinkItem);
//STRIP001 	}
//STRIP001 //STRIP001 
//STRIP001     if ( rSet.GetItemState( SID_OPEN_HYPERLINK ) != SFX_ITEM_UNKNOWN )
//STRIP001     {
//STRIP001         SdrView* pView = pViewData->GetScDrawView();
//STRIP001         OutlinerView* pOutView = pView->GetTextEditOutlinerView();
//STRIP001         bool bEnable = false;
//STRIP001         if ( pOutView )
//STRIP001         {
//STRIP001             const SvxFieldItem* pFieldItem = pOutView->GetFieldAtSelection();
//STRIP001             if ( pFieldItem )
//STRIP001             {
//STRIP001                 const SvxFieldData* pField = pFieldItem->GetField();
//STRIP001                 bEnable = pField && pField->ISA( SvxURLField );
//STRIP001             }
//STRIP001         }
//STRIP001         if( !bEnable )
//STRIP001             rSet.DisableItem( SID_OPEN_HYPERLINK );
//STRIP001     }
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( SID_TRANSLITERATE_HALFWIDTH ) != SFX_ITEM_UNKNOWN ||
//STRIP001 		 rSet.GetItemState( SID_TRANSLITERATE_FULLWIDTH ) != SFX_ITEM_UNKNOWN ||
//STRIP001 		 rSet.GetItemState( SID_TRANSLITERATE_HIRAGANA ) != SFX_ITEM_UNKNOWN ||
//STRIP001 		 rSet.GetItemState( SID_TRANSLITERATE_KATAGANA ) != SFX_ITEM_UNKNOWN )
//STRIP001 	{
//STRIP001 		SvtCJKOptions aCJKOptions;
//STRIP001 		if (!aCJKOptions.IsChangeCaseMapEnabled())
//STRIP001 		{
//STRIP001 			rSet.DisableItem( SID_TRANSLITERATE_HALFWIDTH );
//STRIP001 			rSet.DisableItem( SID_TRANSLITERATE_FULLWIDTH );
//STRIP001 			rSet.DisableItem( SID_TRANSLITERATE_HIRAGANA );
//STRIP001 			rSet.DisableItem( SID_TRANSLITERATE_KATAGANA );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( SID_ENABLE_HYPHENATION ) != SFX_ITEM_UNKNOWN )
//STRIP001 	{
//STRIP001 		SdrView* pView = pViewData->GetScDrawView();
//STRIP001 		SfxItemSet aAttrs( pView->GetModel()->GetItemPool() );
//STRIP001 		pView->GetAttributes( aAttrs );
//STRIP001 		if( aAttrs.GetItemState( EE_PARA_HYPHENATE ) >= SFX_ITEM_AVAILABLE )
//STRIP001 		{
//STRIP001 			BOOL bValue = ( (const SfxBoolItem&) aAttrs.Get( EE_PARA_HYPHENATE ) ).GetValue();
//STRIP001 			rSet.Put( SfxBoolItem( SID_ENABLE_HYPHENATION, bValue ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 IMPL_LINK( ScDrawTextObjectBar, ClipboardChanged, TransferableDataHelper*, pDataHelper )
//STRIP001 {
//STRIP001 	if ( pDataHelper )
//STRIP001 	{
//STRIP001 		bPastePossible = ( pDataHelper->HasFormat( SOT_FORMAT_STRING ) || pDataHelper->HasFormat( SOT_FORMAT_RTF ) );
//STRIP001 
//STRIP001 		SfxBindings& rBindings = pViewData->GetBindings();
//STRIP001 		rBindings.Invalidate( SID_PASTE );
//STRIP001 		rBindings.Invalidate( FID_PASTE_CONTENTS );
//STRIP001 		rBindings.Invalidate( SID_CLIPBOARD_FORMAT_ITEMS );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 void __EXPORT ScDrawTextObjectBar::GetClipState( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SdrView* pView = pViewData->GetScDrawView();
//STRIP001 	if ( !pView->GetTextEditOutlinerView() )
//STRIP001 	{
//STRIP001 		GetGlobalClipState( rSet );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !pClipEvtLstnr )
//STRIP001 	{
//STRIP001 		// create listener
//STRIP001 		pClipEvtLstnr = new TransferableClipboardListener( LINK( this, ScDrawTextObjectBar, ClipboardChanged ) );
//STRIP001 		pClipEvtLstnr->acquire();
//STRIP001 		Window* pWin = pViewData->GetActiveWin();
//STRIP001 		pClipEvtLstnr->AddRemoveListener( pWin, TRUE );
//STRIP001 
//STRIP001 		// get initial state
//STRIP001 		TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( pViewData->GetActiveWin() ) );
//STRIP001 		bPastePossible = ( aDataHelper.HasFormat( SOT_FORMAT_STRING ) || aDataHelper.HasFormat( SOT_FORMAT_RTF ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxWhichIter aIter( rSet );
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001 	while (nWhich)
//STRIP001 	{
//STRIP001 		switch (nWhich)
//STRIP001 		{
//STRIP001 			case SID_PASTE:
//STRIP001 			case FID_PASTE_CONTENTS:
//STRIP001 				if( !bPastePossible )
//STRIP001 					rSet.DisableItem( nWhich );
//STRIP001 				break;
//STRIP001 			case SID_CLIPBOARD_FORMAT_ITEMS:
//STRIP001 				if ( bPastePossible )
//STRIP001 				{
//STRIP001 					SvxClipboardFmtItem aFormats( SID_CLIPBOARD_FORMAT_ITEMS );
//STRIP001 					TransferableDataHelper aDataHelper(
//STRIP001 							TransferableDataHelper::CreateFromSystemClipboard( pViewData->GetActiveWin() ) );
//STRIP001 
//STRIP001 					if ( aDataHelper.HasFormat( SOT_FORMAT_STRING ) )
//STRIP001 						aFormats.AddClipbrdFormat( SOT_FORMAT_STRING );
//STRIP001 					if ( aDataHelper.HasFormat( SOT_FORMAT_RTF ) )
//STRIP001 						aFormats.AddClipbrdFormat( SOT_FORMAT_RTF );
//STRIP001 
//STRIP001 					rSet.Put( aFormats );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					rSet.DisableItem( nWhich );
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }

//========================================================================
//
//			Attribute
//
//========================================================================

//STRIP001 void __EXPORT ScDrawTextObjectBar::ExecuteToggle( SfxRequest &rReq )
//STRIP001 {
//STRIP001 	//	Unterstreichung
//STRIP001 
//STRIP001 	SdrView* pView = pViewData->GetScDrawView();
//STRIP001 
//STRIP001 	const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 	USHORT nSlot = rReq.GetSlot();
//STRIP001 
//STRIP001 	SfxItemSet aSet( pView->GetDefaultAttr() );
//STRIP001 
//STRIP001 	SfxItemSet aViewAttr(pView->GetModel()->GetItemPool());
//STRIP001 	pView->GetAttributes(aViewAttr);
//STRIP001 
//STRIP001 	//	Unterstreichung
//STRIP001 	FontUnderline eOld = ((const SvxUnderlineItem&) aViewAttr.
//STRIP001 										Get(EE_CHAR_UNDERLINE)).GetUnderline();
//STRIP001 	FontUnderline eNew = eOld;
//STRIP001 	switch (nSlot)
//STRIP001 	{
//STRIP001 		case SID_ULINE_VAL_NONE:
//STRIP001 			eNew = UNDERLINE_NONE;
//STRIP001 			break;
//STRIP001 		case SID_ULINE_VAL_SINGLE:
//STRIP001 			eNew = ( eOld == UNDERLINE_SINGLE ) ? UNDERLINE_NONE : UNDERLINE_SINGLE;
//STRIP001 			break;
//STRIP001 		case SID_ULINE_VAL_DOUBLE:
//STRIP001 			eNew = ( eOld == UNDERLINE_DOUBLE ) ? UNDERLINE_NONE : UNDERLINE_DOUBLE;
//STRIP001 			break;
//STRIP001 		case SID_ULINE_VAL_DOTTED:
//STRIP001 			eNew = ( eOld == UNDERLINE_DOTTED ) ? UNDERLINE_NONE : UNDERLINE_DOTTED;
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	aSet.Put( SvxUnderlineItem( eNew, EE_CHAR_UNDERLINE ) );
//STRIP001 
//STRIP001 	pView->SetAttributes( aSet );
//STRIP001 	rReq.Done();
//STRIP001 	pViewData->GetScDrawView()->InvalidateDrawTextAttrs();
//STRIP001 }

//STRIP001 void lcl_RemoveFields( OutlinerView& rOutView )
//STRIP001 {
//STRIP001 	//!	Outliner should have RemoveFields with a selection
//STRIP001 
//STRIP001 	Outliner* pOutliner = rOutView.GetOutliner();
//STRIP001 	if (!pOutliner) return;
//STRIP001 
//STRIP001 	ESelection aOldSel = rOutView.GetSelection();
//STRIP001 	ESelection aSel = aOldSel;
//STRIP001 	aSel.Adjust();
//STRIP001 	xub_StrLen nNewEnd = aSel.nEndPos;
//STRIP001 
//STRIP001 	BOOL bUpdate = pOutliner->GetUpdateMode();
//STRIP001 	BOOL bChanged = FALSE;
//STRIP001 
//STRIP001 	//!	GetPortions and GetAttribs should be const!
//STRIP001 	EditEngine& rEditEng = (EditEngine&)pOutliner->GetEditEngine();
//STRIP001 
//STRIP001 	ULONG nParCount = pOutliner->GetParagraphCount();
//STRIP001 	for (ULONG nPar=0; nPar<nParCount; nPar++)
//STRIP001 		if ( nPar >= aSel.nStartPara && nPar <= aSel.nEndPara )
//STRIP001 		{
//STRIP001 			SvUShorts aPortions;
//STRIP001 			rEditEng.GetPortions( (USHORT)nPar, aPortions );
//STRIP001 			//!	GetPortions should use xub_StrLen instead of USHORT
//STRIP001 
//STRIP001 			for ( USHORT nPos = aPortions.Count(); nPos; )
//STRIP001 			{
//STRIP001 				--nPos;
//STRIP001 				USHORT nEnd = aPortions.GetObject( nPos );
//STRIP001 				USHORT nStart = nPos ? aPortions.GetObject( nPos - 1 ) : 0;
//STRIP001 				// fields are single characters
//STRIP001 				if ( nEnd == nStart+1 &&
//STRIP001 					 ( nPar > aSel.nStartPara || nStart >= aSel.nStartPos ) &&
//STRIP001 					 ( nPar < aSel.nEndPara   || nEnd   <= aSel.nEndPos ) )
//STRIP001 				{
//STRIP001 					ESelection aFieldSel( (USHORT)nPar, nStart, (USHORT)nPar, nEnd );
//STRIP001 					SfxItemSet aSet = rEditEng.GetAttribs( aFieldSel );
//STRIP001 					if ( aSet.GetItemState( EE_FEATURE_FIELD ) == SFX_ITEM_ON )
//STRIP001 					{
//STRIP001 						if (!bChanged)
//STRIP001 						{
//STRIP001 							if (bUpdate)
//STRIP001 								pOutliner->SetUpdateMode( FALSE );
//STRIP001 							String aName = ScGlobal::GetRscString( STR_UNDO_DELETECONTENTS );
//STRIP001 							pOutliner->GetUndoManager().EnterListAction( aName, aName );
//STRIP001 							bChanged = TRUE;
//STRIP001 						}
//STRIP001 
//STRIP001 						String aFieldText = rEditEng.GetText( aFieldSel );
//STRIP001 						pOutliner->QuickInsertText( aFieldText, aFieldSel );
//STRIP001 						if ( nPar == aSel.nEndPara )
//STRIP001 						{
//STRIP001 							nNewEnd += aFieldText.Len();
//STRIP001 							--nNewEnd;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 	if (bUpdate && bChanged)
//STRIP001 	{
//STRIP001 		pOutliner->GetUndoManager().LeaveListAction();
//STRIP001 		pOutliner->SetUpdateMode( TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aOldSel.IsEqual( aSel ) )			// aSel is adjusted
//STRIP001 		aOldSel.nEndPos = nNewEnd;
//STRIP001 	else
//STRIP001 		aOldSel.nStartPos = nNewEnd;		// if aOldSel is backwards
//STRIP001 	rOutView.SetSelection( aOldSel );
//STRIP001 }

//STRIP001 void __EXPORT ScDrawTextObjectBar::ExecuteAttr( SfxRequest &rReq )
//STRIP001 {
//STRIP001 	SdrView*			pView = pViewData->GetScDrawView();
//STRIP001 	const SfxItemSet*	pArgs = rReq.GetArgs();
//STRIP001 	USHORT				nSlot = rReq.GetSlot();
//STRIP001 
//STRIP001 	BOOL bArgsInReq = ( pArgs != NULL );
//STRIP001 	if ( !bArgsInReq )
//STRIP001 	{
//STRIP001 		SfxItemSet aEditAttr(pView->GetModel()->GetItemPool());
//STRIP001 		pView->GetAttributes(aEditAttr);
//STRIP001 		SfxItemSet	aNewAttr( *aEditAttr.GetPool(), aEditAttr.GetRanges() );
//STRIP001 		BOOL		bDone = TRUE;
//STRIP001 
//STRIP001 		switch ( nSlot )
//STRIP001 		{
//STRIP001 			case SID_TEXT_STANDARD:	// Harte Textattributierung loeschen
//STRIP001 			{
//STRIP001 				OutlinerView* pOutView = pView->IsTextEdit() ?
//STRIP001 								pView->GetTextEditOutlinerView() : NULL;
//STRIP001 				if ( pOutView )
//STRIP001 					pOutView->Paint( Rectangle() );
//STRIP001 
//STRIP001 				SfxItemSet aEmptyAttr( *aEditAttr.GetPool(), EE_ITEMS_START, EE_ITEMS_END );
//STRIP001 				pView->SetAttributes( aEmptyAttr, TRUE );
//STRIP001 
//STRIP001 				if ( pOutView )
//STRIP001 				{
//STRIP001 					lcl_RemoveFields( *pOutView );
//STRIP001 					pOutView->ShowCursor();
//STRIP001 				}
//STRIP001 
//STRIP001 				rReq.Done( aEmptyAttr );
//STRIP001 				pViewData->GetScDrawView()->InvalidateDrawTextAttrs();
//STRIP001 				bDone = FALSE; // bereits hier passiert
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SID_CHAR_DLG:						// Dialog-Button
//STRIP001 			case SID_ATTR_CHAR_FONT:				// Controller nicht angezeigt
//STRIP001 			case SID_ATTR_CHAR_FONTHEIGHT:
//STRIP001 				bDone = ExecuteCharDlg( aEditAttr, aNewAttr );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_PARA_DLG:
//STRIP001 				bDone = ExecuteParaDlg( aEditAttr, aNewAttr );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ATTR_CHAR_WEIGHT:
//STRIP001 				aNewAttr.Put( (const SvxWeightItem&)aEditAttr.Get( EE_CHAR_WEIGHT ) );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ATTR_CHAR_POSTURE:
//STRIP001 				aNewAttr.Put( (const SvxPostureItem&)aEditAttr.Get( EE_CHAR_ITALIC ) );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ATTR_CHAR_UNDERLINE:
//STRIP001 				aNewAttr.Put( (const SvxUnderlineItem&)aEditAttr.Get( EE_CHAR_UNDERLINE ) );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ATTR_CHAR_CONTOUR:
//STRIP001 				aNewAttr.Put( (const SvxContourItem&)aEditAttr.Get( EE_CHAR_OUTLINE ) );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ATTR_CHAR_SHADOWED:
//STRIP001 				aNewAttr.Put( (const SvxShadowedItem&)aEditAttr.Get( EE_CHAR_SHADOW ) );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ATTR_CHAR_STRIKEOUT:
//STRIP001 				aNewAttr.Put( (const SvxCrossedOutItem&)aEditAttr.Get( EE_CHAR_STRIKEOUT ) );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ALIGNLEFT:
//STRIP001 				aNewAttr.Put( SvxAdjustItem( SVX_ADJUST_LEFT, EE_PARA_JUST ) );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ALIGNCENTERHOR:
//STRIP001 				aNewAttr.Put( SvxAdjustItem( SVX_ADJUST_CENTER, EE_PARA_JUST ) );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ALIGNRIGHT:
//STRIP001 				aNewAttr.Put( SvxAdjustItem( SVX_ADJUST_RIGHT, EE_PARA_JUST ) );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ALIGNBLOCK:
//STRIP001 				aNewAttr.Put( SvxAdjustItem( SVX_ADJUST_BLOCK, EE_PARA_JUST ) );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ATTR_PARA_LINESPACE_10:
//STRIP001 				{
//STRIP001 					SvxLineSpacingItem aItem( SVX_LINESPACE_ONE_LINE, EE_PARA_SBL );
//STRIP001 					aItem.SetPropLineSpace( 100 );
//STRIP001 					aNewAttr.Put( aItem );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ATTR_PARA_LINESPACE_15:
//STRIP001 				{
//STRIP001 					SvxLineSpacingItem aItem( SVX_LINESPACE_ONE_POINT_FIVE_LINES, EE_PARA_SBL );
//STRIP001 					aItem.SetPropLineSpace( 150 );
//STRIP001 					aNewAttr.Put( aItem );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_ATTR_PARA_LINESPACE_20:
//STRIP001 				{
//STRIP001 					SvxLineSpacingItem aItem( SVX_LINESPACE_TWO_LINES, EE_PARA_SBL );
//STRIP001 					aItem.SetPropLineSpace( 200 );
//STRIP001 					aNewAttr.Put( aItem );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_SET_SUPER_SCRIPT:
//STRIP001 				{
//STRIP001 					SvxEscapementItem aItem(EE_CHAR_ESCAPEMENT);
//STRIP001 					SvxEscapement eEsc = (SvxEscapement) ( (const SvxEscapementItem&)
//STRIP001 									aEditAttr.Get( EE_CHAR_ESCAPEMENT ) ).GetEnumValue();
//STRIP001 
//STRIP001 					if( eEsc == SVX_ESCAPEMENT_SUPERSCRIPT )
//STRIP001 						aItem.SetEscapement( SVX_ESCAPEMENT_OFF );
//STRIP001 					else
//STRIP001 						aItem.SetEscapement( SVX_ESCAPEMENT_SUPERSCRIPT );
//STRIP001 					aNewAttr.Put( aItem );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			case SID_SET_SUB_SCRIPT:
//STRIP001 				{
//STRIP001 					SvxEscapementItem aItem(EE_CHAR_ESCAPEMENT);
//STRIP001 					SvxEscapement eEsc = (SvxEscapement) ( (const SvxEscapementItem&)
//STRIP001 									aEditAttr.Get( EE_CHAR_ESCAPEMENT ) ).GetEnumValue();
//STRIP001 
//STRIP001 					if( eEsc == SVX_ESCAPEMENT_SUBSCRIPT )
//STRIP001 						aItem.SetEscapement( SVX_ESCAPEMENT_OFF );
//STRIP001 					else
//STRIP001 						aItem.SetEscapement( SVX_ESCAPEMENT_SUBSCRIPT );
//STRIP001 					aNewAttr.Put( aItem );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_DRAWTEXT_ATTR_DLG:
//STRIP001 				{
//STRIP001 					SvxTextTabDialog* pDlg =
//STRIP001 						new SvxTextTabDialog( pViewData->GetDialogParent(),
//STRIP001 											   &aEditAttr,
//STRIP001 											   pView );
//STRIP001 
//STRIP001 					bDone = ( RET_OK == pDlg->Execute() );
//STRIP001 
//STRIP001 					if ( bDone )
//STRIP001 						aNewAttr.Put( *pDlg->GetOutputItemSet() );
//STRIP001 
//STRIP001 					delete pDlg;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bDone ) // wurden Attribute geaendert?
//STRIP001 		{
//STRIP001 			rReq.Done( aNewAttr );
//STRIP001 			pArgs = rReq.GetArgs();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pArgs )
//STRIP001 	{
//STRIP001 		if ( bArgsInReq &&
//STRIP001 			( nSlot == SID_ATTR_CHAR_FONT || nSlot == SID_ATTR_CHAR_FONTHEIGHT ||
//STRIP001 			  nSlot == SID_ATTR_CHAR_WEIGHT || nSlot == SID_ATTR_CHAR_POSTURE ) )
//STRIP001 		{
//STRIP001 			// font items from toolbox controller have to be applied for the right script type
//STRIP001 
//STRIP001 			USHORT nScript = pView->GetScriptType();
//STRIP001 
//STRIP001 			SfxItemPool& rPool = GetPool();
//STRIP001 			SvxScriptSetItem aSetItem( nSlot, rPool );
//STRIP001 			USHORT nWhich = rPool.GetWhich( nSlot );
//STRIP001 			aSetItem.PutItemForScriptType( nScript, pArgs->Get( nWhich ) );
//STRIP001 
//STRIP001 			pView->SetAttributes( aSetItem.GetItemSet() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// use args directly
//STRIP001 
//STRIP001 			pView->SetAttributes( *pArgs );
//STRIP001 		}
//STRIP001 		pViewData->GetScDrawView()->InvalidateDrawTextAttrs();
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScDrawTextObjectBar::GetAttrState( SfxItemSet& rDestSet )
//STRIP001 {
//STRIP001 	if ( IsNoteEdit() )
//STRIP001 	{
//STRIP001 			//	Notizen haben keine Text-Attribute !!!
//STRIP001 		SfxWhichIter aIter(rDestSet);
//STRIP001 		USHORT nWhich = aIter.FirstWhich();
//STRIP001 		while ( nWhich )
//STRIP001 		{
//STRIP001 			rDestSet.DisableItem( nWhich );
//STRIP001 			nWhich = aIter.NextWhich();
//STRIP001 		}
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	SvtLanguageOptions	aLangOpt;
//STRIP001 	BOOL bDisableCTLFont = !aLangOpt.IsCTLFontEnabled();
//STRIP001 	BOOL bDisableVerticalText = !aLangOpt.IsVerticalTextEnabled();
//STRIP001 	
//STRIP001 	SdrView* pView = pViewData->GetScDrawView();
//STRIP001 	SfxItemSet aAttrSet(pView->GetModel()->GetItemPool());
//STRIP001 	pView->GetAttributes(aAttrSet);
//STRIP001 
//STRIP001 	//	direkte Attribute
//STRIP001 
//STRIP001 	rDestSet.Put( aAttrSet );
//STRIP001 
//STRIP001 	//	choose font info according to selection script type
//STRIP001 
//STRIP001 	USHORT nScript = pView->GetScriptType();
//STRIP001 
//STRIP001 	if ( rDestSet.GetItemState( EE_CHAR_FONTINFO ) != SFX_ITEM_UNKNOWN )
//STRIP001 		ScViewUtil::PutItemScript( rDestSet, aAttrSet, EE_CHAR_FONTINFO, nScript );
//STRIP001 	if ( rDestSet.GetItemState( EE_CHAR_FONTHEIGHT ) != SFX_ITEM_UNKNOWN )
//STRIP001 		ScViewUtil::PutItemScript( rDestSet, aAttrSet, EE_CHAR_FONTHEIGHT, nScript );
//STRIP001 	if ( rDestSet.GetItemState( EE_CHAR_WEIGHT ) != SFX_ITEM_UNKNOWN )
//STRIP001 		ScViewUtil::PutItemScript( rDestSet, aAttrSet, EE_CHAR_WEIGHT, nScript );
//STRIP001 	if ( rDestSet.GetItemState( EE_CHAR_ITALIC ) != SFX_ITEM_UNKNOWN )
//STRIP001 		ScViewUtil::PutItemScript( rDestSet, aAttrSet, EE_CHAR_ITALIC, nScript );
//STRIP001 
//STRIP001 	//	Ausrichtung
//STRIP001 
//STRIP001 	SvxAdjust eAdj = ((const SvxAdjustItem&)aAttrSet.Get(EE_PARA_JUST)).GetAdjust();
//STRIP001 	switch( eAdj )
//STRIP001 	{
//STRIP001 		case SVX_ADJUST_LEFT:
//STRIP001 			rDestSet.Put( SfxBoolItem( SID_ALIGNLEFT, TRUE ) );
//STRIP001 			break;
//STRIP001 		case SVX_ADJUST_CENTER:
//STRIP001 			rDestSet.Put( SfxBoolItem( SID_ALIGNCENTERHOR, TRUE ) );
//STRIP001 			break;
//STRIP001 		case SVX_ADJUST_RIGHT:
//STRIP001 			rDestSet.Put( SfxBoolItem( SID_ALIGNRIGHT, TRUE ) );
//STRIP001 			break;
//STRIP001 		case SVX_ADJUST_BLOCK:
//STRIP001 			rDestSet.Put( SfxBoolItem( SID_ALIGNBLOCK, TRUE ) );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Zeilenabstand
//STRIP001 
//STRIP001 	USHORT nLineSpace = (USHORT)
//STRIP001 				((const SvxLineSpacingItem&)aAttrSet.
//STRIP001 						Get( EE_PARA_SBL )).GetPropLineSpace();
//STRIP001 	switch( nLineSpace )
//STRIP001 	{
//STRIP001 		case 100:
//STRIP001 			rDestSet.Put( SfxBoolItem( SID_ATTR_PARA_LINESPACE_10, TRUE ) );
//STRIP001 			break;
//STRIP001 		case 150:
//STRIP001 			rDestSet.Put( SfxBoolItem( SID_ATTR_PARA_LINESPACE_15, TRUE ) );
//STRIP001 			break;
//STRIP001 		case 200:
//STRIP001 			rDestSet.Put( SfxBoolItem( SID_ATTR_PARA_LINESPACE_20, TRUE ) );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	hoch-/tiefgestellt
//STRIP001 
//STRIP001 	SvxEscapement eEsc = (SvxEscapement) ( (const SvxEscapementItem&)
//STRIP001 					aAttrSet.Get( EE_CHAR_ESCAPEMENT ) ).GetEnumValue();
//STRIP001 	if( eEsc == SVX_ESCAPEMENT_SUPERSCRIPT )
//STRIP001 		rDestSet.Put( SfxBoolItem( SID_SET_SUPER_SCRIPT, TRUE ) );
//STRIP001 	else if( eEsc == SVX_ESCAPEMENT_SUBSCRIPT )
//STRIP001 		rDestSet.Put( SfxBoolItem( SID_SET_SUB_SCRIPT, TRUE ) );
//STRIP001 
//STRIP001 	//	Unterstreichung
//STRIP001 
//STRIP001 	SfxItemState eState = aAttrSet.GetItemState( EE_CHAR_UNDERLINE, TRUE );
//STRIP001 	if ( eState == SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		rDestSet.InvalidateItem( SID_ULINE_VAL_NONE );
//STRIP001 		rDestSet.InvalidateItem( SID_ULINE_VAL_SINGLE );
//STRIP001 		rDestSet.InvalidateItem( SID_ULINE_VAL_DOUBLE );
//STRIP001 		rDestSet.InvalidateItem( SID_ULINE_VAL_DOTTED );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		FontUnderline eUnderline = ((const SvxUnderlineItem&)
//STRIP001 					aAttrSet.Get(EE_CHAR_UNDERLINE)).GetUnderline();
//STRIP001 		USHORT nId = SID_ULINE_VAL_NONE;
//STRIP001 		switch (eUnderline)
//STRIP001 		{
//STRIP001 			case UNDERLINE_SINGLE:	nId = SID_ULINE_VAL_SINGLE;	break;
//STRIP001 			case UNDERLINE_DOUBLE:	nId = SID_ULINE_VAL_DOUBLE;	break;
//STRIP001 			case UNDERLINE_DOTTED:	nId = SID_ULINE_VAL_DOTTED;	break;
//STRIP001 			default:
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		rDestSet.Put( SfxBoolItem( nId, TRUE ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	//	horizontal / vertical
//STRIP001 
//STRIP001 	BOOL bLeftToRight = TRUE;
//STRIP001 
//STRIP001 	SdrOutliner* pOutl = pView->GetTextEditOutliner();
//STRIP001 	if( pOutl )
//STRIP001 	{
//STRIP001 		if( pOutl->IsVertical() )
//STRIP001 			bLeftToRight = FALSE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bLeftToRight = ( (const SvxWritingModeItem&) aAttrSet.Get( SDRATTR_TEXTDIRECTION ) ).GetValue() == ::com::sun::star::text::WritingMode_LR_TB;
//STRIP001 
//STRIP001 	if ( bDisableVerticalText )
//STRIP001 	{
//STRIP001 		rDestSet.DisableItem( SID_TEXTDIRECTION_LEFT_TO_RIGHT );
//STRIP001 		rDestSet.DisableItem( SID_TEXTDIRECTION_TOP_TO_BOTTOM );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rDestSet.Put( SfxBoolItem( SID_TEXTDIRECTION_LEFT_TO_RIGHT, bLeftToRight ) );
//STRIP001 		rDestSet.Put( SfxBoolItem( SID_TEXTDIRECTION_TOP_TO_BOTTOM, !bLeftToRight ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	//	left-to-right or right-to-left
//STRIP001 
//STRIP001 	if ( !bLeftToRight || bDisableCTLFont )
//STRIP001 	{
//STRIP001 		//	disabled if vertical
//STRIP001 		rDestSet.DisableItem( SID_ATTR_PARA_LEFT_TO_RIGHT );
//STRIP001 		rDestSet.DisableItem( SID_ATTR_PARA_RIGHT_TO_LEFT );
//STRIP001 	}
//STRIP001 	else if ( aAttrSet.GetItemState( EE_PARA_WRITINGDIR ) == SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		rDestSet.InvalidateItem( SID_ATTR_PARA_LEFT_TO_RIGHT );
//STRIP001 		rDestSet.InvalidateItem( SID_ATTR_PARA_RIGHT_TO_LEFT );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 	    SvxFrameDirection eAttrDir = (SvxFrameDirection)((const SvxFrameDirectionItem&)
//STRIP001 	                                    aAttrSet.Get( EE_PARA_WRITINGDIR )).GetValue();
//STRIP001 	    if ( eAttrDir == FRMDIR_ENVIRONMENT )
//STRIP001 	    {
//STRIP001 	    	//	get "environment" direction from page style
//STRIP001 	    	if ( pViewData->GetDocument()->GetEditTextDirection( pViewData->GetTabNo() ) == EE_HTEXTDIR_R2L )
//STRIP001 		    	eAttrDir = FRMDIR_HORI_RIGHT_TOP;
//STRIP001 		    else
//STRIP001 		    	eAttrDir = FRMDIR_HORI_LEFT_TOP;
//STRIP001 	    }
//STRIP001 		rDestSet.Put( SfxBoolItem( SID_ATTR_PARA_LEFT_TO_RIGHT, ( eAttrDir == FRMDIR_HORI_LEFT_TOP ) ) );
//STRIP001 		rDestSet.Put( SfxBoolItem( SID_ATTR_PARA_RIGHT_TO_LEFT, ( eAttrDir == FRMDIR_HORI_RIGHT_TOP ) ) );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScDrawTextObjectBar::ExecuteTrans( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	sal_Int32 nType = ScViewUtil::GetTransliterationType( rReq.GetSlot() );
//STRIP001 	if ( nType )
//STRIP001 	{
//STRIP001 		ScDrawView* pView = pViewData->GetScDrawView();
//STRIP001 		OutlinerView* pOutView = pView->GetTextEditOutlinerView();
//STRIP001 		if ( pOutView )
//STRIP001 		{
//STRIP001 			//	change selected text in object
//STRIP001 			pOutView->TransliterateText( nType );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//!	apply to whole objects?
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

}
