/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_undoblk3.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:06:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

//----------------------------------------------------------------------------

#define _MACRODLG_HXX
#define _BIGINT_HXX
#define _SVDXOUT_HXX
#define _SVDATTR_HXX
#define _SVDSURO_HXX

// INCLUDE -------------------------------------------------------------------

#include "scitems.hxx"
#include <bf_svx/boxitem.hxx>
// auto strip #include <bf_svx/srchitem.hxx>
// auto strip #include <bf_svx/linkmgr.hxx>
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #include <vcl/virdev.hxx>

#include "undoblk.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
// auto strip #include "global.hxx"
// auto strip #include "rangenam.hxx"
// auto strip #include "arealink.hxx"
#include "patattr.hxx"
// auto strip #include "target.hxx"
// auto strip #include "document.hxx"
#include "docpool.hxx"
// auto strip #include "table.hxx"
#include "docsh.hxx"
#include "tabvwsh.hxx"
// auto strip #include "undoolk.hxx"
// auto strip #include "undoutil.hxx"
// auto strip #include "chgtrack.hxx"
// auto strip #include "dociter.hxx"
// auto strip #include "cell.hxx"

#ifndef _SFX_SRCHITEM_HXX
#include <bf_sfx2/srchitem.hxx>
#endif

namespace binfilter {

// STATIC DATA ---------------------------------------------------------------

//STRIP001 TYPEINIT1(ScUndoDeleteContents, 	SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoFillTable,		 	SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoSelectionAttr,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoAutoFill,			SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoMerge,				SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoAutoFormat, 		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoReplace,			SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoTabOp,				SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoSpelling,			SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoRefreshLink,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoInsertAreaLink,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoRemoveAreaLink,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoUpdateAreaLink,		SfxUndoAction);


// To Do:
/*A*/	// SetOptimalHeight auf Dokument, wenn keine View


//============================================================================
//	class ScUndoDeleteContents
//
//	Inhalte loeschen

//----------------------------------------------------------------------------

//STRIP001 ScUndoDeleteContents::ScUndoDeleteContents(
//STRIP001 				ScDocShell* pNewDocShell,
//STRIP001 				const ScMarkData& rMark, const ScRange& rRange,
//STRIP001 				ScDocument* pNewUndoDoc, BOOL bNewMulti,
//STRIP001 				USHORT nNewFlags, BOOL bObjects )
//STRIP001 		//
//STRIP001 	:	ScSimpleUndo( pNewDocShell ),
//STRIP001 		//
//STRIP001 		aMarkData	( rMark ),
//STRIP001 		aRange		( rRange ),
//STRIP001 		pUndoDoc	( pNewUndoDoc ),
//STRIP001 		bMulti		( bNewMulti ),	// ueberliquid
//STRIP001 		nFlags		( nNewFlags ),
//STRIP001 		pDrawUndo	( NULL )
//STRIP001 {
//STRIP001 	if (bObjects)
//STRIP001 		pDrawUndo = GetSdrUndoAction( pDocShell->GetDocument() );
//STRIP001 
//STRIP001 	if ( !(aMarkData.IsMarked() || aMarkData.IsMultiMarked()) )		// keine Zelle markiert:
//STRIP001 		aMarkData.SetMarkArea( aRange );							// Zelle unter Cursor markieren
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScUndoDeleteContents::~ScUndoDeleteContents()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	DeleteSdrUndoAction( pDrawUndo );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 String __EXPORT ScUndoDeleteContents::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_DELETECONTENTS );	 // "Loeschen"
//STRIP001 }


//STRIP001 void ScUndoDeleteContents::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack && (nFlags & IDF_CONTENTS) )
//STRIP001 		pChangeTrack->AppendContentRange( aRange, pUndoDoc,
//STRIP001 			nStartChangeAction, nEndChangeAction );
//STRIP001 	else
//STRIP001 		nStartChangeAction = nEndChangeAction = 0;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScUndoDeleteContents::DoChange( const BOOL bUndo )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->DoneBlockMode();
//STRIP001 		pViewShell->InitOwnBlockMode();
//STRIP001 		pViewShell->GetViewData()->GetMarkData() = aMarkData;	// CopyMarksTo
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bPaintExt = FALSE;
//STRIP001 
//STRIP001 	if (bUndo)	// nur Undo
//STRIP001 	{
//STRIP001 		USHORT nUndoFlags = IDF_NONE;		//	entweder alle oder keine Inhalte kopieren
//STRIP001 		if (nFlags & IDF_CONTENTS)			//	(es sind nur die richtigen ins UndoDoc kopiert worden)
//STRIP001 			nUndoFlags |= IDF_CONTENTS;
//STRIP001 		if (nFlags & IDF_ATTRIB)
//STRIP001 			nUndoFlags |= IDF_ATTRIB;
//STRIP001 		if (nFlags & IDF_EDITATTR)			// Edit-Engine-Attribute
//STRIP001 			nUndoFlags |= IDF_STRING;		// -> Zellen werden geaendert
//STRIP001 
//STRIP001 		ScRange aCopyRange = aRange;
//STRIP001 		USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 		aCopyRange.aStart.SetTab(0);
//STRIP001 		aCopyRange.aEnd.SetTab(nTabCount-1);
//STRIP001 
//STRIP001 		pUndoDoc->CopyToDocument( aCopyRange, nUndoFlags, bMulti, pDoc, &aMarkData );
//STRIP001 
//STRIP001 		if (pDrawUndo)
//STRIP001 			DoSdrUndoAction( pDrawUndo );
//STRIP001 
//STRIP001 		ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 		if ( pChangeTrack )
//STRIP001 			pChangeTrack->Undo( nStartChangeAction, nEndChangeAction );
//STRIP001 
//STRIP001 		bPaintExt = pDoc->HasAttrib( aRange, HASATTR_PAINTEXT );	// hinterher
//STRIP001 	}
//STRIP001 	else		// nur Redo
//STRIP001 	{
//STRIP001 		bPaintExt = pDoc->HasAttrib( aRange, HASATTR_PAINTEXT );	// vorher
//STRIP001 
//STRIP001 		aMarkData.MarkToMulti();
//STRIP001 		if (pDrawUndo)
//STRIP001 			pDoc->DeleteObjectsInSelection( aMarkData );
//STRIP001 		pDoc->DeleteSelection( nFlags, aMarkData );
//STRIP001 		aMarkData.MarkToSimple();
//STRIP001 
//STRIP001 		SetChangeTrack();
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nExtFlags = bPaintExt ? SC_PF_LINES : 0;
//STRIP001 	if ( !( (pViewShell) && pViewShell->AdjustRowHeight(
//STRIP001 								aRange.aStart.Row(), aRange.aEnd.Row() ) ) )
//STRIP001 /*A*/	pDocShell->PostPaint( aRange, PAINT_GRID | PAINT_EXTRAS, nExtFlags );
//STRIP001 
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->CellContentChanged();
//STRIP001 
//STRIP001 	ShowTable( aRange );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoDeleteContents::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange( TRUE );
//STRIP001 	EndUndo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoDeleteContents::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoChange( FALSE );
//STRIP001 	EndRedo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoDeleteContents::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->DeleteContents( nFlags, TRUE );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScUndoDeleteContents::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


//============================================================================
//	class ScUndoFillTable
//
//	Tabellen ausfuellen
//	(Bearbeiten|Ausfuellen|...)

//----------------------------------------------------------------------------

//STRIP001 ScUndoFillTable::ScUndoFillTable( ScDocShell* pNewDocShell,
//STRIP001 				const ScMarkData& rMark,
//STRIP001 				USHORT nStartX, USHORT nStartY, USHORT nStartZ,
//STRIP001 				USHORT nEndX, USHORT nEndY, USHORT nEndZ,
//STRIP001 				ScDocument* pNewUndoDoc, BOOL bNewMulti, USHORT nSrc,
//STRIP001 				USHORT nFlg, USHORT nFunc, BOOL bSkip, BOOL bLink )
//STRIP001 		//
//STRIP001 	:	ScSimpleUndo( pNewDocShell ),
//STRIP001 		//
//STRIP001 		aMarkData	( rMark ),
//STRIP001 		aRange		( nStartX, nStartY, nStartZ, nEndX, nEndY, nEndZ ),
//STRIP001 		pUndoDoc	( pNewUndoDoc ),
//STRIP001 		bMulti		( bNewMulti ),
//STRIP001 		nSrcTab		( nSrc ),
//STRIP001 		nFlags		( nFlg ),
//STRIP001 		nFunction	( nFunc ),
//STRIP001 		bSkipEmpty	( bSkip ),
//STRIP001 		bAsLink		( bLink )
//STRIP001 {
//STRIP001 	SetChangeTrack();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScUndoFillTable::~ScUndoFillTable()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 String __EXPORT ScUndoFillTable::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_FILL_TAB );
//STRIP001 }


//STRIP001 void ScUndoFillTable::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 	{
//STRIP001 		USHORT nTabCount = pDocShell->GetDocument()->GetTableCount();
//STRIP001 		ScRange aWorkRange(aRange);
//STRIP001 		nStartChangeAction = 0;
//STRIP001 		ULONG nTmpAction;
//STRIP001 		for ( USHORT i = 0; i < nTabCount; i++ )
//STRIP001 		{
//STRIP001 			if (i != nSrcTab && aMarkData.GetTableSelect(i))
//STRIP001 			{
//STRIP001 				aWorkRange.aStart.SetTab(i);
//STRIP001 				aWorkRange.aEnd.SetTab(i);
//STRIP001 				pChangeTrack->AppendContentRange( aWorkRange, pUndoDoc,
//STRIP001 					nTmpAction, nEndChangeAction );
//STRIP001 				if ( !nStartChangeAction )
//STRIP001 					nStartChangeAction = nTmpAction;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nStartChangeAction = nEndChangeAction = 0;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScUndoFillTable::DoChange( const BOOL bUndo )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->DoneBlockMode();
//STRIP001 		pViewShell->InitOwnBlockMode();
//STRIP001 		pViewShell->GetViewData()->GetMarkData() = aMarkData;	// CopyMarksTo
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bUndo)	// nur Undo
//STRIP001 	{
//STRIP001 		USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 		ScRange aWorkRange(aRange);
//STRIP001 		for ( USHORT i = 0; i < nTabCount; i++ )
//STRIP001 			if (i != nSrcTab && aMarkData.GetTableSelect(i))
//STRIP001 			{
//STRIP001 				aWorkRange.aStart.SetTab(i);
//STRIP001 				aWorkRange.aEnd.SetTab(i);
//STRIP001 				if (bMulti)
//STRIP001 					pDoc->DeleteSelectionTab( i, IDF_ALL, aMarkData );
//STRIP001 				else
//STRIP001 					pDoc->DeleteAreaTab( aWorkRange, IDF_ALL );
//STRIP001 				pUndoDoc->CopyToDocument( aWorkRange, IDF_ALL, bMulti, pDoc, &aMarkData );
//STRIP001 			}
//STRIP001 
//STRIP001 		ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 		if ( pChangeTrack )
//STRIP001 			pChangeTrack->Undo( nStartChangeAction, nEndChangeAction );
//STRIP001 	}
//STRIP001 	else		// nur Redo
//STRIP001 	{
//STRIP001 		aMarkData.MarkToMulti();
//STRIP001 		pDoc->FillTabMarked( nSrcTab, aMarkData, nFlags, nFunction, bSkipEmpty, bAsLink );
//STRIP001 		aMarkData.MarkToSimple();
//STRIP001 		SetChangeTrack();
//STRIP001 	}
//STRIP001 
//STRIP001 	pDocShell->PostPaint(0,0,0,MAXCOL,MAXROW,MAXTAB, PAINT_GRID|PAINT_EXTRAS);
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 
//STRIP001 	//	CellContentChanged kommt mit der Markierung
//STRIP001 
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		USHORT nTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 		if ( !aMarkData.GetTableSelect(nTab) )
//STRIP001 			pViewShell->SetTabNo( nSrcTab );
//STRIP001 
//STRIP001 		pViewShell->DoneBlockMode();	// gibt sonst Probleme, weil Markierung auf falscher Tabelle
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoFillTable::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange( TRUE );
//STRIP001 	EndUndo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoFillTable::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoChange( FALSE );
//STRIP001 	EndRedo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoFillTable::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->FillTab( nFlags, nFunction, bSkipEmpty, bAsLink );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScUndoFillTable::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


//============================================================================
//	class ScUndoSelectionAttr
//
//	Zellformat aendern

//----------------------------------------------------------------------------

/*N*/ ScUndoSelectionAttr::ScUndoSelectionAttr( ScDocShell* pNewDocShell,
/*N*/ 				const ScMarkData& rMark,
/*N*/ 				USHORT nStartX, USHORT nStartY, USHORT nStartZ,
/*N*/ 				USHORT nEndX, USHORT nEndY, USHORT nEndZ,
/*N*/ 				ScDocument* pNewUndoDoc, BOOL bNewMulti,
/*N*/ 				const ScPatternAttr* pNewApply,
/*N*/ 				const SvxBoxItem* pNewOuter, const SvxBoxInfoItem* pNewInner )
/*N*/ 		//
/*N*/ 	:	ScSimpleUndo( pNewDocShell ),
/*N*/ 		//
/*N*/ 		aMarkData	( rMark ),
/*N*/ 		aRange		( nStartX, nStartY, nStartZ, nEndX, nEndY, nEndZ ),
/*N*/ 		pUndoDoc	( pNewUndoDoc ),
/*N*/ 		bMulti		( bNewMulti )
/*N*/ {
/*N*/ 	ScDocumentPool* pPool = pDocShell->GetDocument()->GetPool();
/*N*/ 	pApplyPattern = (ScPatternAttr*) &pPool->Put( *pNewApply );
/*N*/ 	pLineOuter = pNewOuter ? (SvxBoxItem*) &pPool->Put( *pNewOuter ) : NULL;
/*N*/ 	pLineInner = pNewInner ? (SvxBoxInfoItem*) &pPool->Put( *pNewInner ) : NULL;
/*N*/ }


//----------------------------------------------------------------------------

/*N*/ __EXPORT ScUndoSelectionAttr::~ScUndoSelectionAttr()
/*N*/ {
/*N*/ 	ScDocumentPool* pPool = pDocShell->GetDocument()->GetPool();
/*N*/ 	pPool->Remove(*pApplyPattern);
/*N*/ 	if (pLineOuter)
/*?*/ 		pPool->Remove(*pLineOuter);
/*N*/ 	if (pLineInner)
/*?*/ 		pPool->Remove(*pLineInner);
/*N*/ 
/*N*/ 	delete pUndoDoc;
/*N*/ }


//----------------------------------------------------------------------------

/*N*/ String __EXPORT ScUndoSelectionAttr::GetComment() const
/*N*/ {
/*N*/ 	//"Attribute" "/Linien"
/*N*/ 	return ScGlobal::GetRscString( pLineOuter ? STR_UNDO_SELATTRLINES : STR_UNDO_SELATTR );
/*N*/ }


//----------------------------------------------------------------------------

//STRIP001 void ScUndoSelectionAttr::DoChange( const BOOL bUndo )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->DoneBlockMode();
//STRIP001 		pViewShell->InitOwnBlockMode();
//STRIP001 		pViewShell->GetViewData()->GetMarkData() = aMarkData;	// CopyMarksTo
//STRIP001 	}
//STRIP001 
//STRIP001 	ScRange aEffRange( aRange );
//STRIP001 	if ( pDoc->HasAttrib( aEffRange, HASATTR_MERGED ) )			// zusammengefasste Zellen?
//STRIP001 		pDoc->ExtendMerge( aEffRange );
//STRIP001 
//STRIP001 	BOOL bHasLines = pDoc->HasAttrib( aEffRange, HASATTR_PAINTEXT );
//STRIP001 
//STRIP001 	if (bUndo)	// nur bei Undo
//STRIP001 	{
//STRIP001 		ScRange aCopyRange = aRange;
//STRIP001 		USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 		aCopyRange.aStart.SetTab(0);
//STRIP001 		aCopyRange.aEnd.SetTab(nTabCount-1);
//STRIP001 		pUndoDoc->CopyToDocument( aCopyRange, IDF_ATTRIB, bMulti, pDoc, &aMarkData );
//STRIP001 	}
//STRIP001 	else		// nur bei Redo
//STRIP001 	{
//STRIP001 		aMarkData.MarkToMulti();
//STRIP001 		pDoc->ApplySelectionPattern( *pApplyPattern, aMarkData );
//STRIP001 		aMarkData.MarkToSimple();
//STRIP001 
//STRIP001 		if (pLineOuter)
//STRIP001 			pDoc->ApplySelectionFrame( aMarkData, pLineOuter, pLineInner );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !( (pViewShell) && pViewShell->AdjustBlockHeight() ) )
//STRIP001 /*A*/	pDocShell->PostPaint( aEffRange, PAINT_GRID | PAINT_EXTRAS, (bHasLines ? SC_PF_LINES : 0) );
//STRIP001 
//STRIP001 	ShowTable( aRange );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoSelectionAttr::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange( TRUE );
//STRIP001 	EndUndo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoSelectionAttr::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoChange( FALSE );
//STRIP001 	EndRedo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoSelectionAttr::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScTabViewShell& rViewShell = *((ScTabViewTarget&)rTarget).GetViewShell();
//STRIP001 		if (pLineOuter)
//STRIP001 			rViewShell.ApplyPatternLines( *pApplyPattern, pLineOuter, pLineInner, TRUE );
//STRIP001 		else
//STRIP001 			rViewShell.ApplySelectionPattern( *pApplyPattern, TRUE );
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

/*N*/ BOOL __EXPORT ScUndoSelectionAttr::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }


//============================================================================
//	class ScUndoAutoFill
//
//	Auto-Fill (nur einfache Bloecke)

//----------------------------------------------------------------------------

//STRIP001 ScUndoAutoFill::ScUndoAutoFill( ScDocShell* pNewDocShell,
//STRIP001 				const ScRange& rRange, const ScRange& rSourceArea,
//STRIP001 				ScDocument* pNewUndoDoc, const ScMarkData& rMark,
//STRIP001 				FillDir eNewFillDir, FillCmd eNewFillCmd, FillDateCmd eNewFillDateCmd,
//STRIP001 				double fNewStartValue, double fNewStepValue, double fNewMaxValue,
//STRIP001 				USHORT nMaxShIndex )
//STRIP001 		//
//STRIP001 	:	ScBlockUndo( pNewDocShell, rRange, SC_UNDO_AUTOHEIGHT ),
//STRIP001 		//
//STRIP001 		aSource			( rSourceArea ),
//STRIP001 		aMarkData		( rMark ),
//STRIP001 		pUndoDoc		( pNewUndoDoc ),
//STRIP001 		eFillDir		( eNewFillDir ),
//STRIP001 		eFillCmd		( eNewFillCmd ),
//STRIP001 		eFillDateCmd	( eNewFillDateCmd ),
//STRIP001 		fStartValue		( fNewStartValue ),
//STRIP001 		fStepValue		( fNewStepValue ),
//STRIP001 		fMaxValue		( fNewMaxValue ),
//STRIP001 		nMaxSharedIndex	( nMaxShIndex)
//STRIP001 {
//STRIP001 	SetChangeTrack();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScUndoAutoFill::~ScUndoAutoFill()
//STRIP001 {
//STRIP001 	pDocShell->GetDocument()->EraseNonUsedSharedNames(nMaxSharedIndex);
//STRIP001 	delete pUndoDoc;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 String __EXPORT ScUndoAutoFill::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_AUTOFILL ); //"Ausfuellen"
//STRIP001 }


//STRIP001 void ScUndoAutoFill::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->AppendContentRange( aBlockRange, pUndoDoc,
//STRIP001 			nStartChangeAction, nEndChangeAction );
//STRIP001 	else
//STRIP001 		nStartChangeAction = nEndChangeAction = 0;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoAutoFill::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	for (USHORT nTab=0; nTab<nTabCount; nTab++)
//STRIP001 	{
//STRIP001 		if (aMarkData.GetTableSelect(nTab))
//STRIP001 		{
//STRIP001 			ScRange aWorkRange = aBlockRange;
//STRIP001 			aWorkRange.aStart.SetTab(nTab);
//STRIP001 			aWorkRange.aEnd.SetTab(nTab);
//STRIP001 
//STRIP001 			BOOL bHasLines = pDoc->HasAttrib( aWorkRange, HASATTR_PAINTEXT );
//STRIP001 			pDoc->DeleteAreaTab( aWorkRange, IDF_ALL );
//STRIP001 			pUndoDoc->CopyToDocument( aWorkRange, IDF_ALL, FALSE, pDoc );
//STRIP001 
//STRIP001 			pDoc->ExtendMerge( aWorkRange, TRUE );
//STRIP001 			pDocShell->PostPaint( aWorkRange, PAINT_GRID, (bHasLines ? SC_PF_LINES : 0) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->CellContentChanged();
//STRIP001 
//STRIP001 // Shared-Names loeschen
//STRIP001 // Falls Undo ins Dokument gespeichert
//STRIP001 // => automatisches Loeschen am Ende
//STRIP001 // umarbeiten!!
//STRIP001 
//STRIP001 	String aName = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("___SC_"));
//STRIP001 	aName += String::CreateFromInt32(nMaxSharedIndex);
//STRIP001 	aName += '_';
//STRIP001 	ScRangeName* pRangeName = pDoc->GetRangeName();
//STRIP001 	BOOL bHasFound = FALSE;
//STRIP001 	for (USHORT i = 0; i < pRangeName->GetCount(); i++)
//STRIP001 	{
//STRIP001 		ScRangeData* pRangeData = (*pRangeName)[i];
//STRIP001 		if (pRangeData)
//STRIP001 		{
//STRIP001 			String aRName;
//STRIP001 			pRangeData->GetName(aRName);
//STRIP001 			if (aRName.Search(aName) != STRING_NOTFOUND)
//STRIP001 			{
//STRIP001 				pRangeName->AtFree(i);
//STRIP001 				bHasFound = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (bHasFound)
//STRIP001 		pRangeName->SetSharedMaxIndex(pRangeName->GetSharedMaxIndex()-1);
//STRIP001 
//STRIP001 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->Undo( nStartChangeAction, nEndChangeAction );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoAutoFill::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 //!	Tabellen selektieren
//STRIP001 
//STRIP001 	USHORT nCount;
//STRIP001 	switch (eFillDir)
//STRIP001 	{
//STRIP001 		case FILL_TO_BOTTOM:
//STRIP001 			nCount = aBlockRange.aEnd.Row() - aSource.aEnd.Row();
//STRIP001 			break;
//STRIP001 		case FILL_TO_RIGHT:
//STRIP001 			nCount = aBlockRange.aEnd.Col() - aSource.aEnd.Col();
//STRIP001 			break;
//STRIP001 		case FILL_TO_TOP:
//STRIP001 			nCount = aSource.aStart.Row() - aBlockRange.aStart.Row();
//STRIP001 			break;
//STRIP001 		case FILL_TO_LEFT:
//STRIP001 			nCount = aSource.aStart.Col() - aBlockRange.aStart.Col();
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	if ( fStartValue != MAXDOUBLE )
//STRIP001 	{
//STRIP001 		USHORT nValX = (eFillDir == FILL_TO_LEFT) ? aSource.aEnd.Col() : aSource.aStart.Col();
//STRIP001 		USHORT nValY = (eFillDir == FILL_TO_TOP ) ? aSource.aEnd.Row() : aSource.aStart.Row();
//STRIP001 		USHORT nTab = aSource.aStart.Tab();
//STRIP001 		pDoc->SetValue( nValX, nValY, nTab, fStartValue );
//STRIP001 	}
//STRIP001 	pDoc->Fill( aSource.aStart.Col(), aSource.aStart.Row(),
//STRIP001 				aSource.aEnd.Col(),   aSource.aEnd.Row(),
//STRIP001 				aMarkData, nCount,
//STRIP001 				eFillDir, eFillCmd, eFillDateCmd,
//STRIP001 				fStepValue, fMaxValue );
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 
//STRIP001 	pDocShell->PostPaint( aBlockRange, PAINT_GRID );
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->CellContentChanged();
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoAutoFill::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScTabViewShell& rViewShell = *((ScTabViewTarget&)rTarget).GetViewShell();
//STRIP001 		if (eFillCmd==FILL_SIMPLE)
//STRIP001 			rViewShell.FillSimple( eFillDir, TRUE );
//STRIP001 		else
//STRIP001 			rViewShell.FillSeries( eFillDir, eFillCmd, eFillDateCmd,
//STRIP001 								   fStartValue, fStepValue, fMaxValue, TRUE );
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScUndoAutoFill::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


//============================================================================
//	class ScUndoMerge
//
//	Zellen zusammenfassen / Zusammenfassung aufheben

//----------------------------------------------------------------------------

/*N*/ ScUndoMerge::ScUndoMerge( ScDocShell* pNewDocShell,
/*N*/ 							USHORT nStartX, USHORT nStartY, USHORT nStartZ,
/*N*/ 							USHORT nEndX, USHORT nEndY, USHORT nEndZ,
/*N*/ 							BOOL bNewDoMerge, ScDocument* pNewUndoDoc )
/*N*/ 		//
/*N*/ 	:	ScSimpleUndo( pNewDocShell ),
/*N*/ 		//
/*N*/ 		aRange	( nStartX, nStartY, nStartZ, nEndX, nEndY, nEndZ ),
/*N*/ 		bDoMerge( bNewDoMerge ),
/*N*/ 		pUndoDoc( pNewUndoDoc )
/*N*/ {
/*N*/ }


//----------------------------------------------------------------------------

/*N*/ __EXPORT ScUndoMerge::~ScUndoMerge()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ }


//----------------------------------------------------------------------------

/*N*/ String __EXPORT ScUndoMerge::GetComment() const
/*N*/ {
/*N*/ 	// "Zusammenfassen" "Zusammenfassung aufheben"
/*N*/ 	return bDoMerge ?
/*N*/ 		ScGlobal::GetRscString( STR_UNDO_MERGE ) :
/*N*/ 		ScGlobal::GetRscString( STR_UNDO_REMERGE );
/*N*/ }


//----------------------------------------------------------------------------

//STRIP001 void ScUndoMerge::DoChange( const BOOL bUndo ) const
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, aRange );
//STRIP001 
//STRIP001 	if (bDoMerge == bUndo)
//STRIP001 		pDoc->RemoveMerge( aRange.aStart.Col(), aRange.aStart.Row(), aRange.aStart.Tab() );
//STRIP001 //!		pDoc->RemoveMerge( aRange.aStart );
//STRIP001 	else
//STRIP001 /*!*/	pDoc->DoMerge( aRange.aStart.Tab(),
//STRIP001 					   aRange.aStart.Col(), aRange.aStart.Row(),
//STRIP001 					   aRange.aEnd.Col(),   aRange.aEnd.Row()   );
//STRIP001 
//STRIP001 	if (pUndoDoc)
//STRIP001 		if (bUndo)
//STRIP001 		{
//STRIP001 			pDoc->DeleteAreaTab( aRange, IDF_CONTENTS );
//STRIP001 			pUndoDoc->CopyToDocument( aRange, IDF_ALL, FALSE, pDoc );
//STRIP001 		}
//STRIP001 		else
//STRIP001 /*!*/		pDoc->DoMergeContents( aRange.aStart.Tab(),
//STRIP001 								   aRange.aStart.Col(), aRange.aStart.Row(),
//STRIP001 								   aRange.aEnd.Col(),   aRange.aEnd.Row()   );
//STRIP001 
//STRIP001 	BOOL bDidPaint = FALSE;
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if ( pViewShell )
//STRIP001 	{
//STRIP001 		pViewShell->SetTabNo( aRange.aStart.Tab() );
//STRIP001 		bDidPaint = pViewShell->AdjustRowHeight( aRange.aStart.Row(), aRange.aEnd.Row() );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bDidPaint)
//STRIP001 		ScUndoUtil::PaintMore( pDocShell, aRange );
//STRIP001 
//STRIP001 	ShowTable( aRange );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoMerge::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange( TRUE );
//STRIP001 	EndUndo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoMerge::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoChange( FALSE );
//STRIP001 	EndRedo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoMerge::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScTabViewShell& rViewShell = *((ScTabViewTarget&)rTarget).GetViewShell();
//STRIP001 
//STRIP001 		if (bDoMerge)
//STRIP001 		{
//STRIP001 			BOOL bCont = FALSE;
//STRIP001 			rViewShell.MergeCells( FALSE, bCont, TRUE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rViewShell.RemoveMerge( TRUE );
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

/*N*/ BOOL __EXPORT ScUndoMerge::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }


//============================================================================
//	class ScUndoAutoFormat
//
//		Auto-Format (nur einfache Bloecke)

//----------------------------------------------------------------------------

//STRIP001 ScUndoAutoFormat::ScUndoAutoFormat( ScDocShell* pNewDocShell,
//STRIP001 						const ScRange& rRange, ScDocument* pNewUndoDoc,
//STRIP001 						const ScMarkData& rMark, BOOL bNewSize, USHORT nNewFormatNo )
//STRIP001 		//
//STRIP001 	:	ScBlockUndo( pNewDocShell, rRange, bNewSize ? SC_UNDO_MANUALHEIGHT : SC_UNDO_AUTOHEIGHT ),
//STRIP001 		//
//STRIP001 		aMarkData	( rMark ),
//STRIP001 		pUndoDoc	( pNewUndoDoc ),
//STRIP001 		bSize		( bNewSize ),
//STRIP001 		nFormatNo	( nNewFormatNo )
//STRIP001 {
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScUndoAutoFormat::~ScUndoAutoFormat()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 String __EXPORT ScUndoAutoFormat::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_AUTOFORMAT );	//"Auto-Format"
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoAutoFormat::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	// Attribute
//STRIP001 //	pDoc->DeleteAreaTab( aBlockRange, IDF_ATTRIB );
//STRIP001 //	pUndoDoc->CopyToDocument( aBlockRange, IDF_ATTRIB, FALSE, pDoc );
//STRIP001 
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	pDoc->DeleteArea( aBlockRange.aStart.Col(), aBlockRange.aStart.Row(),
//STRIP001 					  aBlockRange.aEnd.Col(), aBlockRange.aEnd.Row(),
//STRIP001 					  aMarkData, IDF_ATTRIB );
//STRIP001 	ScRange aCopyRange = aBlockRange;
//STRIP001 	aCopyRange.aStart.SetTab(0);
//STRIP001 	aCopyRange.aEnd.SetTab(nTabCount-1);
//STRIP001 	pUndoDoc->CopyToDocument( aCopyRange, IDF_ATTRIB, FALSE, pDoc, &aMarkData );
//STRIP001 
//STRIP001 	// Zellhoehen und -breiten (IDF_NONE)
//STRIP001 	if (bSize)
//STRIP001 	{
//STRIP001 		USHORT nStartX = aBlockRange.aStart.Col();
//STRIP001 		USHORT nStartY = aBlockRange.aStart.Row();
//STRIP001 		USHORT nStartZ = aBlockRange.aStart.Tab();
//STRIP001 		USHORT nEndX = aBlockRange.aEnd.Col();
//STRIP001 		USHORT nEndY = aBlockRange.aEnd.Row();
//STRIP001 		USHORT nEndZ = aBlockRange.aEnd.Tab();
//STRIP001 
//STRIP001 		pUndoDoc->CopyToDocument( nStartX, 0, 0, nEndX, MAXROW, nTabCount-1,
//STRIP001 									IDF_NONE, FALSE, pDoc, &aMarkData );
//STRIP001 		pUndoDoc->CopyToDocument( 0, nStartY, 0, MAXCOL, nEndY, nTabCount-1,
//STRIP001 									IDF_NONE, FALSE, pDoc, &aMarkData );
//STRIP001 		pDocShell->PostPaint( 0, 0, nStartZ, MAXCOL, MAXROW, nEndZ,
//STRIP001 							  PAINT_GRID | PAINT_LEFT | PAINT_TOP, SC_PF_LINES );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pDocShell->PostPaint( aBlockRange, PAINT_GRID, SC_PF_LINES );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoAutoFormat::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	USHORT nStartX = aBlockRange.aStart.Col();
//STRIP001 	USHORT nStartY = aBlockRange.aStart.Row();
//STRIP001 	USHORT nStartZ = aBlockRange.aStart.Tab();
//STRIP001 	USHORT nEndX = aBlockRange.aEnd.Col();
//STRIP001 	USHORT nEndY = aBlockRange.aEnd.Row();
//STRIP001 	USHORT nEndZ = aBlockRange.aEnd.Tab();
//STRIP001 
//STRIP001 	pDoc->AutoFormat( nStartX, nStartY, nEndX, nEndY, nFormatNo, aMarkData );
//STRIP001 
//STRIP001 	if (bSize)
//STRIP001 	{
//STRIP001 		VirtualDevice aVirtDev;
//STRIP001 		Fraction aZoomX(1,1);
//STRIP001 		Fraction aZoomY = aZoomX;
//STRIP001 		double nPPTX,nPPTY;
//STRIP001 		ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 		if (pViewShell)
//STRIP001 		{
//STRIP001 			ScViewData* pData = pViewShell->GetViewData();
//STRIP001 			nPPTX = pData->GetPPTX();
//STRIP001 			nPPTY = pData->GetPPTY();
//STRIP001 			aZoomX = pData->GetZoomX();
//STRIP001 			aZoomY = pData->GetZoomY();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//	Zoom auf 100 lassen
//STRIP001 			nPPTX = ScGlobal::nScreenPPTX;
//STRIP001 			nPPTY = ScGlobal::nScreenPPTY;
//STRIP001 		}
//STRIP001 
//STRIP001 		BOOL bFormula = FALSE;	//! merken
//STRIP001 
//STRIP001 		for (USHORT nTab=nStartZ; nTab<=nEndZ; nTab++)
//STRIP001 		{
//STRIP001 			ScMarkData aDestMark;
//STRIP001 			aDestMark.SelectOneTable( nTab );
//STRIP001 			aDestMark.SetMarkArea( ScRange( nStartX, nStartY, nTab, nEndX, nEndY, nTab ) );
//STRIP001 			aDestMark.MarkToMulti();
//STRIP001 
//STRIP001 			// wie SC_SIZE_VISOPT
//STRIP001 			for (USHORT nRow=nStartY; nRow<=nEndY; nRow++)
//STRIP001 			{
//STRIP001 				BYTE nOld = pDoc->GetRowFlags(nRow,nTab);
//STRIP001 				if ( (nOld & CR_HIDDEN) == 0 && ( nOld & CR_MANUALSIZE ) )
//STRIP001 					pDoc->SetRowFlags( nRow, nTab, nOld & ~CR_MANUALSIZE );
//STRIP001 			}
//STRIP001 			pDoc->SetOptimalHeight( nStartY, nEndY, nTab, 0, &aVirtDev,
//STRIP001 										nPPTX, nPPTY, aZoomX, aZoomY, FALSE );
//STRIP001 
//STRIP001 			for (USHORT nCol=nStartX; nCol<=nEndX; nCol++)
//STRIP001 				if ((pDoc->GetColFlags( nCol, nTab ) & CR_HIDDEN) == 0)
//STRIP001 				{
//STRIP001 					USHORT nThisSize = STD_EXTRA_WIDTH + pDoc->GetOptimalColWidth( nCol, nTab,
//STRIP001 												&aVirtDev, nPPTX, nPPTY, aZoomX, aZoomY, bFormula,
//STRIP001 												&aDestMark );
//STRIP001 					pDoc->SetColWidth( nCol, nTab, nThisSize );
//STRIP001 					pDoc->ShowCol( nCol, nTab, TRUE );
//STRIP001 				}
//STRIP001 		}
//STRIP001 
//STRIP001 		pDocShell->PostPaint( 0,      0,      nStartZ,
//STRIP001 							  MAXCOL, MAXROW, nEndZ,
//STRIP001 							  PAINT_GRID | PAINT_LEFT | PAINT_TOP, SC_PF_LINES);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pDocShell->PostPaint( aBlockRange, PAINT_GRID, SC_PF_LINES );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoAutoFormat::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->AutoFormat( nFormatNo, TRUE );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScUndoAutoFormat::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


//============================================================================
//	class ScUndoReplace
//
//		Ersetzen

//----------------------------------------------------------------------------

/*N*/ ScUndoReplace::ScUndoReplace( ScDocShell* pNewDocShell, const ScMarkData& rMark,
/*N*/ 									USHORT nCurX, USHORT nCurY, USHORT nCurZ,
/*N*/ 									const String& rNewUndoStr, ScDocument* pNewUndoDoc,
/*N*/ 									const SvxSearchItem* pItem )
/*N*/ 		//
/*N*/ 	:	ScSimpleUndo( pNewDocShell ),
/*N*/ 		//
/*N*/ 		aMarkData	( rMark ),
/*N*/ 		aCursorPos	( nCurX, nCurY, nCurZ ),
/*N*/ 		aUndoStr	( rNewUndoStr ),
/*N*/ 		pUndoDoc	( pNewUndoDoc )
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pSearchItem = new SvxSearchItem( *pItem );
//STRIP001 /*?*/ 	SetChangeTrack();
/*N*/ }


//----------------------------------------------------------------------------

/*N*/ __EXPORT ScUndoReplace::~ScUndoReplace()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ 	delete pSearchItem;
/*N*/ }


//----------------------------------------------------------------------------

//STRIP001 void ScUndoReplace::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 	{
//STRIP001 		if ( pUndoDoc )
//STRIP001 		{	//! im UndoDoc stehen nur die geaenderten Zellen,
//STRIP001 			// deswegen per Iterator moeglich
//STRIP001 			pChangeTrack->AppendContentsIfInRefDoc( pUndoDoc,
//STRIP001 				nStartChangeAction,	nEndChangeAction );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nStartChangeAction = pChangeTrack->GetActionMax() + 1;
//STRIP001 			ScAddress aPos( aCursorPos.GetCol(), aCursorPos.GetRow(),
//STRIP001 				aCursorPos.GetTab() );
//STRIP001 			ScChangeActionContent* pContent = new ScChangeActionContent(
//STRIP001 				ScRange( aPos, aPos ) );
//STRIP001 			pContent->SetOldValue( aUndoStr, pDoc );
//STRIP001 			pContent->SetNewValue( pDoc->GetCell( aPos ), pDoc );
//STRIP001 			pChangeTrack->Append( pContent );
//STRIP001 			nEndChangeAction = pChangeTrack->GetActionMax();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nStartChangeAction = nEndChangeAction = 0;
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 String __EXPORT ScUndoReplace::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_REPLACE );	// "Ersetzen"
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoReplace::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	ShowTable( aCursorPos.GetTab() );
//STRIP001 
//STRIP001 	if (pUndoDoc)		// nur bei ReplaceAll !!
//STRIP001 	{
//STRIP001 		DBG_ASSERT(pSearchItem->GetCommand() == SVX_SEARCHCMD_REPLACE_ALL,
//STRIP001 				   "ScUndoReplace:: Falscher Modus");
//STRIP001 
//STRIP001 		if (pViewShell)
//STRIP001 		{
//STRIP001 			pViewShell->DoneBlockMode();
//STRIP001 			pViewShell->InitOwnBlockMode();
//STRIP001 			pViewShell->GetViewData()->GetMarkData() = aMarkData;	// CopyMarksTo
//STRIP001 		}
//STRIP001 
//STRIP001 //!	markierte Tabellen
//STRIP001 //!	Bereich merken ?
//STRIP001 
//STRIP001 		//	Undo-Dokument hat keine Zeilen-/Spalten-Infos, also mit bColRowFlags = FALSE
//STRIP001 		//	kopieren, um Outline-Gruppen nicht kaputtzumachen.
//STRIP001 
//STRIP001 		USHORT nUndoFlags = (pSearchItem->GetPattern()) ? IDF_ATTRIB : IDF_CONTENTS;
//STRIP001 		pUndoDoc->CopyToDocument( 0,      0,      0,
//STRIP001 								  MAXCOL, MAXROW, MAXTAB,
//STRIP001 								  nUndoFlags, FALSE, pDoc, NULL, FALSE );	// ohne Row-Flags
//STRIP001 		pDocShell->PostPaintGridAll();
//STRIP001 	}
//STRIP001 	else if (pSearchItem->GetPattern() &&
//STRIP001 			 pSearchItem->GetCommand() == SVX_SEARCHCMD_REPLACE)
//STRIP001 	{
//STRIP001 		String aTempStr = pSearchItem->GetSearchString();		// vertauschen
//STRIP001 		pSearchItem->SetSearchString(pSearchItem->GetReplaceString());
//STRIP001 		pSearchItem->SetReplaceString(aTempStr);
//STRIP001 		pDoc->ReplaceStyle( *pSearchItem,
//STRIP001 							aCursorPos.GetCol(), aCursorPos.GetRow(), aCursorPos.GetTab(),
//STRIP001 							aMarkData, TRUE);
//STRIP001 		pSearchItem->SetReplaceString(pSearchItem->GetSearchString());
//STRIP001 		pSearchItem->SetSearchString(aTempStr);
//STRIP001 		if (pViewShell)
//STRIP001 			pViewShell->MoveCursorAbs( aCursorPos.GetCol(), aCursorPos.GetRow(),
//STRIP001 									   SC_FOLLOW_JUMP, FALSE, FALSE );
//STRIP001 		pDocShell->PostPaintGridAll();
//STRIP001 	}
//STRIP001 	else if (pSearchItem->GetCellType() == SVX_SEARCHIN_NOTE)
//STRIP001 	{
//STRIP001 		ScPostIt aNote;
//STRIP001 		if (pDoc->GetNote(aCursorPos.GetCol(), aCursorPos.GetRow(),
//STRIP001 						  aCursorPos.GetTab(), aNote))
//STRIP001 		{
//STRIP001 			aNote.SetText(aUndoStr);
//STRIP001 			pDoc->SetNote(aCursorPos.GetCol(), aCursorPos.GetRow(),
//STRIP001 						  aCursorPos.GetTab(), aNote);
//STRIP001 		}
//STRIP001 		else
//STRIP001 			DBG_ERROR("ScUndoReplace: Hier ist keine Notizzelle");
//STRIP001 		if (pViewShell)
//STRIP001 			pViewShell->MoveCursorAbs( aCursorPos.GetCol(), aCursorPos.GetRow(),
//STRIP001 									   SC_FOLLOW_JUMP, FALSE, FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// #78889# aUndoStr may contain line breaks
//STRIP001 		if ( aUndoStr.Search('\n') != STRING_NOTFOUND )
//STRIP001 			pDoc->PutCell( aCursorPos.GetCol(), aCursorPos.GetRow(), aCursorPos.GetTab(),
//STRIP001 							new ScEditCell( aUndoStr, pDoc ) );
//STRIP001 		else
//STRIP001 			pDoc->SetString( aCursorPos.GetCol(), aCursorPos.GetRow(), aCursorPos.GetTab(), aUndoStr );
//STRIP001 		if (pViewShell)
//STRIP001 			pViewShell->MoveCursorAbs( aCursorPos.GetCol(), aCursorPos.GetRow(),
//STRIP001 									   SC_FOLLOW_JUMP, FALSE, FALSE );
//STRIP001 		pDocShell->PostPaintGridAll();
//STRIP001 	}
//STRIP001 
//STRIP001 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->Undo( nStartChangeAction, nEndChangeAction );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoReplace::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->MoveCursorAbs( aCursorPos.GetCol(), aCursorPos.GetRow(),
//STRIP001 								   SC_FOLLOW_JUMP, FALSE, FALSE );
//STRIP001 	if (pUndoDoc)
//STRIP001 	{
//STRIP001 		if (pViewShell)
//STRIP001 		{
//STRIP001 			pViewShell->DoneBlockMode();
//STRIP001 			pViewShell->InitOwnBlockMode();
//STRIP001 			pViewShell->GetViewData()->GetMarkData() = aMarkData;	// CopyMarksTo
//STRIP001 
//STRIP001 			pViewShell->SearchAndReplace( pSearchItem, FALSE, TRUE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if (pSearchItem->GetPattern() &&
//STRIP001 			 pSearchItem->GetCommand() == SVX_SEARCHCMD_REPLACE)
//STRIP001 	{
//STRIP001 		pDoc->ReplaceStyle( *pSearchItem,
//STRIP001 							aCursorPos.GetCol(), aCursorPos.GetRow(), aCursorPos.GetTab(),
//STRIP001 							aMarkData, TRUE);
//STRIP001 		pDocShell->PostPaintGridAll();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		if (pViewShell)
//STRIP001 			pViewShell->SearchAndReplace( pSearchItem, FALSE, TRUE );
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoReplace::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->SearchAndReplace( pSearchItem, TRUE, FALSE );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScUndoReplace::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


//============================================================================
//	class ScUndoTabOp
//
//	Mehrfachoperation (nur einfache Bloecke)

//----------------------------------------------------------------------------

//STRIP001 ScUndoTabOp::ScUndoTabOp( ScDocShell* pNewDocShell,
//STRIP001 				USHORT nStartX, USHORT nStartY, USHORT nStartZ,
//STRIP001 				USHORT nEndX, USHORT nEndY, USHORT nEndZ, ScDocument* pNewUndoDoc,
//STRIP001 				const ScRefTripel& rFormulaCell,
//STRIP001 				const ScRefTripel& rFormulaEnd,
//STRIP001 				const ScRefTripel& rRowCell,
//STRIP001 				const ScRefTripel& rColCell,
//STRIP001 				BYTE nMd )
//STRIP001 		//
//STRIP001 	:	ScSimpleUndo( pNewDocShell ),
//STRIP001 		//
//STRIP001 		aRange			( nStartX, nStartY, nStartZ, nEndX, nEndY, nEndZ ),
//STRIP001 		pUndoDoc		( pNewUndoDoc ),
//STRIP001 		theFormulaCell	( rFormulaCell ),
//STRIP001 		theFormulaEnd	( rFormulaEnd ),
//STRIP001 		theRowCell		( rRowCell ),
//STRIP001 		theColCell		( rColCell ),
//STRIP001 		nMode			( nMd )
//STRIP001 {
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScUndoTabOp::~ScUndoTabOp()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 String __EXPORT ScUndoTabOp::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_TABOP );	// "Mehrfachoperation"
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoTabOp::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, aRange );
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	BOOL bHasLines = pDoc->HasAttrib( aRange, HASATTR_PAINTEXT );
//STRIP001 
//STRIP001 	pDoc->DeleteAreaTab( aRange,IDF_ALL );
//STRIP001 	pUndoDoc->CopyToDocument( aRange, IDF_ALL, FALSE, pDoc );
//STRIP001 	pDocShell->PostPaint( aRange, PAINT_GRID, (bHasLines ? SC_PF_LINES : 0) );
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->CellContentChanged();
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoTabOp::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, aRange );
//STRIP001 
//STRIP001 	ScTabOpParam aParam( theFormulaCell, theFormulaEnd,
//STRIP001 						 theRowCell,     theColCell,
//STRIP001 						 nMode );
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->TabOp( aParam, FALSE);
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoTabOp::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScUndoTabOp::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }


//============================================================================
//	class ScUndoSpelling
//
//	Spelling

//----------------------------------------------------------------------------

//STRIP001 ScUndoSpelling::ScUndoSpelling( ScDocShell* pNewDocShell,
//STRIP001 								const ScMarkData& rMark,
//STRIP001 								USHORT nCurX, USHORT nCurY, USHORT nCurZ,
//STRIP001 								ScDocument* pNewUndoDoc,
//STRIP001 								USHORT nNewX, USHORT nNewY, USHORT nNewZ,
//STRIP001 								ScDocument* pNewRedoDoc)
//STRIP001 		//
//STRIP001 	:	ScSimpleUndo( pNewDocShell ),
//STRIP001 		//
//STRIP001 		aMarkData		( rMark ),
//STRIP001 		aCursorPos		( nCurX, nCurY, nCurZ ),
//STRIP001 		aNewCursorPos	( nNewX, nNewY, nNewZ ),
//STRIP001 		pUndoDoc		( pNewUndoDoc ),
//STRIP001 		pRedoDoc		( pNewRedoDoc )
//STRIP001 {
//STRIP001 	SetChangeTrack();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScUndoSpelling::~ScUndoSpelling()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	delete pRedoDoc;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScUndoSpelling::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 	{
//STRIP001 		if ( pUndoDoc )
//STRIP001 			pChangeTrack->AppendContentsIfInRefDoc( pUndoDoc,
//STRIP001 				nStartChangeAction, nEndChangeAction );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			DBG_ERROR( "ScUndoSpelling::SetChangeTrack: kein UndoDoc" );
//STRIP001 			nStartChangeAction = nEndChangeAction = 0;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nStartChangeAction = nEndChangeAction = 0;
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 String __EXPORT ScUndoSpelling::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_SPELLING);	// "Rechtschreibung"
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScUndoSpelling::DoChange( ScDocument* pRefDoc, const ScTripel& rCursorPos )
//STRIP001 {
//STRIP001 	if (pRefDoc)
//STRIP001 	{
//STRIP001 		ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 		ShowTable( rCursorPos.GetTab() );
//STRIP001 
//STRIP001 		ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 		if (pViewShell)
//STRIP001 		{
//STRIP001 			pViewShell->DoneBlockMode();
//STRIP001 			pViewShell->InitOwnBlockMode();
//STRIP001 			pViewShell->GetViewData()->GetMarkData() = aMarkData;	// CopyMarksTo
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 		//	Undo/Redo-doc has only selected tables
//STRIP001 
//STRIP001 		BOOL bMulti = aMarkData.IsMultiMarked();
//STRIP001 		pRefDoc->CopyToDocument( 0,      0,      0,
//STRIP001 								 MAXCOL, MAXROW, nTabCount-1,
//STRIP001 								 IDF_CONTENTS, bMulti, pDoc, &aMarkData );
//STRIP001 		pDocShell->PostPaintGridAll();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ERROR("Kein Un-/RedoDoc bei Un-/RedoSpelling");
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoSpelling::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange( pUndoDoc, aCursorPos );
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->Undo( nStartChangeAction, nEndChangeAction );
//STRIP001 	EndUndo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoSpelling::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoChange( pRedoDoc, aNewCursorPos );
//STRIP001 	SetChangeTrack();
//STRIP001 	EndRedo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoSpelling::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->DoSpellingChecker( TRUE );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScUndoSpelling::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


//============================================================================
//	class ScUndoRefreshLink
//
//	Link aktualisieren / aendern

//----------------------------------------------------------------------------

/*N*/ ScUndoRefreshLink::ScUndoRefreshLink( ScDocShell* pNewDocShell,
/*N*/ 									ScDocument* pNewUndoDoc )
/*N*/ 		//
/*N*/ 	:	ScSimpleUndo( pNewDocShell ),
/*N*/ 		//
/*N*/ 		pUndoDoc( pNewUndoDoc ),
/*N*/ 		pRedoDoc( NULL )
/*N*/ {
/*N*/ 	ScDocument* pDoc = pDocShell->GetDocument();
/*N*/ }


//----------------------------------------------------------------------------

/*N*/ __EXPORT ScUndoRefreshLink::~ScUndoRefreshLink()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ 	delete pRedoDoc;
/*N*/ }


//----------------------------------------------------------------------------

//STRIP001 String __EXPORT ScUndoRefreshLink::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_UPDATELINK );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoRefreshLink::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	BOOL bMakeRedo = !pRedoDoc;
//STRIP001 	if (bMakeRedo)
//STRIP001 		pRedoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 
//STRIP001 	BOOL bFirst = TRUE;
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	USHORT nCount = pDoc->GetTableCount();
//STRIP001 	for (USHORT nTab=0; nTab<nCount; nTab++)
//STRIP001 		if (pUndoDoc->HasTable(nTab))
//STRIP001 		{
//STRIP001 			ScRange aRange(0,0,nTab,MAXCOL,MAXROW,nTab);
//STRIP001 			if (bMakeRedo)
//STRIP001 			{
//STRIP001 				if (bFirst)
//STRIP001 					pRedoDoc->InitUndo( pDoc, nTab, nTab, TRUE, TRUE );
//STRIP001 				else
//STRIP001 					pRedoDoc->AddUndoTab( nTab, nTab, TRUE, TRUE );
//STRIP001 				bFirst = FALSE;
//STRIP001 				pDoc->CopyToDocument(aRange, IDF_ALL, FALSE, pRedoDoc);
//STRIP001 //				pRedoDoc->TransferDrawPage( pDoc, nTab, nTab );
//STRIP001 				pRedoDoc->SetLink( nTab,
//STRIP001 								   pDoc->GetLinkMode(nTab),
//STRIP001 								   pDoc->GetLinkDoc(nTab),
//STRIP001 								   pDoc->GetLinkFlt(nTab),
//STRIP001 								   pDoc->GetLinkOpt(nTab),
//STRIP001 								   pDoc->GetLinkTab(nTab),
//STRIP001 								   pDoc->GetLinkRefreshDelay(nTab) );
//STRIP001 			}
//STRIP001 
//STRIP001 			pDoc->DeleteAreaTab( aRange,IDF_ALL );
//STRIP001 //			pDoc->ClearDrawPage(nTab);
//STRIP001 			pUndoDoc->CopyToDocument( aRange, IDF_ALL, FALSE, pDoc );
//STRIP001 //			pDoc->TransferDrawPage( pUndoDoc, nTab, nTab );
//STRIP001 			pDoc->SetLink( nTab, pUndoDoc->GetLinkMode(nTab), pUndoDoc->GetLinkDoc(nTab),
//STRIP001 								 pUndoDoc->GetLinkFlt(nTab),  pUndoDoc->GetLinkOpt(nTab),
//STRIP001 								 pUndoDoc->GetLinkTab(nTab),
//STRIP001 								 pUndoDoc->GetLinkRefreshDelay(nTab) );
//STRIP001 		}
//STRIP001 
//STRIP001 	pDocShell->PostPaintGridAll();
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoRefreshLink::Redo()
//STRIP001 {
//STRIP001 	DBG_ASSERT(pRedoDoc, "Kein RedoDoc bei ScUndoRefreshLink::Redo");
//STRIP001 
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	USHORT nCount = pDoc->GetTableCount();
//STRIP001 	for (USHORT nTab=0; nTab<nCount; nTab++)
//STRIP001 		if (pRedoDoc->HasTable(nTab))
//STRIP001 		{
//STRIP001 			ScRange aRange(0,0,nTab,MAXCOL,MAXROW,nTab);
//STRIP001 
//STRIP001 			pDoc->DeleteAreaTab( aRange, IDF_ALL );
//STRIP001 //			pDoc->ClearDrawPage(nTab);
//STRIP001 			pRedoDoc->CopyToDocument( aRange, IDF_ALL, FALSE, pDoc );
//STRIP001 //			pDoc->TransferDrawPage( pRedoDoc, nTab, nTab );
//STRIP001 			pDoc->SetLink( nTab,
//STRIP001 						   pRedoDoc->GetLinkMode(nTab),
//STRIP001 						   pRedoDoc->GetLinkDoc(nTab),
//STRIP001 						   pRedoDoc->GetLinkFlt(nTab),
//STRIP001 						   pRedoDoc->GetLinkOpt(nTab),
//STRIP001 						   pRedoDoc->GetLinkTab(nTab),
//STRIP001 						   pRedoDoc->GetLinkRefreshDelay(nTab) );
//STRIP001 		}
//STRIP001 
//STRIP001 	pDocShell->PostPaintGridAll();
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoRefreshLink::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	gippsnich
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScUndoRefreshLink::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 ScAreaLink* lcl_FindAreaLink( SvxLinkManager* pLinkManager, const String& rDoc,
//STRIP001 							const String& rFlt, const String& rOpt,
//STRIP001 							const String& rSrc, const ScRange& rDest )
//STRIP001 {
//STRIP001 	const ::so3::SvBaseLinks& rLinks = pLinkManager->GetLinks();
//STRIP001 	USHORT nCount = pLinkManager->GetLinks().Count();
//STRIP001 	for (USHORT i=0; i<nCount; i++)
//STRIP001 	{
//STRIP001 		::so3::SvBaseLink* pBase = *rLinks[i];
//STRIP001 		if (pBase->ISA(ScAreaLink))
//STRIP001 			if ( ((ScAreaLink*)pBase)->IsEqual( rDoc, rFlt, rOpt, rSrc, rDest ) )
//STRIP001 				return (ScAreaLink*)pBase;
//STRIP001 	}
//STRIP001 
//STRIP001 	DBG_ERROR("ScAreaLink nicht gefunden");
//STRIP001 	return NULL;
//STRIP001 }


//============================================================================
//	class ScUndoInsertAreaLink
//
//	Bereichs-Verknuepfung einfuegen

//----------------------------------------------------------------------------

//STRIP001 ScUndoInsertAreaLink::ScUndoInsertAreaLink( ScDocShell* pShell,
//STRIP001 							const String& rDoc,
//STRIP001 							const String& rFlt, const String& rOpt,
//STRIP001 							const String& rArea, const ScRange& rDestRange,
//STRIP001 							ULONG nRefresh )
//STRIP001 		//
//STRIP001 	:	ScSimpleUndo	( pShell ),
//STRIP001 		//
//STRIP001 		aDocName		( rDoc ),
//STRIP001 		aFltName		( rFlt ),
//STRIP001 		aOptions		( rOpt ),
//STRIP001 		aAreaName		( rArea ),
//STRIP001 		aRange			( rDestRange ),
//STRIP001 		nRefreshDelay	( nRefresh )
//STRIP001 {
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScUndoInsertAreaLink::~ScUndoInsertAreaLink()
//STRIP001 {
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 String __EXPORT ScUndoInsertAreaLink::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_INSERTAREALINK );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoInsertAreaLink::Undo()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	SvxLinkManager* pLinkManager = pDoc->GetLinkManager();
//STRIP001 
//STRIP001 	ScAreaLink* pLink = lcl_FindAreaLink( pLinkManager, aDocName, aFltName, aOptions,
//STRIP001 											aAreaName, aRange );
//STRIP001 	if (pLink)
//STRIP001 		pLinkManager->Remove( pLink );
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_AREALINKS_CHANGED ) );		// Navigator
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoInsertAreaLink::Redo()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	SvxLinkManager* pLinkManager = pDoc->GetLinkManager();
//STRIP001 
//STRIP001 	ScAreaLink* pLink = new ScAreaLink( pDocShell, aDocName, aFltName, aOptions,
//STRIP001 											aAreaName, aRange.aStart, nRefreshDelay );
//STRIP001 	pLink->SetInCreate( TRUE );
//STRIP001 	pLink->SetDestArea( aRange );
//STRIP001 	pLinkManager->InsertFileLink( *pLink, OBJECT_CLIENT_FILE, aDocName, &aFltName, &aAreaName );
//STRIP001 	pLink->Update();
//STRIP001 	pLink->SetInCreate( FALSE );
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_AREALINKS_CHANGED ) );		// Navigator
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoInsertAreaLink::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//!	....
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScUndoInsertAreaLink::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }


//============================================================================
//	class ScUndoRemoveAreaLink
//
//	Bereichs-Verknuepfung loeschen

//----------------------------------------------------------------------------

//STRIP001 ScUndoRemoveAreaLink::ScUndoRemoveAreaLink( ScDocShell* pShell,
//STRIP001 							const String& rDoc, const String& rFlt, const String& rOpt,
//STRIP001 							const String& rArea, const ScRange& rDestRange,
//STRIP001 							ULONG nRefresh )
//STRIP001 		//
//STRIP001 	:	ScSimpleUndo	( pShell ),
//STRIP001 		//
//STRIP001 		aDocName		( rDoc ),
//STRIP001 		aFltName		( rFlt ),
//STRIP001 		aOptions		( rOpt ),
//STRIP001 		aAreaName		( rArea ),
//STRIP001 		aRange			( rDestRange ),
//STRIP001 		nRefreshDelay	( nRefresh )
//STRIP001 {
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScUndoRemoveAreaLink::~ScUndoRemoveAreaLink()
//STRIP001 {
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 String __EXPORT ScUndoRemoveAreaLink::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_REMOVELINK );	//! eigener Text ??
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoRemoveAreaLink::Undo()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	SvxLinkManager* pLinkManager = pDoc->GetLinkManager();
//STRIP001 
//STRIP001 	ScAreaLink* pLink = new ScAreaLink( pDocShell, aDocName, aFltName, aOptions,
//STRIP001 										aAreaName, aRange.aStart, nRefreshDelay );
//STRIP001 	pLink->SetInCreate( TRUE );
//STRIP001 	pLink->SetDestArea( aRange );
//STRIP001 	pLinkManager->InsertFileLink( *pLink, OBJECT_CLIENT_FILE, aDocName, &aFltName, &aAreaName );
//STRIP001 	pLink->Update();
//STRIP001 	pLink->SetInCreate( FALSE );
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_AREALINKS_CHANGED ) );		// Navigator
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoRemoveAreaLink::Redo()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	SvxLinkManager* pLinkManager = pDoc->GetLinkManager();
//STRIP001 
//STRIP001 	ScAreaLink* pLink = lcl_FindAreaLink( pLinkManager, aDocName, aFltName, aOptions,
//STRIP001 											aAreaName, aRange );
//STRIP001 	if (pLink)
//STRIP001 		pLinkManager->Remove( pLink );
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_AREALINKS_CHANGED ) );		// Navigator
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoRemoveAreaLink::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	gippsnich
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScUndoRemoveAreaLink::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }


//============================================================================
//	class ScUndoUpdateAreaLink
//
//	Bereichs-Verknuepfung aktualisieren

//----------------------------------------------------------------------------

//STRIP001 ScUndoUpdateAreaLink::ScUndoUpdateAreaLink( ScDocShell* pShell,
//STRIP001 							const String& rOldD, const String& rOldF, const String& rOldO,
//STRIP001 							const String& rOldA, const ScRange& rOldR, ULONG nOldRD,
//STRIP001 							const String& rNewD, const String& rNewF, const String& rNewO,
//STRIP001 							const String& rNewA, const ScRange& rNewR, ULONG nNewRD,
//STRIP001 							ScDocument* pUndo, ScDocument* pRedo, BOOL bDoInsert )
//STRIP001 		//
//STRIP001 	:	ScSimpleUndo( pShell ),
//STRIP001 		//
//STRIP001 		aOldDoc		( rOldD ),
//STRIP001 		aOldFlt		( rOldF ),
//STRIP001 		aOldOpt		( rOldO ),
//STRIP001 		aOldArea	( rOldA ),
//STRIP001 		aOldRange	( rOldR ),
//STRIP001 		aNewDoc		( rNewD ),
//STRIP001 		aNewFlt		( rNewF ),
//STRIP001 		aNewOpt		( rNewO ),
//STRIP001 		aNewArea	( rNewA ),
//STRIP001 		aNewRange	( rNewR ),
//STRIP001 		pUndoDoc	( pUndo ),
//STRIP001 		pRedoDoc	( pRedo ),
//STRIP001 		nOldRefresh	( nOldRD ),
//STRIP001 		nNewRefresh	( nNewRD ),
//STRIP001 		bWithInsert	( bDoInsert )
//STRIP001 {
//STRIP001 	DBG_ASSERT( aOldRange.aStart == aNewRange.aStart, "AreaLink verschoben ??!??" );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScUndoUpdateAreaLink::~ScUndoUpdateAreaLink()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	delete pRedoDoc;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 String __EXPORT ScUndoUpdateAreaLink::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_UPDATELINK );	//! eigener Text ??
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScUndoUpdateAreaLink::DoChange( const BOOL bUndo ) const
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	USHORT nEndX = Max( aOldRange.aEnd.Col(), aNewRange.aEnd.Col() );
//STRIP001 	USHORT nEndY = Max( aOldRange.aEnd.Row(), aNewRange.aEnd.Row() );
//STRIP001 	USHORT nEndZ = Max( aOldRange.aEnd.Tab(), aNewRange.aEnd.Tab() );	//?
//STRIP001 
//STRIP001 	if ( bUndo )
//STRIP001 	{
//STRIP001 		if ( bWithInsert )
//STRIP001 		{
//STRIP001 			pDoc->FitBlock( aNewRange, aOldRange );
//STRIP001 			pDoc->DeleteAreaTab( aOldRange, IDF_ALL );
//STRIP001 			pUndoDoc->UndoToDocument( aOldRange, IDF_ALL, FALSE, pDoc );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ScRange aCopyRange( aOldRange.aStart, ScAddress(nEndX,nEndY,nEndZ) );
//STRIP001 			pDoc->DeleteAreaTab( aCopyRange, IDF_ALL );
//STRIP001 			pUndoDoc->CopyToDocument( aCopyRange, IDF_ALL, FALSE, pDoc );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( bWithInsert )
//STRIP001 		{
//STRIP001 			pDoc->FitBlock( aOldRange, aNewRange );
//STRIP001 			pDoc->DeleteAreaTab( aNewRange, IDF_ALL );
//STRIP001 			pRedoDoc->CopyToDocument( aNewRange, IDF_ALL, FALSE, pDoc );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ScRange aCopyRange( aOldRange.aStart, ScAddress(nEndX,nEndY,nEndZ) );
//STRIP001 			pDoc->DeleteAreaTab( aCopyRange, IDF_ALL );
//STRIP001 			pRedoDoc->CopyToDocument( aCopyRange, IDF_ALL, FALSE, pDoc );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ScRange aWorkRange( aNewRange.aStart, ScTripel( nEndX, nEndY, nEndZ ) );
//STRIP001 	pDoc->ExtendMerge( aWorkRange, TRUE );
//STRIP001 
//STRIP001 	//	Paint
//STRIP001 
//STRIP001 	if ( aNewRange.aEnd.Col() != aOldRange.aEnd.Col() )
//STRIP001 		aWorkRange.aEnd.SetCol(MAXCOL);
//STRIP001 	if ( aNewRange.aEnd.Row() != aOldRange.aEnd.Row() )
//STRIP001 		aWorkRange.aEnd.SetRow(MAXROW);
//STRIP001 
//STRIP001 	if ( !pDocShell->AdjustRowHeight( aWorkRange.aStart.Row(), aWorkRange.aEnd.Row(), aWorkRange.aStart.Tab() ) )
//STRIP001 		pDocShell->PostPaint( aWorkRange, PAINT_GRID );
//STRIP001 
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->CellContentChanged();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoUpdateAreaLink::Undo()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	SvxLinkManager* pLinkManager = pDoc->GetLinkManager();
//STRIP001 	ScAreaLink* pLink = lcl_FindAreaLink( pLinkManager, aNewDoc, aNewFlt, aNewOpt,
//STRIP001 											aNewArea, aNewRange );
//STRIP001 	if (pLink)
//STRIP001 	{
//STRIP001 		pLink->SetSource( aOldDoc, aOldFlt, aOldOpt, aOldArea );		// alte Werte im Link
//STRIP001 		pLink->SetDestArea( aOldRange );
//STRIP001 		pLink->SetRefreshDelay( nOldRefresh );
//STRIP001 	}
//STRIP001 
//STRIP001 	DoChange(TRUE);
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoUpdateAreaLink::Redo()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	SvxLinkManager* pLinkManager = pDoc->GetLinkManager();
//STRIP001 	ScAreaLink* pLink = lcl_FindAreaLink( pLinkManager, aOldDoc, aOldFlt, aOldOpt,
//STRIP001 											aOldArea, aOldRange );
//STRIP001 	if (pLink)
//STRIP001 	{
//STRIP001 		pLink->SetSource( aNewDoc, aNewFlt, aNewOpt, aNewArea );		// neue Werte im Link
//STRIP001 		pLink->SetDestArea( aNewRange );
//STRIP001 		pLink->SetRefreshDelay( nNewRefresh );
//STRIP001 	}
//STRIP001 
//STRIP001 	DoChange(FALSE);
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScUndoUpdateAreaLink::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	gippsnich
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScUndoUpdateAreaLink::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }




}
