/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_gridwin.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2006/08/14 13:46:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

//SV
//#define _CLIP_HXX
#define _CONFIG_HXX
#define _CURSOR_HXX
#define _FONTDLG_HXX
#define _PRVWIN_HXX

//svdraw.hxx
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
//#define _SDR_NOOBJECTS
//#define _SDR_NOVIEWS


// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
#define ITEMID_FIELD EE_FEATURE_FIELD

#include <bf_svx/adjitem.hxx>
// auto strip #include <bf_svx/algitem.hxx>
#include <bf_svx/dbexch.hrc>
// auto strip #include <bf_svx/editview.hxx>
// auto strip #include <bf_svx/editstat.hxx>

// auto strip #ifndef _PSTM_HXX
// auto strip #include <tools/pstm.hxx>
// auto strip #endif

// auto strip #ifndef _SFXPOOLITEM_HXX
// auto strip #include <svtools/poolitem.hxx>
// auto strip #endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif

// auto strip #include <bf_svx/flditem.hxx>
// auto strip #include <bf_svx/svdetc.hxx>
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #include <svtools/stritem.hxx>
// auto strip #include <svtools/svlbox.hxx>
#include <svtools/svtabbx.hxx>
// auto strip #include <svtools/urlbmk.hxx>
// auto strip #include <tools/urlobj.hxx>
// auto strip #include <vcl/cursor.hxx>
// auto strip #include <vcl/sound.hxx>
//#include <vcl/system.hxx>
// auto strip #include <bf_offmgr/app.hxx>
// auto strip #include <vcl/graph.hxx>
// auto strip #include <sot/formats.hxx>
// auto strip #include <sot/clsids.hxx>

// auto strip #include <bf_svx/svdview.hxx>		// fuer Command-Handler (COMMAND_INSERTTEXT)
// auto strip #include <bf_svx/outliner.hxx>		// fuer Command-Handler (COMMAND_INSERTTEXT)

// auto strip #include <com/sun/star/sheet/MemberResultFlags.hpp>

#include "gridwin.hxx"
#include "tabvwsh.hxx"
// auto strip #include "docsh.hxx"
// auto strip #include "viewdata.hxx"
// auto strip #include "tabview.hxx"
// auto strip #include "select.hxx"
#include "scmod.hxx"
#include "document.hxx"
// auto strip #include "attrib.hxx"
// auto strip #include "dbcolect.hxx"
// auto strip #include "stlpool.hxx"
// auto strip #include "printfun.hxx"
// auto strip #include "cbutton.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
// auto strip #include "editutil.hxx"
// auto strip #include "scresid.hxx"
// auto strip #include "inputhdl.hxx"
// auto strip #include "uiitems.hxx"			// Filter-Dialog - auslagern !!!
#include <vcl/floatwin.hxx>
// auto strip #include "impex.hxx"			// Sylk-ID fuer CB
// auto strip #include "cell.hxx"				// fuer Edit-Felder
// auto strip #include "patattr.hxx"
#include "notemark.hxx"
// auto strip #include "rfindlst.hxx"
// auto strip #include "docpool.hxx"
// auto strip #include "output.hxx"
// auto strip #include "docfunc.hxx"
// auto strip #include "dbdocfun.hxx"
#ifdef AUTOFILTER_POPUP
// auto strip #include <vcl/menu.hxx>
#endif
// auto strip #include "dpobject.hxx"
// auto strip #include "dpoutput.hxx"
// auto strip #include "transobj.hxx"
// auto strip #include "drwtrans.hxx"
// auto strip #include "seltrans.hxx"
// auto strip #include "sizedev.hxx"
// auto strip #include "AccessibilityHints.hxx"
namespace binfilter {

using namespace ::com::sun::star;

#define SC_AUTOFILTER_ALL		0
#define	SC_AUTOFILTER_CUSTOM	1
#define	SC_AUTOFILTER_TOP10		2

//	Modi fuer die FilterListBox
enum ScFilterBoxMode
{
	SC_FILTERBOX_FILTER,
	SC_FILTERBOX_DATASELECT,
	SC_FILTERBOX_SCENARIO
};

extern SfxViewShell* pScActiveViewShell;			// global.cxx
extern USHORT nScClickMouseModifier;				// global.cxx
extern USHORT nScFillModeMouseModifier;				// global.cxx

#define SC_FILTERLISTBOX_LINES	12

// STATIC DATA -----------------------------------------------------------

static long nFilterBoxTabs[] =
	{ 	1, // Number of Tabs
		0
	};

//==================================================================

/*
 * Der Autofilter wird auf dem Mac per AutoFilterPopup realisiert.
 * Die AutoFilterListBox wird trotzdem fuer die Auswahlliste gebraucht.
 */

//==================================================================
class ScFilterListBox : public SvTabListBox
{
//STRIP001 	ScGridWindow*	pGridWin;
//STRIP001 	USHORT			nCol;
//STRIP001 	USHORT			nRow;
//STRIP001 	BOOL			bButtonDown;
//STRIP001 	BOOL			bInit;
//STRIP001 	BOOL			bCancelled;
//STRIP001 	ULONG			nSel;
//STRIP001 	ScFilterBoxMode	eMode;
//STRIP001 
//STRIP001 protected:
//STRIP001 	virtual void	LoseFocus();
//STRIP001 	virtual void	SelectHdl();

public:
				ScFilterListBox( Window* pParent, ScGridWindow* pGrid,
					USHORT nNewCol, USHORT nNewRow, ScFilterBoxMode eNewMode );
//STRIP001 				~ScFilterListBox();
//STRIP001 
//STRIP001 	virtual void	MouseButtonDown( const MouseEvent& rMEvt );
//STRIP001 	virtual void	MouseButtonUp( const MouseEvent& rMEvt );
//STRIP001 
//STRIP001 	virtual void	KeyInput( const KeyEvent& rKEvt );
//STRIP001 
//STRIP001 	USHORT			GetCol() const			{ return nCol; }
//STRIP001 	USHORT			GetRow() const			{ return nRow; }
//STRIP001 	ScFilterBoxMode	GetMode() const			{ return eMode; }
//STRIP001 	BOOL			IsDataSelect() const	{ return (eMode == SC_FILTERBOX_DATASELECT); }
//STRIP001 	void			EndInit();
//STRIP001 	void			SetCancelled()			{ bCancelled = TRUE; }
};

//-------------------------------------------------------------------

//	ListBox in einem FloatingWindow (pParent)
ScFilterListBox::ScFilterListBox( Window* pParent, ScGridWindow* pGrid,
									USHORT nNewCol, USHORT nNewRow, ScFilterBoxMode eNewMode ) :
	SvTabListBox( pParent, WinBits(0) )//STRIP001 	SvTabListBox( pParent, WinBits(0) ),	// ohne Border
//STRIP001 	pGridWin( pGrid ),
//STRIP001 	nCol( nNewCol ),
//STRIP001 	nRow( nNewRow ),
//STRIP001 	eMode( eNewMode ),
//STRIP001 	bButtonDown( FALSE ),
//STRIP001 	bInit( TRUE ),
//STRIP001 	bCancelled( FALSE ),
//STRIP001 	nSel( 0 )
{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
}

//STRIP001 __EXPORT ScFilterListBox::~ScFilterListBox()
//STRIP001 {
//STRIP001 	if (IsMouseCaptured())
//STRIP001 		ReleaseMouse();
//STRIP001 }

//STRIP001 void ScFilterListBox::EndInit()
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = FirstSelected();
//STRIP001 	if (pEntry)
//STRIP001 		nSel = GetModel()->GetAbsPos( pEntry );
//STRIP001 	else
//STRIP001 		nSel = 0;
//STRIP001 
//STRIP001 	bInit = FALSE;
//STRIP001 }

//STRIP001 void __EXPORT ScFilterListBox::LoseFocus()
//STRIP001 {
//STRIP001 #ifndef UNX
//STRIP001 	Hide();
//STRIP001 #endif
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScFilterListBox::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	bButtonDown = TRUE;
//STRIP001 	SvTabListBox::MouseButtonDown( rMEvt );
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScFilterListBox::MouseButtonUp( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	bButtonDown = FALSE;
//STRIP001 	SvTabListBox::MouseButtonUp( rMEvt );
//STRIP001 
//STRIP001 	if (!bCancelled)
//STRIP001 		pGridWin->FilterSelect( nSel );
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScFilterListBox::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001 	KeyCode aCode = rKEvt.GetKeyCode();
//STRIP001 	if ( !aCode.GetModifier() )				// ohne alle Modifiers
//STRIP001 	{
//STRIP001 		USHORT nKey = aCode.GetCode();
//STRIP001 		if ( nKey == KEY_RETURN )
//STRIP001 		{
//STRIP001 			SelectHdl();					// auswaehlen
//STRIP001 			return;
//STRIP001 		}
//STRIP001 		else if ( nKey == KEY_ESCAPE )
//STRIP001 		{
//STRIP001 			pGridWin->ClickExtern();		// loescht die List-Box !!!
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SvTabListBox::KeyInput( rKEvt );
//STRIP001 }

//STRIP001 void __EXPORT ScFilterListBox::SelectHdl()
//STRIP001 {
//STRIP001 	if ( !IsTravelSelect() && !bInit && !bCancelled )
//STRIP001 	{
//STRIP001 		SvLBoxEntry* pEntry = FirstSelected();
//STRIP001 		if (pEntry)
//STRIP001 		{
//STRIP001 			nSel = GetModel()->GetAbsPos( pEntry );
//STRIP001 			if (!bButtonDown)
//STRIP001 				pGridWin->FilterSelect( nSel );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// use a System floating window for the above filter listbox
//STRIP001 class ScFilterFloatingWindow : public FloatingWindow
//STRIP001 {
//STRIP001 public:
//STRIP001 	ScFilterFloatingWindow( Window* pParent, WinBits nStyle = WB_STDFLOATWIN );
//STRIP001     // required for System FloatingWindows that will not process KeyInput by themselves
//STRIP001     virtual Window* GetPreferredKeyInputWindow();
//STRIP001 };
   
//STRIP001 ScFilterFloatingWindow::ScFilterFloatingWindow( Window* pParent, WinBits nStyle ) :
//STRIP001 	FloatingWindow( pParent, nStyle|WB_SYSTEMWINDOW ) // make it a system floater
//STRIP001     {}

//STRIP001 Window* ScFilterFloatingWindow::GetPreferredKeyInputWindow()
//STRIP001 {
//STRIP001     // redirect keyinput in the child window
//STRIP001     return GetWindow(WINDOW_FIRSTCHILD) ? GetWindow(WINDOW_FIRSTCHILD) : NULL;    // will be the FilterBox
//STRIP001 }

#ifdef AUTOFILTER_POPUP

//==================================================================
class AutoFilterPopup : public PopupMenu
{
public:
		AutoFilterPopup( ScGridWindow* _pWin, USHORT _nCol, USHORT _nRow, BOOL bDatSel )
			:	pWin( _pWin ),
				nCol( _nCol ),
				nRow( _nRow ),
				bIsDataSelect( bDatSel ),
				bSelected( FALSE )			{DBG_BF_ASSERT(0, "STRIP");}
//STRIP001 		~AutoFilterPopup();

//STRIP001 protected:
//STRIP001 	virtual void	Select();
//STRIP001 
//STRIP001 private:
//STRIP001 	ScGridWindow* pWin;
//STRIP001 	USHORT		  nCol;
//STRIP001 	USHORT		  nRow;
//STRIP001 	BOOL		  bIsDataSelect;
//STRIP001 	BOOL		  bSelected;
};

//-------------------------------------------------------------------

//STRIP001 void __EXPORT AutoFilterPopup::Select()
//STRIP001 {
//STRIP001 	//	Button vor dem ausfuehren wieder zeichnen
//STRIP001 	if ( !bIsDataSelect )
//STRIP001 	{
//STRIP001 		pWin->HideCursor();
//STRIP001 		pWin->aComboButton.Draw( FALSE );
//STRIP001 		pWin->ShowCursor();
//STRIP001 	}
//STRIP001 	bSelected = TRUE;
//STRIP001 
//STRIP001 	USHORT nCurId = GetCurItemId();
//STRIP001 	pWin->ReleaseMouse();
//STRIP001 	String aStr = GetItemText( nCurId );
//STRIP001 	if ( bIsDataSelect )
//STRIP001 		pWin->ExecDataSelect( nCol, nRow, aStr );
//STRIP001 	else
//STRIP001 		pWin->ExecFilter( nCurId-1, nCol, nRow, aStr );
//STRIP001 }

//STRIP001 AutoFilterPopup::~AutoFilterPopup()
//STRIP001 {
//STRIP001 	if ( !bIsDataSelect && !bSelected )
//STRIP001 	{
//STRIP001 		pWin->HideCursor();
//STRIP001 		pWin->aComboButton.Draw( FALSE );
//STRIP001 		pWin->ShowCursor();
//STRIP001 	}
//STRIP001 }

#endif // #ifdef AUTOFILTER_POPUP

//==================================================================

//STRIP001 BOOL lcl_IsEditableMatrix( ScDocument* pDoc, const ScRange& rRange )
//STRIP001 {
//STRIP001 	//	wenn es ein editierbarer Bereich ist, und rechts unten eine Matrix-Zelle
//STRIP001 	//	mit Origin links oben liegt, enthaelt der Bereich genau die Matrix.
//STRIP001 	//!	Direkt die MatrixEdges Funktionen von der Column herausreichen ???
//STRIP001 
//STRIP001 	if ( !pDoc->IsBlockEditable( rRange.aStart.Tab(), rRange.aStart.Col(),rRange.aStart.Row(),
//STRIP001 									rRange.aEnd.Col(),rRange.aEnd.Row() ) )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	ScAddress aPos;
//STRIP001 	const ScBaseCell* pCell = pDoc->GetCell( rRange.aEnd );
//STRIP001 	return ( pCell && pCell->GetCellType() == CELLTYPE_FORMULA &&
//STRIP001 			((ScFormulaCell*)pCell)->GetMatrixOrigin(aPos) && aPos == rRange.aStart );
//STRIP001 }

//==================================================================

//	WB_DIALOGCONTROL noetig fuer UNO-Controls
/*N*/ ScGridWindow::ScGridWindow( Window* pParent, ScViewData* pData, ScSplitPos eWhichPos ) :
/*N*/ 			Window( pParent, WB_CLIPCHILDREN | WB_DIALOGCONTROL ),
/*N*/ 			DropTargetHelper( this ),
/*N*/ 			DragSourceHelper( this ),
/*N*/ 			pViewData( pData ),
/*N*/ 			eWhich( eWhichPos ),
/*N*/ 			pNoteMarker( NULL ),
/*N*/ 			nCursorHideCount( 0 ),
/*N*/ 			bMarking( FALSE ),
/*N*/ 			bEEMouse( FALSE ),
/*N*/ 			nButtonDown( 0 ),
/*N*/ 			nMouseStatus( SC_GM_NONE ),
/*N*/ 			bPivotMouse( FALSE ),
/*N*/ 			bDPMouse( FALSE ),
/*N*/ 			bRFMouse( FALSE ),
/*N*/ 			nPagebreakMouse( SC_PD_NONE ),
/*N*/ 			nPageScript( 0 ),
/*N*/ 			bDragRect( FALSE ),
/*N*/ 			pFilterBox( NULL ),
/*N*/ 			pFilterFloat( NULL ),
/*N*/ 			nCurrentPointer( 0 ),
/*N*/ 			bIsInScroll( FALSE ),
/*N*/ 			bIsInPaint( FALSE ),
/*N*/ 			aComboButton( this ),
/*N*/ 			aCurMousePos( 0,0 ),
/*N*/ 			nPaintCount( 0 ),
/*N*/ 			bNeedsRepaint( FALSE ),
/*N*/ 			bAutoMarkVisible( FALSE )
/*N*/ {
/*N*/ 	switch(eWhich)
/*N*/ 	{
/*N*/ 		case SC_SPLIT_TOPLEFT:
/*N*/ 			eHWhich = SC_SPLIT_LEFT;
/*N*/ 			eVWhich = SC_SPLIT_TOP;
/*N*/ 			break;
/*N*/ 		case SC_SPLIT_TOPRIGHT:
/*N*/ 			eHWhich = SC_SPLIT_RIGHT;
/*N*/ 			eVWhich = SC_SPLIT_TOP;
/*N*/ 			break;
/*N*/ 		case SC_SPLIT_BOTTOMLEFT:
/*N*/ 			eHWhich = SC_SPLIT_LEFT;
/*N*/ 			eVWhich = SC_SPLIT_BOTTOM;
/*N*/ 			break;
/*N*/ 		case SC_SPLIT_BOTTOMRIGHT:
/*N*/ 			eHWhich = SC_SPLIT_RIGHT;
/*N*/ 			eVWhich = SC_SPLIT_BOTTOM;
/*N*/ 			break;
/*N*/ 		default:
/*N*/ 			DBG_ERROR("GridWindow: falsche Position");
/*N*/ 	}
/*N*/ 
/*N*/ 	SetBackground();
/*N*/ 
/*N*/ 	SetMapMode(pViewData->GetLogicMode(eWhich));
/*N*/ //	EnableDrop();
/*N*/ 	EnableChildTransparentMode();
/*N*/ 	SetDialogControlFlags( WINDOW_DLGCTRL_RETURN | WINDOW_DLGCTRL_WANTFOCUS );
/*N*/ 
/*N*/ 	SetHelpId( HID_SC_WIN_GRIDWIN );
/*N*/ 	SetUniqueId( HID_SC_WIN_GRIDWIN );
/*N*/ 
/*N*/ 	SetDigitLanguage( SC_MOD()->GetOptDigitLanguage() );
/*N*/ }

/*N*/ __EXPORT ScGridWindow::~ScGridWindow()
/*N*/ {
/*N*/ 	delete pFilterBox;
/*N*/ 	if (pFilterFloat)
/*?*/ 		pFilterFloat->EndPopupMode();
/*N*/ 	delete pFilterFloat;
/*N*/ 	delete pNoteMarker;
/*N*/ }

//STRIP001 void __EXPORT ScGridWindow::Resize( const Size& rSize )
//STRIP001 {
//STRIP001 	//	gar nix
//STRIP001 }

/*N*/ void ScGridWindow::ClickExtern()
/*N*/ {
/*N*/ 	DELETEZ(pFilterBox);
/*N*/ 	if (pFilterFloat)
/*?*/ 		pFilterFloat->EndPopupMode();
/*N*/ 	DELETEZ(pFilterFloat);
/*N*/ }

//STRIP001 IMPL_LINK( ScGridWindow, PopupModeEndHdl, FloatingWindow*, pFloat )
//STRIP001 {
//STRIP001 	if (pFilterBox)
//STRIP001 		pFilterBox->SetCancelled();		// nicht mehr auswaehlen
//STRIP001 	GrabFocus();
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 void ScGridWindow::DoScenarioMenue( const ScRange& rScenRange )
//STRIP001 {
//STRIP001 	delete pFilterBox;
//STRIP001 	if (pFilterFloat)
//STRIP001 		pFilterFloat->EndPopupMode();
//STRIP001 	delete pFilterFloat;
//STRIP001 
//STRIP001 	USHORT nCol = rScenRange.aEnd.Col();		// Zelle unterhalb des Buttons
//STRIP001 	USHORT nRow = rScenRange.aStart.Row();
//STRIP001 	if (nRow == 0)
//STRIP001 	{
//STRIP001 		nRow = rScenRange.aEnd.Row() + 1;		// Bereich ganz oben -> Button unterhalb
//STRIP001 		if (nRow>MAXROW) nRow = MAXROW;
//STRIP001 		//!	Texthoehe addieren (wenn sie an der View gespeichert ist...)
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT i;
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	long nSizeX  = 0;
//STRIP001 	long nSizeY  = 0;
//STRIP001 	long nHeight = 0;
//STRIP001 	pViewData->GetMergeSizePixel( nCol, nRow, nSizeX, nSizeY );
//STRIP001 	Point aPos = pViewData->GetScrPos( nCol, nRow, eWhich );
//STRIP001 	Rectangle aCellRect( OutputToScreenPixel(aPos), Size(nSizeX,nSizeY) );
//STRIP001 	aCellRect.Top()    -= nSizeY;
//STRIP001 	aCellRect.Bottom() -= nSizeY - 1;
//STRIP001 	//	Die ListBox direkt unter der schwarzen Linie auf dem Zellgitter
//STRIP001 	//	(wenn die Linie verdeckt wird, sieht es komisch aus...)
//STRIP001 
//STRIP001 	pFilterFloat = new ScFilterFloatingWindow( this, WinBits(WB_BORDER) );		// nicht resizable etc.
//STRIP001 	pFilterFloat->SetPopupModeEndHdl( LINK( this, ScGridWindow, PopupModeEndHdl ) );
//STRIP001 	pFilterBox = new ScFilterListBox( pFilterFloat, this, nCol, nRow, SC_FILTERBOX_SCENARIO );
//STRIP001 
//STRIP001 	nSizeX += 1;
//STRIP001 
//STRIP001 	{
//STRIP001 		Font 	aOldFont = GetFont(); SetFont( pFilterBox->GetFont() );
//STRIP001 		MapMode aOldMode = GetMapMode(); SetMapMode( MAP_PIXEL );
//STRIP001 
//STRIP001 		nHeight  = GetTextHeight();
//STRIP001 		nHeight *= SC_FILTERLISTBOX_LINES;
//STRIP001 
//STRIP001 		SetMapMode( aOldMode );
//STRIP001 		SetFont( aOldFont );
//STRIP001 	}
//STRIP001 
//STRIP001 	//	SetSize spaeter
//STRIP001 	pFilterBox->SetSelectionMode( SINGLE_SELECTION );
//STRIP001 	pFilterBox->SetTabs( nFilterBoxTabs, MapUnit( MAP_APPFONT ));
//STRIP001 
//STRIP001 
//STRIP001 	//	ParentSize Abfrage fehlt
//STRIP001 
//STRIP001 	Size aSize( nSizeX, nHeight );
//STRIP001 	pFilterBox->SetSizePixel( aSize );
//STRIP001 	pFilterBox->Show();					// Show muss vor SetUpdateMode kommen !!!
//STRIP001 	pFilterBox->SetUpdateMode(FALSE);
//STRIP001 
//STRIP001 	//	SetOutputSizePixel/StartPopupMode erst unten, wenn die Groesse feststeht
//STRIP001 
//STRIP001 	//	Listbox fuellen
//STRIP001 
//STRIP001 	long nMaxText = 0;
//STRIP001 	String aCurrent;
//STRIP001 	String aTabName;
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	USHORT nEntryCount = 0;
//STRIP001 	for (i=nTab+1; i<nTabCount && pDoc->IsScenario(i); i++)
//STRIP001 	{
//STRIP001 		if (pDoc->HasScenarioRange( i, rScenRange ))
//STRIP001 			if (pDoc->GetName( i, aTabName ))
//STRIP001 			{
//STRIP001 				pFilterBox->InsertEntry( aTabName );
//STRIP001 				if (pDoc->IsActiveScenario(i))
//STRIP001 					aCurrent = aTabName;
//STRIP001 				long nTextWidth = pFilterBox->GetTextWidth( aTabName );
//STRIP001 				if ( nTextWidth > nMaxText )
//STRIP001 					nMaxText = nTextWidth;
//STRIP001 				++nEntryCount;
//STRIP001 			}
//STRIP001 	}
//STRIP001 	if (nEntryCount > SC_FILTERLISTBOX_LINES)
//STRIP001 		nMaxText += GetSettings().GetStyleSettings().GetScrollBarSize();
//STRIP001 	nMaxText += 4;			// fuer Rand
//STRIP001 	if ( nMaxText > 300 )
//STRIP001 		nMaxText = 300;		// auch nicht uebertreiben (Pixel)
//STRIP001 
//STRIP001 	if (nMaxText > nSizeX)	// Groesse auf benoetigte Groesse anpassen
//STRIP001 	{
//STRIP001 		long nDiff = nMaxText - nSizeX;
//STRIP001 		aSize = Size( nMaxText, nHeight );
//STRIP001 		pFilterBox->SetSizePixel( aSize );
//STRIP001 		pFilterFloat->SetOutputSizePixel( aSize );
//STRIP001 
//STRIP001 		//	auch Startposition verschieben
//STRIP001 		long nNewX = aCellRect.Left() - nDiff;
//STRIP001 		if ( nNewX < 0 )
//STRIP001 			nNewX = 0;
//STRIP001 		aCellRect.Left() = nNewX;
//STRIP001 	}
//STRIP001 
//STRIP001 	pFilterFloat->SetOutputSizePixel( aSize );
//STRIP001 	pFilterFloat->StartPopupMode( aCellRect, FLOATWIN_POPUPMODE_DOWN|FLOATWIN_POPUPMODE_GRABFOCUS );
//STRIP001 
//STRIP001 	pFilterBox->SetUpdateMode(TRUE);
//STRIP001 	pFilterBox->GrabFocus();
//STRIP001 
//STRIP001 	//	Select erst nach GrabFocus, damit das Focus-Rechteck richtig landet
//STRIP001 	SvLBoxEntry* pSelect = NULL;
//STRIP001 	if (aCurrent.Len())
//STRIP001 	{
//STRIP001 		ULONG nPos = pFilterBox->GetEntryPos( aCurrent );
//STRIP001 		pSelect = pFilterBox->GetEntry( nPos );
//STRIP001 	}
//STRIP001 	if (!pSelect)
//STRIP001 		pSelect = pFilterBox->GetEntry(0);			// einer sollte immer selektiert sein
//STRIP001 	if (pSelect)
//STRIP001 		pFilterBox->Select(pSelect);
//STRIP001 
//STRIP001 	pFilterBox->EndInit();
//STRIP001 
//STRIP001 	// Szenario-Auswahl kommt aus MouseButtonDown:
//STRIP001 	//	der naechste MouseMove auf die Filterbox ist wie ein ButtonDown
//STRIP001 
//STRIP001 	nMouseStatus = SC_GM_FILTER;
//STRIP001 	CaptureMouse();
//STRIP001 }

//STRIP001 void ScGridWindow::DoAutoFilterMenue( USHORT nCol, USHORT nRow, BOOL bDataSelect )
//STRIP001 {
//STRIP001 	//	bei AUTOFILTER_POPUP-define fuer AutoFilter das Popup nehmen
//STRIP001 #ifdef AUTOFILTER_POPUP
//STRIP001 	if ( !bDataSelect )
//STRIP001 	{
//STRIP001 		DoAutoFilterPopup( nCol, nRow, bDataSelect );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 #endif

	/*
	 * Standard-Variante mit TreeListBox
	 */

//STRIP001 	delete pFilterBox;
//STRIP001 	if (pFilterFloat)
//STRIP001 		pFilterFloat->EndPopupMode();
//STRIP001 	delete pFilterFloat;
//STRIP001 
//STRIP001 	USHORT i;
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	long nSizeX  = 0;
//STRIP001 	long nSizeY  = 0;
//STRIP001 	long nHeight = 0;
//STRIP001 	pViewData->GetMergeSizePixel( nCol, nRow, nSizeX, nSizeY );
//STRIP001 	Point aPos = pViewData->GetScrPos( nCol, nRow, eWhich );
//STRIP001 
//STRIP001 	Rectangle aCellRect( OutputToScreenPixel(aPos), Size(nSizeX,nSizeY) );
//STRIP001 
//STRIP001 	aPos.X() -= 1;
//STRIP001 	aPos.Y() += nSizeY - 1;
//STRIP001 
//STRIP001 	pFilterFloat = new ScFilterFloatingWindow( this, WinBits(WB_BORDER) );		// nicht resizable etc.
//STRIP001 	pFilterFloat->SetPopupModeEndHdl( LINK( this, ScGridWindow, PopupModeEndHdl ) );
//STRIP001 	pFilterBox = new ScFilterListBox( pFilterFloat, this, nCol, nRow,
//STRIP001 						bDataSelect ? SC_FILTERBOX_DATASELECT : SC_FILTERBOX_FILTER );
//STRIP001 
//STRIP001 	nSizeX += 1;
//STRIP001 
//STRIP001 	{
//STRIP001 		Font 	aOldFont = GetFont(); SetFont( pFilterBox->GetFont() );
//STRIP001 		MapMode aOldMode = GetMapMode(); SetMapMode( MAP_PIXEL );
//STRIP001 
//STRIP001 		nHeight  = GetTextHeight();
//STRIP001 		nHeight *= SC_FILTERLISTBOX_LINES;
//STRIP001 
//STRIP001 		SetMapMode( aOldMode );
//STRIP001 		SetFont( aOldFont );
//STRIP001 	}
//STRIP001 
//STRIP001 	//	SetSize spaeter
//STRIP001 	pFilterBox->SetSelectionMode( SINGLE_SELECTION );
//STRIP001 	pFilterBox->SetTabs( nFilterBoxTabs, MapUnit( MAP_APPFONT ));
//STRIP001 
//STRIP001 	BOOL bEmpty = FALSE;
//STRIP001 	TypedStrCollection aStrings( 128, 128 );
//STRIP001 	if ( bDataSelect )									// Auswahl-Liste
//STRIP001 	{
//STRIP001 		//	Liste fuellen
//STRIP001 		aStrings.SetCaseSensitive( TRUE );
//STRIP001 		pDoc->GetDataEntries( nCol, nRow, nTab, aStrings );
//STRIP001 		if ( aStrings.GetCount() == 0 )
//STRIP001 			bEmpty = TRUE;
//STRIP001 	}
//STRIP001 	else												// AutoFilter
//STRIP001 	{
//STRIP001 		//!	wird der Titel ueberhaupt ausgewertet ???
//STRIP001 		String aString;
//STRIP001 		pDoc->GetString( nCol, nRow, nTab, aString );
//STRIP001 		pFilterBox->SetText( aString );
//STRIP001 
//STRIP001 		long nMaxText = 0;
//STRIP001 
//STRIP001 		//	default entries
//STRIP001 		static const USHORT nDefIDs[] = { SCSTR_ALL, SCSTR_STDFILTER, SCSTR_TOP10FILTER };
//STRIP001 		const USHORT nDefCount = sizeof(nDefIDs) / sizeof(USHORT);
//STRIP001 		for (i=0; i<nDefCount; i++)
//STRIP001 		{
//STRIP001 			String aEntry( (ScResId) nDefIDs[i] );
//STRIP001 			pFilterBox->InsertEntry( aEntry );
//STRIP001 			long nTextWidth = pFilterBox->GetTextWidth( aEntry );
//STRIP001 			if ( nTextWidth > nMaxText )
//STRIP001 				nMaxText = nTextWidth;
//STRIP001 		}
//STRIP001 		
//STRIP001 		//	get list entries
//STRIP001 		pDoc->GetFilterEntries( nCol, nRow, nTab, aStrings );
//STRIP001 
//STRIP001 		//	check widths of numerical entries (string entries are not included)
//STRIP001 		//	so all numbers are completely visible
//STRIP001 		USHORT nCount = aStrings.GetCount();
//STRIP001 		for (i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			TypedStrData* pData = aStrings[i];
//STRIP001 			if ( !pData->IsStrData() )				// only numerical entries
//STRIP001 			{
//STRIP001 				long nTextWidth = pFilterBox->GetTextWidth( pData->GetString() );
//STRIP001 				if ( nTextWidth > nMaxText )
//STRIP001 					nMaxText = nTextWidth;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//	add scrollbar width if needed (string entries are counted here)
//STRIP001 		//	(scrollbar is shown if the box is exactly full?)
//STRIP001 		if ( nCount + nDefCount >= SC_FILTERLISTBOX_LINES )
//STRIP001 			nMaxText += GetSettings().GetStyleSettings().GetScrollBarSize();
//STRIP001 
//STRIP001 		nMaxText += 4;				// for borders
//STRIP001 
//STRIP001 		if ( nMaxText > nSizeX )
//STRIP001 			nSizeX = nMaxText;		// just modify width - starting position is unchanged
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bEmpty)
//STRIP001 	{
//STRIP001 		//	Position und Groesse an Fenster anpassen
//STRIP001 		//!	vorher Abfrage, ob die Eintraege hineinpassen (Breite)
//STRIP001 
//STRIP001 		Size aParentSize = GetParent()->GetOutputSizePixel();
//STRIP001 		Size aSize( nSizeX, nHeight );
//STRIP001 
//STRIP001 		if ( aSize.Height() > aParentSize.Height() )
//STRIP001 			aSize.Height() = aParentSize.Height();
//STRIP001 		if ( aPos.Y() + aSize.Height() > aParentSize.Height() )
//STRIP001 			aPos.Y() = aParentSize.Height() - aSize.Height();
//STRIP001 
//STRIP001 		pFilterBox->SetSizePixel( aSize );
//STRIP001 		pFilterBox->Show();					// Show muss vor SetUpdateMode kommen !!!
//STRIP001 		pFilterBox->SetUpdateMode(FALSE);
//STRIP001 
//STRIP001 		pFilterFloat->SetOutputSizePixel( aSize );
//STRIP001 		pFilterFloat->StartPopupMode( aCellRect, FLOATWIN_POPUPMODE_DOWN|FLOATWIN_POPUPMODE_GRABFOCUS);
//STRIP001 
//STRIP001 		//	Listbox fuellen
//STRIP001 		USHORT nCount = aStrings.GetCount();
//STRIP001 		BOOL bWait = ( nCount > 100 );
//STRIP001 
//STRIP001 		if (bWait)
//STRIP001 			EnterWait();
//STRIP001 
//STRIP001 		for (i=0; i<nCount; i++)
//STRIP001 			pFilterBox->InsertEntry( aStrings[i]->GetString() );
//STRIP001 
//STRIP001 		if (bWait)
//STRIP001 			LeaveWait();
//STRIP001 
//STRIP001 		pFilterBox->SetUpdateMode(TRUE);
//STRIP001 	}
//STRIP001 
//STRIP001 	SvLBoxEntry* pSelect = NULL;
//STRIP001 
//STRIP001 	if (!bDataSelect)						// AutoFilter: aktiven Eintrag selektieren
//STRIP001 	{
//STRIP001 		ScDBData* pDBData = pDoc->GetDBAtCursor( nCol, nRow, nTab );
//STRIP001 		if (pDBData)
//STRIP001 		{
//STRIP001 			ScQueryParam aParam;
//STRIP001 			pDBData->GetQueryParam( aParam );		// kann nur MAXQUERY Eintraege ergeben
//STRIP001 
//STRIP001 			BOOL bValid = TRUE;
//STRIP001 			for (i=0; i<MAXQUERY && bValid; i++)			// bisherige Filter-Einstellungen
//STRIP001 				if (aParam.GetEntry(i).bDoQuery)
//STRIP001 				{
//STRIP001 					//!			Abfrage mit DrawButtons zusammenfassen!
//STRIP001 
//STRIP001 					ScQueryEntry& rEntry = aParam.GetEntry(i);
//STRIP001 					if (i>0)
//STRIP001 						if (rEntry.eConnect != SC_AND)
//STRIP001 							bValid = FALSE;
//STRIP001 					if (rEntry.nField == nCol)
//STRIP001 					{
//STRIP001 						if (rEntry.eOp == SC_EQUAL)
//STRIP001 						{
//STRIP001 							String* pStr = rEntry.pStr;
//STRIP001 							if (pStr)
//STRIP001 							{
//STRIP001 								ULONG nPos = pFilterBox->GetEntryPos( *pStr );
//STRIP001 								pSelect = pFilterBox->GetEntry( nPos );
//STRIP001 							}
//STRIP001 						}
//STRIP001 						else if (rEntry.eOp == SC_TOPVAL && rEntry.pStr &&
//STRIP001 									rEntry.pStr->EqualsAscii("10"))
//STRIP001 							pSelect = pFilterBox->GetEntry( SC_AUTOFILTER_TOP10 );
//STRIP001 						else
//STRIP001 							pSelect = pFilterBox->GetEntry( SC_AUTOFILTER_CUSTOM );
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 			if (!bValid)
//STRIP001 				pSelect = pFilterBox->GetEntry( SC_AUTOFILTER_CUSTOM );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 		//	neu (309): irgendwas muss immer selektiert sein:
//STRIP001 	if (!pSelect)
//STRIP001 		pSelect = pFilterBox->GetEntry(0);
//STRIP001 
//STRIP001 	//	keine leere Auswahl-Liste anzeigen:
//STRIP001 
//STRIP001 	if ( bEmpty )
//STRIP001 	{
//STRIP001 		DELETEZ(pFilterBox);				// war nix
//STRIP001 		if (pFilterFloat)
//STRIP001 			pFilterFloat->EndPopupMode();
//STRIP001 		DELETEZ(pFilterFloat);
//STRIP001 		Sound::Beep();						// bemerkbar machen
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 //		pFilterBox->Show();					// schon vorne
//STRIP001 		pFilterBox->GrabFocus();
//STRIP001 
//STRIP001 			//	Select erst nach GrabFocus, damit das Focus-Rechteck richtig landet
//STRIP001 		if (pSelect)
//STRIP001 			pFilterBox->Select(pSelect);
//STRIP001 
//STRIP001 		pFilterBox->EndInit();
//STRIP001 
//STRIP001 		if (!bDataSelect)
//STRIP001 		{
//STRIP001 			// AutoFilter (aus MouseButtonDown):
//STRIP001 			//	der naechste MouseMove auf die Filterbox ist wie ein ButtonDown
//STRIP001 
//STRIP001 			nMouseStatus = SC_GM_FILTER;
//STRIP001 			CaptureMouse();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

#ifdef AUTOFILTER_POPUP

	/*
	 * Macintosh-Variante mit Popup-Menue
	 */

//STRIP001 void ScGridWindow::DoAutoFilterPopup( USHORT nCol, USHORT nRow, BOOL bDataSelect )
//STRIP001 {
//STRIP001 	AutoFilterPopup*	pPopupMenu = new AutoFilterPopup( this, nCol, nRow, bDataSelect );
//STRIP001 	ScDocument*	 		pDoc = pViewData->GetDocument();
//STRIP001 	USHORT				nTab = pViewData->GetTabNo();
//STRIP001 	Point				aPos = pViewData->GetScrPos( nCol, nRow, eWhich );
//STRIP001 	BOOL				bValid = TRUE;
//STRIP001 	String				aStrSelect;
//STRIP001 	USHORT				nSelPos = 0;
//STRIP001 
//STRIP001 	TypedStrCollection aStrings( 128, 128 );
//STRIP001 	USHORT nFirst = 1;
//STRIP001 	if ( bDataSelect )								// Auswahl-Liste
//STRIP001 	{
//STRIP001 		//	Liste fuellen
//STRIP001 		aStrings.SetCaseSensitive( TRUE );
//STRIP001 		pDoc->GetDataEntries( nCol, nRow, nTab, aStrings );
//STRIP001 
//STRIP001 		//	nichts selektieren
//STRIP001 		bValid = FALSE;
//STRIP001 	}
//STRIP001 	else											// AutoFilter
//STRIP001 	{
//STRIP001 		//	Standard-Eintraege
//STRIP001 		pPopupMenu->InsertItem( 1, String( ScResId(SCSTR_ALL) ) );
//STRIP001 		pPopupMenu->InsertItem( 2, String( ScResId(SCSTR_STDFILTER) ) );
//STRIP001 		pPopupMenu->InsertItem( 3, String( ScResId(SCSTR_TOP10FILTER) ) );
//STRIP001 		nFirst = 4;
//STRIP001 
//STRIP001 		//	Liste fuellen
//STRIP001 		pDoc->GetFilterEntries( nCol, nRow, nTab, aStrings );
//STRIP001 
//STRIP001 		//	aktiven Eintrag suchen
//STRIP001 		ScDBData* pDBData = pDoc->GetDBAtCursor( nCol, nRow, nTab );
//STRIP001 		if (pDBData)
//STRIP001 		{
//STRIP001 			ScQueryParam aParam;
//STRIP001 			pDBData->GetQueryParam( aParam );
//STRIP001 
//STRIP001 			for (USHORT i=0; i<MAXQUERY && bValid; i++)			// bisherige Filter-Einstellungen
//STRIP001 			{
//STRIP001 				ScQueryEntry& rEntry = aParam.GetEntry(i);
//STRIP001 				if (rEntry.bDoQuery)
//STRIP001 				{
//STRIP001 					if (i>0)
//STRIP001 						if (rEntry.eConnect != SC_AND)
//STRIP001 							bValid = FALSE;
//STRIP001 					if (rEntry.nField == nCol)
//STRIP001 					{
//STRIP001 						if (rEntry.eOp == SC_EQUAL)
//STRIP001 						{
//STRIP001 							String* pStr = rEntry.pStr;
//STRIP001 							if (pStr)
//STRIP001 								aStrSelect = *pStr;
//STRIP001 						}
//STRIP001 						else if (rEntry.eOp == SC_TOPVAL && rEntry.pStr &&
//STRIP001 									*rEntry.pStr == "10")
//STRIP001 							nSelPos = SC_AUTOFILTER_TOP10;
//STRIP001 						else
//STRIP001 							nSelPos = SC_AUTOFILTER_CUSTOM;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if (!bValid)
//STRIP001 			{
//STRIP001 				aStrSelect.Erase();
//STRIP001 				nSelPos = 0;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Menue fuellen
//STRIP001 
//STRIP001 	USHORT nCount = aStrings.GetCount();
//STRIP001 	for ( USHORT i=0; i<nCount; i++ )
//STRIP001 	{
//STRIP001 		const String& rStr = aStrings[i]->GetString();
//STRIP001 
//STRIP001 		if ( bValid && nSelPos == 0 )
//STRIP001 			if ( aStrSelect == rStr )
//STRIP001 				nSelPos = i+nFirst;
//STRIP001 
//STRIP001 		pPopupMenu->InsertItem( i+nFirst, rStr );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bValid )
//STRIP001 	{
//STRIP001 		pPopupMenu->SetDefaultItem( nSelPos );
//STRIP001 		pPopupMenu->CheckItem( nSelPos );
//STRIP001 	}
//STRIP001 
//STRIP001 	//	ausfuehren nur, wenn ueberhaupt was drin ist (bei Auswahl-Liste)
//STRIP001 	if ( nCount+nFirst > 1 )
//STRIP001 		pPopupMenu->Execute( OutputToScreenPixel( aPos ) );
//STRIP001 	else
//STRIP001 		Sound::Beep();
//STRIP001 
//STRIP001 	delete pPopupMenu;
//STRIP001 }

#endif // #ifdef AUTOFILTER_POPUP

//STRIP001 void ScGridWindow::FilterSelect( ULONG nSel )
//STRIP001 {
//STRIP001 	String aString;
//STRIP001 	SvLBoxEntry* pEntry = pFilterBox->GetEntry( nSel );
//STRIP001 	if (pEntry)
//STRIP001 	{
//STRIP001 		SvLBoxString* pStringEntry = (SvLBoxString*) pEntry->GetFirstItem( SV_ITEM_ID_LBOXSTRING );
//STRIP001 		if ( pStringEntry )
//STRIP001 			aString = pStringEntry->GetText();
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nCol = pFilterBox->GetCol();
//STRIP001 	USHORT nRow = pFilterBox->GetRow();
//STRIP001 	switch ( pFilterBox->GetMode() )
//STRIP001 	{
//STRIP001 		case SC_FILTERBOX_DATASELECT:
//STRIP001 			ExecDataSelect( nCol, nRow, aString );
//STRIP001 			break;
//STRIP001 		case SC_FILTERBOX_FILTER:
//STRIP001 			ExecFilter( nSel, nCol, nRow, aString );
//STRIP001 			break;
//STRIP001 		case SC_FILTERBOX_SCENARIO:
//STRIP001 			pViewData->GetView()->UseScenario( aString );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pFilterFloat)
//STRIP001 		pFilterFloat->EndPopupMode();
//STRIP001 
//STRIP001 	GrabFocus();		// unter OS/2 stimmt der Focus sonst nicht
//STRIP001 }

//STRIP001 void ScGridWindow::ExecDataSelect( USHORT nCol, USHORT nRow, const String& rStr )
//STRIP001 {
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	if ( rStr.Len() )
//STRIP001 		pViewData->GetView()->EnterData( nCol, nRow, nTab, rStr );
//STRIP001 }

//STRIP001 void ScGridWindow::ExecFilter( ULONG nSel,
//STRIP001 							   USHORT nCol, USHORT nRow,
//STRIP001 							   const String& aValue )
//STRIP001 {
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 
//STRIP001 	ScDBData* pDBData = pDoc->GetDBAtCursor( nCol, nRow, nTab );
//STRIP001 	if (pDBData)
//STRIP001 	{
//STRIP001 		USHORT i;
//STRIP001 		ScQueryParam aParam;
//STRIP001 		pDBData->GetQueryParam( aParam );		// kann nur MAXQUERY Eintraege ergeben
//STRIP001 
//STRIP001 		if (SC_AUTOFILTER_CUSTOM == nSel)
//STRIP001 		{
//STRIP001 //			lcl_StartFilterDialog( pViewData, aParam, Application::GetAppWindow() );
//STRIP001 			pViewData->GetView()->SetCursor(nCol,nRow);		//! auch ueber Slot ??
//STRIP001 			pViewData->GetDispatcher().Execute( SID_FILTER, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			BOOL bDeleteOld = FALSE;
//STRIP001 			USHORT nQueryPos = 0;
//STRIP001 			BOOL bFound = FALSE;
//STRIP001 			if (!aParam.bInplace)
//STRIP001 				bDeleteOld = TRUE;
//STRIP001 			if (aParam.bRegExp)
//STRIP001 				bDeleteOld = TRUE;
//STRIP001 			for (i=0; i<MAXQUERY && !bDeleteOld; i++)			// bisherige Filter-Einstellungen
//STRIP001 				if (aParam.GetEntry(i).bDoQuery)
//STRIP001 				{
//STRIP001 					//!			Abfrage mit DrawButtons zusammenfassen!
//STRIP001 
//STRIP001 					ScQueryEntry& rEntry = aParam.GetEntry(i);
//STRIP001 					if (i>0)
//STRIP001 						if (rEntry.eConnect != SC_AND)
//STRIP001 							bDeleteOld = TRUE;
//STRIP001 
//STRIP001 					if (rEntry.nField == nCol)
//STRIP001 					{
//STRIP001 						if (bFound)							// diese Spalte zweimal?
//STRIP001 							bDeleteOld = TRUE;
//STRIP001 						nQueryPos = i;
//STRIP001 						bFound = TRUE;
//STRIP001 					}
//STRIP001 					if (!bFound)
//STRIP001 						nQueryPos = i + 1;
//STRIP001 				}
//STRIP001 
//STRIP001 			if (bDeleteOld)
//STRIP001 			{
//STRIP001 				USHORT nEC = aParam.GetEntryCount();
//STRIP001 				for (USHORT i=0; i<nEC; i++)
//STRIP001 					aParam.GetEntry(i).bDoQuery = FALSE;
//STRIP001 				nQueryPos = 0;
//STRIP001 				aParam.bInplace = TRUE;
//STRIP001 				aParam.bRegExp = FALSE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( nQueryPos < MAXQUERY || SC_AUTOFILTER_ALL == nSel )	// loeschen geht immer
//STRIP001 			{
//STRIP001 				if (nSel)
//STRIP001 				{
//STRIP001 					ScQueryEntry& rNewEntry = aParam.GetEntry(nQueryPos);
//STRIP001 
//STRIP001 					rNewEntry.bDoQuery		 = TRUE;
//STRIP001 					rNewEntry.bQueryByString = TRUE;
//STRIP001 					rNewEntry.nField		 = nCol;
//STRIP001 					if ( nSel == SC_AUTOFILTER_TOP10 )
//STRIP001 					{
//STRIP001 						rNewEntry.eOp	= SC_TOPVAL;
//STRIP001 						*rNewEntry.pStr	= String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("10"));
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						rNewEntry.eOp	= SC_EQUAL;
//STRIP001 						*rNewEntry.pStr	= aValue;
//STRIP001 					}
//STRIP001 					if (nQueryPos > 0)
//STRIP001 						rNewEntry.eConnect   = SC_AND;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if (bFound)
//STRIP001 						aParam.DeleteQuery(nQueryPos);
//STRIP001 				}
//STRIP001 
//STRIP001 				//	#100597# end edit mode - like in ScCellShell::ExecuteDB
//STRIP001 				if ( pViewData->HasEditView( pViewData->GetActivePart() ) )
//STRIP001 				{
//STRIP001 					SC_MOD()->InputEnterHandler();
//STRIP001 					pViewData->GetViewShell()->UpdateInputHandler();
//STRIP001 				}
//STRIP001 
//STRIP001 				pViewData->GetView()->Query( aParam, NULL, TRUE );
//STRIP001 				pDBData->SetQueryParam( aParam );							// speichern
//STRIP001 			}
//STRIP001 			else					//	"Zuviele Bedingungen"
//STRIP001 				pViewData->GetView()->ErrorMessage( STR_FILTER_TOOMANY );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		DBG_ERROR("Wo ist der Datenbankbereich?");
//STRIP001 }

//STRIP001 void ScGridWindow::SetPointer( const Pointer& rPointer )
//STRIP001 {
//STRIP001 	nCurrentPointer = 0;
//STRIP001 	Window::SetPointer( rPointer );
//STRIP001 }

//STRIP001 void ScGridWindow::MoveMouseStatus( ScGridWindow& rDestWin )
//STRIP001 {
//STRIP001 	if (nButtonDown)
//STRIP001 	{
//STRIP001 		rDestWin.nButtonDown = nButtonDown;
//STRIP001 		rDestWin.nMouseStatus = nMouseStatus;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bRFMouse)
//STRIP001 	{
//STRIP001 		rDestWin.bRFMouse = bRFMouse;
//STRIP001 		rDestWin.bRFSize  = bRFSize;
//STRIP001 		rDestWin.nRFIndex = nRFIndex;
//STRIP001 		rDestWin.nRFAddX  = nRFAddX;
//STRIP001 		rDestWin.nRFAddY  = nRFAddY;
//STRIP001 		bRFMouse = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nPagebreakMouse)
//STRIP001 	{
//STRIP001 		rDestWin.nPagebreakMouse  = nPagebreakMouse;
//STRIP001 		rDestWin.nPagebreakBreak  = nPagebreakBreak;
//STRIP001 		rDestWin.nPagebreakPrev   = nPagebreakPrev;
//STRIP001 		rDestWin.aPagebreakSource = aPagebreakSource;
//STRIP001 		rDestWin.aPagebreakDrag   = aPagebreakDrag;
//STRIP001 		nPagebreakMouse = SC_PD_NONE;
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL ScGridWindow::TestMouse( const MouseEvent& rMEvt, BOOL bAction )
//STRIP001 {
//STRIP001 	//	MouseEvent buttons must only be checked if bAction==TRUE
//STRIP001 	//	to allow changing the mouse pointer in MouseMove,
//STRIP001 	//	but not start AutoFill with right button (#74229#).
//STRIP001 	//	with bAction==TRUE, SetFillMode / SetDragMode is called
//STRIP001 
//STRIP001 	if ( bAction && !rMEvt.IsLeft() )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	BOOL bNewPointer = FALSE;
//STRIP001 
//STRIP001 	SfxInPlaceClient* pClient = pViewData->GetViewShell()->GetIPClient();
//STRIP001 	BOOL bOleActive = ( pClient && pClient->IsInPlaceActive() );
//STRIP001 
//STRIP001 	if ( pViewData->IsActive() && !bOleActive )
//STRIP001 	{
//STRIP001 		//	Auto-Fill
//STRIP001 
//STRIP001 		ScRange aMarkRange;
//STRIP001 		if (pViewData->GetSimpleArea( aMarkRange ))
//STRIP001 		{
//STRIP001 			if ( aMarkRange.aStart.Tab() == pViewData->GetTabNo() )
//STRIP001 			{
//STRIP001 				//	Block-Ende wie in DrawAutoFillMark
//STRIP001 				USHORT nX = aMarkRange.aEnd.Col();
//STRIP001 				USHORT nY = aMarkRange.aEnd.Row();
//STRIP001 
//STRIP001 				Point aFillPos = pViewData->GetScrPos( nX, nY, eWhich, TRUE );
//STRIP001 				long nSizeXPix;
//STRIP001 				long nSizeYPix;
//STRIP001 				pViewData->GetMergeSizePixel( nX, nY, nSizeXPix, nSizeYPix );
//STRIP001 				aFillPos.X() += nSizeXPix;
//STRIP001 				aFillPos.Y() += nSizeYPix;
//STRIP001 
//STRIP001 				Point aMousePos = rMEvt.GetPosPixel();
//STRIP001 				//	Abfrage hier passend zu DrawAutoFillMark
//STRIP001 				//	(ein Pixel mehr als markiert)
//STRIP001 				if ( aMousePos.X() >= aFillPos.X()-3 && aMousePos.X() <= aFillPos.X()+4 &&
//STRIP001 					 aMousePos.Y() >= aFillPos.Y()-3 && aMousePos.Y() <= aFillPos.Y()+4 )
//STRIP001 				{
//STRIP001 					SetPointer( Pointer( POINTER_CROSS ) );		//! dickeres Kreuz ?
//STRIP001 					if (bAction)
//STRIP001 					{
//STRIP001 						if ( lcl_IsEditableMatrix( pViewData->GetDocument(), aMarkRange ) )
//STRIP001 							pViewData->SetDragMode(
//STRIP001 								aMarkRange.aStart.Col(), aMarkRange.aStart.Row(), nX, nY, SC_FILL_MATRIX );
//STRIP001 						else
//STRIP001 							pViewData->SetFillMode(
//STRIP001 								aMarkRange.aStart.Col(), aMarkRange.aStart.Row(), nX, nY );
//STRIP001 
//STRIP001 						//	#108266# The simple selection must also be recognized when dragging,
//STRIP001 						//	where the Marking flag is set and MarkToSimple won't work anymore.
//STRIP001 						pViewData->GetMarkData().MarkToSimple();
//STRIP001 					}
//STRIP001 					bNewPointer = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//	Embedded-Rechteck
//STRIP001 
//STRIP001 		ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 		if (pDoc->IsEmbedded())
//STRIP001 		{
//STRIP001 			ScTripel aStart;
//STRIP001 			ScTripel aEnd;
//STRIP001 			pDoc->GetEmbedded( aStart, aEnd );
//STRIP001 			if ( pViewData->GetTabNo() == aStart.GetTab() )
//STRIP001 			{
//STRIP001 				Point aStartPos = pViewData->GetScrPos( aStart.GetCol(), aStart.GetRow(), eWhich );
//STRIP001 				Point aEndPos   = pViewData->GetScrPos( aEnd.GetCol()+1, aEnd.GetRow()+1, eWhich );
//STRIP001 				Point aMousePos = rMEvt.GetPosPixel();
//STRIP001 				BOOL bTop = ( aMousePos.X() >= aStartPos.X()-3 && aMousePos.X() <= aStartPos.X()+1 &&
//STRIP001 							  aMousePos.Y() >= aStartPos.Y()-3 && aMousePos.Y() <= aStartPos.Y()+1 );
//STRIP001 				BOOL bBottom = ( aMousePos.X() >= aEndPos.X()-3 && aMousePos.X() <= aEndPos.X()+1 &&
//STRIP001 								 aMousePos.Y() >= aEndPos.Y()-3 && aMousePos.Y() <= aEndPos.Y()+1 );
//STRIP001 				if ( bTop || bBottom )
//STRIP001 				{
//STRIP001 					SetPointer( Pointer( POINTER_CROSS ) );
//STRIP001 					if (bAction)
//STRIP001 					{
//STRIP001 						BYTE nMode = bTop ? SC_FILL_EMBED_LT : SC_FILL_EMBED_RB;
//STRIP001 						pViewData->SetDragMode(
//STRIP001 									aStart.GetCol(), aStart.GetRow(),
//STRIP001 									aEnd.GetCol(), aEnd.GetRow(), nMode );
//STRIP001 					}
//STRIP001 					bNewPointer = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bNewPointer && bAction)
//STRIP001 	{
//STRIP001 //		SetPointer( POINTER_ARROW );			// in Fu...
//STRIP001 		pViewData->ResetFillMode();
//STRIP001 	}
//STRIP001 
//STRIP001 	return bNewPointer;
//STRIP001 }

//STRIP001 void __EXPORT ScGridWindow::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	aCurMousePos = rMEvt.GetPosPixel();
//STRIP001 
//STRIP001 	//	Filter-Popup beendet sich mit eigenem Mausklick, nicht erst beim Klick
//STRIP001 	//	in das GridWindow, darum ist die folgende Abfrage nicht mehr noetig:
//STRIP001 #if 0
//STRIP001 	// merken, dass FilterBox geloescht wird, damit sichergestellt
//STRIP001 	// ist, dass in diesem Handler nicht an gleicher Stelle wieder
//STRIP001 	// eine neue geoeffnet wird.
//STRIP001 	BOOL	bWasFilterBox = ( pFilterBox != NULL &&
//STRIP001 								((Window*)pFilterBox)->IsVisible() &&
//STRIP001 								!pFilterBox->IsDataSelect() );
//STRIP001 	USHORT	nOldColFBox	  = bWasFilterBox ? pFilterBox->GetCol() : 0;
//STRIP001 	USHORT  nOldRowFBox	  = bWasFilterBox ? pFilterBox->GetRow() : 0;
//STRIP001 #endif
//STRIP001 
//STRIP001 	ClickExtern();	// loescht FilterBox, wenn vorhanden
//STRIP001 
//STRIP001 	HideNoteMarker();	// Notiz-Anzeige
//STRIP001 
//STRIP001 	bEEMouse = FALSE;
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	if (pScMod->IsModalMode(pViewData->GetSfxDocShell()))
//STRIP001 	{
//STRIP001 		Sound::Beep();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	pScActiveViewShell = pViewData->GetViewShell();			// falls auf Link geklickt wird
//STRIP001 	nScClickMouseModifier = rMEvt.GetModifier();			// um Control-Klick immer zu erkennen
//STRIP001 
//STRIP001 	BOOL bDetective = pViewData->GetViewShell()->IsAuditShell();
//STRIP001 	BOOL bRefMode =	pViewData->IsRefMode();					// Referenz angefangen
//STRIP001 	BOOL bFormulaMode = pScMod->IsFormulaMode();			// naechster Klick -> Referenz
//STRIP001 	BOOL bEditMode = pViewData->HasEditView(eWhich);		// auch bei Mode==SC_INPUT_TYPE
//STRIP001 
//STRIP001 	//	DeactivateIP passiert nur noch bei MarkListHasChanged
//STRIP001 
//STRIP001 	//	im GrabFocus Aufruf kann eine Fehlermeldung hochkommen
//STRIP001 	//	(z.B. beim Umbenennen von Tabellen per Tab-Reiter)
//STRIP001 
//STRIP001 	if (!nButtonDown)
//STRIP001 		nButtonDown = rMEvt.GetButtons();		// vorher, damit StopMarking klappt
//STRIP001 
//STRIP001 //	pViewData->GetViewShell()->GetViewFrame()->GetWindow().GrabFocus();
//STRIP001 	if ( ( bEditMode && pViewData->GetActivePart() == eWhich ) || !bFormulaMode )
//STRIP001 		GrabFocus();
//STRIP001 
//STRIP001 	if ( nMouseStatus == SC_GM_IGNORE )
//STRIP001 	{
//STRIP001 		nButtonDown = 0;
//STRIP001 		nMouseStatus = SC_GM_NONE;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bDetective )				// Detektiv-Fuell-Modus
//STRIP001 	{
//STRIP001 		if ( rMEvt.IsLeft() && !rMEvt.GetModifier() )
//STRIP001 		{
//STRIP001 			Point	aPos = rMEvt.GetPosPixel();
//STRIP001 			short	nPosX;
//STRIP001 			short	nPosY;
//STRIP001 			pViewData->GetPosFromPixel( aPos.X(), aPos.Y(), eWhich, nPosX, nPosY );
//STRIP001 
//STRIP001 			SfxInt16Item aPosXItem( SID_RANGE_COL, nPosX );
//STRIP001 			SfxInt16Item aPosYItem( SID_RANGE_ROW, nPosY );
//STRIP001 			pViewData->GetDispatcher().Execute( SID_FILL_SELECT, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD,
//STRIP001 										&aPosXItem, &aPosYItem, (void*)0L );
//STRIP001 
//STRIP001 		}
//STRIP001 		nButtonDown = 0;
//STRIP001 		nMouseStatus = SC_GM_NONE;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bDouble = (rMEvt.GetClicks() == 2);
//STRIP001 	if (!bDouble)
//STRIP001 		nMouseStatus = SC_GM_NONE;
//STRIP001 
//STRIP001 	if (!bFormulaMode)
//STRIP001 	{
//STRIP001 		if ( pViewData->GetActivePart() != eWhich )
//STRIP001 			pViewData->GetView()->ActivatePart( eWhich );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ScViewSelectionEngine* pSelEng = pViewData->GetView()->GetSelEngine();
//STRIP001 		pSelEng->SetWindow(this);
//STRIP001 		pSelEng->SetWhich(eWhich);
//STRIP001 		pSelEng->SetVisibleArea( Rectangle(Point(), GetOutputSizePixel()) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bEditMode && (pViewData->GetRefTabNo() == pViewData->GetTabNo()))
//STRIP001 	{
//STRIP001 		Point	aPos = rMEvt.GetPosPixel();
//STRIP001 		short	nPosX;
//STRIP001 		short	nPosY;
//STRIP001 		pViewData->GetPosFromPixel( aPos.X(), aPos.Y(), eWhich, nPosX, nPosY );
//STRIP001 
//STRIP001 		EditView*	pEditView;
//STRIP001 		USHORT		nEditCol;
//STRIP001 		USHORT		nEditRow;
//STRIP001 		pViewData->GetEditView( eWhich, pEditView, nEditCol, nEditRow );
//STRIP001 		USHORT nEndCol = pViewData->GetEditEndCol();
//STRIP001 		USHORT nEndRow = pViewData->GetEditEndRow();
//STRIP001 
//STRIP001 		if ( nPosX >= (short) nEditCol && nPosX <= (short) nEndCol &&
//STRIP001 			 nPosY >= (short) nEditRow && nPosY <= (short) nEndRow )
//STRIP001 		{
//STRIP001 			//	#53966# beim Klick in die Tabellen-EditView immer den Focus umsetzen
//STRIP001 			if (bFormulaMode)	// sonst ist es oben schon passiert
//STRIP001 				GrabFocus();
//STRIP001 
//STRIP001 			pScMod->SetInputMode( SC_INPUT_TABLE );
//STRIP001 			bEEMouse = TRUE;
//STRIP001 			bEditMode = pEditView->MouseButtonDown( rMEvt );
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pScMod->GetIsWaterCan())
//STRIP001 	{
//STRIP001 		//!		was is mit'm Mac ???
//STRIP001 		if ( rMEvt.GetModifier() + rMEvt.GetButtons() == MOUSE_RIGHT )
//STRIP001 		{
//STRIP001 			nMouseStatus = SC_GM_WATERUNDO;
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Reihenfolge passend zum angezeigten Cursor:
//STRIP001 	//	RangeFinder, AutoFill, PageBreak, Drawing
//STRIP001 
//STRIP001 	if ( HitRangeFinder( rMEvt.GetPosPixel(), bRFSize, &nRFIndex, &nRFAddX, &nRFAddY ) )
//STRIP001 	{
//STRIP001 		bRFMouse = TRUE;		// die anderen Variablen sind oben initialisiert
//STRIP001 
//STRIP001 		if ( pViewData->GetActivePart() != eWhich )
//STRIP001 			pViewData->GetView()->ActivatePart( eWhich );	//! schon oben immer ???
//STRIP001 
//STRIP001 		// CaptureMouse();
//STRIP001 		StartTracking();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bAutoFill = TestMouse( rMEvt, TRUE );
//STRIP001 	if (bAutoFill)
//STRIP001 		pScMod->InputEnterHandler();								// Autofill etc.
//STRIP001 
//STRIP001 	if (!bAutoFill)
//STRIP001 	{
//STRIP001 		nPagebreakMouse = HitPageBreak( rMEvt.GetPosPixel(), &aPagebreakSource,
//STRIP001 											&nPagebreakBreak, &nPagebreakPrev );
//STRIP001 		if (nPagebreakMouse)
//STRIP001 		{
//STRIP001 			bPagebreakDrawn = FALSE;
//STRIP001 			// CaptureMouse();
//STRIP001 			StartTracking();
//STRIP001 			PagebreakMove( rMEvt, FALSE );
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bFormulaMode && !bEditMode && rMEvt.IsLeft())
//STRIP001 	{
//STRIP001 		if ( !bAutoFill && DrawMouseButtonDown(rMEvt) )
//STRIP001 		{
//STRIP001 			//if (DrawHasMarkedObj())
//STRIP001 			//	pViewData->GetViewShell()->SetDrawShellOrSub();		// Draw-Objekt selektiert
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001 		pViewData->GetViewShell()->SetDrawShell( FALSE );				// kein Draw-Objekt selektiert
//STRIP001 
//STRIP001 		//	TestMouse schon oben passiert
//STRIP001 	}
//STRIP001 
//STRIP001 	Point aPos = rMEvt.GetPosPixel();
//STRIP001 	short nPosX;
//STRIP001 	short nPosY;
//STRIP001 	pViewData->GetPosFromPixel( aPos.X(), aPos.Y(), eWhich, nPosX, nPosY );
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 
//STRIP001 
//STRIP001 			//
//STRIP001 			//		Autofilter - Knoepfe
//STRIP001 			//
//STRIP001 
//STRIP001 	if ( !bDouble && !bFormulaMode )				//! auf rechte Taste abfragen ???
//STRIP001 	{
//STRIP001 		ScMergeFlagAttr* pAttr = (ScMergeFlagAttr*)
//STRIP001 									pDoc->GetAttr( nPosX, nPosY, nTab, ATTR_MERGE_FLAG );
//STRIP001 		if (pAttr->HasAutoFilter())
//STRIP001 		{
//STRIP001 			Point	aScrPos  = pViewData->GetScrPos(nPosX,nPosY,eWhich);
//STRIP001 			long	nSizeX;
//STRIP001 			long	nSizeY;
//STRIP001 			Point	aDiffPix = aPos;
//STRIP001 
//STRIP001 			aDiffPix -= aScrPos;
//STRIP001 			pViewData->GetMergeSizePixel( nPosX, nPosY, nSizeX, nSizeY );
//STRIP001 
//STRIP001 			//	Breite des Buttons ist nicht von der Zellhoehe abhaengig
//STRIP001 			Size aButSize = aComboButton.GetSizePixel();
//STRIP001 			long nButWidth  = Min( aButSize.Width(),  nSizeX );
//STRIP001 			long nButHeight = Min( aButSize.Height(), nSizeY );
//STRIP001 
//STRIP001 			if ( aDiffPix.X() >= nSizeX - nButWidth &&
//STRIP001 				 aDiffPix.Y() >= nSizeY - nButHeight )
//STRIP001 			{
//STRIP001 				BOOL  bFilterActive = IsAutoFilterActive( nPosX, nPosY,
//STRIP001 														  pViewData->GetTabNo() );
//STRIP001 
//STRIP001 				aComboButton.SetOptSizePixel();
//STRIP001                 DrawComboButton( aScrPos, nSizeX, nSizeY, bFilterActive, TRUE );
//STRIP001 
//STRIP001 #if 0
//STRIP001 				if (   bWasFilterBox
//STRIP001 					&& (short)nOldColFBox == nPosX
//STRIP001 					&& (short)nOldRowFBox == nPosY )
//STRIP001 				{
//STRIP001 					// Verhindern, dass an gleicher Stelle eine
//STRIP001 					// FilterBox geoeffnet wird, wenn diese gerade
//STRIP001 					// geloescht wurde
//STRIP001 
//STRIP001 					nMouseStatus = SC_GM_FILTER; // fuer ButtonDraw im MouseButtonUp();
//STRIP001 					return;
//STRIP001 				}
//STRIP001 #endif
//STRIP001 				DoAutoFilterMenue( nPosX, nPosY, FALSE );
//STRIP001 
//STRIP001 				return;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if (pAttr->HasButton())
//STRIP001 		{
//STRIP001 			DoPushButton( nPosX, nPosY, rMEvt );	// setzt evtl. bPivotMouse / bDPMouse
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 			//
//STRIP001 			//		Szenario-Auswahl
//STRIP001 			//
//STRIP001 
//STRIP001 	ScRange aScenRange;
//STRIP001 	if ( HasScenarioButton( aPos, aScenRange ) )
//STRIP001 	{
//STRIP001 		DoScenarioMenue( aScenRange );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 			//
//STRIP001 			//		Doppelklick angefangen ?
//STRIP001 			//
//STRIP001 
//STRIP001 	// StopMarking kann aus DrawMouseButtonDown gerufen werden
//STRIP001 
//STRIP001 	if ( nMouseStatus != SC_GM_IGNORE && !bRefMode )
//STRIP001 	{
//STRIP001 		if (bDouble)
//STRIP001 		{
//STRIP001 			if (nMouseStatus == SC_GM_TABDOWN)
//STRIP001 				nMouseStatus = SC_GM_DBLDOWN;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			nMouseStatus = SC_GM_TABDOWN;
//STRIP001 	}
//STRIP001 
//STRIP001 			//
//STRIP001 			//		Links in Edit-Zellen
//STRIP001 			//
//STRIP001 
//STRIP001 	BOOL bAlt = rMEvt.IsMod2();
//STRIP001 	if ( !bAlt && rMEvt.IsLeft() &&
//STRIP001 			GetEditUrl(rMEvt.GetPosPixel()) )			// Klick auf Link: Cursor nicht bewegen
//STRIP001 	{
//STRIP001 		SetPointer( Pointer( POINTER_REFHAND ) );
//STRIP001 		nMouseStatus = SC_GM_URLDOWN;					// auch nur dann beim ButtonUp ausfuehren
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 			//
//STRIP001 			//		Gridwin - SelectionEngine
//STRIP001 			//
//STRIP001 
//STRIP001 	if ( rMEvt.IsLeft() )
//STRIP001 	{
//STRIP001 		ScViewSelectionEngine* pSelEng = pViewData->GetView()->GetSelEngine();
//STRIP001 		pSelEng->SetWindow(this);
//STRIP001 		pSelEng->SetWhich(eWhich);
//STRIP001 		pSelEng->SetVisibleArea( Rectangle(Point(), GetOutputSizePixel()) );
//STRIP001 
//STRIP001 		//	SelMouseButtonDown an der View setzt noch das bMoveIsShift Flag
//STRIP001 		if ( pViewData->GetView()->SelMouseButtonDown( rMEvt ) )
//STRIP001 		{
//STRIP001 			if (IsMouseCaptured())
//STRIP001 			{
//STRIP001 				//	Tracking statt CaptureMouse, damit sauber abgebrochen werden kann
//STRIP001 				//!	Irgendwann sollte die SelectionEngine selber StartTracking rufen!?!
//STRIP001 				ReleaseMouse();
//STRIP001 				StartTracking();
//STRIP001 			}
//STRIP001 			pViewData->GetMarkData().SetMarking(TRUE);
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScGridWindow::MouseButtonUp( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	aCurMousePos = rMEvt.GetPosPixel();
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 
//STRIP001 	if (nButtonDown != rMEvt.GetButtons())
//STRIP001 		nMouseStatus = SC_GM_IGNORE;			// reset und return
//STRIP001 
//STRIP001 	nButtonDown = 0;
//STRIP001 
//STRIP001 	if (nMouseStatus == SC_GM_IGNORE)
//STRIP001 	{
//STRIP001 		nMouseStatus = SC_GM_NONE;
//STRIP001 										// Selection-Engine: Markieren abbrechen
//STRIP001 		pViewData->GetView()->GetSelEngine()->Reset();
//STRIP001 		rMark.SetMarking(FALSE);
//STRIP001 		if (pViewData->IsAnyFillMode())
//STRIP001 		{
//STRIP001 			pViewData->GetView()->StopRefMode();
//STRIP001 			pViewData->ResetFillMode();
//STRIP001 		}
//STRIP001 		StopMarking();
//STRIP001 		DrawEndAction();				// Markieren/Verschieben auf Drawing-Layer abbrechen
//STRIP001 		ReleaseMouse();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nMouseStatus == SC_GM_FILTER)
//STRIP001 	{
//STRIP001 		if ( pFilterBox && pFilterBox->GetMode() == SC_FILTERBOX_FILTER )
//STRIP001 		{
//STRIP001 			HideCursor();
//STRIP001 			aComboButton.Draw( FALSE );
//STRIP001 			ShowCursor();
//STRIP001 		}
//STRIP001 		nMouseStatus = SC_GM_NONE;
//STRIP001 		ReleaseMouse();
//STRIP001 		return;							// da muss nix mehr passieren
//STRIP001 	}
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	if (pScMod->IsModalMode(pViewData->GetSfxDocShell()))
//STRIP001 		return;
//STRIP001 
//STRIP001 	SfxBindings& rBindings = pViewData->GetBindings();
//STRIP001 	if (bEEMouse)
//STRIP001 	{
//STRIP001 		EditView*	pEditView;
//STRIP001 		USHORT		nEditCol;
//STRIP001 		USHORT		nEditRow;
//STRIP001 		pViewData->GetEditView( eWhich, pEditView, nEditCol, nEditRow );
//STRIP001 		pEditView->MouseButtonUp( rMEvt );
//STRIP001 
//STRIP001 		if ( rMEvt.IsMiddle() &&
//STRIP001 	         	GetSettings().GetMouseSettings().GetMiddleButtonAction() == MOUSE_MIDDLE_PASTESELECTION )
//STRIP001 	    {
//STRIP001 	    	//	EditView may have pasted from selection
//STRIP001 	    	pScMod->InputChanged( pEditView );
//STRIP001 	    }
//STRIP001 		else
//STRIP001 			pScMod->InputSelection( pEditView );			// parentheses etc.
//STRIP001 
//STRIP001 		pViewData->GetView()->InvalidateAttribs();
//STRIP001 		rBindings.Invalidate( SID_HYPERLINK_GETLINK );
//STRIP001 		bEEMouse = FALSE;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bPivotMouse)
//STRIP001 	{
//STRIP001 		PivotMouseButtonUp( rMEvt );
//STRIP001 		bPivotMouse = FALSE;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bDPMouse)
//STRIP001 	{
//STRIP001 		DPMouseButtonUp( rMEvt );		// resets bDPMouse
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bRFMouse)
//STRIP001 	{
//STRIP001 		RFMouseMove( rMEvt, TRUE );		// Range wieder richtigherum
//STRIP001 		bRFMouse = FALSE;
//STRIP001 		SetPointer( Pointer( POINTER_ARROW ) );
//STRIP001 		ReleaseMouse();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nPagebreakMouse)
//STRIP001 	{
//STRIP001 		PagebreakMove( rMEvt, TRUE );
//STRIP001 		nPagebreakMouse = SC_PD_NONE;
//STRIP001 		SetPointer( Pointer( POINTER_ARROW ) );
//STRIP001 		ReleaseMouse();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nMouseStatus == SC_GM_WATERUNDO)	// Undo im Giesskannenmodus
//STRIP001 	{
//STRIP001 		SfxUndoManager* pMgr = pViewData->GetDocShell()->GetUndoManager();
//STRIP001 		if ( pMgr->GetUndoActionCount() && pMgr->GetUndoActionId() == STR_UNDO_APPLYCELLSTYLE )
//STRIP001 			pMgr->Undo();
//STRIP001 		else
//STRIP001 			Sound::Beep();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (DrawMouseButtonUp(rMEvt))
//STRIP001 		return;
//STRIP001 
//STRIP001 	rMark.SetMarking(FALSE);
//STRIP001 
//STRIP001 	SetPointer( Pointer( POINTER_ARROW ) );
//STRIP001 
//STRIP001 	if (pViewData->IsFillMode() ||
//STRIP001 		( pViewData->GetFillMode() == SC_FILL_MATRIX && rMEvt.IsMod1() ))
//STRIP001 	{
//STRIP001 		nScFillModeMouseModifier = rMEvt.GetModifier();
//STRIP001 		USHORT nStartCol;
//STRIP001 		USHORT nStartRow;
//STRIP001 		USHORT nEndCol;
//STRIP001 		USHORT nEndRow;
//STRIP001 		pViewData->GetFillData( nStartCol, nStartRow, nEndCol, nEndRow );
//STRIP001 //		DBG_ASSERT( nStartCol==pViewData->GetRefStartX() && nStartRow==pViewData->GetRefStartY(),
//STRIP001 //								"Block falsch fuer AutoFill" );
//STRIP001 		ScRange aDelRange;
//STRIP001 		BOOL bIsDel = pViewData->GetDelMark( aDelRange );
//STRIP001 
//STRIP001 		ScViewFunc* pView = pViewData->GetView();
//STRIP001 		pView->StopRefMode();
//STRIP001 		pViewData->ResetFillMode();
//STRIP001 		pView->GetFunctionSet()->SetAnchorFlag( FALSE );	// #i5819# don't use AutoFill anchor flag for selection
//STRIP001 
//STRIP001 		if ( bIsDel )
//STRIP001 		{
//STRIP001 			pView->MarkRange( aDelRange, FALSE );
//STRIP001 			pView->DeleteContents( IDF_CONTENTS );
//STRIP001 			USHORT nTab = pViewData->GetTabNo();
//STRIP001 			ScRange aBlockRange( nStartCol, nStartRow, nTab, nEndCol, nEndRow, nTab );
//STRIP001 			if ( aBlockRange != aDelRange )
//STRIP001 			{
//STRIP001 				if ( aDelRange.aStart.Row() == nStartRow )
//STRIP001 					aBlockRange.aEnd.SetCol( aDelRange.aStart.Col() - 1 );
//STRIP001 				else
//STRIP001 					aBlockRange.aEnd.SetRow( aDelRange.aStart.Row() - 1 );
//STRIP001 				pView->MarkRange( aBlockRange, FALSE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pViewData->GetDispatcher().Execute( FID_FILL_AUTO, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD );
//STRIP001 	}
//STRIP001 	else if (pViewData->GetFillMode() == SC_FILL_MATRIX)
//STRIP001 	{
//STRIP001 		USHORT nTab = pViewData->GetTabNo();
//STRIP001 		USHORT nStartCol;
//STRIP001 		USHORT nStartRow;
//STRIP001 		USHORT nEndCol;
//STRIP001 		USHORT nEndRow;
//STRIP001 		pViewData->GetFillData( nStartCol, nStartRow, nEndCol, nEndRow );
//STRIP001 		ScRange aBlockRange( nStartCol, nStartRow, nTab, nEndCol, nEndRow, nTab );
//STRIP001 		USHORT nFillCol = pViewData->GetRefEndX();
//STRIP001 		USHORT nFillRow = pViewData->GetRefEndY();
//STRIP001 		ScAddress aEndPos( nFillCol, nFillRow, nTab );
//STRIP001 
//STRIP001 		ScTabView* pView = pViewData->GetView();
//STRIP001 		pView->StopRefMode();
//STRIP001 		pViewData->ResetFillMode();
//STRIP001 		pView->GetFunctionSet()->SetAnchorFlag( FALSE );
//STRIP001 
//STRIP001 		if ( aEndPos != aBlockRange.aEnd )
//STRIP001 		{
//STRIP001 			pViewData->GetDocShell()->GetDocFunc().ResizeMatrix( aBlockRange, aEndPos, FALSE );
//STRIP001 			pViewData->GetView()->MarkRange( ScRange( aBlockRange.aStart, aEndPos ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if (pViewData->IsAnyFillMode())
//STRIP001 	{
//STRIP001 												// Embedded-Area has been changed
//STRIP001 		ScTabView* pView = pViewData->GetView();
//STRIP001 		pView->StopRefMode();
//STRIP001 		pViewData->ResetFillMode();
//STRIP001 		pView->GetFunctionSet()->SetAnchorFlag( FALSE );
//STRIP001 		pViewData->GetDocShell()->UpdateOle(pViewData);
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bRefMode =	pViewData->IsRefMode();
//STRIP001 	if (bRefMode)
//STRIP001 		pScMod->EndReference();
//STRIP001 
//STRIP001 		//
//STRIP001 		//	Giesskannen-Modus (Gestalter)
//STRIP001 		//
//STRIP001 
//STRIP001 	if (pScMod->GetIsWaterCan())
//STRIP001 	{
//STRIP001 		//	Abfrage auf Undo schon oben
//STRIP001 
//STRIP001 		ScStyleSheetPool* pStylePool = (ScStyleSheetPool*)
//STRIP001 									   (pViewData->GetDocument()->
//STRIP001 											GetStyleSheetPool());
//STRIP001 		if ( pStylePool )
//STRIP001 		{
//STRIP001 			SfxStyleSheet* pStyleSheet = (SfxStyleSheet*)
//STRIP001 										 pStylePool->GetActualStyleSheet();
//STRIP001 
//STRIP001 			if ( pStyleSheet )
//STRIP001 			{
//STRIP001 				SfxStyleFamily eFamily = pStyleSheet->GetFamily();
//STRIP001 
//STRIP001 				switch ( eFamily )
//STRIP001 				{
//STRIP001 					case SFX_STYLE_FAMILY_PARA:
//STRIP001 						pViewData->GetView()->SetStyleSheetToMarked( pStyleSheet );
//STRIP001 						pViewData->GetView()->DoneBlockMode();
//STRIP001 						break;
//STRIP001 
//STRIP001 					case SFX_STYLE_FAMILY_PAGE:
//STRIP001 						pViewData->GetDocument()->SetPageStyle( pViewData->GetTabNo(),
//STRIP001 																pStyleSheet->GetName() );
//STRIP001 
//STRIP001 						ScPrintFunc( pViewData->GetDocShell(),
//STRIP001 									 pViewData->GetViewShell()->GetPrinter(),
//STRIP001 									 pViewData->GetTabNo() ).UpdatePages();
//STRIP001 
//STRIP001 						rBindings.Invalidate( SID_STATUS_PAGESTYLE );
//STRIP001 						break;
//STRIP001 
//STRIP001 					default:
//STRIP001 						break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 			//
//STRIP001 			//		double click (only left button)
//STRIP001 			//
//STRIP001 
//STRIP001 	BOOL bDouble = ( rMEvt.GetClicks() == 2 && rMEvt.IsLeft() );
//STRIP001 	if ( bDouble && !bRefMode && nMouseStatus == SC_GM_DBLDOWN && !pScMod->IsRefDialogOpen() )
//STRIP001 	{
//STRIP001 		//	data pilot table
//STRIP001 		Point aPos = rMEvt.GetPosPixel();
//STRIP001 		short nPosX, nPosY;
//STRIP001 		pViewData->GetPosFromPixel( aPos.X(), aPos.Y(), eWhich, nPosX, nPosY );
//STRIP001 		ScDPObject*	pDPObj	= pDoc->GetDPAtCursor( nPosX, nPosY, pViewData->GetTabNo() );
//STRIP001 		if (pDPObj)
//STRIP001 		{
//STRIP001 			ScAddress aPos( nPosX, nPosY, pViewData->GetTabNo() );
//STRIP001 			ScDPPositionData aData;
//STRIP001 			pDPObj->GetPositionData( aData, aPos );
//STRIP001 
//STRIP001 			if ( ( aData.nFlags & sheet::MemberResultFlags::HASMEMBER ) &&
//STRIP001 				 ! ( aData.nFlags & sheet::MemberResultFlags::SUBTOTAL ) )
//STRIP001 			{
//STRIP001 				ScDPObject aNewObj( *pDPObj );
//STRIP001 				pDPObj->ToggleDetails( aData, &aNewObj );
//STRIP001 				ScDBDocFunc aFunc( *pViewData->GetDocShell() );
//STRIP001 				aFunc.DataPilotUpdate( pDPObj, &aNewObj, TRUE, FALSE );
//STRIP001 				pViewData->GetView()->CursorPosChanged();		// shells may be switched
//STRIP001 			}
//STRIP001 			else
//STRIP001 				Sound::Beep();		// nothing to expand/collapse
//STRIP001 
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001 		//	edit cell contents
//STRIP001 		pViewData->GetViewShell()->UpdateInputHandler();
//STRIP001 		pScMod->SetInputMode( SC_INPUT_TABLE );
//STRIP001 		if (pViewData->HasEditView(eWhich))
//STRIP001 		{
//STRIP001 			//	Text-Cursor gleich an die geklickte Stelle setzen
//STRIP001 			EditView* pEditView = pViewData->GetEditView( eWhich );
//STRIP001 			MouseEvent aEditEvt( rMEvt.GetPosPixel(), 1, MOUSE_SYNTHETIC, MOUSE_LEFT, 0 );
//STRIP001 			pEditView->MouseButtonDown( aEditEvt );
//STRIP001 			pEditView->MouseButtonUp( aEditEvt );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 			//
//STRIP001 			//		Links in Edit-Zellen
//STRIP001 			//
//STRIP001 
//STRIP001 	BOOL bAlt = rMEvt.IsMod2();
//STRIP001 	if ( !bAlt && !bRefMode && !bDouble && nMouseStatus == SC_GM_URLDOWN )
//STRIP001 	{
//STRIP001 		//	beim ButtonUp nur ausfuehren, wenn ButtonDown auch ueber einer URL war
//STRIP001 
//STRIP001 		String aName, aUrl, aTarget;
//STRIP001 		if ( GetEditUrl( rMEvt.GetPosPixel(), &aName, &aUrl, &aTarget ) )
//STRIP001 		{
//STRIP001 			nMouseStatus = SC_GM_NONE;				// keinen Doppelklick anfangen
//STRIP001 			ScGlobal::OpenURL( aUrl, aTarget );
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 			//
//STRIP001 			//		Gridwin - SelectionEngine
//STRIP001 			//
//STRIP001 
//STRIP001 	//	SelMouseButtonDown is called only for left button, but SelMouseButtonUp would return
//STRIP001 	//	TRUE for any call, so IsLeft must be checked here, too.
//STRIP001 
//STRIP001 	if ( rMEvt.IsLeft() && pViewData->GetView()->GetSelEngine()->SelMouseButtonUp( rMEvt ) )
//STRIP001 	{
//STRIP001 //		rMark.MarkToSimple();
//STRIP001 		pViewData->GetView()->UpdateAutoFillMark();
//STRIP001 
//STRIP001 		SfxDispatcher* pDisp = pViewData->GetViewShell()->GetDispatcher();
//STRIP001 		BOOL bRefMode = pScMod->IsFormulaMode();
//STRIP001 		DBG_ASSERT( pDisp || bRefMode, "Cursor auf nicht aktiver View bewegen ?" );
//STRIP001 
//STRIP001 		//	#i14927# execute SID_CURRENTCELL (for macro recording) only if there is no
//STRIP001 		//	multiple selection, so the argument string completely describes the selection,
//STRIP001 		//	and executing the slot won't change the existing selection (executing the slot
//STRIP001 		//	here and from a recorded macro is treated equally)
//STRIP001 
//STRIP001 		if ( pDisp && !bRefMode && !rMark.IsMultiMarked() )
//STRIP001 		{
//STRIP001 			String aAddr;								// CurrentCell
//STRIP001 			if( rMark.IsMarked() )
//STRIP001 			{
//STRIP001 //				BOOL bKeep = rMark.IsMultiMarked();		//! wohin damit ???
//STRIP001 
//STRIP001 				ScRange aScRange;
//STRIP001 				rMark.GetMarkArea( aScRange );
//STRIP001 				aScRange.Format( aAddr, SCR_ABS );
//STRIP001 				if ( aScRange.aStart == aScRange.aEnd )
//STRIP001 				{
//STRIP001 					//	make sure there is a range selection string even for a single cell
//STRIP001 					String aSingle = aAddr;
//STRIP001 					aAddr.Append( (sal_Char) ':' );
//STRIP001 					aAddr.Append( aSingle );
//STRIP001 				}
//STRIP001 
//STRIP001 				//!	SID_MARKAREA gibts nicht mehr ???
//STRIP001 				//!	was passiert beim Markieren mit dem Cursor ???
//STRIP001 			}
//STRIP001 			else										// nur Cursor bewegen
//STRIP001 			{
//STRIP001 				ScAddress aScAddress( pViewData->GetCurX(), pViewData->GetCurY(), 0 );
//STRIP001 				aScAddress.Format( aAddr, SCA_ABS );
//STRIP001 			}
//STRIP001 
//STRIP001 			SfxStringItem aPosItem( SID_CURRENTCELL, aAddr );
//STRIP001 			pDisp->Execute( SID_CURRENTCELL, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD,
//STRIP001 										&aPosItem, (void*)0L );
//STRIP001 
//STRIP001 			pViewData->GetView()->InvalidateAttribs();
//STRIP001 		}
//STRIP001 		return;
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScGridWindow::FakeButtonUp()
//STRIP001 {
//STRIP001 	if ( nButtonDown )
//STRIP001 	{
//STRIP001 		MouseEvent aEvent( aCurMousePos );		// nButtons = 0 -> ignore
//STRIP001 		MouseButtonUp( aEvent );
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScGridWindow::MouseMove( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	aCurMousePos = rMEvt.GetPosPixel();
//STRIP001 
//STRIP001 	if ( rMEvt.IsLeaveWindow() && pNoteMarker && !pNoteMarker->IsByKeyboard() )
//STRIP001 		HideNoteMarker();
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	if (pScMod->IsModalMode(pViewData->GetSfxDocShell()))
//STRIP001 		return;
//STRIP001 
//STRIP001 		//	Ob aus dem Edit-Modus Drag&Drop gestartet wurde, bekommt man leider
//STRIP001 		//	nicht anders mit:
//STRIP001 
//STRIP001 	if (bEEMouse && nButtonDown && !rMEvt.GetButtons())
//STRIP001 	{
//STRIP001 		bEEMouse = FALSE;
//STRIP001 		nButtonDown = 0;
//STRIP001 		nMouseStatus = SC_GM_NONE;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nMouseStatus == SC_GM_IGNORE)
//STRIP001 		return;
//STRIP001 
//STRIP001 	if (nMouseStatus == SC_GM_WATERUNDO)	// Undo im Giesskannenmodus -> nur auf Up warten
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( pViewData->GetViewShell()->IsAuditShell() )		// Detektiv-Fuell-Modus
//STRIP001 	{
//STRIP001 		SetPointer( Pointer( POINTER_FILL ) );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nMouseStatus == SC_GM_FILTER && pFilterBox)
//STRIP001 	{
//STRIP001 		Point aRelPos = pFilterBox->ScreenToOutputPixel( OutputToScreenPixel( rMEvt.GetPosPixel() ) );
//STRIP001 		if ( Rectangle(Point(),pFilterBox->GetOutputSizePixel()).IsInside(aRelPos) )
//STRIP001 		{
//STRIP001 			nButtonDown = 0;
//STRIP001 			nMouseStatus = SC_GM_NONE;
//STRIP001 			if ( pFilterBox->GetMode() == SC_FILTERBOX_FILTER )
//STRIP001 			{
//STRIP001 				HideCursor();
//STRIP001 				aComboButton.Draw( FALSE );
//STRIP001 				ShowCursor();
//STRIP001 			}
//STRIP001 			ReleaseMouse();
//STRIP001 			pFilterBox->MouseButtonDown( MouseEvent( aRelPos, 1, MOUSE_SIMPLECLICK, MOUSE_LEFT ) );
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bRefMode =	pViewData->IsRefMode();					// Referenz angefangen
//STRIP001 	BOOL bFormulaMode = pScMod->IsFormulaMode();			// naechster Klick -> Referenz
//STRIP001 
//STRIP001 	if (bEEMouse)
//STRIP001 	{
//STRIP001 		EditView*	pEditView;
//STRIP001 		USHORT		nEditCol;
//STRIP001 		USHORT		nEditRow;
//STRIP001 		pViewData->GetEditView( eWhich, pEditView, nEditCol, nEditRow );
//STRIP001 		pEditView->MouseMove( rMEvt );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bPivotMouse)
//STRIP001 	{
//STRIP001 		PivotMouseMove( rMEvt );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bDPMouse)
//STRIP001 	{
//STRIP001 		DPMouseMove( rMEvt );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bRFMouse)
//STRIP001 	{
//STRIP001 		RFMouseMove( rMEvt, FALSE );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nPagebreakMouse)
//STRIP001 	{
//STRIP001 		PagebreakMove( rMEvt, FALSE );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	anderen Mauszeiger anzeigen?
//STRIP001 
//STRIP001 	BOOL bEditMode = pViewData->HasEditView(eWhich);
//STRIP001 
//STRIP001 					//! Testen ob RefMode-Dragging !!!
//STRIP001 	if ( bEditMode && (pViewData->GetRefTabNo() == pViewData->GetTabNo()) )
//STRIP001 	{
//STRIP001 		Point	aPos = rMEvt.GetPosPixel();
//STRIP001 		short	nPosX;
//STRIP001 		short	nPosY;
//STRIP001 		pViewData->GetPosFromPixel( aPos.X(), aPos.Y(), eWhich, nPosX, nPosY );
//STRIP001 
//STRIP001 		EditView*	pEditView;
//STRIP001 		USHORT		nEditCol;
//STRIP001 		USHORT		nEditRow;
//STRIP001 		pViewData->GetEditView( eWhich, pEditView, nEditCol, nEditRow );
//STRIP001 		USHORT nEndCol = pViewData->GetEditEndCol();
//STRIP001 		USHORT nEndRow = pViewData->GetEditEndRow();
//STRIP001 
//STRIP001 		if ( nPosX >= (short) nEditCol && nPosX <= (short) nEndCol &&
//STRIP001 			 nPosY >= (short) nEditRow && nPosY <= (short) nEndRow )
//STRIP001 		{
//STRIP001 			//	Field can only be URL field
//STRIP001 			BOOL bAlt = rMEvt.IsMod2();
//STRIP001 			if ( !bAlt && !nButtonDown && pEditView && pEditView->GetFieldUnderMousePointer() )
//STRIP001 				SetPointer( Pointer( POINTER_REFHAND ) );
//STRIP001 			else if ( pEditView && pEditView->GetEditEngine()->IsVertical() )
//STRIP001 				SetPointer( Pointer( POINTER_TEXT_VERTICAL ) );
//STRIP001 			else
//STRIP001 				SetPointer( Pointer( POINTER_TEXT ) );
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bWater = SC_MOD()->GetIsWaterCan();
//STRIP001 	if (bWater)
//STRIP001 		SetPointer( Pointer(POINTER_FILL) );
//STRIP001 
//STRIP001 	if (!bWater)
//STRIP001 	{
//STRIP001 		BOOL bCross = FALSE;
//STRIP001 
//STRIP001 		//	Range-Finder
//STRIP001 
//STRIP001 		BOOL bCorner;
//STRIP001 		if ( HitRangeFinder( rMEvt.GetPosPixel(), bCorner ) )
//STRIP001 		{
//STRIP001 			if (bCorner)
//STRIP001 				SetPointer( Pointer( POINTER_CROSS ) );
//STRIP001 			else
//STRIP001 				SetPointer( Pointer( POINTER_HAND ) );
//STRIP001 			bCross = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		//	Page-Break-Modus
//STRIP001 
//STRIP001 		USHORT nBreakType;
//STRIP001 		if ( !nButtonDown && pViewData->IsPagebreakMode() &&
//STRIP001 				( nBreakType = HitPageBreak( rMEvt.GetPosPixel() ) ) )
//STRIP001 		{
//STRIP001 			PointerStyle eNew = POINTER_ARROW;
//STRIP001 			switch ( nBreakType )
//STRIP001 			{
//STRIP001 				case SC_PD_RANGE_L:
//STRIP001 				case SC_PD_RANGE_R:
//STRIP001 				case SC_PD_BREAK_H:
//STRIP001 					eNew = POINTER_ESIZE;
//STRIP001 					break;
//STRIP001 				case SC_PD_RANGE_T:
//STRIP001 				case SC_PD_RANGE_B:
//STRIP001 				case SC_PD_BREAK_V:
//STRIP001 					eNew = POINTER_SSIZE;
//STRIP001 					break;
//STRIP001 				case SC_PD_RANGE_TL:
//STRIP001 				case SC_PD_RANGE_BR:
//STRIP001 					eNew = POINTER_SESIZE;
//STRIP001 					break;
//STRIP001 				case SC_PD_RANGE_TR:
//STRIP001 				case SC_PD_RANGE_BL:
//STRIP001 					eNew = POINTER_NESIZE;
//STRIP001 					break;
//STRIP001 			}
//STRIP001 			SetPointer( Pointer( eNew ) );
//STRIP001 			bCross = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		//	Fill-Cursor anzeigen ?
//STRIP001 
//STRIP001 		if ( !bFormulaMode && !nButtonDown )
//STRIP001 			if (TestMouse( rMEvt, FALSE ))
//STRIP001 				bCross = TRUE;
//STRIP001 
//STRIP001 		if ( nButtonDown && pViewData->IsAnyFillMode() )
//STRIP001 		{
//STRIP001 			SetPointer( Pointer( POINTER_CROSS ) );
//STRIP001 			bCross = TRUE;
//STRIP001 			nScFillModeMouseModifier = rMEvt.GetModifier();	// ausgewertet bei AutoFill und Matrix
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!bCross)
//STRIP001 		{
//STRIP001 			BOOL bAlt = rMEvt.IsMod2();
//STRIP001 
//STRIP001 			if (bEditMode)									// Edit-Mode muss zuerst kommen!
//STRIP001 				SetPointer( Pointer( POINTER_ARROW ) );
//STRIP001 			else if ( !bAlt && !nButtonDown &&
//STRIP001 						GetEditUrl(rMEvt.GetPosPixel()) )
//STRIP001 				SetPointer( Pointer( POINTER_REFHAND ) );
//STRIP001 			else if ( DrawMouseMove(rMEvt) )				// setzt Pointer um
//STRIP001 				return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pViewData->GetView()->GetSelEngine()->SelMouseMove( rMEvt ) )
//STRIP001 		return;
//STRIP001 }

//STRIP001 void ScGridWindow::Tracking( const TrackingEvent& rTEvt )
//STRIP001 {
//STRIP001 	//	Weil die SelectionEngine kein Tracking kennt, die Events nur auf
//STRIP001 	//	die verschiedenen MouseHandler verteilen...
//STRIP001 
//STRIP001 	const MouseEvent& rMEvt = rTEvt.GetMouseEvent();
//STRIP001 
//STRIP001 	if ( rTEvt.IsTrackingCanceled() )		// alles abbrechen...
//STRIP001 	{
//STRIP001 		if (!pViewData->GetView()->IsInActivatePart())
//STRIP001 		{
//STRIP001 			if (bPivotMouse)
//STRIP001 				bPivotMouse = FALSE;			// gezeichnet wird per bDragRect
//STRIP001 			if (bDPMouse)
//STRIP001 				bDPMouse = FALSE;				// gezeichnet wird per bDragRect
//STRIP001 			if (bDragRect)
//STRIP001 			{
//STRIP001 				pViewData->GetView()->DrawDragRect( nDragStartX, nDragStartY, nDragEndX, nDragEndY, eWhich );
//STRIP001 				bDragRect = FALSE;
//STRIP001 			}
//STRIP001 			if (bRFMouse)
//STRIP001 			{
//STRIP001 				RFMouseMove( rMEvt, TRUE );		// richtig abbrechen geht dabei nicht...
//STRIP001 				bRFMouse = FALSE;
//STRIP001 			}
//STRIP001 			if (nPagebreakMouse)
//STRIP001 			{
//STRIP001 				if (bPagebreakDrawn)
//STRIP001 					DrawDragRect( aPagebreakDrag.aStart.Col(), aPagebreakDrag.aStart.Row(),
//STRIP001 									aPagebreakDrag.aEnd.Col(), aPagebreakDrag.aEnd.Row(), FALSE );
//STRIP001 				bPagebreakDrawn = FALSE;
//STRIP001 				nPagebreakMouse = SC_PD_NONE;
//STRIP001 			}
//STRIP001 
//STRIP001 			SetPointer( Pointer( POINTER_ARROW ) );
//STRIP001 			StopMarking();
//STRIP001 			MouseButtonUp( rMEvt );		// mit Status SC_GM_IGNORE aus StopMarking
//STRIP001 
//STRIP001 			BOOL bRefMode =	pViewData->IsRefMode();
//STRIP001 			if (bRefMode)
//STRIP001 				SC_MOD()->EndReference();		// #63148# Dialog nicht verkleinert lassen
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( rTEvt.IsTrackingEnded() )
//STRIP001 	{
//STRIP001 		//	MouseButtonUp immer mit passenden Buttons (z.B. wegen Testtool, #63148#)
//STRIP001 		//	Schliesslich behauptet der Tracking-Event ja, dass normal beendet und nicht
//STRIP001 		//	abgebrochen wurde.
//STRIP001 
//STRIP001 		MouseEvent aUpEvt( rMEvt.GetPosPixel(), rMEvt.GetClicks(),
//STRIP001 							rMEvt.GetMode(), nButtonDown, rMEvt.GetModifier() );
//STRIP001 		MouseButtonUp( aUpEvt );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		MouseMove( rMEvt );
//STRIP001 }

//STRIP001 void ScGridWindow::StartDrag( sal_Int8 nAction, const Point& rPosPixel )
//STRIP001 {
//STRIP001 	if ( pFilterBox || nPagebreakMouse )
//STRIP001 		return;
//STRIP001 
//STRIP001 	HideNoteMarker();
//STRIP001 
//STRIP001 	::com::mandEvent aDragEvent( rPosPixel, COMMAND_STARTDRAG, TRUE );
//STRIP001 
//STRIP001 	if (bEEMouse)
//STRIP001 	{
//STRIP001 		EditView*	pEditView;
//STRIP001 		USHORT		nEditCol;
//STRIP001 		USHORT		nEditRow;
//STRIP001 		pViewData->GetEditView( eWhich, pEditView, nEditCol, nEditRow );
//STRIP001 
//STRIP001 		// #63263# don't remove the edit view while switching views
//STRIP001 		ScModule* pScMod = SC_MOD();
//STRIP001 		pScMod->SetInEditCommand( TRUE );
//STRIP001 
//STRIP001 		pEditView->Command( aDragEvent );
//STRIP001 
//STRIP001 		ScInputHandler* pHdl = pScMod->GetInputHdl();
//STRIP001 		if (pHdl)
//STRIP001 			pHdl->DataChanged();
//STRIP001 
//STRIP001 		pScMod->SetInEditCommand( FALSE );
//STRIP001 		if (!pViewData->IsActive())				// dropped to different view?
//STRIP001 		{
//STRIP001 			ScInputHandler* pHdl = pScMod->GetInputHdl( pViewData->GetViewShell() );
//STRIP001 			if ( pHdl && pViewData->HasEditView( eWhich ) )
//STRIP001 			{
//STRIP001 				pHdl->CancelHandler();
//STRIP001 				ShowCursor();	// missing from KillEditView
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		if ( !DrawCommand(aDragEvent) )
//STRIP001 			pViewData->GetView()->GetSelEngine()->Command( aDragEvent );
//STRIP001 }

//STRIP001 void lcl_SetTextCursorPos( ScViewData* pViewData, ScSplitPos eWhich, Window* pWin )
//STRIP001 {
//STRIP001 	USHORT nCol = pViewData->GetCurX();
//STRIP001 	USHORT nRow = pViewData->GetCurY();
//STRIP001 	Rectangle aEditArea = pViewData->GetEditArea( eWhich, nCol, nRow, pWin, NULL, TRUE );
//STRIP001 	aEditArea.Right() = aEditArea.Left();
//STRIP001 	aEditArea = pWin->PixelToLogic( aEditArea );
//STRIP001 	pWin->SetCursorRect( &aEditArea );
//STRIP001 }

//STRIP001 void __EXPORT ScGridWindow::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	USHORT nCmd = rCEvt.GetCommand();
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	DBG_ASSERT( nCmd != COMMAND_STARTDRAG, "ScGridWindow::Command called with COMMAND_STARTDRAG" );
//STRIP001 
//STRIP001 	if ( nCmd == COMMAND_STARTEXTTEXTINPUT ||
//STRIP001 		 nCmd == COMMAND_ENDEXTTEXTINPUT ||
//STRIP001 		 nCmd == COMMAND_EXTTEXTINPUT ||
//STRIP001 		 nCmd == COMMAND_CURSORPOS )
//STRIP001 	{
//STRIP001 		BOOL bEditView = pViewData->HasEditView( eWhich );
//STRIP001 		if (!bEditView)
//STRIP001 		{
//STRIP001 			//	only if no cell editview is active, look at drawview
//STRIP001 			SdrView* pSdrView = pViewData->GetView()->GetSdrView();
//STRIP001 			if ( pSdrView )
//STRIP001 			{
//STRIP001 				OutlinerView* pOlView = pSdrView->GetTextEditOutlinerView();
//STRIP001 				if ( pOlView && pOlView->GetWindow() == this )
//STRIP001 				{
//STRIP001 					pOlView->Command( rCEvt );
//STRIP001 					return;								// done
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nCmd == COMMAND_CURSORPOS && !bEditView )
//STRIP001 		{
//STRIP001 			//	#88458# CURSORPOS may be called without following text input,
//STRIP001 			//	to set the input method window position
//STRIP001 			//	-> input mode must not be started,
//STRIP001 			//	manually calculate text insert position if not in input mode
//STRIP001 
//STRIP001 			lcl_SetTextCursorPos( pViewData, eWhich, this );
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001 		ScInputHandler* pHdl = pScMod->GetInputHdl( pViewData->GetViewShell() );
//STRIP001 		if ( pHdl )
//STRIP001 		{
//STRIP001 			pHdl->InputCommand( rCEvt, TRUE );
//STRIP001 			return;										// done
//STRIP001 		}
//STRIP001 
//STRIP001 		Window::Command( rCEvt );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nCmd == COMMAND_VOICE )
//STRIP001 	{
//STRIP001 		//	Der Handler wird nur gerufen, wenn ein Text-Cursor aktiv ist,
//STRIP001 		//	also muss es eine EditView oder ein editiertes Zeichenobjekt geben
//STRIP001 
//STRIP001 		ScInputHandler* pHdl = pScMod->GetInputHdl( pViewData->GetViewShell() );
//STRIP001 		if ( pHdl && pViewData->HasEditView( eWhich ) )
//STRIP001 		{
//STRIP001 			EditView* pEditView = pViewData->GetEditView( eWhich );	// ist dann nicht 0
//STRIP001 			pHdl->DataChanging();
//STRIP001 			pEditView->Command( rCEvt );
//STRIP001 			pHdl->DataChanged();
//STRIP001 			return;										// erledigt
//STRIP001 		}
//STRIP001 		SdrView* pSdrView = pViewData->GetView()->GetSdrView();
//STRIP001 		if ( pSdrView )
//STRIP001 		{
//STRIP001 			OutlinerView* pOlView = pSdrView->GetTextEditOutlinerView();
//STRIP001 			if ( pOlView && pOlView->GetWindow() == this )
//STRIP001 			{
//STRIP001 				pOlView->Command( rCEvt );
//STRIP001 				return;									// erledigt
//STRIP001 			}
//STRIP001 		}
//STRIP001 		Window::Command(rCEvt);		//	sonst soll sich die Basisklasse drum kuemmern...
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nCmd == COMMAND_PASTESELECTION )
//STRIP001 	{
//STRIP001 		if ( bEEMouse )
//STRIP001 		{
//STRIP001 			//	EditEngine handles selection in MouseButtonUp - no action
//STRIP001 			//	needed in command handler
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			PasteSelection( rCEvt.GetMousePosPixel() );
//STRIP001 		}
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bDisable = pScMod->IsFormulaMode() ||
//STRIP001 					pScMod->IsModalMode(pViewData->GetSfxDocShell());
//STRIP001 	if (bDisable)
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( nCmd == COMMAND_WHEEL || nCmd == COMMAND_STARTAUTOSCROLL || nCmd == COMMAND_AUTOSCROLL )
//STRIP001 	{
//STRIP001 		BOOL bDone = pViewData->GetView()->ScrollCommand( rCEvt, eWhich );
//STRIP001 		if (!bDone)
//STRIP001 			Window::Command(rCEvt);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nCmd == COMMAND_CONTEXTMENU && !SC_MOD()->GetIsWaterCan() )
//STRIP001 	{
//STRIP001 		if (pViewData->IsAnyFillMode())
//STRIP001 		{
//STRIP001 			pViewData->GetView()->StopRefMode();
//STRIP001 			pViewData->ResetFillMode();
//STRIP001 		}
//STRIP001 		ReleaseMouse();
//STRIP001 		StopMarking();
//STRIP001 
//STRIP001 		Point aPosPixel = rCEvt.GetMousePosPixel();
//STRIP001 		Point aMenuPos = aPosPixel;
//STRIP001 		BOOL bMouse = rCEvt.IsMouseEvent();
//STRIP001 		BOOL bDone = FALSE;
//STRIP001 		BOOL bEdit = pViewData->HasEditView(eWhich);
//STRIP001 		if ( !bEdit )
//STRIP001 		{
//STRIP001 				// Edit-Zelle mit Spelling-Errors ?
//STRIP001 			if ( bMouse && GetEditUrlOrError( TRUE, aPosPixel ) )
//STRIP001 			{
//STRIP001 				//	GetEditUrlOrError hat den Cursor schon bewegt
//STRIP001 
//STRIP001 				pScMod->SetInputMode( SC_INPUT_TABLE );
//STRIP001 				bEdit = pViewData->HasEditView(eWhich);		// hat's geklappt ?
//STRIP001 
//STRIP001 				DBG_ASSERT( bEdit, "kann nicht in Edit-Modus schalten" );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( bEdit )
//STRIP001 		{
//STRIP001 			EditView* pEditView = pViewData->GetEditView( eWhich );		// ist dann nicht 0
//STRIP001 
//STRIP001 			if ( !bMouse )
//STRIP001 			{
//STRIP001 				Cursor* pCur = pEditView->GetCursor();
//STRIP001 				if ( pCur )
//STRIP001 				{
//STRIP001 					Point aLogicPos = pCur->GetPos();
//STRIP001 					//	use the position right of the cursor (spell popup is opened if
//STRIP001 					//	the cursor is before the word, but not if behind it)
//STRIP001 					aLogicPos.X() += pCur->GetWidth();
//STRIP001 					aLogicPos.Y() += pCur->GetHeight() / 2;		// center vertically
//STRIP001 					aMenuPos = LogicToPixel( aLogicPos );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			//	if edit mode was just started above, online spelling may be incomplete
//STRIP001 			pEditView->GetEditEngine()->CompleteOnlineSpelling();
//STRIP001 
//STRIP001 			//	IsCursorAtWrongSpelledWord could be used for !bMouse
//STRIP001 			//	if there was a corresponding ExecuteSpellPopup call
//STRIP001 
//STRIP001 			if( pEditView->IsWrongSpelledWordAtPos( aMenuPos ) )
//STRIP001 			{
//STRIP001 				//	Wenn man unter OS/2 neben das Popupmenue klickt, kommt MouseButtonDown
//STRIP001 				//	vor dem Ende des Menue-Execute, darum muss SetModified vorher kommen
//STRIP001 				//	(Bug #40968#)
//STRIP001 				ScInputHandler* pHdl = pScMod->GetInputHdl();
//STRIP001 				if (pHdl)
//STRIP001 					pHdl->SetModified();
//STRIP001 
//STRIP001 				pEditView->ExecuteSpellPopup( aMenuPos );
//STRIP001 
//STRIP001 				bDone = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( !bMouse )
//STRIP001 		{
//STRIP001 			//	non-edit menu by keyboard -> use lower right of cell cursor position
//STRIP001 
//STRIP001 			USHORT nCurX = pViewData->GetCurX();
//STRIP001 			USHORT nCurY = pViewData->GetCurY();
//STRIP001 			aMenuPos = pViewData->GetScrPos( nCurX, nCurY, eWhich, TRUE );
//STRIP001 			long nSizeXPix;
//STRIP001 			long nSizeYPix;
//STRIP001 			pViewData->GetMergeSizePixel( nCurX, nCurY, nSizeXPix, nSizeYPix );
//STRIP001 			aMenuPos.X() += nSizeXPix;
//STRIP001 			aMenuPos.Y() += nSizeYPix;
//STRIP001 
//STRIP001             if (pViewData)
//STRIP001             {
//STRIP001         	    ScTabViewShell* pViewSh = pViewData->GetViewShell();
//STRIP001 	            if (pViewSh)
//STRIP001 	            {
//STRIP001 		            //	Is a draw object selected?
//STRIP001 
//STRIP001 		            SdrView* pDrawView = pViewSh->GetSdrView();
//STRIP001 		            if (pDrawView && pDrawView->HasMarked())
//STRIP001 		            {
//STRIP001                         // #100442#; the conext menu should open in the middle of the selected objects
//STRIP001                         Rectangle aSelectRect(LogicToPixel(pDrawView->GetAllMarkedBoundRect()));
//STRIP001                         aMenuPos = aSelectRect.Center();
//STRIP001 		            }
//STRIP001                 }
//STRIP001             }
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!bDone)
//STRIP001 		{
//STRIP001 			SfxDispatcher::ExecutePopup( 0, this, &aMenuPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScGridWindow::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001     // #96965# Cursor control for ref input dialog
//STRIP001     if( SC_MOD()->IsRefDialogOpen() )
//STRIP001     {
//STRIP001         const KeyCode& rKeyCode = rKEvt.GetKeyCode();
//STRIP001         if( !rKeyCode.GetModifier() && (rKeyCode.GetCode() == KEY_F2) )
//STRIP001         {
//STRIP001             SC_MOD()->EndReference();
//STRIP001             return;
//STRIP001         }
//STRIP001         else if( pViewData->GetViewShell()->MoveCursorKeyInput( rKEvt ) )
//STRIP001         {
//STRIP001             ScRange aRef(
//STRIP001                 pViewData->GetRefStartX(), pViewData->GetRefStartY(), pViewData->GetRefStartZ(),
//STRIP001                 pViewData->GetRefEndX(), pViewData->GetRefEndY(), pViewData->GetRefEndZ() );
//STRIP001             SC_MOD()->SetReference( aRef, pViewData->GetDocument() );
//STRIP001             return;
//STRIP001         }
//STRIP001     }
//STRIP001 	// wenn semi-Modeless-SfxChildWindow-Dialog oben, keine KeyInputs:
//STRIP001     else if( !pViewData->IsAnyFillMode() )
//STRIP001 	{
//STRIP001 		//	query for existing note marker before calling ViewShell's keyboard handling
//STRIP001 		//	which may remove the marker
//STRIP001 		BOOL bHadKeyMarker = ( pNoteMarker && pNoteMarker->IsByKeyboard() );
//STRIP001 		ScTabViewShell* pViewSh = pViewData->GetViewShell();
//STRIP001 
//STRIP001 		if (pViewData->GetDocShell()->GetProgress())
//STRIP001 			return;
//STRIP001 
//STRIP001 		if (DrawKeyInput(rKEvt))
//STRIP001 			return;
//STRIP001 
//STRIP001 		if (!pViewData->GetView()->IsDrawSelMode() && !DrawHasMarkedObj())	//	keine Eingaben im Zeichenmodus
//STRIP001 		{															//! DrawShell abfragen !!!
//STRIP001 			if (pViewSh->TabKeyInput(rKEvt))
//STRIP001 				return;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			if (pViewSh->SfxViewShell::KeyInput(rKEvt))				// von SfxViewShell
//STRIP001 				return;
//STRIP001 
//STRIP001 		KeyCode aCode = rKEvt.GetKeyCode();
//STRIP001 		if ( aCode.GetCode() == KEY_ESCAPE && aCode.GetModifier() == 0 )
//STRIP001 		{
//STRIP001 			if ( bHadKeyMarker )
//STRIP001 				HideNoteMarker();
//STRIP001 			else
//STRIP001 				pViewData->GetDocShell()->DoInPlaceActivate(FALSE);
//STRIP001 			return;
//STRIP001 		}
//STRIP001 		if ( aCode.GetCode() == KEY_F1 && aCode.GetModifier() == KEY_MOD1 )
//STRIP001 		{
//STRIP001 			//	ctrl-F1 shows or hides the note or redlining info for the cursor position
//STRIP001 			//	(hard-coded because F1 can't be configured)
//STRIP001 
//STRIP001 			if ( bHadKeyMarker )
//STRIP001 				HideNoteMarker();		// hide when previously visible
//STRIP001 			else
//STRIP001 				ShowNoteMarker( pViewData->GetCurX(), pViewData->GetCurY(), TRUE );
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	Window::KeyInput(rKEvt);
//STRIP001 }

/*N*/ void ScGridWindow::StopMarking()
/*N*/ {
/*N*/ 	DrawEndAction();				// Markieren/Verschieben auf Drawing-Layer abbrechen
/*N*/ 
/*N*/ 	if (nButtonDown)
/*N*/ 	{
/*?*/ 		pViewData->GetMarkData().SetMarking(FALSE);
/*?*/ 		nMouseStatus = SC_GM_IGNORE;
/*N*/ 	}
/*N*/ }

//STRIP001 void ScGridWindow::UpdateInputContext()
//STRIP001 {
//STRIP001 	BOOL bReadOnly = pViewData->GetDocShell()->IsReadOnly();
//STRIP001 	ULONG nOptions = bReadOnly ? 0 : ( INPUTCONTEXT_TEXT | INPUTCONTEXT_EXTTEXTINPUT );
//STRIP001 
//STRIP001 	//	when font from InputContext is used,
//STRIP001 	//	it must be taken from the cursor position's cell attributes
//STRIP001 
//STRIP001 	InputContext aContext;
//STRIP001 	aContext.SetOptions( nOptions );
//STRIP001 	SetInputContext( aContext );
//STRIP001 }

//--------------------------------------------------------

								// sensitiver Bereich (Pixel)
#define SCROLL_SENSITIVE 20

//STRIP001 BOOL ScGridWindow::DropScroll( const Point& rMousePos )
//STRIP001 {
/*	doch auch auf nicht aktiven Views...
	if ( !pViewData->IsActive() )
		return FALSE;
*/
//STRIP001 	short nDx = 0;
//STRIP001 	short nDy = 0;
//STRIP001 	Size aSize = GetOutputSizePixel();
//STRIP001 
//STRIP001 	if (aSize.Width() > SCROLL_SENSITIVE * 3)
//STRIP001 	{
//STRIP001 		if ( rMousePos.X() < SCROLL_SENSITIVE && pViewData->GetPosX(WhichH(eWhich)) > 0 )
//STRIP001 			nDx = -1;
//STRIP001 		if ( rMousePos.X() >= aSize.Width() - SCROLL_SENSITIVE
//STRIP001 				&& pViewData->GetPosX(WhichH(eWhich)) < MAXCOL )
//STRIP001 			nDx = 1;
//STRIP001 	}
//STRIP001 	if (aSize.Height() > SCROLL_SENSITIVE * 3)
//STRIP001 	{
//STRIP001 		if ( rMousePos.Y() < SCROLL_SENSITIVE && pViewData->GetPosY(WhichV(eWhich)) > 0 )
//STRIP001 			nDy = -1;
//STRIP001 		if ( rMousePos.Y() >= aSize.Height() - SCROLL_SENSITIVE
//STRIP001 				&& pViewData->GetPosY(WhichV(eWhich)) < MAXROW )
//STRIP001 			nDy = 1;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nDx || nDy )
//STRIP001 	{
//STRIP001 		if (bDragRect)
//STRIP001 			pViewData->GetView()->DrawDragRect( nDragStartX, nDragStartY, nDragEndX, nDragEndY, eWhich );
//STRIP001 
//STRIP001 		if ( nDx )
//STRIP001 			pViewData->GetView()->ScrollX( nDx, WhichH(eWhich) );
//STRIP001 		if ( nDy )
//STRIP001 			pViewData->GetView()->ScrollY( nDy, WhichV(eWhich) );
//STRIP001 
//STRIP001 		if (bDragRect)
//STRIP001 			pViewData->GetView()->DrawDragRect( nDragStartX, nDragStartY, nDragEndX, nDragEndY, eWhich );
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 BOOL lcl_TestScenarioRedliningDrop( ScDocument* pDoc, const ScRange& aDragRange)
//STRIP001 {
//STRIP001 	//	Testet, ob bei eingeschalteten RedLining,
//STRIP001 	//  bei einem Drop ein Scenario betroffen ist.
//STRIP001 
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 	USHORT nTab = aDragRange.aStart.Tab();
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 
//STRIP001 	if(pDoc->GetChangeTrack()!=NULL)
//STRIP001 	{
//STRIP001 		if( pDoc->IsScenario(nTab) && pDoc->HasScenarioRange(nTab, aDragRange))
//STRIP001 		{
//STRIP001 			bReturn = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			for(USHORT i=nTab+1; i<nTabCount && pDoc->IsScenario(i); i++)
//STRIP001 			{
//STRIP001 				if(pDoc->HasScenarioRange(i, aDragRange))
//STRIP001 				{
//STRIP001 					bReturn = TRUE;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bReturn;
//STRIP001 }

//STRIP001 ScRange lcl_MakeDropRange( USHORT nPosX, USHORT nPosY, USHORT nTab, const ScRange& rSource )
//STRIP001 {
//STRIP001 	USHORT nCol1 = nPosX;
//STRIP001 	USHORT nCol2 = nCol1 + ( rSource.aEnd.Col() - rSource.aStart.Col() );
//STRIP001 	if ( nCol2 > MAXCOL )
//STRIP001 	{
//STRIP001 		nCol1 -= nCol2 - MAXCOL;
//STRIP001 		nCol2 = MAXCOL;
//STRIP001 	}
//STRIP001 	USHORT nRow1 = nPosY;
//STRIP001 	USHORT nRow2 = nRow1 + ( rSource.aEnd.Row() - rSource.aStart.Row() );
//STRIP001 	if ( nRow2 > MAXROW )
//STRIP001 	{
//STRIP001 		nRow1 -= nRow2 - MAXROW;
//STRIP001 		nRow2 = MAXROW;
//STRIP001 	}
//STRIP001 
//STRIP001 	return ScRange( nCol1, nRow1, nTab, nCol2, nRow2, nTab );
//STRIP001 }

//--------------------------------------------------------

extern BOOL bPasteIsDrop;		// viewfun4 -> move to header
extern BOOL bPasteIsMove;		// viewfun7 -> move to header

//--------------------------------------------------------

//STRIP001 sal_Int8 ScGridWindow::AcceptPrivateDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	if ( rEvt.mbLeaving )
//STRIP001 	{
//STRIP001 		if (bDragRect)
//STRIP001 			pViewData->GetView()->DrawDragRect( nDragStartX, nDragStartY, nDragEndX, nDragEndY, eWhich );
//STRIP001 		bDragRect = FALSE;
//STRIP001 		return rEvt.mnAction;
//STRIP001 	}
//STRIP001 
//STRIP001 	const ScDragData& rData = SC_MOD()->GetDragData();
//STRIP001 	if ( rData.pCellTransfer )
//STRIP001 	{
//STRIP001 		Point aPos = rEvt.maPosPixel;
//STRIP001 
//STRIP001 		ScDocument* pSourceDoc = rData.pCellTransfer->GetSourceDocument();
//STRIP001 		ScDocument* pThisDoc   = pViewData->GetDocument();
//STRIP001 		if (pSourceDoc == pThisDoc)
//STRIP001 		{
//STRIP001 			if ( pThisDoc->HasChartAtPoint(pViewData->GetTabNo(), PixelToLogic(aPos)) )
//STRIP001 			{
//STRIP001 				if (bDragRect)			// Rechteck loeschen
//STRIP001 				{
//STRIP001 					pViewData->GetView()->DrawDragRect( nDragStartX, nDragStartY, nDragEndX, nDragEndY, eWhich );
//STRIP001 					bDragRect = FALSE;
//STRIP001 				}
//STRIP001 
//STRIP001 				//!	highlight chart? (selection border?)
//STRIP001 
//STRIP001 				sal_Int8 nRet = rEvt.mnAction;
//STRIP001 //!				if ( rEvt.GetAction() == DROP_LINK )
//STRIP001 //!					bOk = rEvt.SetAction( DROP_COPY );			// can't link onto chart
//STRIP001 				return nRet;
//STRIP001 			}
//STRIP001 		}
//STRIP001 //!		else
//STRIP001 //!			if ( rEvt.GetAction() == DROP_MOVE )
//STRIP001 //!				rEvt.SetAction( DROP_COPY );					// different doc: default=COPY
//STRIP001 
//STRIP001 
//STRIP001 		if ( rData.pCellTransfer->GetDragSourceFlags() & SC_DROP_TABLE )		// whole sheet?
//STRIP001 		{
//STRIP001 			BOOL bOk = pThisDoc->IsDocEditable();
//STRIP001 			return bOk ? rEvt.mnAction : 0;						// don't draw selection frame
//STRIP001 		}
//STRIP001 
//STRIP001 		short	nPosX;
//STRIP001 		short	nPosY;
//STRIP001 		pViewData->GetPosFromPixel( aPos.X(), aPos.Y(), eWhich, nPosX, nPosY );
//STRIP001 
//STRIP001 		ScRange aSourceRange = rData.pCellTransfer->GetRange();
//STRIP001 		USHORT nSizeX = aSourceRange.aEnd.Col() - aSourceRange.aStart.Col() + 1;
//STRIP001 		USHORT nSizeY = aSourceRange.aEnd.Row() - aSourceRange.aStart.Row() + 1;
//STRIP001 
//STRIP001 		if ( rEvt.mnAction != DND_ACTION_MOVE )
//STRIP001 			nSizeY = rData.pCellTransfer->GetNonFilteredRows();		// copy/link: no filtered rows
//STRIP001 
//STRIP001 		short nNewDragX = nPosX - rData.pCellTransfer->GetDragHandleX();
//STRIP001 		if (nNewDragX<0) nNewDragX=0;
//STRIP001 		if (nNewDragX+(nSizeX-1) > MAXCOL)
//STRIP001 			nNewDragX = MAXCOL-(nSizeX-1);
//STRIP001 		short nNewDragY = nPosY - rData.pCellTransfer->GetDragHandleY();
//STRIP001 		if (nNewDragY<0) nNewDragY=0;
//STRIP001 		if (nNewDragY+(nSizeY-1) > MAXROW)
//STRIP001 			nNewDragY = MAXROW-(nSizeY-1);
//STRIP001 
//STRIP001 		//	don't break scenario ranges
//STRIP001 		USHORT nTab = pViewData->GetTabNo();
//STRIP001 		ScRange aDropRange = lcl_MakeDropRange( nNewDragX, nNewDragY, nTab, aSourceRange );
//STRIP001 		if ( lcl_TestScenarioRedliningDrop( pThisDoc, aDropRange ) ||
//STRIP001 			 lcl_TestScenarioRedliningDrop( pSourceDoc, aSourceRange ) )
//STRIP001 		{
//STRIP001 			if (bDragRect)
//STRIP001 			{
//STRIP001 				pViewData->GetView()->DrawDragRect( nDragStartX, nDragStartY, nDragEndX, nDragEndY, eWhich );
//STRIP001 				bDragRect = FALSE;
//STRIP001 			}
//STRIP001 			return DND_ACTION_NONE;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nNewDragX != (short) nDragStartX || nNewDragY != (short) nDragStartY ||
//STRIP001 			 nDragStartX+nSizeX-1 != nDragEndX || nDragStartY+nSizeY-1 != nDragEndY ||
//STRIP001 			 !bDragRect )
//STRIP001 		{
//STRIP001 			if (bDragRect)
//STRIP001 				pViewData->GetView()->DrawDragRect( nDragStartX, nDragStartY, nDragEndX, nDragEndY, eWhich );
//STRIP001 
//STRIP001 			nDragStartX = nNewDragX;
//STRIP001 			nDragStartY = nNewDragY;
//STRIP001 			nDragEndX = nDragStartX+nSizeX-1;
//STRIP001 			nDragEndY = nDragStartY+nSizeY-1;
//STRIP001 			bDragRect = TRUE;
//STRIP001 
//STRIP001 			pViewData->GetView()->DrawDragRect( nDragStartX, nDragStartY, nDragEndX, nDragEndY, eWhich );
//STRIP001 
//STRIP001 			//	show target position as tip help
//STRIP001 #if 0
//STRIP001 			if (Help::IsQuickHelpEnabled())
//STRIP001 			{
//STRIP001 				ScRange aRange( nDragStartX, nDragStartY, nTab, nDragEndX, nDragEndY, nTab );
//STRIP001 				String aHelpStr;
//STRIP001 				aRange.Format( aHelpStr, SCA_VALID );	// non-3D
//STRIP001 
//STRIP001 				Point aPos = Pointer::GetPosPixel();
//STRIP001 				USHORT nAlign = QUICKHELP_BOTTOM|QUICKHELP_RIGHT;
//STRIP001 				Rectangle aRect( aPos, aPos );
//STRIP001 				Help::ShowQuickHelp(aRect, aHelpStr, nAlign);
//STRIP001 			}
//STRIP001 #endif
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return rEvt.mnAction;
//STRIP001 }

//STRIP001 sal_Int8 ScGridWindow::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	const ScDragData& rData = SC_MOD()->GetDragData();
//STRIP001 	if ( rEvt.mbLeaving )
//STRIP001 	{
//STRIP001 		DrawMarkDropObj( NULL );
//STRIP001 		if ( rData.pCellTransfer )
//STRIP001 			return AcceptPrivateDrop( rEvt );	// hide drop marker for internal D&D
//STRIP001 		else
//STRIP001 			return rEvt.mnAction;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pViewData->GetDocShell()->IsReadOnly() )
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if (rData.pCellTransfer)
//STRIP001 	{
//STRIP001 		ScRange aSource = rData.pCellTransfer->GetRange();
//STRIP001 		if ( aSource.aStart.Col() != 0 || aSource.aEnd.Col() != MAXCOL ||
//STRIP001 			 aSource.aStart.Row() != 0 || aSource.aEnd.Row() != MAXROW )
//STRIP001 			DropScroll( rEvt.maPosPixel );
//STRIP001 
//STRIP001 		nRet = AcceptPrivateDrop( rEvt );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( rData.aLinkDoc.Len() )
//STRIP001 		{
//STRIP001 			String aThisName;
//STRIP001 			ScDocShell* pDocSh = pViewData->GetDocShell();
//STRIP001 			if (pDocSh && pDocSh->HasName())
//STRIP001 				aThisName = pDocSh->GetMedium()->GetName();
//STRIP001 
//STRIP001 			if ( rData.aLinkDoc != aThisName )
//STRIP001 				nRet = rEvt.mnAction;
//STRIP001 		}
//STRIP001 		else if (rData.aJumpTarget.Len())
//STRIP001 		{
//STRIP001 			//	internal bookmarks (from Navigator)
//STRIP001 			//	local jumps from an unnamed document are possible only within a document
//STRIP001 
//STRIP001 			if ( !rData.pJumpLocalDoc || rData.pJumpLocalDoc == pViewData->GetDocument() )
//STRIP001 				nRet = rEvt.mnAction;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			sal_Int8 nMyAction = rEvt.mnAction;
//STRIP001 
//STRIP001 			if ( !rData.pDrawTransfer ||
//STRIP001 					!IsMyModel(rData.pDrawTransfer->GetDragSourceView()) )		// drawing within the document
//STRIP001 				if ( rEvt.mbDefault && nMyAction == DND_ACTION_MOVE )
//STRIP001 					nMyAction = DND_ACTION_COPY;
//STRIP001 
//STRIP001 			ScDocument* pThisDoc = pViewData->GetDocument();
//STRIP001 			SdrObject* pHitObj = pThisDoc->GetObjectAtPoint(
//STRIP001 						pViewData->GetTabNo(), PixelToLogic(rEvt.maPosPixel) );
//STRIP001 			if ( pHitObj && nMyAction == DND_ACTION_LINK && !rData.pDrawTransfer )
//STRIP001 			{
//STRIP001 				if ( IsDropFormatSupported(SOT_FORMATSTR_ID_SVXB)
//STRIP001 					|| IsDropFormatSupported(SOT_FORMAT_GDIMETAFILE)
//STRIP001 					|| IsDropFormatSupported(SOT_FORMAT_BITMAP) )
//STRIP001 				{
//STRIP001 					//	graphic dragged onto drawing object
//STRIP001 					DrawMarkDropObj( pHitObj );
//STRIP001 					nRet = nMyAction;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if (!nRet)
//STRIP001 				DrawMarkDropObj( NULL );
//STRIP001 
//STRIP001 			if (!nRet)
//STRIP001 			{
//STRIP001 				switch ( nMyAction )
//STRIP001 				{
//STRIP001 					case DND_ACTION_COPY:
//STRIP001 					case DND_ACTION_MOVE:
//STRIP001 					case DND_ACTION_COPYMOVE:
//STRIP001 						{
//STRIP001 							BOOL bMove = ( nMyAction == DND_ACTION_MOVE );
//STRIP001 							if ( IsDropFormatSupported( SOT_FORMATSTR_ID_EMBED_SOURCE ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMATSTR_ID_LINK_SOURCE ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMATSTR_ID_EMBED_SOURCE_OLE ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMATSTR_ID_LINK_SOURCE_OLE ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMAT_STRING ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMATSTR_ID_SYLK ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMATSTR_ID_LINK ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMATSTR_ID_HTML ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMATSTR_ID_HTML_SIMPLE ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMATSTR_ID_DIF ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMATSTR_ID_DRAWING ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMATSTR_ID_SVXB ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMAT_RTF ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMAT_GDIMETAFILE ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMAT_BITMAP ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMATSTR_ID_SBA_DATAEXCHANGE ) ||
//STRIP001 								 IsDropFormatSupported( SOT_FORMATSTR_ID_SBA_FIELDDATAEXCHANGE ) ||
//STRIP001 								 ( !bMove && (
//STRIP001 								 	IsDropFormatSupported( SOT_FORMAT_FILE ) ||
//STRIP001 								 	IsDropFormatSupported( SOT_FORMATSTR_ID_SOLK ) ||
//STRIP001 								 	IsDropFormatSupported( SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR ) ||
//STRIP001 								 	IsDropFormatSupported( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK ) ||
//STRIP001 								 	IsDropFormatSupported( SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR ) ) ) )
//STRIP001 							{
//STRIP001 								nRet = nMyAction;
//STRIP001 							}
//STRIP001 						}
//STRIP001 						break;
//STRIP001 					case DND_ACTION_LINK:
//STRIP001 						if ( IsDropFormatSupported( SOT_FORMATSTR_ID_LINK_SOURCE ) ||
//STRIP001 							 IsDropFormatSupported( SOT_FORMATSTR_ID_LINK_SOURCE_OLE ) ||
//STRIP001 							 IsDropFormatSupported( SOT_FORMATSTR_ID_LINK ) ||
//STRIP001 							 IsDropFormatSupported( SOT_FORMAT_FILE ) ||
//STRIP001 							 IsDropFormatSupported( SOT_FORMATSTR_ID_SOLK ) ||
//STRIP001 							 IsDropFormatSupported( SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR ) ||
//STRIP001 							 IsDropFormatSupported( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK ) ||
//STRIP001 							 IsDropFormatSupported( SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR ) )
//STRIP001 						{
//STRIP001 							nRet = nMyAction;
//STRIP001 						}
//STRIP001 						break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//	scroll only for accepted formats
//STRIP001 		if (nRet)
//STRIP001 			DropScroll( rEvt.maPosPixel );
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 ULONG lcl_GetDropFormatId( const uno::Reference<datatransfer::XTransferable>& xTransfer )
//STRIP001 {
//STRIP001 	TransferableDataHelper aDataHelper( xTransfer );
//STRIP001 
//STRIP001 	if ( !aDataHelper.HasFormat( SOT_FORMATSTR_ID_SBA_DATAEXCHANGE ) )
//STRIP001 	{
//STRIP001 		//	use bookmark formats if no sba is present
//STRIP001 
//STRIP001 		if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_SOLK ) )
//STRIP001 			return SOT_FORMATSTR_ID_SOLK;
//STRIP001 		else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR ) )
//STRIP001 			return SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR;
//STRIP001 		else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK ) )
//STRIP001 			return SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK;
//STRIP001 		else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR ) )
//STRIP001 			return SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR;
//STRIP001 	}
//STRIP001 
//STRIP001 	ULONG nFormatId = 0;
//STRIP001 	if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_DRAWING ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_DRAWING;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_SVXB ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_SVXB;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_EMBED_SOURCE ) )
//STRIP001 	{
//STRIP001 		//	If it's a Writer object, insert RTF instead of OLE
//STRIP001 
//STRIP001 		BOOL bDoRtf = FALSE;
//STRIP001 		SotStorageStreamRef xStm;
//STRIP001 		TransferableObjectDescriptor aObjDesc;
//STRIP001 		if( aDataHelper.GetTransferableObjectDescriptor( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR, aObjDesc ) &&
//STRIP001 			aDataHelper.GetSotStorageStream( SOT_FORMATSTR_ID_EMBED_SOURCE, xStm ) )
//STRIP001 		{
//STRIP001 			SvStorageRef xStore( new SvStorage( *xStm ) );
//STRIP001 			bDoRtf = ( ( aObjDesc.maClassName == SvGlobalName( BF_SO3_SW_CLASSID ) ||
//STRIP001 						 aObjDesc.maClassName == SvGlobalName( BF_SO3_SWWEB_CLASSID ) )
//STRIP001 					   && aDataHelper.HasFormat( SOT_FORMAT_RTF ) );
//STRIP001 		}
//STRIP001 		if ( bDoRtf )
//STRIP001 			nFormatId = FORMAT_RTF;
//STRIP001 		else
//STRIP001 			nFormatId = SOT_FORMATSTR_ID_EMBED_SOURCE;
//STRIP001 	}
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_LINK_SOURCE ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_LINK_SOURCE;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_SBA_DATAEXCHANGE ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_SBA_DATAEXCHANGE;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_SBA_FIELDDATAEXCHANGE ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_SBA_FIELDDATAEXCHANGE;
//STRIP001     else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_BIFF_8 ) )
//STRIP001         nFormatId = SOT_FORMATSTR_ID_BIFF_8;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_BIFF_5 ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_BIFF_5;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_EMBED_SOURCE_OLE ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_EMBED_SOURCE_OLE;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_LINK_SOURCE_OLE ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_LINK_SOURCE_OLE;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMAT_RTF ) )
//STRIP001 		nFormatId = SOT_FORMAT_RTF;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_HTML ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_HTML;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_HTML_SIMPLE ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_HTML_SIMPLE;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_SYLK ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_SYLK;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_LINK ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_LINK;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMAT_STRING ) )
//STRIP001 		nFormatId = SOT_FORMAT_STRING;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMAT_GDIMETAFILE ) )
//STRIP001 		nFormatId = SOT_FORMAT_GDIMETAFILE;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMAT_BITMAP ) )
//STRIP001 		nFormatId = SOT_FORMAT_BITMAP;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMAT_FILE ) )
//STRIP001 		nFormatId = SOT_FORMAT_FILE;
//STRIP001 
//STRIP001 	return nFormatId;
//STRIP001 }

//STRIP001 ULONG lcl_GetDropLinkId( const uno::Reference<datatransfer::XTransferable>& xTransfer )
//STRIP001 {
//STRIP001 	TransferableDataHelper aDataHelper( xTransfer );
//STRIP001 
//STRIP001 	ULONG nFormatId = 0;
//STRIP001 	if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_LINK_SOURCE ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_LINK_SOURCE;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_LINK_SOURCE_OLE ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_LINK_SOURCE_OLE;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_LINK ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_LINK;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMAT_FILE ) )
//STRIP001 		nFormatId = SOT_FORMAT_FILE;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_SOLK ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_SOLK;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK;
//STRIP001 	else if ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR ) )
//STRIP001 		nFormatId = SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR;
//STRIP001 
//STRIP001 	return nFormatId;
//STRIP001 }


//STRIP001 sal_Int8 ScGridWindow::ExecutePrivateDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001 	// hide drop marker
//STRIP001 	if (bDragRect)
//STRIP001 		pViewData->GetView()->DrawDragRect( nDragStartX, nDragStartY, nDragEndX, nDragEndY, eWhich );
//STRIP001 	bDragRect = FALSE;
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	const ScDragData& rData = pScMod->GetDragData();
//STRIP001 
//STRIP001 	return DropTransferObj( rData.pCellTransfer, nDragStartX, nDragStartY,
//STRIP001 								PixelToLogic(rEvt.maPosPixel), rEvt.mnAction );
//STRIP001 }

//STRIP001 sal_Int8 ScGridWindow::DropTransferObj( ScTransferObj* pTransObj, USHORT nDestPosX, USHORT nDestPosY,
//STRIP001 										const Point& rLogicPos, sal_Int8 nDndAction )
//STRIP001 {
//STRIP001 	if ( !pTransObj )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	ScDocument* pSourceDoc = pTransObj->GetSourceDocument();
//STRIP001 	ScDocument* pThisDoc   = pViewData->GetDocument();
//STRIP001 	ScViewFunc* pView	   = pViewData->GetView();
//STRIP001 	USHORT      nThisTab   = pViewData->GetTabNo();
//STRIP001 	USHORT nFlags = pTransObj->GetDragSourceFlags();
//STRIP001 
//STRIP001 	BOOL bIsNavi = ( nFlags & SC_DROP_NAVIGATOR ) != 0;
//STRIP001 	BOOL bIsMove = ( nDndAction == DND_ACTION_MOVE && !bIsNavi );
//STRIP001 	BOOL bIsLink = ( nDndAction == DND_ACTION_LINK );
//STRIP001 
//STRIP001 	ScRange aSource = pTransObj->GetRange();
//STRIP001 
//STRIP001 	//	only use visible tab from source range - when dragging within one table,
//STRIP001 	//	all selected tables at the time of dropping are used (handled in MoveBlockTo)
//STRIP001 	USHORT nSourceTab = pTransObj->GetVisibleTab();
//STRIP001 	aSource.aStart.SetTab( nSourceTab );
//STRIP001 	aSource.aEnd.SetTab( nSourceTab );
//STRIP001 
//STRIP001 	BOOL bDone = FALSE;
//STRIP001 
//STRIP001 	if (pSourceDoc == pThisDoc)
//STRIP001 	{
//STRIP001 		if ( nFlags & SC_DROP_TABLE )			// whole sheet?
//STRIP001 		{
//STRIP001 			if ( pThisDoc->IsDocEditable() )
//STRIP001 			{
//STRIP001 				USHORT nSrcTab = aSource.aStart.Tab();
//STRIP001 				pViewData->GetDocShell()->MoveTable( nSrcTab, nThisTab, !bIsMove, TRUE );	// with Undo
//STRIP001 				pView->SetTabNo( nThisTab, TRUE );
//STRIP001 				bDone = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else										// move/copy block
//STRIP001 		{
//STRIP001 			String aChartName;
//STRIP001 			if (pThisDoc->HasChartAtPoint( nThisTab, rLogicPos, &aChartName ))
//STRIP001 			{
//STRIP001 				String aRangeName;
//STRIP001 				aSource.Format( aRangeName, SCR_ABS_3D, pThisDoc );
//STRIP001 				SfxStringItem aNameItem( SID_CHART_NAME, aChartName );
//STRIP001 				SfxStringItem aRangeItem( SID_CHART_SOURCE, aRangeName );
//STRIP001 				USHORT nId = bIsMove ? SID_CHART_SOURCE : SID_CHART_ADDSOURCE;
//STRIP001 				pViewData->GetDispatcher().Execute( nId, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001 											&aRangeItem, &aNameItem, (void*) NULL );
//STRIP001 				bDone = TRUE;
//STRIP001 			}
//STRIP001 			else if ( nDestPosX != aSource.aStart.Col() || nDestPosY != aSource.aStart.Row() ||
//STRIP001 						nSourceTab != nThisTab )
//STRIP001 			{
//STRIP001 				//	call with bApi = TRUE to avoid error messages in drop handler
//STRIP001 				ScAddress aDest( nDestPosX, nDestPosY, nThisTab );
//STRIP001 				if ( bIsLink )
//STRIP001 					bDone = pView->LinkBlock( aSource, aDest, TRUE );
//STRIP001 				else
//STRIP001 					bDone = pView->MoveBlockTo( aSource, aDest, bIsMove, TRUE, TRUE, TRUE );
//STRIP001 				if (!bDone)
//STRIP001 					Sound::Beep();	// instead of error message in drop handler
//STRIP001 			}
//STRIP001 			else
//STRIP001 				bDone = TRUE;		// nothing to do
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bDone)
//STRIP001 			pTransObj->SetDragWasInternal();	// don't delete source in DragFinished
//STRIP001 	}
//STRIP001 	else if ( pSourceDoc )						// between documents
//STRIP001 	{
//STRIP001 		if ( nFlags & SC_DROP_TABLE )			// copy/link sheets between documents
//STRIP001 		{
//STRIP001 			if ( pThisDoc->IsDocEditable() )
//STRIP001 			{
//STRIP001 				USHORT nTab = aSource.aStart.Tab();
//STRIP001 				ScDocShell* pSrcShell = pTransObj->GetSourceDocShell();
//STRIP001 
//STRIP001 				USHORT nTabs[MAXTAB+1];
//STRIP001 
//STRIP001 				ScMarkData	aMark		= pTransObj->GetSourceMarkData();
//STRIP001 				USHORT		nTabCount	= pSourceDoc->GetTableCount();
//STRIP001 				USHORT		nTabSelCount = 0;
//STRIP001 
//STRIP001 				for(USHORT i=0; i<nTabCount; i++)
//STRIP001 				{
//STRIP001 					if(aMark.GetTableSelect(i))
//STRIP001 					{
//STRIP001 						nTabs[nTabSelCount++]=i;
//STRIP001 						for(USHORT j=i+1;j<nTabCount;j++)
//STRIP001 						{
//STRIP001 							if((!pSourceDoc->IsVisible(j))&&(pSourceDoc->IsScenario(j)))
//STRIP001 							{
//STRIP001 								nTabs[nTabSelCount++]=j;
//STRIP001 								i=j;
//STRIP001 							}
//STRIP001 							else break;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				pView->ImportTables( pSrcShell,nTabSelCount, nTabs, bIsLink, nThisTab );
//STRIP001 				bDone = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( bIsLink )
//STRIP001 		{
//STRIP001 			//	as in PasteDDE
//STRIP001 			//	(external references might be used instead?)
//STRIP001 
//STRIP001 			SfxObjectShell* pSourceSh = pSourceDoc->GetDocumentShell();
//STRIP001 			DBG_ASSERT(pSourceSh, "drag document has no shell");
//STRIP001 			if (pSourceSh)
//STRIP001 			{
//STRIP001 				String aApp = Application::GetAppName();
//STRIP001 				String aTopic = pSourceSh->GetTitle( SFX_TITLE_FULLNAME );
//STRIP001 				String aItem;
//STRIP001 				aSource.Format( aItem, SCA_VALID | SCA_TAB_3D, pSourceDoc );
//STRIP001 
//STRIP001 				//!	use tokens
//STRIP001 				String aFormula( '=' );
//STRIP001 				aFormula += ScCompiler::pSymbolTableNative[SC_OPCODE_DDE];
//STRIP001 				aFormula.AppendAscii(RTL_CONSTASCII_STRINGPARAM("(\""));
//STRIP001 				aFormula += aApp;
//STRIP001 				aFormula.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\";\""));
//STRIP001 				aFormula += aTopic;
//STRIP001 				aFormula.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\";\""));
//STRIP001 				aFormula += aItem;
//STRIP001 				aFormula.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\")"));
//STRIP001 
//STRIP001 				pView->DoneBlockMode();
//STRIP001 				pView->InitBlockMode( nDestPosX, nDestPosY, nThisTab );
//STRIP001 				pView->MarkCursor( nDestPosX + aSource.aEnd.Col() - aSource.aStart.Col(),
//STRIP001 								   nDestPosY + aSource.aEnd.Row() - aSource.aStart.Row(), nThisTab );
//STRIP001 
//STRIP001 				pView->EnterMatrix( aFormula );
//STRIP001 				pView->CursorPosChanged();
//STRIP001 				bDone = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//!	HasSelectedBlockMatrixFragment without selected sheet?
//STRIP001 			//!	or don't start dragging on a part of a matrix
//STRIP001 
//STRIP001 			pView->Unmark();	// before SetCursor, so CheckSelectionTransfer isn't called with a selection
//STRIP001 			pView->SetCursor( nDestPosX, nDestPosY );
//STRIP001 			pView->PasteFromClip( IDF_ALL, pTransObj->GetDocument() );		// clip-doc
//STRIP001 
//STRIP001 			//	no longer call ResetMark here - the inserted block has been selected
//STRIP001 			//	and may have been copied to primary selection
//STRIP001 
//STRIP001 			bDone = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	sal_Int8 nRet = bDone ? nDndAction : DND_ACTION_NONE;
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 sal_Int8 ScGridWindow::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001 	DrawMarkDropObj( NULL );	// drawing layer
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	const ScDragData& rData = pScMod->GetDragData();
//STRIP001 	if (rData.pCellTransfer)
//STRIP001 		return ExecutePrivateDrop( rEvt );
//STRIP001 
//STRIP001 	Point aPos = rEvt.maPosPixel;
//STRIP001 
//STRIP001 	if ( rData.aLinkDoc.Len() )
//STRIP001 	{
//STRIP001 		//	try to insert a link
//STRIP001 
//STRIP001 		BOOL bOk = TRUE;
//STRIP001 		String aThisName;
//STRIP001 		ScDocShell* pDocSh = pViewData->GetDocShell();
//STRIP001 		if (pDocSh && pDocSh->HasName())
//STRIP001 			aThisName = pDocSh->GetMedium()->GetName();
//STRIP001 
//STRIP001 		if ( rData.aLinkDoc == aThisName )				// error - no link within a document
//STRIP001 			bOk = FALSE;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ScViewFunc* pView = pViewData->GetView();
//STRIP001 			if ( rData.aLinkTable.Len() )
//STRIP001 				pView->InsertTableLink( rData.aLinkDoc, EMPTY_STRING, EMPTY_STRING,
//STRIP001 										rData.aLinkTable );
//STRIP001 			else if ( rData.aLinkArea.Len() )
//STRIP001 			{
//STRIP001 				short	nPosX;
//STRIP001 				short	nPosY;
//STRIP001 				pViewData->GetPosFromPixel( aPos.X(), aPos.Y(), eWhich, nPosX, nPosY );
//STRIP001 				pView->MoveCursorAbs( nPosX, nPosY, SC_FOLLOW_NONE, FALSE, FALSE );
//STRIP001 
//STRIP001 				pView->InsertAreaLink( rData.aLinkDoc, EMPTY_STRING, EMPTY_STRING,
//STRIP001 										rData.aLinkArea, 0 );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				DBG_ERROR("drop with link: no sheet nor area");
//STRIP001 				bOk = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		return bOk ? rEvt.mnAction : DND_ACTION_NONE;			// don't try anything else
//STRIP001 	}
//STRIP001 
//STRIP001 	Point aLogicPos = PixelToLogic(aPos);
//STRIP001 
//STRIP001 	if (rData.pDrawTransfer)
//STRIP001 	{
//STRIP001 		USHORT nFlags = rData.pDrawTransfer->GetDragSourceFlags();
//STRIP001 
//STRIP001 		BOOL bIsNavi = ( nFlags & SC_DROP_NAVIGATOR ) != 0;
//STRIP001 		BOOL bIsMove = ( rEvt.mnAction == DND_ACTION_MOVE && !bIsNavi );
//STRIP001 
//STRIP001 		bPasteIsMove = bIsMove;
//STRIP001 
//STRIP001 		pViewData->GetView()->PasteDraw( aLogicPos, rData.pDrawTransfer->GetModel() );
//STRIP001 
//STRIP001 		if (bPasteIsMove)
//STRIP001 			rData.pDrawTransfer->SetDragWasInternal();
//STRIP001 		bPasteIsMove = FALSE;
//STRIP001 
//STRIP001 		return rEvt.mnAction;
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	short	nPosX;
//STRIP001 	short	nPosY;
//STRIP001 	pViewData->GetPosFromPixel( aPos.X(), aPos.Y(), eWhich, nPosX, nPosY );
//STRIP001 
//STRIP001 	if (rData.aJumpTarget.Len())
//STRIP001 	{
//STRIP001 		//	internal bookmark (from Navigator)
//STRIP001 		//	bookmark clipboard formats are in PasteDataObject
//STRIP001 
//STRIP001 		if ( !rData.pJumpLocalDoc || rData.pJumpLocalDoc == pViewData->GetDocument() )
//STRIP001 		{
//STRIP001 			pViewData->GetViewShell()->InsertBookmark( rData.aJumpText, rData.aJumpTarget,
//STRIP001 														nPosX, nPosY );
//STRIP001 			return rEvt.mnAction;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bIsLink = ( rEvt.mnAction == DND_ACTION_LINK );
//STRIP001 
//STRIP001 	ScDocument* pThisDoc = pViewData->GetDocument();
//STRIP001 	SdrObject* pHitObj = pThisDoc->GetObjectAtPoint( pViewData->GetTabNo(), PixelToLogic(aPos) );
//STRIP001 	if ( pHitObj && bIsLink )
//STRIP001 	{
//STRIP001 		//	dropped on drawing object
//STRIP001 		//	PasteOnDrawObject checks for valid formats
//STRIP001 		if ( pViewData->GetView()->PasteOnDrawObject( rEvt.maDropEvent.Transferable, pHitObj, TRUE ) )
//STRIP001 			return rEvt.mnAction;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bDone = FALSE;
//STRIP001 
//STRIP001 	ULONG nFormatId = bIsLink ?
//STRIP001 						lcl_GetDropLinkId( rEvt.maDropEvent.Transferable ) :
//STRIP001 						lcl_GetDropFormatId( rEvt.maDropEvent.Transferable );
//STRIP001 	if ( nFormatId )
//STRIP001 	{
//STRIP001 		bPasteIsDrop = TRUE;
//STRIP001 		bDone = pViewData->GetView()->PasteDataFormat(
//STRIP001 					nFormatId, rEvt.maDropEvent.Transferable, nPosX, nPosY, &aLogicPos, bIsLink );
//STRIP001 		bPasteIsDrop = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	sal_Int8 nRet = bDone ? rEvt.mnAction : DND_ACTION_NONE;
//STRIP001 	return nRet;
//STRIP001 }

//--------------------------------------------------------

//STRIP001 void ScGridWindow::PasteSelection( const Point& rPosPixel )
//STRIP001 {
//STRIP001 	Point aLogicPos = PixelToLogic( rPosPixel );
//STRIP001 
//STRIP001 	short	nPosX;
//STRIP001 	short	nPosY;
//STRIP001 	pViewData->GetPosFromPixel( rPosPixel.X(), rPosPixel.Y(), eWhich, nPosX, nPosY );
//STRIP001 
//STRIP001 	ScSelectionTransferObj* pOwnSelection = SC_MOD()->GetSelectionTransfer();
//STRIP001 	if ( pOwnSelection )
//STRIP001 	{
//STRIP001 		//	within Calc
//STRIP001 
//STRIP001 		ScTransferObj* pCellTransfer = pOwnSelection->GetCellData();
//STRIP001 		if ( pCellTransfer )
//STRIP001 		{
//STRIP001 			// keep a reference to the data in case the selection is changed during paste
//STRIP001 			uno::Reference<datatransfer::XTransferable> xRef( pCellTransfer );
//STRIP001 			DropTransferObj( pCellTransfer, nPosX, nPosY, aLogicPos, DND_ACTION_COPY );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ScDrawTransferObj* pDrawTransfer = pOwnSelection->GetDrawData();
//STRIP001 			if ( pDrawTransfer )
//STRIP001 			{
//STRIP001 				// keep a reference to the data in case the selection is changed during paste
//STRIP001 				uno::Reference<datatransfer::XTransferable> xRef( pDrawTransfer );
//STRIP001 
//STRIP001 				//	#96821# bSameDocClipboard argument for PasteDraw is needed
//STRIP001 				//	because only DragData is checked directly inside PasteDraw
//STRIP001 				pViewData->GetView()->PasteDraw( aLogicPos, pDrawTransfer->GetModel(), FALSE,
//STRIP001 							pDrawTransfer->GetSourceDocID() == pViewData->GetDocument()->GetDocumentID() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//	get selection from system
//STRIP001 
//STRIP001 		TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSelection( this ) );
//STRIP001 		uno::Reference<datatransfer::XTransferable> xTransferable = aDataHelper.GetTransferable();
//STRIP001 		if ( xTransferable.is() )
//STRIP001 		{
//STRIP001 			ULONG nFormatId = lcl_GetDropFormatId( xTransferable );
//STRIP001 			if ( nFormatId )
//STRIP001 			{
//STRIP001 				bPasteIsDrop = TRUE;
//STRIP001 				pViewData->GetView()->PasteDataFormat( nFormatId, xTransferable, nPosX, nPosY, &aLogicPos );
//STRIP001 				bPasteIsDrop = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------

//STRIP001 void ScGridWindow::UpdateEditViewPos()
//STRIP001 {
//STRIP001 	if (pViewData->HasEditView(eWhich))
//STRIP001 	{
//STRIP001 		EditView* pView;
//STRIP001 		USHORT nCol;
//STRIP001 		USHORT nRow;
//STRIP001 		pViewData->GetEditView( eWhich, pView, nCol, nRow );
//STRIP001 		USHORT nEndCol = pViewData->GetEditEndCol();
//STRIP001 		USHORT nEndRow = pViewData->GetEditEndRow();
//STRIP001 
//STRIP001 		//	hide EditView?
//STRIP001 
//STRIP001 		BOOL bHide = ( nEndCol<pViewData->GetPosX(eHWhich) || nEndRow<pViewData->GetPosY(eVWhich) );
//STRIP001 		if ( SC_MOD()->IsFormulaMode() )
//STRIP001 			if ( pViewData->GetTabNo() != pViewData->GetRefTabNo() )
//STRIP001 				bHide = TRUE;
//STRIP001 
//STRIP001 		if (bHide)
//STRIP001 		{
//STRIP001 			Rectangle aRect = pView->GetOutputArea();
//STRIP001 			long nHeight = aRect.Bottom() - aRect.Top();
//STRIP001 			aRect.Top() = PixelToLogic(GetOutputSizePixel(), pViewData->GetLogicMode()).
//STRIP001 							Height() * 2;
//STRIP001 			aRect.Bottom() = aRect.Top() + nHeight;
//STRIP001 			pView->SetOutputArea( aRect );
//STRIP001 			pView->HideCursor();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// bForceToTop = TRUE for editing
//STRIP001 			Rectangle aPixRect = pViewData->GetEditArea( eWhich, nCol, nRow, this, NULL, TRUE );
//STRIP001 			Point aScrPos = PixelToLogic( aPixRect.TopLeft(), pViewData->GetLogicMode() );
//STRIP001 
//STRIP001 			Rectangle aRect = pView->GetOutputArea();
//STRIP001 			aRect.SetPos( aScrPos );
//STRIP001 			pView->SetOutputArea( aRect );
//STRIP001 			pView->ShowCursor();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScGridWindow::ScrollPixel( long nDifX, long nDifY )
//STRIP001 {
//STRIP001 	ClickExtern();
//STRIP001 	HideNoteMarker();
//STRIP001 
//STRIP001 	bIsInScroll = TRUE;
//STRIP001 	BOOL bXor=DrawBeforeScroll();
//STRIP001 
//STRIP001 	SetMapMode(MAP_PIXEL);
//STRIP001 	Scroll( nDifX, nDifY, SCROLL_CHILDREN );
//STRIP001 	SetMapMode( GetDrawMapMode() );				// verschobenen MapMode erzeugen
//STRIP001 
//STRIP001 	UpdateEditViewPos();
//STRIP001 
//STRIP001 	DrawAfterScroll(bXor);
//STRIP001 	bIsInScroll = FALSE;
//STRIP001 }

// 	Formeln neu zeichnen -------------------------------------------------

/*N*/ void ScGridWindow::UpdateFormulas()
/*N*/ {
/*N*/ 	if (pViewData->GetView()->IsMinimized())
/*N*/ 		return;
/*N*/ 
/*N*/ 	if ( nPaintCount )
/*N*/ 	{
/*?*/ 		//	nicht anfangen, verschachtelt zu painten
/*?*/ 		//	(dann wuerde zumindest der MapMode nicht mehr stimmen)
/*?*/ 
/*?*/ 		bNeedsRepaint = TRUE;			// -> am Ende vom Paint nochmal Invalidate auf alles
/*?*/ 		aRepaintPixel = Rectangle();	// alles
/*?*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT	nX1 = pViewData->GetPosX( eHWhich );
/*N*/ 	USHORT	nY1 = pViewData->GetPosY( eVWhich );
/*N*/ 	USHORT	nX2 = nX1 + pViewData->VisibleCellsX( eHWhich );
/*N*/ 	USHORT	nY2 = nY1 + pViewData->VisibleCellsY( eVWhich );
/*N*/ 
/*N*/ 	if (nX2 > MAXCOL) nX2 = MAXCOL;
/*N*/ 	if (nY2 > MAXROW) nY2 = MAXROW;
/*N*/ 
/*N*/ 	Draw( nX1, nY1, nX2, nY2, SC_UPDATE_CHANGED );
/*N*/ }

/*N*/ void ScGridWindow::UpdateAutoFillMark(BOOL bMarked, const ScRange& rMarkRange)
/*N*/ {
/*N*/ 	if ( bMarked != bAutoMarkVisible || ( bMarked && rMarkRange.aEnd != aAutoMarkPos ) )
/*N*/ 	{
/*N*/ 		HideCursor();
/*N*/ 		bAutoMarkVisible = bMarked;
/*N*/ 		if ( bMarked )
/*N*/ 			aAutoMarkPos = rMarkRange.aEnd;
/*N*/ 		ShowCursor();
/*N*/ 	}
/*N*/ }

/*N*/ void ScGridWindow::HideCursor()
/*N*/ {
/*N*/ 	++nCursorHideCount;
/*N*/ 	if (nCursorHideCount==1)
/*N*/ 	{
/*N*/ 		BOOL bDrawCursor = TRUE;
/*N*/ 		BOOL bDrawAuto   = TRUE;
/*N*/ 
/*N*/ 		//!	irgendwie erkennen, ob wirklich neu gepainted werden muss
/*N*/ 		//!	immer flackert zu viel, weil ein Control sich immer komplett zeichnet
/*N*/ 
/*N*/ 		if (!bIsInPaint)
/*N*/ 		{
/*N*/ 			//	Controls unter dem Cursor ?
/*N*/ 
/*N*/ 			ScMarkData& rMark = pViewData->GetMarkData();
/*N*/ 			BOOL bMarked = ( rMark.IsMarked() || rMark.IsMultiMarked() );
/*N*/ 
/*N*/ 			ScDocument* pDoc = pViewData->GetDocument();
/*N*/ 			USHORT nTab = pViewData->GetTabNo();
/*N*/ 			USHORT nX = pViewData->GetCurX();
/*N*/ 			USHORT nY = pViewData->GetCurY();
/*N*/ 
/*N*/ 			Point aScrPos = pViewData->GetScrPos( nX, nY, eWhich );
/*N*/ 			long nSizeXPix;
/*N*/ 			long nSizeYPix;
/*N*/ 			pViewData->GetMergeSizePixel( nX, nY, nSizeXPix, nSizeYPix );
/*N*/ 			aScrPos.X() -= 2;
/*N*/ 			aScrPos.Y() -= 2;
/*N*/ 			Rectangle aPixRect( aScrPos, Size( nSizeXPix+4,nSizeYPix+4 ) );
/*N*/ 
/*N*/ 			if ( bAutoMarkVisible && aAutoMarkPos == ScAddress(nX,nY,nTab) )
/*N*/ 			{
/*N*/ 				aPixRect.Right() += 2;		// Anfasser mit einschliessen
/*N*/ 				aPixRect.Bottom() += 2;
/*N*/ 			}
/*N*/ 
/*N*/ 			MapMode aDrawMode = GetDrawMapMode();
/*N*/ 			Rectangle aLogicRect = PixelToLogic( aPixRect, aDrawMode );
/*N*/ 
/*N*/ 			if (pDoc->HasControl( nTab, aLogicRect ))
/*N*/ 			{
/*?*/ 				Invalidate( PixelToLogic( aPixRect ) );
/*?*/ 				if (bMarked)
/*?*/ 					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pDoc->InvalidateControls( this, nTab, aLogicRect );
/*?*/ 
/*?*/ 				Update();
/*?*/ 				bDrawCursor = FALSE;		// nicht per XOR malen
/*N*/ 			}
/*N*/ 
/*N*/ 			//	Controls unter dem AutoFill-Anfasser ?
/*N*/ 
/*N*/ 			if ( bAutoMarkVisible && aAutoMarkPos.Tab() == nTab )
/*N*/ 			{
/*N*/ 				if ( aAutoMarkPos == ScAddress(nX,nY,nTab) )
/*N*/ 					bDrawAuto = bDrawCursor;						// schon erledigt
/*N*/ 				else
/*N*/ 				{
/*?*/ 					USHORT nAutoX = aAutoMarkPos.Col();
/*?*/ 					USHORT nAutoY = aAutoMarkPos.Row();
/*?*/ 					Point aFillPos = pViewData->GetScrPos( nAutoX, nAutoY, eWhich, TRUE );
/*?*/ 					long nSizeXPix;
/*?*/ 					long nSizeYPix;
/*?*/ 					pViewData->GetMergeSizePixel( nAutoX, nAutoY, nSizeXPix, nSizeYPix );
/*?*/ 					aFillPos.X() += nSizeXPix;
/*?*/ 					aFillPos.Y() += nSizeYPix;
/*?*/ 
/*?*/ 					aFillPos.X() -= 2;
/*?*/ 					aFillPos.Y() -= 2;
/*?*/ 					Rectangle aFillRect( aFillPos, Size(6,6) );
/*?*/ 
/*?*/ 					Rectangle aLogicFill = PixelToLogic( aFillRect, aDrawMode );
/*?*/ 					if (pDoc->HasControl( nTab, aLogicFill ))
/*?*/ 					{
/*?*/ 						Invalidate( PixelToLogic( aFillRect ) );
/*?*/ 						if (bMarked)
/*?*/ 							{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pDoc->InvalidateControls( this, nTab, aLogicFill );
/*?*/ 
/*?*/ 						Update();
/*?*/ 						bDrawAuto = FALSE;
/*?*/ 					}
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if (bDrawCursor)
/*N*/ 			DrawCursor();
/*N*/ 		if (bDrawAuto)
/*N*/ 			DrawAutoFillMark();
/*N*/ 	}
/*N*/ }

/*N*/ void ScGridWindow::ShowCursor()
/*N*/ {
/*N*/ 	if (nCursorHideCount==0)
/*N*/ 	{
/*N*/ 		DBG_ERROR("zuviel ShowCursor");
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	--nCursorHideCount;
/*N*/ 	if (nCursorHideCount==0)
/*N*/ 	{
/*N*/ 		DrawAutoFillMark();
/*N*/ 		DrawCursor();
/*N*/ 	}
/*N*/ }

//STRIP001 void __EXPORT ScGridWindow::GetFocus()
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = pViewData->GetViewShell();
//STRIP001 	pViewShell->GotFocus();
//STRIP001 
//STRIP001     if (pViewShell->HasAccessibilityObjects())
//STRIP001 		pViewShell->BroadcastAccessibility(ScAccGridWinFocusGotHint(eWhich, GetAccessible()));
//STRIP001 
//STRIP001 
//STRIP001 	if ( !SC_MOD()->IsFormulaMode() )
//STRIP001 	{
//STRIP001 		pViewShell->UpdateInputHandler();
//STRIP001 //		StopMarking();		// falls Dialog (Fehler), weil dann kein ButtonUp
//STRIP001 							// MO: nur wenn nicht im RefInput-Modus
//STRIP001 							//     -> GetFocus/MouseButtonDown-Reihenfolge
//STRIP001 							//		  auf dem Mac
//STRIP001 	}
//STRIP001 
//STRIP001 	Window::GetFocus();
//STRIP001 }

//STRIP001 void __EXPORT ScGridWindow::LoseFocus()
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = pViewData->GetViewShell();
//STRIP001 	pViewShell->LostFocus();
//STRIP001 
//STRIP001     if (pViewShell->HasAccessibilityObjects())
//STRIP001 		pViewShell->BroadcastAccessibility(ScAccGridWinFocusLostHint(eWhich, GetAccessible()));
//STRIP001 
//STRIP001 	Window::LoseFocus();
//STRIP001 }

//STRIP001 Point ScGridWindow::GetMousePosPixel() const  { return aCurMousePos; }

//------------------------------------------------------------------------

//STRIP001 BOOL ScGridWindow::HitRangeFinder( const Point& rMouse, BOOL& rCorner,
//STRIP001 								USHORT* pIndex, short* pAddX, short* pAddY )
//STRIP001 {
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 	ScInputHandler* pHdl = SC_MOD()->GetInputHdl( pViewData->GetViewShell() );
//STRIP001 	if (pHdl)
//STRIP001 	{
//STRIP001 		ScRangeFindList* pRangeFinder = pHdl->GetRangeFindList();
//STRIP001 		if ( pRangeFinder && !pRangeFinder->IsHidden() &&
//STRIP001 				pRangeFinder->GetDocName() == pViewData->GetDocShell()->GetTitle() )
//STRIP001 		{
//STRIP001 			short nPosX, nPosY;
//STRIP001 			pViewData->GetPosFromPixel( rMouse.X(), rMouse.Y(), eWhich, nPosX, nPosY );
//STRIP001 			//	zusammengefasste (einzeln/Bereich) ???
//STRIP001 			ScAddress aAddr( nPosX, nPosY, pViewData->GetTabNo() );
//STRIP001 
//STRIP001 //			Point aNext = pViewData->GetScrPos( nPosX+1, nPosY+1, eWhich );
//STRIP001 
//STRIP001 			Point aNext = pViewData->GetScrPos( nPosX, nPosY, eWhich, TRUE );
//STRIP001 			long nSizeXPix;
//STRIP001 			long nSizeYPix;
//STRIP001 			pViewData->GetMergeSizePixel( nPosX, nPosY, nSizeXPix, nSizeYPix );
//STRIP001 			aNext.X() += nSizeXPix;
//STRIP001 			aNext.Y() += nSizeYPix;
//STRIP001 
//STRIP001 			BOOL bCellCorner = ( rMouse.X() >= aNext.X() - 8 && rMouse.X() <= aNext.X() &&
//STRIP001 								 rMouse.Y() >= aNext.Y() - 8 && rMouse.Y() <= aNext.Y() );
//STRIP001 			//	Corner wird nur erkannt, wenn noch innerhalb der Zelle
//STRIP001 
//STRIP001 			USHORT nCount = (USHORT)pRangeFinder->Count();
//STRIP001 			for (USHORT i=nCount; i;)
//STRIP001 			{
//STRIP001 				//	rueckwaerts suchen, damit der zuletzt gepaintete Rahmen gefunden wird
//STRIP001 				--i;
//STRIP001 				ScRangeFindData* pData = pRangeFinder->GetObject(i);
//STRIP001 				if ( pData && pData->aRef.In(aAddr) )
//STRIP001 				{
//STRIP001 					if (pIndex)	*pIndex = i;
//STRIP001 					if (pAddX)	*pAddX = nPosX - pData->aRef.aStart.Col();
//STRIP001 					if (pAddY)	*pAddY = nPosY - pData->aRef.aStart.Row();
//STRIP001 					bFound = TRUE;
//STRIP001 					rCorner = ( bCellCorner && aAddr == pData->aRef.aEnd );
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bFound;
//STRIP001 }

#define SCE_TOP		1
#define SCE_BOTTOM	2
#define SCE_LEFT	4
#define SCE_RIGHT	8
#define SCE_ALL		15

//STRIP001 void lcl_PaintOneRange( ScDocShell* pDocSh, const ScRange& rRange, USHORT nEdges )
//STRIP001 {
//STRIP001 	//	der Range ist immer richtigherum
//STRIP001 
//STRIP001 	USHORT nCol1 = rRange.aStart.Col();
//STRIP001 	USHORT nRow1 = rRange.aStart.Row();
//STRIP001 	USHORT nTab1 = rRange.aStart.Tab();
//STRIP001 	USHORT nCol2 = rRange.aEnd.Col();
//STRIP001 	USHORT nRow2 = rRange.aEnd.Row();
//STRIP001 	USHORT nTab2 = rRange.aEnd.Tab();
//STRIP001 	BOOL bHiddenEdge = FALSE;
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	while ( nCol1 > 0 && ( pDoc->GetColFlags( nCol1, nTab1 ) & CR_HIDDEN ) )
//STRIP001 	{
//STRIP001 		--nCol1;
//STRIP001 		bHiddenEdge = TRUE;
//STRIP001 	}
//STRIP001 	while ( nCol2 < MAXCOL && ( pDoc->GetColFlags( nCol2, nTab1 ) & CR_HIDDEN ) )
//STRIP001 	{
//STRIP001 		++nCol2;
//STRIP001 		bHiddenEdge = TRUE;
//STRIP001 	}
//STRIP001 	while ( nRow1 > 0 && ( pDoc->GetRowFlags( nRow1, nTab1 ) & CR_HIDDEN ) )
//STRIP001 	{
//STRIP001 		--nRow1;
//STRIP001 		bHiddenEdge = TRUE;
//STRIP001 	}
//STRIP001 	while ( nRow2 < MAXROW && ( pDoc->GetRowFlags( nRow2, nTab1 ) & CR_HIDDEN ) )
//STRIP001 	{
//STRIP001 		++nRow2;
//STRIP001 		bHiddenEdge = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nCol2 > nCol1 + 1 && nRow2 > nRow1 + 1 && !bHiddenEdge )
//STRIP001 	{
//STRIP001 		//	nur an den Raendern entlang
//STRIP001 		//	(die Ecken werden evtl. zweimal getroffen)
//STRIP001 
//STRIP001 		if ( nEdges & SCE_TOP )
//STRIP001 			pDocSh->PostPaint( nCol1, nRow1, nTab1, nCol2, nRow1, nTab2, PAINT_MARKS );
//STRIP001 		if ( nEdges & SCE_LEFT )
//STRIP001 			pDocSh->PostPaint( nCol1, nRow1, nTab1, nCol1, nRow2, nTab2, PAINT_MARKS );
//STRIP001 		if ( nEdges & SCE_RIGHT )
//STRIP001 			pDocSh->PostPaint( nCol2, nRow1, nTab1, nCol2, nRow2, nTab2, PAINT_MARKS );
//STRIP001 		if ( nEdges & SCE_BOTTOM )
//STRIP001 			pDocSh->PostPaint( nCol1, nRow2, nTab1, nCol2, nRow2, nTab2, PAINT_MARKS );
//STRIP001 	}
//STRIP001 	else	// everything in one call
//STRIP001 		pDocSh->PostPaint( nCol1, nRow1, nTab1, nCol2, nRow2, nTab2, PAINT_MARKS );
//STRIP001 }

//STRIP001 void lcl_PaintRefChanged( ScDocShell* pDocSh, const ScRange& rOldUn, const ScRange& rNewUn )
//STRIP001 {
//STRIP001 	//	Repaint fuer die Teile des Rahmens in Old, die bei New nicht mehr da sind
//STRIP001 
//STRIP001 	ScRange aOld = rOldUn;
//STRIP001 	ScRange aNew = rNewUn;
//STRIP001 	aOld.Justify();
//STRIP001 	aNew.Justify();
//STRIP001 
//STRIP001 	if ( aOld.aStart == aOld.aEnd )					//! Tab ignorieren?
//STRIP001 		pDocSh->GetDocument()->ExtendMerge(aOld);
//STRIP001 	if ( aNew.aStart == aNew.aEnd )					//! Tab ignorieren?
//STRIP001 		pDocSh->GetDocument()->ExtendMerge(aNew);
//STRIP001 
//STRIP001 	USHORT nOldCol1 = aOld.aStart.Col();
//STRIP001 	USHORT nOldRow1 = aOld.aStart.Row();
//STRIP001 	USHORT nOldCol2 = aOld.aEnd.Col();
//STRIP001 	USHORT nOldRow2 = aOld.aEnd.Row();
//STRIP001 	USHORT nNewCol1 = aNew.aStart.Col();
//STRIP001 	USHORT nNewRow1 = aNew.aStart.Row();
//STRIP001 	USHORT nNewCol2 = aNew.aEnd.Col();
//STRIP001 	USHORT nNewRow2 = aNew.aEnd.Row();
//STRIP001 	USHORT nTab1 = aOld.aStart.Tab();		// Tab aendert sich nicht
//STRIP001 	USHORT nTab2 = aOld.aEnd.Tab();
//STRIP001 
//STRIP001 	if ( nNewRow2 < nOldRow1 || nNewRow1 > nOldRow2 ||
//STRIP001 		 nNewCol2 < nOldCol1 || nNewCol1 > nOldCol2 ||
//STRIP001 		 ( nNewCol1 != nOldCol1 && nNewRow1 != nOldRow1 &&
//STRIP001 		   nNewCol2 != nOldCol2 && nNewRow2 != nOldRow2 ) )
//STRIP001 	{
//STRIP001 		//	komplett weggeschoben oder alle Seiten veraendert
//STRIP001 		//	(Abfrage <= statt < geht schief bei einzelnen Zeilen/Spalten)
//STRIP001 
//STRIP001 		lcl_PaintOneRange( pDocSh, aOld, SCE_ALL );
//STRIP001 	}
//STRIP001 	else		//	alle vier Kanten einzeln testen
//STRIP001 	{
//STRIP001 		//	oberer Teil
//STRIP001 		if ( nNewRow1 < nOldRow1 )					//	nur obere Linie loeschen
//STRIP001 			lcl_PaintOneRange( pDocSh, ScRange(
//STRIP001 					nOldCol1, nOldRow1, nTab1, nOldCol2, nOldRow1, nTab2 ), SCE_ALL );
//STRIP001 		else if ( nNewRow1 > nOldRow1 )				//	den Teil, der oben wegkommt
//STRIP001 			lcl_PaintOneRange( pDocSh, ScRange(
//STRIP001 					nOldCol1, nOldRow1, nTab1, nOldCol2, nNewRow1-1, nTab2 ),
//STRIP001 					SCE_ALL &~ SCE_BOTTOM );
//STRIP001 
//STRIP001 		//	unterer Teil
//STRIP001 		if ( nNewRow2 > nOldRow2 )					//	nur untere Linie loeschen
//STRIP001 			lcl_PaintOneRange( pDocSh, ScRange(
//STRIP001 					nOldCol1, nOldRow2, nTab1, nOldCol2, nOldRow2, nTab2 ), SCE_ALL );
//STRIP001 		else if ( nNewRow2 < nOldRow2 )				//	den Teil, der unten wegkommt
//STRIP001 			lcl_PaintOneRange( pDocSh, ScRange(
//STRIP001 					nOldCol1, nNewRow2+1, nTab1, nOldCol2, nOldRow2, nTab2 ),
//STRIP001 					SCE_ALL &~ SCE_TOP );
//STRIP001 
//STRIP001 		//	linker Teil
//STRIP001 		if ( nNewCol1 < nOldCol1 )					//	nur linke Linie loeschen
//STRIP001 			lcl_PaintOneRange( pDocSh, ScRange(
//STRIP001 					nOldCol1, nOldRow1, nTab1, nOldCol1, nOldRow2, nTab2 ), SCE_ALL );
//STRIP001 		else if ( nNewCol1 > nOldCol1 )				//	den Teil, der links wegkommt
//STRIP001 			lcl_PaintOneRange( pDocSh, ScRange(
//STRIP001 					nOldCol1, nOldRow1, nTab1, nNewCol1-1, nOldRow2, nTab2 ),
//STRIP001 					SCE_ALL &~ SCE_RIGHT );
//STRIP001 
//STRIP001 		//	rechter Teil
//STRIP001 		if ( nNewCol2 > nOldCol2 )					//	nur rechte Linie loeschen
//STRIP001 			lcl_PaintOneRange( pDocSh, ScRange(
//STRIP001 					nOldCol2, nOldRow1, nTab1, nOldCol2, nOldRow2, nTab2 ), SCE_ALL );
//STRIP001 		else if ( nNewCol2 < nOldCol2 )				//	den Teil, der rechts wegkommt
//STRIP001 			lcl_PaintOneRange( pDocSh, ScRange(
//STRIP001 					nNewCol2+1, nOldRow1, nTab1, nOldCol2, nOldRow2, nTab2 ),
//STRIP001 					SCE_ALL &~ SCE_LEFT );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScGridWindow::RFMouseMove( const MouseEvent& rMEvt, BOOL bUp )
//STRIP001 {
//STRIP001 	ScInputHandler* pHdl = SC_MOD()->GetInputHdl( pViewData->GetViewShell() );
//STRIP001 	if (!pHdl)
//STRIP001 		return;
//STRIP001 	ScRangeFindList* pRangeFinder = pHdl->GetRangeFindList();
//STRIP001 	if (!pRangeFinder || nRFIndex >= pRangeFinder->Count())
//STRIP001 		return;
//STRIP001 	ScRangeFindData* pData = pRangeFinder->GetObject( nRFIndex );
//STRIP001 	if (!pData)
//STRIP001 		return;
//STRIP001 
//STRIP001 	//	Mauszeiger
//STRIP001 
//STRIP001 	if (bRFSize)
//STRIP001 		SetPointer( Pointer( POINTER_CROSS ) );
//STRIP001 	else
//STRIP001 		SetPointer( Pointer( POINTER_HAND ) );
//STRIP001 
//STRIP001 	//	Scrolling
//STRIP001 
//STRIP001 	BOOL bTimer = FALSE;
//STRIP001 	Point aPos = rMEvt.GetPosPixel();
//STRIP001 	short nDx = 0;
//STRIP001 	short nDy = 0;
//STRIP001 	if ( aPos.X() < 0 ) nDx = -1;
//STRIP001 	if ( aPos.Y() < 0 ) nDy = -1;
//STRIP001 	Size aSize = GetOutputSizePixel();
//STRIP001 	if ( aPos.X() >= aSize.Width() )
//STRIP001 		nDx = 1;
//STRIP001 	if ( aPos.Y() >= aSize.Height() )
//STRIP001 		nDy = 1;
//STRIP001 	if ( nDx || nDy )
//STRIP001 	{
//STRIP001 		if ( nDx ) pViewData->GetView()->ScrollX( nDx, WhichH(eWhich) );
//STRIP001 		if ( nDy ) pViewData->GetView()->ScrollY( nDy, WhichV(eWhich) );
//STRIP001 		bTimer = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Umschalten bei Fixierung (damit Scrolling funktioniert)
//STRIP001 
//STRIP001 	if ( eWhich == pViewData->GetActivePart() )		//??
//STRIP001 	{
//STRIP001 		if ( pViewData->GetHSplitMode() == SC_SPLIT_FIX )
//STRIP001 			if ( nDx > 0 )
//STRIP001 			{
//STRIP001 				if ( eWhich == SC_SPLIT_TOPLEFT )
//STRIP001 					pViewData->GetView()->ActivatePart( SC_SPLIT_TOPRIGHT );
//STRIP001 				else if ( eWhich == SC_SPLIT_BOTTOMLEFT )
//STRIP001 					pViewData->GetView()->ActivatePart( SC_SPLIT_BOTTOMRIGHT );
//STRIP001 			}
//STRIP001 
//STRIP001 		if ( pViewData->GetVSplitMode() == SC_SPLIT_FIX )
//STRIP001 			if ( nDy > 0 )
//STRIP001 			{
//STRIP001 				if ( eWhich == SC_SPLIT_TOPLEFT )
//STRIP001 					pViewData->GetView()->ActivatePart( SC_SPLIT_BOTTOMLEFT );
//STRIP001 				else if ( eWhich == SC_SPLIT_TOPRIGHT )
//STRIP001 					pViewData->GetView()->ActivatePart( SC_SPLIT_BOTTOMRIGHT );
//STRIP001 			}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Verschieben
//STRIP001 
//STRIP001 	short	nPosX;
//STRIP001 	short	nPosY;
//STRIP001 	pViewData->GetPosFromPixel( aPos.X(), aPos.Y(), eWhich, nPosX, nPosY );
//STRIP001 
//STRIP001 	ScRange aOld = pData->aRef;
//STRIP001 	ScRange aNew = aOld;
//STRIP001 	if ( bRFSize )
//STRIP001 	{
//STRIP001 		aNew.aEnd.SetCol((USHORT)nPosX);
//STRIP001 		aNew.aEnd.SetRow((USHORT)nPosY);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		long nStartX = nPosX - nRFAddX;
//STRIP001 		if ( nStartX < 0 ) nStartX = 0;
//STRIP001 		long nStartY = nPosY - nRFAddY;
//STRIP001 		if ( nStartY < 0 ) nStartY = 0;
//STRIP001 		long nEndX = nStartX + aOld.aEnd.Col() - aOld.aStart.Col();
//STRIP001 		if ( nEndX > MAXCOL )
//STRIP001 		{
//STRIP001 			nStartX -= ( nEndX - MAXROW );
//STRIP001 			nEndX = MAXCOL;
//STRIP001 		}
//STRIP001 		long nEndY = nStartY + aOld.aEnd.Row() - aOld.aStart.Row();
//STRIP001 		if ( nEndY > MAXROW )
//STRIP001 		{
//STRIP001 			nStartY -= ( nEndY - MAXROW );
//STRIP001 			nEndY = MAXROW;
//STRIP001 		}
//STRIP001 
//STRIP001 		aNew.aStart.SetCol((USHORT)nStartX);
//STRIP001 		aNew.aStart.SetRow((USHORT)nStartY);
//STRIP001 		aNew.aEnd.SetCol((USHORT)nEndX);
//STRIP001 		aNew.aEnd.SetRow((USHORT)nEndY);
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bUp )
//STRIP001 		aNew.Justify();				// beim ButtonUp wieder richtigherum
//STRIP001 
//STRIP001 	if ( aNew != aOld )
//STRIP001 	{
//STRIP001 		pHdl->UpdateRange( nRFIndex, aNew );
//STRIP001 
//STRIP001 		ScDocShell* pDocSh = pViewData->GetDocShell();
//STRIP001 
//STRIP001 		//	nur das neuzeichnen, was sich veraendert hat...
//STRIP001 		lcl_PaintRefChanged( pDocSh, aOld, aNew );
//STRIP001 
//STRIP001 		//	neuen Rahmen nur drueberzeichnen (synchron)
//STRIP001 		pDocSh->Broadcast( ScIndexHint( SC_HINT_SHOWRANGEFINDER, nRFIndex ) );
//STRIP001 
//STRIP001 		Update();	// was man bewegt, will man auch sofort sehen
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Timer fuer Scrolling
//STRIP001 
//STRIP001 	if (bTimer)
//STRIP001 		pViewData->GetView()->SetTimer( this, rMEvt );			// Event wiederholen
//STRIP001 	else
//STRIP001 		pViewData->GetView()->ResetTimer();
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 BOOL ScGridWindow::GetEditUrl( const Point& rPos,
//STRIP001 								String* pName, String* pUrl, String* pTarget )
//STRIP001 {
//STRIP001 	return GetEditUrlOrError( FALSE, rPos, pName, pUrl, pTarget );
//STRIP001 }

//STRIP001 BOOL ScGridWindow::GetEditUrlOrError( BOOL bSpellErr, const Point& rPos,
//STRIP001 								String* pName, String* pUrl, String* pTarget )
//STRIP001 {
//STRIP001 	//!	nPosX/Y mit uebergeben?
//STRIP001 	short nPosX;
//STRIP001 	short nPosY;
//STRIP001 	pViewData->GetPosFromPixel( rPos.X(), rPos.Y(), eWhich, nPosX, nPosY );
//STRIP001 
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	ScDocShell* pDocSh = pViewData->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	ScBaseCell* pCell = NULL;
//STRIP001 
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 	do
//STRIP001 	{
//STRIP001 		pDoc->GetCell( nPosX, nPosY, nTab, pCell );
//STRIP001 		if ( !pCell || pCell->GetCellType() == CELLTYPE_NOTE )
//STRIP001 		{
//STRIP001 			if ( nPosX <= 0 )
//STRIP001 				return FALSE;							// alles leer bis links
//STRIP001 			else
//STRIP001 				--nPosX;								// weitersuchen
//STRIP001 		}
//STRIP001 		else if ( pCell->GetCellType() == CELLTYPE_EDIT )
//STRIP001 			bFound = TRUE;
//STRIP001 		else
//STRIP001 			return FALSE;								// andere Zelle
//STRIP001 	}
//STRIP001 	while ( !bFound );
//STRIP001 
//STRIP001 	ScHideTextCursor aHideCursor( pViewData, eWhich );	// before GetEditArea (MapMode is changed)
//STRIP001 
//STRIP001 	const ScPatternAttr* pPattern = pDoc->GetPattern( nPosX, nPosY, nTab );
//STRIP001 	// bForceToTop = FALSE, use the cell's real position
//STRIP001 	Rectangle aEditRect = pViewData->GetEditArea( eWhich, nPosX, nPosY, this, pPattern, FALSE );
//STRIP001 	if (rPos.Y() < aEditRect.Top())
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 		//	vertikal kann (noch) nicht angeklickt werden:
//STRIP001 
//STRIP001 	SvxCellOrientation eOrient = (SvxCellOrientation) ((SvxOrientationItem&)pPattern->
//STRIP001 											GetItem(ATTR_ORIENTATION)).GetValue();
//STRIP001 	if (eOrient != SVX_ORIENTATION_STANDARD)
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	BOOL bBreak = ((SfxBoolItem&)pPattern->GetItem(ATTR_LINEBREAK)).GetValue() ||
//STRIP001 					((SvxCellHorJustify)((const SvxHorJustifyItem&)pPattern->
//STRIP001 						GetItem( ATTR_HOR_JUSTIFY )).GetValue() == SVX_HOR_JUSTIFY_BLOCK);
//STRIP001 	SvxCellHorJustify eHorJust = (SvxCellHorJustify)((SvxHorJustifyItem&)pPattern->
//STRIP001 						GetItem(ATTR_HOR_JUSTIFY)).GetValue();
//STRIP001 
//STRIP001 		//	EditEngine
//STRIP001 
//STRIP001 	ScFieldEditEngine aEngine( pDoc->GetEditPool() );
//STRIP001 	ScSizeDeviceProvider aProv(pDocSh);
//STRIP001 	aEngine.SetRefDevice( aProv.GetDevice() );
//STRIP001 	aEngine.SetRefMapMode( MAP_100TH_MM );
//STRIP001 	SfxItemSet aDefault( aEngine.GetEmptyItemSet() );
//STRIP001 	pPattern->FillEditItemSet( &aDefault );
//STRIP001 	SvxAdjust eSvxAdjust = SVX_ADJUST_LEFT;
//STRIP001 	switch (eHorJust)
//STRIP001 	{
//STRIP001 		case SVX_HOR_JUSTIFY_LEFT:
//STRIP001 		case SVX_HOR_JUSTIFY_REPEAT:			// nicht implementiert
//STRIP001 		case SVX_HOR_JUSTIFY_STANDARD:			// immer Text
//STRIP001 				eSvxAdjust = SVX_ADJUST_LEFT;
//STRIP001 				break;
//STRIP001 		case SVX_HOR_JUSTIFY_RIGHT:
//STRIP001 				eSvxAdjust = SVX_ADJUST_RIGHT;
//STRIP001 				break;
//STRIP001 		case SVX_HOR_JUSTIFY_CENTER:
//STRIP001 				eSvxAdjust = SVX_ADJUST_CENTER;
//STRIP001 				break;
//STRIP001 		case SVX_HOR_JUSTIFY_BLOCK:
//STRIP001 				eSvxAdjust = SVX_ADJUST_BLOCK;
//STRIP001 				break;
//STRIP001 	}
//STRIP001 	aDefault.Put( SvxAdjustItem( eSvxAdjust, EE_PARA_JUST ) );
//STRIP001 	aEngine.SetDefaults( aDefault );
//STRIP001 	if (bSpellErr)
//STRIP001 		aEngine.SetControlWord( aEngine.GetControlWord() | EE_CNTRL_ONLINESPELLING );
//STRIP001 
//STRIP001 	MapMode aEditMode = pViewData->GetLogicMode(eWhich);			// ohne Drawing-Skalierung
//STRIP001 	Rectangle aLogicEdit = PixelToLogic( aEditRect, aEditMode );
//STRIP001 	long nThisColLogic = aLogicEdit.Right() - aLogicEdit.Left() + 1;
//STRIP001 
//STRIP001 	Size aPaperSize = Size( 1000000, 1000000 );
//STRIP001 	if (bBreak)
//STRIP001 		aPaperSize.Width() = nThisColLogic;
//STRIP001 	aEngine.SetPaperSize( aPaperSize );
//STRIP001 
//STRIP001 	const EditTextObject* pData;
//STRIP001 	((ScEditCell*)pCell)->GetData(pData);
//STRIP001 	if (pData)
//STRIP001 		aEngine.SetText(*pData);
//STRIP001 
//STRIP001 	long nStartX = aLogicEdit.Left();
//STRIP001 
//STRIP001 	long nTextWidth = aEngine.CalcTextWidth();
//STRIP001 	long nTextHeight = aEngine.GetTextHeight();
//STRIP001 	if ( nTextWidth < nThisColLogic )
//STRIP001 	{
//STRIP001 		if (eHorJust == SVX_HOR_JUSTIFY_RIGHT)
//STRIP001 			nStartX += nThisColLogic - nTextWidth;
//STRIP001 		else if (eHorJust == SVX_HOR_JUSTIFY_CENTER)
//STRIP001 			nStartX += (nThisColLogic - nTextWidth) / 2;
//STRIP001 	}
//STRIP001 
//STRIP001 	aLogicEdit.Left() = nStartX;
//STRIP001 	if (!bBreak)
//STRIP001 		aLogicEdit.Right() = nStartX + nTextWidth;
//STRIP001 	aLogicEdit.Bottom() = aLogicEdit.Top() + nTextHeight;
//STRIP001 
//STRIP001 	Point aLogicClick = PixelToLogic(rPos,aEditMode);
//STRIP001 	if ( aLogicEdit.IsInside(aLogicClick) )
//STRIP001 	{
//STRIP001 //		aEngine.SetUpdateMode(FALSE);
//STRIP001 		EditView aTempView( &aEngine, this );
//STRIP001 		aTempView.SetOutputArea( aLogicEdit );
//STRIP001 
//STRIP001 		BOOL bRet = FALSE;
//STRIP001 		MapMode aOld = GetMapMode();
//STRIP001 		SetMapMode(aEditMode);					// kein return mehr
//STRIP001 
//STRIP001 		if (bSpellErr)							// Spelling-Fehler suchen
//STRIP001 		{
//STRIP001 			bRet = aTempView.IsWrongSpelledWordAtPos( rPos );
//STRIP001 			if ( bRet )
//STRIP001 				pViewData->GetView()->SetCursor( nPosX, nPosY );		// Cursor setzen
//STRIP001 		}
//STRIP001 		else									// URL suchen
//STRIP001 		{
//STRIP001 			const SvxFieldItem*	pFieldItem = aTempView.GetFieldUnderMousePointer();
//STRIP001 
//STRIP001 			if (pFieldItem)
//STRIP001 			{
//STRIP001 				const SvxFieldData* pField = pFieldItem->GetField();
//STRIP001 				if ( pField && pField->ISA(SvxURLField) )
//STRIP001 				{
//STRIP001 					if ( pName || pUrl || pTarget )
//STRIP001 					{
//STRIP001 						const SvxURLField* pURLField = (const SvxURLField*)pField;
//STRIP001 						if (pName)
//STRIP001 							*pName = pURLField->GetRepresentation();
//STRIP001 						if (pUrl)
//STRIP001 							*pUrl = pURLField->GetURL();
//STRIP001 						if (pTarget)
//STRIP001 							*pTarget = pURLField->GetTargetFrame();
//STRIP001 					}
//STRIP001 					bRet = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		SetMapMode(aOld);
//STRIP001 
//STRIP001 		//	text cursor is restored in ScHideTextCursor dtor
//STRIP001 
//STRIP001 		return bRet;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 BOOL ScGridWindow::HasScenarioButton( const Point& rPosPixel, ScRange& rScenRange )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	if ( nTab+1<nTabCount && pDoc->IsScenario(nTab+1) && !pDoc->IsScenario(nTab) )
//STRIP001 	{
//STRIP001 		Size aButSize = pViewData->GetScenButSize();
//STRIP001 		long nBWidth  = aButSize.Width();
//STRIP001 		if (!nBWidth)
//STRIP001 			return FALSE;					// noch kein Button gezeichnet -> da ist auch keiner
//STRIP001 		long nBHeight = aButSize.Height();
//STRIP001 		long nHSpace  = (long)( SC_SCENARIO_HSPACE * pViewData->GetPPTX() );
//STRIP001 
//STRIP001 		//!	Ranges an der Table cachen!!!!
//STRIP001 
//STRIP001 		USHORT i;
//STRIP001 		ScMarkData aMarks;
//STRIP001 		for (i=nTab+1; i<nTabCount && pDoc->IsScenario(i); i++)
//STRIP001 			pDoc->MarkScenario( i, nTab, aMarks, FALSE, SC_SCENARIO_SHOWFRAME );
//STRIP001 		ScRangeList aRanges;
//STRIP001 		aMarks.FillRangeListWithMarks( &aRanges, FALSE );
//STRIP001 
//STRIP001 
//STRIP001 		USHORT nRangeCount = (USHORT)aRanges.Count();
//STRIP001 		for (i=0; i<nRangeCount; i++)
//STRIP001 		{
//STRIP001 			ScRange aRange = *aRanges.GetObject(i);
//STRIP001 			//	Szenario-Rahmen immer dann auf zusammengefasste Zellen erweitern, wenn
//STRIP001 			//	dadurch keine neuen nicht-ueberdeckten Zellen mit umrandet werden
//STRIP001 			pDoc->ExtendTotalMerge( aRange );
//STRIP001 
//STRIP001 			BOOL bTextBelow = ( aRange.aStart.Row() == 0 );
//STRIP001 
//STRIP001 			Point aButtonPos;
//STRIP001 			if ( bTextBelow )
//STRIP001 			{
//STRIP001 				aButtonPos = pViewData->GetScrPos( aRange.aEnd.Col()+1, aRange.aEnd.Row()+1,
//STRIP001 													eWhich, TRUE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aButtonPos = pViewData->GetScrPos( aRange.aEnd.Col()+1, aRange.aStart.Row(),
//STRIP001 													eWhich, TRUE );
//STRIP001 				aButtonPos.Y() -= nBHeight;
//STRIP001 			}
//STRIP001 			aButtonPos.X() -= nBWidth - nHSpace;	// in beiden Faellen gleich
//STRIP001 
//STRIP001 			Rectangle aButRect( aButtonPos, Size(nBWidth,nBHeight) );
//STRIP001 			if ( aButRect.IsInside( rPosPixel ) )
//STRIP001 			{
//STRIP001 				rScenRange = aRange;
//STRIP001 				return TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }




}
