/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_invmerge.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:29:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

#include <vcl/window.hxx>
// auto strip #include <tools/debug.hxx>

#include "invmerge.hxx"
namespace binfilter {

//------------------------------------------------------------------

/*N*/ ScInvertMerger::ScInvertMerger( Window* pWindow ) :
/*N*/ 	pWin( pWindow )
/*N*/ {
/*N*/ 	//	both rectangles empty
/*N*/ }

/*N*/ ScInvertMerger::~ScInvertMerger()
/*N*/ {
/*N*/ 	Flush();
/*N*/ }

/*N*/ void ScInvertMerger::Flush()
/*N*/ {
/*N*/ 	FlushLine();
/*N*/ 	FlushTotal();
/*N*/ 
/*N*/ 	DBG_ASSERT( aLineRect.IsEmpty() && aTotalRect.IsEmpty(), "Flush: not empty" );
/*N*/ }

/*N*/ void ScInvertMerger::FlushTotal()
/*N*/ {
/*N*/ 	if( aTotalRect.IsEmpty() )
/*N*/ 		return;							// nothing to do
/*N*/ 
/*?*/ 	pWin->Invert( aTotalRect, INVERT_HIGHLIGHT );
/*?*/ 	aTotalRect.SetEmpty();
/*N*/ }

/*N*/ void ScInvertMerger::FlushLine()
/*N*/ {
/*N*/ 	if( aLineRect.IsEmpty() )
/*N*/ 		return;							// nothing to do
/*N*/ 
/*?*/ 	if ( aTotalRect.IsEmpty() )
/*?*/ 	{
/*?*/ 		aTotalRect = aLineRect;			// start new total rect
/*?*/ 	}
/*?*/ 	else
/*?*/ 	{
/*?*/ 		if ( aLineRect.Left()  == aTotalRect.Left()  &&
/*?*/ 			 aLineRect.Right() == aTotalRect.Right() &&
/*?*/ 			 aLineRect.Top()   == aTotalRect.Bottom() + 1 )
/*?*/ 		{
/*?*/ 			// extend total rect
/*?*/ 			aTotalRect.Bottom() = aLineRect.Bottom();
/*?*/ 		}
/*?*/ 		else
/*?*/ 		{
/*?*/ 			FlushTotal();					// draw old total rect
/*?*/ 			aTotalRect = aLineRect;			// and start new one
/*?*/ 		}
/*?*/ 	}
/*?*/ 
/*?*/ 	aLineRect.SetEmpty();
/*N*/ }

//STRIP001 void ScInvertMerger::AddRect( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	if ( aLineRect.IsEmpty() )
//STRIP001 	{
//STRIP001 		aLineRect = rRect;			// start new line rect
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( rRect.Top()    == aLineRect.Top()    &&
//STRIP001 			 rRect.Bottom() == aLineRect.Bottom() &&
//STRIP001 			 rRect.Left()   == aLineRect.Right() + 1 )
//STRIP001 		{
//STRIP001 			// extend line rect
//STRIP001 			aLineRect.Right() = rRect.Right();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			FlushLine();			// use old line rect for total rect
//STRIP001 			aLineRect = rRect;		// and start new one
//STRIP001 		}
//STRIP001 	}
//STRIP001 }




}
