/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabvwsh2.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2006/08/14 13:48:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#ifdef WNT
#pragma optimize ("", off)
#endif

#include <bf_sfx2/bindings.hxx>
#include <bf_sfx2/ipfrm.hxx>
#include <svtools/aeitem.hxx>
#include <svtools/whiter.hxx>
#include <svtools/moduleoptions.hxx>
#ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
#include <svtools/languageoptions.hxx>
#endif
#include <bf_sfx2/dispatch.hxx>

#include "tabvwsh.hxx"
#include "drawattr.hxx"
#include "drawsh.hxx"
#include "drawview.hxx"
#include "fupoor.hxx"
#include "fusel.hxx"
#include "global.hxx"
#include "bf_sc.hrc"
#include "scmod.hxx"
#include "appoptio.hxx"

// #98185# Create default drawing objects via keyboard
#ifndef _SVDPAGV_HXX
#include <bf_svx/svdpagv.hxx>
#endif

#ifndef _SVDPAGE_HXX
#include <bf_svx/svdpage.hxx>
#endif
namespace binfilter {

// -----------------------------------------------------------------------

//STRIP001 SdrView* __EXPORT ScTabViewShell::GetDrawView() const
//STRIP001 {
//STRIP001 	return ((ScTabViewShell*)this)->GetScDrawView();	// GetScDrawView ist nicht-const
//STRIP001 }

//STRIP001 void ScTabViewShell::WindowChanged()
//STRIP001 {
//STRIP001 	Window* pWin = GetActiveWin();
//STRIP001 
//STRIP001 	ScDrawView* pDrView = GetScDrawView();
//STRIP001 	if (pDrView)
//STRIP001 		pDrView->SetActualWin(pWin);
//STRIP001 
//STRIP001 	FuPoor*	pFunc = GetDrawFuncPtr();
//STRIP001 	if (pFunc)
//STRIP001 		pFunc->SetWindow(pWin);
//STRIP001 
//STRIP001 	//	when font from InputContext is used,
//STRIP001 	//	this must be moved to change of cursor position:
//STRIP001 	UpdateInputContext();
//STRIP001 }

//STRIP001 void ScTabViewShell::ExecDraw(SfxRequest& rReq)
//STRIP001 {
//STRIP001 	SC_MOD()->InputEnterHandler();
//STRIP001 	UpdateInputHandler();
//STRIP001 
//STRIP001 	MakeDrawLayer();
//STRIP001 
//STRIP001 	ScTabView* pTabView = GetViewData()->GetView();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	SfxBindings& rBindings = GetViewFrame()->GetBindings();
//STRIP001 
//STRIP001 	Window* 	pWin	= pTabView->GetActiveWin();
//STRIP001 	SdrView*	pView	= pTabView->GetSdrView();
//STRIP001 	SdrModel*	pDoc	= pView->GetModel();
//STRIP001 
//STRIP001 	const SfxItemSet *pArgs = rReq.GetArgs();
//STRIP001 	USHORT nNewId = rReq.GetSlot();
//STRIP001 
//STRIP001 	//
//STRIP001 	//	Pseudo-Slots von Draw-Toolbox auswerten
//STRIP001 	//!	wird das ueberhaupt noch gebraucht ?????
//STRIP001 	//
//STRIP001 
//STRIP001 	if (nNewId == SID_INSERT_DRAW && pArgs)
//STRIP001 	{
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 		if ( pArgs->GetItemState( SID_INSERT_DRAW, TRUE, &pItem ) == SFX_ITEM_SET &&
//STRIP001 			 pItem->ISA( SvxDrawToolItem ) )
//STRIP001 		{
//STRIP001 			SvxDrawToolEnum eSel = (SvxDrawToolEnum)((const SvxDrawToolItem*)pItem)->GetValue();
//STRIP001 			switch (eSel)
//STRIP001 			{
//STRIP001 				case SVX_SNAP_DRAW_SELECT:			nNewId = SID_OBJECT_SELECT; 		break;
//STRIP001 				case SVX_SNAP_DRAW_LINE:			nNewId = SID_DRAW_LINE; 			break;
//STRIP001 				case SVX_SNAP_DRAW_RECT:			nNewId = SID_DRAW_RECT; 			break;
//STRIP001 				case SVX_SNAP_DRAW_ELLIPSE: 		nNewId = SID_DRAW_ELLIPSE;			break;
//STRIP001 				case SVX_SNAP_DRAW_POLYGON_NOFILL:	nNewId = SID_DRAW_POLYGON_NOFILL;	break;
//STRIP001 				case SVX_SNAP_DRAW_BEZIER_NOFILL:	nNewId = SID_DRAW_BEZIER_NOFILL;	break;
//STRIP001 				case SVX_SNAP_DRAW_FREELINE_NOFILL:	nNewId = SID_DRAW_FREELINE_NOFILL;	break;
//STRIP001 				case SVX_SNAP_DRAW_ARC: 			nNewId = SID_DRAW_ARC;				break;
//STRIP001 				case SVX_SNAP_DRAW_PIE: 			nNewId = SID_DRAW_PIE;				break;
//STRIP001 				case SVX_SNAP_DRAW_CIRCLECUT:		nNewId = SID_DRAW_CIRCLECUT;		break;
//STRIP001 				case SVX_SNAP_DRAW_TEXT:			nNewId = SID_DRAW_TEXT; 			break;
//STRIP001 				case SVX_SNAP_DRAW_TEXT_VERTICAL:	nNewId = SID_DRAW_TEXT_VERTICAL;	break;
//STRIP001 				case SVX_SNAP_DRAW_TEXT_MARQUEE:	nNewId = SID_DRAW_TEXT_MARQUEE;		break;
//STRIP001 				case SVX_SNAP_DRAW_CAPTION: 		nNewId = SID_DRAW_CAPTION;			break;
//STRIP001 				case SVX_SNAP_DRAW_CAPTION_VERTICAL: nNewId = SID_DRAW_CAPTION_VERTICAL; break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else					// USHORT-Item vom Controller
//STRIP001 		{
//STRIP001 			rReq.Done();
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nNewId == SID_DRAW_SELECT )
//STRIP001 		nNewId = SID_OBJECT_SELECT;
//STRIP001 
//STRIP001 	USHORT nNewFormId = 0;
//STRIP001 	if ( nNewId == SID_FM_CREATE_CONTROL && pArgs )
//STRIP001 	{
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 		if ( pArgs->GetItemState( SID_FM_CONTROL_IDENTIFIER, TRUE, &pItem ) == SFX_ITEM_SET &&
//STRIP001 			 pItem->ISA( SfxUInt16Item ) )
//STRIP001 			nNewFormId = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nNewId == SID_INSERT_FRAME)						// vom Tbx-Button
//STRIP001 		nNewId = SID_DRAW_TEXT;
//STRIP001 
//STRIP001 	//	#97016# CTRL-SID_OBJECT_SELECT is used to select the first object,
//STRIP001 	//	but not if SID_OBJECT_SELECT is the result of clicking a create function again,
//STRIP001 	//	so this must be tested before changing nNewId below.
//STRIP001 	BOOL bSelectFirst = ( nNewId == SID_OBJECT_SELECT && (rReq.GetModifier() & KEY_MOD1) );
//STRIP001 
//STRIP001 	BOOL bEx = IsDrawSelMode();
//STRIP001 	if ( rReq.GetModifier() & KEY_MOD1 )
//STRIP001 	{
//STRIP001 		//	#97016# always allow keyboard selection also on background layer
//STRIP001 		//	#98185# also allow creation of default objects if the same object type
//STRIP001 		//	was already active
//STRIP001 		bEx = TRUE;
//STRIP001 	}
//STRIP001 	else if ( nNewId == nDrawSfxId && ( nNewId != SID_FM_CREATE_CONTROL ||
//STRIP001 									nNewFormId == nFormSfxId || nNewFormId == 0 ) )
//STRIP001 	{
//STRIP001 		//	SID_FM_CREATE_CONTROL mit nNewFormId==0 (ohne Parameter) kommt beim Deaktivieren
//STRIP001 		//	aus FuConstruct::SimpleMouseButtonUp
//STRIP001 		//	#59280# Execute fuer die Form-Shell, um im Controller zu deselektieren
//STRIP001 		if ( nNewId == SID_FM_CREATE_CONTROL )
//STRIP001 		{
//STRIP001 			GetViewData()->GetDispatcher().Execute(SID_FM_LEAVE_CREATE);
//STRIP001 			GetViewFrame()->GetBindings().InvalidateAll(FALSE);
//STRIP001 			//!	was fuer einen Slot braucht der komische Controller wirklich, um das anzuzeigen????
//STRIP001 		}
//STRIP001 
//STRIP001 		bEx = !bEx;
//STRIP001 		nNewId = SID_OBJECT_SELECT;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bEx = TRUE;
//STRIP001 
//STRIP001 	if ( nDrawSfxId == SID_FM_CREATE_CONTROL && nNewId != nDrawSfxId )
//STRIP001 	{
//STRIP001 		//	Wechsel von Control- zu Zeichenfunktion -> im Control-Controller deselektieren
//STRIP001 		GetViewData()->GetDispatcher().Execute(SID_FM_LEAVE_CREATE);
//STRIP001 		GetViewFrame()->GetBindings().InvalidateAll(FALSE);
//STRIP001 		//!	was fuer einen Slot braucht der komische Controller wirklich, um das anzuzeigen????
//STRIP001 	}
//STRIP001 
//STRIP001 	SetDrawSelMode(bEx);
//STRIP001 
//STRIP001 	SdrLayer* pLayer = pView->GetModel()->GetLayerAdmin().GetLayerPerID(SC_LAYER_BACK);
//STRIP001 	if (pLayer)
//STRIP001 		pView->SetLayerLocked( pLayer->GetName(), !bEx );
//STRIP001 
//STRIP001 	if ( bSelectFirst )
//STRIP001 	{
//STRIP001 		//	#97016# select first draw object if none is selected yet
//STRIP001 		if(!pView->HasMarkedObj())
//STRIP001 		{
//STRIP001 			// select first object
//STRIP001 			pView->UnmarkAllObj();
//STRIP001 			pView->MarkNextObj(TRUE);
//STRIP001 
//STRIP001 			// ...and make it visible
//STRIP001 			if(pView->HasMarkedObj())
//STRIP001 				pView->MakeVisible(pView->GetAllMarkedRect(), *pWin);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	nDrawSfxId = nNewId;
//STRIP001 
//STRIP001 	if ( nNewId != SID_DRAW_CHART )				// Chart nicht mit DrawShell
//STRIP001 	{
//STRIP001 		if ( nNewId == SID_DRAW_TEXT || nNewId == SID_DRAW_TEXT_VERTICAL ||
//STRIP001 				nNewId == SID_DRAW_TEXT_MARQUEE || nNewId == SID_DRAW_NOTEEDIT )
//STRIP001 			SetDrawTextShell( TRUE );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( bEx || pView->GetMarkList().GetMarkCount() != 0 )
//STRIP001 				SetDrawShellOrSub();
//STRIP001 			else
//STRIP001 				SetDrawShell( FALSE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pTabView->GetDrawFuncPtr())
//STRIP001 	{
//STRIP001 		if (pTabView->GetDrawFuncOldPtr() != pTabView->GetDrawFuncPtr())
//STRIP001 			delete pTabView->GetDrawFuncOldPtr();
//STRIP001 
//STRIP001 		pTabView->GetDrawFuncPtr()->Deactivate();
//STRIP001 		pTabView->SetDrawFuncOldPtr(pTabView->GetDrawFuncPtr());
//STRIP001 		pTabView->SetDrawFuncPtr(NULL);
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxRequest aNewReq(rReq);
//STRIP001 	aNewReq.SetSlot(nDrawSfxId);
//STRIP001 
//STRIP001 	switch (nNewId)
//STRIP001 	{
//STRIP001 		case SID_OBJECT_SELECT:
//STRIP001 			//@#70206# Nicht immer zurueckschalten
//STRIP001 			if(pView->GetMarkList().GetMarkCount() == 0) SetDrawShell(bEx);
//STRIP001 			pTabView->SetDrawFuncPtr(new FuSelection(this, pWin, pView, pDoc, aNewReq));
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_DRAW_LINE:
//STRIP001 		case SID_DRAW_RECT:
//STRIP001 		case SID_DRAW_ELLIPSE:
//STRIP001 			pTabView->SetDrawFuncPtr(new FuConstRectangle(this, pWin, pView, pDoc, aNewReq));
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_DRAW_CAPTION:
//STRIP001 		case SID_DRAW_CAPTION_VERTICAL:
//STRIP001 			pTabView->SetDrawFuncPtr(new FuConstRectangle(this, pWin, pView, pDoc, aNewReq));
//STRIP001 			pView->SetFrameDragSingles( FALSE );
//STRIP001 			rBindings.Invalidate( SID_BEZIER_EDIT );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_DRAW_POLYGON:
//STRIP001 		case SID_DRAW_POLYGON_NOFILL:
//STRIP001 		case SID_DRAW_BEZIER_NOFILL:
//STRIP001 		case SID_DRAW_FREELINE_NOFILL:
//STRIP001 			pTabView->SetDrawFuncPtr(new FuConstPolygon(this, pWin, pView, pDoc, aNewReq));
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_DRAW_ARC:
//STRIP001 		case SID_DRAW_PIE:
//STRIP001 		case SID_DRAW_CIRCLECUT:
//STRIP001 			pTabView->SetDrawFuncPtr(new FuConstArc(this, pWin, pView, pDoc, aNewReq));
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_DRAW_TEXT:
//STRIP001 		case SID_DRAW_TEXT_VERTICAL:
//STRIP001 		case SID_DRAW_TEXT_MARQUEE:
//STRIP001 		case SID_DRAW_NOTEEDIT:
//STRIP001 			pTabView->SetDrawFuncPtr(new FuText(this, pWin, pView, pDoc, aNewReq));
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_FM_CREATE_CONTROL:
//STRIP001 			SetDrawFormShell(TRUE);
//STRIP001 			pTabView->SetDrawFuncPtr(new FuConstUnoControl(this, pWin, pView, pDoc, aNewReq));
//STRIP001 			nFormSfxId = nNewFormId;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_DRAW_CHART:
//STRIP001 			bChartDlgIsEdit = FALSE;
//STRIP001 			pTabView->SetDrawFuncPtr(new FuMarkRect(this, pWin, pView, pDoc, aNewReq));
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pTabView->GetDrawFuncPtr())
//STRIP001 		pTabView->GetDrawFuncPtr()->Activate();
//STRIP001 
//STRIP001 	rReq.Done();
//STRIP001 
//STRIP001 	rBindings.Invalidate( SID_INSERT_DRAW );
//STRIP001 	rBindings.Update( SID_INSERT_DRAW );
//STRIP001 
//STRIP001 	// #98185# Create default drawing objects via keyboard
//STRIP001 	// with qualifier construct directly
//STRIP001 	FuPoor*	pFuActual = GetDrawFuncPtr();
//STRIP001 
//STRIP001 	if(pFuActual && (rReq.GetModifier() & KEY_MOD1))
//STRIP001 	{
//STRIP001 		// #98185# Create default drawing objects via keyboard
//STRIP001 		const ScAppOptions& rAppOpt = SC_MOD()->GetAppOptions();
//STRIP001 		sal_uInt32 nDefaultObjectSizeWidth = rAppOpt.GetDefaultObjectSizeWidth();
//STRIP001 		sal_uInt32 nDefaultObjectSizeHeight = rAppOpt.GetDefaultObjectSizeHeight();
//STRIP001 
//STRIP001 		// calc position and size
//STRIP001 		Rectangle aVisArea = pWin->PixelToLogic(Rectangle(Point(0,0), pWin->GetOutputSizePixel()));
//STRIP001 		Point aPagePos = aVisArea.Center();
//STRIP001 		aPagePos.X() -= nDefaultObjectSizeWidth / 2;
//STRIP001 		aPagePos.Y() -= nDefaultObjectSizeHeight / 2;
//STRIP001 		Rectangle aNewObjectRectangle(aPagePos, Size(nDefaultObjectSizeWidth, nDefaultObjectSizeHeight));
//STRIP001 		
//STRIP001 		ScDrawView* pDrView = GetScDrawView();
//STRIP001 
//STRIP001 		if(pDrView)
//STRIP001 		{
//STRIP001 			SdrPageView* pPageView = pDrView->GetPageViewPvNum(0);
//STRIP001 
//STRIP001 			if(pPageView)
//STRIP001 			{
//STRIP001 				// create the default object
//STRIP001 				SdrObject* pObj = pFuActual->CreateDefaultObject(nNewId, aNewObjectRectangle);
//STRIP001 
//STRIP001 				if(pObj)
//STRIP001 				{
//STRIP001 					// insert into page
//STRIP001 					pView->InsertObject(pObj, *pPageView, pView->IsSolidDraggingNow() ? SDRINSERT_NOBROADCAST : 0);
//STRIP001 
//STRIP001 					if ( nNewId == SID_DRAW_CAPTION || nNewId == SID_DRAW_CAPTION_VERTICAL )
//STRIP001 					{
//STRIP001 						//	#105815# use KeyInput to start edit mode (FuText is created).
//STRIP001 						//	For FuText objects, edit mode is handled within CreateDefaultObject.
//STRIP001 						//	KEY_F2 is handled in FuDraw::KeyInput.
//STRIP001 
//STRIP001 						pFuActual->KeyInput( KeyEvent( 0, KeyCode( KEY_F2 ) ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*N*/ void ScTabViewShell::GetDrawState(SfxItemSet &rSet)
/*N*/ {
/*N*/ 	SfxWhichIter	aIter(rSet);
/*N*/ 	USHORT			nWhich = aIter.FirstWhich();
/*N*/ 
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		switch ( nWhich )
/*N*/ 		{
/*N*/ 			case SID_INSERT_DRAW:
/*N*/ 				{
/*N*/ 					//	SID_OBJECT_SELECT nur, wenn "harter" Selektionsmodus
/*N*/ 					USHORT nPutId = nDrawSfxId;
/*N*/ 					if ( nPutId == SID_OBJECT_SELECT && !IsDrawSelMode() )
/*N*/ 						nPutId = USHRT_MAX;
/*N*/ 					// nur die Images, die auch auf dem Controller liegen
/*N*/ 					if ( nPutId != SID_OBJECT_SELECT &&
/*N*/ 						 nPutId != SID_DRAW_LINE &&
/*N*/ 						 nPutId != SID_DRAW_RECT &&
/*N*/ 						 nPutId != SID_DRAW_ELLIPSE &&
/*N*/ 						 nPutId != SID_DRAW_POLYGON_NOFILL &&
/*N*/ 						 nPutId != SID_DRAW_BEZIER_NOFILL &&
/*N*/ 						 nPutId != SID_DRAW_FREELINE_NOFILL &&
/*N*/ 						 nPutId != SID_DRAW_ARC &&
/*N*/ 						 nPutId != SID_DRAW_PIE &&
/*N*/ 						 nPutId != SID_DRAW_CIRCLECUT &&
/*N*/ 						 nPutId != SID_DRAW_TEXT &&
/*N*/ 						 nPutId != SID_DRAW_TEXT_VERTICAL &&
/*N*/ 						 nPutId != SID_DRAW_TEXT_MARQUEE &&
/*N*/ 						 nPutId != SID_DRAW_CAPTION &&
/*N*/ 						 nPutId != SID_DRAW_CAPTION_VERTICAL )
/*N*/ 						nPutId = USHRT_MAX;
/*N*/ 					SfxAllEnumItem aItem( nWhich, nPutId );
/*N*/ 					if ( !SvtLanguageOptions().IsVerticalTextEnabled() )
/*N*/ 					{
/*N*/ 						aItem.DisableValue( SID_DRAW_TEXT_VERTICAL );
/*N*/ 						aItem.DisableValue( SID_DRAW_CAPTION_VERTICAL );
/*N*/ 					}
/*N*/ 					rSet.Put( aItem );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*?*/ 			case SID_DRAW_CHART:
/*?*/ 				{
/*?*/ 					BOOL bOle = GetViewFrame()->ISA(SfxInPlaceFrame);
/*?*/ 					if ( bOle || !SvtModuleOptions().IsChart() )
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_OBJECT_SELECT:		// wichtig fuer den ollen Control-Controller
/*?*/ 				rSet.Put( SfxBoolItem( nWhich, nDrawSfxId == SID_OBJECT_SELECT && IsDrawSelMode() ) );
/*?*/ 				break;
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }

//STRIP001 BOOL ScTabViewShell::SelectObject( const String& rName )
//STRIP001 {
//STRIP001 	ScDrawView* pView = GetViewData()->GetScDrawView();
//STRIP001 	if (!pView)
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	BOOL bFound = pView->SelectObject( rName );
//STRIP001 	// DrawShell etc. is handled in MarkListHasChanged
//STRIP001 
//STRIP001 	return bFound;
//STRIP001 }



}
