/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabvwshf.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:39:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include "scitems.hxx"
#include <bf_sfx2/request.hxx>
// auto strip #include <basic/sbstar.hxx>
#include <svtools/stritem.hxx>
#include <svtools/whiter.hxx>
// auto strip #include <vcl/msgbox.hxx>

#include "tabvwsh.hxx"
#include "bf_sc.hrc"
#include "docsh.hxx"
// auto strip #include "document.hxx"
// auto strip #include "shtabdlg.hxx"
// auto strip #include "scresid.hxx"
// auto strip #include "instbdlg.hxx"
#include "globstr.hrc"
// auto strip #include "strindlg.hxx"
// auto strip #include "mvtabdlg.hxx"

#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif

namespace binfilter {



#define IS_AVAILABLE(WhichId,ppItem) \
    (pReqArgs->GetItemState((WhichId), TRUE, ppItem ) == SFX_ITEM_SET)

//------------------------------------------------------------------

//STRIP001 void ScTabViewShell::ExecuteTable( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	ScViewData*	pViewData	= GetViewData();
//STRIP001 	ScDocument*	pDoc		= pViewData->GetDocument();
//STRIP001 
//STRIP001 	USHORT		nCurrentTab	= pViewData->GetTabNo();
//STRIP001 	USHORT		nTabCount	= pDoc->GetTableCount();
//STRIP001 	USHORT		nSlot		= rReq.GetSlot();
//STRIP001 	const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 
//STRIP001 	HideListBox();					// Autofilter-DropDown-Listbox
//STRIP001 
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001 		case FID_TABLE_VISIBLE:
//STRIP001 			{
//STRIP001 				USHORT nTabNr = pViewData->GetTabNo();
//STRIP001 				String aName;
//STRIP001 				pDoc->GetName( nCurrentTab, aName );
//STRIP001 
//STRIP001 				BOOL bVisible=TRUE;
//STRIP001 				if( pReqArgs != NULL )
//STRIP001 				{
//STRIP001 					const SfxPoolItem* pItem;
//STRIP001 					if( IS_AVAILABLE( FID_TABLE_VISIBLE, &pItem ) )
//STRIP001 						bVisible = ((const SfxBoolItem*)pItem)->GetValue();
//STRIP001 				}
//STRIP001 
//STRIP001 				if( ! bVisible )			// ausblenden
//STRIP001 				{
//STRIP001 					ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 					USHORT nTabSelCount = rMark.GetSelectCount();
//STRIP001 					USHORT nVis = 0;
//STRIP001 					for ( USHORT i=0; i < nTabCount && nVis<2; i++ )
//STRIP001 						if (pDoc->IsVisible(i))
//STRIP001 							++nVis;
//STRIP001 					if ( nVis<2 || !pDoc->IsDocEditable() || nTabSelCount > 1 )
//STRIP001 						break;
//STRIP001 
//STRIP001 					USHORT nHideTab;
//STRIP001 					if (pDoc->GetTable( aName, nHideTab ))
//STRIP001 						HideTable( nHideTab );
//STRIP001 				}
//STRIP001 				else						// einblenden
//STRIP001 				{
//STRIP001 					ShowTable( aName );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FID_TABLE_HIDE:
//STRIP001 			{
//STRIP001 				ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 				USHORT nTabSelCount = rMark.GetSelectCount();
//STRIP001 				USHORT nVis = 0;
//STRIP001 				for ( USHORT i=0; i < nTabCount && nVis<2; i++ )
//STRIP001 					if (pDoc->IsVisible(i))
//STRIP001 						++nVis;
//STRIP001 				if ( nVis<2 || !pDoc->IsDocEditable() || nTabSelCount > 1 )
//STRIP001 					break;
//STRIP001 
//STRIP001 
//STRIP001 				String aName;
//STRIP001 				if( pReqArgs != NULL )
//STRIP001 				{
//STRIP001 					const SfxPoolItem* pItem;
//STRIP001 					if( IS_AVAILABLE( FID_TABLE_HIDE, &pItem ) )
//STRIP001 						aName = ((const SfxStringItem*)pItem)->GetValue();
//STRIP001 				}
//STRIP001 
//STRIP001 				if (!aName.Len())
//STRIP001 				{
//STRIP001 					pDoc->GetName( nCurrentTab, aName );		// aktuelle Tabelle
//STRIP001 					rReq.AppendItem( SfxStringItem( FID_TABLE_HIDE, aName ) );
//STRIP001 				}
//STRIP001 
//STRIP001 				USHORT nHideTab;
//STRIP001 				if (pDoc->GetTable( aName, nHideTab ))
//STRIP001 					HideTable( nHideTab );
//STRIP001 
//STRIP001 				if( ! rReq.IsAPI() )
//STRIP001 					rReq.Done();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FID_TABLE_SHOW:
//STRIP001 			{
//STRIP001 				String aName;
//STRIP001 				if ( pReqArgs )
//STRIP001 				{
//STRIP001 					const SfxPoolItem* pItem;
//STRIP001 					if( IS_AVAILABLE( FID_TABLE_SHOW, &pItem ) )
//STRIP001 					{
//STRIP001 						aName = ((const SfxStringItem*)pItem)->GetValue();
//STRIP001 
//STRIP001 						ShowTable( aName );
//STRIP001 
//STRIP001 						if( ! rReq.IsAPI() )
//STRIP001 							rReq.Done();
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001                     ScShowTabDlg* pDlg = new ScShowTabDlg( GetDialogParent() );
//STRIP001 
//STRIP001                     String aTabName;
//STRIP001                     BOOL bFirst = TRUE;
//STRIP001 					for ( USHORT i=0; i != nTabCount; i++ )
//STRIP001 					{
//STRIP001 						if (!pDoc->IsVisible(i))
//STRIP001 						{
//STRIP001                             pDoc->GetName( i, aTabName );
//STRIP001                             pDlg->Insert( aTabName, bFirst );
//STRIP001                             bFirst = FALSE;
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					if ( pDlg->Execute() == RET_OK )
//STRIP001 					{
//STRIP001 						USHORT nCount = pDlg->GetSelectEntryCount();
//STRIP001 						for (USHORT nPos=0; nPos<nCount; nPos++)
//STRIP001 						{
//STRIP001 							aName = pDlg->GetSelectEntry(nPos);
//STRIP001 							ShowTable( aName );
//STRIP001 						}
//STRIP001 						rReq.AppendItem( SfxStringItem( FID_TABLE_SHOW, aName ) );
//STRIP001 						rReq.Done();
//STRIP001 					}
//STRIP001 					delete pDlg;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FID_INS_TABLE:
//STRIP001 			{
//STRIP001 				ScMarkData& rMark 	 = pViewData->GetMarkData();
//STRIP001 				USHORT	nTabSelCount = rMark.GetSelectCount();
//STRIP001 				USHORT	nTabNr		 = nCurrentTab;
//STRIP001 
//STRIP001 				if ( !pDoc->IsDocEditable() )
//STRIP001 					break;							// gesperrt
//STRIP001 
//STRIP001 				if ( pReqArgs != NULL )				// von Basic
//STRIP001 				{
//STRIP001 					BOOL bOk = FALSE;
//STRIP001 					const SfxPoolItem*	pTabItem;
//STRIP001 					const SfxPoolItem*	pNameItem;
//STRIP001 					String				aName;
//STRIP001 
//STRIP001 					if ( IS_AVAILABLE( FN_PARAM_1, &pTabItem ) &&
//STRIP001 						 IS_AVAILABLE( nSlot, &pNameItem ) )
//STRIP001 					{
//STRIP001 						//	Tabellennr. von Basic: 1-basiert
//STRIP001 
//STRIP001 						aName = ((const SfxStringItem*)pNameItem)->GetValue();
//STRIP001 						nTabNr = ((const SfxUInt16Item*)pTabItem)->GetValue() - 1;
//STRIP001 						if ( nTabNr < nTabCount )
//STRIP001 							bOk = InsertTable( aName, nTabNr );
//STRIP001 					}
//STRIP001 
//STRIP001 					if (bOk)
//STRIP001 						rReq.Done( *pReqArgs );
//STRIP001 					//!	sonst Fehler setzen
//STRIP001 				}
//STRIP001 				else								// Dialog
//STRIP001 				{
//STRIP001 					ScInsertTableDlg* pDlg = new ScInsertTableDlg(
//STRIP001 													GetDialogParent(),
//STRIP001 													*pViewData,nTabSelCount);
//STRIP001 
//STRIP001 					if ( RET_OK == pDlg->Execute() )
//STRIP001 					{
//STRIP001 						if (pDlg->GetTablesFromFile())
//STRIP001 						{
//STRIP001 							USHORT nTabs[MAXTAB+1];
//STRIP001 							USHORT nCount = 0;
//STRIP001 							USHORT n = 0;
//STRIP001 							const String* pStr = pDlg->GetFirstTable( &n );
//STRIP001 							while ( pStr )
//STRIP001 							{
//STRIP001 								nTabs[nCount++] = n;
//STRIP001 								pStr = pDlg->GetNextTable( &n );
//STRIP001 							}
//STRIP001 							BOOL bLink = pDlg->GetTablesAsLink();
//STRIP001 							if (nCount)
//STRIP001 							{
//STRIP001 								if(pDlg->IsTableBefore())
//STRIP001 								{
//STRIP001 									ImportTables( pDlg->GetDocShellTables(), nCount, nTabs,
//STRIP001 												bLink,nTabNr );
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									USHORT	nTabAfter	 = nTabNr+1;
//STRIP001 
//STRIP001 									for(USHORT j=nCurrentTab+1;j<nTabCount;j++)
//STRIP001 									{
//STRIP001 										if(!pDoc->IsScenario(j))
//STRIP001 										{
//STRIP001 											nTabAfter=j;
//STRIP001 											break;
//STRIP001 										}
//STRIP001 									}
//STRIP001 
//STRIP001 									ImportTables( pDlg->GetDocShellTables(), nCount, nTabs,
//STRIP001 												bLink,nTabAfter );
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							USHORT nCount=pDlg->GetTableCount();
//STRIP001 							if(pDlg->IsTableBefore())
//STRIP001 							{
//STRIP001 								if(nCount==1 && pDlg->GetFirstTable()->Len()>0)
//STRIP001 								{
//STRIP001 									rReq.AppendItem( SfxStringItem( FID_INS_TABLE, *pDlg->GetFirstTable() ) );
//STRIP001 									rReq.AppendItem( SfxUInt16Item( FN_PARAM_1, nTabNr + 1 ) );		// 1-based
//STRIP001 									rReq.Done();
//STRIP001 
//STRIP001 									InsertTable( *pDlg->GetFirstTable(), nTabNr );
//STRIP001 								}
//STRIP001 								else
//STRIP001 									InsertTables( NULL, nTabNr,nCount );
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								USHORT	nTabAfter	 = nTabNr+1;
//STRIP001 								USHORT nSelHigh=0;
//STRIP001 
//STRIP001 								for(int i=0;i<nTabCount;i++)
//STRIP001 								{
//STRIP001 									if(rMark.GetTableSelect(i))
//STRIP001 									{
//STRIP001 										nSelHigh=i;
//STRIP001 									}
//STRIP001 								}
//STRIP001 
//STRIP001 								for(USHORT j=nSelHigh+1;j<nTabCount;j++)
//STRIP001 								{
//STRIP001 									if(!pDoc->IsScenario(j))
//STRIP001 									{
//STRIP001 										nTabAfter=j;
//STRIP001 										break;
//STRIP001 									}
//STRIP001                                     else // #101672#; increase nTabAfter, because it is possible that the scenario tables are the last
//STRIP001                                         nTabAfter = j + 1;
//STRIP001 								}
//STRIP001 
//STRIP001 								if(nCount==1 && pDlg->GetFirstTable()->Len()>0)
//STRIP001 								{
//STRIP001 									rReq.AppendItem( SfxStringItem( FID_INS_TABLE, *pDlg->GetFirstTable() ) );
//STRIP001 									rReq.AppendItem( SfxUInt16Item( FN_PARAM_1, nTabAfter + 1 ) );		// 1-based
//STRIP001 									rReq.Done();
//STRIP001 
//STRIP001 									InsertTable( *pDlg->GetFirstTable(), nTabAfter);
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									InsertTables( NULL, nTabAfter,nCount);
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					delete pDlg;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FID_TAB_APPEND:
//STRIP001 		case FID_TAB_RENAME:
//STRIP001 		case FID_TAB_MENU_RENAME:
//STRIP001 			{
//STRIP001 				//	FID_TAB_MENU_RENAME - "umbenennen" im Menu
//STRIP001 				//	FID_TAB_RENAME		- "Name"-Property fuer Basic
//STRIP001 				//	Execute ist gleich, aber im GetState wird MENU_RENAME evtl. disabled
//STRIP001 
//STRIP001 				if ( nSlot == FID_TAB_MENU_RENAME )
//STRIP001 					nSlot = FID_TAB_RENAME;				// Execute ist gleich
//STRIP001 
//STRIP001 				USHORT nTabNr = pViewData->GetTabNo();
//STRIP001 				ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 				USHORT nTabSelCount = rMark.GetSelectCount();
//STRIP001 
//STRIP001 				if ( !pDoc->IsDocEditable() )
//STRIP001 					break; // alles gesperrt
//STRIP001 
//STRIP001 				if ( nSlot != FID_TAB_APPEND &&
//STRIP001 						( pDoc->IsTabProtected( nTabNr ) || nTabSelCount > 1 ) )
//STRIP001 					break; // kein Rename
//STRIP001 
//STRIP001 #if 0
//STRIP001 				//	ScSbxObject wird nicht mehr benutzt, stattdessen aus dem
//STRIP001 				//	ScSbxTable::Notify die richtige Tabelle an der Basic-View eingestellt
//STRIP001 				if( rReq.IsAPI() )
//STRIP001 				{
//STRIP001 					SbxObject* pObj = GetScSbxObject();
//STRIP001 					ScSbxTable* pSbxTab = PTR_CAST( ScSbxTable, pObj );
//STRIP001 					DBG_ASSERT( pSbxTab, "pSbxTab???" );
//STRIP001 
//STRIP001 					if( pSbxTab )
//STRIP001 						nTabNr = pSbxTab->GetTableNr();
//STRIP001 				}
//STRIP001 #endif
//STRIP001 
//STRIP001 				if( pReqArgs != NULL )
//STRIP001 				{
//STRIP001 					BOOL		bDone	= FALSE;
//STRIP001 					const SfxPoolItem* pItem;
//STRIP001 					String		aName;
//STRIP001 
//STRIP001 					if( IS_AVAILABLE( FN_PARAM_1, &pItem ) )
//STRIP001 						nTabNr = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 
//STRIP001 					if( IS_AVAILABLE( nSlot, &pItem ) )
//STRIP001 						aName = ((const SfxStringItem*)pItem)->GetValue();
//STRIP001 
//STRIP001 					switch ( nSlot )
//STRIP001 					{
//STRIP001 						case FID_TAB_APPEND:
//STRIP001 							bDone = AppendTable( aName );
//STRIP001 							break;
//STRIP001 						case FID_TAB_RENAME:
//STRIP001 							bDone = RenameTable( aName, nTabNr );
//STRIP001 							break;
//STRIP001 					}
//STRIP001 
//STRIP001 					if( bDone )
//STRIP001 					{
//STRIP001 						rReq.Done( *pReqArgs );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					USHORT		nRet	= RET_OK;
//STRIP001 					BOOL		bDone	= FALSE;
//STRIP001 					String		aErrMsg ( ScGlobal::GetRscString( STR_INVALIDTABNAME ) );
//STRIP001 					String		aName;
//STRIP001 					String		aDlgTitle;
//STRIP001 
//STRIP001 					switch ( nSlot )
//STRIP001 					{
//STRIP001 						case FID_TAB_APPEND:
//STRIP001 							aDlgTitle = String(ScResId(SCSTR_APDTABLE));
//STRIP001 							pDoc->CreateValidTabName( aName );
//STRIP001 							break;
//STRIP001 
//STRIP001 						case FID_TAB_RENAME:
//STRIP001 							aDlgTitle = String(ScResId(SCSTR_RENAMETAB));
//STRIP001 							pDoc->GetName( pViewData->GetTabNo(), aName );
//STRIP001 							break;
//STRIP001 					}
//STRIP001 
//STRIP001 					ScStringInputDlg* pDlg =
//STRIP001 						new ScStringInputDlg( GetDialogParent(),
//STRIP001 											  aDlgTitle,
//STRIP001 											  String(ScResId(SCSTR_NAME)),
//STRIP001 											  aName,
//STRIP001 											  nSlot );
//STRIP001 
//STRIP001 					while ( !bDone && nRet == RET_OK )
//STRIP001 					{
//STRIP001 						nRet = pDlg->Execute();
//STRIP001 
//STRIP001 						if ( nRet == RET_OK )
//STRIP001 						{
//STRIP001 							pDlg->GetInputString( aName );
//STRIP001 
//STRIP001 
//STRIP001 							switch ( nSlot )
//STRIP001 							{
//STRIP001 								case FID_TAB_APPEND:
//STRIP001 									bDone = AppendTable( aName );
//STRIP001 									break;
//STRIP001 								case FID_TAB_RENAME:
//STRIP001 									bDone = RenameTable( aName, nTabNr );
//STRIP001 									break;
//STRIP001 							}
//STRIP001 
//STRIP001 							if ( bDone )
//STRIP001 							{
//STRIP001 								rReq.AppendItem( SfxStringItem( nSlot, aName ) );
//STRIP001 								rReq.Done();
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								if( rReq.IsAPI() )
//STRIP001 								{
//STRIP001 									StarBASIC::Error( SbERR_SETPROP_FAILED ); // XXX Fehlerbehandlung???
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									nRet = ErrorBox( GetDialogParent(),
//STRIP001 													 WinBits( WB_OK | WB_DEF_OK ),
//STRIP001 													 aErrMsg
//STRIP001 												   ).Execute();
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 					delete pDlg;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FID_TAB_MOVE:
//STRIP001 			{
//STRIP001 				if ( pDoc->GetChangeTrack() != NULL )
//STRIP001 					break;		// bei aktiviertem ChangeTracking kein TabMove
//STRIP001 
//STRIP001 				BOOL   bDoIt = FALSE;
//STRIP001 				USHORT nDoc = 0;
//STRIP001 				USHORT nTab = pViewData->GetTabNo();
//STRIP001 				BOOL   bCpy = FALSE;
//STRIP001 				String aDocName;
//STRIP001 
//STRIP001 				if( pReqArgs != NULL )
//STRIP001 				{
//STRIP001 					USHORT nTableCount = pDoc->GetTableCount();
//STRIP001 					const SfxPoolItem* pItem;
//STRIP001 
//STRIP001 					if( IS_AVAILABLE( FID_TAB_MOVE, &pItem ) )
//STRIP001 						aDocName = ((const SfxStringItem*)pItem)->GetValue();
//STRIP001 					if( IS_AVAILABLE( FN_PARAM_1, &pItem ) )
//STRIP001 					{
//STRIP001 						//	Tabelle ist 1-basiert
//STRIP001 						nTab = ((const SfxUInt16Item*)pItem)->GetValue() - 1;
//STRIP001 						if ( nTab >= nTableCount )
//STRIP001 							nTab = SC_TAB_APPEND;
//STRIP001 					}
//STRIP001 					if( IS_AVAILABLE( FN_PARAM_2, &pItem ) )
//STRIP001 						bCpy = ((const SfxBoolItem*)pItem)->GetValue();
//STRIP001 
//STRIP001 					if( aDocName.Len() )
//STRIP001 					{
//STRIP001 						SfxObjectShell* pSh		= SfxObjectShell::GetFirst();
//STRIP001 						ScDocShell*		pScSh	= NULL;
//STRIP001 						USHORT			i=0;
//STRIP001 
//STRIP001 						while ( pSh )
//STRIP001 						{
//STRIP001 							pScSh = PTR_CAST( ScDocShell, pSh );
//STRIP001 
//STRIP001 							if( pScSh )
//STRIP001 							{
//STRIP001 								pScSh->GetTitle();
//STRIP001 
//STRIP001 								if( pScSh->GetTitle() == aDocName )
//STRIP001 								{
//STRIP001 									nDoc = i;
//STRIP001 									ScDocument* pDestDoc = pScSh->GetDocument();
//STRIP001 									nTableCount = pDestDoc->GetTableCount();
//STRIP001 									bDoIt = pDestDoc->IsDocEditable();
//STRIP001 									break;
//STRIP001 								}
//STRIP001 
//STRIP001 								i++;		// nur die ScDocShell's zaehlen
//STRIP001 							}
//STRIP001 							pSh = SfxObjectShell::GetNext( *pSh );
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else // Kein Dokumentname -> neues Dokument
//STRIP001 					{
//STRIP001 						nDoc = SC_DOC_NEW;
//STRIP001 						bDoIt = TRUE;
//STRIP001 					}
//STRIP001 
//STRIP001 					if ( bDoIt && nTab >= nTableCount )		// ggf. anhaengen
//STRIP001 						nTab = SC_TAB_APPEND;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					ScMoveTableDlg* pDlg = new ScMoveTableDlg( GetDialogParent() );
//STRIP001 
//STRIP001 					USHORT nTableCount = pDoc->GetTableCount();
//STRIP001 					ScMarkData& rMark		= GetViewData()->GetMarkData();
//STRIP001 					USHORT		nTabSelCount = rMark.GetSelectCount();
//STRIP001 
//STRIP001 
//STRIP001 					if(nTableCount==nTabSelCount)
//STRIP001 					{
//STRIP001 						pDlg->SetCopyTable();
//STRIP001 						pDlg->EnableCopyTable(FALSE);
//STRIP001 					}
//STRIP001 					if ( pDlg->Execute() == RET_OK )
//STRIP001 					{
//STRIP001 						nDoc = pDlg->GetSelectedDocument();
//STRIP001 						nTab = pDlg->GetSelectedTable();
//STRIP001 						bCpy = pDlg->GetCopyTable();
//STRIP001 						bDoIt = TRUE;
//STRIP001 
//STRIP001 						String aDocName;
//STRIP001 						if ( nDoc != SC_DOC_NEW )
//STRIP001 						{
//STRIP001 							ScDocShell* pSh = ScDocShell::GetShellByNum( nDoc );
//STRIP001 							if (pSh)
//STRIP001 							{
//STRIP001 								aDocName = pSh->GetTitle();
//STRIP001 								if ( !pSh->GetDocument()->IsDocEditable() )
//STRIP001 								{
//STRIP001 									ErrorMessage(STR_READONLYERR);
//STRIP001 									bDoIt = FALSE;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 						rReq.AppendItem( SfxStringItem( FID_TAB_MOVE, aDocName ) );
//STRIP001 						//	Tabelle ist 1-basiert, wenn nicht APPEND
//STRIP001 						USHORT nBasicTab = ( nTab <= MAXTAB ) ? (nTab+1) : nTab;
//STRIP001 						rReq.AppendItem( SfxUInt16Item( FN_PARAM_1, nBasicTab ) );
//STRIP001 						rReq.AppendItem( SfxBoolItem( FN_PARAM_2, bCpy ) );
//STRIP001 					}
//STRIP001 					delete pDlg;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( bDoIt )
//STRIP001 				{
//STRIP001 					rReq.Done();		// aufzeichnen, solange das Dokument noch aktiv ist
//STRIP001 
//STRIP001 					MoveTable( nDoc, nTab, bCpy );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FID_DELETE_TABLE:
//STRIP001 			{
//STRIP001 				//	Parameter war ueberfluessig, weil die Methode an der Table haengt
//STRIP001 
//STRIP001 				BOOL bDoIt = rReq.IsAPI();
//STRIP001 				if( !bDoIt )
//STRIP001 				{
//STRIP001 					//	wenn's nicht von Basic kommt, nochmal nachfragen:
//STRIP001 
//STRIP001 					bDoIt = ( RET_YES ==
//STRIP001 							  QueryBox( GetDialogParent(),
//STRIP001 										WinBits( WB_YES_NO | WB_DEF_YES ),
//STRIP001 										ScGlobal::GetRscString(STR_QUERY_DELTAB)
//STRIP001 									   ).Execute() );
//STRIP001 				}
//STRIP001 				if( bDoIt )
//STRIP001 				{
//STRIP001 					USHORT nNewTab	= nCurrentTab;
//STRIP001 					USHORT nFirstTab=0;
//STRIP001 					BOOL   bTabFlag=FALSE;
//STRIP001 					ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 					SvUShorts TheTabs;
//STRIP001 					for(USHORT i=0;i<nTabCount;i++)
//STRIP001 					{
//STRIP001 						if(rMark.GetTableSelect(i) &&!pDoc->IsTabProtected(i))
//STRIP001 						{
//STRIP001 							TheTabs.Insert(i,TheTabs.Count());
//STRIP001 							bTabFlag=TRUE;
//STRIP001 							if(nNewTab==i) nNewTab++;
//STRIP001 						}
//STRIP001 						if(!bTabFlag) nFirstTab=i;
//STRIP001 					}
//STRIP001 					if(nNewTab>=nTabCount) nNewTab=nFirstTab;
//STRIP001 
//STRIP001 					pViewData->SetTabNo(nNewTab);
//STRIP001 					DeleteTables(TheTabs);
//STRIP001 					TheTabs.Remove(0,TheTabs.Count());
//STRIP001 					rReq.Done();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			DBG_ERROR("Unbekannte Message bei ViewShell");
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------

/*N*/ void ScTabViewShell::GetStateTable( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	ScViewData* pViewData	= GetViewData();
/*N*/ 	ScDocument* pDoc		= pViewData->GetDocument();
/*N*/ 	ScMarkData& rMark		= GetViewData()->GetMarkData();
/*N*/ 	USHORT		nPosX		= pViewData->GetCurX();
/*N*/ 	USHORT		nPosY		= pViewData->GetCurY();
/*N*/ 	USHORT		nTab		= pViewData->GetTabNo();
/*N*/ 
/*N*/ 	BOOL bOle = GetViewData()->GetDocShell()->IsOle();
/*N*/ 
/*N*/ 	USHORT nTabCount = pDoc->GetTableCount();
/*N*/ 	USHORT nTabSelCount = rMark.GetSelectCount();
/*N*/ 
/*N*/ 	SfxWhichIter	aIter(rSet);
/*N*/ 	USHORT			nWhich = aIter.FirstWhich();
/*N*/ 
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		switch ( nWhich )
/*N*/ 		{
/*N*/ 
/*?*/ 			case FID_TABLE_VISIBLE:
/*?*/ 				rSet.Put( SfxBoolItem( nWhich, pDoc->IsVisible(nTab) ));
/*?*/ 				break;
/*?*/ 
/*N*/ 			case FID_TABLE_HIDE:
/*N*/ 				{
/*N*/ 					USHORT nVis = 0;
/*N*/ 					for ( USHORT i=0; i < nTabCount && nVis<2; i++ )
/*N*/ 						if (pDoc->IsVisible(i))
/*N*/ 							++nVis;
/*N*/ 
/*N*/ 					if ( nVis<2 || !pDoc->IsDocEditable() || nTabSelCount > 1 )
/*?*/ 						rSet.DisableItem( nWhich );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case FID_TABLE_SHOW:
/*N*/ 				{
/*N*/ 					BOOL bHasHidden = FALSE;
/*N*/ 					for ( USHORT i=0; i < nTabCount && !bHasHidden; i++ )
/*N*/ 						if (!pDoc->IsVisible(i))
/*N*/ 							bHasHidden = TRUE;
/*N*/ 					if ( !bHasHidden || pDoc->IsDocProtected() || nTabSelCount > 1 )
/*N*/ 						rSet.DisableItem( nWhich );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*?*/ 			case FID_DELETE_TABLE:
/*?*/ 				{
/*?*/ 					if ( pDoc->GetChangeTrack() )
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 					else
/*?*/ 					{
/*?*/ 						USHORT nVis = 0;
/*?*/ 						for ( USHORT i=0; i < nTabCount && nVis<2; i++ )
/*?*/ 							if (pDoc->IsVisible(i))
/*?*/ 								++nVis;
/*?*/ 						if (   pDoc->IsTabProtected(nTab)
/*?*/ 							|| !pDoc->IsDocEditable()
/*?*/ 							|| nVis < 2
/*?*/ 							|| nTabSelCount == nTabCount)
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 					}
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_INS_TABLE:
/*?*/ 			case FID_TAB_APPEND:
/*?*/ 				if (   !pDoc->IsDocEditable()
/*?*/ 					|| nTabCount > MAXTAB)
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_TAB_MOVE:
/*?*/ 				if (   !pDoc->IsDocEditable()
/*?*/ 					|| pDoc->GetChangeTrack() != NULL
/*?*/ 					|| nTabCount > MAXTAB)
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				break;
/*N*/ 
/*N*/ 			//	FID_TAB_MENU_RENAME - "umbenennen" im Menu
/*N*/ 			//	FID_TAB_RENAME		- "Name"-Property fuer Basic
/*N*/ 
/*N*/ 			case FID_TAB_MENU_RENAME:
/*N*/ 				if ( !pDoc->IsDocEditable() ||
/*N*/ 					 pDoc->IsTabProtected(nTab) ||nTabSelCount > 1 )
/*N*/ 					rSet.DisableItem( nWhich );
/*N*/ 				break;
/*N*/ 
/*?*/ 			case FID_TAB_RENAME:
/*?*/ 				{
/*?*/ 					String aTabName;
/*?*/ 					pDoc->GetName( nTab, aTabName );
/*?*/ 
/*?*/ 					rSet.Put( SfxStringItem( nWhich, aTabName ));
/*?*/ 
/*?*/ 				}
/*?*/ 				break;
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }




}
