/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_fusel.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:31:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// auto strip #include <bf_sfx2/docfile.hxx>

// auto strip #ifndef _SVDORECT_HXX //autogen
// auto strip #include <bf_svx/svdorect.hxx>
// auto strip #endif

// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// header for SdrCircObj
// auto strip #ifndef _SVDOCIRC_HXX
// auto strip #include <bf_svx/svdocirc.hxx>
// auto strip #endif

#include "app.hrc"
// auto strip #include "fudraw.hxx"
#include "fusel.hxx"
// auto strip #include "viewshel.hxx"
#include "schview.hxx"
// auto strip #include <bf_svx/scene3d.hxx>
// auto strip #include <bf_svx/polysc3d.hxx>
// auto strip #include "chwindow.hxx"
// auto strip #include "objid.hxx"
// auto strip #ifndef _CHTMODEL_HXX
// auto strip #include "chtmodel.hxx"
// auto strip #endif
// auto strip #ifndef _SCH_DATAPOIN_HXX
// auto strip #include "datapoin.hxx"
// auto strip #endif
// auto strip #ifndef _SCH_DATAROW_HXX
// auto strip #include "datarow.hxx"
// auto strip #endif
// auto strip #include "schgroup.hxx"
// auto strip #include "chtscene.hxx"

// header for SchCalculationHelper
// auto strip #include "calculat.hxx"
// header for SchDragConstrainedToVector
// auto strip #include "schdrgmt.hxx"
// auto strip #include "undmovsize.hxx"
// auto strip #include "undmovpieseg.hxx"
#include "strings.hrc"
namespace binfilter {

//STRIP001 TYPEINIT1(SchFuSelection, SchFuDraw);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ SchFuSelection::SchFuSelection(SchViewShell* pViewSh, SchWindow* pWin,
/*N*/ 							   SchView* pView, ChartModel* pDoc,
/*N*/ 							   SfxRequest& rReq) :
/*N*/ 		SchFuDraw(pViewSh, pWin, pView, pDoc, rReq),
/*N*/ 		bVCAction(FALSE),
/*N*/ 		pDragMethod(NULL)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SchFuSelection::~SchFuSelection()
/*N*/ {
/*N*/ 	if( pView->GetDragMode() != SDRDRAG_MOVE )
/*?*/ 	{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	pView->SetDragMode(SDRDRAG_MOVE);
/*N*/ }

/*************************************************************************
|*
|* Wege durch die MouseUp/Down Events:
|*
|* Weg A:  markierte Gesamtflaeche -> markierte Diagramflaeche (DIAGRAM_AREA -> DIAGRAM)
|*         (durch Klick in freie Flaeche, z.B. neben einem Datenpunkt)
|* Weg B:  markierte Gesamtflaeche -> markierte Datenreihe
\*************************************************************************/

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

//STRIP001 BOOL SchFuSelection::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001     // guard object to suspend sending broadcasts
//STRIP001     SuspendSelectionChangeBroadcasting aSelectionSuspender( pViewShell );
//STRIP001 
//STRIP001     BOOL bReturn = SchFuDraw::MouseButtonDown(rMEvt);
//STRIP001 
//STRIP001     bMBDown = TRUE;
//STRIP001 
//STRIP001     if( pView->IsAction() )
//STRIP001     {
//STRIP001 		if( rMEvt.IsRight() )
//STRIP001 			pView->BckAction();
//STRIP001 		return TRUE;
//STRIP001     }
//STRIP001 
//STRIP001     bWasSelected = FALSE;
//STRIP001 
//STRIP001     if( rMEvt.IsLeft() )
//STRIP001     {
//STRIP001 		pWindow->CaptureMouse();
//STRIP001 
//STRIP001 		SdrHdl* pHdl = NULL;
//STRIP001 		SdrObject* pObj = NULL;
//STRIP001 		SdrPageView* pPV = NULL;
//STRIP001 		SchObjectId* pObjId = NULL;
//STRIP001 
//STRIP001 		pViewShell->SetMousePos( aMDPos );
//STRIP001 
//STRIP001 		USHORT nDrgLog = (USHORT)pWindow->PixelToLogic(Size(DRGPIX,0)).Width();
//STRIP001 		USHORT nHitLog = (USHORT)pWindow->PixelToLogic(Size(HITPIX,0)).Width();
//STRIP001 
//STRIP001 		if( pView->GetPageViewPvNum(0)->GetEnteredLevel() == 0 )
//STRIP001 			pHdl = pView->PickHandle( aMDPos, *pWindow );
//STRIP001 
//STRIP001 		const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 		SchChartDocShell* pDocSh = (SchChartDocShell*) pChDoc->GetObjectShell();
//STRIP001 
//STRIP001 		if(!pDocSh)
//STRIP001 		{
//STRIP001 			DBG_ERROR("pDocSh lost!");
//STRIP001 			return FALSE;
//STRIP001 		}
//STRIP001 
//STRIP001 		// click on marked object
//STRIP001 		// ----------------------
//STRIP001 		if( (pView->IsMarkedHit(aMDPos, nHitLog) &&
//STRIP001 			 !rMEvt.IsShift() && !rMEvt.IsMod2() || pHdl)
//STRIP001 			&& rMarkList.GetMark(0)) //#57196#
//STRIP001 		{
//STRIP001 			pObj   = rMarkList.GetMark(0)->GetObj();
//STRIP001 			pObjId = GetObjectId(*pObj);
//STRIP001 
//STRIP001 			bWasSelected = TRUE;
//STRIP001 
//STRIP001 			SdrObject *pOldObj = NULL;
//STRIP001 			
//STRIP001 			if( pObjId )
//STRIP001 			{
//STRIP001 				DBG_TRACE2( "SchFuSelection::MouseButtonDown Step 1, ObjId=%ld (%s)", pObjId->GetObjId(), GetCHOBJIDName( pObjId->GetObjId()));
//STRIP001 				switch( pObjId->GetObjId() )
//STRIP001 				{
//STRIP001 					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
//STRIP001 					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
//STRIP001 					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
//STRIP001 						
//STRIP001 					case CHOBJID_TITLE_MAIN:
//STRIP001 					case CHOBJID_TITLE_SUB:
//STRIP001 						{
//STRIP001 							pHdl = NULL;
//STRIP001 							pView->SetFrameDragSingles(TRUE);
//STRIP001 							
//STRIP001 							if( !pDocSh->IsReadOnly() )
//STRIP001 							{
//STRIP001 								pView->BegDragObj(aMDPos, NULL, pHdl, nDrgLog);
//STRIP001 							}
//STRIP001 						}
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_AREA:									// path A,B #1
//STRIP001 						{
//STRIP001 							SdrPage *pPage = pChDoc->GetPage(0);
//STRIP001 
//STRIP001 							if( pPage )
//STRIP001 							{
//STRIP001 								SdrObject *pDiagramObj = GetObjWithId( CHOBJID_DIAGRAM, *pPage, 0, IM_DEEPWITHGROUPS );
//STRIP001 								SchObjectId* pDiagramId = NULL;
//STRIP001 
//STRIP001 								if( pDiagramObj )
//STRIP001 								{
//STRIP001 									SdrPageView* pPV = pView->GetPageViewPvNum( 0 );
//STRIP001 
//STRIP001 									pView->UnmarkAll();                       // path A,B #2
//STRIP001 									pView->SetMarkHdlHidden(TRUE);
//STRIP001 									pView->SetFrameDragSingles(FALSE);
//STRIP001 									pView->PickObj( aMDPos, 50, pDiagramObj, pPV );		// pDiagramObj <- next level object in group
//STRIP001 
//STRIP001 									SchObjectId* pDiaObjId = NULL;
//STRIP001 									if( pDiagramObj ) // might be set to NULL in PickObj
//STRIP001 									{
//STRIP001 										pDiaObjId = GetObjectId( *pDiagramObj );
//STRIP001 
//STRIP001 										if( pDiaObjId )
//STRIP001 										{
//STRIP001 											switch(pDiaObjId->GetObjId())
//STRIP001 											{
//STRIP001 												case CHOBJID_LEGEND:
//STRIP001 												case CHOBJID_LEGEND_BACK:
//STRIP001 												case CHOBJID_TITLE_MAIN:
//STRIP001 												case CHOBJID_TITLE_SUB:
//STRIP001 												case CHOBJID_DIAGRAM_TITLE_X_AXIS:
//STRIP001 												case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
//STRIP001 												case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
//STRIP001 												case CHOBJID_DIAGRAM_AREA:
//STRIP001 													pView->SetFrameDragSingles(TRUE);
//STRIP001 													pView->MarkObj( pDiagramObj, pPV );
//STRIP001 													break;
//STRIP001 
//STRIP001 												default:
//STRIP001 													pView->MarkObj( pDiagramObj, pPV );
//STRIP001 													pView->EnterMarkedGroup();
//STRIP001 													break;
//STRIP001 											}
//STRIP001 										}
//STRIP001 									}
//STRIP001 
//STRIP001 									if( pView->PickObj( aMDPos, nHitLog, pDiagramObj, pPV ))		// pDiagramObj <- next level object in group
//STRIP001 										pView->MarkObj( aMDPos, nHitLog );      // path A,B #3
//STRIP001 
//STRIP001 									pView->SetMarkHdlHidden(FALSE);
//STRIP001 
//STRIP001 									//TVM: Wenn DonutChart, dann darf nicht versucht werden, eine
//STRIP001 									//     Datenreihe zu markieren, die gibt es dort nicht als
//STRIP001 									//     Gruppenobjekt!
//STRIP001 									if(pObj==pDiagramObj || pChDoc->IsDonutChart())
//STRIP001 									{
//STRIP001 										pDiagramObj = GetObjWithId( CHOBJID_DIAGRAM, *pPage, 0, IM_DEEPWITHGROUPS );
//STRIP001 										if(pDiagramObj)
//STRIP001 										{
//STRIP001 											if(pDiagramObj->GetLogicRect().IsInside(aMDPos))
//STRIP001 											{
//STRIP001 												pView->LeaveOneGroup();       // path A #4
//STRIP001 												pView->UnmarkAll();
//STRIP001 												pView->MarkObj(pDiagramObj,pPV);
//STRIP001 												pView->SetFrameDragSingles(TRUE);
//STRIP001 											}
//STRIP001 										}
//STRIP001 									}
//STRIP001 									else
//STRIP001 									{
//STRIP001 										if(pDiagramObj)
//STRIP001 										{
//STRIP001 											pDiagramId = GetObjectId(*pDiagramObj);
//STRIP001 											if(pDiagramId)
//STRIP001 											{
//STRIP001 												short nId = pDiagramId->GetObjId();  // path B #4
//STRIP001 												switch(nId)
//STRIP001 												{
//STRIP001 													case CHOBJID_DIAGRAM_ROWGROUP:
//STRIP001                                                         if( pChDoc->IsFlat3DChart() )
//STRIP001                                                             Select3DGroupMembers(pObj,pPV);
//STRIP001 														break;
//STRIP001 													case CHOBJID_LEGEND:
//STRIP001 														pView->LeaveOneGroup();
//STRIP001 														pView->UnmarkAll();
//STRIP001 														pView->MarkObj(pDiagramObj,pPV);
//STRIP001 														pView->SetFrameDragSingles(TRUE);
//STRIP001 														break;
//STRIP001 												}
//STRIP001 											}
//STRIP001 											else
//STRIP001 											{
//STRIP001 												//DBG_TRACE("new selection in Chart::Fusel.cxx");
//STRIP001 												// ohne diesen Block ist es moeglich, 3D-Achsenbeschr. zu selektieren
//STRIP001 												pDiagramObj = GetObjWithId( CHOBJID_DIAGRAM, *pPage, 0, IM_DEEPWITHGROUPS );
//STRIP001 												if(pDiagramObj)
//STRIP001 												{
//STRIP001 													pView->LeaveOneGroup();
//STRIP001 													pView->UnmarkAll();
//STRIP001 													pView->MarkObj(pDiagramObj,pPV);
//STRIP001 													pView->SetFrameDragSingles( FALSE ); // TRUE
//STRIP001 												}
//STRIP001 											}
//STRIP001 										}
//STRIP001 									}
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM:
//STRIP001 						{
//STRIP001 							if( !pDocSh->IsReadOnly() )
//STRIP001 							{
//STRIP001 								pView->BegDragObj(aMDPos, NULL, pHdl, nDrgLog); // ReSize
//STRIP001 							}
//STRIP001 						}
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_DATA :
//STRIP001 						// drag pie segments
//STRIP001 						if( pChDoc->IsPieChart()
//STRIP001 							&& !pDocSh->IsReadOnly() )
//STRIP001 						{
//STRIP001 							CreatePieDragMethod( SAL_STATIC_CAST( SdrCircObj*, pObj ) );
//STRIP001 							pView->BegDragObj( aMDPos, NULL, pHdl, nDrgLog, pDragMethod );
//STRIP001 						}
//STRIP001 						if( !pView->IsLogicalGroupMarked() )
//STRIP001 							break;
//STRIP001 						// else continue with following block
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_STACKEDGROUP:
//STRIP001 					case CHOBJID_DIAGRAM_SPECIAL_GROUP:
//STRIP001 					case CHOBJID_LEGEND:
//STRIP001 						{
//STRIP001 							pView->SetMarkHdlHidden(TRUE);
//STRIP001 
//STRIP001 							if(CHOBJID_LEGEND!=pObjId->GetObjId())
//STRIP001 								pView->SetFrameDragSingles(FALSE);
//STRIP001 							else
//STRIP001 								pView->SetFrameDragSingles(TRUE);
//STRIP001 
//STRIP001 							pView->MarkObj(aMDPos, nHitLog);
//STRIP001 							pView->EnterMarkedGroup();
//STRIP001 
//STRIP001 							if( pView->PickObj(aMDPos, nHitLog, pObj, pPV) )
//STRIP001 								pView->MarkObj(aMDPos, nHitLog);
//STRIP001 
//STRIP001 							pView->SetMarkHdlHidden(FALSE);
//STRIP001 
//STRIP001 							if(pObj)
//STRIP001 							{
//STRIP001 								SchObjectId* pSubObjId = GetObjectId(*pObj);
//STRIP001 								if(pSubObjId)
//STRIP001 								{
//STRIP001 									long nId=pSubObjId->GetObjId();
//STRIP001 									DBG_TRACE2( "SchFuSelection::MouseButtonDown Step 2, ObjId=%ld (%s)", nId, GetCHOBJIDName( nId ));
//STRIP001 
//STRIP001 									if(nId<10)				 // meaning simple object (line, area, text, any)
//STRIP001 									{
//STRIP001 										pOldObj = GetObjWithId( CHOBJID_LEGEND, *pChDoc->GetPage(0), 0, IM_DEEPWITHGROUPS );
//STRIP001 										if(pOldObj->GetLogicRect().IsInside(aMDPos))
//STRIP001 										{
//STRIP001 											pView->LeaveOneGroup();
//STRIP001 											pView->UnmarkAll();
//STRIP001 											pView->MarkObj(pOldObj,pPV);
//STRIP001 											pView->SetFrameDragSingles(TRUE);
//STRIP001 
//STRIP001 											if( !pDocSh->IsReadOnly() )
//STRIP001 											{
//STRIP001 												pView->BegDragObj( aMDPos, NULL, pHdl, nDrgLog );
//STRIP001 											}
//STRIP001 										}
//STRIP001 									}
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_ROWGROUP:
//STRIP001 //					case CHOBJID_3D_PIE_TOP:
//STRIP001 						{
//STRIP001 							switch( pChDoc->ChartStyle() )
//STRIP001 							{
//STRIP001 								case CHSTYLE_2D_AREA :
//STRIP001 								case CHSTYLE_2D_STACKEDAREA :
//STRIP001 								case CHSTYLE_2D_PERCENTAREA :
//STRIP001 								case CHSTYLE_3D_STRIPE :
//STRIP001 								case CHSTYLE_3D_AREA :
//STRIP001 								case CHSTYLE_3D_STACKEDAREA :
//STRIP001 								case CHSTYLE_3D_PERCENTAREA :
//STRIP001 								case CHSTYLE_3D_SURFACE :
//STRIP001 								case CHSTYLE_2D_LINE :
//STRIP001 								case CHSTYLE_2D_STACKEDLINE :
//STRIP001 								case CHSTYLE_2D_PERCENTLINE :
//STRIP001 								case CHSTYLE_2D_CUBIC_SPLINE :
//STRIP001 								case CHSTYLE_2D_B_SPLINE :
//STRIP001 								case CHSTYLE_2D_NET :
//STRIP001 								case CHSTYLE_2D_NET_STACK :
//STRIP001 								case CHSTYLE_2D_NET_PERCENT :
//STRIP001 								// #72910# xy types
//STRIP001 								case CHSTYLE_2D_XY_LINE :		// lines only
//STRIP001 								case CHSTYLE_2D_CUBIC_SPLINE_XY :
//STRIP001 								case CHSTYLE_2D_B_SPLINE_XY :
//STRIP001 									break;
//STRIP001 
//STRIP001 								case CHSTYLE_2D_XY :			// lines + symbols
//STRIP001 								case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
//STRIP001 								case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
//STRIP001 									pView->SetMarkHdlHidden(TRUE);
//STRIP001 									pView->EnterMarkedGroup();
//STRIP001 									pView->MarkObj(aMDPos, nHitLog);
//STRIP001 
//STRIP001 									// if marked object is not a data point,
//STRIP001 									// go up one level again
//STRIP001 									if( rMarkList.GetMarkCount() )
//STRIP001 									{
//STRIP001 										SdrObject* pSubObj = rMarkList.GetMark( 0 )->GetObj();
//STRIP001 										if( pSubObj )
//STRIP001 										{
//STRIP001 											SchObjectId* pSubObjId = GetObjectId( *pSubObj );
//STRIP001 											if( pSubObjId )
//STRIP001 											{
//STRIP001 												if( pSubObjId->GetObjId() != CHOBJID_DIAGRAM_DATA )
//STRIP001 													pView->LeaveOneGroup();
//STRIP001 											}
//STRIP001 											else
//STRIP001 												pView->SetFrameDragSingles(FALSE);
//STRIP001 										}
//STRIP001 									}
//STRIP001 
//STRIP001 									pView->SetMarkHdlHidden(FALSE);									
//STRIP001 									break;
//STRIP001 
//STRIP001 								default:
//STRIP001 									if( rMEvt.GetClicks() == 1 )
//STRIP001 									{
//STRIP001 										pView->SetMarkHdlHidden(TRUE);
//STRIP001                                         BOOL bDragSingles = !pChDoc->Is3DChart();
//STRIP001 										pView->SetFrameDragSingles(bDragSingles);
//STRIP001 										pView->EnterMarkedGroup();
//STRIP001 										pView->MarkObj(aMDPos, nHitLog);
//STRIP001 										pView->SetMarkHdlHidden(FALSE);
//STRIP001 									}
//STRIP001 							}
//STRIP001 						}
//STRIP001 						break;
//STRIP001 				}
//STRIP001 
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 			else		// object without CHOBJID hit
//STRIP001 			{
//STRIP001 				if(!pDocSh->IsReadOnly())
//STRIP001 				{
//STRIP001 					aDragTimer.Start();
//STRIP001 				}
//STRIP001 
//STRIP001 				pView->BegDragObj(aMDPos, NULL, NULL, nDrgLog);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		// unmarked object hit or click with modifying key
//STRIP001 		// -----------------------------------------------
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pView->UnmarkAll();
//STRIP001 			pView->SetFrameDragSingles(TRUE);
//STRIP001 
//STRIP001 			while( pView->GetPageViewPvNum(0)->GetEnteredLevel() )
//STRIP001 			{
//STRIP001 				// anderes Objekt in gleicher oder uebergeordneter Gruppe
//STRIP001 				// selektieren
//STRIP001 
//STRIP001 				if( pView->PickObj(aMDPos, nHitLog, pObj, pPV) )
//STRIP001 				{
//STRIP001 					pObjId = GetObjectId(*pObj);
//STRIP001 
//STRIP001 					if( pObjId )
//STRIP001 					{
//STRIP001 						BOOL bBreak;
//STRIP001 
//STRIP001 						pView->SetMarkHdlHidden(TRUE);
//STRIP001 						SchObjectId *pNewObjectId=NULL;
//STRIP001 
//STRIP001 						DBG_TRACE2( "SchFuSelection::MouseButtonDown Step 3, ObjId=%ld (%s)", pObjId->GetObjId(), GetCHOBJIDName( pObjId->GetObjId() ));
//STRIP001 						long nId;
//STRIP001 
//STRIP001                         BOOL bDragSingles = FALSE;
//STRIP001 
//STRIP001                         switch( pObjId->GetObjId() )
//STRIP001 						{
//STRIP001 							case CHOBJID_LEGEND_SYMBOL_ROW:
//STRIP001 							case CHOBJID_LEGEND_SYMBOL_COL:
//STRIP001                             case CHOBJID_DIAGRAM_DATA:
//STRIP001                                 bDragSingles = TRUE;
//STRIP001                                 if( pObjId->GetObjId() == CHOBJID_DIAGRAM_DATA && pChDoc->Is3DChart() )
//STRIP001                                 {
//STRIP001                                     bDragSingles = FALSE;
//STRIP001                                 }
//STRIP001                                 // Warning: Fall-Through intended!
//STRIP001                             case CHOBJID_DIAGRAM_ROWGROUP:
//STRIP001                                 if( pObjId->GetObjId() == CHOBJID_DIAGRAM_ROWGROUP )
//STRIP001                                 {
//STRIP001                                     bDragSingles = pChDoc->Is3DChart();
//STRIP001                                 }
//STRIP001                                 // Warning: Fall-Through intended!
//STRIP001 							case CHOBJID_DIAGRAM_ROWS:
//STRIP001 							case CHOBJID_DIAGRAM_ROWSLINE:
//STRIP001 							case CHOBJID_DIAGRAM_STOCKLINE_GROUP:
//STRIP001 							case CHOBJID_DIAGRAM_STOCKLOSS_GROUP:
//STRIP001 							case CHOBJID_DIAGRAM_STOCKPLUS_GROUP:
//STRIP001 							case CHOBJID_DIAGRAM_SPECIAL_GROUP:
//STRIP001 							case CHOBJID_DIAGRAM_X_AXIS:
//STRIP001 							case CHOBJID_DIAGRAM_Y_AXIS:
//STRIP001 							case CHOBJID_DIAGRAM_Z_AXIS:
//STRIP001 							case CHOBJID_DIAGRAM_A_AXIS:
//STRIP001 							case CHOBJID_DIAGRAM_B_AXIS:
//STRIP001 							case CHOBJID_DIAGRAM_C_AXIS:
//STRIP001 								pView->UnmarkAll();
//STRIP001                                 pView->SetFrameDragSingles( bDragSingles );
//STRIP001 								pView->MarkObj(aMDPos, nHitLog);
//STRIP001 								pView->MarkLogicalGroup();
//STRIP001 
//STRIP001 								bBreak = TRUE;
//STRIP001 
//STRIP001 								if(pObj)//TVMNEW
//STRIP001 								{
//STRIP001 									pNewObjectId=GetObjectId(*pObj);
//STRIP001 									if(pNewObjectId)
//STRIP001 									{
//STRIP001 										nId=pNewObjectId->GetObjId();
//STRIP001 										if(nId==CHOBJID_DIAGRAM_ROWGROUP &&
//STRIP001                                            pChDoc->IsFlat3DChart() )
//STRIP001 										{
//STRIP001 											pView->LeaveOneGroup();
//STRIP001 											pView->PickObj(aMDPos,nHitLog,pObj,pPV);
//STRIP001 											Select3DGroupMembers(pObj,pPV);
//STRIP001 										}
//STRIP001 									}
//STRIP001 								}
//STRIP001 								if( pChDoc->IsPieChart() && pObjId->GetObjId() == CHOBJID_DIAGRAM_DATA )
//STRIP001 								{
//STRIP001 									// drag pie segments
//STRIP001 									if( !pDocSh->IsReadOnly() )
//STRIP001 									{
//STRIP001 										CreatePieDragMethod( SAL_STATIC_CAST( SdrCircObj*, pObj ) );
//STRIP001 										pView->BegDragObj( aMDPos, NULL, pHdl, nDrgLog, pDragMethod );
//STRIP001 									}
//STRIP001 								}
//STRIP001 								break;
//STRIP001 
//STRIP001 							default:
//STRIP001 								bBreak = FALSE;
//STRIP001 								break;
//STRIP001 						}
//STRIP001 						pView->SetMarkHdlHidden(FALSE);
//STRIP001 
//STRIP001 						if( bBreak )
//STRIP001 							break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				pView->LeaveOneGroup();
//STRIP001 			}
//STRIP001 			
//STRIP001 
//STRIP001 			pPV = NULL;
//STRIP001 			pObj = NULL;
//STRIP001 
//STRIP001 			if(!pView->HasMarkedObj() &&
//STRIP001 			   pView->PickObj(aMDPos, nHitLog, pObj, pPV))
//STRIP001 			{
//STRIP001 				// Falls kein anderes Gruppenobjekt selektiert wurde,
//STRIP001 				// ggf. auf oberster Ebene Objekt markieren und draggen
//STRIP001 
//STRIP001 				pView->SetFrameDragSingles(TRUE);
//STRIP001 				pObjId = GetObjectId(*pObj);
//STRIP001 
//STRIP001 				if( pObjId )
//STRIP001 				{
//STRIP001 
//STRIP001 					SdrObject *pDiagramObj = GetObjWithId( CHOBJID_DIAGRAM,*pChDoc->GetPage(0),
//STRIP001 														   0, IM_DEEPWITHGROUPS);
//STRIP001 					DBG_ASSERT(pDiagramObj,"Diagramm nicht gefunden");
//STRIP001 
//STRIP001 					DBG_TRACE2( "SchFuSelection::MouseButtonDown Step 4, ObjId=%ld (%s)", pObjId->GetObjId(), GetCHOBJIDName( pObjId->GetObjId() ));
//STRIP001 
//STRIP001 					switch( pObjId->GetObjId() )
//STRIP001 					{
//STRIP001 						case CHOBJID_DIAGRAM_AREA:
//STRIP001 							if( pDiagramObj &&
//STRIP001 								pDiagramObj->GetLogicRect().IsInside(aMDPos) )
//STRIP001 							{
//STRIP001 								pView->MarkObj(pDiagramObj,pPV);
//STRIP001 								if(!pDocSh->IsReadOnly())
//STRIP001 								{
//STRIP001 									pView->BegDragObj(aMDPos, NULL, NULL, nDrgLog);
//STRIP001 								}
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								pView->MarkObj(pObj, pPV);
//STRIP001 								if(!pDocSh->IsReadOnly())
//STRIP001 								{
//STRIP001 									pView->BegDragObj(aMDPos, NULL, NULL, nDrgLog);
//STRIP001 								}
//STRIP001 							}
//STRIP001 							break;
//STRIP001 
//STRIP001 						case CHOBJID_DIAGRAM:
//STRIP001 						case CHOBJID_TITLE_MAIN:
//STRIP001 						case CHOBJID_TITLE_SUB:
//STRIP001 						case CHOBJID_LEGEND:
//STRIP001 						case CHOBJID_DIAGRAM_TITLE_X_AXIS:
//STRIP001 						case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
//STRIP001 						case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
//STRIP001 							{
//STRIP001 								pView->MarkObj(pObj, pPV);
//STRIP001 
//STRIP001 								pView->SetDragMode(SDRDRAG_MOVE);		// if scene was selected #53954#
//STRIP001 
//STRIP001 								if(!pDocSh->IsReadOnly())
//STRIP001 								{
//STRIP001 									pView->BegDragObj(aMDPos, NULL, NULL, nDrgLog);
//STRIP001 								}
//STRIP001 							}
//STRIP001 							break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 #ifdef OS2
//STRIP001 					bFirstMouseMove = TRUE;
//STRIP001 #endif
//STRIP001 					if(!pDocSh->IsReadOnly())
//STRIP001 					{
//STRIP001 						aDragTimer.Start();
//STRIP001 					}
//STRIP001 
//STRIP001 					pView->MarkObj(pObj, pPV);
//STRIP001 					pView->BegDragObj(aMDPos, NULL, NULL, nDrgLog);
//STRIP001 				}
//STRIP001 
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001     }
//STRIP001 
//STRIP001     if(!bIsInDragMode)
//STRIP001 		ForcePointer(&rMEvt);
//STRIP001 
//STRIP001     return bReturn;
//STRIP001 }

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

//STRIP001 BOOL SchFuSelection::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = SchFuDraw::MouseMove(rMEvt);
//STRIP001 
//STRIP001 	if(aDragTimer.IsActive())
//STRIP001 	{
//STRIP001 #ifdef OS2
//STRIP001 		if(bFirstMouseMove)
//STRIP001 			bFirstMouseMove = FALSE;
//STRIP001 		else
//STRIP001 #endif
//STRIP001 		{
//STRIP001 			aDragTimer.Stop();
//STRIP001 			bIsInDragMode = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if(pView->IsAction())
//STRIP001 		pView->MovAction( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
//STRIP001 
//STRIP001 	ForcePointer(&rMEvt);
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }


/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

//STRIP001 BOOL SchFuSelection::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001     // guard object to suspend sending broadcasts
//STRIP001     SuspendSelectionChangeBroadcasting aSelectionSuspender( pViewShell );
//STRIP001 
//STRIP001 	if(aDragTimer.IsActive())
//STRIP001 	{
//STRIP001 		aDragTimer.Stop();
//STRIP001 		bIsInDragMode = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	SchFuDraw::MouseButtonUp(rMEvt);
//STRIP001 
//STRIP001 	Point aPnt(pWindow->PixelToLogic(rMEvt.GetPosPixel()));
//STRIP001 	USHORT nDrgLog = USHORT( pWindow->PixelToLogic(Size(DRGPIX,0)).Width() );
//STRIP001 	USHORT nHitLog = USHORT( pWindow->PixelToLogic(Size(HITPIX,0)).Width() );
//STRIP001 
//STRIP001 	if( rMEvt.IsLeft() )
//STRIP001 	{
//STRIP001 		if(pView->IsDragObj())
//STRIP001 		{
//STRIP001 			//-- prepare undo
//STRIP001 			UINT16 nUndoObjId(CHOBJID_ANY);
//STRIP001 			Rectangle aOldUndoRect(0,0,0,0);// | if only a position point is relevant/available (e.g. objects that cannot be resized)
//STRIP001 			Rectangle aNewUndoRect(0,0,0,0);// | this point will be storede in the top left corner of aOldUndoRect
//STRIP001 			Point aUndoDataPointColRow(0,0);//x == column y == row
//STRIP001 			Point aUndoPieSegOffOldNew(0,0);//x == old y == new
//STRIP001 			Matrix4D aUndoOldSceneMatrix;
//STRIP001 			Matrix4D aUndoNewSceneMatrix;
//STRIP001 			//-- prepare undo (collect old state)
//STRIP001 			{
//STRIP001 				const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 				if(rMarkList.GetMarkCount())
//STRIP001 				{
//STRIP001 					SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
//STRIP001 					if(pObj)
//STRIP001 					{
//STRIP001 						aOldUndoRect = Rectangle(pObj->GetLogicRect().TopLeft(), Size(0,0));
//STRIP001 						switch(GetObjectIdNum(*pObj))
//STRIP001 						{
//STRIP001 							case CHOBJID_DIAGRAM:
//STRIP001 								aOldUndoRect = pChDoc->GetDiagramRectangle();
//STRIP001 								if(pObj->ISA(ChartScene))
//STRIP001 								{
//STRIP001 									aUndoOldSceneMatrix = ((ChartScene*)pObj)->GetTransform();
//STRIP001 								}
//STRIP001 								break;
//STRIP001 							case CHOBJID_DIAGRAM_DATA:
//STRIP001 								if( pObj->ISA(SdrCircObj) && pChDoc->IsPieChart() )
//STRIP001 								{
//STRIP001 									SchDataPoint* pDataPoint = GetDataPoint( *pObj );
//STRIP001 									if(pDataPoint)
//STRIP001 										aUndoPieSegOffOldNew.X() =
//STRIP001 											pChDoc->PieSegOfs( pDataPoint->GetCol() );
//STRIP001 								}
//STRIP001 								break;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}//-- end prepare undo (collect old state)
//STRIP001 
//STRIP001             // #i11980# copying objects with Ctrl-Key is not supported.  It
//STRIP001             // wasn't even a real drag&drop.
//STRIP001 			if( pView->EndDragObj()) //rMEvt.IsMod1()))
//STRIP001 			{
//STRIP001 //				pView->SetDragWithCopy( rMEvt.IsMod1());
//STRIP001 
//STRIP001 				const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 				SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
//STRIP001 				pChDoc->SetUseRelativePositions(TRUE);
//STRIP001 				if(pObj->ISA(SchObjGroup))
//STRIP001 				{
//STRIP001 					((SchObjGroup*) pObj)->SetGroupMoved(TRUE);
//STRIP001 					if(((SchObjGroup*) pObj)->GetGroupType() == SchObjGroup::DIAGRAM)
//STRIP001 					{
//STRIP001 						//-- prepare undo (collect new state)
//STRIP001 						nUndoObjId = CHOBJID_DIAGRAM;
//STRIP001 						aNewUndoRect = pChDoc->GetDiagramRectangle();
//STRIP001 						//--
//STRIP001 						pChDoc->BuildChart(FALSE);
//STRIP001 					}
//STRIP001 					else if(((SchObjGroup*) pObj)->GetGroupType() == SchObjGroup::LEGEND)
//STRIP001 					{
//STRIP001 						//-- prepare undo (collect new state)
//STRIP001 						nUndoObjId = CHOBJID_LEGEND;
//STRIP001 						aNewUndoRect = Rectangle(pObj->GetLogicRect().TopLeft(), Size(0,0));
//STRIP001 						//--
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else if(pObj->ISA(SdrTextObj))
//STRIP001 				{
//STRIP001 					SchObjectId* pId = GetObjectId(*pObj);
//STRIP001 					if (pId)switch(pId->GetObjId())
//STRIP001 					{
//STRIP001 						case CHOBJID_TITLE_MAIN:
//STRIP001 						case CHOBJID_TITLE_SUB:
//STRIP001 						case CHOBJID_DIAGRAM_TITLE_X_AXIS:
//STRIP001 						case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
//STRIP001 						case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
//STRIP001 							pChDoc->SetHasBeenMoved(pId->GetObjId(),TRUE);
//STRIP001 							//-- prepare undo (collect new state)
//STRIP001 							nUndoObjId = pId->GetObjId();
//STRIP001 							aNewUndoRect = Rectangle(pObj->GetLogicRect().TopLeft(), Size(0,0));
//STRIP001 							//--
//STRIP001 						break;
//STRIP001 					}
//STRIP001 
//STRIP001 					if( pObj->ISA(SdrCircObj) && pChDoc->IsPieChart() )
//STRIP001 					{
//STRIP001 						long nCol = -1, nRow = -1;
//STRIP001 						SchDataPoint* pDataPoint = GetDataPoint( *pObj );
//STRIP001 						if( pDataPoint )
//STRIP001 						{
//STRIP001 							nCol = pDataPoint->GetCol();
//STRIP001 							nRow = pDataPoint->GetRow();
//STRIP001 
//STRIP001 							//-- prepare undo (collect new state)
//STRIP001 							nUndoObjId = GetObjectIdNum(*pObj);
//STRIP001 							aUndoDataPointColRow = Point(nCol,nRow);
//STRIP001 							aUndoPieSegOffOldNew.Y() = pChDoc->PieSegOfs( pDataPoint->GetCol() );
//STRIP001 							//--
//STRIP001 						}
//STRIP001 
//STRIP001 						if( pChDoc->ChartStyle() == CHSTYLE_2D_PIE_SEGOFALL ||
//STRIP001 							pChDoc->ChartStyle() == CHSTYLE_2D_PIE_SEGOF1 )
//STRIP001 						{
//STRIP001 							pChDoc->ChartStyle() = CHSTYLE_2D_PIE;
//STRIP001 						}
//STRIP001 						pChDoc->BuildChart( FALSE );
//STRIP001 
//STRIP001 						SdrPageView* pPV = pView->GetPageViewPvNum( 0 );
//STRIP001 
//STRIP001 						if( pPV && nCol >= 0 && nRow >= 0 )
//STRIP001 						{
//STRIP001 							pView->MarkObj( GetObjWithId( CHOBJID_DIAGRAM, *pChDoc->GetPage(0), 0, IM_DEEPWITHGROUPS ), pPV );
//STRIP001 							pView->EnterMarkedGroup();
//STRIP001 							pView->MarkObj( pChDoc->GetDataPointObj( nCol, nRow ), pPV );
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else if(pObj->ISA(ChartScene))
//STRIP001 				{
//STRIP001 					Rectangle aRectangle;
//STRIP001 					aRectangle = pObj->GetSnapRect();
//STRIP001 					((ChartScene *)pObj)->SetAskForLogicRect(FALSE);
//STRIP001 					pChDoc->SetDiagramRectangle(aRectangle);
//STRIP001 					pChDoc->SetDiagramHasBeenMovedOrResized(TRUE);
//STRIP001 
//STRIP001 					//-- prepare undo (collect new state)
//STRIP001 					if( GetObjectIdNum(*pObj) == CHOBJID_DIAGRAM )
//STRIP001 					{
//STRIP001 						nUndoObjId = CHOBJID_DIAGRAM;
//STRIP001 						aNewUndoRect = pChDoc->GetDiagramRectangle();
//STRIP001 						aUndoNewSceneMatrix = ((ChartScene*)pObj)->GetTransform();
//STRIP001 					}
//STRIP001 					//--
//STRIP001 
//STRIP001 					// BM: don't rescale text if object was rotated
//STRIP001 					if( pView->GetDragMode() == SDRDRAG_ROTATE &&
//STRIP001 						pChDoc->TextScalability() )
//STRIP001 					{
//STRIP001 						BOOL& bScalable = pChDoc->TextScalability();
//STRIP001 						bScalable = FALSE;
//STRIP001 						pChDoc->BuildChart(FALSE);
//STRIP001 						bScalable = TRUE;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						pChDoc->BuildChart(FALSE);
//STRIP001 					}
//STRIP001 
//STRIP001 					SdrObject* pDiagramObj = GetObjWithId( CHOBJID_DIAGRAM, *pChDoc->GetPage(0), 0, IM_DEEPWITHGROUPS );
//STRIP001 					if( pDiagramObj )
//STRIP001 					{
//STRIP001 						pView->LeaveOneGroup();
//STRIP001 						pView->UnmarkAll();
//STRIP001 						pView->MarkObj(pDiagramObj, pView->GetPageViewPvNum(0));
//STRIP001 					}
//STRIP001 				}
//STRIP001 				//create undo action
//STRIP001 				if(nUndoObjId != CHOBJID_ANY)
//STRIP001 				{
//STRIP001 					SfxUndoAction* pUndo=NULL;
//STRIP001 					if(nUndoObjId==CHOBJID_DIAGRAM_DATA)
//STRIP001 					{
//STRIP001 						if(aUndoDataPointColRow.Y()==0)
//STRIP001 						{
//STRIP001 							pUndo = new SchUndoMovePieSeg(	*pChDoc, aUndoDataPointColRow.X()
//STRIP001 								, aUndoPieSegOffOldNew.X(), aUndoPieSegOffOldNew.Y() );
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						pUndo = new SchUndoMoveOrResize( *pChDoc, nUndoObjId
//STRIP001 								, aOldUndoRect, aNewUndoRect
//STRIP001 								, aUndoOldSceneMatrix, aUndoNewSceneMatrix );
//STRIP001 
//STRIP001 						USHORT nResId(STR_UNDO_MOVE);
//STRIP001 						if(pView->GetDragMode()==SDRDRAG_ROTATE)
//STRIP001 							nResId = STR_UNDO_ROTATE;
//STRIP001 						else if(aOldUndoRect.GetWidth()!=aNewUndoRect.GetWidth()
//STRIP001 							 || aOldUndoRect.GetHeight()!=aNewUndoRect.GetHeight())
//STRIP001 							 nResId = STR_UNDO_RESIZE;
//STRIP001 						reinterpret_cast<SchUndoMoveOrResize*>(pUndo)->SetCommentTemplate(nResId);
//STRIP001 					}
//STRIP001 					if(pUndo)
//STRIP001 						pViewShell->GetViewFrame()->GetObjectShell()->
//STRIP001 							GetUndoManager()->AddUndoAction(pUndo);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if( bWasSelected )
//STRIP001 			{
//STRIP001 				// Kein Drag, dann Gruppe betreten, falls diese schon
//STRIP001 				// selektiert war
//STRIP001 
//STRIP001 				const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 				SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
//STRIP001 
//STRIP001 				if(pObj->ISA(SdrObjGroup) || pObj->ISA(E3dScene) || pObj->ISA(E3dPolyScene))
//STRIP001 				{
//STRIP001 					BOOL bLeave      = TRUE;
//STRIP001 					BOOL bDontShow   = FALSE;
//STRIP001 					SdrPageView* pPV = NULL;
//STRIP001 
//STRIP001 					pView->SetMarkHdlHidden(TRUE);
//STRIP001 					pView->SetDragMode(SDRDRAG_MOVE);
//STRIP001 					pView->SetFrameDragSingles(FALSE);
//STRIP001 					pView->EnterMarkedGroup();
//STRIP001 
//STRIP001 					if(pView->PickObj(aMDPos, nHitLog, pObj, pPV,SDRSEARCH_TESTMARKABLE))
//STRIP001 					{
//STRIP001 						SchObjectId* pObjId=NULL;//#51458#
//STRIP001 						pObjId = GetObjectId(*pObj);
//STRIP001 
//STRIP001 						if(pObjId)
//STRIP001 						{
//STRIP001 							// nur bestimmte Objekte zulassen
//STRIP001 							DBG_TRACE2( "SchFuSelection::MouseButtonDown Step 5, ObjId=%ld (%s)", pObjId->GetObjId(), GetCHOBJIDName( pObjId->GetObjId() ));
//STRIP001 
//STRIP001 							if( !pObj->ISA(E3dScene) )					// do not rotate non-scene objects
//STRIP001 								pView->SetDragMode( SDRDRAG_MOVE );
//STRIP001 
//STRIP001 							switch( pObjId->GetObjId() )
//STRIP001 							{
//STRIP001 								case CHOBJID_DIAGRAM_ROWGROUP:
//STRIP001 								case CHOBJID_DIAGRAM_STATISTICS_GROUP:
//STRIP001 								case CHOBJID_DIAGRAM_STOCKLINE_GROUP:
//STRIP001 								case CHOBJID_DIAGRAM_STOCKLOSS_GROUP:
//STRIP001 								case CHOBJID_DIAGRAM_STOCKPLUS_GROUP:
//STRIP001 								case CHOBJID_DIAGRAM_ROWS:
//STRIP001 								case CHOBJID_DIAGRAM_ROWSLINE:
//STRIP001 								case CHOBJID_DIAGRAM_DATA:
//STRIP001 								case CHOBJID_DIAGRAM_X_AXIS:
//STRIP001 								case CHOBJID_DIAGRAM_Y_AXIS:
//STRIP001 								case CHOBJID_DIAGRAM_Z_AXIS:
//STRIP001 								case CHOBJID_DIAGRAM_A_AXIS:
//STRIP001 								case CHOBJID_DIAGRAM_B_AXIS:
//STRIP001 								case CHOBJID_DIAGRAM_C_AXIS:
//STRIP001 								case CHOBJID_LEGEND_SYMBOL_ROW:
//STRIP001 								case CHOBJID_LEGEND_SYMBOL_COL:
//STRIP001 								case CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP :
//STRIP001 								case CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP :
//STRIP001 								case CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP :
//STRIP001 								case CHOBJID_DIAGRAM_X_GRID_HELP_GROUP :
//STRIP001 								case CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP :
//STRIP001 								case CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP :
//STRIP001 								case CHOBJID_DIAGRAM_AVERAGEVALUE :
//STRIP001 								case CHOBJID_DIAGRAM_REGRESSION :
//STRIP001 								case CHOBJID_DIAGRAM_ERROR :
//STRIP001 								case CHOBJID_DIAGRAM_FLOOR:
//STRIP001 //                                case CHOBJID_3D_PIE_TOP :
//STRIP001                                     if( pObjId->GetObjId() == CHOBJID_DIAGRAM_ROWGROUP &&
//STRIP001                                         pChDoc->IsFlat3DChart() )
//STRIP001                                     {
//STRIP001                                         pView->SetFrameDragSingles( FALSE );
//STRIP001                                         Select3DGroupMembers(pObj,pPV);
//STRIP001 //                                         bDontShow = TRUE;
//STRIP001                                     }
//STRIP001 //                                     else
//STRIP001                                     bLeave = FALSE;
//STRIP001 									break;
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					if(bLeave)
//STRIP001 						pView->LeaveOneGroup();
//STRIP001 					if(!bDontShow)
//STRIP001 					{
//STRIP001 						pView->MarkObj(aMDPos, nHitLog);
//STRIP001 						pView->MarkLogicalGroup();
//STRIP001 
//STRIP001 						if( pView->GetPageViewPvNum(0)->GetEnteredLevel() == 0 ||
//STRIP001 							rMarkList.GetMarkCount() &&
//STRIP001 							rMarkList.GetMark(0)->GetObj()->ISA(SdrRectObj))
//STRIP001 							pView->SetFrameDragSingles(TRUE);
//STRIP001 
//STRIP001 					}
//STRIP001 
//STRIP001 					pView->SetMarkHdlHidden(FALSE);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pView->IsAction() )
//STRIP001 			pView->EndAction();
//STRIP001 
//STRIP001 		if(!rMEvt.IsShift() && !rMEvt.IsMod1() && !rMEvt.IsMod2() &&
//STRIP001 		   Abs(aPnt.X() - aMDPos.X()) < nDrgLog &&
//STRIP001 		   Abs(aPnt.Y() - aMDPos.Y()) < nDrgLog)
//STRIP001 		{
//STRIP001 			/**************************************************************
//STRIP001 			 * Toggle zw. Selektion und Rotation
//STRIP001 			 **************************************************************/
//STRIP001 			SdrObject* pSingleObj = NULL;
//STRIP001 			ULONG nMarkCount = pView->GetMarkList().GetMarkCount();
//STRIP001 
//STRIP001 			if( nMarkCount == 1 )
//STRIP001 			{
//STRIP001 				pSingleObj = pView->GetMarkList().GetMark(0)->GetObj();
//STRIP001 			}
//STRIP001 
//STRIP001 			SdrDragMode eDragMode = pView->GetDragMode();
//STRIP001 
//STRIP001 			if (pSingleObj && pSingleObj->ISA( E3dScene ))
//STRIP001 			{
//STRIP001 				SchObjectId* pId = GetObjectId(*pSingleObj);
//STRIP001 				if ( pId &&
//STRIP001 					 (pId->GetObjId() == CHOBJID_DIAGRAM))
//STRIP001 					if (eDragMode == SDRDRAG_MOVE )
//STRIP001 						pView->SetDragMode(SDRDRAG_ROTATE);
//STRIP001 					else if( eDragMode == SDRDRAG_ROTATE )
//STRIP001 						pView->SetDragMode(SDRDRAG_MOVE);
//STRIP001 			}
//STRIP001 /*	AF: That's the way it was done before.
//STRIP001 			if( pSingleObj && pSingleObj->ISA(E3dScene) && //bWasSelected &&
//STRIP001 				eDragMode == SDRDRAG_MOVE )
//STRIP001 			{
//STRIP001 				pView->SetDragMode(SDRDRAG_ROTATE);
//STRIP001 			}
//STRIP001 			else if( eDragMode == SDRDRAG_ROTATE )
//STRIP001 			{
//STRIP001 				pView->SetDragMode(SDRDRAG_MOVE);
//STRIP001 			}
//STRIP001 */		}
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nClicks = rMEvt.GetClicks();
//STRIP001 	SchChartDocShell* pDocSh = (SchChartDocShell*) pChDoc->GetObjectShell();
//STRIP001 	if(!pDocSh)
//STRIP001 	{
//STRIP001 		DBG_ERROR("pDocSh lost!");
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if(nClicks == 2 && rMEvt.IsLeft() && bMBDown &&
//STRIP001 	   !rMEvt.IsMod1() && !rMEvt.IsMod2() && !rMEvt.IsShift() &&
//STRIP001 	   !pDocSh->IsReadOnly())
//STRIP001 	{
//STRIP001 		DoubleClick();
//STRIP001 	}
//STRIP001 
//STRIP001 	bMBDown = FALSE;
//STRIP001 
//STRIP001 	ForcePointer(&rMEvt);
//STRIP001 	pWindow->ReleaseMouse();
//STRIP001 
//STRIP001 	return FALSE;   //path A: nichts wesentliches passiert
//STRIP001 }

/*************************************************************************
|*
|* Command-event
|*
\************************************************************************/

//STRIP001 BOOL SchFuSelection::Command(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

/*N*/ void SchFuSelection::Activate()
/*N*/ {
/*N*/ 	pView->SetEditMode(TRUE);
/*N*/ 
/*N*/ 	SchFuDraw::Activate();
/*N*/ }

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

/*N*/ void SchFuSelection::Deactivate()
/*N*/ {
/*N*/ 	if(pView->GetDragMode() != SDRDRAG_MOVE)
/*?*/ 	{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	pView->SetDragMode(SDRDRAG_MOVE);
/*N*/ 
/*N*/ 	pView->SetEditMode(FALSE);
/*N*/ 
/*N*/ 	SchFuDraw::Deactivate();
/*N*/ }

//STRIP001 void SchFuSelection::CreatePieDragMethod( SdrCircObj* pPie )
//STRIP001 {
//STRIP001 	// 100th degrees in 90deg rotated system -> rad
//STRIP001 	long nStartAngle = pPie->GetStartWink(),
//STRIP001 		nEndAngle = pPie->GetEndWink();
//STRIP001 	if( nStartAngle > nEndAngle )
//STRIP001 		nEndAngle += 36000;
//STRIP001 	long nAngle = (nStartAngle + nEndAngle) / 2 + 9000;
//STRIP001 	double fAngle = (double)nAngle * F_PI / 18000.0;
//STRIP001 
//STRIP001 	double fRadius = (double)pChDoc->GetPieRadius();	 // maximum shift is 100% of radius
//STRIP001 	Vector2D aVec( fRadius * sin( fAngle ), fRadius * cos( fAngle ) );
//STRIP001 
//STRIP001 	SchDataPoint* pPoint = GetDataPoint( *pPie );
//STRIP001 	DBG_ASSERT( pPoint, "CreatePieDragMethod: Pie has no data point user data" );
//STRIP001 
//STRIP001 	if( pPoint )
//STRIP001 	{
//STRIP001 		double fOldShift = (double)pChDoc->PieSegOfs( pPoint->GetCol() );
//STRIP001 		pDragMethod = new SchDragConstrainedToVector( *pView, aVec, fOldShift );
//STRIP001 	}
//STRIP001 }



}
