/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_sdmod2.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2006/08/14 14:19:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif

#define ITEMID_FIELD    EE_FEATURE_FIELD

// auto strip #ifndef _PSTM_HXX
// auto strip #include <tools/pstm.hxx>
// auto strip #endif

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif

// auto strip #ifndef _SVX_FLDITEM_HXX //autogen
// auto strip #include <bf_svx/flditem.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_PRINTER_HXX //autogen
// auto strip #include <bf_sfx2/printer.hxx>
// auto strip #endif
#ifndef _INETHIST_HXX //autogen
#include <svtools/inethist.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
// auto strip #ifndef _SFXFLAGITEM_HXX //autogen
// auto strip #include <svtools/flagitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_ADRITEM_HXX //autogen
// auto strip #include <bf_svx/adritem.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX //autogen
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <bf_sfx2/docfile.hxx>
#endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif

#include <bf_svx/svdfield.hxx>
// auto strip #include <bf_svx/editstat.hxx>
// auto strip #include <bf_svx/editeng.hxx>

#define ITEMID_SPELLCHECK   0
#include <bf_svx/dialogs.hrc>

// auto strip #ifndef _SVDOTEXT_HXX
// auto strip #include <bf_svx/svdotext.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOPAGE_HXX
// auto strip #include <bf_svx/svdopage.hxx>
// auto strip #endif

#pragma hdrstop

#ifndef _OFF_OFAIDS_HRC
#include <bf_offmgr/ofaids.hrc>
#endif
// auto strip #ifndef _OFFAPP_INTERNATIONALOPTIONS_HXX_
// auto strip #include <bf_offmgr/internationaloptions.hxx>
// auto strip #endif

#define _SD_DLL                 // fuer SD_MOD()
// auto strip #include "sdmod.hxx"
// auto strip #include "sddll.hxx"
#include "app.hrc"
#include "glob.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
// auto strip #include "viewshel.hxx"
#include "frmview.hxx"
// auto strip #include "sdattr.hxx"
// auto strip #include "optsitem.hxx"
// auto strip #include "docshell.hxx"
#include "drawdoc.hxx"
#include "sdoutl.hxx"
// auto strip #include "sdresid.hxx"
// auto strip #include "pres.hxx"
// auto strip #include "drviewsh.hxx"
#include "outlnvsh.hxx"
// auto strip #include "outlview.hxx"
// auto strip #include "sdpage.hxx"
// auto strip #include "tpoption.hxx"
// auto strip #include "prntopts.hxx"
// auto strip #include "sdxfer.hxx"
namespace binfilter {


/*************************************************************************
|*
|* Options-Dialog
|*
\************************************************************************/



/*************************************************************************
|*
|* Link fuer CalcFieldValue des Outliners
|*
\************************************************************************/

/*N*/ IMPL_LINK(SdModule, CalcFieldValueHdl, EditFieldInfo*, pInfo)
/*N*/ {
/*N*/ 	if (pInfo)
/*N*/ 	{
/*N*/ 		const SvxFieldData* pField = pInfo->GetField().GetField();
/*N*/         SdDrawDocShell*     pDocShell = NULL;
/*N*/ 
/*N*/         if( pInfo->GetOutliner() )
/*N*/         {
/*N*/             const SdrTextObj* pTextObj = static_cast< SdrOutliner* >( pInfo->GetOutliner() )->GetTextObj();
/*N*/ 
/*N*/             if( pTextObj && pTextObj->GetModel() && pTextObj->GetModel()->ISA( SdDrawDocument ) )
/*N*/                 pDocShell = static_cast< SdDrawDocument* >( pTextObj->GetModel() )->GetDocSh();
/*N*/         }
/*N*/ 
/*N*/         if( !pDocShell )
/*N*/             pDocShell = PTR_CAST( SdDrawDocShell, SfxObjectShell::Current() );
/*N*/ 
/*N*/ 		if (pField && pField->ISA(SvxDateField))
/*N*/ 		{
			/******************************************************************
			* Date-Field
			******************************************************************/
/*N*/ 			LanguageType eLang = pInfo->GetOutliner()->GetLanguage( pInfo->GetPara(), pInfo->GetPos() );
/*N*/ 			pInfo->SetRepresentation( ((const SvxDateField*) pField)->GetFormatted( *GetNumberFormatter(), eLang ) );
/*N*/ 		}
/*N*/ 		else if( pField && pField->ISA( SvxExtTimeField ) )
		{
 			/******************************************************************
 			* Time-Field
 			******************************************************************/
/*N*/			LanguageType eLang = pInfo->GetOutliner()->GetLanguage( pInfo->GetPara(), pInfo->GetPos() );
/*N*/ 			pInfo->SetRepresentation( ( (const SvxExtTimeField*) pField)->GetFormatted( *GetNumberFormatter(), eLang ) );
		}
/*N*/ 		else if( pField && pField->ISA( SvxExtFileField ) )
		{
 			/******************************************************************
 			* File-Field
 			******************************************************************/
				/*N*/ const SvxExtFileField* pFileField = (const SvxExtFileField*) pField;
/*N*/ 			String aFile;
/*N*/ 			if( pFileField->GetType() == SVXFILETYPE_FIX )
/*N*/ 				aFile =  pFileField->GetFormatted();
/*N*/ 			else if( pDocShell )
/*N*/ 			{
/*N*/ 				String aName;
/*N*/ 				if( pDocShell->HasName() )
/*N*/ 					aName = pDocShell->GetMedium()->GetName();
/*N*/ 				else
/*N*/ 					aName = pDocShell->GetName();
/*N*/ 
/*N*/                 // #92496# Set new content also for living field
/*N*/ 				const_cast< SvxExtFileField* >(pFileField)->SetFile( aName );
/*N*/ 				aFile = pFileField->GetFormatted();
/*N*/ 			}

/*N*/ 			pInfo->SetRepresentation( aFile );
/*N*/ 
		}
/*N*/ 		else if( pField && pField->ISA( SvxAuthorField ) )
		{
	 			/******************************************************************
	 			* Author-Field
	 			******************************************************************/
/*N*/			const SvxAuthorField* pAuthorField = (const SvxAuthorField*) pField;
/*N*/ 			String aAuthor;
/*N*/ 			if( pAuthorField->GetType() == SVXAUTHORTYPE_FIX )
/*N*/ 				aAuthor = pAuthorField->GetFormatted();
/*N*/ 			else
/*N*/ 			{
					aAuthor = String( RTL_CONSTASCII_USTRINGPARAM( "<author>" ) );
/*N*/ 			}
/*N*/ 			pInfo->SetRepresentation( aAuthor );
/*N*/ 
		}
/*N*/ 		else if( pField && pField->ISA( SvxPageField ) )
		{
	 			/******************************************************************
	 			* Page-Field
	 			******************************************************************/
/*N*/ 			String aRepresentation;
/*N*/ 			aRepresentation += sal_Unicode( ' ' );
/*N*/ 			pInfo->SetRepresentation( aRepresentation );
		}
/*N*/ 		else if (pField && pField->ISA(SvxURLField))
/*N*/ 		{
			/******************************************************************
			* URL-Field
			******************************************************************/

/*N*/  switch ( ((const SvxURLField*) pField)->GetFormat() )
/*N*/ 			{
/*N*/ 				case SVXURLFORMAT_APPDEFAULT: //!!! einstellbar an App???
/*N*/ 				case SVXURLFORMAT_REPR:
/*N*/ 				{
/*N*/ 					pInfo->SetRepresentation(
/*N*/ 						   ((const SvxURLField*)pField)->GetRepresentation() );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 				case SVXURLFORMAT_URL:
/*N*/ 				{
/*N*/ 					pInfo->SetRepresentation(
/*N*/ 						   ((const SvxURLField*)pField)->GetURL() );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 			}
/*N*/ 
/*N*/ 			String aURL = ((const SvxURLField*)pField)->GetURL();
/*N*/ 
/*N*/             svtools::ColorConfig aConfig;
/*N*/             svtools::ColorConfigEntry eEntry =
/*N*/                 INetURLHistory::GetOrCreate()->QueryUrl( aURL ) ? svtools::LINKSVISITED : svtools::LINKS;
/*N*/ 			pInfo->SetTxtColor( aConfig.GetColorValue(eEntry).nColor );
/*N*/ 		}
/*N*/ 		else if (pField && pField->ISA(SdrMeasureField))
		{
			/******************************************************************
			* Measure-Field
			******************************************************************/
/*N*/ 			pInfo->ClearFldColor();
/*N*/ 		}
/*N*/ 		else
		{
/*?*/ 			DBG_ERROR("unbekannter Feldbefehl");
/*?*/ 			String aStr;
/*?*/ 			aStr += sal_Unicode( '?' );
/*?*/ 			pInfo->SetRepresentation( aStr );
/*?*/ 		}
/*?*/ 	}
/*N*/ 
/*N*/ 	return(0);
/*N*/ }



/*************************************************************************
|*
|* virt. Methoden fuer Optionendialog
|*
\************************************************************************/
//STRIP001 SfxItemSet*	 SdModule::CreateItemSet( USHORT nSlot )
//STRIP001 {
//STRIP001 	FrameView* pFrameView = NULL;
//STRIP001 	SdDrawDocShell* pDocSh = PTR_CAST( SdDrawDocShell, SfxObjectShell::Current() );
//STRIP001 	SdDrawDocument* pDoc = NULL;
//STRIP001 
//STRIP001 	// Hier wird der DocType vom Optionsdialog gesetzt (nicht Dokument!)
//STRIP001 	DocumentType eDocType = DOCUMENT_TYPE_IMPRESS;
//STRIP001 	if( nSlot == SID_SD_GRAPHIC_OPTIONS )
//STRIP001 		eDocType = DOCUMENT_TYPE_DRAW;
//STRIP001 
//STRIP001 	SdViewShell* pViewShell = NULL;
//STRIP001 
//STRIP001 	if (pDocSh)
//STRIP001 	{
//STRIP001 		pDoc = pDocSh->GetDoc();
//STRIP001 
//STRIP001 		// Wenn der Optionsdialog zum Dokumenttyp identisch ist,
//STRIP001 		// kann auch die FrameView mit uebergeben werden:
//STRIP001 		if( pDoc && eDocType == pDoc->GetDocumentType() )
//STRIP001 			pFrameView = pDocSh->GetFrameView();
//STRIP001 
//STRIP001 		pViewShell = pDocSh->GetViewShell();
//STRIP001 		pViewShell->WriteFrameViewData();
//STRIP001 	}
//STRIP001 
//STRIP001 	SdOptions* pOptions = GetSdOptions(eDocType);
//STRIP001 
//STRIP001 	// Pool hat standardmaessig MapUnit Twips (Baeh!)
//STRIP001 	SfxItemPool& rPool = GetPool();
//STRIP001 	rPool.SetDefaultMetric( SFX_MAPUNIT_100TH_MM );
//STRIP001 
//STRIP001 	SfxItemSet*	 pRet = new SfxItemSet( rPool,
//STRIP001 						SID_ATTR_METRIC, SID_ATTR_METRIC,
//STRIP001 						SID_ATTR_DEFTABSTOP, SID_ATTR_DEFTABSTOP,
//STRIP001 
//STRIP001 						ATTR_OPTIONS_LAYOUT, ATTR_OPTIONS_LAYOUT,
//STRIP001 						ATTR_OPTIONS_CONTENTS, ATTR_OPTIONS_CONTENTS,
//STRIP001 						ATTR_OPTIONS_MISC, ATTR_OPTIONS_MISC,
//STRIP001 
//STRIP001 						ATTR_OPTIONS_SNAP, ATTR_OPTIONS_SNAP,
//STRIP001 
//STRIP001 						ATTR_OPTIONS_SCALE_START, ATTR_OPTIONS_SCALE_END,
//STRIP001 
//STRIP001 						ATTR_OPTIONS_PRINT, ATTR_OPTIONS_PRINT,
//STRIP001 
//STRIP001 						SID_ATTR_GRID_OPTIONS, SID_ATTR_GRID_OPTIONS,
//STRIP001 						0 );
//STRIP001 
//STRIP001 	// TP_OPTIONS_LAYOUT:
//STRIP001 	pRet->Put( SdOptionsLayoutItem( ATTR_OPTIONS_LAYOUT, pOptions, pFrameView ) );
//STRIP001 
//STRIP001 	UINT16 nDefTab = 0;
//STRIP001 	if( pFrameView)
//STRIP001 		nDefTab = pDoc->GetDefaultTabulator();
//STRIP001 	else
//STRIP001 		nDefTab = pOptions->GetDefTab();
//STRIP001 	pRet->Put( SfxUInt16Item( SID_ATTR_DEFTABSTOP, nDefTab ) );
//STRIP001 
//STRIP001 	UINT16 nMetric = 0xffff;
//STRIP001 	if( pFrameView)
//STRIP001 		nMetric = pDoc->GetUIUnit();
//STRIP001 	else
//STRIP001 		nMetric = pOptions->GetMetric();
//STRIP001 
//STRIP001 	if( nMetric == 0xffff )
//STRIP001 		nMetric = GetModuleFieldUnit();
//STRIP001 
//STRIP001 	pRet->Put( SfxUInt16Item( SID_ATTR_METRIC, nMetric ) );
//STRIP001 
//STRIP001 	// TP_OPTIONS_CONTENTS:
//STRIP001 	pRet->Put( SdOptionsContentsItem( ATTR_OPTIONS_CONTENTS, pOptions, pFrameView ) );
//STRIP001 
//STRIP001 	// TP_OPTIONS_MISC:
//STRIP001     SdOptionsMiscItem aSdOptionsMiscItem( ATTR_OPTIONS_MISC, pOptions, pFrameView );
//STRIP001     if ( pFrameView )
//STRIP001     {
//STRIP001         aSdOptionsMiscItem.SetSummationOfParagraphs( pDoc->IsSummationOfParagraphs() );
//STRIP001         aSdOptionsMiscItem.SetPrinterIndependentLayout (pDoc->GetPrinterIndependentLayout());
//STRIP001     }
//STRIP001 	pRet->Put( aSdOptionsMiscItem );
//STRIP001 
//STRIP001 
//STRIP001 	// TP_OPTIONS_SNAP:
//STRIP001 	pRet->Put( SdOptionsSnapItem( ATTR_OPTIONS_SNAP, pOptions, pFrameView ) );
//STRIP001 
//STRIP001 	// TP_SCALE:
//STRIP001 	UINT32 nW = 10L;
//STRIP001 	UINT32 nH = 10L;
//STRIP001 	INT32  nX;
//STRIP001 	INT32  nY;
//STRIP001 	if( pDocSh )
//STRIP001 	{
//STRIP001 		SdrPage* pPage = (SdrPage*) pDoc->GetSdPage(0, PK_STANDARD);
//STRIP001 		Size aSize(pPage->GetSize());
//STRIP001 		nW = aSize.Width();
//STRIP001 		nH = aSize.Height();
//STRIP001 	}
//STRIP001 
//STRIP001 	if(pFrameView)
//STRIP001 	{
//STRIP001 		const Fraction& rFraction =  pDoc->GetUIScale();
//STRIP001 		nX=rFraction.GetNumerator();
//STRIP001 		nY=rFraction.GetDenominator();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Optionen aus Configdatei holen
//STRIP001 		pOptions->GetScale( nX, nY );
//STRIP001 	}
//STRIP001 
//STRIP001 	pRet->Put( SfxInt32Item( ATTR_OPTIONS_SCALE_X, nX ) );
//STRIP001 	pRet->Put( SfxInt32Item( ATTR_OPTIONS_SCALE_Y, nY ) );
//STRIP001 	pRet->Put( SfxUInt32Item( ATTR_OPTIONS_SCALE_WIDTH, nW ) );
//STRIP001 	pRet->Put( SfxUInt32Item( ATTR_OPTIONS_SCALE_HEIGHT, nH ) );
//STRIP001 
//STRIP001 
//STRIP001 	// TP_OPTIONS_PRINT:
//STRIP001 	pRet->Put( SdOptionsPrintItem( ATTR_OPTIONS_PRINT, pOptions ) );
//STRIP001 
//STRIP001 	// RID_SVXPAGE_GRID:
//STRIP001 	pRet->Put( SdOptionsGridItem( SID_ATTR_GRID_OPTIONS, pOptions ) );
//STRIP001 
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 void SdModule::ApplyItemSet( USHORT nSlot, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	const SfxPoolItem*	pItem = NULL;
//STRIP001 	BOOL bNewDefTab = FALSE;
//STRIP001 	BOOL bNewPrintOptions = FALSE;
//STRIP001 	BOOL bMiscOptions = FALSE;
//STRIP001 
//STRIP001 	FrameView* pFrameView = NULL;
//STRIP001 	SdDrawDocShell* pDocSh = PTR_CAST( SdDrawDocShell, SfxObjectShell::Current() );
//STRIP001 	SdDrawDocument* pDoc = NULL;
//STRIP001 	// Hier wird der DocType vom Optionsdialog gesetzt (nicht Dokument!)
//STRIP001 	DocumentType eDocType = DOCUMENT_TYPE_IMPRESS;
//STRIP001 	if( nSlot == SID_SD_GRAPHIC_OPTIONS )
//STRIP001 		eDocType = DOCUMENT_TYPE_DRAW;
//STRIP001 
//STRIP001 	SdViewShell* pViewShell = NULL;
//STRIP001 
//STRIP001 	if (pDocSh)
//STRIP001 	{
//STRIP001 		pDoc = pDocSh->GetDoc();
//STRIP001 
//STRIP001 		// Wenn der Optionsdialog zum Dokumenttyp identisch ist,
//STRIP001 		// kann auch die FrameView mit uebergeben werden:
//STRIP001 		if( pDoc && eDocType == pDoc->GetDocumentType() )
//STRIP001 			pFrameView = pDocSh->GetFrameView();
//STRIP001 
//STRIP001 		pViewShell = pDocSh->GetViewShell();
//STRIP001 		pViewShell->WriteFrameViewData();
//STRIP001 	}
//STRIP001 	// TP_GENERAL
//STRIP001 	//!!! const weg-casten, da Store nicht-const:
//STRIP001 	if ( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_ADDRESS, TRUE, &pItem ) )
//STRIP001 	{
//STRIP001 		((SfxAddressItem*)pItem)->Store();
//STRIP001 	}
//STRIP001 
//STRIP001 	SdOptions* pOptions = GetSdOptions(eDocType);
//STRIP001 	// Raster
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_GRID_OPTIONS ,
//STRIP001 							FALSE, (const SfxPoolItem**) &pItem ))
//STRIP001 	{
//STRIP001 		const SdOptionsGridItem* pGridItem = (SdOptionsGridItem*) pItem;
//STRIP001 		pGridItem->SetOptions( pOptions );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Layout
//STRIP001 	const SdOptionsLayoutItem* pLayoutItem = NULL;
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( ATTR_OPTIONS_LAYOUT,
//STRIP001 							FALSE, (const SfxPoolItem**) &pLayoutItem ))
//STRIP001 	{
//STRIP001 		pLayoutItem->SetOptions( pOptions );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Metric
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_METRIC, FALSE, &pItem ) )
//STRIP001 	{
//STRIP001 		if( pDoc && eDocType == pDoc->GetDocumentType() )
//STRIP001 			PutItem( *pItem );
//STRIP001 		pOptions->SetMetric( ( (SfxUInt16Item*) pItem )->GetValue() );
//STRIP001 	}
//STRIP001 	UINT16 nDefTab = pOptions->GetDefTab();
//STRIP001 	// Default-Tabulator
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_DEFTABSTOP, FALSE, &pItem ) )
//STRIP001 	{
//STRIP001 		nDefTab = ( (SfxUInt16Item*) pItem )->GetValue();
//STRIP001 		pOptions->SetDefTab( nDefTab );
//STRIP001 
//STRIP001 		bNewDefTab = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001     // Massstab
//STRIP001     if( SFX_ITEM_SET == rSet.GetItemState( ATTR_OPTIONS_SCALE_X, FALSE, &pItem ) )
//STRIP001     {
//STRIP001         INT32 nX = ( (SfxInt32Item*) pItem )->GetValue();
//STRIP001         if( SFX_ITEM_SET == rSet.GetItemState( ATTR_OPTIONS_SCALE_Y, FALSE, &pItem ) )
//STRIP001         {
//STRIP001             INT32 nY = ( (SfxInt32Item*) pItem )->GetValue();
//STRIP001             pOptions->SetScale( nX, nY );
//STRIP001 
//STRIP001             // #92067# Apply to document only if doc type match
//STRIP001             if( pDocSh && pDoc && eDocType == pDoc->GetDocumentType() )
//STRIP001             {
//STRIP001                 pDoc->SetUIScale( Fraction( nX, nY ) );
//STRIP001                 if( pViewShell )
//STRIP001                     pViewShell->SetRuler( pViewShell->HasRuler() );
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 	// Contents (Inhalte)
//STRIP001 	const SdOptionsContentsItem* pContentsItem = NULL;
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( ATTR_OPTIONS_CONTENTS,
//STRIP001 							FALSE, (const SfxPoolItem**) &pContentsItem ))
//STRIP001 	{
//STRIP001 		pContentsItem->SetOptions( pOptions );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Misc (Sonstiges)
//STRIP001 	const SdOptionsMiscItem* pMiscItem = NULL;
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( ATTR_OPTIONS_MISC,
//STRIP001 							FALSE, (const SfxPoolItem**) &pMiscItem ))
//STRIP001 	{
//STRIP001 		pMiscItem->SetOptions( pOptions );
//STRIP001 		bMiscOptions = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Fangen/Einrasten
//STRIP001 	const SdOptionsSnapItem* pSnapItem = NULL;
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( ATTR_OPTIONS_SNAP,
//STRIP001 							FALSE, (const SfxPoolItem**) &pSnapItem ))
//STRIP001 	{
//STRIP001 		pSnapItem->SetOptions( pOptions );
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxItemSet aPrintSet( GetPool(),
//STRIP001 					SID_PRINTER_NOTFOUND_WARN,	SID_PRINTER_NOTFOUND_WARN,
//STRIP001 					SID_PRINTER_CHANGESTODOC,	SID_PRINTER_CHANGESTODOC,
//STRIP001 					ATTR_OPTIONS_PRINT, 		ATTR_OPTIONS_PRINT,
//STRIP001 					0 );
//STRIP001 
//STRIP001 	// Drucken
//STRIP001 	const SdOptionsPrintItem* pPrintItem = NULL;
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( ATTR_OPTIONS_PRINT,
//STRIP001 							FALSE, (const SfxPoolItem**) &pPrintItem ))
//STRIP001 	{
//STRIP001 		pPrintItem->SetOptions( pOptions );
//STRIP001 
//STRIP001 		// PrintOptionsSet setzen
//STRIP001 		SdOptionsPrintItem aPrintItem( ATTR_OPTIONS_PRINT, pOptions );
//STRIP001 		SfxFlagItem aFlagItem( SID_PRINTER_CHANGESTODOC );
//STRIP001 		USHORT		nFlags = 0;
//STRIP001 
//STRIP001 		nFlags =  (aPrintItem.IsWarningSize() ? SFX_PRINTER_CHG_SIZE : 0) |
//STRIP001 				(aPrintItem.IsWarningOrientation() ? SFX_PRINTER_CHG_ORIENTATION : 0);
//STRIP001 		aFlagItem.SetValue( nFlags );
//STRIP001 
//STRIP001 		aPrintSet.Put( aPrintItem );
//STRIP001 		aPrintSet.Put( SfxBoolItem( SID_PRINTER_NOTFOUND_WARN, aPrintItem.IsWarningPrinter() ) );
//STRIP001 		aPrintSet.Put( aFlagItem );
//STRIP001 
//STRIP001 		bNewPrintOptions = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Nur, wenn auch der Dokumenttyp uebereinstimmt...
//STRIP001 	if( pDocSh && pDoc && eDocType == pDoc->GetDocumentType() )
//STRIP001 	{
//STRIP001 		if( bNewPrintOptions )
//STRIP001 		{
//STRIP001 			pDocSh->GetPrinter(TRUE)->SetOptions( aPrintSet );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Am Model den DefTab setzen
//STRIP001 		if( bNewDefTab )
//STRIP001 		{
//STRIP001 			SdDrawDocument* pDocument = pDocSh->GetDoc();
//STRIP001 			pDocument->SetDefaultTabulator( nDefTab );
//STRIP001 
//STRIP001 			SdOutliner* pOutl = pDocument->GetOutliner( FALSE );
//STRIP001 			if( pOutl )
//STRIP001 				pOutl->SetDefTab( nDefTab );
//STRIP001 
//STRIP001 			SdOutliner* pInternalOutl = pDocument->GetInternalOutliner( FALSE );
//STRIP001 			if( pInternalOutl )
//STRIP001 				pInternalOutl->SetDefTab( nDefTab );
//STRIP001 		}
//STRIP001 		if ( bMiscOptions )
//STRIP001 		{
//STRIP001             pDoc->SetSummationOfParagraphs( pMiscItem->IsSummationOfParagraphs() );
//STRIP001 			sal_uInt32 nSum = pMiscItem->IsSummationOfParagraphs() ? EE_CNTRL_ULSPACESUMMATION : 0;
//STRIP001 			sal_uInt32 nCntrl;
//STRIP001 
//STRIP001 			SdDrawDocument* pDocument = pDocSh->GetDoc();
//STRIP001 			SdrOutliner& rOutl = pDocument->GetDrawOutliner( FALSE );
//STRIP001 			nCntrl = rOutl.GetControlWord() &~ EE_CNTRL_ULSPACESUMMATION;
//STRIP001 			rOutl.SetControlWord( nCntrl | nSum );
//STRIP001 			SdOutliner* pOutl = pDocument->GetOutliner( FALSE );
//STRIP001 			if( pOutl )
//STRIP001 			{
//STRIP001 				nCntrl = pOutl->GetControlWord() &~ EE_CNTRL_ULSPACESUMMATION;
//STRIP001 				pOutl->SetControlWord( nCntrl | nSum );
//STRIP001 			}
//STRIP001 			pOutl = pDocument->GetInternalOutliner( FALSE );
//STRIP001 			if( pOutl )
//STRIP001 			{
//STRIP001 				nCntrl = pOutl->GetControlWord() &~ EE_CNTRL_ULSPACESUMMATION;
//STRIP001 				pOutl->SetControlWord( nCntrl | nSum );
//STRIP001 			}
//STRIP001 
//STRIP001             // Set printer independent layout mode.
//STRIP001             pDoc->SetPrinterIndependentLayout (pMiscItem->GetPrinterIndependentLayout());
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	pOptions->StoreConfig();
//STRIP001 	SFX_APP()->SaveConfiguration();
//STRIP001 
//STRIP001 	// Nur, wenn auch der Dokumenttyp uebereinstimmt...
//STRIP001 	if( pDocSh && pDoc && eDocType == pDoc->GetDocumentType() )
//STRIP001 	{
//STRIP001 		FieldUnit eUIUnit = (FieldUnit) pOptions->GetMetric();
//STRIP001 		pDoc->SetUIUnit(eUIUnit);
//STRIP001 
//STRIP001 		if (pViewShell)
//STRIP001 		{
//STRIP001 			// #74495# make sure no one is in text edit mode, cause there
//STRIP001 			// are some pointers remembered else (!)
//STRIP001 			if(pViewShell->GetView())
//STRIP001 				pViewShell->GetView()->EndTextEdit();
//STRIP001 
//STRIP001 			FrameView* pFrameView = pViewShell->GetFrameView();
//STRIP001 			pFrameView->Update(pOptions);
//STRIP001 			pViewShell->ReadFrameViewData(pFrameView);
//STRIP001 			pViewShell->SetUIUnit(eUIUnit);
//STRIP001 			pViewShell->SetDefTabHRuler( nDefTab );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pViewShell && pViewShell->GetViewFrame() ) 
//STRIP001 		pViewShell->GetViewFrame()->GetBindings().InvalidateAll( TRUE );
//STRIP001 }
//STRIP001 SfxTabPage* SdModule::CreateTabPage( USHORT nId, Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxTabPage* pRet = NULL;
//STRIP001 	switch(nId)
//STRIP001 	{
//STRIP001 		case SID_SD_TP_CONTENTS:
//STRIP001 		case SID_SI_TP_CONTENTS:
//STRIP001 			pRet = SdTpOptionsContents::Create(pParent, rSet);
//STRIP001 		break;
//STRIP001         case SID_SD_TP_SNAP:
//STRIP001 		case SID_SI_TP_SNAP:
//STRIP001 			pRet = SdTpOptionsSnap::Create(pParent, rSet);
//STRIP001 		break;
//STRIP001         case SID_SD_TP_PRINT:
//STRIP001 		case SID_SI_TP_PRINT:
//STRIP001 			pRet = SdPrintOptions::Create(pParent, rSet);
//STRIP001 			if(SID_SD_TP_PRINT == nId)
//STRIP001                 ( (SdPrintOptions*) pRet )->SetDrawMode();
//STRIP001 		break;
//STRIP001 		case SID_SI_TP_MISC:
//STRIP001 		case SID_SD_TP_MISC:
//STRIP001 			pRet = SdTpOptionsMisc::Create(pParent, rSet);
//STRIP001 			if(SID_SD_TP_MISC == nId)
//STRIP001                 ( (SdTpOptionsMisc*) pRet )->SetDrawMode();
//STRIP001             else
//STRIP001                 ( (SdTpOptionsMisc*) pRet )->SetImpressMode();
//STRIP001         break;
//STRIP001 		case RID_OFA_TP_INTERNATIONAL_SD:
//STRIP001 		case RID_OFA_TP_INTERNATIONAL_IMPR:
//STRIP001 			pRet = ::offapp::InternationalOptionsPage::CreateSd( pParent, rSet );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	DBG_ASSERT( pRet, "SdModule::CreateTabPage(): no valid ID for TabPage!" );
//STRIP001 
//STRIP001 	return pRet;
//STRIP001 }
}
