/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_preview.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:59:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONEFFECT_HPP_
// auto strip #include <com/sun/star/presentation/AnimationEffect.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_PRESENTATION_CLICKACTION_HPP_
// auto strip #include <com/sun/star/presentation/ClickAction.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONSPEED_HPP_
// auto strip #include <com/sun/star/presentation/AnimationSpeed.hpp>
// auto strip #endif

#include <bf_svx/svxids.hrc>           // SID_PRESENTATION
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SV_WRKWIN_HXX //autogen
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif

#include "preview.hxx"
//STRIP001 #include "frmview.hxx"
// auto strip #include "prevchld.hxx"
#include "preview.hrc"
#include "app.hrc"
namespace binfilter {
//STRIP001 #include "sdattr.hxx"
//STRIP001 #include "sdresid.hxx"
//STRIP001 #include "drawview.hxx"
//STRIP001 #include "drviewsh.hxx"
//STRIP001 #include "drawdoc.hxx"
//STRIP001 #include "fuslshow.hxx"
//STRIP001 #include "sdpage.hxx"
//STRIP001 #include "anminfo.hxx"
//STRIP001 #include "anmdef.hxx"
//STRIP001 #include "grdocsh.hxx"

using namespace ::com::sun::star;

/*N*/ SFX_IMPL_DOCKINGWINDOW( SdPreviewChildWindow, SID_PREVIEW_WIN)

#define OFFSET 4

/*************************************************************************
|*
|* Ableitung vom SfxChildWindow als "Behaelter" fuer Preview
|*
\************************************************************************/

/*N*/ SdPreviewChildWindow::SdPreviewChildWindow( Window* pParent,
/*N*/ 													 USHORT nId,
/*N*/ 													 SfxBindings* pBindings,
/*N*/ 													 SfxChildWinInfo* pInfo ) :
/*N*/ 	SfxChildWindow( pParent, nId )
/*N*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP");//STRIP001 	SdPreviewWin* pPreviewWin = new SdPreviewWin( pBindings, this, pParent,
//STRIP001 										SdResId( FLT_WIN_PREVIEW ) );
//STRIP001 	pWindow = pPreviewWin;
//STRIP001 
//STRIP001 	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
//STRIP001 
//STRIP001 	Size aMinSize( 80, 80 );
//STRIP001 	pPreviewWin->SetMinOutputSizePixel( aMinSize );
//STRIP001 
//STRIP001     pPreviewWin->Initialize( pInfo );
/*N*/ }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* ControllerItem fuer Preview
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdPreviewCtrlItem::SdPreviewCtrlItem( USHORT nId,
//STRIP001 								SdPreviewWin* 	pPrevWin,
//STRIP001 								SfxBindings*	pBindings) :
//STRIP001 	SfxControllerItem	( nId, *pBindings ),
//STRIP001 	pPreviewWin			( pPrevWin )
//STRIP001 {
//STRIP001 	pForwarder1 = new SfxStatusForwarder( SID_PREVIEW_QUALITY_COLOR, *this );
//STRIP001 	pForwarder2 = new SfxStatusForwarder( SID_PREVIEW_QUALITY_GRAYSCALE, *this );
//STRIP001 	pForwarder3 = new SfxStatusForwarder( SID_PREVIEW_QUALITY_BLACKWHITE, *this );
//STRIP001 	pForwarder4 = new SfxStatusForwarder( SID_PREVIEW_QUALITY_CONTRAST, *this );
//STRIP001 }
//STRIP001 
//STRIP001 SdPreviewCtrlItem::~SdPreviewCtrlItem()
//STRIP001 {
//STRIP001 	delete pForwarder1;
//STRIP001 	delete pForwarder2;
//STRIP001 	delete pForwarder3;
//STRIP001 	delete pForwarder4;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 //
//STRIP001 // Hier koennen Stati der Applikation ausgewertet werden
//STRIP001 //
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdPreviewCtrlItem::StateChanged( USHORT nSId,
//STRIP001 						SfxItemState eState, const SfxPoolItem* pItem )
//STRIP001 {
//STRIP001 	if( eState < SFX_ITEM_AVAILABLE )
//STRIP001 		return;
//STRIP001 
//STRIP001 	ULONG nNewMode = pPreviewWin->pShowWindow->GetDrawMode();
//STRIP001 
//STRIP001 	SvtAccessibilityOptions aAccOptions;
//STRIP001 
//STRIP001 	switch(nSId)
//STRIP001 	{
//STRIP001 		case SID_PREVIEW_STATE:
//STRIP001 		{
//STRIP001 			const SfxUInt16Item* pStateItem = PTR_CAST( SfxUInt16Item, pItem );
//STRIP001 			DBG_ASSERT( pStateItem, "SfxUInt16Item erwartet");
//STRIP001 			UINT16 nState = pStateItem->GetValue();
//STRIP001 
//STRIP001 			//pPreviewWin->DoSomething();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_PREVIEW_QUALITY_COLOR:
//STRIP001 		{
//STRIP001 			const SfxBoolItem* pBoolItem = PTR_CAST( SfxBoolItem, pItem );
//STRIP001 			DBG_ASSERT( pBoolItem, "SfxBoolItem erwartet!");
//STRIP001 
//STRIP001 			if(pBoolItem && pBoolItem->GetValue())
//STRIP001 				nNewMode = PREVIEW_DRAWMODE_COLOR;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_PREVIEW_QUALITY_GRAYSCALE:
//STRIP001 		{
//STRIP001 			const SfxBoolItem* pBoolItem = PTR_CAST( SfxBoolItem, pItem );
//STRIP001 			DBG_ASSERT( pBoolItem, "SfxBoolItem erwartet!");
//STRIP001 
//STRIP001 			if(pBoolItem && pBoolItem->GetValue())
//STRIP001 				nNewMode = PREVIEW_DRAWMODE_GRAYSCALE;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_PREVIEW_QUALITY_BLACKWHITE:
//STRIP001 		{
//STRIP001 			const SfxBoolItem* pBoolItem = PTR_CAST( SfxBoolItem, pItem );
//STRIP001 			DBG_ASSERT( pBoolItem, "SfxBoolItem erwartet!");
//STRIP001 
//STRIP001 			if(pBoolItem && pBoolItem->GetValue())
//STRIP001 				nNewMode = PREVIEW_DRAWMODE_BLACKWHITE;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_PREVIEW_QUALITY_CONTRAST:
//STRIP001 		{
//STRIP001 			if( aAccOptions.GetIsForPagePreviews() || !pPreviewWin->GetSettings().GetStyleSettings().GetHighContrastMode() )
//STRIP001 			{
//STRIP001 				const SfxBoolItem* pBoolItem = PTR_CAST( SfxBoolItem, pItem );
//STRIP001 				DBG_ASSERT( pBoolItem, "SfxBoolItem erwartet!");
//STRIP001 
//STRIP001 				if(pBoolItem && pBoolItem->GetValue())
//STRIP001 					nNewMode = PREVIEW_DRAWMODE_CONTRAST;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	};
//STRIP001 
//STRIP001 	bool bUseContrast = aAccOptions.GetIsForPagePreviews() && pPreviewWin->GetSettings().GetStyleSettings().GetHighContrastMode();
//STRIP001 	if( bUseContrast )
//STRIP001 		nNewMode = PREVIEW_DRAWMODE_CONTRAST;
//STRIP001 	
//STRIP001 	if( nNewMode != pPreviewWin->pShowWindow->GetDrawMode() )
//STRIP001 	{
//STRIP001 		pPreviewWin->pShowWindow->SetDrawMode(nNewMode);
//STRIP001 		pPreviewWin->pShowWindow->Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*  SdPreviewWin - FloatingWindow
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* ctor
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdPreviewWin::SdPreviewWin( SfxBindings* pInBindings,
//STRIP001 				SfxChildWindow *pCW, Window* pParent, const SdResId& rSdResId ) :
//STRIP001 		SfxDockingWindow    ( pInBindings, pCW, pParent, rSdResId ),
//STRIP001 		pBindings			( pInBindings ),
//STRIP001 		pDoc				( NULL ),
//STRIP001 		pView               ( NULL ),
//STRIP001 		pFuSlideShow        (NULL),
//STRIP001 		pShowWindow         (NULL),
//STRIP001 		nMagic(SDPREVIEWWIN_MAGIC),
//STRIP001 		mbInitialFocus(true)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	bInAnimation = FALSE;
//STRIP001 
//STRIP001 	pControllerItem = new SdPreviewCtrlItem( SID_PREVIEW_STATE, this, pBindings );
//STRIP001 	pShowWindow     = new SdShowWindow(this, this);
//STRIP001 
//STRIP001 	SdViewShell*    pViewShell =  (SdViewShell*) pBindings->GetDispatcher()->GetFrame()->GetViewShell();
//STRIP001 	FrameView*		pFrameView = pViewShell->GetFrameView();
//STRIP001 	SdDrawDocument* pTheDoc    = pViewShell->GetDoc();
//STRIP001 	SdPage*         pPage      = pViewShell->GetActualPage();
//STRIP001 	USHORT          nPage      = pPage->GetPageNum();
//STRIP001 	PageKind        ePageKind  = pPage->GetPageKind();
//STRIP001 	pViewShell->WriteFrameViewData();
//STRIP001 
//STRIP001 	if (pViewShell->ISA(SdDrawViewShell) &&
//STRIP001 	   ((SdDrawViewShell*) pViewShell)->GetEditMode() == EM_MASTERPAGE)
//STRIP001 	{
//STRIP001 		// MasterPages sollen in der Preview nicht dargestellt werden
//STRIP001 		for (USHORT i = 0; i < pTheDoc->GetSdPageCount(ePageKind); i++)
//STRIP001 		{
//STRIP001 			// Selektierte Seite suchen
//STRIP001 			pPage = pTheDoc->GetSdPage(i, ePageKind);
//STRIP001 			if (pPage->IsSelected())
//STRIP001 			{
//STRIP001 				nPage = pPage->GetPageNum();
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	nPage = (nPage - 1) / 2; // Sdr --> Sd
//STRIP001 /*
//STRIP001 	// adjust contrast mode initially
//STRIP001 	SvtAccessibilityOptions aAccOptions;
//STRIP001 	bool bUseContrast = aAccOptions.GetIsForPagePreviews() && GetSettings().GetStyleSettings().GetHighContrastMode();
//STRIP001     SetDrawMode( bUseContrast ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
//STRIP001 */
//STRIP001 	SetContext(pTheDoc, nPage, pFrameView);
//STRIP001 	pBindings->Invalidate(SID_PREVIEW_WIN);
//STRIP001 
//STRIP001 	StartListening( maColorConfig );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* dtor
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdPreviewWin::~SdPreviewWin()
//STRIP001 {
//STRIP001 	EndListening( maColorConfig );
//STRIP001 
//STRIP001 	if ( pFuSlideShow )
//STRIP001 		pFuSlideShow->Terminate();
//STRIP001 
//STRIP001 	nMagic = 0L;
//STRIP001 	delete pControllerItem;
//STRIP001 
//STRIP001 	if( pFuSlideShow )
//STRIP001 		pFuSlideShow->Destroy();
//STRIP001 
//STRIP001 	delete pShowWindow;
//STRIP001 	delete pView;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* StateChanged takes care of setting correct position
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPreviewWin::StateChanged( StateChangedType nType )
//STRIP001 {
//STRIP001     if ( nType == STATE_CHANGE_INITSHOW )
//STRIP001     {
//STRIP001         // calculate initial position
//STRIP001         SfxViewShell*   pViewShell = pBindings->GetDispatcher()->GetFrame()->GetViewShell();
//STRIP001         Window*         pWin = pViewShell ? pViewShell->GetWindow() : NULL;
//STRIP001         
//STRIP001         if( pWin )
//STRIP001         {
//STRIP001             Rectangle   aRect( ScreenToOutputPixel( pWin->OutputToScreenPixel( pWin->GetPosPixel() ) ), pWin->GetSizePixel() );
//STRIP001             Point       aPoint( aRect.TopLeft() );
//STRIP001             
//STRIP001             aPoint.X() += aRect.GetSize().Width() - GetSizePixel().Width() - 
//STRIP001                 ( pWin->GetSettings().GetStyleSettings().GetScrollBarSize() << 1 );
//STRIP001             
//STRIP001             SetFloatingPos( aPoint );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     SfxDockingWindow::StateChanged( nType );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* SetContext, dem Preview-Window das aktuelle Dokument, die aktuelle Seite
//STRIP001 |* und den View-Status bekanntgeben
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPreviewWin::SetContext(SdDrawDocument* pDrawDoc, USHORT nSdPage,
//STRIP001 							  FrameView* pFrm)
//STRIP001 {
//STRIP001 	// die alte Show erst loeschen, wenn die neue schon erzeugt wurde;
//STRIP001 	// dadurch ist sichergestellt, dass die Magic Number der zerstoerten
//STRIP001 	// Show nicht durch das Ueberschreiben mit der neuen Show wieder
//STRIP001 	// gueltig wird
//STRIP001 	FuSlideShow*	pOldShow = pFuSlideShow;
//STRIP001 	SdDrawView*		pOldView = pView;
//STRIP001 
//STRIP001 	pDoc = pDrawDoc;        // als Member merken
//STRIP001 
//STRIP001 	// pDoc == NULL waehrend des Kontextwechsels
//STRIP001 	if (pDoc)
//STRIP001 	{
//STRIP001 		SdPage* pPage = pDoc->GetSdPage(nSdPage, PK_STANDARD);
//STRIP001 
//STRIP001 		SdDrawDocShell* pDocShell = pDoc->GetDocSh();
//STRIP001 		pView = new SdDrawView(pDocShell, pShowWindow, NULL);
//STRIP001 		updateViewSettings();
//STRIP001 
//STRIP001 		SfxAllItemSet aSet(pDrawDoc->GetItemPool());
//STRIP001 		{
//STRIP001 		SfxBoolItem aItem(ATTR_PRESENT_ALL, FALSE);
//STRIP001 		aSet.Put(aItem, aItem.Which());
//STRIP001 		}
//STRIP001 		{
//STRIP001 		SfxStringItem aItem(ATTR_PRESENT_DIANAME, pPage->GetName());
//STRIP001 		aSet.Put(aItem, aItem.Which());
//STRIP001 		}
//STRIP001 		{
//STRIP001 		SfxBoolItem aItem(ATTR_PRESENT_ENDLESS, FALSE);
//STRIP001 		aSet.Put(aItem, aItem.Which());
//STRIP001 		}
//STRIP001 		{
//STRIP001 		SfxBoolItem aItem(ATTR_PRESENT_MANUEL, TRUE);
//STRIP001 		aSet.Put(aItem, aItem.Which());
//STRIP001 		}
//STRIP001 		{
//STRIP001 		SfxBoolItem aItem(ATTR_PRESENT_MOUSE, TRUE);
//STRIP001 		aSet.Put(aItem, aItem.Which());
//STRIP001 		}
//STRIP001 		{
//STRIP001 		SfxBoolItem aItem(ATTR_PRESENT_PEN, FALSE);
//STRIP001 		aSet.Put(aItem, aItem.Which());
//STRIP001 		}
//STRIP001 		{
//STRIP001 		SfxBoolItem aItem(ATTR_PRESENT_NAVIGATOR, FALSE);
//STRIP001 		aSet.Put(aItem, aItem.Which());
//STRIP001 		}
//STRIP001 		{
//STRIP001 		SfxBoolItem aItem(ATTR_PRESENT_CHANGE_PAGE, TRUE);
//STRIP001 		aSet.Put(aItem, aItem.Which());
//STRIP001 		}
//STRIP001 		{
//STRIP001 		SfxBoolItem aItem(ATTR_PRESENT_ALWAYS_ON_TOP, FALSE);
//STRIP001 		aSet.Put(aItem, aItem.Which());
//STRIP001 		}
//STRIP001 		{
//STRIP001 		SfxBoolItem aItem(ATTR_PRESENT_FULLSCREEN, FALSE);
//STRIP001 		aSet.Put(aItem, aItem.Which());
//STRIP001 		}
//STRIP001 		{
//STRIP001 		SfxBoolItem aItem(ATTR_PRESENT_ANIMATION_ALLOWED, TRUE);
//STRIP001 		aSet.Put(aItem, aItem.Which());
//STRIP001 		}
//STRIP001 		{
//STRIP001 		SfxUInt32Item aItem(ATTR_PRESENT_PAUSE_TIMEOUT, 0);
//STRIP001 		aSet.Put(aItem, aItem.Which());
//STRIP001 		}
//STRIP001 		{
//STRIP001 		SfxBoolItem aItem(ATTR_PRESENT_SHOW_PAUSELOGO, FALSE);
//STRIP001 		aSet.Put(aItem, aItem.Which());
//STRIP001 		}
//STRIP001 
//STRIP001 		SfxRequest aReq(SID_PRESENTATION, 0, aSet);
//STRIP001 
//STRIP001 		pFuSlideShow = new FuSlideShow(NULL, NULL, pView, pDoc, aReq);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pFuSlideShow = NULL;
//STRIP001 		pView = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pOldShow )
//STRIP001 	{
//STRIP001 		if( pOldShow->IsInputLocked() )
//STRIP001 			pOldShow->Terminate();
//STRIP001 
//STRIP001 		pOldShow->Destroy();
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pOldView;
//STRIP001 
//STRIP001 	if (pDoc)
//STRIP001 	{
//STRIP001 		pFuSlideShow->SetAnimationMode(ANIMATIONMODE_PREVIEW, pShowWindow);
//STRIP001 		pFuSlideShow->StartShow();
//STRIP001 	}
//STRIP001 
//STRIP001 	pShowWindow->Invalidate();
//STRIP001 	pShowWindow->Update();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* Resize, die Groesse hat sich geaendert
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPreviewWin::Resize()
//STRIP001 {
//STRIP001 	Size aWinSize( GetOutputSizePixel() ); // vorher rSize im Resizing()
//STRIP001 
//STRIP001 	if ( !IsFloatingMode() ||
//STRIP001 		 !GetFloatingWindow()->IsRollUp() )
//STRIP001 	{
//STRIP001 		aWinSize.Width()  -= 2 * OFFSET;
//STRIP001 		aWinSize.Height() -= 2 * OFFSET;
//STRIP001 		pShowWindow->SetPosPixel(Point(OFFSET, OFFSET));
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxDockingWindow::Resize();
//STRIP001 	pShowWindow->SetSizePixel( aWinSize );
//STRIP001 
//STRIP001 	if (!bInAnimation)
//STRIP001 	{
//STRIP001 		if (pFuSlideShow)
//STRIP001 			pFuSlideShow->Resize(aWinSize);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// waehrend ein Effekt laeuft, kann man die Show nicht resizen,
//STRIP001 		// deshalb: die alte Show zerstoeren und durch eine neue
//STRIP001 		// ersetzen
//STRIP001 		SdViewShell* 	pViewShell = (SdViewShell*) pBindings->GetDispatcher()->GetFrame()->GetViewShell();
//STRIP001 		FrameView*      pFrameView = pViewShell->GetFrameView();
//STRIP001 		SdDrawDocument* pTheDoc    = pViewShell->GetDoc();
//STRIP001 		SdPage*         pPage      = pViewShell->GetActualPage();
//STRIP001 		USHORT          nPage      = (pPage->GetPageNum() - 1) / 2; // Sdr --> Sd
//STRIP001 
//STRIP001 		SetContext(pTheDoc, nPage, pFrameView);
//STRIP001 		pFuSlideShow->Resize(aWinSize);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* Close
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL SdPreviewWin::Close()
//STRIP001 {
//STRIP001 	SfxBoolItem aItem( SID_PREVIEW_WIN, FALSE );
//STRIP001 
//STRIP001 	pBindings->GetDispatcher()->Execute( 
//STRIP001 		SID_PREVIEW_WIN, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 
//STRIP001 	SfxDockingWindow::Close();
//STRIP001 
//STRIP001 	return( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* Paint
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPreviewWin::PaintContents(const Rectangle& rRect)
//STRIP001 {
//STRIP001 	const ULONG		nOldDrawMode = pShowWindow->GetDrawMode();
//STRIP001 	const Wallpaper	aBack( pShowWindow->GetBackground() );
//STRIP001 
//STRIP001 	pShowWindow->SetDrawMode( DRAWMODE_DEFAULT );
//STRIP001 	pShowWindow->SetBackground( Color( COL_BLACK ) );
//STRIP001 	pShowWindow->Erase( rRect );
//STRIP001 	pShowWindow->SetBackground( aBack );
//STRIP001 	pShowWindow->SetDrawMode( nOldDrawMode );
//STRIP001 
//STRIP001 	if( pDoc && pView->IsPresPaintAllowed() )
//STRIP001 		pView->InitRedraw(pShowWindow, Region(rRect));
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* KeyInputFromContents
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPreviewWin::KeyInputFromContents(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* MouseMoveFromContents
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPreviewWin::MouseMoveFromContents(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	if (pFuSlideShow && !bInAnimation &&
//STRIP001 		pDoc && pDoc->GetDocumentType() == DOCUMENT_TYPE_IMPRESS &&
//STRIP001 		!pDoc->GetDocSh()->ISA(SdGraphicDocShell))
//STRIP001 	{
//STRIP001 		Pointer aPtr(POINTER_ARROW);
//STRIP001 		Point	aPos = pShowWindow->PixelToLogic(rMEvt.GetPosPixel());
//STRIP001 
//STRIP001 		// Objekt mit Effekt?
//STRIP001 		SdrObject* pObject = pFuSlideShow->OverObject(aPos);
//STRIP001 
//STRIP001 		if (pObject)
//STRIP001 		{
//STRIP001 			SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObject);
//STRIP001 
//STRIP001 			if (pInfo)
//STRIP001 			{
//STRIP001 				if ((pInfo->bActive &&
//STRIP001 					 ( pInfo->eEffect != presentation::AnimationEffect_NONE ||
//STRIP001 					   pInfo->eTextEffect != presentation::AnimationEffect_NONE)) ||
//STRIP001 					(pInfo->eClickAction == presentation::ClickAction_VANISH ||
//STRIP001 					 pInfo->eClickAction == presentation::ClickAction_INVISIBLE))
//STRIP001 				{
//STRIP001 					aPtr = Pointer(POINTER_REFHAND);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if (pShowWindow->GetPointer() != aPtr)
//STRIP001 		{
//STRIP001 			pShowWindow->SetPointer(aPtr);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* MouseButtonUpFromContents
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPreviewWin::MouseButtonUpFromContents(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	// Position umrechnen vom ShowWindow auf Seitenkoordinaten
//STRIP001 	Point aPos = pShowWindow->PixelToLogic(rMEvt.GetPosPixel());
//STRIP001 
//STRIP001 	if (pFuSlideShow && !bInAnimation && aPos == aDownPos &&
//STRIP001 		pDoc && pDoc->GetDocumentType() == DOCUMENT_TYPE_IMPRESS &&
//STRIP001 		!pDoc->GetDocSh()->ISA(SdGraphicDocShell))
//STRIP001 	{
//STRIP001 		SdrObject* pObject = pFuSlideShow->OverObject(aPos);
//STRIP001 
//STRIP001 		if (rMEvt.IsLeft() && pObject)
//STRIP001 		{
//STRIP001 			SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObject);
//STRIP001 			if (pInfo)
//STRIP001 			{
//STRIP001 				if ((pInfo->bActive &&
//STRIP001 					 ( pInfo->eEffect != presentation::AnimationEffect_NONE ||
//STRIP001 					   pInfo->eTextEffect != presentation::AnimationEffect_NONE )) ||
//STRIP001 					(pInfo->eClickAction == presentation::ClickAction_VANISH ||
//STRIP001 					 pInfo->eClickAction == presentation::ClickAction_INVISIBLE))
//STRIP001 				{
//STRIP001 					HideAndAnimateObject(pObject);
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					AnimatePage();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				AnimatePage();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			AnimatePage();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* MouseButtonDownFromContents
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPreviewWin::MouseButtonDownFromContents(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	// Position umrechnen vom ShowWindow auf Seitenkoordinaten und merken
//STRIP001 	aDownPos = pShowWindow->PixelToLogic(rMEvt.GetPosPixel());
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* HideAndAnimateObject, eine Objektanimation zeigen
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPreviewWin::HideAndAnimateObject(SdrObject* pObject)
//STRIP001 {
//STRIP001 	if( pFuSlideShow && 
//STRIP001 	    ( !pFuSlideShow->IsSoundPlaying() || !pFuSlideShow->IsSoundPlayFull() ) &&
//STRIP001 		( pDoc && pDoc->GetDocumentType() == DOCUMENT_TYPE_IMPRESS ) &&
//STRIP001 	    !bInAnimation &&
//STRIP001 		!pDoc->GetDocSh()->ISA(SdGraphicDocShell))
//STRIP001 	{
//STRIP001 		bInAnimation = TRUE;
//STRIP001 		pView->SetAnimationEnabled(FALSE);
//STRIP001 
//STRIP001 		pFuSlideShow->HideAndAnimateObject(pObject);
//STRIP001 
//STRIP001 		// im Reschedule des Effekts zerstoert?
//STRIP001 		if (nMagic != SDPREVIEWWIN_MAGIC)
//STRIP001 		{
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001 		pView->SetAnimationEnabled(TRUE);
//STRIP001 		bInAnimation = FALSE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* AnimatePage, die Seitenanimation zeigen
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdPreviewWin::AnimatePage()
//STRIP001 {
//STRIP001 	if( pFuSlideShow && 
//STRIP001 	    ( !pFuSlideShow->IsSoundPlaying() || !pFuSlideShow->IsSoundPlayFull() ) &&
//STRIP001 		( pDoc && pDoc->GetDocumentType() == DOCUMENT_TYPE_IMPRESS ) &&
//STRIP001 	    !bInAnimation &&
//STRIP001 		!pDoc->GetDocSh()->ISA(SdGraphicDocShell))
//STRIP001 	{
//STRIP001 		bInAnimation = TRUE;
//STRIP001 		pView->SetAnimationEnabled(FALSE);
//STRIP001 
//STRIP001 		pFuSlideShow->AnimatePage();
//STRIP001 
//STRIP001 		// im Reschedule des Effekts zerstoert?
//STRIP001 		if (nMagic != SDPREVIEWWIN_MAGIC)
//STRIP001 		{
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001 		pView->SetAnimationEnabled(TRUE);
//STRIP001 		bInAnimation = FALSE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SdPreviewWin::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 	{
//STRIP001 		updateViewSettings();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdPreviewWin::GetFocus()
//STRIP001 {
//STRIP001 #ifndef WIN32
//STRIP001 	if( mbInitialFocus )
//STRIP001 	{
//STRIP001 		mbInitialFocus = false;
//STRIP001 		GrabFocusToDocument();
//STRIP001 	}
//STRIP001 	else
//STRIP001 #endif
//STRIP001 	{
//STRIP001 		SfxDockingWindow::GetFocus();
//STRIP001 	}
//STRIP001 }

//STRIP001 void SdPreviewWin::updateViewSettings()
//STRIP001 {
//STRIP001 	// adjust contrast mode
//STRIP001 	SvtAccessibilityOptions aAccOptions;
//STRIP001 	bool bUseWhiteColor = !aAccOptions.GetIsForPagePreviews() && GetSettings().GetStyleSettings().GetHighContrastMode();
//STRIP001 	Color aColor( bUseWhiteColor ? COL_WHITE : COL_AUTO );
//STRIP001 	if( pView )
//STRIP001 		pView->SetApplicationDocumentColor( aColor );
//STRIP001 }

//STRIP001 void SdPreviewWin::SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType, const SfxHint& rHint, const TypeId& rHintType)
//STRIP001 {
//STRIP001 	if( rHint.ISA( SfxSimpleHint ) && ( (SfxSimpleHint&) rHint ).GetId() == SFX_HINT_COLORS_CHANGED )
//STRIP001 	{
//STRIP001 		updateViewSettings();
//STRIP001 		if( pView )
//STRIP001 			pView->InvalidateAllWin();
//STRIP001 	}
//STRIP001 }
}
