/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_fuinsert.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2006/08/14 14:37:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <tools/urlobj.hxx>

#ifndef SVTOOLS_URIHELPER_HXX
#include <svtools/urihelper.hxx>
#endif

#include <bf_sfx2/request.hxx>
#include <so3/outplace.hxx>
#include <svtools/globalnameitem.hxx>
#include <so3/plugin.hxx>
#include <so3/pastedlg.hxx>
#include <bf_svx/pfiledlg.hxx>
#include <bf_svx/impgrf.hxx>
#include <bf_svx/dialogs.hrc>
#include <bf_svx/linkmgr.hxx>
#include <bf_svx/svdetc.hxx>
#ifndef _UNOTOOLS_UCBSTREAMHELPER_HXX
#include <unotools/ucbstreamhelper.hxx>
#endif
#ifndef _SFX_PRINTER_HXX
#include <bf_sfx2/printer.hxx>
#endif
#ifndef _SO_CLSIDS_HXX
#include <so3/clsids.hxx>
#endif
#ifndef _SFXECODE_HXX //autogen
#include <svtools/sfxecode.hxx>
#endif
#ifndef _TRANSFER_HXX //autogen
#include <svtools/transfer.hxx>
#endif
#ifndef _URLBMK_HXX
#include <svtools/urlbmk.hxx>
#endif
#ifndef _INSDLG_HXX //autogen
#include <so3/insdlg.hxx>
#endif
#ifndef _SVDOBJ_HXX //autogen
#include <bf_svx/svdobj.hxx>
#endif
#ifndef _SVDOGRAF_HXX //autogen
#include <bf_svx/svdograf.hxx>
#endif
#ifndef _SVDOOLE2_HXX //autogen
#include <bf_svx/svdoole2.hxx>
#endif
#ifndef _EDITENG_HXX //autogen
#include <bf_svx/editeng.hxx>
#endif
#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _SOT_FORMATS_HXX //autogen
#include <sot/formats.hxx>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <bf_svx/svdpagv.hxx>
#endif
#ifndef _SCH_DLL_HXX //autogen
#include <bf_sch/schdll.hxx>
#endif
#ifndef _FRAMEOBJ_HXX //autogen
#include <bf_sfx2/frameobj.hxx>
#endif
#ifndef _MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SVX_OPENGRF_HXX
#include <bf_svx/opengrf.hxx>
#endif

#include "app.hrc"
#include "misc.hxx"
#include "sdresid.hxx"
#include "sdview.hxx"
#include "app.hxx"
#include "sdwindow.hxx"
#include "drawview.hxx"
#include "drviewsh.hxx"
#include "fuinsert.hxx"
#include "docshell.hxx"
#include "grdocsh.hxx"
#include "strings.hrc"
#include "drawdoc.hxx"
#include "sdgrffilter.hxx"
#include "sdxfer.hxx"
#include "so3/staticbaseurl.hxx"
namespace binfilter {

//STRIP001 #ifndef SO2_DECL_SVINPLACEOBJECT_DEFINED
//STRIP001 #define SO2_DECL_SVINPLACEOBJECT_DEFINED
//STRIP001 SO2_DECL_REF(SvInPlaceObject)
//STRIP001 #endif
//STRIP001 #ifndef SO2_DECL_SVSTORAGE_DEFINED
//STRIP001 #define SO2_DECL_SVSTORAGE_DEFINED
//STRIP001 SO2_DECL_REF(SvStorage)
//STRIP001 #endif
//STRIP001 
//STRIP001 TYPEINIT1( FuInsertGraphic, FuPoor );
//STRIP001 TYPEINIT1( FuInsertClipboard, FuPoor );
//STRIP001 TYPEINIT1( FuInsertOLE, FuPoor );
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* FuInsertGraphic::Konstruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 #ifdef WNT
//STRIP001 #pragma optimize ( "", off )
//STRIP001 #endif
//STRIP001 
//STRIP001 FuInsertGraphic::FuInsertGraphic(SdViewShell* pViewSh, SdWindow* pWin, SdView* pView,
//STRIP001 				 SdDrawDocument* pDoc, SfxRequest& rReq)
//STRIP001 	   : FuPoor(pViewSh, pWin, pView, pDoc, rReq)
//STRIP001 {
//STRIP001 	SvxOpenGraphicDialog	aDlg(SdResId(STR_INSERTGRAPHIC));
//STRIP001 
//STRIP001 	if( aDlg.Execute() == GRFILTER_OK )
//STRIP001 	{
//STRIP001 		USHORT		nError = 0;
//STRIP001 		Graphic		aGraphic;
//STRIP001 
//STRIP001 		if( (nError=aDlg.GetGraphic(aGraphic)) == GRFILTER_OK )
//STRIP001 		{
//STRIP001 			if( pViewSh->ISA(SdDrawViewShell) )
//STRIP001 			{
//STRIP001 				sal_Int8	nAction = DND_ACTION_COPY;
//STRIP001 				SdrGrafObj* pEmptyGrafObj = NULL;
//STRIP001 
//STRIP001 				if ( pView->HasMarkedObj() )
//STRIP001 				{
//STRIP001 					/**********************************************************
//STRIP001 					* Is an empty graphic object available?
//STRIP001 					**********************************************************/
//STRIP001 					const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 
//STRIP001 					if (rMarkList.GetMarkCount() == 1)
//STRIP001 					{
//STRIP001 						SdrMark* pMark = rMarkList.GetMark(0);
//STRIP001 						SdrObject* pObj = pMark->GetObj();
//STRIP001 
//STRIP001 						if (pObj->GetObjInventor() == SdrInventor &&
//STRIP001 							pObj->GetObjIdentifier() == OBJ_GRAF)
//STRIP001 						{
//STRIP001 							nAction = DND_ACTION_LINK;
//STRIP001 							pEmptyGrafObj = (SdrGrafObj*) pObj;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				Point aPos;
//STRIP001 				Rectangle aRect(aPos, pWindow->GetOutputSizePixel() );
//STRIP001 				aPos = aRect.Center();
//STRIP001 				aPos = pWindow->PixelToLogic(aPos);
//STRIP001 				SdrGrafObj* pGrafObj = pView->InsertGraphic(aGraphic, nAction, aPos, pEmptyGrafObj, NULL);
//STRIP001 
//STRIP001 				if(pGrafObj && aDlg.IsAsLink())
//STRIP001 				{
//STRIP001 					// store link only?
//STRIP001 					String aFltName(aDlg.GetCurrentFilter());
//STRIP001 					String aPath(aDlg.GetPath());
//STRIP001 					pGrafObj->SetGraphicLink(aPath, aFltName);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SdGRFFilter::HandleGraphicFilterError( nError, GetGrfFilter()->GetLastError().nStreamError );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 #ifdef WNT
//STRIP001 #pragma optimize ( "", on )
//STRIP001 #endif
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* FuInsertGraphic::Destruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 FuInsertGraphic::~FuInsertGraphic()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* FuInsertClipboard::Konstruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 FuInsertClipboard::FuInsertClipboard(SdViewShell* pViewSh, SdWindow* pWin, SdView* pView,
//STRIP001 				 SdDrawDocument* pDoc, SfxRequest& rReq)
//STRIP001 	   : FuPoor(pViewSh, pWin, pView, pDoc, rReq)
//STRIP001 {
//STRIP001 	TransferableDataHelper						aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( pWin ) );
//STRIP001 	SvPasteObjectDialog*						pDlg = new SvPasteObjectDialog();
//STRIP001     const String                                aEmptyString;
//STRIP001 	::com::sun::star::datatransfer::DataFlavor	aFlavor;
//STRIP001     ULONG                                       nFormatId;
//STRIP001 
//STRIP001 	pDlg->Insert( SOT_FORMATSTR_ID_EMBED_SOURCE, aEmptyString );
//STRIP001 	pDlg->Insert( SOT_FORMATSTR_ID_LINK_SOURCE, aEmptyString );
//STRIP001 	pDlg->Insert( SOT_FORMATSTR_ID_DRAWING, aEmptyString ); 
//STRIP001 	pDlg->Insert( SOT_FORMATSTR_ID_SVXB, aEmptyString );
//STRIP001 	pDlg->Insert( FORMAT_GDIMETAFILE, aEmptyString );
//STRIP001 	pDlg->Insert( FORMAT_BITMAP, aEmptyString );
//STRIP001     pDlg->Insert( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK, aEmptyString );
//STRIP001 	pDlg->Insert( FORMAT_STRING, aEmptyString );
//STRIP001 	pDlg->Insert( SOT_FORMATSTR_ID_HTML, aEmptyString );
//STRIP001 	pDlg->Insert( FORMAT_RTF, aEmptyString );
//STRIP001 	pDlg->Insert( SOT_FORMATSTR_ID_EDITENGINE, aEmptyString );
//STRIP001 
//STRIP001     try
//STRIP001     {
//STRIP001 	    nFormatId = pDlg->Execute( pWindow, aDataHelper.GetTransferable() );
//STRIP001     }
//STRIP001     catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001         nFormatId = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( nFormatId && aDataHelper.GetTransferable().is() )
//STRIP001 	{
//STRIP001 		sal_Int8 nAction = DND_ACTION_COPY;
//STRIP001 
//STRIP001 		if( !pView->InsertData( aDataHelper, 
//STRIP001                                 pWindow->PixelToLogic( Rectangle( Point(), pWindow->GetOutputSizePixel() ).Center() ),
//STRIP001 						        nAction, FALSE, nFormatId ) && 
//STRIP001             ( pViewShell && pViewShell->ISA( SdDrawViewShell ) ) )
//STRIP001         {
//STRIP001 		    SdDrawViewShell*    pDrViewSh = (SdDrawViewShell*) pViewShell;
//STRIP001 			String			    aEmptyStr;
//STRIP001 			INetBookmark	    aINetBookmark( aEmptyStr, aEmptyStr );
//STRIP001 
//STRIP001 			if( ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK ) &&
//STRIP001 				  aDataHelper.GetINetBookmark( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK, aINetBookmark ) ) ||
//STRIP001 				( aDataHelper.HasFormat( SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR ) &&
//STRIP001 				  aDataHelper.GetINetBookmark( SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR, aINetBookmark ) ) ||
//STRIP001 				( aDataHelper.HasFormat( SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR ) &&
//STRIP001 				  aDataHelper.GetINetBookmark( SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR, aINetBookmark ) ) )
//STRIP001 			{
//STRIP001 				pDrViewSh->InsertURLField( aINetBookmark.GetURL(), aINetBookmark.GetDescription(), aEmptyStr, NULL );
//STRIP001 			}
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pDlg;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* FuInsertClipboard::Destruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 FuInsertClipboard::~FuInsertClipboard()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* FuInsertOLE::Konstruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 FuInsertOLE::FuInsertOLE(SdViewShell* pViewSh, SdWindow* pWin, SdView* pView,
//STRIP001 						 SdDrawDocument* pDoc, SfxRequest& rReq)
//STRIP001 	: FuPoor(pViewSh, pWin, pView, pDoc, rReq)
//STRIP001 {
//STRIP001 	String aEmptyStr;
//STRIP001 
//STRIP001 #ifdef STARIMAGE_AVAILABLE
//STRIP001 	if (nSlotId == SID_INSERT_IMAGE &&
//STRIP001 		(pView->HasMarkedObj() || pView->IsTextEdit()))
//STRIP001 	{
//STRIP001 		/**********************************************************************
//STRIP001 		* Ist ein Graphik-Objekt selektiert?
//STRIP001 		**********************************************************************/
//STRIP001 		if (pView->IsTextEdit())
//STRIP001 		{
//STRIP001 		   pView->EndTextEdit();
//STRIP001 		}
//STRIP001 
//STRIP001 		const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 
//STRIP001 		if (rMarkList.GetMarkCount() == 1)
//STRIP001 		{
//STRIP001 			SdrMark* pMark = rMarkList.GetMark(0);
//STRIP001 			SdrObject* pObj = pMark->GetObj();
//STRIP001 
//STRIP001 			if( pObj->GetObjInventor() == SdrInventor &&
//STRIP001 				pObj->GetObjIdentifier() == OBJ_GRAF &&
//STRIP001 				((SdrGrafObj*) pObj)->GetGraphicType() == GRAPHIC_BITMAP )
//STRIP001 			{
//STRIP001 				// Graphik-Objekt wird bearbeitet
//STRIP001 				pViewSh->DoVerb(0);
//STRIP001 				return;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 #endif
//STRIP001 
//STRIP001 	if ( nSlotId == SID_ATTR_TABLE ||
//STRIP001 		 nSlotId == SID_INSERT_DIAGRAM ||
//STRIP001 #ifdef STARIMAGE_AVAILABLE
//STRIP001 		 nSlotId == SID_INSERT_IMAGE ||
//STRIP001 #endif
//STRIP001 		 nSlotId == SID_INSERT_MATH )
//STRIP001 	{
//STRIP001 		/**********************************************************************
//STRIP001 		* Diagramm oder StarCalc-Tabelle einfuegen
//STRIP001 		**********************************************************************/
//STRIP001 		SvInPlaceObjectRef aIPObj;
//STRIP001 		SvStorageRef aStor = new SvStorage( aEmptyStr, STREAM_STD_READWRITE );
//STRIP001 
//STRIP001 		if (nSlotId == SID_INSERT_DIAGRAM)
//STRIP001 		{
//STRIP001 			aIPObj = &((SvFactory*)SvInPlaceObject::ClassFactory())->CreateAndInit(
//STRIP001 						  SvGlobalName(BF_SO3_SCH_CLASSID_60), aStor);
//STRIP001 		}
//STRIP001 		else if (nSlotId == SID_ATTR_TABLE)
//STRIP001 		{
//STRIP001 			aIPObj = &((SvFactory*)SvInPlaceObject::ClassFactory())->CreateAndInit(
//STRIP001 						  SvGlobalName(BF_SO3_SC_CLASSID_60), aStor);
//STRIP001 		}
//STRIP001 #ifdef STARIMAGE_AVAILABLE
//STRIP001 		else if (nSlotId == SID_INSERT_IMAGE)
//STRIP001 		{
//STRIP001 			aIPObj = &((SvFactory*)SvInPlaceObject::ClassFactory())->CreateAndInit(
//STRIP001 						  SvGlobalName(BF_SO3_SIM_CLASSID_60), aStor);
//STRIP001 		}
//STRIP001 #endif
//STRIP001 		else if (nSlotId == SID_INSERT_MATH)
//STRIP001 		{
//STRIP001 			aIPObj = &((SvFactory*)SvInPlaceObject::ClassFactory())->CreateAndInit(
//STRIP001 						  SvGlobalName(BF_SO3_SM_CLASSID_60), aStor);
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aIPObj.Is() )
//STRIP001 		{
//STRIP001 			String aName = pViewShell->GetViewFrame()->GetObjectShell()->
//STRIP001 								InsertObject( aIPObj, aEmptyStr )->GetObjName();
//STRIP001 
//STRIP001 			Size aSize = aIPObj->GetVisArea().GetSize();
//STRIP001 
//STRIP001 			if (aSize.Height() == 0 || aSize.Width() == 0)
//STRIP001 			{
//STRIP001 				// Rechteck mit ausgewogenem Kantenverhaeltnis
//STRIP001 				aSize.Width()  = 14100;
//STRIP001 				aSize.Height() = 10000;
//STRIP001 				aIPObj->SetVisAreaSize( OutputDevice::LogicToLogic( aSize, MAP_100TH_MM, aIPObj->GetMapUnit() ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aSize = OutputDevice::LogicToLogic(aSize, aIPObj->GetMapUnit(), MAP_100TH_MM);
//STRIP001 
//STRIP001 			Point aPos;
//STRIP001 			Rectangle aWinRect(aPos, pWin->GetOutputSizePixel() );
//STRIP001 			aPos = aWinRect.Center();
//STRIP001 			aPos = pWindow->PixelToLogic(aPos);
//STRIP001 			aPos.X() -= aSize.Width() / 2;
//STRIP001 			aPos.Y() -= aSize.Height() / 2;
//STRIP001 			Rectangle aRect (aPos, aSize);
//STRIP001 			SdrOle2Obj* pOleObj = new SdrOle2Obj(aIPObj, aName, aRect);
//STRIP001 			SdrPageView* pPV = pView->GetPageViewPvNum(0);
//STRIP001 			if( pView->InsertObject(pOleObj, *pPV, SDRINSERT_SETDEFLAYER) )
//STRIP001 			{
//STRIP001 				if (nSlotId == SID_INSERT_DIAGRAM)
//STRIP001 				{
//STRIP001 					pOleObj->SetProgName( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "StarChart" ) ) );
//STRIP001 					SchDLL::SetTransparentBackground( aIPObj, TRUE );
//STRIP001 				}
//STRIP001 				else if (nSlotId == SID_ATTR_TABLE)
//STRIP001 				{
//STRIP001 					pOleObj->SetProgName( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "StarCalc" ) ) );
//STRIP001 				}
//STRIP001 #ifdef STARIMAGE_AVAILABLE
//STRIP001 				else if (nSlotId == SID_INSERT_IMAGE)
//STRIP001 				{
//STRIP001 					pOleObj->SetProgName( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "StarImage" ) ) );
//STRIP001 				}
//STRIP001 #endif
//STRIP001 				else if (nSlotId == SID_INSERT_MATH)
//STRIP001 				{
//STRIP001 					pOleObj->SetProgName( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "StarMath" ) ) );
//STRIP001 				}
//STRIP001 
//STRIP001 				pView->HideMarkHdl(NULL);
//STRIP001 				pOleObj->SetLogicRect(aRect);
//STRIP001 				aIPObj->SetVisAreaSize( OutputDevice::LogicToLogic( aRect.GetSize(), MAP_100TH_MM, aIPObj->GetMapUnit() ) );
//STRIP001 				pViewShell->ActivateObject(pOleObj, SVVERB_SHOW);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ErrorHandler::HandleError(* new StringErrorInfo(ERRCODE_SFX_OLEGENERAL,
//STRIP001 										aEmptyStr ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		/**********************************************************************
//STRIP001 		* Objekt einfuegen
//STRIP001 		**********************************************************************/
//STRIP001 		SvInPlaceObjectRef aIPObj;
//STRIP001 		SvInsertOleObjectDialog* pOleDlg = NULL;
//STRIP001 		SvInsertPlugInDialog* pPlugInDlg = NULL;
//STRIP001 		SvInsertAppletDialog* pAppletDlg = NULL;
//STRIP001 		SfxInsertFloatingFrameDialog* pFrameDlg = NULL;
//STRIP001 
//STRIP001 		if (nSlotId == SID_INSERT_OBJECT)
//STRIP001 		{
//STRIP001 	        SFX_REQUEST_ARG( rReq, pNameItem, SfxGlobalNameItem, SID_INSERT_OBJECT, sal_False );
//STRIP001 			if ( pNameItem )
//STRIP001 			{
//STRIP001 				SvGlobalName aName = pNameItem->GetValue();
//STRIP001 				const SotFactory* pFact = SvFactory::Find( aName );
//STRIP001 				if ( pFact )
//STRIP001 				{
//STRIP001 					SvStorageRef aStor = new SvStorage( aEmptyStr );
//STRIP001 					aIPObj = &((SvFactory*)SvInPlaceObject::ClassFactory())->CreateAndInit( aName,aStor );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SvStorageRef aStor = new SvStorage( FALSE, aEmptyStr );
//STRIP001 					String aFileName;
//STRIP001 					BOOL bOk;
//STRIP001 					aIPObj = SvOutPlaceObject::InsertObject( NULL, &aStor, bOk, aName, aFileName );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pOleDlg = new SvInsertOleObjectDialog();
//STRIP001 				pOleDlg->SetHelpId(SID_INSERT_OBJECT);
//STRIP001 
//STRIP001 				// Die Liste ist eine Memberliste, und loescht selbst ihre Eintraege
//STRIP001 				SvObjectServerList aServerLst;
//STRIP001 
//STRIP001 				// Liste mit Servern fuellen
//STRIP001 				pOleDlg->FillObjectServerList(&aServerLst);
//STRIP001 
//STRIP001 				// Eigenen Eintrag loeschen
//STRIP001 				if (pDoc->GetDocumentType() == DOCUMENT_TYPE_DRAW)
//STRIP001 				{
//STRIP001 					aServerLst.Remove( *SdGraphicDocShell::ClassFactory() );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					aServerLst.Remove( *SdDrawDocShell::ClassFactory() );
//STRIP001 				}
//STRIP001 
//STRIP001 				SvStorageRef aStor = new SvStorage( aEmptyStr, STREAM_STD_READWRITE );
//STRIP001 				aIPObj = pOleDlg->Execute(pWin, aStor, &aServerLst );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if (nSlotId == SID_INSERT_PLUGIN)
//STRIP001 		{
//STRIP001 			pPlugInDlg = new SvInsertPlugInDialog();
//STRIP001 			pPlugInDlg->SetHelpId(SID_INSERT_PLUGIN);
//STRIP001 
//STRIP001 			SvStorageRef aStor = new SvStorage( aEmptyStr, STREAM_STD_READWRITE );
//STRIP001 			aIPObj = pPlugInDlg->Execute(pWin, aStor);
//STRIP001 		}
//STRIP001 		else if (nSlotId == SID_INSERT_SOUND || nSlotId == SID_INSERT_VIDEO)
//STRIP001 		{ // load sound- or video- plugin
//STRIP001 
//STRIP001 			// create special filedialog for plugins
//STRIP001 			SvxPluginFileDlg aPluginFileDialog (pWin, nSlotId);
//STRIP001 
//STRIP001 			// open filedlg
//STRIP001 			if( ERRCODE_NONE == aPluginFileDialog.Execute () )
//STRIP001 			{
//STRIP001 				// get URL
//STRIP001 				String aStrURL(aPluginFileDialog.GetPath());
//STRIP001 				aStrURL = so3::StaticBaseUrl::SmartRelToAbs( aStrURL, FALSE,
//STRIP001 													  INetURLObject::WAS_ENCODED,
//STRIP001 													  INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001 
//STRIP001 				INetURLObject aURL( aStrURL );
//STRIP001 
//STRIP001 				if( aURL.GetProtocol() != INET_PROT_NOT_VALID )
//STRIP001 				{
//STRIP001 					// create plugin, initialize, etc.
//STRIP001 					SvFactory * pPlugIn = SvPlugInObject::ClassFactory();
//STRIP001 					SvStorageRef aStor = new SvStorage( aEmptyStr, STREAM_STD_READWRITE );
//STRIP001 					SvPlugInObjectRef xObj = &pPlugIn->CreateAndInit( *pPlugIn, aStor );
//STRIP001 					xObj->SetPlugInMode( (USHORT)PLUGIN_EMBEDED );
//STRIP001 					xObj->SetURL( aURL );
//STRIP001 					aIPObj = (SvInPlaceObject*)&xObj;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// PlugIn konnte nicht erzeugt werden
//STRIP001 					String aStrErr( ResId( STR_ERROR_OBJNOCREATE_PLUGIN , SOAPP->GetResMgr() ) );
//STRIP001 					String aMask;
//STRIP001 					aMask += sal_Unicode('%');
//STRIP001 					aStrErr.SearchAndReplace( aMask, aStrURL );
//STRIP001 					ErrorBox( pWin, WB_3DLOOK | WB_OK, aStrErr ).Execute();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if (nSlotId == SID_INSERT_APPLET)
//STRIP001 		{
//STRIP001 			pAppletDlg = new SvInsertAppletDialog();
//STRIP001 			pAppletDlg->SetHelpId(SID_INSERT_APPLET);
//STRIP001 
//STRIP001 			SvStorageRef aStor = new SvStorage( aEmptyStr, STREAM_STD_READWRITE );
//STRIP001 			aIPObj = pAppletDlg->Execute(pWin, aStor);
//STRIP001 		}
//STRIP001 		else if (nSlotId == SID_INSERT_FLOATINGFRAME)
//STRIP001 		{
//STRIP001 			pFrameDlg = new SfxInsertFloatingFrameDialog( pWin );
//STRIP001 //            pFrameDlg->SetHelpId(SID_INSERT_FLOATINGFRAME);
//STRIP001 
//STRIP001 			SvStorageRef aStor = new SvStorage( aEmptyStr, STREAM_STD_READWRITE );
//STRIP001 			aIPObj = pFrameDlg->Execute(aStor);
//STRIP001 		}
//STRIP001 
//STRIP001 		if (aIPObj.Is())
//STRIP001 		{
//STRIP001 			if( SVOBJ_MISCSTATUS_RESIZEONPRINTERCHANGE & aIPObj->GetMiscStatus() )
//STRIP001 				aIPObj->OnDocumentPrinterChanged( pDocSh->GetPrinter(FALSE) );
//STRIP001 
//STRIP001 			BOOL bInsertNewObject = FALSE;
//STRIP001 			Size aSize;
//STRIP001 			String aName;
//STRIP001 
//STRIP001 			SvEmbeddedInfoObject* pInfoObj = pViewShell->GetViewFrame()
//STRIP001 						  ->GetObjectShell()->InsertObject( aIPObj, aEmptyStr );
//STRIP001 
//STRIP001 			if (pInfoObj)
//STRIP001 			{
//STRIP001 				bInsertNewObject = TRUE;
//STRIP001 				aName = pInfoObj->GetObjName();
//STRIP001 
//STRIP001 				aSize = aIPObj->GetVisArea().GetSize();
//STRIP001 
//STRIP001 				if (aSize.Height() == 0 || aSize.Width() == 0)
//STRIP001 				{
//STRIP001 					// Rechteck mit ausgewogenem Kantenverhaeltnis
//STRIP001 					aSize.Width()  = 14100;
//STRIP001 					aSize.Height() = 10000;
//STRIP001 					aIPObj->SetVisAreaSize( OutputDevice::LogicToLogic( aSize, MAP_100TH_MM, aIPObj->GetMapUnit() ) );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					aSize = OutputDevice::LogicToLogic(aSize, aIPObj->GetMapUnit(), MAP_100TH_MM);
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( pView->HasMarkedObj() )
//STRIP001 				{
//STRIP001 					/**********************************************************
//STRIP001 					* Ist ein leeres OLE-Objekt vorhanden?
//STRIP001 					**********************************************************/
//STRIP001 					const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 
//STRIP001 					if (rMarkList.GetMarkCount() == 1)
//STRIP001 					{
//STRIP001 						SdrMark* pMark = rMarkList.GetMark(0);
//STRIP001 						SdrObject* pObj = pMark->GetObj();
//STRIP001 
//STRIP001 						if (pObj->GetObjInventor() == SdrInventor &&
//STRIP001 							pObj->GetObjIdentifier() == OBJ_OLE2)
//STRIP001 						{
//STRIP001 							SvInPlaceObjectRef aOldIPObj = ( (SdrOle2Obj*) pObj)->GetObjRef();
//STRIP001 
//STRIP001 							if ( !aOldIPObj.Is() )
//STRIP001 							{
//STRIP001 								/**************************************************
//STRIP001 								* Das leere OLE-Objekt bekommt ein neues IPObj
//STRIP001 								**************************************************/
//STRIP001 								bInsertNewObject = FALSE;
//STRIP001 								pObj->SetEmptyPresObj(FALSE);
//STRIP001 								( (SdrOle2Obj*) pObj)->SetOutlinerParaObject(NULL);
//STRIP001 								( (SdrOle2Obj*) pObj)->SetObjRef(aIPObj);
//STRIP001 								( (SdrOle2Obj*) pObj)->SetPersistName(aName);
//STRIP001 								( (SdrOle2Obj*) pObj)->SetName(aName);
//STRIP001 								Rectangle aRect = ( (SdrOle2Obj*) pObj)->GetLogicRect();
//STRIP001 
//STRIP001 								pView->HideMarkHdl(NULL);
//STRIP001 								aIPObj->SetVisAreaSize( OutputDevice::LogicToLogic( aRect.GetSize(), MAP_100TH_MM, aIPObj->GetMapUnit() ) );
//STRIP001 
//STRIP001 								if ( nSlotId == SID_ATTR_TABLE ||
//STRIP001 									 nSlotId == SID_INSERT_DIAGRAM ||
//STRIP001 #ifdef STARIMAGE_AVAILABLE
//STRIP001 									 nSlotId == SID_INSERT_IMAGE ||
//STRIP001 #endif
//STRIP001 									 nSlotId == SID_INSERT_MATH )
//STRIP001 								{
//STRIP001 									if (nSlotId == SID_INSERT_DIAGRAM)
//STRIP001 										SchDLL::SetTransparentBackground( aIPObj, TRUE );
//STRIP001 
//STRIP001 									pViewShell->ActivateObject( (SdrOle2Obj*) pObj, SVVERB_SHOW);
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if (bInsertNewObject)
//STRIP001 			{
//STRIP001 				/**************************************************************
//STRIP001 				* Ein neues OLE-Objekt wird erzeugt
//STRIP001 				**************************************************************/
//STRIP001 				SdrPageView* pPV = pView->GetPageViewPvNum(0);
//STRIP001 				Size aPageSize = pPV->GetPage()->GetSize();
//STRIP001 				Point aPnt ((aPageSize.Width()	- aSize.Width())  / 2,
//STRIP001 							(aPageSize.Height() - aSize.Height()) / 2);
//STRIP001 				Rectangle aRect (aPnt, aSize);
//STRIP001 
//STRIP001 				SdrOle2Obj* pObj = new SdrOle2Obj(aIPObj, aName, aRect);
//STRIP001 
//STRIP001 				if( pView->InsertObject(pObj, *pPV, SDRINSERT_SETDEFLAYER) )
//STRIP001 				{
					//	#73279# Math objects change their object size during InsertObject.
					//	New size must be set in SdrObject, or a wrong scale will be set at
					//	ActivateObject.

//STRIP001 					Size aNewSize = Window::LogicToLogic( aIPObj->GetVisArea().GetSize(),
//STRIP001 									MapMode( aIPObj->GetMapUnit() ), MapMode( MAP_100TH_MM ) );
//STRIP001 					if ( aNewSize != aSize )
//STRIP001 					{
//STRIP001 						aRect.SetSize( aNewSize );
//STRIP001 						pObj->SetLogicRect( aRect );
//STRIP001 					}

//STRIP001 					if (pOleDlg && pOleDlg->IsCreateNew())
//STRIP001 					{
//STRIP001 						pView->HideMarkHdl(NULL);
//STRIP001 						pObj->SetLogicRect(aRect);
//STRIP001 						aIPObj->SetVisAreaSize( OutputDevice::LogicToLogic( aRect.GetSize(), MAP_100TH_MM, aIPObj->GetMapUnit() ) );
//STRIP001 						pViewShell->ActivateObject(pObj, SVVERB_SHOW);
//STRIP001 					}
//STRIP001 
//STRIP001 					Size aVisSizePixel = pWin->GetOutputSizePixel();
//STRIP001 					Rectangle aVisAreaWin = pWin->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
//STRIP001 					pViewShell->VisAreaChanged(aVisAreaWin);
//STRIP001 					pDocSh->SetVisArea(aVisAreaWin);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pOleDlg;
//STRIP001 		delete pPlugInDlg;
//STRIP001 		delete pAppletDlg;
//STRIP001 		delete pFrameDlg;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* FuInsertOLE::Destruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 FuInsertOLE::~FuInsertOLE()
//STRIP001 {
//STRIP001 }
}
