/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviews5.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: hr $ $Date: 2006/08/14 15:15:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _OUTLINER_HXX
#include <bf_svx/outliner.hxx>
#endif
#ifndef _SVXIDS_HXX
#include <bf_svx/svxids.hrc>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <bf_svx/svdpagv.hxx>
#endif
#ifndef _SV_SCRBAR_HXX //autogen
#include <vcl/scrbar.hxx>
#endif
#ifndef _TL_POLY_HXX
#include <tools/poly.hxx>
#endif
#ifndef _SVX_FMSHELL_HXX //autogen
#include <bf_svx/fmshell.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XEVENTLISTENER_HPP_
#include <com/sun/star/document/XEventListener.hpp>
#endif

#ifndef _SVX_ACCESSIBILITY_ACCESSIBLE_SHAPE_TREE_INFO_HXX
#include <bf_svx/AccessibleShapeTreeInfo.hxx>
#endif

#ifndef _SVX_ACCESSIBILITY_CHILDREN_MANAGER_HXX
#include <bf_svx/ChildrenManager.hxx>
#endif

#ifndef _SD_ACCESSIBILITY_ACCESSIBLE_DRAW_DOCUMENT_VIEW_HXX
#include "AccessibleDrawDocumentView.hxx"
#endif


#include "strings.hrc"
#include "res_bmp.hrc"
#include "glob.hrc"
#include "app.hrc"

#include "optsitem.hxx"
#include "app.hxx"
#include "frmview.hxx"
#include "sdattr.hxx"
//STRIP001#include "futext.hxx"
#include "sdpage.hxx"
#include "stlpool.hxx"
#include "sdresid.hxx"
#include "sdwindow.hxx"
#include "drawview.hxx"
#include "drawdoc.hxx"
#include "docshell.hxx"
#include "drviewsh.hxx"
#include "presvish.hxx"
#include "sdoutl.hxx"
#include "sdclient.hxx"
#include "fuslshow.hxx"
#include "unokywds.hxx"
#include "SdUnoDrawView.hxx"
namespace binfilter {

#define TABCONTROL_INITIAL_SIZE     350
#define PAPER_SHADOW_EXT_PIXEL        2

/*************************************************************************
|*
|* Wird gerufen, wenn sich das Model aendert
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::ModelHasChanged()
/*N*/ {
/*N*/ 	Invalidate();
/*N*/ 	// Damit der Navigator auch einen aktuellen Status bekommt
/*N*/ 	GetViewFrame()->GetBindings().Invalidate( SID_NAVIGATOR_STATE, TRUE, FALSE );
/*N*/ 
/*N*/ 	// Damit das Effekte-Window die Reihenfolge updaten kann
/*N*/ 	UpdateEffectWindow();
/*N*/ 
/*N*/ 	//Update3DWindow();
/*N*/ 	SfxBoolItem aItem( SID_3D_STATE, TRUE );
/*N*/ 	GetViewFrame()->GetDispatcher()->Execute( 
/*N*/ 		SID_3D_STATE, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
/*N*/ 
/*N*/ 	// jetzt den von der Drawing Engine neu erzeugten TextEditOutliner
/*N*/ 	// initialisieren
/*N*/ 	Outliner* pOutliner 	  = pDrView->GetTextEditOutliner();
/*N*/ 	if (pOutliner)
/*N*/ 	{
/*?*/ 		SfxStyleSheetPool* pSPool = (SfxStyleSheetPool*) pDocSh->GetStyleSheetPool();
/*?*/ 		pOutliner->SetStyleSheetPool(pSPool);
/*?*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Ersatz fuer AdjustPosSizePixel ab Sfx 248a
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::InnerResizePixel(const Point &rPos, const Size &rSize)
//STRIP001 {
//STRIP001 	if (!pFuSlideShow)
//STRIP001 	{
//STRIP001 		// Da die innere Groesse vorgegeben wird, ist ein Zoomen auf
//STRIP001 		// Seitenbreite nicht erlaubt
//STRIP001 		bZoomOnPage = FALSE;
//STRIP001 
//STRIP001 		SdViewShell::InnerResizePixel(rPos, rSize);
//STRIP001 
//STRIP001 		SetZoomRect( pDocSh->GetVisArea(ASPECT_CONTENT) );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Ersatz fuer AdjustPosSizePixel ab Sfx 248a
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::OuterResizePixel(const Point &rPos, const Size &rSize)
//STRIP001 {
//STRIP001 	if (!pFuSlideShow || !pFuSlideShow->IsFullScreen())
//STRIP001 	{
//STRIP001 		SdViewShell::OuterResizePixel(rPos, rSize);
//STRIP001 
//STRIP001 		if ( pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
//STRIP001 		{
//STRIP001 			SetZoomRect( pDocSh->GetVisArea(ASPECT_CONTENT) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     FuSlideShow* pSlideShow = ( pFuSlideShow ? pFuSlideShow : ( pDrView ? pDrView->GetSlideShow() : NULL ) );
//STRIP001 
//STRIP001     if( pSlideShow && !pSlideShow->IsFullScreen())
//STRIP001 		pSlideShow->Resize( rSize );
//STRIP001 }


/** This call is simply delegated to the base class.
*/
//STRIP001 void SdDrawViewShell::AdjustPosSizePixel(const Point &rNewPos,
//STRIP001 										 const Size &rNewSize)
//STRIP001 {
//STRIP001     SdViewShell::AdjustPosSizePixel (rNewPos, rNewSize);
//STRIP001 }



//STRIP001 void SdDrawViewShell::ArrangeGUIElements ()
//STRIP001 {
//STRIP001     Size aTabSize = aTabControl.GetSizePixel();
//STRIP001 
//STRIP001     // Retrieve the current size (thickness) of the scroll bars.  That is
//STRIP001     // the width of the vertical and the height of the horizontal scroll
//STRIP001     // bar.
//STRIP001     int nScrollBarSize = GetViewFrame()->GetWindow().GetSettings().GetStyleSettings().GetScrollBarSize();
//STRIP001 	aScrBarWH = Size (nScrollBarSize, nScrollBarSize);
//STRIP001 
//STRIP001 	if( 0 == aTabSize.Width() )
//STRIP001 	{
//STRIP001 	    if( 0.0 == pFrameView->GetTabCtrlPercent() )
//STRIP001             aTabSize.Width() = TABCONTROL_INITIAL_SIZE;
//STRIP001         else
//STRIP001         {
//STRIP001             const Size aFrameSize( GetViewFrame()->GetWindow().GetOutputSizePixel() );
//STRIP001             aTabSize.Width() = FRound( aFrameSize.Width() * pFrameView->GetTabCtrlPercent() );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     aTabSize.Height() = aScrBarWH.Height();
//STRIP001     Point aHPos = aViewPos;
//STRIP001     aHPos.Y() += aViewSize.Height() - aTabSize.Height();
//STRIP001 
//STRIP001     Size aBtnSize(aScrBarWH);
//STRIP001     aPageBtn.SetPosSizePixel(aHPos, aBtnSize);
//STRIP001     aHPos.X() += aBtnSize.Width();
//STRIP001     aMasterPageBtn.SetPosSizePixel(aHPos, aBtnSize);
//STRIP001     aHPos.X() += aBtnSize.Width();
//STRIP001     aLayerBtn.SetPosSizePixel(aHPos, aBtnSize);
//STRIP001     aHPos.X() += aBtnSize.Width();
//STRIP001 
//STRIP001     aTabControl.SetSizePixel(aTabSize);
//STRIP001     
//STRIP001     SdViewShell::ArrangeGUIElements ();
//STRIP001 
//STRIP001     aTabSize.Width() = pHScrlArray[0]->GetPosPixel().X() - aHPos.X();
//STRIP001     if ( aTabSize.Width() < 0 )
//STRIP001         aTabSize.Width() = 0;
//STRIP001 
//STRIP001     aTabControl.SetPosSizePixel(aHPos, aTabSize);
//STRIP001     aLayerTab.SetPosSizePixel(aHPos, aTabSize);
//STRIP001 
//STRIP001     SdClient*	pIPClient = (SdClient*)GetIPClient();
//STRIP001     BOOL bClientActive = FALSE;
//STRIP001     if ( pIPClient && pIPClient->IsInPlaceActive() )
//STRIP001         bClientActive = TRUE;
//STRIP001 
//STRIP001     BOOL bInPlaceActive = pDocSh->GetProtocol().IsInPlaceActive();
//STRIP001 
//STRIP001 //		  if ( bZoomOnPage && pDocSh->GetCreateMode() != SFX_CREATE_MODE_EMBEDDED )
//STRIP001     if ( bZoomOnPage && !bInPlaceActive && !bClientActive )
//STRIP001     {
//STRIP001         // bei Split immer erstes Fenster resizen
//STRIP001         pWindow = pWinArray[0][0];
//STRIP001         SfxRequest aReq(SID_SIZE_PAGE, 0, pDoc->GetItemPool());
//STRIP001         ExecuteSlot( aReq );
//STRIP001     }
//STRIP001 }

/*************************************************************************
|*
|* Daten der FrameView auf die aktuelle View uebertragen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::ReadFrameViewData(FrameView* pView)
/*N*/ {
/*N*/ 	BOOL bChanged = pDoc->IsChanged();		// merken
/*N*/ 
/*N*/ 	// Diese Option wird am Model eingestellt
/*N*/ 	pDoc->SetPickThroughTransparentTextFrames(
/*N*/ 			 SD_MOD()->GetSdOptions(pDoc->GetDocumentType())->IsPickThrough());
/*N*/ 
/*N*/ 	// Initialisierungen der Zeichen-(Bildschirm-)Attribute
/*N*/ 	if (HasRuler() != pView->HasRuler())
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	SetRuler( pView->HasRuler() );
/*N*/ 
/*N*/ 	if (pDrView->GetGridCoarse() != pView->GetGridCoarse())
/*N*/ 		pDrView->SetGridCoarse( pView->GetGridCoarse() );
/*N*/ 
/*N*/ 	if (pDrView->GetGridFine() != pView->GetGridFine())
/*N*/ 		pDrView->SetGridFine( pView->GetGridFine() );
/*N*/ 
/*N*/ 	if (pDrView->GetSnapGrid() != pView->GetSnapGrid())
/*N*/ 		pDrView->SetSnapGrid( pView->GetSnapGrid() );
/*N*/ 
/*N*/ 	if (pDrView->GetSnapGridWidthX() != pView->GetSnapGridWidthX() || pDrView->GetSnapGridWidthY() != pView->GetSnapGridWidthY())
/*N*/ 		pDrView->SetSnapGridWidth(pView->GetSnapGridWidthX(), pView->GetSnapGridWidthY());
/*N*/ 
/*N*/ 	if (pDrView->IsGridVisible() != pView->IsGridVisible())
/*N*/ 		pDrView->SetGridVisible( pView->IsGridVisible() );
/*N*/ 
/*N*/ 	if (pDrView->IsGridFront() != pView->IsGridFront())
/*N*/ 		pDrView->SetGridFront( pView->IsGridFront() );
/*N*/ 
/*N*/ 	if (pDrView->GetSnapAngle() != pView->GetSnapAngle())
/*N*/ 		pDrView->SetSnapAngle( pView->GetSnapAngle() );
/*N*/ 
/*N*/ 	if (pDrView->IsGridSnap() !=  pView->IsGridSnap() )
/*N*/ 		pDrView->SetGridSnap( pView->IsGridSnap() );
/*N*/ 
/*N*/ 	if (pDrView->IsBordSnap() !=  pView->IsBordSnap() )
/*N*/ 		pDrView->SetBordSnap( pView->IsBordSnap() );
/*N*/ 
/*N*/ 	if (pDrView->IsHlplSnap() !=  pView->IsHlplSnap() )
/*N*/ 		pDrView->SetHlplSnap( pView->IsHlplSnap() );

/*N*/ 	if (pDrView->IsOFrmSnap() !=  pView->IsOFrmSnap() )
/*N*/ 		pDrView->SetOFrmSnap( pView->IsOFrmSnap() );
/*N*/ 
/*N*/ 	if (pDrView->IsOPntSnap() !=  pView->IsOPntSnap() )
/*N*/ 		pDrView->SetOPntSnap( pView->IsOPntSnap() );
/*N*/ 
/*N*/ 	if (pDrView->IsOConSnap() !=  pView->IsOConSnap() )
/*N*/ 		pDrView->SetOConSnap( pView->IsOConSnap() );
/*N*/ 
/*N*/ 	if (pDrView->IsHlplVisible() != pView->IsHlplVisible() )
/*?*/ 		pDrView->SetHlplVisible( pView->IsHlplVisible() );
/*?*/ 
/*N*/ 	if (pDrView->IsDragStripes() != pView->IsDragStripes() )
/*?*/ 		pDrView->SetDragStripes( pView->IsDragStripes() );
/*?*/ 
/*N*/ 	if (pDrView->IsPlusHandlesAlwaysVisible() != pView->IsPlusHandlesAlwaysVisible() )
/*?*/ 		pDrView->SetPlusHandlesAlwaysVisible( pView->IsPlusHandlesAlwaysVisible() );
/*?*/ 
/*N*/ 	if (pDrView->GetSnapMagneticPixel() != pView->GetSnapMagneticPixel() )
/*N*/ 		pDrView->SetSnapMagneticPixel( pView->GetSnapMagneticPixel() );
/*N*/ 
/*N*/ 	if (pDrView->IsMarkedHitMovesAlways() != pView->IsMarkedHitMovesAlways() )
/*N*/ 		pDrView->SetMarkedHitMovesAlways( pView->IsMarkedHitMovesAlways() );
/*N*/ 
/*N*/ 	if (pDrView->IsMoveOnlyDragging() != pView->IsMoveOnlyDragging() )
/*?*/ 		pDrView->SetMoveOnlyDragging( pView->IsMoveOnlyDragging() );
/*?*/ 
//    pDrView->SetSlantButShear( pView->IsSlantButShear() );
/*N*/ 
/*N*/ 	if (pDrView->IsNoDragXorPolys() != pView->IsNoDragXorPolys() )
/*?*/ 		pDrView->SetNoDragXorPolys( pView->IsNoDragXorPolys() );
/*?*/ 
/*N*/ 	if (pDrView->IsCrookNoContortion() != pView->IsCrookNoContortion() )
/*?*/ 		pDrView->SetCrookNoContortion( pView->IsCrookNoContortion() );
/*?*/ 
/*N*/ 	if (pDrView->IsAngleSnapEnabled() != pView->IsAngleSnapEnabled() )
/*?*/ 		pDrView->SetAngleSnapEnabled( pView->IsAngleSnapEnabled() );
/*?*/ 
/*N*/ 	if (pDrView->IsBigOrtho() != pView->IsBigOrtho() )
/*N*/ 		pDrView->SetBigOrtho( pView->IsBigOrtho() );
/*N*/ 
/*N*/ 	if (pDrView->IsOrtho() != pView->IsOrtho() )
/*?*/ 		pDrView->SetOrtho( pView->IsOrtho() );
/*?*/ 
/*N*/ 	if (pDrView->GetEliminatePolyPointLimitAngle() != pView->GetEliminatePolyPointLimitAngle() )
/*N*/ 		pDrView->SetEliminatePolyPointLimitAngle( pView->GetEliminatePolyPointLimitAngle() );
/*N*/ 
/*N*/ 	if (pDrView->IsEliminatePolyPoints() != pView->IsEliminatePolyPoints() )
/*?*/ 		pDrView->SetEliminatePolyPoints( pView->IsEliminatePolyPoints() );
/*?*/ 
/*N*/ 	if (pDrView->IsLineDraft() != pView->IsLineDraft() )
/*?*/ 		pDrView->SetLineDraft( pView->IsLineDraft() );
/*?*/ 
/*N*/ 	if (pDrView->IsFillDraft() != pView->IsFillDraft() )
/*N*/ 	{
/*?*/ 		pDrView->ReleaseMasterPagePaintCache();
/*?*/ 		pDrView->SetFillDraft( pView->IsFillDraft() );
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pDrView->IsTextDraft() != pView->IsTextDraft() )
/*?*/ 		pDrView->SetTextDraft( pView->IsTextDraft() );
/*?*/ 
/*N*/ 	if (pDrView->IsGrafDraft() != pView->IsGrafDraft() )
/*?*/ 		pDrView->SetGrafDraft( pView->IsGrafDraft() );
/*?*/ 
/*N*/ 	if (pDrView->IsSolidMarkHdl() != pView->IsSolidMarkHdl() )
/*N*/ 		pDrView->SetSolidMarkHdl( pView->IsSolidMarkHdl() );
/*N*/ 
/*N*/ 	if (pDrView->IsSolidDragging() != pView->IsSolidDragging() )
/*?*/ 		pDrView->SetSolidDragging( pView->IsSolidDragging() );
/*?*/ 
/*N*/ 	if (pDrView->IsQuickTextEditMode() != pView->IsQuickEdit())
/*N*/ 		pDrView->SetQuickTextEditMode( pView->IsQuickEdit() );
/*N*/ 
/*N*/ 	// Definition:
/*N*/ 	//	grosse Handles:	9
/*N*/ 	//	kleine Handles:	7
/*N*/ 	USHORT nTmp = pDrView->GetMarkHdlSizePixel();
/*N*/ 	//DBG_ASSERT(nTmp != 7, "HandleSize != 7 oder 9");
/*N*/ 	if( nTmp == 9 && !pView->IsBigHandles() )
/*?*/ 		pDrView->SetMarkHdlSizePixel( 7 );
/*?*/ 	else if( nTmp == 7 && pView->IsBigHandles() )
/*?*/ 		pDrView->SetMarkHdlSizePixel( 9 );
/*N*/ 
/*N*/ 
/*N*/ 	SdrPageView* pPageView = pDrView->GetPageViewPvNum(0);
/*N*/ 
/*N*/ 	if (pPageView)
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pPageView->GetVisibleLayers() != pView->GetVisibleLayers() )
//STRIP001 /*?*/ 			pPageView->SetVisibleLayers( pView->GetVisibleLayers() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if ( pPageView->GetPrintableLayers() != pView->GetPrintableLayers() )
//STRIP001 /*?*/ 			pPageView->SetPrintableLayers( pView->GetPrintableLayers() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if ( pPageView->GetLockedLayers() != pView->GetLockedLayers() )
//STRIP001 /*?*/ 			pPageView->SetLockedLayers( pView->GetLockedLayers() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if (ePageKind == PK_NOTES)
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (pPageView->GetHelpLines() != pView->GetNotesHelpLines())
//STRIP001 /*?*/ 				pPageView->SetHelpLines( pView->GetNotesHelpLines() );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else if (ePageKind == PK_HANDOUT)
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (pPageView->GetHelpLines() != pView->GetHandoutHelpLines())
//STRIP001 /*?*/ 				pPageView->SetHelpLines( pView->GetHandoutHelpLines() );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (pPageView->GetHelpLines() != pView->GetStandardHelpLines())
//STRIP001 /*?*/ 				pPageView->SetHelpLines( pView->GetStandardHelpLines() );
//STRIP001 /*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pDrView->GetActiveLayer() != pView->GetActiveLayer() )
/*N*/ 		pDrView->SetActiveLayer( pView->GetActiveLayer() );
/*N*/ 
/*N*/ 	USHORT nSelectedPage = 0;
/*N*/ 
/*N*/ 	if (ePageKind != PK_HANDOUT)
/*N*/ 	{
/*N*/ 		nSelectedPage = pView->GetSelectedPage();
/*N*/ 	}
/*N*/ 
/*N*/ 	EditMode eNewEditMode = pView->GetViewShEditMode(ePageKind);
/*N*/ 	BOOL bNewLayerMode = pView->IsLayerMode();
/*N*/ 	ChangeEditMode(eNewEditMode, bNewLayerMode);
/*N*/ 	SwitchPage(nSelectedPage);
/*N*/ 
/*N*/ 	// DrawMode fuer 'Normales' Fenster wiederherstellen
/*N*/ 	if(pWindow->GetDrawMode() != pView->GetDrawMode())
/*?*/ 	  pWindow->SetDrawMode(pView->GetDrawMode());

/*N*/ 	if ( pDrView->IsDesignMode() != pView->IsDesignMode() )
/*N*/ 	{
/*?*/ 		SfxBoolItem aDesignModeItem( SID_FM_DESIGN_MODE, pView->IsDesignMode() );
/*?*/ 		GetViewFrame()->GetDispatcher()->Execute( SID_FM_DESIGN_MODE, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD, &aDesignModeItem, 0L );
/*N*/ 	}

	// Muss am Ende gerufen werden, da ein WriteFrameViewData() ausgeloest wird
/*N*/ 	if (pDrView->IsFrameDragSingles() != pView->IsFrameDragSingles() )
/*N*/  		pDrView->SetFrameDragSingles( pView->IsFrameDragSingles() );
/*N*/ 
/*N*/ 	pDoc->SetChanged( bChanged );
/*N*/ }

/*************************************************************************
|*
|* Daten der aktuellen View auf die FrameView uebertragen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::WriteFrameViewData()
/*N*/ {
/*N*/ 	// Zeichen-(Bildschirm-)Attribute an FrameView merken
/*N*/ 	pFrameView->SetRuler( HasRuler() );
/*N*/ 	pFrameView->SetGridCoarse( pDrView->GetGridCoarse() );
/*N*/ 	pFrameView->SetGridFine( pDrView->GetGridFine() );
/*N*/ 	pFrameView->SetSnapGrid( pDrView->GetSnapGrid() );
/*N*/ 	pFrameView->SetSnapGridWidth(pDrView->GetSnapGridWidthX(), pDrView->GetSnapGridWidthY());
/*N*/ 	pFrameView->SetGridVisible( pDrView->IsGridVisible() );
/*N*/ 	pFrameView->SetGridFront( pDrView->IsGridFront() );
/*N*/ 	pFrameView->SetSnapAngle( pDrView->GetSnapAngle() );
/*N*/ 	pFrameView->SetGridSnap( pDrView->IsGridSnap() );
/*N*/ 	pFrameView->SetBordSnap( pDrView->IsBordSnap() );
/*N*/ 	pFrameView->SetHlplSnap( pDrView->IsHlplSnap() );
/*N*/ 	pFrameView->SetOFrmSnap( pDrView->IsOFrmSnap() );
/*N*/ 	pFrameView->SetOPntSnap( pDrView->IsOPntSnap() );
/*N*/ 	pFrameView->SetOConSnap( pDrView->IsOConSnap() );
/*N*/ 	pFrameView->SetHlplVisible( pDrView->IsHlplVisible() );
/*N*/ 	pFrameView->SetDragStripes( pDrView->IsDragStripes() );
/*N*/ 	pFrameView->SetPlusHandlesAlwaysVisible( pDrView->IsPlusHandlesAlwaysVisible() );
/*N*/ 	pFrameView->SetFrameDragSingles( pDrView->IsFrameDragSingles() );
/*N*/ 	pFrameView->SetMarkedHitMovesAlways( pDrView->IsMarkedHitMovesAlways() );
/*N*/ 	pFrameView->SetMoveOnlyDragging( pDrView->IsMoveOnlyDragging() );
/*N*/ 	pFrameView->SetNoDragXorPolys( pDrView->IsNoDragXorPolys() );
/*N*/ 	pFrameView->SetCrookNoContortion( pDrView->IsCrookNoContortion() );
/*N*/ 	pFrameView->SetBigOrtho( pDrView->IsBigOrtho() );
/*N*/ 	pFrameView->SetEliminatePolyPointLimitAngle( pDrView->GetEliminatePolyPointLimitAngle() );
/*N*/ 	pFrameView->SetEliminatePolyPoints( pDrView->IsEliminatePolyPoints() );
/*N*/ 
/*N*/ 	pFrameView->SetLineDraft( pDrView->IsLineDraft() );
/*N*/ 	pFrameView->SetFillDraft( pDrView->IsFillDraft() );
/*N*/ 	pFrameView->SetTextDraft( pDrView->IsTextDraft() );
/*N*/ 	pFrameView->SetGrafDraft( pDrView->IsGrafDraft() );
/*N*/ 	pFrameView->SetSolidMarkHdl( pDrView->IsSolidMarkHdl() );
/*N*/ 	pFrameView->SetSolidDragging( pDrView->IsSolidDragging() );
/*N*/ 	pFrameView->SetQuickEdit( pDrView->IsQuickTextEditMode() );
/*N*/ 
/*N*/ 	pFrameView->SetDesignMode( pDrView->IsDesignMode() );
/*N*/ 
/*N*/ 	Size aVisSizePixel = pWindow->GetOutputSizePixel();
/*N*/ 	Rectangle aVisArea = pWindow->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
/*N*/ 	pFrameView->SetVisArea(aVisArea);
/*N*/ 
/*N*/ 	if( ePageKind == PK_HANDOUT )
/*N*/  		pFrameView->SetSelectedPage(0);
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if( !ISA( SdPresViewShell ) )
/*N*/ 		{
/*N*/ 			if( pFuSlideShow && ( pFuSlideShow->GetAnimationMode() == ANIMATIONMODE_SHOW ) )
/*?*/     		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	pFrameView->SetSelectedPage( pFuSlideShow->GetCurrentPage() );
/*N*/ 			else 
/*N*/     			pFrameView->SetSelectedPage( aTabControl.GetCurPageId() - 1 );
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	pFrameView->SetViewShEditMode(eEditMode, ePageKind);
/*N*/ 	pFrameView->SetLayerMode(bLayerMode);
/*N*/ 
/*N*/ 	SdrPageView* pPageView = pDrView->GetPageViewPvNum(0);
/*N*/ 
/*N*/ 	if (pPageView)
/*N*/ 	{
/*N*/ 		if ( pFrameView->GetVisibleLayers() != pPageView->GetVisibleLayers() )
/*?*/ 			pFrameView->SetVisibleLayers( pPageView->GetVisibleLayers() );

/*N*/ 		if ( pFrameView->GetPrintableLayers() != pPageView->GetPrintableLayers() )
/*?*/ 			pFrameView->SetPrintableLayers( pPageView->GetPrintableLayers() );

/*N*/ 		if ( pFrameView->GetLockedLayers() != pPageView->GetLockedLayers() )
/*?*/ 			pFrameView->SetLockedLayers( pPageView->GetLockedLayers() );

/*N*/ 		if (ePageKind == PK_NOTES)
/*N*/ 		{
/*?*/ 			pFrameView->SetNotesHelpLines( pPageView->GetHelpLines() );
/*?*/ 		}
/*N*/ 		else if (ePageKind == PK_HANDOUT)
/*N*/ 		{
/*?*/ 			pFrameView->SetHandoutHelpLines( pPageView->GetHelpLines() );
/*?*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			pFrameView->SetStandardHelpLines( pPageView->GetHelpLines() );
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pFrameView->GetActiveLayer() != pDrView->GetActiveLayer() )
/*?*/ 		pFrameView->SetActiveLayer( pDrView->GetActiveLayer() );

	// DrawMode fuer 'Normales' Fenster merken
/*N*/ 	if(pFrameView->GetDrawMode() != pWindow->GetDrawMode())
/*?*/ 	  pFrameView->SetDrawMode(pWindow->GetDrawMode());

    // remember tabcontrol extent as percentage of whole frame width
/*N*/     const Size aFrameSize( GetViewFrame()->GetWindow().GetOutputSizePixel() );
/*N*/ 
/*N*/     if( aFrameSize.Width() )
/*N*/         pFrameView->SetTabCtrlPercent( (double) aTabControl.GetSizePixel().Width() / aFrameSize.Width() );
/*N*/     else
/*N*/         pFrameView->SetTabCtrlPercent( 0.0 );
/*N*/ }



/*************************************************************************
|*
|* Paint-Methode: das Ereignis wird vom Fenster pWin an
|* die Viewshell und die aktuelle Funktion weitergeleitet
|*
|* Anmerkung: pWin==NULL, wenn Paint() vom ShowWindow gerufen wird!
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::Paint(const Rectangle& rRect, SdWindow* pWin)
//STRIP001 {
//STRIP001 	// #103834# Fill var FillColor here to have it available on later call
//STRIP001     svtools::ColorConfig aColorConfig;
//STRIP001 	Color aFillColor;
//STRIP001 
//STRIP001     if(DOCUMENT_TYPE_IMPRESS == pDoc->GetDocumentType())
//STRIP001 	{
//STRIP001         aFillColor = Color( aColorConfig.GetColorValue( svtools::APPBACKGROUND ).nColor );
//STRIP001 	}
//STRIP001     else
//STRIP001 	{
//STRIP001         aFillColor = Color( aColorConfig.GetColorValue( svtools::DOCCOLOR ).nColor );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pWin )
//STRIP001 	{
//STRIP001 		if( !pFuSlideShow || pWin != (SdWindow*) pFuSlideShow->GetShowWindow() )
//STRIP001 		{
//STRIP001             const SdrPageView*  pPageView = pDrView->GetPageViewPvNum( 0 );
//STRIP001 			const Color         aOldLineColor( pWin->GetLineColor() );
//STRIP001 			const Color         aOldFillColor( pWin->GetFillColor() );
//STRIP001 			const ULONG         nOldDrawMode( pWin->GetDrawMode() );
//STRIP001             const BOOL          bOldMap = pWin->IsMapModeEnabled();
//STRIP001             Point               aNullPoint;
//STRIP001             const Rectangle     aOutputRect( aNullPoint, pWin->GetOutputSizePixel() );
//STRIP001 	        Rectangle           aOutputPaperRect, aPaperRect;
//STRIP001 
//STRIP001             if( pPageView )
//STRIP001                 aPaperRect = pPageView->GetPageRect();
//STRIP001             else
//STRIP001                 aPaperRect = Rectangle( aNullPoint, pActualPage->GetSize() );
//STRIP001 
//STRIP001             ( aOutputPaperRect = aPaperRect = pWin->LogicToPixel( aPaperRect ) ).Intersection( aOutputRect );
//STRIP001             
//STRIP001             pWin->EnableMapMode( FALSE );
//STRIP001 			pWin->SetDrawMode( DRAWMODE_DEFAULT );
//STRIP001 			pWin->SetLineColor();
//STRIP001 			pWin->SetFillColor( aFillColor );
//STRIP001 
//STRIP001             if( aOutputPaperRect.IsEmpty() )
//STRIP001                 pWin->DrawRect( aOutputRect );
//STRIP001             else
//STRIP001             {
//STRIP001                 const Color aShadowColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001                 PolyPolygon aPolyPoly( 2 );
//STRIP001                 Rectangle   aOutputRectExt( aOutputRect );
//STRIP001 
//STRIP001                 aOutputRectExt.Left()--;
//STRIP001                 aOutputRectExt.Top()--;
//STRIP001                 aOutputRectExt.Right()++;
//STRIP001                 aOutputRectExt.Bottom()++;
//STRIP001 
//STRIP001                 aPolyPoly.Insert( aOutputRectExt );
//STRIP001                 aPolyPoly.Insert( aOutputPaperRect );
//STRIP001 
//STRIP001 			    // draw paper
//STRIP001                 pWin->DrawPolyPolygon( aPolyPoly );
//STRIP001 
//STRIP001                  // draw shadow
//STRIP001                 pWin->SetFillColor( aShadowColor );
//STRIP001                 pWin->DrawRect( Rectangle( Point( aPaperRect.Right() + 1, aPaperRect.Top() + PAPER_SHADOW_EXT_PIXEL ),
//STRIP001                                            Size( PAPER_SHADOW_EXT_PIXEL, aPaperRect.GetHeight() ) ) );
//STRIP001                 pWin->DrawRect( Rectangle( Point( aPaperRect.Left() + PAPER_SHADOW_EXT_PIXEL, aPaperRect.Bottom() + 1 ),
//STRIP001                                            Size( aPaperRect.GetWidth(), PAPER_SHADOW_EXT_PIXEL ) ) );
//STRIP001             }
//STRIP001 
//STRIP001 			pWin->SetFillColor( aOldFillColor );
//STRIP001 			pWin->SetLineColor( aOldLineColor );
//STRIP001 			pWin->SetDrawMode( nOldDrawMode );
//STRIP001             pWin->EnableMapMode( bOldMap );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	/* #97517#	This is done before each text edit, so why not do it before every paint.
//STRIP001 				The default language is only used if the outliner only contains one
//STRIP001 				character in a symbol font */
//STRIP001 	pDoc->GetDrawOutliner( NULL ).SetDefaultLanguage( pDoc->GetLanguage( EE_CHAR_LANGUAGE ) );
//STRIP001 
//STRIP001 	// #103834# Set Application Background color for usage in SdrPaintView(s)
//STRIP001 	pDrView->SetApplicationBackgroundColor(aFillColor);
//STRIP001 
//STRIP001 	/* #97517#	This is done before each text edit, so why not do it before every paint.
//STRIP001 				The default language is only used if the outliner only contains one
//STRIP001 				character in a symbol font */
//STRIP001 	pDoc->GetDrawOutliner( NULL ).SetDefaultLanguage( Application::GetSettings().GetLanguage() );
//STRIP001 
//STRIP001 	pDrView->InitRedraw( pWin, Region( rRect ) );
//STRIP001 
//STRIP001 	if( pWin )
//STRIP001 	{
//STRIP001 		if( pDocSh->GetActualFunction() )
//STRIP001 			pDocSh->GetActualFunction()->Paint( rRect, pWin );
//STRIP001 
//STRIP001 		if( pFuActual ) 
//STRIP001 			pFuActual->Paint( rRect, pWin );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Zoom-Faktor fuer InPlace einstellen
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::SetZoomFactor(const Fraction& rZoomX, const Fraction& rZoomY)
//STRIP001 {
//STRIP001 	SdViewShell::SetZoomFactor(rZoomX, rZoomY);
//STRIP001 	bZoomOnPage = FALSE;
//STRIP001 	Point aOrigin = pWindow->GetViewOrigin();
//STRIP001 	pWindow->SetWinViewPos(aOrigin);
//STRIP001 }

/*************************************************************************
|*
|* Optimale Groesse zurueckgeben
|*
\************************************************************************/

//STRIP001 Size SdDrawViewShell::GetOptimalSizePixel() const
//STRIP001 {
//STRIP001 	Size aSize;
//STRIP001 
//STRIP001 	SdrPageView* pPV = pDrView->GetPageViewPvNum(0);
//STRIP001 
//STRIP001 	if (pPV)
//STRIP001 	{
//STRIP001 		SdPage* pPage = (SdPage*) pPV->GetPage();
//STRIP001 
//STRIP001 		if (pPage)
//STRIP001 		{
//STRIP001 			if (!bZoomOnPage)
//STRIP001 			{
//STRIP001 				// Gegenwaertigen MapMode beruecksichtigen
//STRIP001 				aSize = pWindow->LogicToPixel( pPage->GetSize() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// 1:1 Darstellung
//STRIP001 				MapMode aMapMode(MAP_100TH_MM);
//STRIP001 				aSize = pWindow->LogicToPixel( pPage->GetSize(), aMapMode );
//STRIP001 				( (SdDrawViewShell*) this)->bZoomOnPage = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return(aSize);
//STRIP001 }


/*************************************************************************
|*
|* Seite wird gehided
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::HidePage(SdrPageView* pPV)
/*N*/ {
/*N*/ 	FmFormShell* pShell = (FmFormShell*) aShellTable.Get(RID_FORMLAYER_TOOLBOX);
/*N*/ 
/*N*/ 	if (pShell)
/*N*/ 		pShell->PrepareClose(FALSE);
/*N*/ }



/*N*/ void SdDrawViewShell::WriteUserDataSequence ( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rSequence, sal_Bool bBrowse )
/*N*/ {
/*N*/ 	WriteFrameViewData();
/*N*/ 
/*N*/ 	SdViewShell::WriteUserDataSequence( rSequence, bBrowse );
/*N*/ 
/*N*/ 	const sal_Int32 nIndex = rSequence.getLength();
/*N*/ 	rSequence.realloc( nIndex + 1 );
/*N*/ 	rSequence[nIndex].Name = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sUNO_View_ZoomOnPage ) );
/*N*/ 	rSequence[nIndex].Value <<= (sal_Bool)bZoomOnPage;
/*N*/ }

//STRIP001 void SdDrawViewShell::ReadUserDataSequence ( const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rSequence, sal_Bool bBrowse )
//STRIP001 {
//STRIP001 	WriteFrameViewData();
//STRIP001 
//STRIP001 	SdViewShell::ReadUserDataSequence( rSequence, bBrowse );
//STRIP001 
//STRIP001 	const sal_Int32 nLength = rSequence.getLength();
//STRIP001     const ::com::sun::star::beans::PropertyValue *pValue = rSequence.getConstArray();
//STRIP001     for (sal_Int16 i = 0 ; i < nLength; i++, pValue++ )
//STRIP001     {
//STRIP001         if (pValue->Name.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( sUNO_View_ZoomOnPage ) ) )
//STRIP001 		{
//STRIP001 			sal_Bool bZoomPage;
//STRIP001 			if( pValue->Value >>= bZoomPage )
//STRIP001 			{
//STRIP001 				bZoomOnPage = bZoomPage;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pFrameView->GetPageKind() != ePageKind )
//STRIP001 	{
//STRIP001 		ePageKind = pFrameView->GetPageKind();
//STRIP001 
//STRIP001 		if (ePageKind == PK_NOTES)
//STRIP001 		{
//STRIP001 			// SdDrawViewShell buttons
//STRIP001 			aLayerBtn.Disable();
//STRIP001 
//STRIP001 			// SdViewShell buttons
//STRIP001 			aDrawBtn.Check(FALSE);
//STRIP001 			aOutlineBtn.Check(FALSE);
//STRIP001 			aSlideBtn.Check(FALSE);
//STRIP001 			aHandoutBtn.Check(FALSE);
//STRIP001 			aPresentationBtn.Check(FALSE);
//STRIP001 			aNotesBtn.Check(TRUE);
//STRIP001 
//STRIP001 			SetHelpId( SID_NOTESMODE );
//STRIP001 			pWindow->SetHelpId( SID_NOTESMODE );
//STRIP001 			pWindow->SetUniqueId( SID_NOTESMODE );
//STRIP001 		}
//STRIP001 		else if (ePageKind == PK_HANDOUT)
//STRIP001 		{
//STRIP001 			// SdDrawViewShell buttons
//STRIP001 			aPageBtn.Disable();
//STRIP001 			aLayerBtn.Disable();
//STRIP001 
//STRIP001 			// SdViewShell buttons
//STRIP001 			aDrawBtn.Check(FALSE);
//STRIP001 			aOutlineBtn.Check(FALSE);
//STRIP001 			aSlideBtn.Check(FALSE);
//STRIP001 			aPresentationBtn.Check(FALSE);
//STRIP001 			aNotesBtn.Check(FALSE);
//STRIP001 			aHandoutBtn.Check(TRUE);
//STRIP001 
//STRIP001 			SetHelpId( SID_HANDOUTMODE );
//STRIP001 			pWindow->SetHelpId( SID_HANDOUTMODE );
//STRIP001 			pWindow->SetUniqueId( SID_HANDOUTMODE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// SdViewShell buttons
//STRIP001 			aOutlineBtn.Check(FALSE);
//STRIP001 			aSlideBtn.Check(FALSE);
//STRIP001 			aPresentationBtn.Check(FALSE);
//STRIP001 			aNotesBtn.Check(FALSE);
//STRIP001 			aHandoutBtn.Check(FALSE);
//STRIP001 			aDrawBtn.Check(TRUE);
//STRIP001 
//STRIP001 			SetHelpId( SD_IF_SDDRAWVIEWSHELL );
//STRIP001 			pWindow->SetHelpId( SD_IF_SDDRAWVIEWSHELL );
//STRIP001 			pWindow->SetUniqueId( SD_IF_SDDRAWVIEWSHELL );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ReadFrameViewData( pFrameView );
//STRIP001 
//STRIP001 	if( !bZoomOnPage )
//STRIP001 	{
//STRIP001 		const Rectangle aVisArea( pFrameView->GetVisArea() );
//STRIP001 
//STRIP001 		if ( pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
//STRIP001 		{
//STRIP001 			pDocSh->SetVisArea(aVisArea);
//STRIP001 		}
//STRIP001 
//STRIP001 		VisAreaChanged(aVisArea);
//STRIP001 
//STRIP001 		SdView* pView = GetView();
//STRIP001 
//STRIP001 		if (pView)
//STRIP001 		{
//STRIP001 			pView->VisAreaChanged(pWindow);
//STRIP001 		}
//STRIP001 
//STRIP001 		SetZoomRect(aVisArea);
//STRIP001 	}
//STRIP001 
//STRIP001 	ChangeEditMode( eEditMode, !bLayerMode );
//STRIP001 	ChangeEditMode( eEditMode, !bLayerMode );
//STRIP001 
//STRIP001 }

/*N*/ void SdDrawViewShell::VisAreaChanged(const Rectangle& rRect)
/*N*/ {
/*N*/ 	SdViewShell::VisAreaChanged( rRect );
/*N*/ 
/*N*/ 	if( pController )
/*N*/ 	{
/*N*/ 		pController->fireVisAreaChanged( rRect );
/*N*/ 	}
/*N*/ }




/** If there is a valid controller then create a new instance of
    <type>AccessibleDrawDocumentView</type>.  Otherwise delegate this call
    to the base class to return a default object (probably an empty
    reference).
*/
//STRIP001 ::com::sun::star::uno::Reference<
//STRIP001     ::com::sun::star::accessibility::XAccessible>
//STRIP001     SdDrawViewShell::CreateAccessibleDocumentView (SdWindow* pWindow)
//STRIP001 {
//STRIP001     if (GetController() != NULL)
//STRIP001     {
//STRIP001         accessibility::AccessibleDrawDocumentView* pDocumentView =
//STRIP001             new accessibility::AccessibleDrawDocumentView (
//STRIP001                 pWindow,
//STRIP001                 this,
//STRIP001                 GetController(),
//STRIP001                 pWindow->GetAccessibleParentWindow()->GetAccessible());
//STRIP001         pDocumentView->Init();
//STRIP001         return ::com::sun::star::uno::Reference<
//STRIP001             ::com::sun::star::accessibility::XAccessible>
//STRIP001             (static_cast< ::com::sun::star::uno::XWeak*>(pDocumentView),
//STRIP001                 ::com::sun::star::uno::UNO_QUERY);
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         OSL_TRACE ("SdDrawViewShell::CreateAccessibleDocumentView: no controller");
//STRIP001         return SdViewShell::CreateAccessibleDocumentView (pWindow);
//STRIP001     }
//STRIP001 }




/*?*/ int SdDrawViewShell::GetTabLayerCount (void) const
/*?*/ {
/*?*/ {DBG_BF_ASSERT(0, "STRIP");} return 0;//STRIP001     return aLayerTab.GetPageCount();
//STRIP001 
/*?*/ }




/*?*/ int SdDrawViewShell::GetActiveTabLayerIndex (void) const
/*?*/ {
/*?*/ {DBG_BF_ASSERT(0, "STRIP");} return 0;//STRIP001 /*?*/     return aLayerTab.GetPagePos (aLayerTab.GetCurPageId());
/*?*/ }
    



/*?*/ void SdDrawViewShell::SetActiveTabLayerIndex (int nIndex)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/     // Ignore invalid indices silently.
//STRIP001 /*?*/     if (nIndex>=0 && nIndex<aLayerTab.GetPageCount())
//STRIP001 /*?*/     {
//STRIP001         // Tell the draw view and the tab control of the new active layer.
//STRIP001         pDrView->SetActiveLayer (aLayerTab.GetPageText (aLayerTab.GetPageId (nIndex)));
//STRIP001         aLayerTab.SetCurPageId (aLayerTab.GetPageId (nIndex));
//STRIP001    }
/*?*/ }




//STRIP001 SdTabControl* SdDrawViewShell::GetPageTabControl (void)
//STRIP001 {
//STRIP001     return &aTabControl;
//STRIP001 }




//STRIP001 SdLayerTab* SdDrawViewShell::GetLayerTabControl (void)
//STRIP001 {
//STRIP001     return &aLayerTab;
//STRIP001 }
}
