/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviews8.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:37:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _TOOLKIT_HELPER_VCLUNOHELPER_HXX_
// auto strip #include <toolkit/unohlp.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
#ifndef _SVXIDS_HXX
#include <bf_svx/svxids.hrc>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
// auto strip #ifndef _SVDDEF_HXX //autogen
// auto strip #include <bf_svx/svddef.hxx>
// auto strip #endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <bf_sfx2/bindings.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <bf_sfx2/viewfrm.hxx>
#endif
// auto strip #ifndef _SVDOGRAF_HXX //autogen
// auto strip #include <bf_svx/svdograf.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif

#pragma hdrstop

#include "app.hrc"
#include "strings.hrc"

// auto strip #include "misc.hxx"
// auto strip #include "fuzoom.hxx"
// auto strip #include "fudspord.hxx"
// auto strip #include "fuslprms.hxx"
// auto strip #include "futransf.hxx"
// auto strip #include "fuline.hxx"
// auto strip #include "fuarea.hxx"
// auto strip #include "fuchar.hxx"
// auto strip #include "fuparagr.hxx"
// auto strip #include "fubullet.hxx"
// auto strip #include "futempl.hxx"
// auto strip #include "fuinsert.hxx"
// auto strip #include "fuprlout.hxx"
// auto strip #include "fuprtmpl.hxx"
// auto strip #include "fupage.hxx"
// auto strip #include "fuoaprms.hxx"
#include "sdresid.hxx"
// auto strip #include "fucopy.hxx"
// auto strip #include "fulinend.hxx"
// auto strip #include "fusnapln.hxx"
// auto strip #include "fuolbull.hxx"
// auto strip #include "fuinsfil.hxx"
// auto strip #include "fulink.hxx"
// auto strip #include "futhes.hxx"
// auto strip #include "futxtatt.hxx"
// auto strip #include "fumeasur.hxx"
// auto strip #include "fuconnct.hxx"
// auto strip #include "fumorph.hxx"
// auto strip #include "fuvect.hxx"
#include "sdwindow.hxx"
// auto strip #include "drawview.hxx"
#include "drviewsh.hxx"
// auto strip #include "zoomlist.hxx"
// auto strip #include "drawview.hxx"
namespace binfilter {



/*************************************************************************
|*
|* SfxRequests fuer temporaere Funktionen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::FuTemp01(SfxRequest& rReq)
/*N*/ {
/*N*/ 	switch(rReq.GetSlot())
/*N*/ 	{
/*?*/ 		case SID_ATTRIBUTES_LINE:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuLine( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ATTRIBUTES_AREA:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_ASSERT(0,"STRIP!"); //STRIP001 pFuActual = new FuArea( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ATTR_TRANSFORM:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuTransform( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Invalidate(SID_RULER_OBJECT);
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CHAR_DLG:	// BASIC
/*?*/ 		{
/*?*/ 			DBG_ASSERT(0, "STRIP!"); //STRIP001 pFuActual = new FuChar( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_PARA_DLG:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuParagraph( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OUTLINE_BULLET:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuOutlineBullet( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_BULLET:
/*?*/ 		{
/*?*/ 			DBG_ASSERT(0, "STRIP!"); //STRIP001 pFuActual = new FuBullet( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_PRESENTATION_LAYOUT:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuPresentationLayout(this, pWindow, pDrView, pDoc, rReq);
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ //        case SID_MODEL:
/*?*/ //        {
/*?*/ //            pFuActual = new FuTemplate( this, pWindow, pDrView, pDoc, rReq );
/*?*/ //            Cancel();
/*?*/ //        }
/*?*/ //        break;
/*?*/ 
/*?*/ 		case SID_PASTE2:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuInsertClipboard( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_INSERT_GRAPHIC:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuInsertGraphic( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Invalidate(SID_DRAWTBX_INSERT);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_INSERT_OBJECT:
/*?*/ 		case SID_INSERT_PLUGIN:
/*?*/ 		case SID_INSERT_SOUND:
/*?*/ 		case SID_INSERT_VIDEO:
/*?*/ 		case SID_INSERT_APPLET:
/*?*/ 		case SID_INSERT_FLOATINGFRAME:
/*?*/ #ifdef STARIMAGE_AVAILABLE
/*?*/ 		case SID_INSERT_IMAGE:
/*?*/ #endif
/*?*/ 		case SID_INSERT_MATH:
/*?*/ 		case SID_INSERT_DIAGRAM:
/*?*/ 		case SID_ATTR_TABLE:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuInsertOLE( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Invalidate(SID_DRAWTBX_INSERT);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_COPYOBJECTS:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsPresObjSelected(FALSE, TRUE) )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if ( pDrView->IsTextEdit() )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pDrView->EndTextEdit();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pFuActual = new FuCopy( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_INSERTFILE:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuInsertFile( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Invalidate(SID_DRAWTBX_INSERT);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_PAGESETUP:  // BASIC ??
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuPage( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore (); // es werden eigenstaendige macros generiert !!
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ZOOM_OUT:
/*?*/ 		case SID_ZOOM_PANNING:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 bZoomOnPage = FALSE;
//STRIP001 /*?*/ 			pFuActual = new FuZoom(this, pWindow, pDrView, pDoc, rReq);
//STRIP001 /*?*/ 			// Beendet sich selbst, kein Cancel() notwendig!
//STRIP001 /*?*/ 			Invalidate( SID_ZOOM_TOOLBOX );
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_BEFORE_OBJ:
/*?*/ 		case SID_BEHIND_OBJ:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuDisplayOrder(this, pWindow, pDrView, pDoc, rReq);
//STRIP001 /*?*/ 			Invalidate( SID_POSITION );
//STRIP001 /*?*/ 			rReq.Ignore ();
//STRIP001 /*?*/ 			// Beendet sich selbst, kein Cancel() notwendig!
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_REVERSE_ORDER:   // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->ReverseOrderOfMarked();
//STRIP001 /*?*/ 			Invalidate( SID_POSITION );
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DIA:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual =new FuSlideParameters( this, pWindow, pDrView, pDoc, rReq);
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ANIMATION_EFFECTS:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual =new FuObjectAnimationParameters( this, pWindow, pDrView, pDoc, rReq);
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_LINEEND_POLYGON:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuLineEnd( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CAPTUREPOINT:
/*?*/ 			// negative Werte um Aufruf aus Menue zu signalisieren
/*?*/ 			aMousePos = Point(-1,-1);
/*?*/ 		case SID_SET_SNAPITEM:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuSnapLine(this, pWindow, pDrView, pDoc, rReq);
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_MANAGE_LINKS:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuLink( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_THESAURUS:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuThesaurus( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_TEXTATTR_DLG:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuTextAttrDlg( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_MEASURE_DLG:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuMeasureDlg( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CONNECTION_DLG:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuConnectionDlg( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CONNECTION_NEW_ROUTING:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxItemSet aDefAttr( GetPool(), SDRATTR_EDGELINE1DELTA, SDRATTR_EDGELINE3DELTA );
//STRIP001 /*?*/ 			pView->SetAttributes( aDefAttr, TRUE ); // (ReplaceAll)
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_TWAIN_SELECT:
/*?*/ 		{
/*?*/ 			BOOL bDone = FALSE;
/*?*/ 
/*?*/ 			if( mxScannerManager.is() )
/*?*/ 			{
/*?*/ 				try
/*?*/ 				{
/*?*/ 					const ::com::sun::star::uno::Sequence< ::com::sun::star::scanner::ScannerContext >
/*?*/ 						aContexts( mxScannerManager->getAvailableScanners() );
/*?*/ 
/*?*/ 					if( aContexts.getLength() )
/*?*/ 					{
/*?*/ 						::com::sun::star::scanner::ScannerContext aContext( aContexts.getConstArray()[ 0 ] );
/*?*/ 						bDone = mxScannerManager->configureScanner( aContext );
/*?*/ 					}
/*?*/ 				}
/*?*/ 				catch(...)
/*?*/ 				{
/*?*/                 }
/*?*/ 			}
/*?*/ 
/*?*/             Cancel();
/*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_TWAIN_TRANSFER:
/*?*/ 		{
/*?*/ 			BOOL bDone = FALSE;
/*?*/ 
/*?*/ 			if( mxScannerManager.is() )
/*?*/ 			{
/*?*/ 				try
/*?*/ 				{
/*?*/ 					const ::com::sun::star::uno::Sequence< ::com::sun::star::scanner::ScannerContext > aContexts( mxScannerManager->getAvailableScanners() );
/*?*/ 
/*?*/ 					if( aContexts.getLength() )
/*?*/ 					{
/*?*/ 						mxScannerManager->startScan( aContexts.getConstArray()[ 0 ], mxScannerListener );
/*?*/ 						bDone = TRUE;
/*?*/ 					}
/*?*/ 				}
/*?*/ 				catch( ... )
/*?*/ 				{
/*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			if( !bDone )
/*?*/ 			{
/*?*/ #ifndef UNX
/*?*/ 				const USHORT nId = STR_TWAIN_NO_SOURCE;
/*?*/ #else
/*?*/ 				const USHORT nId = STR_TWAIN_NO_SOURCE_UNX;
/*?*/ #endif
/*?*/ 
/*?*/ 				InfoBox( pWindow, String( SdResId( nId ) ) ).Execute();
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				SfxBindings& rBindings = GetViewFrame()->GetBindings();
/*?*/ 				rBindings.Invalidate( SID_TWAIN_SELECT );
/*?*/ 				rBindings.Invalidate( SID_TWAIN_TRANSFER );
/*?*/ 			}
/*?*/ 
/*?*/             Cancel();
/*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_POLYGON_MORPHING:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuMorph( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_VECTORIZE:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuVectorize( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*N*/ 		default:
/*N*/ 		{
/*N*/ 			// switch Anweisung wegen CLOOKS aufgeteilt. Alle case-Anweisungen die
/*N*/ 			// eine Fu???? -Funktion aufrufen, sind in die Methode FuTemp01 (drviews8),
/*N*/ 			// FuTemp02 (drviewsb) gewandert.
/*N*/ 			FuTemp02(rReq);
/*N*/ 		}
/*N*/ 		break;
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Scanner-Event
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::ScannerEvent( const ::com::sun::star::lang::EventObject& rEventObject )
//STRIP001 {
//STRIP001 	if( mxScannerManager.is() )
//STRIP001 	{
//STRIP001 		const ::com::sun::star::scanner::ScannerContext	aContext( mxScannerManager->getAvailableScanners().getConstArray()[ 0 ] );
//STRIP001 		const ::com::sun::star::scanner::ScanError		eError = mxScannerManager->getError( aContext );
//STRIP001 
//STRIP001 		if( ::com::sun::star::scanner::ScanError_ScanErrorNone == eError )
//STRIP001 		{
//STRIP001 			const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XBitmap > xBitmap( mxScannerManager->getBitmap( aContext ) );
//STRIP001 
//STRIP001 			if( xBitmap.is() )
//STRIP001 			{
//STRIP001 				const BitmapEx aScanBmp( VCLUnoHelper::GetBitmap( xBitmap ) );
//STRIP001 
//STRIP001 				if( !!aScanBmp )
//STRIP001 				{
//STRIP001                     const ::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 		            SdrPage*            pPage = pDrView->GetPageViewPvNum( 0 )->GetPage();
//STRIP001             		Size                aBmpSize( aScanBmp.GetPrefSize() ), aPageSize( pPage->GetSize() );
//STRIP001                     const MapMode       aMap100( MAP_100TH_MM );
//STRIP001 
//STRIP001 		            if( !aBmpSize.Width() || !aBmpSize.Height() )
//STRIP001 			            aBmpSize = aScanBmp.GetSizePixel();
//STRIP001 
//STRIP001 		            if( aScanBmp.GetPrefMapMode().GetMapUnit() == MAP_PIXEL )
//STRIP001 			            aBmpSize = pWindow->PixelToLogic( aBmpSize, aMap100 );
//STRIP001 		            else
//STRIP001 			            aBmpSize = OutputDevice::LogicToLogic( aBmpSize, aScanBmp.GetPrefMapMode(), aMap100 );
//STRIP001 
//STRIP001                     aPageSize.Width() -= pPage->GetLftBorder() + pPage->GetRgtBorder();
//STRIP001 		            aPageSize.Height() -= pPage->GetUppBorder() + pPage->GetLwrBorder();
//STRIP001 
//STRIP001 		            if( ( aBmpSize.Height() > aPageSize.Height() ) || ( aBmpSize.Width()	> aPageSize.Width() ) && aBmpSize.Height() && aPageSize.Height() )
//STRIP001 		            {
//STRIP001 			            double fGrfWH = (double) aBmpSize.Width() / aBmpSize.Height();
//STRIP001 			            double fWinWH = (double) aPageSize.Width() / aPageSize.Height();
//STRIP001 
//STRIP001 			            if( fGrfWH < fWinWH )
//STRIP001 			            {
//STRIP001 				            aBmpSize.Width() = FRound( aPageSize.Height() * fGrfWH );
//STRIP001 				            aBmpSize.Height()= aPageSize.Height();
//STRIP001 			            }
//STRIP001 			            else if( fGrfWH > 0.F )
//STRIP001 			            {
//STRIP001 				            aBmpSize.Width() = aPageSize.Width();
//STRIP001 				            aBmpSize.Height()= FRound( aPageSize.Width() / fGrfWH );
//STRIP001 			            }
//STRIP001 		            }
//STRIP001 
//STRIP001 		            Point aPnt ( ( aPageSize.Width() - aBmpSize.Width() ) >> 1, ( aPageSize.Height() - aBmpSize.Height() ) >> 1 );
//STRIP001                     aPnt += Point( pPage->GetLftBorder(), pPage->GetUppBorder() );
//STRIP001 		            Rectangle   aRect( aPnt, aBmpSize );
//STRIP001 		            SdrGrafObj* pGrafObj = NULL;
//STRIP001                     BOOL        bInsertNewObject = TRUE;
//STRIP001 
//STRIP001 		            if( pView->HasMarkedObj() )
//STRIP001 		            {
//STRIP001 			            const SdrMarkList& rMarkList = pDrView->GetMarkList();
//STRIP001 
//STRIP001 			            if( rMarkList.GetMarkCount() == 1 )
//STRIP001 			            {
//STRIP001 				            SdrMark*    pMark = rMarkList.GetMark(0);
//STRIP001 				            SdrObject*  pObj = pMark->GetObj();
//STRIP001 
//STRIP001 				            if( pObj->ISA( SdrGrafObj ) )
//STRIP001 				            {
//STRIP001 					            pGrafObj = static_cast< SdrGrafObj* >( pObj );
//STRIP001 
//STRIP001 					            if( pGrafObj->IsEmptyPresObj() )
//STRIP001 					            {
//STRIP001 						            bInsertNewObject = FALSE;
//STRIP001 						            pGrafObj->SetEmptyPresObj(FALSE);
//STRIP001 						            pGrafObj->SetOutlinerParaObject(NULL);
//STRIP001 						            pGrafObj->SetGraphic( Graphic( aScanBmp ) );
//STRIP001 					            }
//STRIP001 				            }
//STRIP001 			            }
//STRIP001 		            }
//STRIP001 
//STRIP001 		            if( bInsertNewObject )
//STRIP001 		            {
//STRIP001 			            pGrafObj = new SdrGrafObj( Graphic( aScanBmp ), aRect );
//STRIP001 			            SdrPageView* pPV = pView->GetPageViewPvNum(0);
//STRIP001 			            pView->InsertObject( pGrafObj, *pPV, SDRINSERT_SETDEFLAYER );
//STRIP001 		            }
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxBindings& rBindings = GetViewFrame()->GetBindings();
//STRIP001 	rBindings.Invalidate( SID_TWAIN_SELECT );
//STRIP001 	rBindings.Invalidate( SID_TWAIN_TRANSFER );
//STRIP001 }
}
