/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_accelcfg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:56:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// auto strip #ifndef _COM_SUN_STAR_UNO_ANY_HXX_
// auto strip #include <com/sun/star/uno/Any.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
// auto strip #include <com/sun/star/uno/Sequence.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
// auto strip #include <com/sun/star/io/XActiveDataSource.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
// auto strip #include <com/sun/star/io/XInputStream.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
// auto strip #include <com/sun/star/io/XOutputStream.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
// auto strip #include <com/sun/star/xml/sax/XParser.hpp>
// auto strip #endif
// auto strip #ifndef _UTL_CONFIGMGR_HXX_
// auto strip #include <unotools/configmgr.hxx>
// auto strip #endif
// auto strip #ifndef _UTL_CONFIGITEM_HXX_
// auto strip #include <unotools/configitem.hxx>
// auto strip #endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

// auto strip #include <osl/mutex.hxx>
// auto strip #include <tools/string.hxx>
#include <tools/urlobj.hxx>
// auto strip #include <unotools/streamwrap.hxx>
#include <unotools/ucbstreamhelper.hxx>
// auto strip #include <comphelper/processfactory.hxx>
#include <svtools/pathoptions.hxx>

// auto strip #include "accelcfg.hxx"
#include "xmlaccelcfg.hxx"
// auto strip #include "saxnamespacefilter.hxx"

// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
namespace binfilter {


using namespace utl;
using namespace rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::xml::sax;

/*?*/ class SfxAcceleratorConfig_Impl
/*?*/ {
/*?*/ public:
/*?*/ 
/*?*/     SfxAcceleratorItemList aList;
/*?*/ 	bool			bModified;
/*?*/ 
/*?*/                     SfxAcceleratorConfig_Impl()
/*?*/                         : bModified( FALSE )
/*?*/                     {}
/*?*/ };

// -----------------------------------------------------------------------

/*?*/ SfxAcceleratorConfiguration::SfxAcceleratorConfiguration()
/*?*/ {
/*?*/     pImp = new SfxAcceleratorConfig_Impl;
/*?*/ }

// -----------------------------------------------------------------------

/*?*/ SfxAcceleratorConfiguration::~SfxAcceleratorConfiguration()
/*?*/ {
/*?*/     if ( pImp->bModified )
/*?*/     {
/*?*/         String aUserConfig = SvtPathOptions().GetUserConfigPath();
/*?*/         INetURLObject aObj( aUserConfig );
/*?*/         aObj.insertName( String::CreateFromAscii("GlobalKeyBindings.xml") );
/*?*/         SvStream* pStream = ::utl::UcbStreamHelper::CreateStream( aObj.GetMainURL( INetURLObject::NO_DECODE ), STREAM_STD_READWRITE|STREAM_TRUNC );
/*?*/         Commit( *pStream );
/*?*/         delete pStream;
/*?*/     }
/*?*/ 
/*?*/     delete pImp;
/*?*/ }

/*?*/ bool SfxAcceleratorConfiguration::Load( SvStream& rStream )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE; //STRIP001 
//STRIP001 	bool bRet = true;
//STRIP001     ::utl::OInputStreamWrapper* pHelper = new ::utl::OInputStreamWrapper( rStream );
//STRIP001     ::com::sun::star::uno::Reference < ::com::sun::star::io::XInputStream > xInStream( pHelper );
//STRIP001     try
//STRIP001     {
//STRIP001 		Reference< XParser > xParser( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(
//STRIP001 										::rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Parser" )),
//STRIP001 								  	UNO_QUERY);
//STRIP001 
//STRIP001 		// connect stream to input stream to the parser
//STRIP001 		InputSource aInputSource;
//STRIP001 		aInputSource.aInputStream = xInStream;
//STRIP001 
//STRIP001 		// get filter
//STRIP001 		Reference< XDocumentHandler > xDocHandler( new OReadAcceleratorDocumentHandler( pImp->aList ) );
//STRIP001 		Reference< XDocumentHandler > xFilter( new SaxNamespaceFilter( xDocHandler ));
//STRIP001 
//STRIP001 		// connect parser and filter
//STRIP001 		xParser->setDocumentHandler( xFilter );
//STRIP001     	xParser->parseStream( aInputSource );
//STRIP001     }
//STRIP001     catch ( RuntimeException& )
//STRIP001     {
//STRIP001 		bRet = FALSE;
//STRIP001     }
//STRIP001     catch( SAXException& )
//STRIP001     {
//STRIP001 		bRet = FALSE;
//STRIP001     }
//STRIP001     catch( ::com::sun::star::io::IOException& )
//STRIP001     {
//STRIP001 		bRet = FALSE;
//STRIP001     }
//STRIP001 
//STRIP001 	return bRet;
/*?*/ }

/*?*/ const SfxAcceleratorItemList& SfxAcceleratorConfiguration::GetItems()
/*?*/ {
/*?*/ 	return pImp->aList;
/*?*/ }

/*?*/ void SfxAcceleratorConfiguration::SetCommand( const SfxAcceleratorConfigItem& rItem )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     std::vector< SfxAcceleratorConfigItem>::iterator p;
//STRIP001 	for ( p = pImp->aList.begin(); p != pImp->aList.end(); p++ )
//STRIP001         if ( p->nCode == rItem.nCode && p->nModifier == rItem.nModifier )
//STRIP001 		{
//STRIP001             p->aCommand = rItem.aCommand;
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001     pImp->aList.push_back( rItem );
/*?*/ 
/*?*/ }

/*?*/ void SfxAcceleratorConfiguration::SetItems( const SfxAcceleratorItemList& rItems, bool bClear )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( bClear )
//STRIP001 	{
//STRIP001 		pImp->aList = rItems;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001         std::vector< SfxAcceleratorConfigItem>::const_iterator p;
//STRIP001         for ( p = rItems.begin(); p != rItems.end(); ++p )
//STRIP001             SetCommand( *p );
//STRIP001 	}
/*?*/ }

/*?*/ bool SfxAcceleratorConfiguration::Commit( SvStream& rStream )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	bool bRet = true;
//STRIP001     ::utl::OOutputStreamWrapper* pHelper = new ::utl::OOutputStreamWrapper( rStream );
//STRIP001     ::com::sun::star::uno::Reference < ::com::sun::star::io::XOutputStream > xOutputStream( pHelper );
//STRIP001 
//STRIP001     Reference< XDocumentHandler > xWriter =
//STRIP001             Reference< XDocumentHandler >( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(
//STRIP001 			::rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Writer" )), UNO_QUERY) ;
//STRIP001 
//STRIP001 	Reference< ::com::sun::star::io::XActiveDataSource> xDataSource( xWriter , UNO_QUERY );
//STRIP001     xDataSource->setOutputStream( xOutputStream );
//STRIP001 	try
//STRIP001 	{
//STRIP001 		OWriteAcceleratorDocumentHandler aWriteHandler( pImp->aList, xWriter );
//STRIP001 		aWriteHandler.WriteAcceleratorDocument();
//STRIP001         xOutputStream->flush();
//STRIP001 	}
//STRIP001 	catch ( RuntimeException& )
//STRIP001 	{
//STRIP001 		bRet = false;
//STRIP001 	}
//STRIP001 	catch ( SAXException& )
//STRIP001 	{
//STRIP001 		bRet = false;
//STRIP001 	}
//STRIP001 	catch ( ::com::sun::star::io::IOException& )
//STRIP001 	{
//STRIP001 		bRet = false;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
/*?*/ }

}
