/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_helpinterceptor.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:26:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "helpinterceptor.hxx"
#include "helpdispatch.hxx"
#include "newhelp.hxx"
#include "sfxuno.hxx"

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XNOTIFYINGDISPATCH_HPP_
#include <com/sun/star/frame/XNotifyingDispatch.hpp>
#endif
#ifndef _CPPUHELPER_INTERFACECONTAINER_H_
#include <cppuhelper/interfacecontainer.h>
#endif
#include <vcl/window.hxx>
#include <limits.h>
namespace binfilter {

using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::lang;

//STRIP001 extern void AppendConfigToken_Impl( String& rURL, sal_Bool bQuestionMark ); // sfxhelp.cxx
//STRIP001 
//STRIP001 // class HelpInterceptor_Impl --------------------------------------------
//STRIP001 
//STRIP001 HelpInterceptor_Impl::HelpInterceptor_Impl() :
//STRIP001 
//STRIP001 	m_pHistory	( NULL ),
//STRIP001 	m_nCurPos	( 0 )
//STRIP001 
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 HelpInterceptor_Impl::~HelpInterceptor_Impl()
//STRIP001 {
//STRIP001 	for ( USHORT i = 0; m_pHistory && i < m_pHistory->Count(); ++i )
//STRIP001 		delete m_pHistory->GetObject(i);
//STRIP001 	delete m_pHistory;
//STRIP001 
//STRIP001 	if ( m_xIntercepted.is() )
//STRIP001 		m_xIntercepted->releaseDispatchProviderInterceptor( (XDispatchProviderInterceptor*)this );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void HelpInterceptor_Impl::addURL( const String& rURL )
//STRIP001 {
//STRIP001 	if ( !m_pHistory )
//STRIP001 		m_pHistory = new HelpHistoryList_Impl;
//STRIP001 	ULONG nCount = m_pHistory->Count();
//STRIP001 	if ( nCount && m_nCurPos < ( nCount - 1 ) )
//STRIP001 	{
//STRIP001 		for ( ULONG i = nCount - 1; i > m_nCurPos; i-- )
//STRIP001 			delete m_pHistory->Remove(i);
//STRIP001 	}
//STRIP001     Reference<XFrame> xFrame(m_xIntercepted, UNO_QUERY);
//STRIP001     Reference<XController> xController;
//STRIP001     if(xFrame.is())
//STRIP001         xController = xFrame->getController();
//STRIP001     Any aViewData;
//STRIP001     if(xController.is() && m_pHistory->Count())
//STRIP001 	{
//STRIP001 		m_pHistory->GetObject(m_nCurPos)->aViewData = xController->getViewData();
//STRIP001 	}
//STRIP001             
//STRIP001 	m_aCurrentURL = rURL;
//STRIP001 	Any aEmptyViewData;
//STRIP001     m_pHistory->Insert( new HelpHistoryEntry_Impl( rURL, aEmptyViewData ), LIST_APPEND );
//STRIP001 	m_nCurPos = m_pHistory->Count() - 1;
//STRIP001 
//STRIP001 	if ( m_xListener.is() )
//STRIP001 	{
//STRIP001 		::com::sun::star::frame::FeatureStateEvent aEvent;
//STRIP001 		URL aURL;
//STRIP001 	    aURL.Complete = rURL;
//STRIP001 		aEvent.FeatureURL = aURL;
//STRIP001         aEvent.Source = (::com::sun::star::frame::XDispatch*)this;
//STRIP001 		m_xListener->statusChanged( aEvent );
//STRIP001 	}
//STRIP001 
//STRIP001 	m_pWindow->UpdateToolbox();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void HelpInterceptor_Impl::setInterception( Reference< XFrame > xFrame )
//STRIP001 {
//STRIP001 	m_xIntercepted = Reference< XDispatchProviderInterception>( xFrame, UNO_QUERY );
//STRIP001 
//STRIP001 	if ( m_xIntercepted.is() )
//STRIP001 		m_xIntercepted->registerDispatchProviderInterceptor( (XDispatchProviderInterceptor*)this );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void HelpInterceptor_Impl::SetStartURL( const String& rURL )
//STRIP001 {
//STRIP001 	DBG_ASSERT( !m_pHistory, "invalid history" );
//STRIP001 	if ( !m_pHistory )
//STRIP001 	{
//STRIP001 		m_pHistory = new HelpHistoryList_Impl;
//STRIP001         Any aEmptyViewData;
//STRIP001         m_pHistory->Insert( new HelpHistoryEntry_Impl( rURL, aEmptyViewData ), ((ULONG)0x0) );
//STRIP001 		m_nCurPos = m_pHistory->Count() - 1;
//STRIP001 
//STRIP001 		m_pWindow->UpdateToolbox();
//STRIP001 	}
//STRIP001 	m_aCurrentURL = rURL;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool HelpInterceptor_Impl::HasHistoryPred() const
//STRIP001 {
//STRIP001 	return m_pHistory && ( m_nCurPos > 0 );
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool HelpInterceptor_Impl::HasHistorySucc() const
//STRIP001 {
//STRIP001 	return m_pHistory && ( m_nCurPos < ( m_pHistory->Count() - 1 ) );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 // XDispatchProvider
//STRIP001 
//STRIP001 Reference< XDispatch > SAL_CALL HelpInterceptor_Impl::queryDispatch(
//STRIP001 
//STRIP001 	const URL& aURL, const ::rtl::OUString& aTargetFrameName, sal_Int32 nSearchFlags )
//STRIP001 
//STRIP001 	throw( RuntimeException )
//STRIP001 
//STRIP001 {
//STRIP001 	Reference< XDispatch > xResult;
//STRIP001 	if ( m_xSlaveDispatcher.is() )
//STRIP001 		xResult = m_xSlaveDispatcher->queryDispatch( aURL, aTargetFrameName, nSearchFlags );
//STRIP001 
//STRIP001 	INetURLObject aObj( aURL.Complete );
//STRIP001 	sal_Bool bHelpURL = ( aObj.GetProtocol() == INET_PROT_VND_SUN_STAR_HELP );
//STRIP001 	if ( bHelpURL )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( xResult.is(), "invalid dispatch" );
//STRIP001 	    HelpDispatch_Impl* pHelpDispatch = new HelpDispatch_Impl( *this, xResult );
//STRIP001     	xResult = Reference< XDispatch >( static_cast< ::cppu::OWeakObject* >(pHelpDispatch), UNO_QUERY );
//STRIP001 	}
//STRIP001 
//STRIP001 	return xResult;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 Sequence < Reference < XDispatch > > SAL_CALL HelpInterceptor_Impl::queryDispatches(
//STRIP001 
//STRIP001 	const Sequence< DispatchDescriptor >& aDescripts )
//STRIP001 
//STRIP001 	throw( RuntimeException )
//STRIP001 
//STRIP001 {
//STRIP001 	Sequence< Reference< XDispatch > > aReturn( aDescripts.getLength() );
//STRIP001 	Reference< XDispatch >* pReturn = aReturn.getArray();
//STRIP001 	const DispatchDescriptor* pDescripts = aDescripts.getConstArray();
//STRIP001 	for ( sal_Int16 i = 0; i < aDescripts.getLength(); ++i, ++pReturn, ++pDescripts )
//STRIP001 	{
//STRIP001 		*pReturn = queryDispatch( pDescripts->FeatureURL, pDescripts->FrameName, pDescripts->SearchFlags );
//STRIP001 	}
//STRIP001 	return aReturn;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 // XDispatchProviderInterceptor
//STRIP001 
//STRIP001 Reference< XDispatchProvider > SAL_CALL HelpInterceptor_Impl::getSlaveDispatchProvider()
//STRIP001 
//STRIP001 	throw( RuntimeException )
//STRIP001 
//STRIP001 {
//STRIP001 	return m_xSlaveDispatcher;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SAL_CALL HelpInterceptor_Impl::setSlaveDispatchProvider( const Reference< XDispatchProvider >& xNewSlave )
//STRIP001 
//STRIP001 	throw( RuntimeException )
//STRIP001 
//STRIP001 {
//STRIP001 	m_xSlaveDispatcher = xNewSlave;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 Reference< XDispatchProvider > SAL_CALL HelpInterceptor_Impl::getMasterDispatchProvider()
//STRIP001 
//STRIP001 	throw( RuntimeException )
//STRIP001 
//STRIP001 {
//STRIP001 	return m_xMasterDispatcher;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SAL_CALL HelpInterceptor_Impl::setMasterDispatchProvider( const Reference< XDispatchProvider >& xNewMaster )
//STRIP001 
//STRIP001 	throw( RuntimeException )
//STRIP001 
//STRIP001 {
//STRIP001 	m_xMasterDispatcher = xNewMaster;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 // XInterceptorInfo
//STRIP001 
//STRIP001 Sequence< ::rtl::OUString > SAL_CALL HelpInterceptor_Impl::getInterceptedURLs()
//STRIP001 
//STRIP001 	throw( RuntimeException )
//STRIP001 
//STRIP001 {
//STRIP001 	Sequence< ::rtl::OUString > aURLList( 1 );
//STRIP001 	aURLList[0] = DEFINE_CONST_UNICODE("vnd.sun.star.help://*");
//STRIP001 	return aURLList;;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 // XDispatch
//STRIP001 
//STRIP001 void SAL_CALL HelpInterceptor_Impl::dispatch(
//STRIP001 
//STRIP001 	const URL& aURL, const Sequence< ::com::sun::star::beans::PropertyValue >& aArgs ) throw( RuntimeException )
//STRIP001 
//STRIP001 {
//STRIP001 	sal_Bool bBack = ( String( DEFINE_CONST_UNICODE(".uno:Backward") ) == String( aURL.Complete ) );
//STRIP001 	if ( bBack || String( DEFINE_CONST_UNICODE(".uno:Forward") ) == String( aURL.Complete ) )
//STRIP001 	{
//STRIP001 		if ( m_pHistory )
//STRIP001 		{
//STRIP001 			if(m_pHistory->Count() > m_nCurPos)
//STRIP001 			{
//STRIP001 				Reference<XFrame> xFrame(m_xIntercepted, UNO_QUERY);
//STRIP001                 Reference<XController> xController;
//STRIP001                 if(xFrame.is())
//STRIP001                     xController = xFrame->getController();
//STRIP001 				if(xController.is())
//STRIP001 				{
//STRIP001 					m_pHistory->GetObject(m_nCurPos)->aViewData = xController->getViewData();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			
//STRIP001 			ULONG nPos = ( bBack && m_nCurPos > 0 ) ? --m_nCurPos
//STRIP001 													: ( !bBack && m_nCurPos < m_pHistory->Count() - 1 )
//STRIP001 													? ++m_nCurPos
//STRIP001 													: ULONG_MAX;
//STRIP001 
//STRIP001 			if ( nPos < ULONG_MAX )
//STRIP001 			{
//STRIP001 				HelpHistoryEntry_Impl* pEntry = m_pHistory->GetObject( nPos );
//STRIP001 				if ( pEntry )
//STRIP001 				{
//STRIP001 					URL aURL;
//STRIP001 	        		aURL.Complete = pEntry->aURL;
//STRIP001             		Reference < XDispatch > xDisp = m_xSlaveDispatcher->queryDispatch( aURL, String(), 0 );
//STRIP001             		if ( xDisp.is() )
//STRIP001 					{
//STRIP001 						if ( m_pOpenListener && m_pWindow )
//STRIP001 						{
//STRIP001 							if ( !m_pWindow->IsWait() )
//STRIP001 								m_pWindow->EnterWait();
//STRIP001 						}
//STRIP001 						m_aCurrentURL = aURL.Complete;
//STRIP001                         m_aViewData = pEntry->aViewData;
//STRIP001 
//STRIP001         				Reference < XNotifyingDispatch > xNotifyingDisp( xDisp, UNO_QUERY );
//STRIP001 				        if ( xNotifyingDisp.is() )
//STRIP001         				{
//STRIP001         					OpenStatusListener_Impl* pListener = (OpenStatusListener_Impl*)m_pWindow->getOpenListener().get();
//STRIP001         					DBG_ASSERT( pListener, "invalid XDispatchResultListener" );
//STRIP001         					pListener->SetURL( aURL.Complete );
//STRIP001         					xNotifyingDisp->dispatchWithNotification( aURL, Sequence < PropertyValue >(), pListener );
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			m_pWindow->UpdateToolbox();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SAL_CALL HelpInterceptor_Impl::addStatusListener(
//STRIP001 
//STRIP001 	const Reference< XStatusListener >& xControl, const URL& aURL ) throw( RuntimeException )
//STRIP001 
//STRIP001 {
//STRIP001 	DBG_ASSERT( !m_xListener.is(), "listener already exists" );
//STRIP001 	m_xListener = xControl;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SAL_CALL HelpInterceptor_Impl::removeStatusListener(
//STRIP001 
//STRIP001 	const Reference< XStatusListener >& xControl, const URL& aURL ) throw( RuntimeException )
//STRIP001 
//STRIP001 {
//STRIP001 	m_xListener = 0;
//STRIP001 }
//STRIP001 
//STRIP001 // HelpListener_Impl -----------------------------------------------------
//STRIP001 
//STRIP001 HelpListener_Impl::HelpListener_Impl( HelpInterceptor_Impl* pInter )
//STRIP001 {
//STRIP001 	pInterceptor = pInter;
//STRIP001     pInterceptor->addStatusListener( this, ::com::sun::star::util::URL() );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SAL_CALL HelpListener_Impl::statusChanged( const ::com::sun::star::frame::FeatureStateEvent& Event )
//STRIP001 
//STRIP001 	throw( ::com::sun::star::uno::RuntimeException )
//STRIP001 
//STRIP001 {
//STRIP001 	INetURLObject aObj( Event.FeatureURL.Complete );
//STRIP001 	aFactory = aObj.GetHost();
//STRIP001 	aChangeLink.Call( this );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SAL_CALL HelpListener_Impl::disposing( const ::com::sun::star::lang::EventObject& obj )
//STRIP001 
//STRIP001 	throw( ::com::sun::star::uno::RuntimeException )
//STRIP001 
//STRIP001 {
//STRIP001     pInterceptor->removeStatusListener( this, ::com::sun::star::util::URL() );
//STRIP001     pInterceptor = NULL;
//STRIP001 }
//STRIP001 /*-- 05.09.2002 12:17:59---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 HelpStatusListener_Impl::HelpStatusListener_Impl(
//STRIP001         Reference < XDispatch > xDispatch, URL& rURL)
//STRIP001 {
//STRIP001     xDispatch->addStatusListener(this, rURL);
//STRIP001 }
//STRIP001 /*-- 05.09.2002 12:17:59---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 HelpStatusListener_Impl::~HelpStatusListener_Impl()
//STRIP001 {
//STRIP001     if(xDispatch.is())
//STRIP001         xDispatch->removeStatusListener(this, ::com::sun::star::util::URL());
//STRIP001 }
//STRIP001 /*-- 05.09.2002 12:17:59---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 void HelpStatusListener_Impl::statusChanged(
//STRIP001     const FeatureStateEvent& rEvent ) throw( RuntimeException )
//STRIP001 {
//STRIP001     aStateEvent = rEvent;
//STRIP001 }
//STRIP001 /*-- 05.09.2002 12:18:00---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 void HelpStatusListener_Impl::disposing( const EventObject& obj ) throw( RuntimeException )
//STRIP001 {
//STRIP001     xDispatch->removeStatusListener(this, ::com::sun::star::util::URL());
//STRIP001     xDispatch = 0;
//STRIP001 }
}
