/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_slotinfo.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:03:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
// INCLUDE ---------------------------------------------------------------

#ifndef _RSCSFX_HXX //autogen
#include <rsc/rscsfx.hxx>
#endif
#pragma hdrstop

#include "slotinfo.hxx"
namespace binfilter {

// -----------------------------------------------------------------------

// Implementierung des Resource-Konstruktors

/*N*/ SfxSlotInfo::SfxSlotInfo( const ResId &rResId ) :
/*N*/ 
/*N*/ 	Resource( rResId.SetRT( RSC_SFX_SLOT_INFO ) )
/*N*/ 
/*N*/ {
/*N*/ #if SUPD<548
/*N*/ 	USHORT nMask = *(USHORT *)GetClassRes();
/*N*/ 	IncrementRes( sizeof( USHORT ) );
/*N*/ 
/*N*/ 	if(nMask & RSC_SFX_SLOT_INFO_SLOTNAME)
/*N*/ 	{
/*N*/ 		aName = String( (char*)GetClassRes() );
/*N*/ 		IncrementRes(GetStringSizeRes(aName));
/*N*/ 	}
/*N*/ 	if(nMask & RSC_SFX_SLOT_INFO_HELPTEXT)
/*N*/ 	{
/*N*/ 		aHelpText = String( (char*)GetClassRes() );
/*N*/ 		IncrementRes(GetStringSizeRes(aHelpText));
/*N*/ 	}
/*N*/ #else
/*N*/ 	USHORT nMask = (USHORT) ReadShortRes();
/*N*/ 	if(nMask & RSC_SFX_SLOT_INFO_SLOTNAME)
/*N*/ 	{
/*N*/ 		aName = ReadStringRes();
/*N*/ 	}
/*N*/ 	if(nMask & RSC_SFX_SLOT_INFO_HELPTEXT)
/*N*/ 	{
/*?*/ 		aHelpText = ReadStringRes();
/*N*/ 	}
/*N*/ #endif
/*N*/ }


}
