/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_splitwin.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:03:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

// auto strip #ifndef _WRKWIN_HXX //autogen
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif
#ifndef INCLUDED_SVTOOLS_VIEWOPTIONS_HXX
#include <svtools/viewoptions.hxx>
#endif
#pragma hdrstop

#include "splitwin.hxx"
#include "workwin.hxx"
#include "dockwin.hxx"
// auto strip #include "app.hxx"
#include "dialog.hrc"
// auto strip #include "sfxresid.hxx"
// auto strip #include "mnumgr.hxx"
// auto strip #include "virtmenu.hxx"
// auto strip #include "msgpool.hxx"
// auto strip #include "viewfrm.hxx"

#ifndef _SFX_SFXUNO_HXX
#include "sfxuno.hxx"
#endif

namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::rtl;

#define VERSION	1
#define nPixel	30L
#define USERITEM_NAME			OUString::createFromAscii( "UserItem" )

struct SfxDock_Impl
{
	USHORT 				nType;
	SfxDockingWindow*	pWin;			// SplitWindow hat dieses Fenster
	BOOL				bNewLine;
	BOOL				bHide;			// SplitWindow hatte dieses Fenster
	long				nSize;
};

typedef SfxDock_Impl* SfxDockPtr;
/*?*/ SV_DECL_PTRARR_DEL( SfxDockArr_Impl, SfxDockPtr, 4, 4)//STRIP008 ;
/*N*/ SV_IMPL_PTRARR( SfxDockArr_Impl, SfxDockPtr);

class SfxEmptySplitWin_Impl : public SplitWindow
{
/*  [Beschreibung]

	Das SfxEmptySplitWin_Impldow ist ein leeres SplitWindow, das das SfxSplitWindow
	im AutoHide-Modus ersetzt. Es dient nur als Platzhalter, um MouseMoves
	zu empfangen und ggf. das eigentlichte SplitWindow einzublenden
*/
friend class SfxSplitWindow;

	SfxSplitWindow* 	pOwner;
	BOOL				bFadeIn;
	BOOL				bAutoHide;
	BOOL				bSplit;
	BOOL				bEndAutoHide;
	Timer				aTimer;
	Point				aLastPos;
	USHORT				nState;

						SfxEmptySplitWin_Impl( SfxSplitWindow *pParent )
							: SplitWindow( pParent->GetParent(), WinBits( WB_BORDER | WB_3DLOOK ) )
							, pOwner( pParent )
							, bFadeIn( FALSE )
							, bAutoHide( FALSE )
							, bEndAutoHide( FALSE )
							, bSplit( FALSE )
							, nState( 1 )
						{
							aTimer.SetTimeoutHdl(
								LINK(pOwner, SfxSplitWindow, TimerHdl ) );
							aTimer.SetTimeout( 200 );
//                            EnableDrop( TRUE );
							SetAlign( pOwner->GetAlign() );
							Actualize();
							ShowAutoHideButton( pOwner->IsAutoHideButtonVisible() );
							ShowFadeInHideButton( TRUE );
						}

						~SfxEmptySplitWin_Impl()
						{
							aTimer.Stop();
						}

	virtual void		MouseMove( const MouseEvent& );
	virtual void		AutoHide();
	virtual void		FadeIn();
	void				Actualize();
};

/*N*/ void SfxEmptySplitWin_Impl::Actualize()
/*N*/ {
/*N*/ 	Size aSize( pOwner->GetSizePixel() );
/*N*/ 	switch ( pOwner->GetAlign() )
/*N*/ 	{
/*N*/ 		case WINDOWALIGN_LEFT:
/*N*/ 		case WINDOWALIGN_RIGHT:
/*N*/ 			aSize.Width() = GetFadeInSize();
/*N*/ 			break;
/*N*/ 		case WINDOWALIGN_TOP:
/*N*/ 		case WINDOWALIGN_BOTTOM:
/*N*/ 			aSize.Height() = GetFadeInSize();
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	SetSizePixel( aSize );
/*N*/ }

/*?*/ void SfxEmptySplitWin_Impl::AutoHide()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	pOwner->SetPinned_Impl( !pOwner->bPinned );
//STRIP001 	pOwner->SaveConfig_Impl();
//STRIP001 	bAutoHide = TRUE;
//STRIP001 	FadeIn();
/*?*/ }

/*?*/ void SfxEmptySplitWin_Impl::FadeIn()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if (!bAutoHide )
//STRIP001 		bAutoHide = IsFadeNoButtonMode();
//STRIP001 	pOwner->SetFadeIn_Impl( TRUE );
//STRIP001 	pOwner->Show_Impl();
//STRIP001 	if ( bAutoHide )
//STRIP001 	{
//STRIP001 		// Timer zum Schlie\sen aufsetzen; der Aufrufer mu\s selbst sicherstellen,
//STRIP001 		// da\s das Window nicht gleich wieder zu geht ( z.B. durch Setzen des
//STRIP001 		// Focus oder einen modal mode )
//STRIP001 		aLastPos = GetPointerPosPixel();
//STRIP001 		aTimer.Start();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pOwner->SaveConfig_Impl();
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxSplitWindow::MouseButtonDown( const MouseEvent& rMEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( rMEvt.GetClicks() != 2 )
//STRIP001 		SplitWindow::MouseButtonDown( rMEvt );
/*?*/ }

/*?*/ void SfxEmptySplitWin_Impl::MouseMove( const MouseEvent& rMEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	SplitWindow::MouseMove( rMEvt );
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ SfxSplitWindow::SfxSplitWindow( Window* pParent, SfxChildAlignment eAl,
/*N*/ 		SfxWorkWindow *pW, BOOL bWithButtons, WinBits nBits )

/*  [Beschreibung]

	Ein SfxSplitWindow verbirgt die rekursive Struktur des SV-Splitwindows
	nach au\sen, indem es einen tabellenartigen Aufbau mit Zeilen und Spalten
	( also maximale Rekursionstiefe 2 ) simuliert.
	Au\erdem sichert es die Persistenz der Anordnung der SfxDockingWindows.
*/

/*N*/ :	SplitWindow ( pParent, nBits | WB_HIDE ),
/*N*/ 	eAlign(eAl),
/*N*/ 	pWorkWin(pW),
/*N*/ 	pDockArr( new SfxDockArr_Impl ),
/*N*/ 	bLocked(FALSE),
/*N*/ 	bPinned(TRUE),
/*N*/ 	pEmptyWin(NULL),
/*N*/ 	pActive(NULL)
/*N*/ {
/*N*/ 	if ( bWithButtons )
/*N*/ 	{
/*N*/ 		ShowAutoHideButton( TRUE );
/*N*/ 		ShowFadeOutButton( TRUE );
/*N*/ 	}
/*N*/ 
/*N*/ 	// SV-Alignment setzen
/*N*/ 	WindowAlign eTbxAlign;
/*N*/ 	switch ( eAlign )
/*N*/ 	{
/*N*/ 		case SFX_ALIGN_LEFT:
/*N*/ 			eTbxAlign = WINDOWALIGN_LEFT;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_RIGHT:
/*N*/ 			eTbxAlign = WINDOWALIGN_RIGHT;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_TOP:
/*N*/ 			eTbxAlign = WINDOWALIGN_TOP;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_BOTTOM:
/*N*/ 			eTbxAlign = WINDOWALIGN_BOTTOM;
/*N*/ 			bPinned = TRUE;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	SetAlign (eTbxAlign);
/*N*/ 	pEmptyWin = new SfxEmptySplitWin_Impl( this );
/*N*/ 	if ( bPinned )
/*N*/ 	{
/*N*/ 		pEmptyWin->bFadeIn = TRUE;
/*N*/ 		pEmptyWin->nState = 2;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( bWithButtons )
/*N*/ 	{
/*N*/ 		// Konfiguration einlesen
/*N*/         String aWindowId = String::CreateFromAscii("SplitWindow");
/*N*/         aWindowId += String::CreateFromInt32( (sal_Int32) eTbxAlign );
/*N*/         SvtViewOptions aWinOpt( E_WINDOW, aWindowId );
/*N*/         String aWinData;
/*N*/ 		Any aUserItem = aWinOpt.GetUserItem( USERITEM_NAME );
/*N*/ 		OUString aTemp;
/*N*/ 		if ( aUserItem >>= aTemp )
/*N*/ 			aWinData = String( aTemp );
/*N*/         if ( aWinData.Len() && aWinData.GetChar( (USHORT) 0 ) == 'V' )
/*N*/         {
/*N*/             pEmptyWin->nState = (USHORT) aWinData.GetToken( 1, ',' ).ToInt32();
/*N*/             if ( pEmptyWin->nState & 2 )
/*N*/                 pEmptyWin->bFadeIn = TRUE;
/*N*/             bPinned = !( pEmptyWin->nState & 1 );
/*N*/ 
/*N*/             USHORT i=2;
/*N*/             USHORT nCount = (USHORT) aWinData.GetToken(i++, ',').ToInt32();
/*N*/             for ( USHORT n=0; n<nCount; n++ )
/*N*/             {
/*N*/                 SfxDock_Impl *pDock = new SfxDock_Impl;
/*N*/                 pDock->pWin = 0;
/*N*/                 pDock->bNewLine = FALSE;
/*N*/                 pDock->bHide = TRUE;
/*N*/                 pDock->nType = (USHORT) aWinData.GetToken(i++, ',').ToInt32();
/*N*/                 if ( !pDock->nType )
/*N*/                 {
/*N*/                     // K"onnte NewLine bedeuten
/*N*/                     pDock->nType = (USHORT) aWinData.GetToken(i++, ',').ToInt32();
/*N*/                     if ( !pDock->nType )
/*N*/                     {
/*N*/                         // Lesefehler
/*N*/                         delete pDock;
/*N*/                         break;
/*N*/                     }
/*N*/                     else
/*N*/                         pDock->bNewLine = TRUE;
/*N*/                 }
/*N*/ 
/*N*/                 pDockArr->Insert(pDock,n);
/*N*/             }
/*N*/         }
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/ 		bPinned = TRUE;
/*?*/ 		pEmptyWin->bFadeIn = TRUE;
/*?*/ 		pEmptyWin->nState = 2;
/*N*/ 	}
/*N*/ 
/*N*/ 	SetAutoHideState( !bPinned );
/*N*/ 	pEmptyWin->SetAutoHideState( !bPinned );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxSplitWindow::~SfxSplitWindow()
/*N*/ {
/*N*/ 	if ( !pWorkWin->GetParent_Impl() )
/*N*/ 		SaveConfig_Impl();
/*N*/ 
/*N*/ 	if ( pEmptyWin )
/*N*/ 	{
/*N*/ 		// pOwner auf NULL setzen, sonst versucht pEmptyWin, nochmal zu
/*N*/ 		// l"oschen; es wird n"amlich von au\sen immer das Fenster deleted,
/*N*/ 		// das gerade angedockt ist
/*N*/ 		pEmptyWin->pOwner = NULL;
/*N*/ 		delete pEmptyWin;
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pDockArr;
/*N*/ }

/*N*/ void SfxSplitWindow::SaveConfig_Impl()
/*N*/ {
/*N*/ 	// Konfiguration abspeichern
/*N*/ 	String aWinData('V');
/*N*/     aWinData += String::CreateFromInt32( VERSION );
/*N*/ 	aWinData += ',';
/*N*/     aWinData += String::CreateFromInt32( pEmptyWin->nState );
/*N*/ 	aWinData += ',';
/*N*/ 
/*N*/ 	USHORT nCount = 0;
/*N*/ 	USHORT n;
/*N*/ 	for ( n=0; n<pDockArr->Count(); n++ )
/*N*/ 	{
/*N*/ 		SfxDock_Impl *pDock = (*pDockArr)[n];
/*N*/ 		if ( pDock->bHide || pDock->pWin )
/*N*/ 			nCount++;
/*N*/ 	}
/*N*/ 
/*N*/     aWinData += String::CreateFromInt32( nCount );
/*N*/ 
/*N*/ 	for ( n=0; n<pDockArr->Count(); n++ )
/*N*/ 	{
/*N*/ 		SfxDock_Impl *pDock = (*pDockArr)[n];
/*N*/ 		if ( !pDock->bHide && !pDock->pWin )
/*N*/ 			continue;
/*N*/ 		if ( pDock->bNewLine )
/*N*/ 			aWinData += DEFINE_CONST_UNICODE(",0");
/*N*/ 		aWinData += ',';
/*N*/         aWinData += String::CreateFromInt32( pDock->nType);
/*N*/ 	}
/*N*/ 
/*N*/     String aWindowId = String::CreateFromAscii("SplitWindow");
/*N*/     aWindowId += String::CreateFromInt32( (sal_Int32) GetAlign() );
/*N*/     SvtViewOptions aWinOpt( E_WINDOW, aWindowId );
/*N*/ 	aWinOpt.SetUserItem( USERITEM_NAME, makeAny( OUString( aWinData ) ) );
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxSplitWindow::StartSplit()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	long nSize;
//STRIP001 	Size aSize = GetSizePixel();
//STRIP001 
//STRIP001 	if ( pEmptyWin )
//STRIP001 	{
//STRIP001 		pEmptyWin->bFadeIn = TRUE;
//STRIP001 		pEmptyWin->bSplit = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	Rectangle aRect = pWorkWin->GetFreeArea( !bPinned );
//STRIP001 	switch ( GetAlign() )
//STRIP001 	{
//STRIP001 		case WINDOWALIGN_LEFT:
//STRIP001 		case WINDOWALIGN_RIGHT:
//STRIP001 			nSize = aSize.Width() + aRect.GetWidth();
//STRIP001 			break;
//STRIP001 		case WINDOWALIGN_TOP:
//STRIP001 		case WINDOWALIGN_BOTTOM:
//STRIP001 			nSize = aSize.Height() + aRect.GetHeight();
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	SetMaxSizePixel( nSize );
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxSplitWindow::SplitResize()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( bPinned )
//STRIP001 	{
//STRIP001 		pWorkWin->ArrangeChilds_Impl();
//STRIP001 		pWorkWin->ShowChilds_Impl();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pWorkWin->ArrangeAutoHideWindows( this );
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxSplitWindow::Split()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( pEmptyWin )
//STRIP001 		pEmptyWin->bSplit = FALSE;
//STRIP001 
//STRIP001 	SplitWindow::Split();
//STRIP001 
//STRIP001 	USHORT nCount = pDockArr->Count();
//STRIP001 	for ( USHORT n=0; n<nCount; n++ )
//STRIP001 	{
//STRIP001 		SfxDock_Impl *pD = (*pDockArr)[n];
//STRIP001 		if ( pD->pWin )
//STRIP001 		{
//STRIP001 			USHORT nId = pD->nType;
//STRIP001 			long nSize    = GetItemSize( nId );
//STRIP001 			long nSetSize = GetItemSize( GetSet( nId ) );
//STRIP001 			Size aSize;
//STRIP001 
//STRIP001 			if ( IsHorizontal() )
//STRIP001 			{
//STRIP001 				aSize.Width()  = nSize;
//STRIP001 				aSize.Height() = nSetSize;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aSize.Width()  = nSetSize;
//STRIP001 				aSize.Height() = nSize;
//STRIP001 			}
//STRIP001 
//STRIP001 			pD->pWin->SetItemSize_Impl( aSize );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SaveConfig_Impl();
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxSplitWindow::InsertWindow( SfxDockingWindow* pDockWin, const Size& rSize)

/*  [Beschreibung]

	Zum Einf"ugen von SfxDockingWindows kann auch keine Position "ubergeben
	werden. Das SfxSplitWindow sucht dann die zuletzt gemerkte zu dem
	"ubergebenen SfxDockingWindow heraus oder h"angt es als letztes neu an.

*/
/*N*/ {
/*N*/ 	short nLine = -1;    	// damit erstes Fenster nLine auf 0 hochsetzen kann
/*N*/ 	USHORT nL;
/*N*/ 	USHORT nPos = 0;
/*N*/ 	BOOL bNewLine = TRUE;
/*N*/ 	BOOL bSaveConfig = FALSE;
/*N*/ 	SfxDock_Impl *pFoundDock=0;
/*N*/ 	USHORT nCount = pDockArr->Count();
/*N*/ 	for ( USHORT n=0; n<nCount; n++ )
/*N*/ 	{
/*N*/ 		SfxDock_Impl *pDock = (*pDockArr)[n];
/*N*/ 		if ( pDock->bNewLine )
/*N*/ 		{
/*N*/ 			// Das Fenster er"offnet eine neue Zeile
/*N*/ 			if ( pFoundDock )
/*N*/ 				// Aber hinter dem gerade eingef"ugten Fenster
/*N*/ 				break;
/*N*/ 
/*N*/ 			// Neue Zeile
/*N*/ 			nPos = 0;
/*N*/ 			bNewLine = TRUE;
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pDock->pWin )
/*N*/ 		{
/*N*/ 			// Es gibt an dieser Stelle gerade ein Fenster
/*?*/ 			if ( bNewLine && !pFoundDock )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				// Bisher ist nicht bekannt, in welcher realen Zeile es liegt
//STRIP001 /*?*/ 				GetWindowPos( pDock->pWin, nL, nPos );
//STRIP001 /*?*/ 				nLine = (short) nL;
/*?*/ 			}
/*?*/ 
/*?*/ 			if ( !pFoundDock )
/*?*/ 			{
/*?*/ 				// Fenster liegt vor dem eingef"ugten
/*?*/ 				nPos++;
/*?*/ 			}
/*?*/ 
/*?*/ 			// Zeile ist schon er"offnet
/*?*/ 			bNewLine = FALSE;
/*?*/ 			if ( pFoundDock )
/*?*/ 				break;
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pDock->nType == pDockWin->GetType() )
/*N*/ 		{
/*N*/ 			DBG_ASSERT( !pFoundDock && !pDock->pWin, "Fenster ist schon vorhanden!");
/*N*/ 			pFoundDock = pDock;
/*N*/ 			if ( !bNewLine )
/*N*/ 				break;
/*N*/ 			else
/*N*/ 			{
/*N*/ 				// Es wurde zuletzt eine neue Reihe gestartet, aber noch kein
/*N*/ 				// darin liegendes Fenster gefunden; daher weitersuchen, ob noch
/*N*/ 				// ein Fenster in dieser Zeile folgt, um bNewLine korrekt zu setzen.
/*N*/ 				// Dabei darf aber nLine oder nPos nicht mehr ver"andert werden!
/*N*/ 				nLine++;
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( !pFoundDock )
/*N*/ 	{
/*N*/ 		// Nicht gefunden, am Ende einf"ugen
/*N*/ 		pFoundDock = new SfxDock_Impl;
/*N*/ 		pFoundDock->bHide = TRUE;
/*N*/ 		pDockArr->Insert( pFoundDock, nCount );
/*N*/ 		pFoundDock->nType = pDockWin->GetType();
/*N*/ 		nLine++;
/*N*/ 		nPos = 0;
/*N*/ 		bNewLine = TRUE;
/*N*/ 		pFoundDock->bNewLine = bNewLine;
/*N*/ 		bSaveConfig = TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	pFoundDock->pWin = pDockWin;
/*N*/ 	pFoundDock->bHide = FALSE;
/*N*/ 	InsertWindow_Impl( pFoundDock, rSize, nLine, nPos, bNewLine );
/*N*/ 	if ( bSaveConfig )
/*N*/ 		SaveConfig_Impl();
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 void SfxSplitWindow::ReleaseWindow_Impl(SfxDockingWindow *pDockWin, BOOL bSave)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Das DockingWindow wird nicht mehr in den internen Daten gespeichert.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	SfxDock_Impl *pDock=0;
//STRIP001 	USHORT nCount = pDockArr->Count();
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 	for ( USHORT n=0; n<nCount; n++ )
//STRIP001 	{
//STRIP001 		pDock = (*pDockArr)[n];
//STRIP001 		if ( pDock->nType == pDockWin->GetType() )
//STRIP001 		{
//STRIP001 			if ( pDock->bNewLine && n<nCount-1 )
//STRIP001 				(*pDockArr)[n+1]->bNewLine = TRUE;
//STRIP001 
//STRIP001 			// Fenster hat schon eine Position, die vergessen wir
//STRIP001 			bFound = TRUE;
//STRIP001 			pDockArr->Remove(n);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bFound )
//STRIP001 		delete pDock;
//STRIP001 
//STRIP001 	if ( bSave )
//STRIP001 		SaveConfig_Impl();
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxSplitWindow::MoveWindow( SfxDockingWindow* pDockWin, const Size& rSize,
//STRIP001 						USHORT nLine, USHORT nPos, BOOL bNewLine)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Das DockingWindow wird innerhalb des Splitwindows verschoben.
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	USHORT nL, nP;
//STRIP001 	GetWindowPos( pDockWin, nL, nP );
//STRIP001 
//STRIP001 	if ( nLine > nL && GetItemCount( GetItemId( nL, 0 ) ) == 1 )
//STRIP001 	{
//STRIP001 		// Wenn das letzte Fenster aus seiner Zeile entfernt wird, rutscht
//STRIP001 		// alles eine Zeile nach vorne!
//STRIP001 		nLine--;
//STRIP001 	}
//STRIP001 /*
//STRIP001 	else if ( nLine == nL && nPos > nP )
//STRIP001 	{
//STRIP001 		nPos--;
//STRIP001 	}
//STRIP001 */
//STRIP001 	RemoveWindow( pDockWin );
//STRIP001 	InsertWindow( pDockWin, rSize, nLine, nPos, bNewLine );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxSplitWindow::InsertWindow( SfxDockingWindow* pDockWin, const Size& rSize,
//STRIP001 						USHORT nLine, USHORT nPos, BOOL bNewLine)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Das DockingWindow wird in dieses Splitwindow geschoben und soll die
//STRIP001 	"ubergebene Position und Gr"o\se haben.
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	ReleaseWindow_Impl( pDockWin, FALSE );
//STRIP001 	SfxDock_Impl *pDock = new SfxDock_Impl;
//STRIP001 	pDock->bHide = FALSE;
//STRIP001 	pDock->nType = pDockWin->GetType();
//STRIP001 	pDock->bNewLine = bNewLine;
//STRIP001 	pDock->pWin = pDockWin;
//STRIP001 
//STRIP001 	DBG_ASSERT( nPos==0 || !bNewLine, "Falsche Paramenter!");
//STRIP001 	if ( bNewLine )
//STRIP001 		nPos = 0;
//STRIP001 
//STRIP001 	// Das Fenster mu\s vor dem ersten Fenster eingef"ugt werden, das die
//STRIP001 	// gleiche oder eine gr"o\sere Position hat als pDockWin.
//STRIP001 	USHORT nCount = pDockArr->Count();
//STRIP001 
//STRIP001 	// Wenn gar kein Fenster gefunden wird, wird als erstes eingef"ugt
//STRIP001 	USHORT nInsertPos = 0;
//STRIP001 	for ( USHORT n=0; n<nCount; n++ )
//STRIP001 	{
//STRIP001 		SfxDock_Impl *pD = (*pDockArr)[n];
//STRIP001 
//STRIP001 		if (pD->pWin)
//STRIP001 		{
//STRIP001 			// Ein angedocktes Fenster wurde gefunden
//STRIP001 			// Wenn kein geeignetes Fenster hinter der gew"unschten Einf"ugeposition
//STRIP001 			// gefunden wird, wird am Ende eingef"ugt
//STRIP001 			nInsertPos = nCount;
//STRIP001 			USHORT nL=0, nP=0;
//STRIP001 			GetWindowPos( pD->pWin, nL, nP );
//STRIP001 
//STRIP001 			if ( nL == nLine && nP == nPos || nL > nLine )
//STRIP001 			{
//STRIP001 				DBG_ASSERT( nL == nLine || bNewLine || nPos > 0, "Falsche Parameter!" );
//STRIP001 				if ( nL == nLine && nPos == 0 && !bNewLine )
//STRIP001 				{
//STRIP001 					DBG_ASSERT(pD->bNewLine, "Keine neue Zeile?");
//STRIP001 
//STRIP001 					// Das Fenster wird auf nPos==0 eingeschoben
//STRIP001 					pD->bNewLine = FALSE;
//STRIP001 					pDock->bNewLine = TRUE;
//STRIP001 				}
//STRIP001 
//STRIP001 				nInsertPos = n;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	pDockArr->Insert(pDock, nInsertPos);
//STRIP001 	InsertWindow_Impl( pDock, rSize, nLine, nPos, bNewLine );
//STRIP001 	SaveConfig_Impl();
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ void SfxSplitWindow::InsertWindow_Impl( SfxDock_Impl* pDock,
/*N*/ 						const Size& rSize,
/*N*/ 						USHORT nLine, USHORT nPos, BOOL bNewLine)

/*  [Beschreibung]

	F"ugt ein DockingWindow ein und veranla\st die Neuberechnung der Gr"o\se
	des Splitwindows.
*/

/*N*/ {
/*N*/ 	SfxDockingWindow* pDockWin = pDock->pWin;
/*N*/ 
/*N*/ 	USHORT nItemBits = pDockWin->GetWinBits_Impl();
/*N*/ 
/*N*/ 	long nWinSize, nSetSize;
/*N*/ 	if ( IsHorizontal() )
/*N*/ 	{
/*N*/ 		nWinSize = rSize.Width();
/*N*/ 		nSetSize = rSize.Height();
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/ 		nSetSize = rSize.Width();
/*?*/ 		nWinSize = rSize.Height();
/*N*/ 	}
/*N*/ 
/*N*/ 	pDock->nSize = nWinSize;
/*N*/ 
/*N*/ 	BOOL bUpdateMode = IsUpdateMode();
/*N*/ 	if ( bUpdateMode )
/*N*/ 		SetUpdateMode( FALSE );
/*N*/ 
/*N*/ 	if ( bNewLine || nLine == GetItemCount( 0 ) )
/*N*/ 	{
/*N*/ 		// Es soll nicht in eine vorhandene Zeile eingef"ugt werden, sondern
/*N*/ 		// eine neue erzeugt werden
/*N*/ 
/*N*/ 		USHORT nId = 1;
/*N*/ 		for ( USHORT n=0; n<GetItemCount(0); n++ )
/*N*/ 		{
/*?*/ 			if ( GetItemId(n) >= nId )
/*?*/ 				nId = GetItemId(n)+1;
/*N*/ 		}
/*N*/ 
/*N*/ 		// Eine neue nLine-te Zeile erzeugen
/*N*/ 		USHORT nBits = nItemBits;
/*N*/ 		if ( GetAlign() == WINDOWALIGN_TOP || GetAlign() == WINDOWALIGN_BOTTOM )
/*N*/ 			nBits |= SWIB_COLSET;
/*N*/ 		InsertItem( nId, nSetSize, nLine, 0, nBits );
/*N*/ 	}
/*N*/ 
/*N*/ 	// In Zeile mit Position nLine das Fenster einf"ugen
/*N*/ 	// ItemWindowSize auf "Prozentual" setzen, da SV dann das Umgr"o\sern
/*N*/ 	// so macht, wie man erwartet; "Pixel" macht eigentlich nur Sinn, wenn
/*N*/ 	// auch Items mit prozentualen oder relativen Gr"o\sen dabei sind.
/*N*/ 	nItemBits |= SWIB_PERCENTSIZE;
/*N*/ 	bLocked = TRUE;
/*N*/ 	USHORT nSet = GetItemId( nLine );
/*N*/ 	InsertItem( pDockWin->GetType(), pDockWin, nWinSize, nPos, nSet, nItemBits );
/*N*/ 
/*N*/ 	// Splitwindows werden im SFX einmal angelegt und beim Einf"ugen des ersten
/*N*/ 	// DockingWindows sichtbar gemacht.
/*N*/ 	if ( GetItemCount( 0 ) == 1 && GetItemCount( 1 ) == 1 )
/*N*/ 	{
/*N*/ 		// Das Neuarrangieren am WorkWindow und ein Show() auf das SplitWindow
/*N*/ 		// wird vom SfxDockingwindow veranla\st (->SfxWorkWindow::ConfigChild_Impl)
/*N*/ 		if ( !bPinned && !IsFloatingMode() )
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 			bPinned = TRUE;
//STRIP001 /*?*/ 			BOOL bFadeIn = ( pEmptyWin->nState & 2 ) != 0;
//STRIP001 /*?*/ 			pEmptyWin->bFadeIn = FALSE;
//STRIP001 /*?*/ 			SetPinned_Impl( FALSE );
//STRIP001 /*?*/ 			pEmptyWin->Actualize();
//STRIP001 /*?*/             DBG_TRACE( "SfxSplitWindow::InsertWindow_Impl - registering empty Splitwindow" );
//STRIP001 /*?*/ 			pWorkWin->RegisterChild_Impl( *GetSplitWindow(), eAlign, TRUE )->nVisible = CHILD_VISIBLE;
//STRIP001 /*?*/ 			pWorkWin->ArrangeChilds_Impl();
//STRIP001 /*?*/ 			if ( bFadeIn )
//STRIP001 /*?*/ 				FadeIn();
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			BOOL bFadeIn = ( pEmptyWin->nState & 2 ) != 0;
/*N*/ 			pEmptyWin->bFadeIn = FALSE;
/*N*/ 			pEmptyWin->Actualize();
/*N*/ #ifdef DBG_UTIL
/*N*/             if ( !bPinned || !pEmptyWin->bFadeIn )
/*N*/             {
/*N*/                 DBG_TRACE( "SfxSplitWindow::InsertWindow_Impl - registering empty Splitwindow" );
/*N*/             }
/*N*/             else
/*N*/             {
/*N*/                 DBG_TRACE( "SfxSplitWindow::InsertWindow_Impl - registering real Splitwindow" );
/*N*/             }
/*N*/ #endif
/*N*/ 			pWorkWin->RegisterChild_Impl( *GetSplitWindow(), eAlign, TRUE )->nVisible = CHILD_VISIBLE;
/*N*/ 			pWorkWin->ArrangeChilds_Impl();
/*N*/ 			if ( bFadeIn )
/*N*/ 				FadeIn();
/*N*/ 		}
/*N*/ 
/*N*/ 		pWorkWin->ShowChilds_Impl();
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( bUpdateMode )
/*N*/ 		SetUpdateMode( TRUE );
/*N*/ 	bLocked = FALSE;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxSplitWindow::RemoveWindow( SfxDockingWindow* pDockWin, BOOL bHide )

/*  [Beschreibung]

	Entfernt ein DockingWindow. Wenn es das letzte war, wird das SplitWindow
	gehidet.
*/
/*N*/ {
/*N*/ 	USHORT nSet = GetSet( pDockWin->GetType() );
/*N*/ 
/*N*/ 	// Splitwindows werden im SFX einmal angelegt und nach dem Entfernen
/*N*/ 	// des letzten DockingWindows unsichtbar gemacht.
/*N*/ 	if ( GetItemCount( nSet ) == 1 && GetItemCount( 0 ) == 1 )
/*N*/ 	{
/*N*/ 		// Das Neuarrangieren am WorkWindow wird vom SfxDockingwindow
/*N*/ 		// veranla\st!
/*N*/ 		Hide();
/*N*/ 		pEmptyWin->aTimer.Stop();
/*N*/         USHORT nRealState = pEmptyWin->nState;
/*N*/ 		FadeOut_Impl();
/*N*/ 		pEmptyWin->Hide();
/*N*/ #ifdef DBG_UTIL
/*N*/         if ( !bPinned || !pEmptyWin->bFadeIn )
/*N*/         {
/*N*/             DBG_TRACE( "SfxSplitWindow::RemoveWindow - releasing empty Splitwindow" );
/*N*/         }
/*N*/         else
/*N*/         {
/*N*/             DBG_TRACE( "SfxSplitWindow::RemoveWindow - releasing real Splitwindow" );
/*N*/         }
/*N*/ #endif
/*N*/ 		pWorkWin->ReleaseChild_Impl( *GetSplitWindow() );
/*N*/ 		pEmptyWin->nState = nRealState;
/*N*/ 		pWorkWin->ArrangeAutoHideWindows( this );
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxDock_Impl *pDock=0;
/*N*/ 	USHORT nCount = pDockArr->Count();
/*N*/ 	BOOL bFound = FALSE;
/*N*/ 	for ( USHORT n=0; n<nCount; n++ )
/*N*/ 	{
/*N*/ 		pDock = (*pDockArr)[n];
/*N*/ 		if ( pDock->nType == pDockWin->GetType() )
/*N*/ 		{
/*N*/ 			pDock->pWin = 0;
/*N*/ 			pDock->bHide = bHide;
/*N*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// Fenster removen, und wenn es das letzte der Zeile war, auch die Zeile
/*N*/ 	// ( Zeile = ItemSet )
/*N*/ 	BOOL bUpdateMode = IsUpdateMode();
/*N*/ 	if ( bUpdateMode )
/*?*/ 		SetUpdateMode( FALSE );
/*N*/ 	bLocked = TRUE;
/*N*/ 
/*N*/ 	RemoveItem( pDockWin->GetType() );
/*N*/ 
/*N*/ 	if ( nSet && !GetItemCount( nSet ) )
/*N*/ 		RemoveItem( nSet );
/*N*/ 
/*N*/ 	if ( bUpdateMode )
/*?*/ 		SetUpdateMode( TRUE );
/*N*/ 	bLocked = FALSE;
/*N*/ };

//-------------------------------------------------------------------------

//STRIP001 BOOL SfxSplitWindow::GetWindowPos( const SfxDockingWindow* pWindow,
//STRIP001 										USHORT& rLine, USHORT& rPos ) const
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Liefert die Id des Itemsets und die des Items f"ur das "ubergebene
//STRIP001 	DockingWindow in der alten Zeilen/Spalten-Bezeichnung zur"uck.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	USHORT nSet = GetSet ( pWindow->GetType() );
//STRIP001 	if ( nSet == SPLITWINDOW_ITEM_NOTFOUND )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	rPos  = GetItemPos( pWindow->GetType(), nSet );
//STRIP001 	rLine = GetItemPos( nSet );
//STRIP001 	return TRUE;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 BOOL SfxSplitWindow::GetWindowPos( const Point& rTestPos,
//STRIP001 									  USHORT& rLine, USHORT& rPos ) const
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Liefert die Id des Itemsets und die des Items f"ur das DockingWindow
//STRIP001 	an der "ubergebenen Position in der alten Zeilen/Spalten-Bezeichnung
//STRIP001 	zur"uck.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	USHORT nId = GetItemId( rTestPos );
//STRIP001 	if ( nId == 0 )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	USHORT nSet = GetSet ( nId );
//STRIP001 	rPos  = GetItemPos( nId, nSet );
//STRIP001 	rLine = GetItemPos( nSet );
//STRIP001 	return TRUE;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 USHORT SfxSplitWindow::GetLineCount() const
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Liefert die Zeilenzahl = Zahl der Sub-Itemsets im Root-Set.
//STRIP001 */
//STRIP001 {
//STRIP001 	return GetItemCount( 0 );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 long SfxSplitWindow::GetLineSize( USHORT nLine ) const
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Liefert die "Zeilenh"ohe" des nLine-ten Itemsets.
//STRIP001 */
//STRIP001 {
//STRIP001 	USHORT nId = GetItemId( nLine );
//STRIP001 	return GetItemSize( nId );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 USHORT SfxSplitWindow::GetWindowCount( USHORT nLine ) const
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Liefert die
//STRIP001 */
//STRIP001 {
//STRIP001 	USHORT nId = GetItemId( nLine );
//STRIP001 	return GetItemCount( nId );
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ USHORT SfxSplitWindow::GetWindowCount() const

/*  [Beschreibung]

	Liefert die Gesamtzahl aller Fenstert
*/
/*N*/ {
/*N*/ 	return GetItemCount( 0 );
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxSplitWindow::Command( const CommandEvent& rCEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 #ifdef TF_AUTOSHOW_ON_MOUSEMOVE
//STRIP001 	if ( rCEvt.GetCommand() != COMMAND_CONTEXTMENU )
//STRIP001 		return;
//STRIP001 
//STRIP001 	SfxPopupMenuManager aPop( SfxResId( RID_AUTOHIDE ), pWorkWin->GetBindings() );
//STRIP001 	aPop.StartInsert();
//STRIP001 
//STRIP001 	if ( !bPinned )
//STRIP001 	{
//STRIP001 		aPop.RemoveItem( 0 );
//STRIP001 		String aText( SfxResId(RID_AUTOHIDE ) );
//STRIP001 		aPop.InsertItem( SID_AUTOHIDE, aText, MIB_CHECKABLE ) ;
//STRIP001 	}
//STRIP001 
//STRIP001 	aPop.InsertSeparator();
//STRIP001 
//STRIP001 	USHORT nCount = pDockArr->Count();
//STRIP001 	SfxSlotPool &rSlotPool = SFX_SLOTPOOL();
//STRIP001 	for ( USHORT n=0; n<nCount; n++ )
//STRIP001 	{
//STRIP001 		SfxDock_Impl *pD = (*pDockArr)[n];
//STRIP001 		if ( pD->pWin || pD->bHide )
//STRIP001 		{
//STRIP001 			String aHelpText;
//STRIP001 			String aMenuText = rSlotPool.GetSlotName_Impl( pD->nType, &aHelpText );
//STRIP001 			aPop.InsertItem( pD->nType, aMenuText, MIB_CHECKABLE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aPop.EndInsert();
//STRIP001 
//STRIP001 	if ( aPop.Execute( GetPointerPosPixel() ) == SID_AUTOHIDE )
//STRIP001 	{
//STRIP001 		// ChildWindows neu anordnen
//STRIP001 		SetPinned_Impl( !bPinned );
//STRIP001 		if ( bPinned && pWorkWin->IsAutoHideMode( this ) )
//STRIP001 			pWorkWin->ArrangeAutoHideWindows( this );
//STRIP001 		pWorkWin->ArrangeChilds_Impl();
//STRIP001 		pWorkWin->ShowChilds_Impl();
//STRIP001 	}
//STRIP001 #else
//STRIP001 	SplitWindow::Command( rCEvt );
//STRIP001 #endif
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ IMPL_LINK( SfxSplitWindow, TimerHdl, Timer*, pTimer)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( pTimer )
//STRIP001 		pTimer->Stop();
//STRIP001 
//STRIP001 	if ( CursorIsOverRect( FALSE ) || !pTimer )
//STRIP001 	{
//STRIP001 		// Wenn der Mauszeiger innerhalb des Fensters liegt, SplitWindow anzeigen
//STRIP001 		// und Timer zum Schlie\sen aufsetzen
//STRIP001 		pEmptyWin->bAutoHide = TRUE;
//STRIP001 		if ( !IsVisible() )
//STRIP001 			pEmptyWin->FadeIn();
//STRIP001 
//STRIP001 		pEmptyWin->aLastPos = GetPointerPosPixel();
//STRIP001 		pEmptyWin->aTimer.Start();
//STRIP001 	}
//STRIP001 	else if ( pEmptyWin->bAutoHide )
//STRIP001 	{
//STRIP001 		if ( GetPointerPosPixel() != pEmptyWin->aLastPos )
//STRIP001 		{
//STRIP001 			// Die Maus wurd innerhalb der Timerlaugzeit bewegt, also erst einmal
//STRIP001 			// nichts tun
//STRIP001 			pEmptyWin->aLastPos = GetPointerPosPixel();
//STRIP001 			pEmptyWin->aTimer.Start();
//STRIP001 			return 0L;
//STRIP001 		}
//STRIP001 
//STRIP001 		// Speziell f"ur TF_AUTOSHOW_ON_MOUSEMOVE :
//STRIP001 		// Wenn das Fenster nicht sichtbar ist, gibt es nichts zu tun
//STRIP001 		// (Benutzer ist einfach mit der Maus "uber pEmptyWin gefahren)
//STRIP001 		if ( IsVisible() )
//STRIP001 		{
//STRIP001 			pEmptyWin->bEndAutoHide = FALSE;
//STRIP001 			if ( !Application::IsInModalMode() &&
//STRIP001 				  !PopupMenu::IsInExecute() &&
//STRIP001 				  !pEmptyWin->bSplit && !HasChildPathFocus( TRUE ) )
//STRIP001 			{
//STRIP001 				// W"ahrend ein modaler Dialog oder ein Popupmenu offen sind
//STRIP001 				// oder w"ahrend des Splittens auf keinen Fall zumachen; auch
//STRIP001 				// solange eines der Children den Focus hat, bleibt das
//STRIP001 				// das Fenster offen
//STRIP001 				pEmptyWin->bEndAutoHide = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pEmptyWin->bEndAutoHide )
//STRIP001 			{
//STRIP001 				// Von mir aus kann Schlu\s sein mit AutoShow
//STRIP001 				// Aber vielleicht will noch ein anderes SfxSplitWindow offen bleiben,
//STRIP001 				// dann bleiben auch alle anderen offen
//STRIP001 				if ( !pWorkWin->IsAutoHideMode( this ) )
//STRIP001 				{
//STRIP001 					FadeOut_Impl();
//STRIP001 					pWorkWin->ArrangeAutoHideWindows( this );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pEmptyWin->aLastPos = GetPointerPosPixel();
//STRIP001 					pEmptyWin->aTimer.Start();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pEmptyWin->aLastPos = GetPointerPosPixel();
//STRIP001 				pEmptyWin->aTimer.Start();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
/*N*/ 	return 0L;
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 BOOL SfxSplitWindow::CursorIsOverRect( BOOL bForceAdding ) const
//STRIP001 {
//STRIP001 	BOOL bVisible = IsVisible();
//STRIP001 
//STRIP001 	// Auch das kollabierte SplitWindow ber"ucksichtigen
//STRIP001 	Point aPos = pEmptyWin->GetParent()->OutputToScreenPixel( pEmptyWin->GetPosPixel() );
//STRIP001 	Size aSize = pEmptyWin->GetSizePixel();
//STRIP001 
//STRIP001 	if ( bForceAdding )
//STRIP001 	{
//STRIP001 		// Um +/- ein paar Pixel erweitern, sonst ist es zu nerv"os
//STRIP001 		aPos.X() -= nPixel;
//STRIP001 		aPos.Y() -= nPixel;
//STRIP001 		aSize.Width() += 2 * nPixel;
//STRIP001 		aSize.Height() += 2 * nPixel;
//STRIP001 	}
//STRIP001 
//STRIP001 	Rectangle aRect( aPos, aSize );
//STRIP001 
//STRIP001 	if ( bVisible )
//STRIP001 	{
//STRIP001 		Point aPos = GetPosPixel();
//STRIP001 		Size aSize = GetSizePixel();
//STRIP001 
//STRIP001 		// Um +/- ein paar Pixel erweitern, sonst ist es zu nerv"os
//STRIP001 		aPos.X() -= nPixel;
//STRIP001 		aPos.Y() -= nPixel;
//STRIP001 		aSize.Width() += 2 * nPixel;
//STRIP001 		aSize.Height() += 2 * nPixel;
//STRIP001 
//STRIP001 		Rectangle aVisRect( aPos, aSize );
//STRIP001 		aRect = aRect.GetUnion( aVisRect );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aRect.IsInside( OutputToScreenPixel( ((Window*)this)->GetPointerPosPixel() ) ) )
//STRIP001 		return TRUE;
//STRIP001 	return FALSE;
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ SplitWindow* SfxSplitWindow::GetSplitWindow()
/*N*/ {
/*N*/ 	if ( !bPinned || !pEmptyWin->bFadeIn )
/*N*/ 		return pEmptyWin;
/*N*/ 	return this;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ BOOL SfxSplitWindow::IsFadeIn() const
/*N*/ {
/*N*/ 	return pEmptyWin->bFadeIn;
/*N*/ }

/*N*/ BOOL SfxSplitWindow::IsAutoHide( BOOL bSelf ) const
/*N*/ {
/*N*/ 	return bSelf ? pEmptyWin->bAutoHide && !pEmptyWin->bEndAutoHide : pEmptyWin->bAutoHide;
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 void SfxSplitWindow::SetPinned_Impl( BOOL bOn )
//STRIP001 {
//STRIP001 	if ( bPinned == bOn )
//STRIP001 		return;
//STRIP001 
//STRIP001 	bPinned = bOn;
//STRIP001 	if ( GetItemCount( 0 ) == 0 )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( !bOn )
//STRIP001 	{
//STRIP001 		pEmptyWin->nState |= 1;
//STRIP001 		if ( pEmptyWin->bFadeIn )
//STRIP001 		{
//STRIP001 			// Ersatzfenster anmelden
//STRIP001             DBG_TRACE( "SfxSplitWindow::SetPinned_Impl - releasing real Splitwindow" );
//STRIP001 			pWorkWin->ReleaseChild_Impl( *this );
//STRIP001 			Hide();
//STRIP001 			pEmptyWin->Actualize();
//STRIP001             DBG_TRACE( "SfxSplitWindow::SetPinned_Impl - registering empty Splitwindow" );
//STRIP001 			pWorkWin->RegisterChild_Impl( *pEmptyWin, eAlign, TRUE )->nVisible = CHILD_VISIBLE;
//STRIP001 		}
//STRIP001 
//STRIP001 		Point aPos( GetPosPixel() );
//STRIP001 		aPos = GetParent()->OutputToScreenPixel( aPos );
//STRIP001 		SetFloatingPos( aPos );
//STRIP001 		SetFloatingMode( TRUE );
//STRIP001 		GetFloatingWindow()->SetOutputSizePixel( GetOutputSizePixel() );
//STRIP001 
//STRIP001 		if ( pEmptyWin->bFadeIn )
//STRIP001 			Show();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pEmptyWin->nState &= ~1;
//STRIP001 		SetOutputSizePixel( GetFloatingWindow()->GetOutputSizePixel() );
//STRIP001 		SetFloatingMode( FALSE );
//STRIP001 
//STRIP001 		if ( pEmptyWin->bFadeIn )
//STRIP001 		{
//STRIP001 			// Ersatzfenster abmelden
//STRIP001             DBG_TRACE( "SfxSplitWindow::SetPinned_Impl - releasing empty Splitwindow" );
//STRIP001 			pWorkWin->ReleaseChild_Impl( *pEmptyWin );
//STRIP001 			pEmptyWin->Hide();
//STRIP001             DBG_TRACE( "SfxSplitWindow::SetPinned_Impl - registering real Splitwindow" );
//STRIP001 			pWorkWin->RegisterChild_Impl( *this, eAlign, TRUE )->nVisible = CHILD_VISIBLE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SetAutoHideState( !bPinned );
//STRIP001 	pEmptyWin->SetAutoHideState( !bPinned );
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ void SfxSplitWindow::SetFadeIn_Impl( BOOL bOn )
/*N*/ {
/*N*/ 	if ( bOn == pEmptyWin->bFadeIn )
/*N*/ 		return;
/*N*/ 
/*N*/ 	if ( GetItemCount( 0 ) == 0 )
/*N*/ 		return;
/*N*/ 
/*N*/ 	pEmptyWin->bFadeIn = bOn;
/*N*/ 	if ( bOn )
/*N*/ 	{
/*N*/ 		pEmptyWin->nState |= 2;
/*N*/ 		if ( IsFloatingMode() )
/*N*/ 		{
/*N*/ 			// FloatingWindow ist nicht sichtbar, also anzeigen
/*?*/ 			pWorkWin->ArrangeAutoHideWindows( this );
/*?*/ 			Show();
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/             DBG_TRACE( "SfxSplitWindow::SetFadeIn_Impl - releasing empty Splitwindow" );
/*N*/ 			pWorkWin->ReleaseChild_Impl( *pEmptyWin );
/*N*/ 			pEmptyWin->Hide();
/*N*/             DBG_TRACE( "SfxSplitWindow::SetFadeIn_Impl - registering real Splitwindow" );
/*N*/ 			pWorkWin->RegisterChild_Impl( *this, eAlign, TRUE )->nVisible = CHILD_VISIBLE;
/*N*/ 			pWorkWin->ArrangeChilds_Impl();
/*N*/ 			pWorkWin->ShowChilds_Impl();
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		pEmptyWin->bAutoHide = FALSE;
/*N*/ 		pEmptyWin->nState &= ~2;
/*N*/ 		if ( !IsFloatingMode() )
/*N*/ 		{
/*N*/ 			// Das Fenster "schwebt" nicht, soll aber ausgeblendet werden,
/*N*/             DBG_TRACE( "SfxSplitWindow::SetFadeIn_Impl - releasing real Splitwindow" );
/*N*/ 			pWorkWin->ReleaseChild_Impl( *this );
/*N*/ 			Hide();
/*N*/ 			pEmptyWin->Actualize();
/*N*/             DBG_TRACE( "SfxSplitWindow::SetFadeIn_Impl - registering empty Splitwindow" );
/*N*/ 			pWorkWin->RegisterChild_Impl( *pEmptyWin, eAlign, TRUE )->nVisible = CHILD_VISIBLE;
/*N*/ 			pWorkWin->ArrangeChilds_Impl();
/*N*/ 			pWorkWin->ShowChilds_Impl();
/*N*/ 			pWorkWin->ArrangeAutoHideWindows( this );
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*?*/ 			Hide();
/*?*/ 			pWorkWin->ArrangeAutoHideWindows( this );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*?*/ void SfxSplitWindow::AutoHide()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// Wenn dieser Handler am "echten" SplitWindow aufgerufen wird, ist es
//STRIP001 	// entweder angedockt und soll "schwebend" angezeigt werden oder umgekehrt
//STRIP001 	if ( !bPinned )
//STRIP001 	{
//STRIP001 		// Es "schwebt", also wieder andocken
//STRIP001 		SetPinned_Impl( TRUE );
//STRIP001 		pWorkWin->ArrangeChilds_Impl();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// In den "Schwebezustand" bringen
//STRIP001 		SetPinned_Impl( FALSE );
//STRIP001 		pWorkWin->ArrangeChilds_Impl();
//STRIP001 		pWorkWin->ArrangeAutoHideWindows( this );
//STRIP001 	}
//STRIP001 
//STRIP001 	pWorkWin->ShowChilds_Impl();
//STRIP001 	SaveConfig_Impl();
/*?*/ }

/*N*/ void SfxSplitWindow::FadeOut_Impl()
/*N*/ {
/*N*/     if ( pEmptyWin->aTimer.IsActive() )
/*N*/     {
/*?*/         pEmptyWin->bAutoHide = FALSE;
/*?*/         pEmptyWin->aTimer.Stop();
/*N*/     }
/*N*/ 
/*N*/ 	SetFadeIn_Impl( FALSE );
/*N*/ 	Show_Impl();
/*N*/ }

/*?*/ void SfxSplitWindow::FadeOut()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	FadeOut_Impl();
//STRIP001 	SaveConfig_Impl();
/*?*/ }

/*N*/ void SfxSplitWindow::FadeIn()
/*N*/ {
/*N*/ 	SetFadeIn_Impl( TRUE );
/*N*/ 	Show_Impl();
/*N*/ }

/*N*/ void SfxSplitWindow::Show_Impl()
/*N*/ {
/*N*/ 	USHORT nCount = pDockArr->Count();
/*N*/ 	for ( USHORT n=0; n<nCount; n++ )
/*N*/ 	{
/*N*/ 		SfxDock_Impl *pDock = (*pDockArr)[n];
/*N*/ 		if ( pDock->pWin )
/*N*/ 			pDock->pWin->FadeIn( pEmptyWin->bFadeIn );
/*N*/ 	}
/*N*/ }
/*
void SfxSplitWindow::Pin_Impl( BOOL bPin )
{
	if ( bPinned != bPin )
		AutoHide();
}
*/
//STRIP001 BOOL SfxSplitWindow::ActivateNextChild_Impl( BOOL bForward )
//STRIP001 {
//STRIP001 	// Wenn kein pActive, auf erstes bzw. letztes Fenster gehen ( bei !bForward wird erst in der loop dekrementiert )
//STRIP001 	USHORT nCount = pDockArr->Count();
//STRIP001 	USHORT n = bForward ? 0 : nCount;
//STRIP001 
//STRIP001 	// Wenn Focus innerhalb, dann ein Fenster vor oder zur"uck, wenn m"oglich
//STRIP001 	if ( pActive )
//STRIP001 	{
//STRIP001 		// Aktives Fenster ermitteln
//STRIP001 		for ( n=0; n<nCount; n++ )
//STRIP001 		{
//STRIP001 			SfxDock_Impl *pD = (*pDockArr)[n];
//STRIP001 			if ( pD->pWin && pD->pWin->HasChildPathFocus() )
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bForward )
//STRIP001 			// ein Fenster weiter ( wenn dann n>nCount, wird die Schleife unten gar nicht durchlaufen )
//STRIP001 			n++;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bForward )
//STRIP001 	{
//STRIP001 		// N"achstes Fenster suchen
//STRIP001 		for ( USHORT nNext=n; nNext<nCount; nNext++ )
//STRIP001 		{
//STRIP001 			SfxDock_Impl *pD = (*pDockArr)[nNext];
//STRIP001 			if ( pD->pWin )
//STRIP001 			{
//STRIP001 				pD->pWin->GrabFocus();
//STRIP001 				return TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Vorheriges Fenster suchen
//STRIP001 		for ( USHORT nNext=n; nNext--; )
//STRIP001 		{
//STRIP001 			SfxDock_Impl *pD = (*pDockArr)[nNext];
//STRIP001 			if ( pD->pWin )
//STRIP001 			{
//STRIP001 				pD->pWin->GrabFocus();
//STRIP001 				return TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }

/*N*/ void SfxSplitWindow::SetActiveWindow_Impl( SfxDockingWindow* pWin )
/*N*/ {
/*N*/ 	pActive = pWin;
/*N*/ 	pWorkWin->SetActiveChild_Impl( this );
/*N*/ }


}
