/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_backgrnd.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:34:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <bf_sfx2/objsh.hxx>
#endif
#ifndef _SFXDOCFILE_HXX
#include <bf_sfx2/docfile.hxx>
#endif
#ifndef _WALLITEM_HXX
#include <svtools/wallitem.hxx>
#endif
#ifndef _CNTWALL_HXX
#include <svtools/cntwall.hxx>
#endif
#ifndef _CNTIDS_HRC
#include <bf_sfx2/cntids.hrc>
#endif
#pragma hdrstop

#define _SVX_BACKGRND_CXX

#include "dialogs.hrc"
#include "backgrnd.hrc"
#include "svxitems.hrc"

#define ITEMID_BRUSH		0
#define ITEMID_COLOR_TABLE	0

// Tabellenhintergrund
#define TBL_DEST_CELL 	0
#define TBL_DEST_ROW 	1
#define TBL_DEST_TBL	2

#include "brshitem.hxx"
#include "backgrnd.hxx"

#include "xtable.hxx"
#include "opengrf.hxx"
#include "impgrf.hxx"
#include "svxerr.hxx"
#include "drawitem.hxx"
#include "dialmgr.hxx"
#include "htmlmode.hxx"
#ifndef _SVT_CONTROLDIMS_HRC_
#include <svtools/controldims.hrc>
#endif
#include "so3/staticbaseurl.hxx"
namespace binfilter {

using namespace ::com::sun::star;
//STRIP001 // static ----------------------------------------------------------------
//STRIP001 
//STRIP001 static USHORT pRanges[] =
//STRIP001 {
//STRIP001 	SID_VIEW_FLD_PIC, SID_VIEW_FLD_PIC,
//STRIP001 	SID_ATTR_BRUSH, SID_ATTR_BRUSH,
//STRIP001 	SID_ATTR_BRUSH_CHAR, SID_ATTR_BRUSH_CHAR,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 struct SvxBackgroundTable_Impl
//STRIP001 {
//STRIP001 	SvxBrushItem*	pCellBrush;
//STRIP001 	SvxBrushItem*	pRowBrush;
//STRIP001 	SvxBrushItem*	pTableBrush;
//STRIP001     USHORT          nCellWhich;
//STRIP001     USHORT          nRowWhich;
//STRIP001     USHORT          nTableWhich;
//STRIP001     USHORT          nActPos;
//STRIP001 
//STRIP001 	SvxBackgroundTable_Impl() :
//STRIP001         pCellBrush(NULL), pRowBrush(NULL), pTableBrush(NULL),
//STRIP001         nCellWhich(0), nRowWhich(0), nTableWhich(0) {}
//STRIP001 };
//STRIP001 
//STRIP001 struct SvxBackgroundPara_Impl
//STRIP001 {
//STRIP001 	SvxBrushItem*	pParaBrush;
//STRIP001 	SvxBrushItem*	pCharBrush;
//STRIP001 
//STRIP001 	USHORT 			nActPos;
//STRIP001 
//STRIP001 	SvxBackgroundPara_Impl() :
//STRIP001 		pParaBrush(NULL), pCharBrush(NULL) {}
//STRIP001 };
//STRIP001 
//STRIP001 struct SvxBackgroundPage_Impl
//STRIP001 {
//STRIP001 	Timer*          pLoadTimer;
//STRIP001 	BOOL            bIsImportDlgInExecute;
//STRIP001 
//STRIP001 	SvxBackgroundPage_Impl() :
//STRIP001 		pLoadTimer(NULL), bIsImportDlgInExecute(FALSE) {}
//STRIP001 };
//STRIP001 /* -----------------------------15.08.2002 12:21------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 inline BYTE lcl_PercentToTransparency(long nPercent)
//STRIP001 {
//STRIP001     //0xff must not be returned!
//STRIP001     return BYTE(nPercent ? (50 + 0xfe * nPercent) / 100 : 0);
//STRIP001 }
//STRIP001 inline BYTE lcl_TransparencyToPercent(BYTE nTrans)
//STRIP001 {
//STRIP001     return (nTrans * 100 + 127) / 254;
//STRIP001 }
//STRIP001 void lcl_SetTransparency(SvxBrushItem& rBrush, long nTransparency)
//STRIP001 {
//STRIP001     uno::Any aTransparency;
//STRIP001     aTransparency <<= (sal_Int8)nTransparency;
//STRIP001     rBrush.PutValue(aTransparency, MID_GRAPHIC_TRANSPARENCY);
//STRIP001 }
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 USHORT GetItemId_Impl( ValueSet& rValueSet, const Color& rCol )
//STRIP001 {
//STRIP001 	BOOL	bFound = FALSE;
//STRIP001 	USHORT	nCount = rValueSet.GetItemCount();
//STRIP001 	USHORT	n	   = 1;
//STRIP001 
//STRIP001 	while ( !bFound && n <= nCount )
//STRIP001 	{
//STRIP001 		Color aValCol = rValueSet.GetItemColor(n);
//STRIP001 
//STRIP001 		bFound = (   aValCol.GetRed()   == rCol.GetRed()
//STRIP001 				  && aValCol.GetGreen() == rCol.GetGreen()
//STRIP001 				  && aValCol.GetBlue()  == rCol.GetBlue() );
//STRIP001 
//STRIP001 		if ( !bFound )
//STRIP001 			n++;
//STRIP001 	}
//STRIP001 	return bFound ? n : 0;
//STRIP001 }
//STRIP001 
//STRIP001 // class BackgroundPreview -----------------------------------------------
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Vorschaufenster f"ur Brush oder Bitmap
//STRIP001 */
//STRIP001 
//STRIP001 class BackgroundPreviewImpl : public Window
//STRIP001 {
//STRIP001 public:
//STRIP001 	BackgroundPreviewImpl( Window* pParent,
//STRIP001 						   const ResId& rResId, BOOL bIsBmpPreview );
//STRIP001 	~BackgroundPreviewImpl();
//STRIP001 
//STRIP001 	void			NotifyChange( const Color&  rColor );
//STRIP001 	void			NotifyChange( const Bitmap* pBitmap );
//STRIP001 
//STRIP001 protected:
//STRIP001 	virtual void	Paint( const Rectangle& rRect );
//STRIP001     virtual void    DataChanged( const DataChangedEvent& rDCEvt );
//STRIP001 
//STRIP001 private:
//STRIP001 	const BOOL		bIsBmp;
//STRIP001 	Bitmap*			pBitmap;
//STRIP001 	Point			aDrawPos;
//STRIP001 	Size			aDrawSize;
//STRIP001 	Rectangle		aDrawRect;
//STRIP001     BYTE            nTransparency;
//STRIP001 };
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 BackgroundPreviewImpl::BackgroundPreviewImpl
//STRIP001 (
//STRIP001 	Window* pParent,
//STRIP001 	const ResId& rResId,
//STRIP001 	BOOL bIsBmpPreview
//STRIP001 ) :
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 	Window( pParent, rResId ),
//STRIP001 
//STRIP001 	bIsBmp	 ( bIsBmpPreview ),
//STRIP001 	pBitmap	 ( NULL ),
//STRIP001     aDrawRect( Point(0,0), GetOutputSizePixel() ),
//STRIP001     nTransparency(0)
//STRIP001 
//STRIP001 {
//STRIP001     SetBorderStyle(WINDOW_BORDER_MONO);
//STRIP001     Paint( aDrawRect );
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 BackgroundPreviewImpl::~BackgroundPreviewImpl()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	delete pBitmap;
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 void BackgroundPreviewImpl::NotifyChange( const Color& rColor )
//STRIP001 {
//STRIP001 	if ( !bIsBmp )
//STRIP001 	{
//STRIP001 		const static Color aTranspCol( COL_TRANSPARENT );
//STRIP001 
//STRIP001         nTransparency = lcl_TransparencyToPercent( rColor.GetTransparency() );
//STRIP001 
//STRIP001 		SetFillColor( rColor == aTranspCol ? GetSettings().GetStyleSettings().GetFieldColor() : (Color) rColor.GetRGBColor() );
//STRIP001         Paint( aDrawRect );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 void BackgroundPreviewImpl::NotifyChange( const Bitmap* pNewBitmap )
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001     if ( bIsBmp && (pNewBitmap || pBitmap) )
//STRIP001 	{
//STRIP001         if ( pNewBitmap && pBitmap )
//STRIP001 			*pBitmap = *pNewBitmap;
//STRIP001 		else if ( pNewBitmap && !pBitmap )
//STRIP001 			pBitmap = new Bitmap( *pNewBitmap );
//STRIP001 		else if ( !pNewBitmap )
//STRIP001 			DELETEZ( pBitmap );
//STRIP001 
//STRIP001 		if ( pBitmap )
//STRIP001 		{
//STRIP001 			Size aSize = GetOutputSizePixel();
//STRIP001 			// InnerSize == Size without one pixel border
//STRIP001 			Size aInnerSize = aSize;
//STRIP001 			aInnerSize.Width() -= 2;
//STRIP001 			aInnerSize.Height() -= 2;
//STRIP001 			aDrawSize = pBitmap->GetSizePixel();
//STRIP001 
//STRIP001 			// bitmap bigger than preview window?
//STRIP001 			if ( aDrawSize.Width() > aInnerSize.Width() )
//STRIP001 			{
//STRIP001 				aDrawSize.Height() = aDrawSize.Height() * aInnerSize.Width() / aDrawSize.Width();
//STRIP001 				if ( aDrawSize.Height() > aInnerSize.Height() )
//STRIP001 				{
//STRIP001 					aDrawSize.Width() = aDrawSize.Height();
//STRIP001 					aDrawSize.Height() = aInnerSize.Height();
//STRIP001 				}
//STRIP001 				else
//STRIP001 					aDrawSize.Width() = aInnerSize.Width();
//STRIP001 			}
//STRIP001 			else if ( aDrawSize.Height() > aInnerSize.Height() )
//STRIP001 			{
//STRIP001 				aDrawSize.Width() = aDrawSize.Width() * aInnerSize.Height() / aDrawSize.Height();
//STRIP001 				if ( aDrawSize.Width() > aInnerSize.Width() )
//STRIP001 				{
//STRIP001 					aDrawSize.Height() = aDrawSize.Width();
//STRIP001 					aDrawSize.Width() = aInnerSize.Width();
//STRIP001 				}
//STRIP001 				else
//STRIP001 					aDrawSize.Height() = aInnerSize.Height();
//STRIP001 			}
//STRIP001 
//STRIP001 			aDrawPos.X() = (aSize.Width()  - aDrawSize.Width())  / 2;
//STRIP001 			aDrawPos.Y() = (aSize.Height() - aDrawSize.Height()) / 2;
//STRIP001 		}
//STRIP001 		Invalidate( aDrawRect );
//STRIP001 		Update();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 void BackgroundPreviewImpl::Paint( const Rectangle& rRect )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001     const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001     SetBackground(Wallpaper(rStyleSettings.GetWindowColor()));
//STRIP001     SetLineColor( rStyleSettings.GetFieldTextColor() );
//STRIP001     if(bIsBmp)
//STRIP001         SetFillColor( Color(COL_TRANSPARENT) );
//STRIP001     DrawRect( aDrawRect );
//STRIP001 	if ( bIsBmp )
//STRIP001 	{
//STRIP001 		if ( pBitmap )
//STRIP001 			DrawBitmap( aDrawPos, aDrawSize, *pBitmap );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Size aSize = GetOutputSizePixel();
//STRIP001             DrawLine( Point(0,0),               Point(aSize.Width(),aSize.Height()) );
//STRIP001 			DrawLine( Point(0,aSize.Height()),	Point(aSize.Width(),0) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------------------27.02.2002 11:07------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void BackgroundPreviewImpl::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001         Invalidate();
//STRIP001     }
//STRIP001     Window::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxBackgroundTabPage --------------------------------------------
//STRIP001 
//STRIP001 #define HDL(hdl) LINK(this,SvxBackgroundTabPage,hdl)
//STRIP001 
//STRIP001 SvxBackgroundTabPage::SvxBackgroundTabPage( Window* pParent,
//STRIP001 											const SfxItemSet& rCoreSet ) :
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 	SvxTabPage( pParent, SVX_RES( RID_SVXPAGE_BACKGROUND ), rCoreSet ),
//STRIP001 
//STRIP001 	aBorderWin			( this, ResId(CT_BORDER) ),
//STRIP001 	aBackgroundColorSet ( &aBorderWin, ResId( SET_BGDCOLOR ) ),
//STRIP001 	aBackgroundColorBox ( this, ResId( GB_BGDCOLOR ) ),
//STRIP001 	pPreviewWin1        ( new BackgroundPreviewImpl(
//STRIP001 							this, ResId( WIN_PREVIEW1 ), FALSE ) ),
//STRIP001     aColTransFT         ( this, ResId( FT_COL_TRANS ) ),
//STRIP001     aColTransMF         ( this, ResId( MF_COL_TRANS ) ),
//STRIP001 	aBtnBrowse	        ( this, ResId( BTN_BROWSE ) ),
//STRIP001 	aBtnLink	        ( this, ResId( BTN_LINK ) ),
//STRIP001 	aBtnPreview	        ( this, ResId( BTN_PREVIEW ) ),
//STRIP001 	aFtFile		        ( this, ResId( FT_FILE ) ),
//STRIP001 	aGbFile		        ( this, ResId( GB_FILE ) ),
//STRIP001 	aBtnPosition        ( this, ResId( BTN_POSITION ) ),
//STRIP001 	aBtnArea	        ( this, ResId( BTN_AREA ) ),
//STRIP001 	aBtnTile	        ( this, ResId( BTN_TILE ) ),
//STRIP001 	aWndPosition		( this, ResId( WND_POSITION ), RP_MM ),
//STRIP001 	aGbPosition			( this, ResId( GB_POSITION ) ),
//STRIP001     aGraphTransFL       ( this, ResId( FL_GRAPH_TRANS ) ),
//STRIP001     aGraphTransMF       ( this, ResId( MF_GRAPH_TRANS ) ),
//STRIP001     pPreviewWin2        ( new BackgroundPreviewImpl(
//STRIP001 							this, ResId( WIN_PREVIEW2 ), TRUE ) ),
//STRIP001 	aSelectTxt			( this, ResId( FT_SELECTOR ) ),
//STRIP001 	aLbSelect			( this, ResId( LB_SELECTOR ) ),
//STRIP001 	aTblDesc            ( this, ResId( FT_TBL_DESC ) ),
//STRIP001 	aTblLBox            ( this, ResId( LB_TBL_BOX ) ),
//STRIP001 	aParaLBox           ( this, ResId( LB_PARA_BOX ) ),
//STRIP001 	aStrBrowse			( ResId( STR_BROWSE ) ),
//STRIP001 	aStrUnlinked		( ResId( STR_UNLINKED ) ),
//STRIP001 	nHtmlMode			( 0 ),
//STRIP001 	bAllowShowSelector	( TRUE ),
//STRIP001 	bIsGraphicValid		( FALSE ),
//STRIP001 	bLinkOnly			( FALSE ),
//STRIP001     bResized            ( FALSE ),
//STRIP001     bColTransparency    ( FALSE ),
//STRIP001     bGraphTransparency  ( FALSE ),
//STRIP001 
//STRIP001 	pPageImpl           ( new SvxBackgroundPage_Impl ),
//STRIP001 	pImportDlg			( NULL ),
//STRIP001 	pTableBck_Impl		( NULL ),
//STRIP001 	pParaBck_Impl       ( NULL )
//STRIP001 
//STRIP001 {
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 	SfxObjectShell* pShell;
//STRIP001 
//STRIP001 	if ( SFX_ITEM_SET == rCoreSet.GetItemState( SID_HTML_MODE, FALSE, &pItem )
//STRIP001 		 || ( 0 != ( pShell = SfxObjectShell::Current()) &&
//STRIP001 			  0 != ( pItem = pShell->GetItem( SID_HTML_MODE ) ) ) )
//STRIP001 	{
//STRIP001 		nHtmlMode = ((SfxUInt16Item*)pItem)->GetValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	FillColorValueSets_Impl();
//STRIP001 
//STRIP001 	aBackgroundColorSet.SetSelectHdl( HDL(BackgroundColorHdl_Impl) );
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxBackgroundTabPage::~SvxBackgroundTabPage()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	delete pPreviewWin1;
//STRIP001 	delete pPreviewWin2;
//STRIP001 	delete pPageImpl->pLoadTimer;
//STRIP001 	delete pPageImpl;
//STRIP001 	delete pImportDlg;
//STRIP001 
//STRIP001 	if( pTableBck_Impl)
//STRIP001 	{
//STRIP001 		delete pTableBck_Impl->pCellBrush;
//STRIP001 		delete pTableBck_Impl->pRowBrush;
//STRIP001 		delete pTableBck_Impl->pTableBrush;
//STRIP001 		delete pTableBck_Impl;
//STRIP001 	}
//STRIP001 
//STRIP001 	if(pParaBck_Impl)
//STRIP001 	{
//STRIP001 		delete pParaBck_Impl->pParaBrush;
//STRIP001 		delete pParaBck_Impl->pCharBrush;
//STRIP001 		delete pParaBck_Impl;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT* SvxBackgroundTabPage::GetRanges()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	gibt den Bereich der Which-Werte zur"uck
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return pRanges;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxBackgroundTabPage::Create( Window* pParent,
//STRIP001 										  const SfxItemSet& rAttrSet )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Create-Methode f"ur den TabDialog
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return ( new SvxBackgroundTabPage( pParent, rAttrSet ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBackgroundTabPage::Reset( const SfxItemSet& rSet )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 // os: So ein Unsinn! Irgendwo laesst sich so ein Item immer finden,
//STRIP001 //		es muss aber im rSet vorhanden sein!
//STRIP001 //	const SfxPoolItem* pX = GetOldItem( rSet, SID_VIEW_FLD_PIC );
//STRIP001 // 	if( pX && pX->ISA(SfxWallpaperItem))
//STRIP001 	if(SFX_ITEM_AVAILABLE <= rSet.GetItemState(GetWhich(SID_VIEW_FLD_PIC), FALSE))
//STRIP001 	{
//STRIP001 		ResetFromWallpaperItem( rSet );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Zustand des Vorschau-Buttons durch UserData persistent
//STRIP001 	String aUserData = GetUserData();
//STRIP001 	aBtnPreview.Check( aUserData.Len() ? ( sal_Unicode('1') == aUserData.GetChar( 0 ) ) : FALSE );
//STRIP001 
//STRIP001 	// nach Reset kein ShowSelector() mehr aufrufen d"urfen
//STRIP001 	bAllowShowSelector = FALSE;
//STRIP001 
//STRIP001 
//STRIP001 	// Input-BrushItem besorgen und auswerten
//STRIP001 	const SvxBrushItem* pBgdAttr = NULL;
//STRIP001 	USHORT nSlot = SID_ATTR_BRUSH;
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 	USHORT nDestValue = USHRT_MAX;
//STRIP001 
//STRIP001 	if ( SFX_ITEM_SET == rSet.GetItemState(	SID_BACKGRND_DESTINATION,
//STRIP001 											FALSE, &pItem ) )
//STRIP001 	{
//STRIP001 		nDestValue = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 		aTblLBox.SelectEntryPos(nDestValue);
//STRIP001 
//STRIP001 		switch ( nDestValue )
//STRIP001 		{
//STRIP001 			case TBL_DEST_CELL:
//STRIP001 				nSlot = SID_ATTR_BRUSH;
//STRIP001 			break;
//STRIP001 			case TBL_DEST_ROW:
//STRIP001 				nSlot = SID_ATTR_BRUSH_ROW;
//STRIP001 			break;
//STRIP001 			case TBL_DEST_TBL:
//STRIP001 				nSlot = SID_ATTR_BRUSH_TABLE;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( SFX_ITEM_SET == rSet.GetItemState(
//STRIP001 				SID_PARA_BACKGRND_DESTINATION, FALSE, &pItem ) )
//STRIP001 	{
//STRIP001 		nDestValue = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 		// ist gerade Zeichen aktiviert?
//STRIP001 		USHORT nParaSel  = aParaLBox.GetSelectEntryPos();
//STRIP001 		if(1 == nParaSel)
//STRIP001 		{
//STRIP001 			// dann war das ein "Standard" - Aufruf
//STRIP001 			nDestValue = nParaSel;
//STRIP001 		}
//STRIP001 		aParaLBox.SelectEntryPos(nDestValue);
//STRIP001 
//STRIP001 		switch ( nDestValue )
//STRIP001 		{
//STRIP001 			case PARA_DEST_PARA:
//STRIP001 				nSlot = SID_ATTR_BRUSH;
//STRIP001 			break;
//STRIP001 			case PARA_DEST_CHAR:
//STRIP001 				nSlot = SID_ATTR_BRUSH_CHAR;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	USHORT nWhich = GetWhich( nSlot );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( nWhich, FALSE ) >= SFX_ITEM_AVAILABLE )
//STRIP001 		pBgdAttr = (const SvxBrushItem*)&( rSet.Get( nWhich ) );
//STRIP001 
//STRIP001 	aBtnTile.Check();
//STRIP001 
//STRIP001 	if ( pBgdAttr )
//STRIP001 	{
//STRIP001 		FillControls_Impl(*pBgdAttr, aUserData);
//STRIP001 		aBgdColor = ( (SvxBrushItem*)pBgdAttr )->GetColor();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aSelectTxt.Hide();
//STRIP001 		aLbSelect.Hide();
//STRIP001 		aLbSelect.SelectEntryPos( 0 );
//STRIP001 		ShowColorUI_Impl();
//STRIP001 
//STRIP001 		const SfxPoolItem* pOld = GetOldItem( rSet, SID_ATTR_BRUSH );
//STRIP001 
//STRIP001 		if ( pOld )
//STRIP001 			aBgdColor = ( (SvxBrushItem*)pOld )->GetColor();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nDestValue != USHRT_MAX )
//STRIP001 	{
//STRIP001 		if(aTblLBox.IsVisible())
//STRIP001 		{
//STRIP001 			USHORT nValue = aTblLBox.GetSelectEntryPos();
//STRIP001 
//STRIP001 			if ( pTableBck_Impl )
//STRIP001 			{
//STRIP001                 DELETEZ( pTableBck_Impl->pCellBrush);
//STRIP001                 DELETEZ( pTableBck_Impl->pRowBrush);
//STRIP001                 DELETEZ( pTableBck_Impl->pTableBrush);
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pTableBck_Impl = new SvxBackgroundTable_Impl();
//STRIP001 
//STRIP001 			pTableBck_Impl->nActPos = nValue;
//STRIP001 
//STRIP001 			nWhich = GetWhich( SID_ATTR_BRUSH );
//STRIP001 			if ( rSet.GetItemState( nWhich, FALSE ) >= SFX_ITEM_AVAILABLE )
//STRIP001             {
//STRIP001 				pBgdAttr = (const SvxBrushItem*)&( rSet.Get( nWhich ) );
//STRIP001                 pTableBck_Impl->pCellBrush = new SvxBrushItem(*pBgdAttr);
//STRIP001             }
//STRIP001             pTableBck_Impl->nCellWhich = nWhich;
//STRIP001 
//STRIP001 			if ( rSet.GetItemState( SID_ATTR_BRUSH_ROW, FALSE ) >= SFX_ITEM_AVAILABLE )
//STRIP001             {
//STRIP001 				pBgdAttr = (const SvxBrushItem*)&( rSet.Get( SID_ATTR_BRUSH_ROW ) );
//STRIP001                 pTableBck_Impl->pRowBrush = new SvxBrushItem(*pBgdAttr);
//STRIP001             }
//STRIP001             pTableBck_Impl->nRowWhich = SID_ATTR_BRUSH_ROW;
//STRIP001 
//STRIP001 			if ( rSet.GetItemState( SID_ATTR_BRUSH_TABLE, FALSE ) >= SFX_ITEM_AVAILABLE )
//STRIP001             {
//STRIP001 				pBgdAttr = (const SvxBrushItem*)&( rSet.Get( SID_ATTR_BRUSH_TABLE ) );
//STRIP001                 pTableBck_Impl->pTableBrush = new SvxBrushItem(*pBgdAttr);
//STRIP001             }
//STRIP001             pTableBck_Impl->nTableWhich = SID_ATTR_BRUSH_TABLE;
//STRIP001 
//STRIP001 			TblDestinationHdl_Impl(&aTblLBox);
//STRIP001 			aTblLBox.SaveValue();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			USHORT nValue = aParaLBox.GetSelectEntryPos();
//STRIP001 
//STRIP001 			if ( pParaBck_Impl )
//STRIP001 			{
//STRIP001 				delete pParaBck_Impl->pParaBrush;
//STRIP001 				delete pParaBck_Impl->pCharBrush;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pParaBck_Impl = new SvxBackgroundPara_Impl();
//STRIP001 
//STRIP001 			pParaBck_Impl->nActPos = nValue;
//STRIP001 
//STRIP001 			nWhich = GetWhich( SID_ATTR_BRUSH );
//STRIP001 			if ( rSet.GetItemState( nWhich, FALSE ) >= SFX_ITEM_AVAILABLE )
//STRIP001 				pBgdAttr = (const SvxBrushItem*)&( rSet.Get( nWhich ) );
//STRIP001 			pParaBck_Impl->pParaBrush = new SvxBrushItem(*pBgdAttr);
//STRIP001 
//STRIP001 			nWhich = GetWhich( SID_ATTR_BRUSH_CHAR );
//STRIP001 			SfxItemState eState = rSet.GetItemState( nWhich, TRUE );
//STRIP001 			eState = rSet.GetItemState( nWhich, FALSE );
//STRIP001 			if ( rSet.GetItemState( nWhich, TRUE ) > SFX_ITEM_AVAILABLE )
//STRIP001 			{
//STRIP001 				pBgdAttr = (const SvxBrushItem*)&( rSet.Get( nWhich ) );
//STRIP001 				pParaBck_Impl->pCharBrush = new SvxBrushItem(*pBgdAttr);
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pParaBck_Impl->pCharBrush = new SvxBrushItem(SID_ATTR_BRUSH_CHAR);
//STRIP001 
//STRIP001 			ParaDestinationHdl_Impl(&aParaLBox);
//STRIP001 			aParaLBox.SaveValue();
//STRIP001 		}
//STRIP001 	}
//STRIP001     if(!bResized)
//STRIP001     {
//STRIP001         if(!aLbSelect.IsVisible() && !aTblLBox.IsVisible() && !aParaLBox.IsVisible())
//STRIP001         {
//STRIP001 			long nY(LogicToPixel(Point(11,14), MAP_APPFONT).X());
//STRIP001 			long nX(LogicToPixel(Point(11,14), MAP_APPFONT).Y());
//STRIP001             Point aPos(aBorderWin.GetPosPixel());
//STRIP001 			aPos.X() = nX;
//STRIP001             aPos.Y() = nY;
//STRIP001             aBorderWin.SetPosPixel(aPos);
//STRIP001             aPos = pPreviewWin1->GetPosPixel();
//STRIP001             aPos.Y()  = nY;
//STRIP001             pPreviewWin1->SetPosPixel(aPos);
//STRIP001             aBackgroundColorBox.Hide();
//STRIP001         }
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 void SvxBackgroundTabPage::ResetFromWallpaperItem( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	ShowSelector();
//STRIP001 
//STRIP001 	// Zustand des Vorschau-Buttons durch UserData persistent
//STRIP001 	String aUserData = GetUserData();
//STRIP001 	aBtnPreview.Check( aUserData.Len() ? ( sal_Unicode('1') == aUserData.GetChar( 0 ) ) : FALSE );
//STRIP001 
//STRIP001 	// Input-BrushItem besorgen und auswerten
//STRIP001 	const SvxBrushItem* pBgdAttr = NULL;
//STRIP001 	USHORT nSlot = SID_VIEW_FLD_PIC;
//STRIP001 	USHORT nWhich = GetWhich( nSlot );
//STRIP001 	SvxBrushItem* pTemp = 0;
//STRIP001 	const CntWallpaperItem* pItem = 0;
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( nWhich, FALSE ) >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		pItem = (const CntWallpaperItem*)&rSet.Get( nWhich );
//STRIP001 		pTemp = new SvxBrushItem( *pItem, nWhich );
//STRIP001 		pBgdAttr = pTemp;
//STRIP001 	}
//STRIP001 
//STRIP001 	aBtnTile.Check();
//STRIP001 
//STRIP001 	if ( pBgdAttr )
//STRIP001 	{
//STRIP001 		FillControls_Impl(*pBgdAttr, aUserData);
//STRIP001 		// Auch bei Anzeige der Grafik, soll die Brush erhalten bleiben
//STRIP001 		if( aBgdColor != pBgdAttr->GetColor() )
//STRIP001 		{
//STRIP001 			aBgdColor = pBgdAttr->GetColor();
//STRIP001 			USHORT nCol = GetItemId_Impl( aBackgroundColorSet, aBgdColor );
//STRIP001 			aBackgroundColorSet.SelectItem( nCol );
//STRIP001 			pPreviewWin1->NotifyChange( aBgdColor );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLbSelect.SelectEntryPos( 0 );
//STRIP001 		ShowColorUI_Impl();
//STRIP001 
//STRIP001 		const SfxPoolItem* pOld = GetOldItem( rSet, SID_VIEW_FLD_PIC );
//STRIP001 		if ( pOld )
//STRIP001 			aBgdColor = Color( ((CntWallpaperItem*)pOld)->GetColor() );
//STRIP001 	}
//STRIP001 
//STRIP001 	// We now have always a link to the background
//STRIP001 	bLinkOnly = TRUE;
//STRIP001 	aBtnLink.Check( TRUE );
//STRIP001 	aBtnLink.Show( FALSE );
//STRIP001 //	if( !pItem || !pItem->GetWallpaper(FALSE).IsBitmap() )
//STRIP001 //		aBtnLink.Check();
//STRIP001 
//STRIP001 	delete pTemp;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBackgroundTabPage::FillUserData()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Beim Destruieren einer SfxTabPage wird diese virtuelle Methode gerufen,
//STRIP001 	damit die TabPage interne Informationen sichern kann.
//STRIP001 
//STRIP001 	In diesem Fall wird der Zustand des Vorschau-Buttons gesichert.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	SetUserData( String( aBtnPreview.IsChecked() ? sal_Unicode('1') : sal_Unicode('0') ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxBackgroundTabPage::FillItemSet( SfxItemSet& rCoreSet )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( pPageImpl->pLoadTimer && pPageImpl->pLoadTimer->IsActive() )
//STRIP001 	{
//STRIP001 		pPageImpl->pLoadTimer->Stop();
//STRIP001 		LoadTimerHdl_Impl( pPageImpl->pLoadTimer );
//STRIP001 	}
//STRIP001 // os: So ein Unsinn! Irgendwo laesst sich so ein Item immer finden,
//STRIP001 //		es muss aber im rSet vorhanden sein!
//STRIP001 
//STRIP001 //	const SfxPoolItem* pX = GetOldItem( rCoreSet, SID_VIEW_FLD_PIC );
//STRIP001 //	if( pX && pX->ISA(SfxWallpaperItem))
//STRIP001 	if(SFX_ITEM_AVAILABLE <= rCoreSet.GetItemState(GetWhich(SID_VIEW_FLD_PIC), FALSE))
//STRIP001 		return FillItemSetWithWallpaperItem( rCoreSet, SID_VIEW_FLD_PIC );
//STRIP001 
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 	USHORT nSlot = SID_ATTR_BRUSH;
//STRIP001 
//STRIP001 	if ( aTblLBox.IsVisible() )
//STRIP001 	{
//STRIP001 		switch( aTblLBox.GetSelectEntryPos() )
//STRIP001 		{
//STRIP001 			case TBL_DEST_CELL:
//STRIP001 				nSlot = SID_ATTR_BRUSH;
//STRIP001 			break;
//STRIP001 			case TBL_DEST_ROW:
//STRIP001 				nSlot = SID_ATTR_BRUSH_ROW;
//STRIP001 			break;
//STRIP001 			case TBL_DEST_TBL:
//STRIP001 				nSlot = SID_ATTR_BRUSH_TABLE;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if(aParaLBox.GetData() == &aParaLBox)
//STRIP001 	{
//STRIP001 		switch(aParaLBox.GetSelectEntryPos())
//STRIP001 		{
//STRIP001 			case PARA_DEST_PARA:
//STRIP001 				nSlot = SID_ATTR_BRUSH;
//STRIP001 			break;
//STRIP001 			case PARA_DEST_CHAR:
//STRIP001 				nSlot = SID_ATTR_BRUSH_CHAR;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	USHORT nWhich = GetWhich( nSlot );
//STRIP001 
//STRIP001 	const SfxPoolItem* pOld = GetOldItem( rCoreSet, nSlot );
//STRIP001 	SfxItemState eOldItemState = rCoreSet.GetItemState(nSlot, FALSE);
//STRIP001 	const SfxItemSet& rOldSet = GetItemSet();
//STRIP001 
//STRIP001     BOOL bGraphTransparencyChanged = bGraphTransparency && (aGraphTransMF.GetText() != aGraphTransMF.GetSavedValue());
//STRIP001     if ( pOld )
//STRIP001 	{
//STRIP001 		const SvxBrushItem& rOldItem	= (const SvxBrushItem&)*pOld;
//STRIP001 		SvxGraphicPosition	eOldPos		= rOldItem.GetGraphicPos();
//STRIP001 		const BOOL 			bIsBrush	= ( 0 == aLbSelect.GetSelectEntryPos() );
//STRIP001 
//STRIP001         // transparency has to be set if enabled, the color not already set to "No fill" and
//STRIP001         if( bColTransparency && 
//STRIP001             aBgdColor.GetTransparency() < 0xff)
//STRIP001         {
//STRIP001             aBgdColor.SetTransparency(lcl_PercentToTransparency(aColTransMF.GetValue()));
//STRIP001         }
//STRIP001         if (   ( (GPOS_NONE == eOldPos) && bIsBrush  )
//STRIP001 			|| ( (GPOS_NONE != eOldPos) && !bIsBrush ) ) // Brush <-> Bitmap gewechselt?
//STRIP001 		{
//STRIP001 			// Hintergrund-Art wurde nicht gewechselt:
//STRIP001 
//STRIP001 			if ( (GPOS_NONE == eOldPos) || !aLbSelect.IsVisible() )
//STRIP001 			{
//STRIP001 				// Brush-Behandlung:
//STRIP001 				if ( rOldItem.GetColor() != aBgdColor ||
//STRIP001 						(SFX_ITEM_AVAILABLE >= eOldItemState && !aBackgroundColorSet.IsNoSelection()))
//STRIP001 				{
//STRIP001 					bModified = TRUE;
//STRIP001 					rCoreSet.Put( SvxBrushItem( aBgdColor, nWhich ) );
//STRIP001 				}
//STRIP001 				else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 					rCoreSet.ClearItem( nWhich );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// Bitmap-Behandlung:
//STRIP001 
//STRIP001 				SvxGraphicPosition	eNewPos  = GetGraphicPosition_Impl();
//STRIP001 				const BOOL			bIsLink  = aBtnLink.IsChecked();
//STRIP001 				const BOOL			bWasLink = (NULL != rOldItem.GetGraphicLink() );
//STRIP001 
//STRIP001 
//STRIP001 				if ( !bIsLink && !bIsGraphicValid )
//STRIP001 					bIsGraphicValid = LoadLinkedGraphic_Impl();
//STRIP001 
//STRIP001                 if (    bGraphTransparencyChanged ||
//STRIP001                         eNewPos != eOldPos
//STRIP001 					|| bIsLink != bWasLink
//STRIP001 					|| ( bWasLink  &&    *rOldItem.GetGraphicLink()
//STRIP001 									  != aBgdGraphicPath )
//STRIP001 					|| ( !bWasLink &&    rOldItem.GetGraphic()->GetBitmap()
//STRIP001 									  != aBgdGraphic.GetBitmap() )
//STRIP001 				   )
//STRIP001 				{
//STRIP001 					bModified = TRUE;
//STRIP001 
//STRIP001                     SvxBrushItem aTmpBrush(nWhich);
//STRIP001                     if ( bIsLink )
//STRIP001 					{
//STRIP001 						String aAbs = so3::StaticBaseUrl::RelToAbs( aBgdGraphicPath );
//STRIP001                         aTmpBrush = SvxBrushItem( aAbs,
//STRIP001                                                 aBgdGraphicFilter,
//STRIP001                                                 eNewPos,
//STRIP001                                                 nWhich );
//STRIP001 					}
//STRIP001 					else
//STRIP001                         aTmpBrush = SvxBrushItem( aBgdGraphic,
//STRIP001                                         eNewPos,
//STRIP001                                         nWhich );
//STRIP001                     lcl_SetTransparency(aTmpBrush, aGraphTransMF.GetValue());
//STRIP001 
//STRIP001                     rCoreSet.Put(aTmpBrush);
//STRIP001 				}
//STRIP001 				else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 					rCoreSet.ClearItem( nWhich );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else // Brush <-> Bitmap gewechselt!
//STRIP001 		{
//STRIP001 			if ( bIsBrush )
//STRIP001 				rCoreSet.Put( SvxBrushItem( aBgdColor, nWhich ) );
//STRIP001 			else
//STRIP001 			{
//STRIP001                 SvxBrushItem* pTmpBrush = 0;
//STRIP001                 if ( aBtnLink.IsChecked() )
//STRIP001 				{
//STRIP001 					String aAbs = so3::StaticBaseUrl::RelToAbs( aBgdGraphicPath );
//STRIP001                     pTmpBrush = new SvxBrushItem( aAbs,
//STRIP001 												aBgdGraphicFilter,
//STRIP001 												GetGraphicPosition_Impl(),
//STRIP001                                                 nWhich );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if ( !bIsGraphicValid )
//STRIP001 						bIsGraphicValid = LoadLinkedGraphic_Impl();
//STRIP001 
//STRIP001 					if ( bIsGraphicValid )
//STRIP001                         pTmpBrush = new SvxBrushItem( aBgdGraphic,
//STRIP001 													GetGraphicPosition_Impl(),
//STRIP001                                                     nWhich );
//STRIP001 				}
//STRIP001                 if(pTmpBrush)
//STRIP001                 {
//STRIP001                     lcl_SetTransparency(*pTmpBrush, aGraphTransMF.GetValue());
//STRIP001                     rCoreSet.Put(*pTmpBrush);
//STRIP001                     delete pTmpBrush;
//STRIP001                 }
//STRIP001 			}
//STRIP001 			bModified = ( bIsBrush || aBtnLink.IsChecked() || bIsGraphicValid );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( SID_ATTR_BRUSH_CHAR == nSlot && aBgdColor != Color( COL_WHITE ) )
//STRIP001 	{
//STRIP001 		rCoreSet.Put( SvxBrushItem( aBgdColor, nWhich ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aTblLBox.IsVisible() )
//STRIP001 	{
//STRIP001 		// Der aktuelle Zustand wurde bereits geputtet
//STRIP001         if( nSlot != SID_ATTR_BRUSH && pTableBck_Impl->pCellBrush)
//STRIP001 		{
//STRIP001 			const SfxPoolItem* pOldCell =
//STRIP001 				GetOldItem( rCoreSet, SID_ATTR_BRUSH );
//STRIP001 
//STRIP001             if ( *pTableBck_Impl->pCellBrush != *pOldCell )
//STRIP001 			{
//STRIP001 				rCoreSet.Put( *pTableBck_Impl->pCellBrush );
//STRIP001 				bModified |= TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         if( nSlot != SID_ATTR_BRUSH_ROW && pTableBck_Impl->pRowBrush)
//STRIP001 		{
//STRIP001 			const SfxPoolItem* pOldRow =
//STRIP001 				GetOldItem( rCoreSet, SID_ATTR_BRUSH_ROW );
//STRIP001 
//STRIP001             if ( *pTableBck_Impl->pRowBrush != *pOldRow )
//STRIP001 			{
//STRIP001 				rCoreSet.Put( *pTableBck_Impl->pRowBrush );
//STRIP001 				bModified |= TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         if( nSlot != SID_ATTR_BRUSH_TABLE && pTableBck_Impl->pTableBrush)
//STRIP001 		{
//STRIP001 			const SfxPoolItem* pOldTable =
//STRIP001 				GetOldItem( rCoreSet, SID_ATTR_BRUSH_TABLE );
//STRIP001 
//STRIP001 			if ( *pTableBck_Impl->pTableBrush != *pOldTable )
//STRIP001 			{
//STRIP001 				rCoreSet.Put( *pTableBck_Impl->pTableBrush );
//STRIP001 				bModified |= TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( aTblLBox.GetSavedValue() != aTblLBox.GetSelectEntryPos() )
//STRIP001 		{
//STRIP001 			rCoreSet.Put( SfxUInt16Item( SID_BACKGRND_DESTINATION,
//STRIP001 										 aTblLBox.GetSelectEntryPos() ) );
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if(aParaLBox.GetData() == &aParaLBox)
//STRIP001 	{
//STRIP001 		// Der aktuelle Zustand wurde bereits geputtet
//STRIP001 		if( nSlot != SID_ATTR_BRUSH && aParaLBox.IsVisible()) // nicht im Suchen-Format-Dialog
//STRIP001 		{
//STRIP001 			const SfxPoolItem* pOldPara =
//STRIP001 				GetOldItem( rCoreSet, SID_ATTR_BRUSH );
//STRIP001 
//STRIP001 			if ( *pParaBck_Impl->pParaBrush != *pOldPara )
//STRIP001 			{
//STRIP001 				rCoreSet.Put( *pParaBck_Impl->pParaBrush );
//STRIP001 				bModified |= TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( nSlot != SID_ATTR_BRUSH_CHAR )
//STRIP001 		{
//STRIP001 			const SfxPoolItem* pOldChar =
//STRIP001 				GetOldItem( rCoreSet, SID_ATTR_BRUSH_CHAR );
//STRIP001 
//STRIP001 			if ( pOldChar && *pParaBck_Impl->pCharBrush != *pOldChar ||
//STRIP001 				*pParaBck_Impl->pCharBrush != SvxBrushItem(SID_ATTR_BRUSH_CHAR))
//STRIP001 			{
//STRIP001 				rCoreSet.Put( *pParaBck_Impl->pCharBrush );
//STRIP001 				bModified |= TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( aParaLBox.GetSavedValue() != aParaLBox.GetSelectEntryPos() )
//STRIP001 		{
//STRIP001 			rCoreSet.Put( SfxUInt16Item( SID_BACKGRND_DESTINATION,
//STRIP001 										 aParaLBox.GetSelectEntryPos() ) );
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SvxBackgroundTabPage::FillItemSetWithWallpaperItem( SfxItemSet& rCoreSet, USHORT nSlot)
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( nSlot );
//STRIP001 	const SfxPoolItem* pOld = GetOldItem( rCoreSet, nSlot );
//STRIP001 	const SfxItemSet& rOldSet = GetItemSet();
//STRIP001 	DBG_ASSERT(pOld,"FillItemSetWithWallpaperItem: Item not found");
//STRIP001 
//STRIP001 	SvxBrushItem 		rOldItem( (const CntWallpaperItem&)*pOld, nWhich );
//STRIP001 	SvxGraphicPosition	eOldPos		= rOldItem.GetGraphicPos();
//STRIP001 	const BOOL 			bIsBrush	= ( 0 == aLbSelect.GetSelectEntryPos() );
//STRIP001 	BOOL				bModified = FALSE;
//STRIP001 
//STRIP001 	if (   ( (GPOS_NONE == eOldPos) && bIsBrush  )
//STRIP001 		|| ( (GPOS_NONE != eOldPos) && !bIsBrush ) ) // Brush <-> Bitmap gewechselt?
//STRIP001 	{
//STRIP001 		// Hintergrund-Art wurde nicht gewechselt:
//STRIP001 
//STRIP001 		if ( (GPOS_NONE == eOldPos) || !aLbSelect.IsVisible() )
//STRIP001 		{
//STRIP001 			// Brush-Behandlung:
//STRIP001 			if ( rOldItem.GetColor() != aBgdColor )
//STRIP001 			{
//STRIP001 				bModified = TRUE;
//STRIP001 				CntWallpaperItem aItem( nWhich );
//STRIP001 				aItem.SetColor( aBgdColor );
//STRIP001 				rCoreSet.Put( aItem );
//STRIP001 			}
//STRIP001 			else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 				rCoreSet.ClearItem( nWhich );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Bitmap-Behandlung:
//STRIP001 			SvxGraphicPosition	eNewPos  = GetGraphicPosition_Impl();
//STRIP001 
//STRIP001 			int bBitmapChanged = ( ( eNewPos != eOldPos ) ||
//STRIP001 								   ( *rOldItem.GetGraphicLink() != aBgdGraphicPath ) );
//STRIP001 			int bBrushChanged = ( rOldItem.GetColor() != aBgdColor );
//STRIP001 			if( bBitmapChanged || bBrushChanged )
//STRIP001 			{
//STRIP001 				bModified = TRUE;
//STRIP001 
//STRIP001 				CntWallpaperItem aItem( nWhich );
//STRIP001 				WallpaperStyle eWallStyle = SvxBrushItem::GraphicPos2WallpaperStyle(eNewPos);
//STRIP001 				aItem.SetStyle( eWallStyle );
//STRIP001 				aItem.SetColor( aBgdColor );
//STRIP001 				String aAbs = so3::StaticBaseUrl::RelToAbs( aBgdGraphicPath );
//STRIP001 				aItem.SetBitmapURL( aAbs );
//STRIP001 				rCoreSet.Put( aItem );
//STRIP001 			}
//STRIP001 			else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich, FALSE ) )
//STRIP001 				rCoreSet.ClearItem( nWhich );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else // Brush <-> Bitmap gewechselt!
//STRIP001 	{
//STRIP001 		CntWallpaperItem aItem( nWhich );
//STRIP001 		if ( bIsBrush )
//STRIP001 		{
//STRIP001 			aItem.SetColor( aBgdColor );
//STRIP001 			rCoreSet.Put( aItem );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			WallpaperStyle eWallStyle =
//STRIP001 				SvxBrushItem::GraphicPos2WallpaperStyle( GetGraphicPosition_Impl() );
//STRIP001 			aItem.SetStyle( eWallStyle );
//STRIP001 			aItem.SetColor( aBgdColor );
//STRIP001 			String aAbs = so3::StaticBaseUrl::RelToAbs( aBgdGraphicPath );
//STRIP001 			aItem.SetBitmapURL( aAbs );
//STRIP001 			rCoreSet.Put( aItem );
//STRIP001 		}
//STRIP001 
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxBackgroundTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	virtuelle Methode, wird beim Deaktivieren gerufen
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( pPageImpl->bIsImportDlgInExecute )
//STRIP001 		return KEEP_PAGE;
//STRIP001 
//STRIP001 	int nRes = LEAVE_PAGE;
//STRIP001 
//STRIP001 /*!!! (pb) no exists question any longer
//STRIP001 
//STRIP001 	if ( ( 1 == aLbSelect.GetSelectEntryPos() ) && aBtnLink.IsChecked() )
//STRIP001 	{
//STRIP001 		// Seite nur verlassen, wenn Grafik-Link ok
//STRIP001 		INetURLObject aObj;
//STRIP001 		aObj.SetSmartURL( aBgdGraphicPath );
//STRIP001 		FASTBOOL bExists = ( aObj.GetProtocol() != INET_PROT_FILE ) ||
//STRIP001 						   DirEntry( aBgdGraphicPath ).Exists();
//STRIP001 
//STRIP001 		if ( !bExists && aBgdGraphicPath.Len() )
//STRIP001 		{
//STRIP001 			// wenn Datei nicht existiert, dann vieleicht eine URL?
//STRIP001 			String aURL;
//STRIP001 
//STRIP001 			if ( SfxMedium::HumanToUrl( aURL, aBgdGraphicPath ) == ERRCODE_NONE )
//STRIP001 			{
//STRIP001 				SfxMedium aTmp( aURL, STREAM_READ, TRUE );
//STRIP001 
//STRIP001 				if ( !aTmp.Exists() )
//STRIP001 				{
//STRIP001 					RaiseLoadError_Impl();
//STRIP001 					nRes = KEEP_PAGE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 !!!*/
//STRIP001 
//STRIP001 	if ( pSet && LEAVE_PAGE == nRes )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return nRes;
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBackgroundTabPage::PointChanged( Window* pWindow, RECT_POINT eRP )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	// muss implementiert werden, damit Position-Control funktioniert
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBackgroundTabPage::ShowSelector()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if( bAllowShowSelector)
//STRIP001 	{
//STRIP001 		aSelectTxt.Show();
//STRIP001 		aLbSelect.Show();
//STRIP001 		aLbSelect.SetSelectHdl( HDL(SelectHdl_Impl) );
//STRIP001 		aBtnLink.SetClickHdl( HDL(FileClickHdl_Impl) );
//STRIP001 		aBtnPreview.SetClickHdl( HDL(FileClickHdl_Impl) );
//STRIP001 		aBtnBrowse.SetClickHdl( HDL(BrowseHdl_Impl) );
//STRIP001 		aBtnArea.SetClickHdl( HDL(RadioClickHdl_Impl) );
//STRIP001 		aBtnTile.SetClickHdl( HDL(RadioClickHdl_Impl) );
//STRIP001 		aBtnPosition.SetClickHdl( HDL(RadioClickHdl_Impl) );
//STRIP001 
//STRIP001 		// Verz"ogertes Laden "uber Timer (wg. UI-Update)
//STRIP001 		pPageImpl->pLoadTimer = new Timer;
//STRIP001 		pPageImpl->pLoadTimer->SetTimeout( 500 ); // 500ms verz"ogern
//STRIP001 		pPageImpl->pLoadTimer->SetTimeoutHdl(
//STRIP001 			LINK( this, SvxBackgroundTabPage, LoadTimerHdl_Impl ) );
//STRIP001 
//STRIP001 		bAllowShowSelector = FALSE;
//STRIP001 
//STRIP001 		if(nHtmlMode & HTMLMODE_ON)
//STRIP001 		{
//STRIP001 			if(!(nHtmlMode & HTMLMODE_GRAPH_POS))
//STRIP001 				aBtnPosition.Enable(FALSE);
//STRIP001 			aBtnArea.Enable(FALSE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void SvxBackgroundTabPage::RaiseLoadError_Impl()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	SfxErrorContext aContext( ERRCTX_SVX_BACKGROUND,
//STRIP001 							  String(),
//STRIP001 							  this,
//STRIP001 							  RID_SVXERRCTX,
//STRIP001 							  DIALOG_MGR() );
//STRIP001 
//STRIP001 	ErrorHandler::HandleError(
//STRIP001 		*new StringErrorInfo( ERRCODE_SVX_GRAPHIC_NOTREADABLE,
//STRIP001 							  aBgdGraphicPath ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxBackgroundTabPage::LoadLinkedGraphic_Impl()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	BOOL bResult = ( aBgdGraphicPath.Len() > 0 ) &&
//STRIP001 				   ( GRFILTER_OK == LoadGraphic( aBgdGraphicPath,
//STRIP001 												 aBgdGraphicFilter,
//STRIP001 												 aBgdGraphic ) );
//STRIP001 	return bResult;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void SvxBackgroundTabPage::FillColorValueSets_Impl()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	F"ullen des Farb-Sets
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	SfxObjectShell* pDocSh = SfxObjectShell::Current();
//STRIP001 	const SfxPoolItem* pItem = NULL;
//STRIP001 	XColorTable* pColorTable = NULL;
//STRIP001 	const Size aSize15x15 = Size( 15, 15 );
//STRIP001 	FASTBOOL bOwn = FALSE;
//STRIP001 
//STRIP001 	DBG_ASSERT( pDocSh, "DocShell not found!" );
//STRIP001 
//STRIP001 	BOOL bHtmlMode = 0 != (nHtmlMode & HTMLMODE_ON);
//STRIP001 
//STRIP001 	if ( pDocSh && ( 0 != ( pItem = pDocSh->GetItem( SID_COLOR_TABLE ) ) ) )
//STRIP001 		pColorTable = ( (SvxColorTableItem*)pItem )->GetColorTable();
//STRIP001 
//STRIP001 	if ( !pColorTable )
//STRIP001 	{
//STRIP001 		bOwn = TRUE;
//STRIP001 		pColorTable = new XColorTable( SvtPathOptions().GetPalettePath() );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pColorTable )
//STRIP001 	{
//STRIP001 		short i	= 0;
//STRIP001 		long nCount	= pColorTable->Count();
//STRIP001 		XColorEntry* pEntry	= NULL;
//STRIP001 		Color aColWhite( COL_WHITE );
//STRIP001 		String aStrWhite( ResId( RID_SVXITEMS_COLOR_WHITE, DIALOG_MGR() ) );
//STRIP001 		WinBits nBits = ( aBackgroundColorSet.GetStyle() | WB_ITEMBORDER | WB_NAMEFIELD | WB_NONEFIELD );
//STRIP001 		aBackgroundColorSet.SetText( String( ResId( RID_SVXSTR_TRANSPARENT, DIALOG_MGR() ) ) );
//STRIP001 		aBackgroundColorSet.SetStyle( nBits );
//STRIP001 		for ( i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			pEntry = pColorTable->Get(i);
//STRIP001 			aBackgroundColorSet.InsertItem(	i + 1, pEntry->GetColor(), pEntry->GetName() );
//STRIP001 		}
//STRIP001 
//STRIP001 		while ( i < 80 )
//STRIP001 		{
//STRIP001 			aBackgroundColorSet.InsertItem( i + 1, aColWhite, aStrWhite );
//STRIP001 			i++;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nCount > 80 )
//STRIP001 		{
//STRIP001 			aBackgroundColorSet.SetStyle( nBits | WB_VSCROLL );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bOwn )
//STRIP001 		delete pColorTable;
//STRIP001 
//STRIP001 	aBackgroundColorSet.SetColCount( 10 );
//STRIP001 	aBackgroundColorSet.SetLineCount( 10 );
//STRIP001 	aBackgroundColorSet.CalcWindowSizePixel( aSize15x15 );
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBackgroundTabPage::ShowColorUI_Impl()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Die Controls f"ur das Einstellen der Grafik ausblenden und die
//STRIP001 	Controls f"ur die Farbeinstellung einblenden.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if( !aBackgroundColorSet.IsVisible() )
//STRIP001 	{
//STRIP001 		aBackgroundColorSet.Show();
//STRIP001 		aBackgroundColorBox.Show();
//STRIP001 		aBorderWin.Show();
//STRIP001 		pPreviewWin1->Show();
//STRIP001 		aBtnBrowse.Hide();
//STRIP001 		aFtFile.Hide();
//STRIP001 		aBtnLink.Hide();
//STRIP001 		aBtnPreview.Hide();
//STRIP001 		aGbFile.Hide();
//STRIP001 		aBtnPosition.Hide();
//STRIP001 		aBtnArea.Hide();
//STRIP001 		aBtnTile.Hide();
//STRIP001 		aWndPosition.Hide();
//STRIP001 		aGbPosition.Hide();
//STRIP001 		pPreviewWin2->Hide();
//STRIP001         aGraphTransFL.Show(FALSE);
//STRIP001         aGraphTransMF.Show(FALSE);
//STRIP001         if(bColTransparency)
//STRIP001 		{
//STRIP001 			aColTransFT.Show();
//STRIP001 			aColTransMF.Show();
//STRIP001 		}
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBackgroundTabPage::ShowBitmapUI_Impl()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Die Controls f"ur die Farbeinstellung ausblenden und die
//STRIP001 	Controls f"ur das Einstellen der Grafik einblenden.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( aLbSelect.IsVisible() &&
//STRIP001 		 (
//STRIP001 		aBackgroundColorSet.IsVisible()
//STRIP001 		 || !aBtnBrowse.IsVisible() ) )
//STRIP001 	{
//STRIP001 		aBackgroundColorSet.Hide();
//STRIP001 		aBackgroundColorBox.Hide();
//STRIP001 		aBorderWin.Hide();
//STRIP001 		pPreviewWin1->Hide();
//STRIP001 		aBtnBrowse.Show();
//STRIP001 		aFtFile.Show();
//STRIP001 
//STRIP001 		if ( !bLinkOnly && ! nHtmlMode & HTMLMODE_ON )
//STRIP001 			aBtnLink.Show();
//STRIP001 		aBtnPreview.Show();
//STRIP001 		aGbFile.Show();
//STRIP001 		aBtnPosition.Show();
//STRIP001 		aBtnArea.Show();
//STRIP001 		aBtnTile.Show();
//STRIP001 		aWndPosition.Show();
//STRIP001 		aGbPosition.Show();
//STRIP001 		pPreviewWin2->Show();
//STRIP001         if(bGraphTransparency)
//STRIP001 		{
//STRIP001 			aGraphTransFL.Show();
//STRIP001 			aGraphTransMF.Show();
//STRIP001 		}
//STRIP001         aColTransFT.Show(FALSE);
//STRIP001         aColTransMF.Show(FALSE);
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBackgroundTabPage::SetGraphicPosition_Impl( SvxGraphicPosition ePos )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Die Controls f"ur die Grafikposition einstellen.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	switch ( ePos )
//STRIP001 	{
//STRIP001 		case GPOS_AREA:
//STRIP001 		{
//STRIP001 			aBtnArea.Check();
//STRIP001 			aWndPosition.Disable();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case GPOS_TILED:
//STRIP001 		{
//STRIP001 			aBtnTile.Check();
//STRIP001 			aWndPosition.Disable();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		{
//STRIP001 			aBtnPosition.Check();
//STRIP001 			aWndPosition.Enable();
//STRIP001 			RECT_POINT eNewPos = RP_MM;
//STRIP001 
//STRIP001 			switch ( ePos )
//STRIP001 			{
//STRIP001 				case GPOS_MM:	break;
//STRIP001 				case GPOS_LT:	eNewPos = RP_LT; break;
//STRIP001 				case GPOS_MT:	eNewPos = RP_MT; break;
//STRIP001 				case GPOS_RT:	eNewPos = RP_RT; break;
//STRIP001 				case GPOS_LM:	eNewPos = RP_LM; break;
//STRIP001 				case GPOS_RM:	eNewPos = RP_RM; break;
//STRIP001 				case GPOS_LB:	eNewPos = RP_LB; break;
//STRIP001 				case GPOS_MB:	eNewPos = RP_MB; break;
//STRIP001 				case GPOS_RB:	eNewPos = RP_RB; break;
//STRIP001 			}
//STRIP001 			aWndPosition.SetActualRP( eNewPos );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	aWndPosition.Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxGraphicPosition SvxBackgroundTabPage::GetGraphicPosition_Impl()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Die Position der Grafik zur"uckgeben.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( aBtnTile.IsChecked() )
//STRIP001 		return GPOS_TILED;
//STRIP001 	else if ( aBtnArea.IsChecked() )
//STRIP001 		return GPOS_AREA;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		switch ( aWndPosition.GetActualRP() )
//STRIP001 		{
//STRIP001 			case RP_LT:	return GPOS_LT;
//STRIP001 			case RP_MT:	return GPOS_MT;
//STRIP001 			case RP_RT:	return GPOS_RT;
//STRIP001 			case RP_LM:	return GPOS_LM;
//STRIP001 			case RP_MM:	return GPOS_MM;
//STRIP001 			case RP_RM:	return GPOS_RM;
//STRIP001 			case RP_LB:	return GPOS_LB;
//STRIP001 			case RP_MB:	return GPOS_MB;
//STRIP001 			case RP_RB:	return GPOS_RB;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return GPOS_MM;
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 // Handler
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBackgroundTabPage, BackgroundColorHdl_Impl, ValueSet*, EMTPYARG )
//STRIP001 /*
//STRIP001     Handler, called when color selection is changed
//STRIP001 */
//STRIP001 {
//STRIP001 	USHORT nItemId = aBackgroundColorSet.GetSelectItemId();
//STRIP001 	Color aColor = nItemId ? ( aBackgroundColorSet.GetItemColor( nItemId ) ) : Color( COL_TRANSPARENT );
//STRIP001 	aBgdColor = aColor;
//STRIP001 	pPreviewWin1->NotifyChange( aBgdColor );
//STRIP001     BOOL bEnableTransp = aBgdColor.GetTransparency() < 0xff;
//STRIP001     aColTransFT.Enable(bEnableTransp);
//STRIP001     aColTransMF.Enable(bEnableTransp);
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBackgroundTabPage, SelectHdl_Impl, ListBox*, EMPTYARG )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( 0 == aLbSelect.GetSelectEntryPos() )
//STRIP001 	{
//STRIP001 		ShowColorUI_Impl();
//STRIP001 		aParaLBox.Enable(); // Zeichenhintergrund kann keine Bitmap sein
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ShowBitmapUI_Impl();
//STRIP001 		aParaLBox.Enable(FALSE);// Zeichenhintergrund kann keine Bitmap sein
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBackgroundTabPage, FileClickHdl_Impl, CheckBox*, pBox )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( &aBtnLink == pBox )
//STRIP001 	{
//STRIP001 		if ( aBtnLink.IsChecked() )
//STRIP001 		{
//STRIP001 			INetURLObject aObj;
//STRIP001 			aObj.SetSmartURL( aBgdGraphicPath );
//STRIP001 			String aFilePath;
//STRIP001 
//STRIP001 			if ( aObj.GetProtocol() == INET_PROT_FILE )
//STRIP001 				aFilePath = aObj.getFSysPath( INetURLObject::FSYS_DETECT );
//STRIP001 			else
//STRIP001 				aFilePath = aBgdGraphicPath;
//STRIP001 			aFtFile.SetText( aFilePath );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aFtFile.SetText( aStrUnlinked );
//STRIP001 	}
//STRIP001 	else if ( &aBtnPreview == pBox )
//STRIP001 	{
//STRIP001 		if ( aBtnPreview.IsChecked() )
//STRIP001 		{
//STRIP001 			if ( !bIsGraphicValid )
//STRIP001 				bIsGraphicValid = LoadLinkedGraphic_Impl();
//STRIP001 
//STRIP001 			if ( bIsGraphicValid )
//STRIP001 			{
//STRIP001 				Bitmap aBmp = aBgdGraphic.GetBitmap();
//STRIP001 				pPreviewWin2->NotifyChange( &aBmp );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if ( aBgdGraphicPath.Len() > 0 ) // nur bei gelinkter Grafik
//STRIP001 					RaiseLoadError_Impl();		 // ein Fehler
//STRIP001 				pPreviewWin2->NotifyChange( NULL );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pPreviewWin2->NotifyChange( NULL );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBackgroundTabPage, RadioClickHdl_Impl, RadioButton*, pBtn )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( pBtn == &aBtnPosition )
//STRIP001 	{
//STRIP001 		if ( !aWndPosition.IsEnabled() )
//STRIP001 		{
//STRIP001 			aWndPosition.Enable();
//STRIP001 			aWndPosition.Invalidate();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( aWndPosition.IsEnabled() )
//STRIP001 	{
//STRIP001 		aWndPosition.Disable();
//STRIP001 		aWndPosition.Invalidate();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBackgroundTabPage, BrowseHdl_Impl, PushButton* , EMPTYARG )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Handler, gerufen durch das Dr"ucken des Durchsuchen-Buttons.
//STRIP001 	Grafik/Einf"ugen-Dialog erzeugen, Pfad setzen und starten.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( pPageImpl->pLoadTimer->IsActive() )
//STRIP001 		return 0;
//STRIP001 	BOOL bHtml = 0 != ( nHtmlMode & HTMLMODE_ON );
//STRIP001 
//STRIP001 	pImportDlg = new SvxOpenGraphicDialog( aStrBrowse );
//STRIP001 	if ( bHtml || bLinkOnly )
//STRIP001 		pImportDlg->EnableLink(sal_False);
//STRIP001 	pImportDlg->SetPath( aBgdGraphicPath, aBtnLink.IsChecked() );
//STRIP001 
//STRIP001 	pPageImpl->bIsImportDlgInExecute = TRUE;
//STRIP001 	short nErr = pImportDlg->Execute();
//STRIP001 	pPageImpl->bIsImportDlgInExecute = FALSE;
//STRIP001 
//STRIP001 	if( !nErr )
//STRIP001 	{
//STRIP001 		if ( bHtml )
//STRIP001 			aBtnLink.Check();
//STRIP001 		// wenn Verkn"upfen nicht gecheckt ist und die Vorschau auch nicht,
//STRIP001 		// dann die Vorschau aktivieren, damit der Anwender sieht,
//STRIP001 		// welche Grafik er ausgew"ahlt hat
//STRIP001 		if ( !aBtnLink.IsChecked() && !aBtnPreview.IsChecked() )
//STRIP001 			aBtnPreview.Check( TRUE );
//STRIP001 		// timer-verz"ogertes Laden der Grafik
//STRIP001 		pPageImpl->pLoadTimer->Start();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		DELETEZ( pImportDlg );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBackgroundTabPage, LoadTimerHdl_Impl, Timer* , pTimer )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Verz"ogertes Laden der Grafik.
//STRIP001 	Grafik wird nur dann geladen, wenn sie unterschiedlich zur
//STRIP001 	aktuellen Grafik ist.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( pTimer == pPageImpl->pLoadTimer )
//STRIP001 	{
//STRIP001 		pPageImpl->pLoadTimer->Stop();
//STRIP001 
//STRIP001 		if ( pImportDlg )
//STRIP001 		{
//STRIP001 			INetURLObject aOld;
//STRIP001 			aOld.SetSmartURL( aBgdGraphicPath );
//STRIP001 			INetURLObject aNew( pImportDlg->GetPath() );
//STRIP001 
//STRIP001 			if ( !aBgdGraphicPath.Len() || aNew != aOld )
//STRIP001 			{
//STRIP001 				// neue Datei gew"ahlt
//STRIP001 				aBgdGraphicPath   = pImportDlg->GetPath();
//STRIP001 				aBgdGraphicFilter =	pImportDlg->GetCurrentFilter();
//STRIP001 				BOOL bLink = ( nHtmlMode & HTMLMODE_ON ) || bLinkOnly ? TRUE : pImportDlg->IsAsLink();
//STRIP001 				aBtnLink.Check( bLink );
//STRIP001 				aBtnLink.Enable();
//STRIP001 
//STRIP001 				if ( aBtnPreview.IsChecked() )
//STRIP001 				{
//STRIP001 					if( !pImportDlg->GetGraphic(aBgdGraphic) )
//STRIP001 					{
//STRIP001 						bIsGraphicValid = TRUE;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						aBgdGraphicFilter.Erase();
//STRIP001 						aBgdGraphicPath.Erase();
//STRIP001 						bIsGraphicValid = FALSE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 					bIsGraphicValid = FALSE; // Grafik erst beim Preview-Click laden
//STRIP001 
//STRIP001 				if ( aBtnPreview.IsChecked() && bIsGraphicValid )
//STRIP001 				{
//STRIP001 					Bitmap aBmp = aBgdGraphic.GetBitmap();
//STRIP001 					pPreviewWin2->NotifyChange( &aBmp );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					pPreviewWin2->NotifyChange( NULL );
//STRIP001 			}
//STRIP001 
//STRIP001 			FileClickHdl_Impl( &aBtnLink );
//STRIP001 			DELETEZ( pImportDlg );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBackgroundTabPage::ShowTblControl()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	aTblLBox			.SetSelectHdl( HDL(TblDestinationHdl_Impl) );
//STRIP001 	aTblDesc.Show();
//STRIP001 	aTblLBox.Show();
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBackgroundTabPage::ShowParaControl(BOOL bCharOnly)
//STRIP001 {
//STRIP001 	aParaLBox.SetSelectHdl(HDL(ParaDestinationHdl_Impl));
//STRIP001 	if(!bCharOnly)
//STRIP001 	{
//STRIP001 		aTblDesc.Show();
//STRIP001 		aParaLBox.Show();
//STRIP001 	}
//STRIP001 	aParaLBox.SetData(&aParaLBox); // hier erkennt man, dass dieser Mode eingeschaltet ist
//STRIP001 }
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBackgroundTabPage, TblDestinationHdl_Impl, ListBox*, pBox )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	USHORT nSelPos = pBox->GetSelectEntryPos();
//STRIP001 	if( pTableBck_Impl && pTableBck_Impl->nActPos != nSelPos)
//STRIP001 	{
//STRIP001 		SvxBrushItem** pActItem = new (SvxBrushItem*);
//STRIP001         USHORT nWhich = 0;
//STRIP001         switch(pTableBck_Impl->nActPos)
//STRIP001 		{
//STRIP001 			case TBL_DEST_CELL:
//STRIP001                 *pActItem = pTableBck_Impl->pCellBrush;
//STRIP001                 nWhich = pTableBck_Impl->nCellWhich;
//STRIP001 			break;
//STRIP001 			case TBL_DEST_ROW:
//STRIP001                 *pActItem = pTableBck_Impl->pRowBrush;
//STRIP001                 nWhich = pTableBck_Impl->nRowWhich;
//STRIP001 			break;
//STRIP001 			case TBL_DEST_TBL:
//STRIP001                 *pActItem = pTableBck_Impl->pTableBrush;
//STRIP001                 nWhich = pTableBck_Impl->nTableWhich;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		pTableBck_Impl->nActPos = nSelPos;
//STRIP001         if(!*pActItem)
//STRIP001             *pActItem = new SvxBrushItem;
//STRIP001         if(0 == aLbSelect.GetSelectEntryPos())  // Brush ausgewaehlt
//STRIP001 		{
//STRIP001 			**pActItem = aBgdColor;
//STRIP001 			(*pActItem)->SetWhich(nWhich);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 				SvxGraphicPosition	eNewPos  = GetGraphicPosition_Impl();
//STRIP001 				const BOOL			bIsLink  = aBtnLink.IsChecked();
//STRIP001 
//STRIP001 				if ( !bIsLink && !bIsGraphicValid )
//STRIP001 					bIsGraphicValid = LoadLinkedGraphic_Impl();
//STRIP001 
//STRIP001 				if ( bIsLink )
//STRIP001 					**pActItem = SvxBrushItem( aBgdGraphicPath,
//STRIP001 												aBgdGraphicFilter,
//STRIP001 												eNewPos,
//STRIP001 												(*pActItem)->Which() );
//STRIP001 				else
//STRIP001 					**pActItem = SvxBrushItem( aBgdGraphic,
//STRIP001 												eNewPos,
//STRIP001 												(*pActItem)->Which() );
//STRIP001 		}
//STRIP001 		switch(nSelPos)
//STRIP001 		{
//STRIP001 			case TBL_DEST_CELL:
//STRIP001 				*pActItem = pTableBck_Impl->pCellBrush;
//STRIP001 				aLbSelect.Enable();
//STRIP001                 nWhich = pTableBck_Impl->nCellWhich;
//STRIP001             break;
//STRIP001 			case TBL_DEST_ROW:
//STRIP001 			{
//STRIP001 				if((nHtmlMode & HTMLMODE_ON) && !(nHtmlMode & HTMLMODE_SOME_STYLES))
//STRIP001 					aLbSelect.Disable();
//STRIP001 				*pActItem = pTableBck_Impl->pRowBrush;
//STRIP001                 nWhich = pTableBck_Impl->nRowWhich;
//STRIP001             }
//STRIP001 			break;
//STRIP001 			case TBL_DEST_TBL:
//STRIP001 				*pActItem = pTableBck_Impl->pTableBrush;
//STRIP001 				aLbSelect.Enable();
//STRIP001                 nWhich = pTableBck_Impl->nTableWhich;
//STRIP001             break;
//STRIP001 		}
//STRIP001 		String aUserData = GetUserData();
//STRIP001         if(!*pActItem)
//STRIP001             *pActItem = new SvxBrushItem(nWhich);
//STRIP001         FillControls_Impl(**pActItem, aUserData);
//STRIP001 		delete pActItem;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBackgroundTabPage, ParaDestinationHdl_Impl, ListBox*, pBox )
//STRIP001 {
//STRIP001 	USHORT nSelPos = pBox->GetSelectEntryPos();
//STRIP001 	if( pParaBck_Impl && pParaBck_Impl->nActPos != nSelPos)
//STRIP001 	{
//STRIP001 		SvxBrushItem** pActItem = new (SvxBrushItem*);
//STRIP001 		switch(pParaBck_Impl->nActPos)
//STRIP001 		{
//STRIP001 			case PARA_DEST_PARA:
//STRIP001 				*pActItem = pParaBck_Impl->pParaBrush;
//STRIP001 			break;
//STRIP001 			case PARA_DEST_CHAR:
//STRIP001 				*pActItem = pParaBck_Impl->pCharBrush;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		pParaBck_Impl->nActPos = nSelPos;
//STRIP001 		if(0 == aLbSelect.GetSelectEntryPos())  // Brush ausgewaehlt
//STRIP001 		{
//STRIP001 			USHORT nWhich = (*pActItem)->Which();
//STRIP001 			**pActItem = aBgdColor;
//STRIP001 			(*pActItem)->SetWhich(nWhich);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 				SvxGraphicPosition	eNewPos  = GetGraphicPosition_Impl();
//STRIP001 				const BOOL			bIsLink  = aBtnLink.IsChecked();
//STRIP001 
//STRIP001 				if ( !bIsLink && !bIsGraphicValid )
//STRIP001 					bIsGraphicValid = LoadLinkedGraphic_Impl();
//STRIP001 
//STRIP001 				if ( bIsLink )
//STRIP001 					**pActItem = SvxBrushItem( aBgdGraphicPath,
//STRIP001 												aBgdGraphicFilter,
//STRIP001 												eNewPos,
//STRIP001 												(*pActItem)->Which() );
//STRIP001 				else
//STRIP001 					**pActItem = SvxBrushItem( aBgdGraphic,
//STRIP001 												eNewPos,
//STRIP001 												(*pActItem)->Which() );
//STRIP001 		}
//STRIP001 		switch(nSelPos)
//STRIP001 		{
//STRIP001 			case PARA_DEST_PARA:
//STRIP001 				*pActItem = pParaBck_Impl->pParaBrush;
//STRIP001 				aLbSelect.Enable();
//STRIP001 			break;
//STRIP001 			case PARA_DEST_CHAR:
//STRIP001 			{
//STRIP001 				*pActItem = pParaBck_Impl->pCharBrush;
//STRIP001 				aLbSelect.Enable(FALSE);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		String aUserData = GetUserData();
//STRIP001 		FillControls_Impl(**pActItem, aUserData);
//STRIP001 		delete pActItem;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBackgroundTabPage::FillControls_Impl( const SvxBrushItem& rBgdAttr,
//STRIP001 											  const String& rUserData )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	SvxGraphicPosition	ePos = rBgdAttr.GetGraphicPos();
//STRIP001 	const Color& rColor = rBgdAttr.GetColor();
//STRIP001     if(bColTransparency)
//STRIP001     {
//STRIP001         aColTransMF.SetValue(lcl_TransparencyToPercent(rColor.GetTransparency()));
//STRIP001         aColTransMF.SaveValue();
//STRIP001 		BOOL bEnableTransp = rColor.GetTransparency() < 0xff;
//STRIP001 		aColTransFT.Enable(bEnableTransp);
//STRIP001 		aColTransMF.Enable(bEnableTransp);
//STRIP001 		//the default setting should be "no transparency"
//STRIP001 		if(!bEnableTransp)
//STRIP001 			aColTransMF.SetValue(0);
//STRIP001     }
//STRIP001 
//STRIP001     if ( GPOS_NONE == ePos || !aLbSelect.IsVisible() )
//STRIP001 	{
//STRIP001 		aLbSelect.SelectEntryPos( 0 );
//STRIP001 		ShowColorUI_Impl();
//STRIP001 		Color aTrColor( COL_TRANSPARENT );
//STRIP001 		aBgdColor = rColor;
//STRIP001 
//STRIP001 		USHORT nCol = ( aTrColor != aBgdColor ) ?
//STRIP001 			GetItemId_Impl( aBackgroundColorSet, aBgdColor ) : 0;
//STRIP001 
//STRIP001 		if( aTrColor != aBgdColor && nCol == 0)
//STRIP001 		{
//STRIP001 			aBackgroundColorSet.SetNoSelection();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aBackgroundColorSet.SelectItem( nCol );
//STRIP001 		}
//STRIP001 
//STRIP001 		pPreviewWin1->NotifyChange( aBgdColor );
//STRIP001 		if ( aLbSelect.IsVisible() ) // Grafikteil initialisieren
//STRIP001 		{
//STRIP001 			aBgdGraphicFilter.Erase();
//STRIP001 			aBgdGraphicPath.Erase();
//STRIP001 
//STRIP001 			if ( !rUserData.Len() )
//STRIP001 				aBtnPreview.Check( FALSE );
//STRIP001 			aBtnLink.Check( FALSE );
//STRIP001 			aBtnLink.Disable();
//STRIP001 			pPreviewWin2->NotifyChange( NULL );
//STRIP001 			SetGraphicPosition_Impl( GPOS_TILED );	// Kacheln als Default
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		const String*	pStrLink   = rBgdAttr.GetGraphicLink();
//STRIP001 		const String*	pStrFilter = rBgdAttr.GetGraphicFilter();
//STRIP001 
//STRIP001 		aLbSelect.SelectEntryPos( 1 );
//STRIP001 		ShowBitmapUI_Impl();
//STRIP001 
//STRIP001 		if ( pStrLink )
//STRIP001 		{
//STRIP001 			aBgdGraphicPath = *pStrLink;
//STRIP001 			aBtnLink.Check( TRUE );
//STRIP001 			aBtnLink.Enable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aBgdGraphicPath.Erase();
//STRIP001 			aBtnLink.Check( FALSE );
//STRIP001 			aBtnLink.Disable();
//STRIP001 		}
//STRIP001 
//STRIP001         if(bGraphTransparency)
//STRIP001         {
//STRIP001             const GraphicObject* pObject = rBgdAttr.GetGraphicObject(SfxObjectShell::Current());
//STRIP001             if(pObject)
//STRIP001                 aGraphTransMF.SetValue(lcl_TransparencyToPercent(pObject->GetAttr().GetTransparency()));
//STRIP001             else
//STRIP001                 aGraphTransMF.SetValue(0);
//STRIP001             aGraphTransMF.SaveValue();
//STRIP001         }
//STRIP001 
//STRIP001         FileClickHdl_Impl( &aBtnLink );
//STRIP001 
//STRIP001 		if ( pStrFilter )
//STRIP001 			aBgdGraphicFilter = *pStrFilter;
//STRIP001 		else
//STRIP001 			aBgdGraphicFilter.Erase();
//STRIP001 
//STRIP001 		if ( !pStrLink || aBtnPreview.IsChecked() )
//STRIP001 		{
//STRIP001 			// Grafik ist im Item vorhanden und muss nicht
//STRIP001 			// geladen werden:
//STRIP001 
//STRIP001 			const Graphic* pGraphic =
//STRIP001 				rBgdAttr.GetGraphic( SfxObjectShell::Current() );
//STRIP001 
//STRIP001 			if ( !pGraphic && aBtnPreview.IsChecked() )
//STRIP001 				bIsGraphicValid = LoadLinkedGraphic_Impl();
//STRIP001 			else if ( pGraphic )
//STRIP001 			{
//STRIP001 				aBgdGraphic = *pGraphic;
//STRIP001 				bIsGraphicValid = TRUE;
//STRIP001 
//STRIP001 				if ( !rUserData.Len() )
//STRIP001 					aBtnPreview.Check();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				RaiseLoadError_Impl();
//STRIP001 				bIsGraphicValid = FALSE;
//STRIP001 
//STRIP001 				if ( !rUserData.Len() )
//STRIP001 					aBtnPreview.Check( FALSE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aBtnPreview.IsChecked() && bIsGraphicValid )
//STRIP001 		{
//STRIP001 			Bitmap aBmp = aBgdGraphic.GetBitmap();
//STRIP001 			pPreviewWin2->NotifyChange( &aBmp );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pPreviewWin2->NotifyChange( NULL );
//STRIP001 
//STRIP001 		SetGraphicPosition_Impl( ePos );
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------------------09.08.2002 14:04------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxBackgroundTabPage::EnableTransparency(BOOL bColor, BOOL bGraphic)
//STRIP001 {
//STRIP001     bColTransparency  = bColor;
//STRIP001     bGraphTransparency = bGraphic;
//STRIP001     if(bColor)
//STRIP001     {
//STRIP001         aColTransFT.Show();
//STRIP001         aColTransMF.Show();
//STRIP001     }
//STRIP001     if(bGraphic)
//STRIP001     {
//STRIP001         Size aRectSize(aWndPosition.GetSizePixel());
//STRIP001         Point aRectPos(aWndPosition.GetPosPixel());
//STRIP001         Point aFLPos(aGraphTransFL.GetPosPixel());
//STRIP001         Size aTmp(LogicToPixel(Size(RSC_SP_FLGR_SPACE_Y, RSC_SP_FLGR_SPACE_Y), MAP_APPFONT));
//STRIP001         long nRectHeight = aFLPos.Y() - aRectPos.Y() - aTmp.Height();
//STRIP001         aRectSize.Height() = nRectHeight;
//STRIP001         aWndPosition.SetSizePixel(aRectSize);
//STRIP001         aWndPosition.Invalidate();
//STRIP001     }
//STRIP001 }

}
