/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_commonlingui.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:37:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SVX_COMMON_LINGUI_HXX
#include "commonlingui.hxx"
#endif

#ifndef _SVX_DIALOGS_HRC
#include "dialogs.hrc"
#endif

#ifndef _SVX_DIALMGR_HXX
#include "dialmgr.hxx"
#endif

#ifndef _SV_DECOVIEW_HXX 
#include <vcl/decoview.hxx>
#endif

#include "spldlg.hrc"
namespace binfilter {

//=============================================================================
// SvxClickInfoCtr
//=============================================================================

//-----------------------------------------------------------------------------
//STRIP001 SvxClickInfoCtr::SvxClickInfoCtr( Window* pParent, const ResId& rResId ) :
//STRIP001 		Control( pParent, rResId ),
//STRIP001 		aFixedInfo( this)
//STRIP001 {
//STRIP001 	aFixedInfo.SetSizePixel(GetOutputSizePixel());
//STRIP001 	aFixedInfo.Show();
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void SvxClickInfoCtr::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	aActivateLink.Call(this);
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 long SvxClickInfoCtr::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	if(rNEvt.GetType()==EVENT_GETFOCUS || rNEvt.GetType()==EVENT_MOUSEBUTTONDOWN)
//STRIP001 	{
//STRIP001 		aActivateLink.Call(this);
//STRIP001 	}
//STRIP001 
//STRIP001 	return Control::PreNotify(rNEvt);
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void SvxClickInfoCtr::SetText( const XubString& rStr )
//STRIP001 {
//STRIP001 	aFixedInfo.SetText(rStr );
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 XubString SvxClickInfoCtr::GetText() const
//STRIP001 {
//STRIP001 	return aFixedInfo.GetText();
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 __EXPORT SvxClickInfoCtr::~SvxClickInfoCtr()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //=============================================================================
//STRIP001 // SvxCommonLinguisticControl
//STRIP001 //=============================================================================
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 SvxCommonLinguisticControl::SvxCommonLinguisticControl( ModalDialog* _pParent )
//STRIP001 	:Window( _pParent, SVX_RES( RID_SVX_WND_COMMON_LINGU ) )
//STRIP001 	,aWordText		( this,	ResId( FT_WORD ) )
//STRIP001 	,aAktWord		( this,	ResId( FT_AKTWORD ) )
//STRIP001 	,aNewWord		( this,	ResId( FT_NEWWORD ) )
//STRIP001 	,aNewWordED		( this,	ResId( ED_NEWWORD ) )
//STRIP001 	,aSuggestionFT	( this, ResId( FT_SUGGESTION ) )
//STRIP001 	,aAuditBox		( this, ResId( GB_AUDIT ) )
//STRIP001 	,aIgnoreBtn		( this,	ResId( BTN_IGNORE ) )
//STRIP001 	,aIgnoreAllBtn	( this,	ResId( BTN_IGNOREALL ) )
//STRIP001 	,aChangeBtn		( this,	ResId( BTN_CHANGE ) )
//STRIP001 	,aChangeAllBtn	( this,	ResId( BTN_CHANGEALL ) )
//STRIP001 	,aStatusText	( this, ResId( FT_STATUS ) )
//STRIP001 	,aCancelBtn		( this,	ResId( BTN_SPL_CANCEL ) )
//STRIP001 	,aHelpBtn		( this,	ResId( BTN_SPL_HELP ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 #ifdef FS_PRIV_DEBUG
//STRIP001 	SetType( WINDOW_TABPAGE );
//STRIP001 #endif
//STRIP001 
//STRIP001 	SetPosSizePixel( Point( 0, 0 ), _pParent->GetOutputSizePixel() );
//STRIP001 	Show();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 PushButton*	SvxCommonLinguisticControl::implGetButton( ButtonType _eType  ) const
//STRIP001 {
//STRIP001 	const PushButton* pButton = NULL;
//STRIP001 	switch ( _eType )
//STRIP001 	{
//STRIP001 		case eClose: pButton = &aCancelBtn; break;
//STRIP001 		case eIgnore: pButton = &aIgnoreBtn; break;
//STRIP001 		case eIgnoreAll: pButton = &aIgnoreAllBtn; break;
//STRIP001 		case eChange: pButton = &aChangeBtn; break;
//STRIP001 		case eChangeAll: pButton = &aChangeAllBtn; break;
//STRIP001 	}
//STRIP001 	return const_cast< PushButton* >( pButton );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SvxCommonLinguisticControl::SetButtonHandler( ButtonType _eType, const Link& _rHandler )
//STRIP001 {
//STRIP001 	Button* pButton = GetButton( _eType );
//STRIP001 	if ( pButton )
//STRIP001 		pButton->SetClickHdl( _rHandler );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SvxCommonLinguisticControl::EnableButton( ButtonType _eType, sal_Bool _bEnable )
//STRIP001 {
//STRIP001 	Button* pButton = GetButton( _eType );
//STRIP001 	if ( pButton )
//STRIP001 		pButton->Enable( _bEnable );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SvxCommonLinguisticControl::InsertControlGroup( Window& _rFirstGroupWindow, Window& _rLastGroupWindow, ControlGroup _eInsertAfter )
//STRIP001 {
//STRIP001 	Window* pInsertAfter = NULL;	// will be the last window of our own "undividable" group, after which we insert the foreign group
//STRIP001 	switch ( _eInsertAfter )
//STRIP001 	{
//STRIP001 		case eLeftRightWords	: pInsertAfter = &aNewWordED; break;
//STRIP001 		case eSuggestionLabel	: pInsertAfter = &aSuggestionFT; break;
//STRIP001 		case eActionButtons		: pInsertAfter = &aChangeAllBtn; break;
//STRIP001 		case eDialogButtons		: pInsertAfter = &aCancelBtn; break;
//STRIP001 	}
//STRIP001 
//STRIP001 	// now loop through the remaining windows of the foreign group
//STRIP001 	Window* pInsertBehind = pInsertAfter;
//STRIP001 	Window* pInsert = &_rFirstGroupWindow;
//STRIP001 
//STRIP001 	// some strange thing below: asking a window for WINDOW_NEXT or WINDOW_PREV does not take into
//STRIP001 	// account the border window, _but_ SetZOrder _does_!. Thus, when advancing through a chain
//STRIP001 	// of windows, we need to work with the border windows (WINDOW_BORDER), instead of simply
//STRIP001 	// asking for WINDOW_NEXT.
//STRIP001 
//STRIP001 	Window* pLoopEnd = _rLastGroupWindow.GetWindow( WINDOW_BORDER );
//STRIP001 	while ( pInsert && ( pInsertBehind != pLoopEnd ) )
//STRIP001 	{
//STRIP001 		// we'll destroy the NEXT relation immediately, so remember the next window
//STRIP001 		DBG_ASSERT( pInsert->GetWindow( WINDOW_BORDER ), "SvxCommonLinguisticControl::InsertControlGroup: border window is expected to be non NULL!" );
//STRIP001 		Window* pNextInsert = pInsert->GetWindow( WINDOW_BORDER )->GetWindow( WINDOW_NEXT );
//STRIP001 		// knit
//STRIP001 		pInsert->SetZOrder( pInsertBehind, WINDOW_ZORDER_BEHIND );
//STRIP001 		// advance
//STRIP001 		pInsertBehind = pInsert;
//STRIP001 		pInsert = pNextInsert;
//STRIP001 	}
//STRIP001 	DBG_ASSERT( pInsertBehind == pLoopEnd, "SvxCommonLinguisticControl::InsertControlGroup: controls do not form a group!" );
//STRIP001 		// if we did not reach pLoopEnd, then we did not reach _rLastGroupWindow in the loop, then
//STRIP001 		// (FirstWindow, LastWindow) was no valid control group
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 String SvxCommonLinguisticControl::GetNewEditWord()
//STRIP001 {
//STRIP001 	return aNewWordED.GetText();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SvxCommonLinguisticControl::SetNewEditWord( const String& _rNew )
//STRIP001 {
//STRIP001 	aNewWordED.SetText( _rNew );
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void SvxCommonLinguisticControl::UpdateIgnoreHelp( )
//STRIP001 {
//STRIP001 
//STRIP001 	String aInfoStr( RTL_CONSTASCII_USTRINGPARAM( ": " ) );
//STRIP001 	aInfoStr.Append( GetCurrentText() );
//STRIP001 
//STRIP001 	String aString = GetNonMnemonicString( aIgnoreAllBtn.GetText() );
//STRIP001 	aString.Append( aInfoStr );
//STRIP001 	aIgnoreAllBtn.SetQuickHelpText( aString );
//STRIP001 
//STRIP001 	aString = GetNonMnemonicString( aIgnoreBtn.GetText() );
//STRIP001 	aString.Append( aInfoStr );
//STRIP001 	aIgnoreBtn.SetQuickHelpText( aString );
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void SvxCommonLinguisticControl::UpdateChangesHelp( const String& _rNewText )
//STRIP001 {
//STRIP001 	String aInfoStr( RTL_CONSTASCII_USTRINGPARAM( ": " ) );
//STRIP001 	aInfoStr.Append( GetCurrentText() );
//STRIP001 	aInfoStr.Append( String( RTL_CONSTASCII_USTRINGPARAM( " -> " ) ) );
//STRIP001 	aInfoStr.Append( _rNewText );
//STRIP001 		// TODO: shouldn't this be part of the resources, for proper localization?
//STRIP001 
//STRIP001 	String aString = GetNonMnemonicString( aChangeAllBtn.GetText() );
//STRIP001 	aString.Append( aInfoStr );
//STRIP001 	aChangeAllBtn.SetQuickHelpText( aString );
//STRIP001 
//STRIP001 	aString = GetNonMnemonicString( aChangeBtn.GetText() );
//STRIP001 	aString.Append( aInfoStr );
//STRIP001 	aChangeBtn.SetQuickHelpText( aString );
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void SvxCommonLinguisticControl::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	Window::Paint(rRect );
//STRIP001 
//STRIP001 	DecorationView aDecoView( this );
//STRIP001 
//STRIP001 	Rectangle aRect( aAuditBox.GetPosPixel(), aAuditBox.GetSizePixel() );
//STRIP001 	aDecoView.DrawButton( aRect, BUTTON_DRAW_NOFILL );
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void SvxCommonLinguisticControl::Enlarge( sal_Int32 _nX, sal_Int32 _nY )
//STRIP001 {
//STRIP001 	Size aSize;
//STRIP001 	Point aPos;
//STRIP001 
//STRIP001 	// the controls which need to be resized
//STRIP001 	{
//STRIP001 		Window* pResize[] =
//STRIP001 		{
//STRIP001 			this, &aAuditBox, &aStatusText
//STRIP001 		};
//STRIP001 		for ( sal_Int32 i = 0; i < sizeof( pResize ) / sizeof( pResize[0] ); ++i )
//STRIP001 		{
//STRIP001 			aSize = pResize[i]->GetSizePixel( );
//STRIP001 			pResize[i]->SetSizePixel( Size( aSize.Width() + _nX, aSize.Height() + _nY ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// the controls which stick to the bottom of the window
//STRIP001 	{
//STRIP001 		Window* pMoveDown[] =
//STRIP001 		{
//STRIP001 			&aStatusText, &aHelpBtn, &aCancelBtn
//STRIP001 		};
//STRIP001 		for ( sal_Int32 i = 0; i < sizeof( pMoveDown ) / sizeof( pMoveDown[0] ); ++i )
//STRIP001 		{
//STRIP001 			aPos = pMoveDown[i]->GetPosPixel();
//STRIP001 			aPos.Y() += _nY;
//STRIP001 			pMoveDown[i]->SetPosPixel( aPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// the controls which stick to the right
//STRIP001 	{
//STRIP001 		Window* pMoveRight[] =
//STRIP001 		{
//STRIP001 			&aIgnoreBtn, &aIgnoreAllBtn, &aChangeBtn, &aChangeAllBtn, &aHelpBtn, &aCancelBtn
//STRIP001 		};
//STRIP001 		for ( sal_Int32 i = 0; i < sizeof( pMoveRight ) / sizeof( pMoveRight[0] ); ++i )
//STRIP001 		{
//STRIP001 			aPos = pMoveRight[i]->GetPosPixel();
//STRIP001 			aPos.X() += _nX;
//STRIP001 			pMoveRight[i]->SetPosPixel( aPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
}
