/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_dlgctrl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:40:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#ifndef _APP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
#pragma hdrstop

#include "xoutx.hxx"
#include "xtable.hxx"
#include "xpool.hxx"

#include "dialogs.hrc"
#include "accessibility.hrc"
#include "dlgctrl.hxx"
#include "dialmgr.hxx"

#ifndef _TL_POLY_HXX
#include <tools/poly.hxx>
#endif
#ifndef _SV_REGION_HXX
#include <vcl/region.hxx>
#endif
#ifndef _SV_GRADIENT_HXX
#include <vcl/gradient.hxx>
#endif
#ifndef _SV_HATCH_HXX
#include <vcl/hatch.hxx>
#endif

#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif

#include "svxrectctaccessiblecontext.hxx"

#ifndef _COM_SUN_STAR_LANG_XUNOTUNNEL_HPP_
#include <com/sun/star/lang/XUnoTunnel.hpp>
#endif
namespace binfilter {

//STRIP001 #define OUTPUT_DRAWMODE_COLOR		(DRAWMODE_DEFAULT)
//STRIP001 #define OUTPUT_DRAWMODE_CONTRAST	(DRAWMODE_SETTINGSLINE | DRAWMODE_SETTINGSFILL | DRAWMODE_SETTINGSTEXT | DRAWMODE_SETTINGSGRADIENT)
//STRIP001 
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::lang;
//STRIP001 using namespace ::com::sun::star::accessibility;
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Control zur Darstellung und Auswahl der Eckpunkte (und Mittelpunkt)
//STRIP001 |*	eines Objekts
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 inline Bitmap* SvxRectCtl::GetBitmap( void )
//STRIP001 {
//STRIP001 	if( !pBitmap )
//STRIP001 		InitBitmap();
//STRIP001 
//STRIP001 	return pBitmap;
//STRIP001 }
//STRIP001 
//STRIP001 SvxRectCtl::SvxRectCtl( Window* pParent, const ResId& rResId, RECT_POINT eRpt,
//STRIP001 						USHORT nBorder, USHORT nCircle, CTL_STYLE eStyle ) :
//STRIP001 
//STRIP001 	Control( pParent, rResId ),
//STRIP001 
//STRIP001 	pAccContext	( NULL ),
//STRIP001 	eDefRP		( eRpt ),
//STRIP001 	nBorderWidth( nBorder ),
//STRIP001 	nRadius		( nCircle),
//STRIP001 	m_nState	( 0 ),
//STRIP001 	eCS			( eStyle ),
//STRIP001 	pBitmap		( NULL ),
//STRIP001 	mbCompleteDisable(sal_False)
//STRIP001 {
//STRIP001 	SetMapMode( MAP_100TH_MM );
//STRIP001     Resize_Impl();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxRectCtl::~SvxRectCtl()
//STRIP001 {
//STRIP001 	delete pBitmap;
//STRIP001 
//STRIP001 	if( pAccContext )
//STRIP001 		pAccContext->release();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SvxRectCtl::Resize()
//STRIP001 {
//STRIP001     Resize_Impl();
//STRIP001     Control::Resize();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxRectCtl::Resize_Impl()
//STRIP001 {
//STRIP001     aSize = GetOutputSize();
//STRIP001 
//STRIP001 	switch( eCS )
//STRIP001 	{
//STRIP001 		case CS_RECT:
//STRIP001 		case CS_ANGLE:
//STRIP001 		case CS_SHADOW:
//STRIP001 			aPtLT = Point( 0 + nBorderWidth,  0 + nBorderWidth );
//STRIP001 			aPtMT = Point( aSize.Width() / 2, 0 + nBorderWidth );
//STRIP001 			aPtRT = Point( aSize.Width() - nBorderWidth, 0 + nBorderWidth );
//STRIP001 
//STRIP001 			aPtLM = Point( 0 + nBorderWidth,  aSize.Height() / 2 );
//STRIP001 			aPtMM = Point( aSize.Width() / 2, aSize.Height() / 2 );
//STRIP001 			aPtRM = Point( aSize.Width() - nBorderWidth, aSize.Height() / 2 );
//STRIP001 
//STRIP001 			aPtLB = Point( 0 + nBorderWidth,	aSize.Height() - nBorderWidth );
//STRIP001 			aPtMB = Point( aSize.Width() / 2,	aSize.Height() - nBorderWidth );
//STRIP001 			aPtRB = Point( aSize.Width() - nBorderWidth, aSize.Height() - nBorderWidth );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case CS_LINE:
//STRIP001 			aPtLT = Point( 0 + 3 * nBorderWidth,  0 + nBorderWidth );
//STRIP001 			aPtMT = Point( aSize.Width() / 2, 0 + nBorderWidth );
//STRIP001 			aPtRT = Point( aSize.Width() - 3 * nBorderWidth, 0 + nBorderWidth );
//STRIP001 
//STRIP001 			aPtLM = Point( 0 + 3 * nBorderWidth,  aSize.Height() / 2 );
//STRIP001 			aPtMM = Point( aSize.Width() / 2, aSize.Height() / 2 );
//STRIP001 			aPtRM = Point( aSize.Width() - 3 * nBorderWidth, aSize.Height() / 2 );
//STRIP001 
//STRIP001 			aPtLB = Point( 0 + 3 * nBorderWidth,	aSize.Height() - nBorderWidth );
//STRIP001 			aPtMB = Point( aSize.Width() / 2,	aSize.Height() - nBorderWidth );
//STRIP001 			aPtRB = Point( aSize.Width() - 3 * nBorderWidth, aSize.Height() - nBorderWidth );
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	Reset();
//STRIP001 	InitSettings( TRUE, TRUE );
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxRectCtl::InitBitmap( void )
//STRIP001 {
//STRIP001 	if( pBitmap )
//STRIP001 		delete pBitmap;
//STRIP001 
//STRIP001 	const StyleSettings&	rStyles = Application::GetSettings().GetStyleSettings();
//STRIP001 	svtools::ColorConfig aColorConfig;
//STRIP001 
//STRIP001 	pBitmap = new Bitmap( SVX_RES( RID_SVXCTRL_RECTBTNS ) );
//STRIP001 
//STRIP001 	// set bitmap-colors
//STRIP001 	long	aTempAry1[(7*sizeof(Color))/sizeof(long)];
//STRIP001 	long	aTempAry2[(7*sizeof(Color))/sizeof(long)];
//STRIP001 	Color*	pColorAry1 = (Color*)aTempAry1;
//STRIP001 	Color*	pColorAry2 = (Color*)aTempAry2;
//STRIP001 	pColorAry1[0] = Color( 0xC0, 0xC0, 0xC0 );	// light-gray
//STRIP001 	pColorAry1[1] = Color( 0xFF, 0xFF, 0x00 );	// yellow
//STRIP001 	pColorAry1[2] = Color( 0xFF, 0xFF, 0xFF );	// white
//STRIP001 	pColorAry1[3] = Color( 0x80, 0x80, 0x80 );	// dark-gray
//STRIP001 	pColorAry1[4] = Color( 0x00, 0x00, 0x00 );  // black
//STRIP001 	pColorAry1[5] = Color( 0x00, 0xFF, 0x00 );	// green
//STRIP001 	pColorAry1[6] = Color( 0x00, 0x00, 0xFF );	// blue
//STRIP001 	pColorAry2[0] = rStyles.GetDialogColor();		// background
//STRIP001 	pColorAry2[1] = rStyles.GetWindowColor();
//STRIP001 	pColorAry2[2] = rStyles.GetLightColor();
//STRIP001 	pColorAry2[3] = rStyles.GetShadowColor();
//STRIP001 	pColorAry2[4] = rStyles.GetDarkShadowColor();
//STRIP001 	pColorAry2[5] = Color( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001 	pColorAry2[6] = rStyles.GetDialogColor();
//STRIP001 
//STRIP001 #ifdef DBG_UTIL
//STRIP001 	static BOOL		bModify = FALSE;
//STRIP001 	BOOL&			rModify = bModify;
//STRIP001 	if( rModify )
//STRIP001 	{
//STRIP001 		static int		n = 0;
//STRIP001 		static UINT8	r = 0xFF;
//STRIP001 		static UINT8	g = 0x00;
//STRIP001 		static UINT8	b = 0xFF;
//STRIP001 		int&			rn = n;
//STRIP001 		UINT8&			rr = r;
//STRIP001 		UINT8&			rg = g;
//STRIP001 		UINT8&			rb = b;
//STRIP001 		pColorAry2[ rn ] = Color( rr, rg, rb );
//STRIP001 	}
//STRIP001 #endif
//STRIP001 
//STRIP001 	pBitmap->Replace( pColorAry1, pColorAry2, 7, NULL );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxRectCtl::InitSettings( BOOL bForeground, BOOL bBackground )
//STRIP001 {
//STRIP001 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 
//STRIP001 	if( bForeground )
//STRIP001 	{
//STRIP001 		svtools::ColorConfig aColorConfig;
//STRIP001 		Color aTextColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001 
//STRIP001 		if ( IsControlForeground() )
//STRIP001 			aTextColor = GetControlForeground();
//STRIP001 		SetTextColor( aTextColor );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bBackground )
//STRIP001 	{
//STRIP001 		if ( IsControlBackground() )
//STRIP001 			SetBackground( GetControlBackground() );
//STRIP001 		else
//STRIP001 			SetBackground( rStyleSettings.GetWindowColor() );
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pBitmap;
//STRIP001 	pBitmap = NULL;		// forces new creating of bitmap
//STRIP001 
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Das angeklickte Rechteck (3 x 3) wird ermittelt und der Parent (Dialog)
//STRIP001 |*	wird benachrichtigt, dass der Punkt geaendert wurde
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxRectCtl::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	// #103516# CompletelyDisabled() added to have a disabled state for SvxRectCtl
//STRIP001 	if(!IsCompletelyDisabled())
//STRIP001 	{
//STRIP001 		Point aPtLast = aPtNew;
//STRIP001 
//STRIP001 		aPtNew = GetApproxLogPtFromPixPt( rMEvt.GetPosPixel() );
//STRIP001 
//STRIP001 		if( aPtNew == aPtMM && ( eCS == CS_SHADOW || eCS == CS_ANGLE ) )
//STRIP001 		{
//STRIP001 			aPtNew = aPtLast;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Invalidate( Rectangle( aPtLast - Point( nRadius, nRadius ),
//STRIP001 								   aPtLast + Point( nRadius, nRadius ) ) );
//STRIP001 			Invalidate( Rectangle( aPtNew - Point( nRadius, nRadius ),
//STRIP001 								   aPtNew + Point( nRadius, nRadius ) ) );
//STRIP001 			eRP = GetRPFromPoint( aPtNew );
//STRIP001 
//STRIP001 			SetActualRP( eRP );
//STRIP001 
//STRIP001 			if( WINDOW_TABPAGE == GetParent()->GetType() )
//STRIP001 				( (SvxTabPage*) GetParent() )->PointChanged( this, eRP );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxRectCtl::KeyInput( const KeyEvent& rKeyEvt )
//STRIP001 {
//STRIP001 	// #103516# CompletelyDisabled() added to have a disabled state for SvxRectCtl
//STRIP001 	if(!IsCompletelyDisabled())
//STRIP001 	{
//STRIP001 		RECT_POINT eNewRP = eRP;
//STRIP001 		BOOL bUseMM = (eCS != CS_SHADOW) && (eCS != CS_ANGLE);
//STRIP001 
//STRIP001 		switch( rKeyEvt.GetKeyCode().GetCode() )
//STRIP001 		{
//STRIP001 			case KEY_DOWN:
//STRIP001 			{
//STRIP001 				if( !(m_nState & CS_NOVERT) )
//STRIP001 					switch( eNewRP )
//STRIP001 					{
//STRIP001 						case RP_LT: eNewRP = RP_LM; break;
//STRIP001 						case RP_MT: eNewRP = bUseMM ? RP_MM : RP_MB; break;
//STRIP001 						case RP_RT: eNewRP = RP_RM; break;
//STRIP001 						case RP_LM: eNewRP = RP_LB; break;
//STRIP001 						case RP_MM: eNewRP = RP_MB; break;
//STRIP001 						case RP_RM: eNewRP = RP_RB; break;
//STRIP001 					}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case KEY_UP:
//STRIP001 			{
//STRIP001 				if( !(m_nState & CS_NOVERT) )
//STRIP001 					switch( eNewRP )
//STRIP001 					{
//STRIP001 						case RP_LM: eNewRP = RP_LT; break;
//STRIP001 						case RP_MM: eNewRP = RP_MT; break;
//STRIP001 						case RP_RM: eNewRP = RP_RT; break;
//STRIP001 						case RP_LB: eNewRP = RP_LM; break;
//STRIP001 						case RP_MB: eNewRP = bUseMM ? RP_MM : RP_MT; break;
//STRIP001 						case RP_RB: eNewRP = RP_RM; break;
//STRIP001 					}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case KEY_LEFT:
//STRIP001 			{
//STRIP001 				if( !(m_nState & CS_NOHORZ) )
//STRIP001 					switch( eNewRP )
//STRIP001 					{
//STRIP001 						case RP_MT: eNewRP = RP_LT; break;
//STRIP001 						case RP_RT: eNewRP = RP_MT; break;
//STRIP001 						case RP_MM: eNewRP = RP_LM; break;
//STRIP001 						case RP_RM: eNewRP = bUseMM ? RP_MM : RP_LM; break;
//STRIP001 						case RP_MB: eNewRP = RP_LB; break;
//STRIP001 						case RP_RB: eNewRP = RP_MB; break;
//STRIP001 					}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case KEY_RIGHT:
//STRIP001 			{
//STRIP001 				if( !(m_nState & CS_NOHORZ) )
//STRIP001 					switch( eNewRP )
//STRIP001 					{
//STRIP001 						case RP_LT: eNewRP = RP_MT; break;
//STRIP001 						case RP_MT: eNewRP = RP_RT; break;
//STRIP001 						case RP_LM: eNewRP = bUseMM ? RP_MM : RP_RM; break;
//STRIP001 						case RP_MM: eNewRP = RP_RM; break;
//STRIP001 						case RP_LB: eNewRP = RP_MB; break;
//STRIP001 						case RP_MB: eNewRP = RP_RB; break;
//STRIP001 					}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			default:
//STRIP001 				Control::KeyInput( rKeyEvt );
//STRIP001 				return;
//STRIP001 		}
//STRIP001 		if( eNewRP != eRP )
//STRIP001 		{
//STRIP001 			SetActualRP( eNewRP );
//STRIP001 
//STRIP001 			if( WINDOW_TABPAGE == GetParent()->GetType() )
//STRIP001 				( (SvxTabPage*) GetParent() )->PointChanged( this, eRP );
//STRIP001 
//STRIP001 			SetFocusRect();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxRectCtl::StateChanged( StateChangedType nType )
//STRIP001 {
//STRIP001 	if ( nType == STATE_CHANGE_CONTROLFOREGROUND )
//STRIP001 		InitSettings( TRUE, FALSE );
//STRIP001 	else if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
//STRIP001 		InitSettings( FALSE, TRUE );
//STRIP001 
//STRIP001 	Window::StateChanged( nType );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxRectCtl::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 		InitSettings( TRUE, TRUE );
//STRIP001 	else
//STRIP001 		Window::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Zeichnet das Control (Rechteck mit 9 Kreisen)
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxRectCtl::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	Point	aPtDiff( PixelToLogic( Point( 1, 1 ) ) );
//STRIP001 
//STRIP001 	const StyleSettings& rStyles = Application::GetSettings().GetStyleSettings();
//STRIP001 
//STRIP001 	SetLineColor( rStyles.GetDialogColor() );
//STRIP001 	SetFillColor( rStyles.GetDialogColor() );
//STRIP001 	DrawRect( Rectangle( Point(0,0), GetOutputSize() ) );
//STRIP001 
//STRIP001 	if( IsEnabled() )
//STRIP001 		SetLineColor( rStyles.GetLabelTextColor() );
//STRIP001 	else
//STRIP001 		SetLineColor( rStyles.GetShadowColor() );
//STRIP001 
//STRIP001 	SetFillColor();
//STRIP001 
//STRIP001 	switch( eCS )
//STRIP001 	{
//STRIP001 
//STRIP001 		case CS_RECT:
//STRIP001 		case CS_SHADOW:
//STRIP001 			if( !IsEnabled() )
//STRIP001 			{
//STRIP001 				Color aOldCol = GetLineColor();
//STRIP001 				SetLineColor( rStyles.GetLightColor() );
//STRIP001 				DrawRect( Rectangle( aPtLT + aPtDiff, aPtRB + aPtDiff ) );
//STRIP001 				SetLineColor( aOldCol );
//STRIP001 			}
//STRIP001 			DrawRect( Rectangle( aPtLT, aPtRB ) );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case CS_LINE:
//STRIP001 			if( !IsEnabled() )
//STRIP001 			{
//STRIP001 				Color aOldCol = GetLineColor();
//STRIP001 				SetLineColor( rStyles.GetLightColor() );
//STRIP001 				DrawLine( aPtLM - Point( 2 * nBorderWidth, 0) + aPtDiff,
//STRIP001 						  aPtRM + Point( 2 * nBorderWidth, 0 ) + aPtDiff );
//STRIP001 				SetLineColor( aOldCol );
//STRIP001 			}
//STRIP001 			DrawLine( aPtLM - Point( 2 * nBorderWidth, 0),
//STRIP001 					  aPtRM + Point( 2 * nBorderWidth, 0 ) );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case CS_ANGLE:
//STRIP001 			if( !IsEnabled() )
//STRIP001 			{
//STRIP001 				Color aOldCol = GetLineColor();
//STRIP001 				SetLineColor( rStyles.GetLightColor() );
//STRIP001 				DrawLine( aPtLT + aPtDiff, aPtRB + aPtDiff );
//STRIP001 				DrawLine( aPtLB + aPtDiff, aPtRT + aPtDiff );
//STRIP001 				DrawLine( aPtLM + aPtDiff, aPtRM + aPtDiff );
//STRIP001 				DrawLine( aPtMT + aPtDiff, aPtMB + aPtDiff );
//STRIP001 				SetLineColor( aOldCol );
//STRIP001 			}
//STRIP001 			DrawLine( aPtLT, aPtRB );
//STRIP001 			DrawLine( aPtLB, aPtRT );
//STRIP001 			DrawLine( aPtLM, aPtRM );
//STRIP001 			DrawLine( aPtMT, aPtMB );
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	SetFillColor( GetBackground().GetColor() );
//STRIP001 
//STRIP001 	Size aBtnSize( 11, 11 );
//STRIP001 	Size aDstBtnSize(  PixelToLogic( aBtnSize ) );
//STRIP001 	Point aToCenter( aDstBtnSize.Width() >> 1, aDstBtnSize.Height() >> 1);
//STRIP001 	Point aBtnPnt1( IsEnabled()?0:22,0 );
//STRIP001 	Point aBtnPnt2( 11,0 );
//STRIP001 	Point aBtnPnt3( 22,0 );
//STRIP001 
//STRIP001 	BOOL bNoHorz = (m_nState & CS_NOHORZ) != 0;
//STRIP001 	BOOL bNoVert = (m_nState & CS_NOVERT) != 0;
//STRIP001 
//STRIP001 	Bitmap&			rBitmap = *GetBitmap();
//STRIP001 
//STRIP001 	// #103516# CompletelyDisabled() added to have a disabled state for SvxRectCtl
//STRIP001 	if(IsCompletelyDisabled())
//STRIP001 	{
//STRIP001 		DrawBitmap( aPtLT - aToCenter, aDstBtnSize, aBtnPnt3, aBtnSize, rBitmap );
//STRIP001 		DrawBitmap( aPtMT - aToCenter, aDstBtnSize, aBtnPnt3, aBtnSize, rBitmap );
//STRIP001 		DrawBitmap( aPtRT - aToCenter, aDstBtnSize, aBtnPnt3, aBtnSize, rBitmap );
//STRIP001 		DrawBitmap( aPtLM - aToCenter, aDstBtnSize, aBtnPnt3, aBtnSize, rBitmap );
//STRIP001 		if( eCS == CS_RECT || eCS == CS_LINE )
//STRIP001 			DrawBitmap( aPtMM - aToCenter, aDstBtnSize, aBtnPnt3, aBtnSize, rBitmap );
//STRIP001 		DrawBitmap( aPtRM - aToCenter, aDstBtnSize, aBtnPnt3, aBtnSize, rBitmap );
//STRIP001 		DrawBitmap( aPtLB - aToCenter, aDstBtnSize, aBtnPnt3, aBtnSize, rBitmap );
//STRIP001 		DrawBitmap( aPtMB - aToCenter, aDstBtnSize, aBtnPnt3, aBtnSize, rBitmap );
//STRIP001 		DrawBitmap( aPtRB - aToCenter, aDstBtnSize, aBtnPnt3, aBtnSize, rBitmap );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DrawBitmap( aPtLT - aToCenter, aDstBtnSize, (bNoHorz | bNoVert)?aBtnPnt3:aBtnPnt1, aBtnSize, rBitmap );
//STRIP001 		DrawBitmap( aPtMT - aToCenter, aDstBtnSize, bNoVert?aBtnPnt3:aBtnPnt1, aBtnSize, rBitmap );
//STRIP001 		DrawBitmap( aPtRT - aToCenter, aDstBtnSize, (bNoHorz | bNoVert)?aBtnPnt3:aBtnPnt1, aBtnSize, rBitmap );
//STRIP001 
//STRIP001 		DrawBitmap( aPtLM - aToCenter, aDstBtnSize, bNoHorz?aBtnPnt3:aBtnPnt1, aBtnSize, rBitmap );
//STRIP001 
//STRIP001 		// Mittelpunkt bei Rechteck und Linie
//STRIP001 		if( eCS == CS_RECT || eCS == CS_LINE )
//STRIP001 			DrawBitmap( aPtMM - aToCenter, aDstBtnSize, aBtnPnt1, aBtnSize, rBitmap );
//STRIP001 
//STRIP001 		DrawBitmap( aPtRM - aToCenter, aDstBtnSize, bNoHorz?aBtnPnt3:aBtnPnt1, aBtnSize, rBitmap );
//STRIP001 
//STRIP001 		DrawBitmap( aPtLB - aToCenter, aDstBtnSize, (bNoHorz | bNoVert)?aBtnPnt3:aBtnPnt1, aBtnSize, rBitmap );
//STRIP001 		DrawBitmap( aPtMB - aToCenter, aDstBtnSize, bNoVert?aBtnPnt3:aBtnPnt1, aBtnSize, rBitmap );
//STRIP001 		DrawBitmap( aPtRB - aToCenter, aDstBtnSize, (bNoHorz | bNoVert)?aBtnPnt3:aBtnPnt1, aBtnSize, rBitmap );
//STRIP001 	}
//STRIP001 
//STRIP001 	// draw active button, avoid center pos for angle
//STRIP001 	// #103516# CompletelyDisabled() added to have a disabled state for SvxRectCtl
//STRIP001 	if(!IsCompletelyDisabled())
//STRIP001 	{
//STRIP001 		if( IsEnabled() && (eCS != CS_ANGLE || aPtNew != aPtMM) )
//STRIP001 		{
//STRIP001 			Point		aCenterPt( aPtNew );
//STRIP001 			aCenterPt -= aToCenter;
//STRIP001 
//STRIP001 			DrawBitmap( aCenterPt, aDstBtnSize, aBtnPnt2, aBtnSize, rBitmap );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Konvertiert RECT_POINT in Point
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 Point SvxRectCtl::GetPointFromRP( RECT_POINT eRP) const
//STRIP001 {
//STRIP001 	switch( eRP )
//STRIP001 	{
//STRIP001 		case RP_LT: return aPtLT;
//STRIP001 		case RP_MT: return aPtMT;
//STRIP001 		case RP_RT: return aPtRT;
//STRIP001 		case RP_LM: return aPtLM;
//STRIP001 		case RP_MM: return aPtMM;
//STRIP001 		case RP_RM: return aPtRM;
//STRIP001 		case RP_LB: return aPtLB;
//STRIP001 		case RP_MB: return aPtMB;
//STRIP001 		case RP_RB: return aPtRB;
//STRIP001 	}
//STRIP001 	return( aPtMM ); // default
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SvxRectCtl::SetFocusRect( const Rectangle* pRect )
//STRIP001 {
//STRIP001 	HideFocus();
//STRIP001 
//STRIP001 	if( pRect )
//STRIP001 		ShowFocus( *pRect );
//STRIP001 	else
//STRIP001 		ShowFocus( CalculateFocusRectangle() );
//STRIP001 }
//STRIP001 
//STRIP001 Point SvxRectCtl::SetActualRPWithoutInvalidate( RECT_POINT eNewRP )
//STRIP001 {
//STRIP001 	Point aPtLast = aPtNew;
//STRIP001 	aPtNew = GetPointFromRP( eNewRP );
//STRIP001 
//STRIP001 	if( (m_nState & CS_NOHORZ) != 0 )
//STRIP001 		aPtNew.X() = aPtMM.X();
//STRIP001 
//STRIP001 	if( (m_nState & CS_NOVERT) != 0 )
//STRIP001 		aPtNew.Y() = aPtMM.Y();
//STRIP001 
//STRIP001 	eNewRP = GetRPFromPoint( aPtNew );
//STRIP001 
//STRIP001 	eDefRP = eNewRP;
//STRIP001 	eRP = eNewRP;
//STRIP001 
//STRIP001 	return aPtLast;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxRectCtl::GetFocus()
//STRIP001 {
//STRIP001 	SetFocusRect();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SvxRectCtl::LoseFocus()
//STRIP001 {
//STRIP001 	HideFocus();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 Point SvxRectCtl::GetApproxLogPtFromPixPt( const Point& rPt ) const
//STRIP001 {
//STRIP001 	Point	aPt = PixelToLogic( rPt );
//STRIP001 	long	x;
//STRIP001 	long	y;
//STRIP001 
//STRIP001 	if( ( m_nState & CS_NOHORZ ) == 0 )
//STRIP001 	{
//STRIP001 		if( aPt.X() < aSize.Width() / 3 )
//STRIP001 			x = aPtLT.X();
//STRIP001 		else if( aPt.X() < aSize.Width() * 2 / 3 )
//STRIP001 			x = aPtMM.X();
//STRIP001 		else
//STRIP001 			x = aPtRB.X();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		x = aPtMM.X();
//STRIP001 
//STRIP001 	if( ( m_nState & CS_NOVERT ) == 0 )
//STRIP001 	{
//STRIP001 		if( aPt.Y() < aSize.Height() / 3 )
//STRIP001 			y = aPtLT.Y();
//STRIP001 		else if( aPt.Y() < aSize.Height() * 2 / 3 )
//STRIP001 			y = aPtMM.Y();
//STRIP001 		else
//STRIP001 			y = aPtRB.Y();
//STRIP001 	}
//STRIP001 	else
//STRIP001 			y = aPtMM.Y();
//STRIP001 
//STRIP001 	return Point( x, y );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Konvertiert Point in RECT_POINT
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 RECT_POINT SvxRectCtl::GetRPFromPoint( Point aPt ) const
//STRIP001 {
//STRIP001 	if	   ( aPt == aPtLT) return RP_LT;
//STRIP001 	else if( aPt == aPtMT) return RP_MT;
//STRIP001 	else if( aPt == aPtRT) return RP_RT;
//STRIP001 	else if( aPt == aPtLM) return RP_LM;
//STRIP001 	else if( aPt == aPtRM) return RP_RM;
//STRIP001 	else if( aPt == aPtLB) return RP_LB;
//STRIP001 	else if( aPt == aPtMB) return RP_MB;
//STRIP001 	else if( aPt == aPtRB) return RP_RB;
//STRIP001 
//STRIP001 	else
//STRIP001 		return RP_MM; // default
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Bewirkt den Ursprungszustand des Controls
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxRectCtl::Reset()
//STRIP001 {
//STRIP001 	aPtNew = GetPointFromRP( eDefRP );
//STRIP001 	eRP = eDefRP;
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Gibt den aktuell ausgewaehlten RECT_POINT zurck
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 RECT_POINT SvxRectCtl::GetActualRP() const
//STRIP001 {
//STRIP001 	return( eRP );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Gibt den aktuell ausgewaehlten RECT_POINT zurck
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxRectCtl::SetActualRP( RECT_POINT eNewRP )
//STRIP001 {
//STRIP001 	Point aPtLast( SetActualRPWithoutInvalidate( eNewRP ) );
//STRIP001 
//STRIP001 	Invalidate( Rectangle( aPtLast - Point( nRadius, nRadius ), aPtLast + Point( nRadius, nRadius ) ) );
//STRIP001 	Invalidate( Rectangle( aPtNew - Point( nRadius, nRadius ), aPtNew + Point( nRadius, nRadius ) ) );
//STRIP001 
//STRIP001 	// notify accessability object about change
//STRIP001 	if( pAccContext )
//STRIP001 		pAccContext->selectChild( eNewRP );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxRectCtl::SetState( CTL_STATE nState )
//STRIP001 {
//STRIP001 	m_nState = nState;
//STRIP001 
//STRIP001 	Point aPtLast( GetPointFromRP( eRP ) );
//STRIP001 	Point aPtNew( aPtLast );
//STRIP001 
//STRIP001 	if( (m_nState & CS_NOHORZ) != 0 )
//STRIP001 		aPtNew.X() = aPtMM.X();
//STRIP001 
//STRIP001 	if( (m_nState & CS_NOVERT) != 0 )
//STRIP001 		aPtNew.Y() = aPtMM.Y();
//STRIP001 
//STRIP001 	eRP = GetRPFromPoint( aPtNew );
//STRIP001 	Invalidate();
//STRIP001 
//STRIP001 	if( WINDOW_TABPAGE == GetParent()->GetType() )
//STRIP001 		( (SvxTabPage*) GetParent() )->PointChanged( this, eRP );
//STRIP001 }
//STRIP001 
//STRIP001 UINT8 SvxRectCtl::GetNumOfChilds( void ) const
//STRIP001 {
//STRIP001 	return ( eCS == CS_ANGLE )? 8 : 9;
//STRIP001 }
//STRIP001 
//STRIP001 Rectangle SvxRectCtl::CalculateFocusRectangle( void ) const
//STRIP001 {
//STRIP001 	Size		aDstBtnSize( PixelToLogic( Size( 15, 15 ) ) );
//STRIP001 	return Rectangle( aPtNew - Point( aDstBtnSize.Width() >> 1, aDstBtnSize.Height() >> 1 ), aDstBtnSize );
//STRIP001 }
//STRIP001 
//STRIP001 Rectangle SvxRectCtl::CalculateFocusRectangle( RECT_POINT eRectPoint ) const
//STRIP001 {
//STRIP001 	Rectangle	aRet;
//STRIP001 	RECT_POINT	eOldRectPoint = GetActualRP();
//STRIP001 
//STRIP001 	if( eOldRectPoint == eRectPoint )
//STRIP001 		aRet = CalculateFocusRectangle();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SvxRectCtl*	pThis = const_cast< SvxRectCtl* >( this );
//STRIP001 
//STRIP001 		pThis->SetActualRPWithoutInvalidate( eRectPoint );		// no invalidation because it's only temporary!
//STRIP001 		aRet = CalculateFocusRectangle();
//STRIP001 
//STRIP001 		pThis->SetActualRPWithoutInvalidate( eOldRectPoint );	// no invalidation because nothing has changed!
//STRIP001 	}
//STRIP001 
//STRIP001 	return aRet;
//STRIP001 }
//STRIP001 
//STRIP001 Reference< XAccessible > SvxRectCtl::CreateAccessible()
//STRIP001 {
//STRIP001 	Window*						pParent = GetAccessibleParentWindow();
//STRIP001 
//STRIP001 	DBG_ASSERT( pParent, "-SvxRectCtl::CreateAccessible(): No Parent!" );
//STRIP001 
//STRIP001 	Reference< XAccessible >	xAccParent  = pParent->GetAccessible();
//STRIP001 	if( xAccParent.is() )
//STRIP001 	{
//STRIP001 		pAccContext = new SvxRectCtlAccessibleContext( xAccParent, *this );
//STRIP001 		pAccContext->acquire();
//STRIP001 
//STRIP001         SetActualRP( GetActualRP() );
//STRIP001 
//STRIP001 		return pAccContext;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return Reference< XAccessible >();
//STRIP001 }
//STRIP001 
//STRIP001 RECT_POINT SvxRectCtl::GetApproxRPFromPixPt( const ::com::sun::star::awt::Point& r ) const
//STRIP001 {
//STRIP001 	return GetRPFromPoint( GetApproxLogPtFromPixPt( Point( r.X, r.Y ) ) );
//STRIP001 }
//STRIP001 
//STRIP001 // #103516# CompletelyDisabled() added to have a disabled state for SvxRectCtl
//STRIP001 void SvxRectCtl::DoCompletelyDisable(sal_Bool bNew) 
//STRIP001 { 
//STRIP001 	mbCompleteDisable = bNew; 
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Konstruktor ohne Size-Parameter
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxAngleCtl::SvxAngleCtl( Window* pParent, const ResId& rResId ) :
//STRIP001 
//STRIP001 	SvxRectCtl( pParent, rResId ),
//STRIP001 
//STRIP001 	aFont( Application::GetSettings().GetStyleSettings().GetAppFont() )
//STRIP001 {
//STRIP001 	aFontSize = Size( 250, 400 );
//STRIP001 	Initialize();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Konstruktor mit Size-Parameter
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxAngleCtl::SvxAngleCtl( Window* pParent, const ResId& rResId, Size aSize ) :
//STRIP001 
//STRIP001 	SvxRectCtl( pParent, rResId ),
//STRIP001 
//STRIP001 	aFont( Application::GetSettings().GetStyleSettings().GetAppFont() )
//STRIP001 {
//STRIP001 	aFontSize = aSize;
//STRIP001 	Initialize();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Initialisierung
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxAngleCtl::Initialize()
//STRIP001 {
//STRIP001 	bPositive = TRUE;
//STRIP001 
//STRIP001 	// aFont.SetName( "Helvetica" );
//STRIP001 	aFont.SetSize( aFontSize );
//STRIP001 	aFont.SetWeight( WEIGHT_NORMAL );
//STRIP001 	aFont.SetTransparent( FALSE );
//STRIP001 
//STRIP001 	SetFont( aFont );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Zeichnet das (Mini-)Koordinatensystem
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxAngleCtl::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	SetLineColor( Color( COL_BLACK ) ); 	// PEN_DOT ???
//STRIP001 	DrawLine( aPtLT - Point( 0, 0), aPtRB + Point( 0, 0 ) );
//STRIP001 	DrawLine( aPtLB - Point( 0, 0), aPtRT + Point( 0, 0 ) );
//STRIP001 
//STRIP001 	SetLineColor( Color( COL_BLACK ) );
//STRIP001 	DrawLine( aPtLM - Point( 0, 0), aPtRM + Point( 0, 0 ) );
//STRIP001 	DrawLine( aPtMT - Point( 0, 0), aPtMB + Point( 0, 0 ) );
//STRIP001 
//STRIP001 	Point aDiff(aFontSize.Width() / 2, aFontSize.Height() / 2);
//STRIP001 
//STRIP001 	DrawText( aPtLT - aDiff, UniString::CreateFromAscii(
//STRIP001 		                     RTL_CONSTASCII_STRINGPARAM( "135" ) ) );
//STRIP001 	DrawText( aPtLM - aDiff, UniString::CreateFromAscii(
//STRIP001 		                     RTL_CONSTASCII_STRINGPARAM( "180" ) ) );
//STRIP001 
//STRIP001 	if ( bPositive )
//STRIP001 		DrawText( aPtLB - aDiff, UniString::CreateFromAscii(
//STRIP001 		                         RTL_CONSTASCII_STRINGPARAM( "225" ) ) );
//STRIP001 	else
//STRIP001 		DrawText( aPtLB - aDiff, UniString::CreateFromAscii(
//STRIP001 		                         RTL_CONSTASCII_STRINGPARAM( "-135" ) ) );
//STRIP001 
//STRIP001 	aDiff.X() = aFontSize.Width();
//STRIP001 	DrawText( aPtMT - aDiff, UniString::CreateFromAscii(
//STRIP001 		                     RTL_CONSTASCII_STRINGPARAM( "90" ) ) );
//STRIP001 	DrawText( aPtRT - aDiff, UniString::CreateFromAscii(
//STRIP001 		                     RTL_CONSTASCII_STRINGPARAM( "45" ) ) );
//STRIP001 	aDiff.X() = aDiff .X() * 3 / 2;
//STRIP001 
//STRIP001 	if ( bPositive )
//STRIP001 		DrawText( aPtMB - aDiff, UniString::CreateFromAscii(
//STRIP001 		                         RTL_CONSTASCII_STRINGPARAM( "270" ) ) );
//STRIP001 	else
//STRIP001 		DrawText( aPtMB - aDiff, UniString::CreateFromAscii(
//STRIP001 		                         RTL_CONSTASCII_STRINGPARAM( "-90" ) ) );
//STRIP001 
//STRIP001 	DrawText( aPtRM - Point( 0, aDiff.Y() ), UniString::CreateFromAscii(
//STRIP001 		                                     RTL_CONSTASCII_STRINGPARAM( "0" ) ) );
//STRIP001 	aDiff.X() = aFontSize.Width() * 2;
//STRIP001 
//STRIP001 	if ( bPositive )
//STRIP001 		DrawText( aPtRB - aDiff, UniString::CreateFromAscii(
//STRIP001 		                         RTL_CONSTASCII_STRINGPARAM( "315" ) ) );
//STRIP001 	else
//STRIP001 		DrawText( aPtRB - aDiff, UniString::CreateFromAscii(
//STRIP001 		                         RTL_CONSTASCII_STRINGPARAM( "-45" ) ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Control zum Editieren von Bitmaps
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxPixelCtl::SvxPixelCtl( Window* pParent, const ResId& rResId, USHORT nNumber ) :
//STRIP001 						Control		( pParent, rResId ),
//STRIP001 						nLines		( nNumber ),
//STRIP001 						bPaintable	( TRUE )
//STRIP001 {
//STRIP001 	// SetMapMode( MAP_100TH_MM );
//STRIP001 	aRectSize = GetOutputSize();
//STRIP001 
//STRIP001 	SetPixelColor( Color( COL_BLACK ) );
//STRIP001 	SetBackgroundColor( Color( COL_WHITE ) );
//STRIP001 	SetLineColor( Application::GetSettings().GetStyleSettings().GetShadowColor() );
//STRIP001 
//STRIP001 	nSquares = nLines * nLines;
//STRIP001 	pPixel = new USHORT[ nSquares ];
//STRIP001 
//STRIP001 	// Reset();	<-- wird vom Dialog aufgerufen
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Destruktor dealociert dyn. Array
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxPixelCtl::~SvxPixelCtl( )
//STRIP001 {
//STRIP001 	delete []pPixel;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Wechselt die Vordergrund- ,bzw. Hintergrundfarbe
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxPixelCtl::ChangePixel( USHORT nPixel )
//STRIP001 {
//STRIP001 	if( *( pPixel + nPixel) == 0 )
//STRIP001 		*( pPixel + nPixel) = 1; // koennte erweitert werden auf mehrere Farben
//STRIP001 	else
//STRIP001 		*( pPixel + nPixel) = 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Das angeklickte Rechteck wird ermittelt um die Farbe zu wechseln
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxPixelCtl::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	Point aPt = PixelToLogic( rMEvt.GetPosPixel() );
//STRIP001 	Point aPtTl, aPtBr;
//STRIP001 	USHORT	nX, nY;
//STRIP001 
//STRIP001 	nX = (USHORT) ( aPt.X() * nLines / aRectSize.Width() );
//STRIP001 	nY = (USHORT) ( aPt.Y() * nLines / aRectSize.Height() );
//STRIP001 
//STRIP001 	ChangePixel( nX + nY * nLines );
//STRIP001 
//STRIP001 	aPtTl.X() = aRectSize.Width() * nX / nLines + 1;
//STRIP001 	aPtBr.X() = aRectSize.Width() * (nX + 1) / nLines - 1;
//STRIP001 	aPtTl.Y() = aRectSize.Height() * nY / nLines + 1;
//STRIP001 	aPtBr.Y() = aRectSize.Height() * (nY + 1) / nLines - 1;
//STRIP001 
//STRIP001 	Invalidate( Rectangle( aPtTl, aPtBr ) );
//STRIP001 
//STRIP001 	if( WINDOW_TABPAGE == GetParent()->GetType() )
//STRIP001 		( (SvxTabPage*) GetParent() )->PointChanged( this, RP_MM ); // RectPoint ist dummy
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Zeichnet das Control (Rechteck mit 9 Kreisen)
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxPixelCtl::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	USHORT	i, j, nTmp;
//STRIP001 	Point	aPtTl, aPtBr;
//STRIP001 
//STRIP001 	if( bPaintable )
//STRIP001 	{
//STRIP001 		// Linien Zeichnen
//STRIP001 		Control::SetLineColor( aLineColor );
//STRIP001 		for( i = 1; i < nLines; i++)
//STRIP001 		{
//STRIP001 			// horizontal
//STRIP001 			nTmp = (USHORT) ( aRectSize.Height() * i / nLines );
//STRIP001 			DrawLine( Point( 0, nTmp ), Point( aRectSize.Width(), nTmp ) );
//STRIP001 			// vertikal
//STRIP001 			nTmp = (USHORT) ( aRectSize.Width() * i / nLines );
//STRIP001 			DrawLine( Point( nTmp, 0 ), Point( nTmp, aRectSize.Height() ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Rechtecke (Quadrate) zeichnen
//STRIP001 		Control::SetLineColor();
//STRIP001 		USHORT nLastPixel = *pPixel ? 0 : 1;
//STRIP001 
//STRIP001 		for( i = 0; i < nLines; i++)
//STRIP001 		{
//STRIP001 			aPtTl.Y() = aRectSize.Height() * i / nLines + 1;
//STRIP001 			aPtBr.Y() = aRectSize.Height() * (i + 1) / nLines - 1;
//STRIP001 
//STRIP001 			for( j = 0; j < nLines; j++)
//STRIP001 			{
//STRIP001 				aPtTl.X() = aRectSize.Width() * j / nLines + 1;
//STRIP001 				aPtBr.X() = aRectSize.Width() * (j + 1) / nLines - 1;
//STRIP001 
//STRIP001 				if ( *( pPixel + i * nLines + j ) != nLastPixel )
//STRIP001 				{
//STRIP001 					nLastPixel = *( pPixel + i * nLines + j );
//STRIP001 					// Farbe wechseln: 0 -> Hintergrundfarbe
//STRIP001 					SetFillColor( nLastPixel ? aPixelColor : aBackgroundColor );
//STRIP001 				}
//STRIP001 				DrawRect( Rectangle( aPtTl, aPtBr ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	} // bPaintable
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SetBackground( Wallpaper( Color( COL_LIGHTGRAY ) ) );
//STRIP001 		Control::SetLineColor( Color( COL_LIGHTRED ) );
//STRIP001 		DrawLine( Point( 0, 0 ), Point( aRectSize.Width(), aRectSize.Height() ) );
//STRIP001 		DrawLine( Point( 0, aRectSize.Height() ), Point( aRectSize.Width(), 0 ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxPixelCtl::SetXBitmap( const XOBitmap& rXBmp )
//STRIP001 {
//STRIP001 	if( rXBmp.GetBitmapType() == XBITMAP_8X8 )
//STRIP001 	{
//STRIP001 		aPixelColor = rXBmp.GetPixelColor();
//STRIP001 		aBackgroundColor = rXBmp.GetBackgroundColor();
//STRIP001 
//STRIP001 		USHORT* pArray = rXBmp.GetPixelArray();
//STRIP001 
//STRIP001 		for( USHORT i = 0; i < nSquares; i++ )
//STRIP001 			*( pPixel + i ) = *( pArray + i );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Gibt ein bestimmtes Pixel zurueck
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 USHORT SvxPixelCtl::GetPixel( const USHORT nPixel )
//STRIP001 {
//STRIP001 	return( *( pPixel + nPixel ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Bewirkt den Ursprungszustand des Controls
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxPixelCtl::Reset()
//STRIP001 {
//STRIP001 	// Initialisierung des Arrays
//STRIP001 	for( USHORT i = 0; i < nSquares; i++)
//STRIP001 		*(pPixel + i) = 0;
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Ctor: BitmapCtl fuer SvxPixelCtl
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxBitmapCtl::SvxBitmapCtl( Window* pParent, const Size& rSize )
//STRIP001 {
//STRIP001 	aSize = rSize;
//STRIP001 	// aVD.SetOutputSizePixel( aSize );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Dtor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxBitmapCtl::~SvxBitmapCtl()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	BitmapCtl:	Gibt die Bitmap zurueck
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 XOBitmap SvxBitmapCtl::GetXBitmap()
//STRIP001 {
//STRIP001 	XOBitmap aXOBitmap( pBmpArray, aPixelColor, aBackgroundColor );
//STRIP001 
//STRIP001 	return( aXOBitmap );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Fuellt die Listbox mit Farben und Strings
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void ColorLB::Fill( const XColorTable* pColorTab )
//STRIP001 {
//STRIP001 	long nCount = pColorTab->Count();
//STRIP001 	XColorEntry* pEntry;
//STRIP001 	SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	for( long i = 0; i < nCount; i++ )
//STRIP001 	{
//STRIP001 		pEntry = pColorTab->Get( i );
//STRIP001 		InsertEntry( pEntry->GetColor(), pEntry->GetName() );
//STRIP001 	}
//STRIP001 	SetUpdateMode( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void ColorLB::Append( XColorEntry* pEntry, Bitmap* pBmp )
//STRIP001 {
//STRIP001 	InsertEntry( pEntry->GetColor(), pEntry->GetName() );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void ColorLB::Modify( XColorEntry* pEntry, USHORT nPos, Bitmap* pBmp )
//STRIP001 {
//STRIP001 	RemoveEntry( nPos );
//STRIP001 	InsertEntry( pEntry->GetColor(), pEntry->GetName(), nPos );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Fuellt die Listbox mit Farben und Strings
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void FillAttrLB::Fill( const XColorTable* pColorTab )
//STRIP001 {
//STRIP001 	long nCount = pColorTab->Count();
//STRIP001 	XColorEntry* pEntry;
//STRIP001 	SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	for( long i = 0; i < nCount; i++ )
//STRIP001 	{
//STRIP001 		pEntry = pColorTab->Get( i );
//STRIP001 		InsertEntry( pEntry->GetColor(), pEntry->GetName() );
//STRIP001 	}
//STRIP001 	SetUpdateMode( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Fuellt die Listbox (vorlaeufig) mit Strings
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 HatchingLB::HatchingLB( Window* pParent, ResId Id, BOOL bUserDraw /*= TRUE*/ )
//STRIP001 : ListBox( pParent, Id ),
//STRIP001   mpList ( NULL ),
//STRIP001   mbUserDraw( bUserDraw )
//STRIP001 {
//STRIP001 	EnableUserDraw( mbUserDraw );
//STRIP001 }
//STRIP001 
//STRIP001 HatchingLB::HatchingLB( Window* pParent, WinBits aWB, BOOL bUserDraw /*= TRUE*/ )
//STRIP001 : ListBox( pParent, aWB ),
//STRIP001   mpList ( NULL ),
//STRIP001   mbUserDraw( bUserDraw )
//STRIP001 {
//STRIP001 	EnableUserDraw( mbUserDraw );
//STRIP001 }
//STRIP001 
//STRIP001 void HatchingLB::Fill( const XHatchList* pList )
//STRIP001 {
//STRIP001 	mpList = (XHatchList*)pList;
//STRIP001 	XHatchEntry* pEntry;
//STRIP001 	long nCount = pList->Count();
//STRIP001 
//STRIP001 	SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	if( mbUserDraw )
//STRIP001 	{
//STRIP001 		for( long i = 0; i < nCount; i++ )
//STRIP001 			InsertEntry( pList->Get( i )->GetName() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		for( long i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			pEntry = pList->Get( i );
//STRIP001 			Bitmap* pBitmap = pList->GetBitmap( i );
//STRIP001 			if( pBitmap )
//STRIP001 				InsertEntry( pEntry->GetName(), *pBitmap );
//STRIP001 			else
//STRIP001 				InsertEntry( pEntry->GetName() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SetUpdateMode( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 void HatchingLB::UserDraw( const UserDrawEvent& rUDEvt )
//STRIP001 {
//STRIP001 	if( mpList != NULL )
//STRIP001 	{
//STRIP001 		// Draw gradient with borderrectangle
//STRIP001 		const Rectangle& rDrawRect = rUDEvt.GetRect();
//STRIP001 		Rectangle aRect( rDrawRect.nLeft+1, rDrawRect.nTop+1, rDrawRect.nLeft+33, rDrawRect.nBottom-1 );
//STRIP001 
//STRIP001 		USHORT nId = rUDEvt.GetItemId();
//STRIP001 		if( nId >= 0 && nId <= mpList->Count() )
//STRIP001 		{
//STRIP001 			OutputDevice* pDevice = rUDEvt.GetDevice();
//STRIP001 
//STRIP001 			ULONG nOldDrawMode = pDevice->GetDrawMode();
//STRIP001 		    pDevice->SetDrawMode( GetDisplayBackground().GetColor().IsDark() ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
//STRIP001 
//STRIP001 			XHatch& rXHatch = mpList->Get( rUDEvt.GetItemId() )->GetHatch();
//STRIP001 			MapMode aMode( MAP_100TH_MM );
//STRIP001 			Hatch aHatch( (HatchStyle) rXHatch.GetHatchStyle(),
//STRIP001 						  rXHatch.GetColor(),
//STRIP001 						  rUDEvt.GetDevice()->LogicToPixel( Point( rXHatch.GetDistance(), 0 ), aMode ).X(),
//STRIP001 						  rXHatch.GetAngle() );
//STRIP001 			const Polygon aPolygon( aRect );
//STRIP001 			const PolyPolygon aPolypoly( aPolygon );
//STRIP001 			pDevice->DrawHatch( aPolypoly, aHatch );
//STRIP001 
//STRIP001 			pDevice->SetLineColor( COL_BLACK );
//STRIP001 			pDevice->SetFillColor();
//STRIP001 			pDevice->DrawRect( aRect );
//STRIP001 
//STRIP001 			pDevice->SetDrawMode( nOldDrawMode );
//STRIP001 
//STRIP001 			// Draw name
//STRIP001 			pDevice->DrawText( Point( aRect.nRight+7, aRect.nTop-1 ), mpList->Get( rUDEvt.GetItemId() )->GetName() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void HatchingLB::Append( XHatchEntry* pEntry, Bitmap* pBmp )
//STRIP001 {
//STRIP001 	if( pBmp )
//STRIP001 		InsertEntry( pEntry->GetName(), *pBmp );
//STRIP001 	else
//STRIP001 		InsertEntry( pEntry->GetName() );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void HatchingLB::Modify( XHatchEntry* pEntry, USHORT nPos, Bitmap* pBmp )
//STRIP001 {
//STRIP001 	RemoveEntry( nPos );
//STRIP001 
//STRIP001 	if( pBmp )
//STRIP001 		InsertEntry( pEntry->GetName(), *pBmp, nPos );
//STRIP001 	else
//STRIP001 		InsertEntry( pEntry->GetName(), nPos );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void HatchingLB::SelectEntryByList( const XHatchList* pList, const String& rStr,
//STRIP001 									const XHatch& rHatch, USHORT nDist )
//STRIP001 {
//STRIP001 	long nCount = pList->Count();
//STRIP001 	XHatchEntry* pEntry;
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 	String aStr;
//STRIP001 
//STRIP001 	long i;
//STRIP001 	for( i = 0; i < nCount && !bFound; i++ )
//STRIP001 	{
//STRIP001 		pEntry = pList->Get( i );
//STRIP001 
//STRIP001 		aStr = pEntry->GetName();
//STRIP001 
//STRIP001 		if( rStr == aStr && rHatch == pEntry->GetHatch() )
//STRIP001 			bFound = TRUE;
//STRIP001 	}
//STRIP001 	if( bFound )
//STRIP001 		SelectEntryPos( (USHORT) ( i - 1 + nDist ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Fuellt die Listbox (vorlaeufig) mit Strings
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void FillAttrLB::Fill( const XHatchList* pList )
//STRIP001 {
//STRIP001 	long nCount = pList->Count();
//STRIP001 	XHatchEntry* pEntry;
//STRIP001 	ListBox::SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	for( long i = 0; i < nCount; i++ )
//STRIP001 	{
//STRIP001 		pEntry = pList->Get( i );
//STRIP001 		Bitmap* pBitmap = pList->GetBitmap( i );
//STRIP001 		if( pBitmap )
//STRIP001 			ListBox::InsertEntry( pEntry->GetName(), *pBitmap );
//STRIP001 		else
//STRIP001 			InsertEntry( pEntry->GetName() );
//STRIP001 	}
//STRIP001 	ListBox::SetUpdateMode( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Fuellt die Listbox (vorlaeufig) mit Strings
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 GradientLB::GradientLB( Window* pParent, ResId Id, BOOL bUserDraw /*= TRUE*/ )
//STRIP001 : ListBox( pParent, Id ),
//STRIP001   mpList(NULL),
//STRIP001   mbUserDraw( bUserDraw )
//STRIP001 {
//STRIP001 	EnableUserDraw( mbUserDraw);
//STRIP001 }
//STRIP001 
//STRIP001 GradientLB::GradientLB( Window* pParent, WinBits aWB, BOOL bUserDraw /*= TRUE*/ )
//STRIP001 : ListBox( pParent, aWB ),
//STRIP001   mpList(NULL),
//STRIP001   mbUserDraw( bUserDraw )
//STRIP001 {
//STRIP001 	EnableUserDraw( mbUserDraw );
//STRIP001 }
//STRIP001 
//STRIP001 void GradientLB::Fill( const XGradientList* pList )
//STRIP001 {
//STRIP001 	mpList = (XGradientList*)pList;
//STRIP001 	XGradientEntry* pEntry;
//STRIP001 	long nCount = pList->Count();
//STRIP001 
//STRIP001 	SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	if( mbUserDraw )
//STRIP001 	{
//STRIP001 		for( long i = 0; i < nCount; i++ )
//STRIP001 			InsertEntry( pList->Get( i )->GetName() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		for( long i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			pEntry = pList->Get( i );
//STRIP001 			Bitmap* pBitmap = pList->GetBitmap( i );
//STRIP001 			if( pBitmap )
//STRIP001 				InsertEntry( pEntry->GetName(), *pBitmap );
//STRIP001 			else
//STRIP001 				InsertEntry( pEntry->GetName() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SetUpdateMode( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 void GradientLB::UserDraw( const UserDrawEvent& rUDEvt )
//STRIP001 {
//STRIP001 	if( mpList != NULL )
//STRIP001 	{
//STRIP001 		// Draw gradient with borderrectangle
//STRIP001 		const Rectangle& rDrawRect = rUDEvt.GetRect();
//STRIP001 		Rectangle aRect( rDrawRect.nLeft+1, rDrawRect.nTop+1, rDrawRect.nLeft+33, rDrawRect.nBottom-1 );
//STRIP001 
//STRIP001 		USHORT nId = rUDEvt.GetItemId();
//STRIP001 		if( nId >= 0 && nId <= mpList->Count() )
//STRIP001 		{
//STRIP001 			OutputDevice* pDevice = rUDEvt.GetDevice();
//STRIP001 
//STRIP001 			XGradient& rXGrad = mpList->Get( rUDEvt.GetItemId() )->GetGradient();
//STRIP001 			Gradient aGradient( (GradientStyle) rXGrad.GetGradientStyle(), rXGrad.GetStartColor(), rXGrad.GetEndColor() );
//STRIP001 			aGradient.SetAngle( (USHORT)rXGrad.GetAngle() );
//STRIP001 			aGradient.SetBorder( rXGrad.GetBorder() );
//STRIP001 			aGradient.SetOfsX( rXGrad.GetXOffset() );
//STRIP001 			aGradient.SetOfsY( rXGrad.GetYOffset() );
//STRIP001 			aGradient.SetStartIntensity( rXGrad.GetStartIntens() );
//STRIP001 			aGradient.SetEndIntensity( rXGrad.GetEndIntens() );
//STRIP001 			aGradient.SetSteps( 255 );
//STRIP001 
//STRIP001 			pDevice->DrawGradient( aRect, aGradient );
//STRIP001 
//STRIP001 			pDevice->SetLineColor( COL_BLACK );
//STRIP001 			pDevice->SetFillColor();
//STRIP001 			pDevice->DrawRect( aRect );
//STRIP001 
//STRIP001 			// Draw name
//STRIP001 			pDevice->DrawText( Point( aRect.nRight+7, aRect.nTop-1 ), mpList->Get( rUDEvt.GetItemId() )->GetName() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void GradientLB::Append( XGradientEntry* pEntry, Bitmap* pBmp )
//STRIP001 {
//STRIP001 	if( pBmp )
//STRIP001 		InsertEntry( pEntry->GetName(), *pBmp );
//STRIP001 	else
//STRIP001 		InsertEntry( pEntry->GetName() );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void GradientLB::Modify( XGradientEntry* pEntry, USHORT nPos, Bitmap* pBmp )
//STRIP001 {
//STRIP001 	RemoveEntry( nPos );
//STRIP001 
//STRIP001 	if( pBmp )
//STRIP001 		InsertEntry( pEntry->GetName(), *pBmp, nPos );
//STRIP001 	else
//STRIP001 		InsertEntry( pEntry->GetName(), nPos );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void GradientLB::SelectEntryByList( const XGradientList* pList, const String& rStr,
//STRIP001 								const XGradient& rGradient, USHORT nDist )
//STRIP001 {
//STRIP001 	long nCount = pList->Count();
//STRIP001 	XGradientEntry* pEntry;
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 	String aStr;
//STRIP001 
//STRIP001 	long i;
//STRIP001 	for( i = 0; i < nCount && !bFound; i++ )
//STRIP001 	{
//STRIP001 		pEntry = pList->Get( i );
//STRIP001 
//STRIP001 		aStr = pEntry->GetName();
//STRIP001 
//STRIP001 		if( rStr == aStr && rGradient == pEntry->GetGradient() )
//STRIP001 			bFound = TRUE;
//STRIP001 	}
//STRIP001 	if( bFound )
//STRIP001 		SelectEntryPos( (USHORT) ( i - 1 + nDist ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Fuellt die Listbox (vorlaeufig) mit Strings
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void FillAttrLB::Fill( const XGradientList* pList )
//STRIP001 {
//STRIP001 	long nCount = pList->Count();
//STRIP001 	XGradientEntry* pEntry;
//STRIP001 	ListBox::SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	for( long i = 0; i < nCount; i++ )
//STRIP001 	{
//STRIP001 		pEntry = pList->Get( i );
//STRIP001 		Bitmap* pBitmap = pList->GetBitmap( i );
//STRIP001 		if( pBitmap )
//STRIP001 			ListBox::InsertEntry( pEntry->GetName(), *pBitmap );
//STRIP001 		else
//STRIP001 			InsertEntry( pEntry->GetName() );
//STRIP001 	}
//STRIP001 	ListBox::SetUpdateMode( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Konstruktor von BitmapLB
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BitmapLB::BitmapLB( Window* pParent, ResId Id, BOOL bUserDraw /*= TRUE*/ )
//STRIP001 : ListBox( pParent, Id ),
//STRIP001   mpList( NULL ),
//STRIP001   mbUserDraw( bUserDraw )
//STRIP001 {
//STRIP001 	aVD.SetOutputSizePixel( Size( 32, 16 ) );
//STRIP001 	EnableUserDraw( mbUserDraw );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void BitmapLB::SetVirtualDevice()
//STRIP001 {
//STRIP001 	if( aBitmap.GetSizePixel().Width() > 8 ||
//STRIP001 		aBitmap.GetSizePixel().Height() > 8 )
//STRIP001 	{
//STRIP001 		aVD.DrawBitmap( Point( 0, 0 ), Size( 32, 16 ), aBitmap );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aVD.DrawBitmap( Point( 0, 0 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 8, 0 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 16, 0 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 24, 0 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 0, 8 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 8, 8 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 16, 8 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 24, 8 ), aBitmap );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void BitmapLB::Fill( const XBitmapList* pList )
//STRIP001 {
//STRIP001 	mpList = (XBitmapList*)pList;
//STRIP001 	XBitmapEntry* pEntry;
//STRIP001 	long nCount = pList->Count();
//STRIP001 
//STRIP001 	SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	if( mbUserDraw )
//STRIP001 	{
//STRIP001 		for( long i = 0; i < nCount; i++ )
//STRIP001 			InsertEntry( pList->Get( i )->GetName() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		for( long i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			pEntry = pList->Get( i );
//STRIP001 			aBitmap = pEntry->GetXBitmap().GetBitmap();
//STRIP001 
//STRIP001 			SetVirtualDevice();
//STRIP001 
//STRIP001 			InsertEntry( pEntry->GetName(), aVD.GetBitmap( Point( 0, 2 ), Size( 32, 12 ) ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SetUpdateMode( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 void BitmapLB::UserDraw( const UserDrawEvent& rUDEvt )
//STRIP001 {
//STRIP001 	if( mpList != NULL )
//STRIP001 	{
//STRIP001 		// Draw bitmap
//STRIP001 		const Rectangle& rDrawRect = rUDEvt.GetRect();
//STRIP001 		Rectangle aRect( rDrawRect.nLeft+1, rDrawRect.nTop+1, rDrawRect.nLeft+33, rDrawRect.nBottom-1 );
//STRIP001 
//STRIP001 		USHORT nId = rUDEvt.GetItemId();
//STRIP001 		if( nId >= 0 && nId <= mpList->Count() )
//STRIP001 		{
//STRIP001 			Rectangle aClipRect( rDrawRect.nLeft+1, rDrawRect.nTop+1, rDrawRect.nRight-1, rDrawRect.nBottom-1 );
//STRIP001 
//STRIP001 			OutputDevice* pDevice = rUDEvt.GetDevice();
//STRIP001 			pDevice->SetClipRegion( Region( aClipRect ) );
//STRIP001 
//STRIP001 			aBitmap = mpList->Get( nId )->GetXBitmap().GetBitmap();
//STRIP001 
//STRIP001 			long nPosBaseX = aRect.nLeft;
//STRIP001 			long nPosBaseY = aRect.nTop;
//STRIP001 
//STRIP001 			if( aBitmap.GetSizePixel().Width() > 8 ||
//STRIP001 				aBitmap.GetSizePixel().Height() > 8 )
//STRIP001 			{
//STRIP001 				pDevice->DrawBitmap( Point( nPosBaseX, nPosBaseY ), Size( 32, 16 ), aBitmap );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pDevice->DrawBitmap( Point( nPosBaseX+ 0, nPosBaseY+0 ), aBitmap );
//STRIP001 				pDevice->DrawBitmap( Point( nPosBaseX+ 8, nPosBaseY+0 ), aBitmap );
//STRIP001 				pDevice->DrawBitmap( Point( nPosBaseX+16, nPosBaseY+0 ), aBitmap );
//STRIP001 				pDevice->DrawBitmap( Point( nPosBaseX+24, nPosBaseY+0 ), aBitmap );
//STRIP001 				pDevice->DrawBitmap( Point( nPosBaseX+ 0, nPosBaseY+8 ), aBitmap );
//STRIP001 				pDevice->DrawBitmap( Point( nPosBaseX+ 8, nPosBaseY+8 ), aBitmap );
//STRIP001 				pDevice->DrawBitmap( Point( nPosBaseX+16, nPosBaseY+8 ), aBitmap );
//STRIP001 				pDevice->DrawBitmap( Point( nPosBaseX+24, nPosBaseY+8 ), aBitmap );
//STRIP001 			}
//STRIP001 
//STRIP001 			pDevice->SetClipRegion();
//STRIP001 
//STRIP001 			// Draw name
//STRIP001 			pDevice->DrawText( Point( aRect.nRight+7, aRect.nTop-1 ), mpList->Get( nId )->GetName() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void BitmapLB::Append( XBitmapEntry* pEntry, Bitmap* pBmp )
//STRIP001 {
//STRIP001 	if( pBmp )
//STRIP001 	{
//STRIP001 		aBitmap = pEntry->GetXBitmap().GetBitmap();
//STRIP001 		SetVirtualDevice();
//STRIP001 		InsertEntry( pEntry->GetName(), aVD.GetBitmap( Point( 0, 2 ), Size( 32, 12 ) ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		InsertEntry( pEntry->GetName() );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void BitmapLB::Modify( XBitmapEntry* pEntry, USHORT nPos, Bitmap* pBmp )
//STRIP001 {
//STRIP001 	RemoveEntry( nPos );
//STRIP001 
//STRIP001 	if( pBmp )
//STRIP001 	{
//STRIP001 		aBitmap = pEntry->GetXBitmap().GetBitmap();
//STRIP001 		SetVirtualDevice();
//STRIP001 
//STRIP001 		InsertEntry( pEntry->GetName(), aVD.GetBitmap( Point( 0, 2 ), Size( 32, 12 ) ), nPos );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		InsertEntry( pEntry->GetName() );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void BitmapLB::SelectEntryByList( const XBitmapList* pList, const String& rStr,
//STRIP001 							const Bitmap& rBmp)
//STRIP001 {
//STRIP001 	long nCount = pList->Count();
//STRIP001 	XBitmapEntry* pEntry;
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 
//STRIP001 	long i;
//STRIP001 	for( i = 0; i < nCount && !bFound; i++ )
//STRIP001 	{
//STRIP001 		pEntry = pList->Get( i );
//STRIP001 
//STRIP001 		String aStr = pEntry->GetName();
//STRIP001 		// Bitmap aBmp = pEntry->GetBitmap();
//STRIP001 
//STRIP001 		if( rStr == aStr )
//STRIP001 		{
//STRIP001 			bFound = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( bFound )
//STRIP001 		SelectEntryPos( (USHORT) ( i - 1 ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Konstruktor von FillAttrLB
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 FillAttrLB::FillAttrLB( Window* pParent, ResId Id ) :
//STRIP001 					ColorListBox( pParent, Id )
//STRIP001 {
//STRIP001 	aVD.SetOutputSizePixel( Size( 32, 16 ) );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 FillAttrLB::FillAttrLB( Window* pParent, WinBits aWB ) :
//STRIP001 					ColorListBox( pParent, aWB )
//STRIP001 {
//STRIP001 	aVD.SetOutputSizePixel( Size( 32, 16 ) );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void FillAttrLB::SetVirtualDevice()
//STRIP001 {
//STRIP001 	if( aBitmap.GetSizePixel().Width() > 8 ||
//STRIP001 		aBitmap.GetSizePixel().Height() > 8 )
//STRIP001 	{
//STRIP001 		aVD.DrawBitmap( Point( 0, 0 ), Size( 32, 16 ), aBitmap );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aVD.DrawBitmap( Point( 0, 0 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 8, 0 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 16, 0 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 24, 0 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 0, 8 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 8, 8 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 16, 8 ), aBitmap );
//STRIP001 		aVD.DrawBitmap( Point( 24, 8 ), aBitmap );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void FillAttrLB::Fill( const XBitmapList* pList )
//STRIP001 {
//STRIP001 	long nCount = pList->Count();
//STRIP001 	XBitmapEntry* pEntry;
//STRIP001 	ListBox::SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	for( long i = 0; i < nCount; i++ )
//STRIP001 	{
//STRIP001 		pEntry = pList->Get( i );
//STRIP001 		aBitmap = pEntry->GetXBitmap().GetBitmap();
//STRIP001 
//STRIP001 		SetVirtualDevice();
//STRIP001 
//STRIP001 		ListBox::InsertEntry( pEntry->GetName(), aVD.GetBitmap( Point( 0, 2 ), Size( 32, 12 ) ) );
//STRIP001 	}
//STRIP001 	ListBox::SetUpdateMode( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void FillAttrLB::SelectEntryByList( const XBitmapList* pList, const String& rStr,
//STRIP001 							const Bitmap& rBmp)
//STRIP001 {
//STRIP001 	long nCount = pList->Count();
//STRIP001 	XBitmapEntry* pEntry;
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 
//STRIP001 	long i;
//STRIP001 	for( i = 0; i < nCount && !bFound; i++ )
//STRIP001 	{
//STRIP001 		pEntry = pList->Get( i );
//STRIP001 
//STRIP001 		String aStr = pEntry->GetName();
//STRIP001 		// Bitmap aBmp = pEntry->GetBitmap();
//STRIP001 
//STRIP001 		if( rStr == aStr )
//STRIP001 		{
//STRIP001 			bFound = TRUE;
//STRIP001 		}
//STRIP001 		/*
//STRIP001 		if( rStr == aStr && rBmp == aBmp )
//STRIP001 			bFound = TRUE; */
//STRIP001 	}
//STRIP001 	if( bFound )
//STRIP001 		SelectEntryPos( (USHORT) ( i - 1 ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Fuellt die Listbox (vorlaeufig) mit Strings
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void FillTypeLB::Fill()
//STRIP001 {
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	SetUpdateMode( FALSE );
//STRIP001 	InsertEntry( String( ResId( RID_SVXSTR_INVISIBLE, pMgr ) ) );
//STRIP001 	InsertEntry( String( ResId( RID_SVXSTR_COLOR, pMgr ) ) );
//STRIP001 	InsertEntry( String( ResId( RID_SVXSTR_GRADIENT, pMgr ) ) );
//STRIP001 	InsertEntry( String( ResId( RID_SVXSTR_HATCH, pMgr ) ) );
//STRIP001 	InsertEntry( String( ResId( RID_SVXSTR_BITMAP, pMgr ) ) );
//STRIP001 	SetUpdateMode( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Fuellt die Listbox (vorlaeufig) mit Strings
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void LineLB::Fill( const XDashList* pList )
//STRIP001 {
//STRIP001 	long nCount = pList->Count();
//STRIP001 	XDashEntry* pEntry;
//STRIP001 	SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	for( long i = 0; i < nCount; i++ )
//STRIP001 	{
//STRIP001 		pEntry = pList->Get( i );
//STRIP001 		Bitmap* pBitmap = const_cast<XDashList*>(pList)->CreateBitmapForUI( i );
//STRIP001 		if( pBitmap )
//STRIP001 		{
//STRIP001 			InsertEntry( pEntry->GetName(), *pBitmap );
//STRIP001 			delete pBitmap;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			InsertEntry( pEntry->GetName() );
//STRIP001 	}
//STRIP001 	SetUpdateMode( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void LineLB::Append( XDashEntry* pEntry, Bitmap* pBmp )
//STRIP001 {
//STRIP001 	if( pBmp )
//STRIP001 		InsertEntry( pEntry->GetName(), *pBmp );
//STRIP001 	else
//STRIP001 		InsertEntry( pEntry->GetName() );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void LineLB::Modify( XDashEntry* pEntry, USHORT nPos, Bitmap* pBmp )
//STRIP001 {
//STRIP001 	RemoveEntry( nPos );
//STRIP001 
//STRIP001 	if( pBmp )
//STRIP001 		InsertEntry( pEntry->GetName(), *pBmp, nPos );
//STRIP001 	else
//STRIP001 		InsertEntry( pEntry->GetName(), nPos );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void LineLB::SelectEntryByList( const XDashList* pList, const String& rStr,
//STRIP001 								const XDash& rDash, USHORT nDist )
//STRIP001 {
//STRIP001 	long nCount = pList->Count();
//STRIP001 	XDashEntry* pEntry;
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 	String aStr;
//STRIP001 	XDash aDash;
//STRIP001 
//STRIP001 	long i;
//STRIP001 	for( i = 0; i < nCount && !bFound; i++ )
//STRIP001 	{
//STRIP001 		pEntry = pList->Get( i );
//STRIP001 
//STRIP001 		aStr = pEntry->GetName();
//STRIP001 		aDash = pEntry->GetDash();
//STRIP001 
//STRIP001 		if( rStr == aStr && rDash == aDash )
//STRIP001 			bFound = TRUE;
//STRIP001 	}
//STRIP001 	if( bFound )
//STRIP001 		SelectEntryPos( (USHORT) ( i - 1 + nDist ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Fuellt die Listbox (vorlaeufig) mit Strings
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void LineEndLB::Fill( const XLineEndList* pList, BOOL bStart )
//STRIP001 {
//STRIP001 	long nCount = pList->Count();
//STRIP001 	XLineEndEntry* pEntry;
//STRIP001 	VirtualDevice aVD;
//STRIP001 	SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	for( long i = 0; i < nCount; i++ )
//STRIP001 	{
//STRIP001 		pEntry = pList->Get( i );
//STRIP001 		Bitmap* pBitmap = const_cast<XLineEndList*>(pList)->CreateBitmapForUI( i );
//STRIP001 		if( pBitmap )
//STRIP001 		{
//STRIP001 			Size aBmpSize( pBitmap->GetSizePixel() );
//STRIP001 			aVD.SetOutputSizePixel( aBmpSize, FALSE );
//STRIP001 			aVD.DrawBitmap( Point(), *pBitmap );
//STRIP001 			InsertEntry( pEntry->GetName(),
//STRIP001 				aVD.GetBitmap( bStart ? Point() : Point( aBmpSize.Width() / 2, 0 ),
//STRIP001 					Size( aBmpSize.Width() / 2, aBmpSize.Height() ) ) );
//STRIP001 
//STRIP001 			delete pBitmap;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			InsertEntry( pEntry->GetName() );
//STRIP001 	}
//STRIP001 	SetUpdateMode( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void LineEndLB::Append( XLineEndEntry* pEntry, Bitmap* pBmp,
//STRIP001 						BOOL bStart )
//STRIP001 {
//STRIP001 	if( pBmp )
//STRIP001 	{
//STRIP001 		VirtualDevice aVD;
//STRIP001 		Size aBmpSize( pBmp->GetSizePixel() );
//STRIP001 
//STRIP001 		aVD.SetOutputSizePixel( aBmpSize, FALSE );
//STRIP001 		aVD.DrawBitmap( Point(), *pBmp );
//STRIP001 		InsertEntry( pEntry->GetName(),
//STRIP001 			aVD.GetBitmap( bStart ? Point() : Point( aBmpSize.Width() / 2, 0 ),
//STRIP001 				Size( aBmpSize.Width() / 2, aBmpSize.Height() ) ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		InsertEntry( pEntry->GetName() );
//STRIP001 }
//STRIP001 
//STRIP001 /************************************************************************/
//STRIP001 
//STRIP001 void LineEndLB::Modify( XLineEndEntry* pEntry, USHORT nPos, Bitmap* pBmp,
//STRIP001 						BOOL bStart )
//STRIP001 {
//STRIP001 	RemoveEntry( nPos );
//STRIP001 
//STRIP001 	if( pBmp )
//STRIP001 	{
//STRIP001 		VirtualDevice aVD;
//STRIP001 		Size aBmpSize( pBmp->GetSizePixel() );
//STRIP001 
//STRIP001 		aVD.SetOutputSizePixel( aBmpSize, FALSE );
//STRIP001 		aVD.DrawBitmap( Point(), *pBmp );
//STRIP001 		InsertEntry( pEntry->GetName(),
//STRIP001 			aVD.GetBitmap( bStart ? Point() : Point( aBmpSize.Width() / 2, 0 ),
//STRIP001 				Size( aBmpSize.Width() / 2, aBmpSize.Height() ) ), nPos );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		InsertEntry( pEntry->GetName(), nPos );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*    SvxXLinePreview::SvxXLinePreview()
//STRIP001 |*
//STRIP001 *************************************************************************/
//STRIP001 
//STRIP001 SvxXLinePreview::SvxXLinePreview( Window* pParent, const ResId& rResId, XOutputDevice* pXOut ) :
//STRIP001 
//STRIP001 	Control	( pParent, rResId ),
//STRIP001 
//STRIP001 	pXOutDev	( pXOut ),
//STRIP001 	bWithSymbol	( FALSE ),
//STRIP001 	pGraphic	( NULL )
//STRIP001 
//STRIP001 {
//STRIP001 	SetMapMode( MAP_100TH_MM );
//STRIP001 	Size aSize = GetOutputSize();
//STRIP001 	aPtA = Point( 500, aSize.Height() / 2 );
//STRIP001 	aPtB = Point( aSize.Width() - 500, aSize.Height() / 2 );
//STRIP001 	InitSettings( TRUE, TRUE );
//STRIP001 
//STRIP001     //	Draw the control's border as a flat thin black line.
//STRIP001 	SetBorderStyle (WINDOW_BORDER_MONO);
//STRIP001 
//STRIP001     SetDrawMode( GetDisplayBackground().GetColor().IsDark() ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXLinePreview::InitSettings( BOOL bForeground, BOOL bBackground )
//STRIP001 {
//STRIP001 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 
//STRIP001 	if ( bForeground )
//STRIP001 	{
//STRIP001 		svtools::ColorConfig aColorConfig;
//STRIP001 		Color aTextColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001 
//STRIP001 		if ( IsControlForeground() )
//STRIP001 			aTextColor = GetControlForeground();
//STRIP001 		SetTextColor( aTextColor );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bBackground )
//STRIP001 	{
//STRIP001 		if ( IsControlBackground() )
//STRIP001 			SetBackground( GetControlBackground() );
//STRIP001 		else
//STRIP001 			SetBackground( rStyleSettings.GetWindowColor() );
//STRIP001 	}
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXLinePreview::SetSymbol(Graphic* p,const Size& s)
//STRIP001 {
//STRIP001 	pGraphic = p;
//STRIP001 	aSymbolSize = s;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXLinePreview::ResizeSymbol(const Size& s)
//STRIP001 {
//STRIP001 	if ( s != aSymbolSize )
//STRIP001 	{
//STRIP001 		aSymbolSize = s;
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXLinePreview::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	pXOutDev->DrawLine( aPtA, aPtB );
//STRIP001 	if ( bWithSymbol && pGraphic )
//STRIP001 	{
//STRIP001 		Point aPos = Point( GetOutputSize().Width() / 2, GetOutputSize().Height() / 2 );
//STRIP001 		aPos.X() -= aSymbolSize.Width() / 2;
//STRIP001 		aPos.Y() -= aSymbolSize.Height() / 2;
//STRIP001 		pGraphic->Draw( this, aPos, aSymbolSize );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXLinePreview::StateChanged( StateChangedType nType )
//STRIP001 {
//STRIP001 	if ( nType == STATE_CHANGE_CONTROLFOREGROUND )
//STRIP001 		InitSettings( TRUE, FALSE );
//STRIP001 	else if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
//STRIP001 		InitSettings( FALSE, TRUE );
//STRIP001 
//STRIP001 	Control::StateChanged( nType );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXLinePreview::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 		InitSettings( TRUE, TRUE );
//STRIP001 	else
//STRIP001 		Control::DataChanged( rDCEvt );
//STRIP001 
//STRIP001    SetDrawMode( GetDisplayBackground().GetColor().IsDark() ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*    SvxXRectPreview::SvxXRectPreview()
//STRIP001 |*
//STRIP001 *************************************************************************/
//STRIP001 
//STRIP001 SvxXRectPreview::SvxXRectPreview( Window* pParent, const ResId& rResId, XOutputDevice* pXOut ) :
//STRIP001 
//STRIP001 	Control	( pParent, rResId ),
//STRIP001 
//STRIP001 	pXOutDev( pXOut )
//STRIP001 
//STRIP001 {
//STRIP001     SetBorderStyle( WINDOW_BORDER_MONO );
//STRIP001     SetMapMode( MAP_100TH_MM );
//STRIP001     aRect = Rectangle( Point(), GetOutputSize() );
//STRIP001 	InitSettings( TRUE, TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXRectPreview::InitSettings( BOOL bForeground, BOOL bBackground )
//STRIP001 {
//STRIP001 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 
//STRIP001 	if ( bForeground )
//STRIP001 	{
//STRIP001 		svtools::ColorConfig aColorConfig;
//STRIP001 		Color aTextColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001 
//STRIP001 		if ( IsControlForeground() )
//STRIP001 			aTextColor = GetControlForeground();
//STRIP001 		SetTextColor( aTextColor );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bBackground )
//STRIP001 	{
//STRIP001 		if ( IsControlBackground() )
//STRIP001 			SetBackground( GetControlBackground() );
//STRIP001 		else
//STRIP001 			SetBackground( rStyleSettings.GetWindowColor() );
//STRIP001 	}
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXRectPreview::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001     pXOutDev->SetLineColor( Color( COL_TRANSPARENT ) );
//STRIP001 	pXOutDev->DrawRect( aRect );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXRectPreview::StateChanged( StateChangedType nType )
//STRIP001 {
//STRIP001 	if ( nType == STATE_CHANGE_CONTROLFOREGROUND )
//STRIP001 		InitSettings( TRUE, FALSE );
//STRIP001 	else if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
//STRIP001 		InitSettings( FALSE, TRUE );
//STRIP001 
//STRIP001 	Control::StateChanged( nType );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXRectPreview::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 		InitSettings( TRUE, TRUE );
//STRIP001 	else
//STRIP001 		Control::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*    SvxXShadowPreview::SvxXShadowPreview()
//STRIP001 |*
//STRIP001 *************************************************************************/
//STRIP001 
//STRIP001 SvxXShadowPreview::SvxXShadowPreview( Window* pParent, const ResId& rResId,
//STRIP001 									  XOutputDevice* pXOut, XOutdevItemPool* pXInPool ) :
//STRIP001 
//STRIP001 	Control		( pParent, rResId ),
//STRIP001 
//STRIP001 	pXOutDev	( pXOut ),
//STRIP001 	pXPool		( pXInPool ),
//STRIP001 	pRectItem	( NULL ),
//STRIP001 	pShadowItem ( NULL )
//STRIP001 
//STRIP001 {
//STRIP001 	SetMapMode( MAP_100TH_MM );
//STRIP001 	Size aSize = GetOutputSize();
//STRIP001 	aSize.Width() = aSize.Width() / 3;
//STRIP001 	aSize.Height() = aSize.Height() / 3;
//STRIP001 	aRect = Rectangle( Point( aSize.Width(), aSize.Height() ), aSize );
//STRIP001 	aShadow = Rectangle( Point( aSize.Width(), aSize.Height() ), aSize );
//STRIP001 	InitSettings( TRUE, TRUE );
//STRIP001 
//STRIP001     //	Draw the control's border as a flat thin black line.
//STRIP001 	SetBorderStyle (WINDOW_BORDER_MONO);
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxXShadowPreview::~SvxXShadowPreview()
//STRIP001 {
//STRIP001 	delete pRectItem;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXShadowPreview::InitSettings( BOOL bForeground, BOOL bBackground )
//STRIP001 {
//STRIP001 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 
//STRIP001 	if ( bForeground )
//STRIP001 	{
//STRIP001 		svtools::ColorConfig aColorConfig;
//STRIP001 		Color aTextColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001 
//STRIP001 		if ( IsControlForeground() )
//STRIP001 			aTextColor = GetControlForeground();
//STRIP001 		SetTextColor( aTextColor );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bBackground )
//STRIP001 	{
//STRIP001 		if ( IsControlBackground() )
//STRIP001 			SetBackground( GetControlBackground() );
//STRIP001 		else
//STRIP001 			SetBackground( rStyleSettings.GetWindowColor() );
//STRIP001 	}
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXShadowPreview::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001     aShadow.SetPos( aShadowPos + Point( aRect.GetWidth(), aRect.GetHeight() ) );
//STRIP001 	if ( pShadowItem )
//STRIP001 		pXOutDev->SetFillAttr( pShadowItem->GetItemSet() );
//STRIP001 	pXOutDev->DrawRect( aShadow );
//STRIP001 	if ( pRectItem )
//STRIP001 		pXOutDev->SetFillAttr( pRectItem->GetItemSet() );
//STRIP001 	pXOutDev->DrawRect( aRect );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXShadowPreview::SetRectAttr( XFillAttrSetItem* pSetItem )
//STRIP001 {
//STRIP001 	if( pRectItem )
//STRIP001 		delete pRectItem;
//STRIP001 	pRectItem = (XFillAttrSetItem*) pSetItem->Clone( pXPool );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXShadowPreview::SetShadowAttr( XFillAttrSetItem* pSetItem )
//STRIP001 {
//STRIP001 	pShadowItem = pSetItem;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXShadowPreview::StateChanged( StateChangedType nType )
//STRIP001 {
//STRIP001 	if ( nType == STATE_CHANGE_CONTROLFOREGROUND )
//STRIP001 		InitSettings( TRUE, FALSE );
//STRIP001 	else if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
//STRIP001 		InitSettings( FALSE, TRUE );
//STRIP001 
//STRIP001 	Control::StateChanged( nType );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxXShadowPreview::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 		InitSettings( TRUE, TRUE );
//STRIP001 	else
//STRIP001 		Control::DataChanged( rDCEvt );
//STRIP001 }


}
